/*
 * Copyright (c) 2003, 2007-14 Matteo Frigo
 * Copyright (c) 2003, 2007-14 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Tue Sep 14 10:46:37 EDT 2021 */

#include "rdft/codelet-rdft.h"

#if defined(ARCH_PREFERS_FMA) || defined(ISA_EXTENSION_PREFERS_FMA)

/* Generated by: ../../../genfft/gen_hc2cdft.native -fma -compact -variables 4 -pipeline-latency 4 -n 32 -dit -name hc2cfdft_32 -include rdft/scalar/hc2cf.h */

/*
 * This function contains 498 FP additions, 324 FP multiplications,
 * (or, 300 additions, 126 multiplications, 198 fused multiply/add),
 * 113 stack variables, 8 constants, and 128 memory accesses
 */
#include "rdft/scalar/hc2cf.h"

static void hc2cfdft_32(R *Rp, R *Ip, R *Rm, R *Im, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP198912367, +0.198912367379658006911597622644676228597850501);
     DK(KP668178637, +0.668178637919298919997757686523080761552472251);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP414213562, +0.414213562373095048801688724209698078569671875);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     DK(KP500000000, +0.500000000000000000000000000000000000000000000);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 62); m < me; m = m + 1, Rp = Rp + ms, Ip = Ip + ms, Rm = Rm - ms, Im = Im - ms, W = W + 62, MAKE_VOLATILE_STRIDE(128, rs)) {
	       E T3B, T89, T61, T8l, T2F, T8t, T4B, T7p, T1n, T7L, T5e, T7I, T4u, T82, T5E;
	       E T7R, T3m, T8k, T5W, T8a, T2r, T8u, T4G, T7q, T12, T7K, T59, T7H, T4h, T81;
	       E T5z, T7Q, Tl, T7D, T4Y, T7A, T3Q, T5o, T7V, T84, T1K, T7t, T4M, T7s, T2V;
	       E T8n, T5L, T8e, T25, T7w, T4R, T7v, T38, T8o, T5Q, T8h, TG, T7E, T53, T7B;
	       E T43, T5t, T7Y, T85;
	       {
		    E T2E, T3z, T4y, T3y, T5Z, T3t, T3x, T2v, T2A, T3r, T3q, T5X, T3n, T3p, T2w;
		    E T4z, T3s, T3A;
		    {
			 E T2C, T2D, T3u, T3v, T3w;
			 T2C = Ip[0];
			 T2D = Im[0];
			 T2E = T2C - T2D;
			 T3z = T2C + T2D;
			 T3u = Rm[0];
			 T3v = Rp[0];
			 T3w = T3u - T3v;
			 T4y = T3v + T3u;
			 T3y = W[1];
			 T5Z = T3y * T3w;
			 T3t = W[0];
			 T3x = T3t * T3w;
			 {
			      E T2t, T2u, T3o, T2y, T2z, T2s;
			      T2t = Ip[WS(rs, 8)];
			      T2u = Im[WS(rs, 8)];
			      T2v = T2t - T2u;
			      T2y = Rp[WS(rs, 8)];
			      T2z = Rm[WS(rs, 8)];
			      T2A = T2y + T2z;
			      T3o = T2z - T2y;
			      T3r = T2t + T2u;
			      T3q = W[33];
			      T5X = T3q * T3o;
			      T3n = W[32];
			      T3p = T3n * T3o;
			      T2s = W[30];
			      T2w = T2s * T2v;
			      T4z = T2s * T2A;
			 }
		    }
		    T3s = FNMS(T3q, T3r, T3p);
		    T3A = FNMS(T3y, T3z, T3x);
		    T3B = T3s + T3A;
		    T89 = T3A - T3s;
		    {
			 E T5Y, T60, T2B, T4A, T2x;
			 T5Y = FMA(T3n, T3r, T5X);
			 T60 = FMA(T3t, T3z, T5Z);
			 T61 = T5Y + T60;
			 T8l = T60 - T5Y;
			 T2x = W[31];
			 T2B = FNMS(T2x, T2A, T2w);
			 T4A = FMA(T2x, T2v, T4z);
			 T2F = T2B + T2E;
			 T8t = T4y - T4A;
			 T4B = T4y + T4A;
			 T7p = T2E - T2B;
		    }
	       }
	       {
		    E T16, T4m, T1b, T4j, T17, T5a, T4k, T5A, T1g, T4s, T1l, T4p, T1h, T5c, T4q;
		    E T5C;
		    {
			 E T13, T4i, T1d, T4o;
			 {
			      E T14, T15, T19, T1a;
			      T14 = Ip[WS(rs, 3)];
			      T15 = Im[WS(rs, 3)];
			      T16 = T14 - T15;
			      T4m = T14 + T15;
			      T19 = Rp[WS(rs, 3)];
			      T1a = Rm[WS(rs, 3)];
			      T1b = T19 + T1a;
			      T4j = T19 - T1a;
			 }
			 T13 = W[10];
			 T17 = T13 * T16;
			 T5a = T13 * T1b;
			 T4i = W[12];
			 T4k = T4i * T4j;
			 T5A = T4i * T4m;
			 {
			      E T1e, T1f, T1j, T1k;
			      T1e = Ip[WS(rs, 11)];
			      T1f = Im[WS(rs, 11)];
			      T1g = T1e - T1f;
			      T4s = T1e + T1f;
			      T1j = Rp[WS(rs, 11)];
			      T1k = Rm[WS(rs, 11)];
			      T1l = T1j + T1k;
			      T4p = T1j - T1k;
			 }
			 T1d = W[42];
			 T1h = T1d * T1g;
			 T5c = T1d * T1l;
			 T4o = W[44];
			 T4q = T4o * T4p;
			 T5C = T4o * T4s;
		    }
		    {
			 E T1c, T5b, T1m, T5d, T18, T1i;
			 T18 = W[11];
			 T1c = FNMS(T18, T1b, T17);
			 T5b = FMA(T18, T16, T5a);
			 T1i = W[43];
			 T1m = FNMS(T1i, T1l, T1h);
			 T5d = FMA(T1i, T1g, T5c);
			 T1n = T1c + T1m;
			 T7L = T1c - T1m;
			 T5e = T5b + T5d;
			 T7I = T5b - T5d;
		    }
		    {
			 E T4n, T5B, T4t, T5D, T4l, T4r;
			 T4l = W[13];
			 T4n = FMA(T4l, T4m, T4k);
			 T5B = FNMS(T4l, T4j, T5A);
			 T4r = W[45];
			 T4t = FMA(T4r, T4s, T4q);
			 T5D = FNMS(T4r, T4p, T5C);
			 T4u = T4n + T4t;
			 T82 = T4t - T4n;
			 T5E = T5B + T5D;
			 T7R = T5D - T5B;
		    }
	       }
	       {
		    E T2a, T2f, T3e, T3d, T5S, T3a, T3c, T2b, T4C, T2k, T2p, T3k, T3j, T5U, T3g;
		    E T3i, T2l, T4E;
		    {
			 E T28, T29, T3b, T2d, T2e, T27;
			 T28 = Ip[WS(rs, 4)];
			 T29 = Im[WS(rs, 4)];
			 T2a = T28 - T29;
			 T2d = Rp[WS(rs, 4)];
			 T2e = Rm[WS(rs, 4)];
			 T2f = T2d + T2e;
			 T3b = T2e - T2d;
			 T3e = T28 + T29;
			 T3d = W[17];
			 T5S = T3d * T3b;
			 T3a = W[16];
			 T3c = T3a * T3b;
			 T27 = W[14];
			 T2b = T27 * T2a;
			 T4C = T27 * T2f;
		    }
		    {
			 E T2i, T2j, T3h, T2n, T2o, T2h;
			 T2i = Ip[WS(rs, 12)];
			 T2j = Im[WS(rs, 12)];
			 T2k = T2i - T2j;
			 T2n = Rp[WS(rs, 12)];
			 T2o = Rm[WS(rs, 12)];
			 T2p = T2n + T2o;
			 T3h = T2o - T2n;
			 T3k = T2i + T2j;
			 T3j = W[49];
			 T5U = T3j * T3h;
			 T3g = W[48];
			 T3i = T3g * T3h;
			 T2h = W[46];
			 T2l = T2h * T2k;
			 T4E = T2h * T2p;
		    }
		    {
			 E T3f, T3l, T5T, T5V;
			 T3f = FNMS(T3d, T3e, T3c);
			 T3l = FNMS(T3j, T3k, T3i);
			 T3m = T3f + T3l;
			 T8k = T3f - T3l;
			 T5T = FMA(T3a, T3e, T5S);
			 T5V = FMA(T3g, T3k, T5U);
			 T5W = T5T + T5V;
			 T8a = T5T - T5V;
			 {
			      E T2g, T4D, T2q, T4F, T2c, T2m;
			      T2c = W[15];
			      T2g = FNMS(T2c, T2f, T2b);
			      T4D = FMA(T2c, T2a, T4C);
			      T2m = W[47];
			      T2q = FNMS(T2m, T2p, T2l);
			      T4F = FMA(T2m, T2k, T4E);
			      T2r = T2g + T2q;
			      T8u = T2g - T2q;
			      T4G = T4D + T4F;
			      T7q = T4D - T4F;
			 }
		    }
	       }
	       {
		    E TL, T49, TQ, T46, TM, T55, T47, T5v, TV, T4f, T10, T4c, TW, T57, T4d;
		    E T5x;
		    {
			 E TI, T45, TS, T4b;
			 {
			      E TJ, TK, TO, TP;
			      TJ = Ip[WS(rs, 15)];
			      TK = Im[WS(rs, 15)];
			      TL = TJ - TK;
			      T49 = TJ + TK;
			      TO = Rp[WS(rs, 15)];
			      TP = Rm[WS(rs, 15)];
			      TQ = TO + TP;
			      T46 = TO - TP;
			 }
			 TI = W[58];
			 TM = TI * TL;
			 T55 = TI * TQ;
			 T45 = W[60];
			 T47 = T45 * T46;
			 T5v = T45 * T49;
			 {
			      E TT, TU, TY, TZ;
			      TT = Ip[WS(rs, 7)];
			      TU = Im[WS(rs, 7)];
			      TV = TT - TU;
			      T4f = TT + TU;
			      TY = Rp[WS(rs, 7)];
			      TZ = Rm[WS(rs, 7)];
			      T10 = TY + TZ;
			      T4c = TY - TZ;
			 }
			 TS = W[26];
			 TW = TS * TV;
			 T57 = TS * T10;
			 T4b = W[28];
			 T4d = T4b * T4c;
			 T5x = T4b * T4f;
		    }
		    {
			 E TR, T56, T11, T58, TN, TX;
			 TN = W[59];
			 TR = FNMS(TN, TQ, TM);
			 T56 = FMA(TN, TL, T55);
			 TX = W[27];
			 T11 = FNMS(TX, T10, TW);
			 T58 = FMA(TX, TV, T57);
			 T12 = TR + T11;
			 T7K = T56 - T58;
			 T59 = T56 + T58;
			 T7H = TR - T11;
		    }
		    {
			 E T4a, T5w, T4g, T5y, T48, T4e;
			 T48 = W[61];
			 T4a = FMA(T48, T49, T47);
			 T5w = FNMS(T48, T46, T5v);
			 T4e = W[29];
			 T4g = FMA(T4e, T4f, T4d);
			 T5y = FNMS(T4e, T4c, T5x);
			 T4h = T4a + T4g;
			 T81 = T5w - T5y;
			 T5z = T5w + T5y;
			 T7Q = T4g - T4a;
		    }
	       }
	       {
		    E T4, T3I, T9, T3F, T5, T4U, T3G, T5k, Te, T3O, Tj, T3L, Tf, T4W, T3M;
		    E T5m;
		    {
			 E T1, T3E, Tb, T3K;
			 {
			      E T2, T3, T7, T8;
			      T2 = Ip[WS(rs, 1)];
			      T3 = Im[WS(rs, 1)];
			      T4 = T2 - T3;
			      T3I = T2 + T3;
			      T7 = Rp[WS(rs, 1)];
			      T8 = Rm[WS(rs, 1)];
			      T9 = T7 + T8;
			      T3F = T7 - T8;
			 }
			 T1 = W[2];
			 T5 = T1 * T4;
			 T4U = T1 * T9;
			 T3E = W[4];
			 T3G = T3E * T3F;
			 T5k = T3E * T3I;
			 {
			      E Tc, Td, Th, Ti;
			      Tc = Ip[WS(rs, 9)];
			      Td = Im[WS(rs, 9)];
			      Te = Tc - Td;
			      T3O = Tc + Td;
			      Th = Rp[WS(rs, 9)];
			      Ti = Rm[WS(rs, 9)];
			      Tj = Th + Ti;
			      T3L = Th - Ti;
			 }
			 Tb = W[34];
			 Tf = Tb * Te;
			 T4W = Tb * Tj;
			 T3K = W[36];
			 T3M = T3K * T3L;
			 T5m = T3K * T3O;
		    }
		    {
			 E Ta, T4V, Tk, T4X, T6, Tg;
			 T6 = W[3];
			 Ta = FNMS(T6, T9, T5);
			 T4V = FMA(T6, T4, T4U);
			 Tg = W[35];
			 Tk = FNMS(Tg, Tj, Tf);
			 T4X = FMA(Tg, Te, T4W);
			 Tl = Ta + Tk;
			 T7D = T4V - T4X;
			 T4Y = T4V + T4X;
			 T7A = Ta - Tk;
		    }
		    {
			 E T3J, T5l, T3P, T5n, T3H, T3N, T7T, T7U;
			 T3H = W[5];
			 T3J = FMA(T3H, T3I, T3G);
			 T5l = FNMS(T3H, T3F, T5k);
			 T3N = W[37];
			 T3P = FMA(T3N, T3O, T3M);
			 T5n = FNMS(T3N, T3L, T5m);
			 T3Q = T3J + T3P;
			 T5o = T5l + T5n;
			 T7T = T3P - T3J;
			 T7U = T5l - T5n;
			 T7V = T7T - T7U;
			 T84 = T7U + T7T;
		    }
	       }
	       {
		    E T1t, T1y, T2N, T2M, T5H, T2J, T2L, T1u, T4I, T1D, T1I, T2T, T2S, T5J, T2P;
		    E T2R, T1E, T4K;
		    {
			 E T1r, T1s, T2K, T1w, T1x, T1q;
			 T1r = Ip[WS(rs, 2)];
			 T1s = Im[WS(rs, 2)];
			 T1t = T1r - T1s;
			 T1w = Rp[WS(rs, 2)];
			 T1x = Rm[WS(rs, 2)];
			 T1y = T1w + T1x;
			 T2K = T1x - T1w;
			 T2N = T1r + T1s;
			 T2M = W[9];
			 T5H = T2M * T2K;
			 T2J = W[8];
			 T2L = T2J * T2K;
			 T1q = W[6];
			 T1u = T1q * T1t;
			 T4I = T1q * T1y;
		    }
		    {
			 E T1B, T1C, T2Q, T1G, T1H, T1A;
			 T1B = Ip[WS(rs, 10)];
			 T1C = Im[WS(rs, 10)];
			 T1D = T1B - T1C;
			 T1G = Rp[WS(rs, 10)];
			 T1H = Rm[WS(rs, 10)];
			 T1I = T1G + T1H;
			 T2Q = T1H - T1G;
			 T2T = T1B + T1C;
			 T2S = W[41];
			 T5J = T2S * T2Q;
			 T2P = W[40];
			 T2R = T2P * T2Q;
			 T1A = W[38];
			 T1E = T1A * T1D;
			 T4K = T1A * T1I;
		    }
		    {
			 E T1z, T4J, T1J, T4L, T1v, T1F;
			 T1v = W[7];
			 T1z = FNMS(T1v, T1y, T1u);
			 T4J = FMA(T1v, T1t, T4I);
			 T1F = W[39];
			 T1J = FNMS(T1F, T1I, T1E);
			 T4L = FMA(T1F, T1D, T4K);
			 T1K = T1z + T1J;
			 T7t = T4J - T4L;
			 T4M = T4J + T4L;
			 T7s = T1z - T1J;
		    }
		    {
			 E T2O, T2U, T8c, T5I, T5K, T8d;
			 T2O = FNMS(T2M, T2N, T2L);
			 T2U = FNMS(T2S, T2T, T2R);
			 T8c = T2O - T2U;
			 T5I = FMA(T2J, T2N, T5H);
			 T5K = FMA(T2P, T2T, T5J);
			 T8d = T5I - T5K;
			 T2V = T2O + T2U;
			 T8n = T8c + T8d;
			 T5L = T5I + T5K;
			 T8e = T8c - T8d;
		    }
	       }
	       {
		    E T1O, T1T, T30, T2Z, T5M, T2W, T2Y, T1P, T4N, T1Y, T23, T36, T35, T5O, T32;
		    E T34, T1Z, T4P;
		    {
			 E T1M, T1N, T2X, T1R, T1S, T1L;
			 T1M = Ip[WS(rs, 14)];
			 T1N = Im[WS(rs, 14)];
			 T1O = T1M - T1N;
			 T1R = Rp[WS(rs, 14)];
			 T1S = Rm[WS(rs, 14)];
			 T1T = T1R + T1S;
			 T2X = T1S - T1R;
			 T30 = T1M + T1N;
			 T2Z = W[57];
			 T5M = T2Z * T2X;
			 T2W = W[56];
			 T2Y = T2W * T2X;
			 T1L = W[54];
			 T1P = T1L * T1O;
			 T4N = T1L * T1T;
		    }
		    {
			 E T1W, T1X, T33, T21, T22, T1V;
			 T1W = Ip[WS(rs, 6)];
			 T1X = Im[WS(rs, 6)];
			 T1Y = T1W - T1X;
			 T21 = Rp[WS(rs, 6)];
			 T22 = Rm[WS(rs, 6)];
			 T23 = T21 + T22;
			 T33 = T22 - T21;
			 T36 = T1W + T1X;
			 T35 = W[25];
			 T5O = T35 * T33;
			 T32 = W[24];
			 T34 = T32 * T33;
			 T1V = W[22];
			 T1Z = T1V * T1Y;
			 T4P = T1V * T23;
		    }
		    {
			 E T1U, T4O, T24, T4Q, T1Q, T20;
			 T1Q = W[55];
			 T1U = FNMS(T1Q, T1T, T1P);
			 T4O = FMA(T1Q, T1O, T4N);
			 T20 = W[23];
			 T24 = FNMS(T20, T23, T1Z);
			 T4Q = FMA(T20, T1Y, T4P);
			 T25 = T1U + T24;
			 T7w = T1U - T24;
			 T4R = T4O + T4Q;
			 T7v = T4O - T4Q;
		    }
		    {
			 E T31, T37, T8f, T5N, T5P, T8g;
			 T31 = FNMS(T2Z, T30, T2Y);
			 T37 = FNMS(T35, T36, T34);
			 T8f = T31 - T37;
			 T5N = FMA(T2W, T30, T5M);
			 T5P = FMA(T32, T36, T5O);
			 T8g = T5N - T5P;
			 T38 = T31 + T37;
			 T8o = T8g - T8f;
			 T5Q = T5N + T5P;
			 T8h = T8f + T8g;
		    }
	       }
	       {
		    E Tp, T3V, Tu, T3S, Tq, T4Z, T3T, T5p, Tz, T41, TE, T3Y, TA, T51, T3Z;
		    E T5r;
		    {
			 E Tm, T3R, Tw, T3X;
			 {
			      E Tn, To, Ts, Tt;
			      Tn = Ip[WS(rs, 5)];
			      To = Im[WS(rs, 5)];
			      Tp = Tn - To;
			      T3V = Tn + To;
			      Ts = Rp[WS(rs, 5)];
			      Tt = Rm[WS(rs, 5)];
			      Tu = Ts + Tt;
			      T3S = Ts - Tt;
			 }
			 Tm = W[18];
			 Tq = Tm * Tp;
			 T4Z = Tm * Tu;
			 T3R = W[20];
			 T3T = T3R * T3S;
			 T5p = T3R * T3V;
			 {
			      E Tx, Ty, TC, TD;
			      Tx = Ip[WS(rs, 13)];
			      Ty = Im[WS(rs, 13)];
			      Tz = Tx - Ty;
			      T41 = Tx + Ty;
			      TC = Rp[WS(rs, 13)];
			      TD = Rm[WS(rs, 13)];
			      TE = TC + TD;
			      T3Y = TC - TD;
			 }
			 Tw = W[50];
			 TA = Tw * Tz;
			 T51 = Tw * TE;
			 T3X = W[52];
			 T3Z = T3X * T3Y;
			 T5r = T3X * T41;
		    }
		    {
			 E Tv, T50, TF, T52, Tr, TB;
			 Tr = W[19];
			 Tv = FNMS(Tr, Tu, Tq);
			 T50 = FMA(Tr, Tp, T4Z);
			 TB = W[51];
			 TF = FNMS(TB, TE, TA);
			 T52 = FMA(TB, Tz, T51);
			 TG = Tv + TF;
			 T7E = Tv - TF;
			 T53 = T50 + T52;
			 T7B = T50 - T52;
		    }
		    {
			 E T3W, T5q, T42, T5s, T3U, T40, T7W, T7X;
			 T3U = W[21];
			 T3W = FMA(T3U, T3V, T3T);
			 T5q = FNMS(T3U, T3S, T5p);
			 T40 = W[53];
			 T42 = FMA(T40, T41, T3Z);
			 T5s = FNMS(T40, T3Y, T5r);
			 T43 = T3W + T42;
			 T5t = T5q + T5s;
			 T7W = T5s - T5q;
			 T7X = T3W - T42;
			 T7Y = T7W + T7X;
			 T85 = T7W - T7X;
		    }
	       }
	       {
		    E T1p, T6i, T2H, T68, T5g, T67, T4T, T6h, T4w, T6m, T5G, T6c, T3D, T6n, T63;
		    E T6f;
		    {
			 E TH, T1o, T4H, T4S;
			 TH = Tl + TG;
			 T1o = T12 + T1n;
			 T1p = TH + T1o;
			 T6i = TH - T1o;
			 {
			      E T26, T2G, T54, T5f;
			      T26 = T1K + T25;
			      T2G = T2r + T2F;
			      T2H = T26 + T2G;
			      T68 = T2G - T26;
			      T54 = T4Y + T53;
			      T5f = T59 + T5e;
			      T5g = T54 + T5f;
			      T67 = T5f - T54;
			 }
			 T4H = T4B + T4G;
			 T4S = T4M + T4R;
			 T4T = T4H + T4S;
			 T6h = T4H - T4S;
			 {
			      E T44, T4v, T6b, T5u, T5F, T6a;
			      T44 = T3Q + T43;
			      T4v = T4h + T4u;
			      T6b = T44 - T4v;
			      T5u = T5o + T5t;
			      T5F = T5z + T5E;
			      T6a = T5F - T5u;
			      T4w = T44 + T4v;
			      T6m = T6a - T6b;
			      T5G = T5u + T5F;
			      T6c = T6a + T6b;
			 }
			 {
			      E T39, T3C, T6d, T5R, T62, T6e;
			      T39 = T2V + T38;
			      T3C = T3m + T3B;
			      T6d = T3C - T39;
			      T5R = T5L + T5Q;
			      T62 = T5W + T61;
			      T6e = T62 - T5R;
			      T3D = T39 + T3C;
			      T6n = T6d + T6e;
			      T63 = T5R + T62;
			      T6f = T6d - T6e;
			 }
		    }
		    {
			 E T2I, T4x, T65, T66;
			 T2I = T1p + T2H;
			 T4x = T3D - T4w;
			 Ip[0] = KP500000000 * (T2I + T4x);
			 Im[WS(rs, 15)] = KP500000000 * (T4x - T2I);
			 T65 = T4T + T5g;
			 T66 = T5G + T63;
			 Rm[WS(rs, 15)] = KP500000000 * (T65 - T66);
			 Rp[0] = KP500000000 * (T65 + T66);
		    }
		    {
			 E T5h, T5i, T5j, T64;
			 T5h = T4T - T5g;
			 T5i = T4w + T3D;
			 Rm[WS(rs, 7)] = KP500000000 * (T5h - T5i);
			 Rp[WS(rs, 8)] = KP500000000 * (T5h + T5i);
			 T5j = T2H - T1p;
			 T64 = T5G - T63;
			 Ip[WS(rs, 8)] = KP500000000 * (T5j + T64);
			 Im[WS(rs, 7)] = KP500000000 * (T64 - T5j);
		    }
		    {
			 E T69, T6g, T6p, T6q;
			 T69 = T67 + T68;
			 T6g = T6c + T6f;
			 Ip[WS(rs, 4)] = KP500000000 * (FMA(KP707106781, T6g, T69));
			 Im[WS(rs, 11)] = -(KP500000000 * (FNMS(KP707106781, T6g, T69)));
			 T6p = T6h + T6i;
			 T6q = T6m + T6n;
			 Rm[WS(rs, 11)] = KP500000000 * (FNMS(KP707106781, T6q, T6p));
			 Rp[WS(rs, 4)] = KP500000000 * (FMA(KP707106781, T6q, T6p));
		    }
		    {
			 E T6j, T6k, T6l, T6o;
			 T6j = T6h - T6i;
			 T6k = T6f - T6c;
			 Rm[WS(rs, 3)] = KP500000000 * (FNMS(KP707106781, T6k, T6j));
			 Rp[WS(rs, 12)] = KP500000000 * (FMA(KP707106781, T6k, T6j));
			 T6l = T68 - T67;
			 T6o = T6m - T6n;
			 Ip[WS(rs, 12)] = KP500000000 * (FMA(KP707106781, T6o, T6l));
			 Im[WS(rs, 3)] = -(KP500000000 * (FNMS(KP707106781, T6o, T6l)));
		    }
	       }
	       {
		    E T6t, T75, T6T, T7f, T6A, T7g, T6W, T76, T6I, T7k, T70, T7a, T6P, T7l, T71;
		    E T7d;
		    {
			 E T6r, T6s, T6R, T6S;
			 T6r = T4R - T4M;
			 T6s = T2F - T2r;
			 T6t = T6r + T6s;
			 T75 = T6s - T6r;
			 T6R = T4B - T4G;
			 T6S = T1K - T25;
			 T6T = T6R + T6S;
			 T7f = T6R - T6S;
		    }
		    {
			 E T6w, T6U, T6z, T6V;
			 {
			      E T6u, T6v, T6x, T6y;
			      T6u = Tl - TG;
			      T6v = T4Y - T53;
			      T6w = T6u - T6v;
			      T6U = T6v + T6u;
			      T6x = T59 - T5e;
			      T6y = T12 - T1n;
			      T6z = T6x + T6y;
			      T6V = T6x - T6y;
			 }
			 T6A = T6w + T6z;
			 T7g = T6w - T6z;
			 T6W = T6U + T6V;
			 T76 = T6V - T6U;
		    }
		    {
			 E T6E, T78, T6H, T79;
			 {
			      E T6C, T6D, T6F, T6G;
			      T6C = T5t - T5o;
			      T6D = T4u - T4h;
			      T6E = T6C + T6D;
			      T78 = T6C - T6D;
			      T6F = T43 - T3Q;
			      T6G = T5z - T5E;
			      T6H = T6F + T6G;
			      T79 = T6G - T6F;
			 }
			 T6I = FMA(KP414213562, T6H, T6E);
			 T7k = FNMS(KP414213562, T78, T79);
			 T70 = FNMS(KP414213562, T6E, T6H);
			 T7a = FMA(KP414213562, T79, T78);
		    }
		    {
			 E T6L, T7b, T6O, T7c;
			 {
			      E T6J, T6K, T6M, T6N;
			      T6J = T5Q - T5L;
			      T6K = T3B - T3m;
			      T6L = T6J + T6K;
			      T7b = T6K - T6J;
			      T6M = T2V - T38;
			      T6N = T61 - T5W;
			      T6O = T6M + T6N;
			      T7c = T6N - T6M;
			 }
			 T6P = FNMS(KP414213562, T6O, T6L);
			 T7l = FNMS(KP414213562, T7b, T7c);
			 T71 = FMA(KP414213562, T6L, T6O);
			 T7d = FMA(KP414213562, T7c, T7b);
		    }
		    {
			 E T6B, T6Q, T73, T74;
			 T6B = FMA(KP707106781, T6A, T6t);
			 T6Q = T6I + T6P;
			 Ip[WS(rs, 2)] = KP500000000 * (FMA(KP923879532, T6Q, T6B));
			 Im[WS(rs, 13)] = -(KP500000000 * (FNMS(KP923879532, T6Q, T6B)));
			 T73 = FMA(KP707106781, T6W, T6T);
			 T74 = T70 + T71;
			 Rm[WS(rs, 13)] = KP500000000 * (FNMS(KP923879532, T74, T73));
			 Rp[WS(rs, 2)] = KP500000000 * (FMA(KP923879532, T74, T73));
		    }
		    {
			 E T6X, T6Y, T6Z, T72;
			 T6X = FNMS(KP707106781, T6W, T6T);
			 T6Y = T6P - T6I;
			 Rm[WS(rs, 5)] = KP500000000 * (FNMS(KP923879532, T6Y, T6X));
			 Rp[WS(rs, 10)] = KP500000000 * (FMA(KP923879532, T6Y, T6X));
			 T6Z = FNMS(KP707106781, T6A, T6t);
			 T72 = T70 - T71;
			 Ip[WS(rs, 10)] = KP500000000 * (FMA(KP923879532, T72, T6Z));
			 Im[WS(rs, 5)] = -(KP500000000 * (FNMS(KP923879532, T72, T6Z)));
		    }
		    {
			 E T77, T7e, T7n, T7o;
			 T77 = FNMS(KP707106781, T76, T75);
			 T7e = T7a - T7d;
			 Ip[WS(rs, 14)] = KP500000000 * (FMA(KP923879532, T7e, T77));
			 Im[WS(rs, 1)] = -(KP500000000 * (FNMS(KP923879532, T7e, T77)));
			 T7n = FNMS(KP707106781, T7g, T7f);
			 T7o = T7k + T7l;
			 Rp[WS(rs, 14)] = KP500000000 * (FNMS(KP923879532, T7o, T7n));
			 Rm[WS(rs, 1)] = KP500000000 * (FMA(KP923879532, T7o, T7n));
		    }
		    {
			 E T7h, T7i, T7j, T7m;
			 T7h = FMA(KP707106781, T7g, T7f);
			 T7i = T7a + T7d;
			 Rm[WS(rs, 9)] = KP500000000 * (FNMS(KP923879532, T7i, T7h));
			 Rp[WS(rs, 6)] = KP500000000 * (FMA(KP923879532, T7i, T7h));
			 T7j = FMA(KP707106781, T76, T75);
			 T7m = T7k - T7l;
			 Ip[WS(rs, 6)] = KP500000000 * (FMA(KP923879532, T7m, T7j));
			 Im[WS(rs, 9)] = -(KP500000000 * (FNMS(KP923879532, T7m, T7j)));
		    }
	       }
	       {
		    E T7z, T9T, T8L, T9x, T8z, T9J, T8V, T97, T7O, T8W, T8C, T8M, T9t, T9Y, T9E;
		    E T9O, T88, T90, T8G, T8Q, T9e, T9U, T9A, T9K, T9m, T9Z, T9F, T9R, T8r, T91;
		    E T8H, T8T;
		    {
			 E T7r, T9v, T7y, T9w, T7u, T7x;
			 T7r = T7p - T7q;
			 T9v = T8t - T8u;
			 T7u = T7s - T7t;
			 T7x = T7v + T7w;
			 T7y = T7u + T7x;
			 T9w = T7u - T7x;
			 T7z = FMA(KP707106781, T7y, T7r);
			 T9T = FNMS(KP707106781, T9w, T9v);
			 T8L = FNMS(KP707106781, T7y, T7r);
			 T9x = FMA(KP707106781, T9w, T9v);
		    }
		    {
			 E T8v, T95, T8y, T96, T8w, T8x;
			 T8v = T8t + T8u;
			 T95 = T7q + T7p;
			 T8w = T7t + T7s;
			 T8x = T7v - T7w;
			 T8y = T8w + T8x;
			 T96 = T8x - T8w;
			 T8z = FMA(KP707106781, T8y, T8v);
			 T9J = FNMS(KP707106781, T96, T95);
			 T8V = FNMS(KP707106781, T8y, T8v);
			 T97 = FMA(KP707106781, T96, T95);
		    }
		    {
			 E T7G, T8A, T7N, T8B;
			 {
			      E T7C, T7F, T7J, T7M;
			      T7C = T7A - T7B;
			      T7F = T7D + T7E;
			      T7G = FNMS(KP414213562, T7F, T7C);
			      T8A = FMA(KP414213562, T7C, T7F);
			      T7J = T7H - T7I;
			      T7M = T7K + T7L;
			      T7N = FMA(KP414213562, T7M, T7J);
			      T8B = FNMS(KP414213562, T7J, T7M);
			 }
			 T7O = T7G + T7N;
			 T8W = T7G - T7N;
			 T8C = T8A + T8B;
			 T8M = T8B - T8A;
		    }
		    {
			 E T9p, T9M, T9s, T9N;
			 {
			      E T9n, T9o, T9q, T9r;
			      T9n = T7R - T7Q;
			      T9o = T85 - T84;
			      T9p = FNMS(KP707106781, T9o, T9n);
			      T9M = FMA(KP707106781, T9o, T9n);
			      T9q = T81 - T82;
			      T9r = T7Y - T7V;
			      T9s = FNMS(KP707106781, T9r, T9q);
			      T9N = FMA(KP707106781, T9r, T9q);
			 }
			 T9t = FNMS(KP668178637, T9s, T9p);
			 T9Y = FNMS(KP198912367, T9M, T9N);
			 T9E = FMA(KP668178637, T9p, T9s);
			 T9O = FMA(KP198912367, T9N, T9M);
		    }
		    {
			 E T80, T8O, T87, T8P;
			 {
			      E T7S, T7Z, T83, T86;
			      T7S = T7Q + T7R;
			      T7Z = T7V + T7Y;
			      T80 = FMA(KP707106781, T7Z, T7S);
			      T8O = FNMS(KP707106781, T7Z, T7S);
			      T83 = T81 + T82;
			      T86 = T84 + T85;
			      T87 = FMA(KP707106781, T86, T83);
			      T8P = FNMS(KP707106781, T86, T83);
			 }
			 T88 = FMA(KP198912367, T87, T80);
			 T90 = FMA(KP668178637, T8O, T8P);
			 T8G = FNMS(KP198912367, T80, T87);
			 T8Q = FNMS(KP668178637, T8P, T8O);
		    }
		    {
			 E T9a, T9z, T9d, T9y;
			 {
			      E T98, T99, T9b, T9c;
			      T98 = T7K - T7L;
			      T99 = T7H + T7I;
			      T9a = FMA(KP414213562, T99, T98);
			      T9z = FNMS(KP414213562, T98, T99);
			      T9b = T7D - T7E;
			      T9c = T7A + T7B;
			      T9d = FNMS(KP414213562, T9c, T9b);
			      T9y = FMA(KP414213562, T9b, T9c);
			 }
			 T9e = T9a - T9d;
			 T9U = T9d + T9a;
			 T9A = T9y - T9z;
			 T9K = T9y + T9z;
		    }
		    {
			 E T9i, T9P, T9l, T9Q;
			 {
			      E T9g, T9h, T9j, T9k;
			      T9g = T8a + T89;
			      T9h = T8n - T8o;
			      T9i = FNMS(KP707106781, T9h, T9g);
			      T9P = FMA(KP707106781, T9h, T9g);
			      T9j = T8l - T8k;
			      T9k = T8h - T8e;
			      T9l = FNMS(KP707106781, T9k, T9j);
			      T9Q = FMA(KP707106781, T9k, T9j);
			 }
			 T9m = FNMS(KP668178637, T9l, T9i);
			 T9Z = FNMS(KP198912367, T9P, T9Q);
			 T9F = FMA(KP668178637, T9i, T9l);
			 T9R = FMA(KP198912367, T9Q, T9P);
		    }
		    {
			 E T8j, T8R, T8q, T8S;
			 {
			      E T8b, T8i, T8m, T8p;
			      T8b = T89 - T8a;
			      T8i = T8e + T8h;
			      T8j = FMA(KP707106781, T8i, T8b);
			      T8R = FNMS(KP707106781, T8i, T8b);
			      T8m = T8k + T8l;
			      T8p = T8n + T8o;
			      T8q = FMA(KP707106781, T8p, T8m);
			      T8S = FNMS(KP707106781, T8p, T8m);
			 }
			 T8r = FNMS(KP198912367, T8q, T8j);
			 T91 = FNMS(KP668178637, T8R, T8S);
			 T8H = FMA(KP198912367, T8j, T8q);
			 T8T = FMA(KP668178637, T8S, T8R);
		    }
		    {
			 E T7P, T8s, T8J, T8K;
			 T7P = FMA(KP923879532, T7O, T7z);
			 T8s = T88 + T8r;
			 Ip[WS(rs, 1)] = KP500000000 * (FMA(KP980785280, T8s, T7P));
			 Im[WS(rs, 14)] = -(KP500000000 * (FNMS(KP980785280, T8s, T7P)));
			 T8J = FMA(KP923879532, T8C, T8z);
			 T8K = T8G + T8H;
			 Rm[WS(rs, 14)] = KP500000000 * (FNMS(KP980785280, T8K, T8J));
			 Rp[WS(rs, 1)] = KP500000000 * (FMA(KP980785280, T8K, T8J));
		    }
		    {
			 E T8D, T8E, T8F, T8I;
			 T8D = FNMS(KP923879532, T8C, T8z);
			 T8E = T8r - T88;
			 Rm[WS(rs, 6)] = KP500000000 * (FNMS(KP980785280, T8E, T8D));
			 Rp[WS(rs, 9)] = KP500000000 * (FMA(KP980785280, T8E, T8D));
			 T8F = FNMS(KP923879532, T7O, T7z);
			 T8I = T8G - T8H;
			 Ip[WS(rs, 9)] = KP500000000 * (FMA(KP980785280, T8I, T8F));
			 Im[WS(rs, 6)] = -(KP500000000 * (FNMS(KP980785280, T8I, T8F)));
		    }
		    {
			 E T8N, T8U, T93, T94;
			 T8N = FNMS(KP923879532, T8M, T8L);
			 T8U = T8Q + T8T;
			 Ip[WS(rs, 13)] = KP500000000 * (FNMS(KP831469612, T8U, T8N));
			 Im[WS(rs, 2)] = -(KP500000000 * (FMA(KP831469612, T8U, T8N)));
			 T93 = FNMS(KP923879532, T8W, T8V);
			 T94 = T90 + T91;
			 Rp[WS(rs, 13)] = KP500000000 * (FNMS(KP831469612, T94, T93));
			 Rm[WS(rs, 2)] = KP500000000 * (FMA(KP831469612, T94, T93));
		    }
		    {
			 E T8X, T8Y, T8Z, T92;
			 T8X = FMA(KP923879532, T8W, T8V);
			 T8Y = T8T - T8Q;
			 Rm[WS(rs, 10)] = KP500000000 * (FNMS(KP831469612, T8Y, T8X));
			 Rp[WS(rs, 5)] = KP500000000 * (FMA(KP831469612, T8Y, T8X));
			 T8Z = FMA(KP923879532, T8M, T8L);
			 T92 = T90 - T91;
			 Ip[WS(rs, 5)] = KP500000000 * (FMA(KP831469612, T92, T8Z));
			 Im[WS(rs, 10)] = -(KP500000000 * (FNMS(KP831469612, T92, T8Z)));
		    }
		    {
			 E T9f, T9u, T9H, T9I;
			 T9f = FMA(KP923879532, T9e, T97);
			 T9u = T9m - T9t;
			 Ip[WS(rs, 3)] = KP500000000 * (FMA(KP831469612, T9u, T9f));
			 Im[WS(rs, 12)] = -(KP500000000 * (FNMS(KP831469612, T9u, T9f)));
			 T9H = FMA(KP923879532, T9A, T9x);
			 T9I = T9E + T9F;
			 Rm[WS(rs, 12)] = KP500000000 * (FNMS(KP831469612, T9I, T9H));
			 Rp[WS(rs, 3)] = KP500000000 * (FMA(KP831469612, T9I, T9H));
		    }
		    {
			 E T9B, T9C, T9D, T9G;
			 T9B = FNMS(KP923879532, T9A, T9x);
			 T9C = T9t + T9m;
			 Rm[WS(rs, 4)] = KP500000000 * (FNMS(KP831469612, T9C, T9B));
			 Rp[WS(rs, 11)] = KP500000000 * (FMA(KP831469612, T9C, T9B));
			 T9D = FNMS(KP923879532, T9e, T97);
			 T9G = T9E - T9F;
			 Ip[WS(rs, 11)] = KP500000000 * (FMA(KP831469612, T9G, T9D));
			 Im[WS(rs, 4)] = -(KP500000000 * (FNMS(KP831469612, T9G, T9D)));
		    }
		    {
			 E T9L, T9S, Ta1, Ta2;
			 T9L = FMA(KP923879532, T9K, T9J);
			 T9S = T9O - T9R;
			 Ip[WS(rs, 15)] = KP500000000 * (FMA(KP980785280, T9S, T9L));
			 Im[0] = -(KP500000000 * (FNMS(KP980785280, T9S, T9L)));
			 Ta1 = FMA(KP923879532, T9U, T9T);
			 Ta2 = T9Y + T9Z;
			 Rp[WS(rs, 15)] = KP500000000 * (FNMS(KP980785280, Ta2, Ta1));
			 Rm[0] = KP500000000 * (FMA(KP980785280, Ta2, Ta1));
		    }
		    {
			 E T9V, T9W, T9X, Ta0;
			 T9V = FNMS(KP923879532, T9U, T9T);
			 T9W = T9O + T9R;
			 Rm[WS(rs, 8)] = KP500000000 * (FNMS(KP980785280, T9W, T9V));
			 Rp[WS(rs, 7)] = KP500000000 * (FMA(KP980785280, T9W, T9V));
			 T9X = FNMS(KP923879532, T9K, T9J);
			 Ta0 = T9Y - T9Z;
			 Ip[WS(rs, 7)] = KP500000000 * (FMA(KP980785280, Ta0, T9X));
			 Im[WS(rs, 8)] = -(KP500000000 * (FNMS(KP980785280, Ta0, T9X)));
		    }
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     { TW_FULL, 1, 32 },
     { TW_NEXT, 1, 0 }
};

static const hc2c_desc desc = { 32, "hc2cfdft_32", twinstr, &GENUS, { 300, 126, 198, 0 } };

void X(codelet_hc2cfdft_32) (planner *p) {
     X(khc2c_register) (p, hc2cfdft_32, &desc, HC2C_VIA_DFT);
}
#else

/* Generated by: ../../../genfft/gen_hc2cdft.native -compact -variables 4 -pipeline-latency 4 -n 32 -dit -name hc2cfdft_32 -include rdft/scalar/hc2cf.h */

/*
 * This function contains 498 FP additions, 228 FP multiplications,
 * (or, 404 additions, 134 multiplications, 94 fused multiply/add),
 * 106 stack variables, 9 constants, and 128 memory accesses
 */
#include "rdft/scalar/hc2cf.h"

static void hc2cfdft_32(R *Rp, R *Ip, R *Rm, R *Im, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP277785116, +0.277785116509801112371415406974266437187468595);
     DK(KP415734806, +0.415734806151272618539394188808952878369280406);
     DK(KP097545161, +0.097545161008064133924142434238511120463845809);
     DK(KP490392640, +0.490392640201615224563091118067119518486966865);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     DK(KP191341716, +0.191341716182544885864229992015199433380672281);
     DK(KP461939766, +0.461939766255643378064091594698394143411208313);
     DK(KP353553390, +0.353553390593273762200422181052424519642417969);
     DK(KP500000000, +0.500000000000000000000000000000000000000000000);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 62); m < me; m = m + 1, Rp = Rp + ms, Ip = Ip + ms, Rm = Rm - ms, Im = Im - ms, W = W + 62, MAKE_VOLATILE_STRIDE(128, rs)) {
	       E T2S, T5K, T52, T5N, T7p, T8r, T7i, T8o, T2q, T7t, T45, T6L, T2d, T7u, T48;
	       E T6M, T1A, T4c, T4f, T1T, T3f, T5M, T7e, T7l, T6J, T7x, T4V, T5J, T7b, T7k;
	       E T6G, T7w, Tj, TC, T5r, T4k, T4n, T5s, T3D, T5C, T6V, T72, T4G, T5F, T6u;
	       E T86, T6S, T71, T6r, T85, TW, T1f, T5v, T4r, T4u, T5u, T40, T5G, T76, T8k;
	       E T4N, T5D, T6B, T89, T6Z, T8h, T6y, T88;
	       {
		    E T1Y, T22, T2L, T4W, T2p, T43, T2A, T50, T27, T2b, T2Q, T4X, T2h, T2l, T2F;
		    E T4Z;
		    {
			 E T1W, T1X, T2K, T20, T21, T2I, T2H, T2J;
			 T1W = Ip[WS(rs, 4)];
			 T1X = Im[WS(rs, 4)];
			 T2K = T1W + T1X;
			 T20 = Rp[WS(rs, 4)];
			 T21 = Rm[WS(rs, 4)];
			 T2I = T20 - T21;
			 T1Y = T1W - T1X;
			 T22 = T20 + T21;
			 T2H = W[16];
			 T2J = W[17];
			 T2L = FMA(T2H, T2I, T2J * T2K);
			 T4W = FNMS(T2J, T2I, T2H * T2K);
		    }
		    {
			 E T2n, T2o, T2z, T2v, T2w, T2x, T2u, T2y;
			 T2n = Ip[0];
			 T2o = Im[0];
			 T2z = T2n + T2o;
			 T2v = Rm[0];
			 T2w = Rp[0];
			 T2x = T2v - T2w;
			 T2p = T2n - T2o;
			 T43 = T2w + T2v;
			 T2u = W[0];
			 T2y = W[1];
			 T2A = FNMS(T2y, T2z, T2u * T2x);
			 T50 = FMA(T2y, T2x, T2u * T2z);
		    }
		    {
			 E T25, T26, T2P, T29, T2a, T2N, T2M, T2O;
			 T25 = Ip[WS(rs, 12)];
			 T26 = Im[WS(rs, 12)];
			 T2P = T25 + T26;
			 T29 = Rp[WS(rs, 12)];
			 T2a = Rm[WS(rs, 12)];
			 T2N = T29 - T2a;
			 T27 = T25 - T26;
			 T2b = T29 + T2a;
			 T2M = W[48];
			 T2O = W[49];
			 T2Q = FMA(T2M, T2N, T2O * T2P);
			 T4X = FNMS(T2O, T2N, T2M * T2P);
		    }
		    {
			 E T2f, T2g, T2E, T2j, T2k, T2C, T2B, T2D;
			 T2f = Ip[WS(rs, 8)];
			 T2g = Im[WS(rs, 8)];
			 T2E = T2f + T2g;
			 T2j = Rp[WS(rs, 8)];
			 T2k = Rm[WS(rs, 8)];
			 T2C = T2j - T2k;
			 T2h = T2f - T2g;
			 T2l = T2j + T2k;
			 T2B = W[32];
			 T2D = W[33];
			 T2F = FMA(T2B, T2C, T2D * T2E);
			 T4Z = FNMS(T2D, T2C, T2B * T2E);
		    }
		    {
			 E T2G, T2R, T7g, T7h;
			 T2G = T2A - T2F;
			 T2R = T2L + T2Q;
			 T2S = T2G - T2R;
			 T5K = T2R + T2G;
			 {
			      E T4Y, T51, T7n, T7o;
			      T4Y = T4W + T4X;
			      T51 = T4Z + T50;
			      T52 = T4Y + T51;
			      T5N = T51 - T4Y;
			      T7n = T2Q - T2L;
			      T7o = T50 - T4Z;
			      T7p = T7n + T7o;
			      T8r = T7o - T7n;
			 }
			 T7g = T2F + T2A;
			 T7h = T4W - T4X;
			 T7i = T7g - T7h;
			 T8o = T7h + T7g;
			 {
			      E T2m, T44, T2e, T2i;
			      T2e = W[30];
			      T2i = W[31];
			      T2m = FNMS(T2i, T2l, T2e * T2h);
			      T44 = FMA(T2e, T2l, T2i * T2h);
			      T2q = T2m + T2p;
			      T7t = T43 - T44;
			      T45 = T43 + T44;
			      T6L = T2p - T2m;
			 }
			 {
			      E T23, T46, T2c, T47;
			      {
				   E T1V, T1Z, T24, T28;
				   T1V = W[14];
				   T1Z = W[15];
				   T23 = FNMS(T1Z, T22, T1V * T1Y);
				   T46 = FMA(T1V, T22, T1Z * T1Y);
				   T24 = W[46];
				   T28 = W[47];
				   T2c = FNMS(T28, T2b, T24 * T27);
				   T47 = FMA(T24, T2b, T28 * T27);
			      }
			      T2d = T23 + T2c;
			      T7u = T23 - T2c;
			      T48 = T46 + T47;
			      T6M = T46 - T47;
			 }
		    }
	       }
	       {
		    E T1q, T4a, T2X, T4P, T1S, T4e, T3d, T4T, T1z, T4b, T32, T4Q, T1J, T4d, T38;
		    E T4S;
		    {
			 E T1l, T2W, T1p, T2U;
			 {
			      E T1j, T1k, T1n, T1o;
			      T1j = Ip[WS(rs, 2)];
			      T1k = Im[WS(rs, 2)];
			      T1l = T1j - T1k;
			      T2W = T1j + T1k;
			      T1n = Rp[WS(rs, 2)];
			      T1o = Rm[WS(rs, 2)];
			      T1p = T1n + T1o;
			      T2U = T1n - T1o;
			 }
			 {
			      E T1i, T1m, T2T, T2V;
			      T1i = W[6];
			      T1m = W[7];
			      T1q = FNMS(T1m, T1p, T1i * T1l);
			      T4a = FMA(T1i, T1p, T1m * T1l);
			      T2T = W[8];
			      T2V = W[9];
			      T2X = FMA(T2T, T2U, T2V * T2W);
			      T4P = FNMS(T2V, T2U, T2T * T2W);
			 }
		    }
		    {
			 E T1N, T3c, T1R, T3a;
			 {
			      E T1L, T1M, T1P, T1Q;
			      T1L = Ip[WS(rs, 6)];
			      T1M = Im[WS(rs, 6)];
			      T1N = T1L - T1M;
			      T3c = T1L + T1M;
			      T1P = Rp[WS(rs, 6)];
			      T1Q = Rm[WS(rs, 6)];
			      T1R = T1P + T1Q;
			      T3a = T1P - T1Q;
			 }
			 {
			      E T1K, T1O, T39, T3b;
			      T1K = W[22];
			      T1O = W[23];
			      T1S = FNMS(T1O, T1R, T1K * T1N);
			      T4e = FMA(T1K, T1R, T1O * T1N);
			      T39 = W[24];
			      T3b = W[25];
			      T3d = FMA(T39, T3a, T3b * T3c);
			      T4T = FNMS(T3b, T3a, T39 * T3c);
			 }
		    }
		    {
			 E T1u, T31, T1y, T2Z;
			 {
			      E T1s, T1t, T1w, T1x;
			      T1s = Ip[WS(rs, 10)];
			      T1t = Im[WS(rs, 10)];
			      T1u = T1s - T1t;
			      T31 = T1s + T1t;
			      T1w = Rp[WS(rs, 10)];
			      T1x = Rm[WS(rs, 10)];
			      T1y = T1w + T1x;
			      T2Z = T1w - T1x;
			 }
			 {
			      E T1r, T1v, T2Y, T30;
			      T1r = W[38];
			      T1v = W[39];
			      T1z = FNMS(T1v, T1y, T1r * T1u);
			      T4b = FMA(T1r, T1y, T1v * T1u);
			      T2Y = W[40];
			      T30 = W[41];
			      T32 = FMA(T2Y, T2Z, T30 * T31);
			      T4Q = FNMS(T30, T2Z, T2Y * T31);
			 }
		    }
		    {
			 E T1E, T37, T1I, T35;
			 {
			      E T1C, T1D, T1G, T1H;
			      T1C = Ip[WS(rs, 14)];
			      T1D = Im[WS(rs, 14)];
			      T1E = T1C - T1D;
			      T37 = T1C + T1D;
			      T1G = Rp[WS(rs, 14)];
			      T1H = Rm[WS(rs, 14)];
			      T1I = T1G + T1H;
			      T35 = T1G - T1H;
			 }
			 {
			      E T1B, T1F, T34, T36;
			      T1B = W[54];
			      T1F = W[55];
			      T1J = FNMS(T1F, T1I, T1B * T1E);
			      T4d = FMA(T1B, T1I, T1F * T1E);
			      T34 = W[56];
			      T36 = W[57];
			      T38 = FMA(T34, T35, T36 * T37);
			      T4S = FNMS(T36, T35, T34 * T37);
			 }
		    }
		    {
			 E T33, T3e, T4R, T4U;
			 T1A = T1q + T1z;
			 T4c = T4a + T4b;
			 T4f = T4d + T4e;
			 T1T = T1J + T1S;
			 T33 = T2X + T32;
			 T3e = T38 + T3d;
			 T3f = T33 + T3e;
			 T5M = T3e - T33;
			 {
			      E T7c, T7d, T6H, T6I;
			      T7c = T4S - T4T;
			      T7d = T3d - T38;
			      T7e = T7c + T7d;
			      T7l = T7c - T7d;
			      T6H = T4d - T4e;
			      T6I = T1J - T1S;
			      T6J = T6H + T6I;
			      T7x = T6H - T6I;
			 }
			 T4R = T4P + T4Q;
			 T4U = T4S + T4T;
			 T4V = T4R + T4U;
			 T5J = T4U - T4R;
			 {
			      E T79, T7a, T6E, T6F;
			      T79 = T32 - T2X;
			      T7a = T4P - T4Q;
			      T7b = T79 - T7a;
			      T7k = T7a + T79;
			      T6E = T1q - T1z;
			      T6F = T4a - T4b;
			      T6G = T6E - T6F;
			      T7w = T6F + T6E;
			 }
		    }
	       }
	       {
		    E T9, T4i, T3l, T4A, TB, T4m, T3B, T4E, Ti, T4j, T3q, T4B, Ts, T4l, T3w;
		    E T4D;
		    {
			 E T4, T3k, T8, T3i;
			 {
			      E T2, T3, T6, T7;
			      T2 = Ip[WS(rs, 1)];
			      T3 = Im[WS(rs, 1)];
			      T4 = T2 - T3;
			      T3k = T2 + T3;
			      T6 = Rp[WS(rs, 1)];
			      T7 = Rm[WS(rs, 1)];
			      T8 = T6 + T7;
			      T3i = T6 - T7;
			 }
			 {
			      E T1, T5, T3h, T3j;
			      T1 = W[2];
			      T5 = W[3];
			      T9 = FNMS(T5, T8, T1 * T4);
			      T4i = FMA(T1, T8, T5 * T4);
			      T3h = W[4];
			      T3j = W[5];
			      T3l = FMA(T3h, T3i, T3j * T3k);
			      T4A = FNMS(T3j, T3i, T3h * T3k);
			 }
		    }
		    {
			 E Tw, T3A, TA, T3y;
			 {
			      E Tu, Tv, Ty, Tz;
			      Tu = Ip[WS(rs, 13)];
			      Tv = Im[WS(rs, 13)];
			      Tw = Tu - Tv;
			      T3A = Tu + Tv;
			      Ty = Rp[WS(rs, 13)];
			      Tz = Rm[WS(rs, 13)];
			      TA = Ty + Tz;
			      T3y = Ty - Tz;
			 }
			 {
			      E Tt, Tx, T3x, T3z;
			      Tt = W[50];
			      Tx = W[51];
			      TB = FNMS(Tx, TA, Tt * Tw);
			      T4m = FMA(Tt, TA, Tx * Tw);
			      T3x = W[52];
			      T3z = W[53];
			      T3B = FMA(T3x, T3y, T3z * T3A);
			      T4E = FNMS(T3z, T3y, T3x * T3A);
			 }
		    }
		    {
			 E Td, T3p, Th, T3n;
			 {
			      E Tb, Tc, Tf, Tg;
			      Tb = Ip[WS(rs, 9)];
			      Tc = Im[WS(rs, 9)];
			      Td = Tb - Tc;
			      T3p = Tb + Tc;
			      Tf = Rp[WS(rs, 9)];
			      Tg = Rm[WS(rs, 9)];
			      Th = Tf + Tg;
			      T3n = Tf - Tg;
			 }
			 {
			      E Ta, Te, T3m, T3o;
			      Ta = W[34];
			      Te = W[35];
			      Ti = FNMS(Te, Th, Ta * Td);
			      T4j = FMA(Ta, Th, Te * Td);
			      T3m = W[36];
			      T3o = W[37];
			      T3q = FMA(T3m, T3n, T3o * T3p);
			      T4B = FNMS(T3o, T3n, T3m * T3p);
			 }
		    }
		    {
			 E Tn, T3v, Tr, T3t;
			 {
			      E Tl, Tm, Tp, Tq;
			      Tl = Ip[WS(rs, 5)];
			      Tm = Im[WS(rs, 5)];
			      Tn = Tl - Tm;
			      T3v = Tl + Tm;
			      Tp = Rp[WS(rs, 5)];
			      Tq = Rm[WS(rs, 5)];
			      Tr = Tp + Tq;
			      T3t = Tp - Tq;
			 }
			 {
			      E Tk, To, T3s, T3u;
			      Tk = W[18];
			      To = W[19];
			      Ts = FNMS(To, Tr, Tk * Tn);
			      T4l = FMA(Tk, Tr, To * Tn);
			      T3s = W[20];
			      T3u = W[21];
			      T3w = FMA(T3s, T3t, T3u * T3v);
			      T4D = FNMS(T3u, T3t, T3s * T3v);
			 }
		    }
		    Tj = T9 + Ti;
		    TC = Ts + TB;
		    T5r = Tj - TC;
		    T4k = T4i + T4j;
		    T4n = T4l + T4m;
		    T5s = T4k - T4n;
		    {
			 E T3r, T3C, T6T, T6U;
			 T3r = T3l + T3q;
			 T3C = T3w + T3B;
			 T3D = T3r + T3C;
			 T5C = T3C - T3r;
			 T6T = T4E - T4D;
			 T6U = T3w - T3B;
			 T6V = T6T + T6U;
			 T72 = T6T - T6U;
		    }
		    {
			 E T4C, T4F, T6s, T6t;
			 T4C = T4A + T4B;
			 T4F = T4D + T4E;
			 T4G = T4C + T4F;
			 T5F = T4F - T4C;
			 T6s = T4i - T4j;
			 T6t = Ts - TB;
			 T6u = T6s + T6t;
			 T86 = T6s - T6t;
		    }
		    {
			 E T6Q, T6R, T6p, T6q;
			 T6Q = T3q - T3l;
			 T6R = T4A - T4B;
			 T6S = T6Q - T6R;
			 T71 = T6R + T6Q;
			 T6p = T9 - Ti;
			 T6q = T4l - T4m;
			 T6r = T6p - T6q;
			 T85 = T6p + T6q;
		    }
	       }
	       {
		    E TM, T4p, T3I, T4H, T1e, T4t, T3Y, T4L, TV, T4q, T3N, T4I, T15, T4s, T3T;
		    E T4K;
		    {
			 E TH, T3H, TL, T3F;
			 {
			      E TF, TG, TJ, TK;
			      TF = Ip[WS(rs, 15)];
			      TG = Im[WS(rs, 15)];
			      TH = TF - TG;
			      T3H = TF + TG;
			      TJ = Rp[WS(rs, 15)];
			      TK = Rm[WS(rs, 15)];
			      TL = TJ + TK;
			      T3F = TJ - TK;
			 }
			 {
			      E TE, TI, T3E, T3G;
			      TE = W[58];
			      TI = W[59];
			      TM = FNMS(TI, TL, TE * TH);
			      T4p = FMA(TE, TL, TI * TH);
			      T3E = W[60];
			      T3G = W[61];
			      T3I = FMA(T3E, T3F, T3G * T3H);
			      T4H = FNMS(T3G, T3F, T3E * T3H);
			 }
		    }
		    {
			 E T19, T3X, T1d, T3V;
			 {
			      E T17, T18, T1b, T1c;
			      T17 = Ip[WS(rs, 11)];
			      T18 = Im[WS(rs, 11)];
			      T19 = T17 - T18;
			      T3X = T17 + T18;
			      T1b = Rp[WS(rs, 11)];
			      T1c = Rm[WS(rs, 11)];
			      T1d = T1b + T1c;
			      T3V = T1b - T1c;
			 }
			 {
			      E T16, T1a, T3U, T3W;
			      T16 = W[42];
			      T1a = W[43];
			      T1e = FNMS(T1a, T1d, T16 * T19);
			      T4t = FMA(T16, T1d, T1a * T19);
			      T3U = W[44];
			      T3W = W[45];
			      T3Y = FMA(T3U, T3V, T3W * T3X);
			      T4L = FNMS(T3W, T3V, T3U * T3X);
			 }
		    }
		    {
			 E TQ, T3M, TU, T3K;
			 {
			      E TO, TP, TS, TT;
			      TO = Ip[WS(rs, 7)];
			      TP = Im[WS(rs, 7)];
			      TQ = TO - TP;
			      T3M = TO + TP;
			      TS = Rp[WS(rs, 7)];
			      TT = Rm[WS(rs, 7)];
			      TU = TS + TT;
			      T3K = TS - TT;
			 }
			 {
			      E TN, TR, T3J, T3L;
			      TN = W[26];
			      TR = W[27];
			      TV = FNMS(TR, TU, TN * TQ);
			      T4q = FMA(TN, TU, TR * TQ);
			      T3J = W[28];
			      T3L = W[29];
			      T3N = FMA(T3J, T3K, T3L * T3M);
			      T4I = FNMS(T3L, T3K, T3J * T3M);
			 }
		    }
		    {
			 E T10, T3S, T14, T3Q;
			 {
			      E TY, TZ, T12, T13;
			      TY = Ip[WS(rs, 3)];
			      TZ = Im[WS(rs, 3)];
			      T10 = TY - TZ;
			      T3S = TY + TZ;
			      T12 = Rp[WS(rs, 3)];
			      T13 = Rm[WS(rs, 3)];
			      T14 = T12 + T13;
			      T3Q = T12 - T13;
			 }
			 {
			      E TX, T11, T3P, T3R;
			      TX = W[10];
			      T11 = W[11];
			      T15 = FNMS(T11, T14, TX * T10);
			      T4s = FMA(TX, T14, T11 * T10);
			      T3P = W[12];
			      T3R = W[13];
			      T3T = FMA(T3P, T3Q, T3R * T3S);
			      T4K = FNMS(T3R, T3Q, T3P * T3S);
			 }
		    }
		    TW = TM + TV;
		    T1f = T15 + T1e;
		    T5v = TW - T1f;
		    T4r = T4p + T4q;
		    T4u = T4s + T4t;
		    T5u = T4r - T4u;
		    {
			 E T3O, T3Z, T74, T75;
			 T3O = T3I + T3N;
			 T3Z = T3T + T3Y;
			 T40 = T3O + T3Z;
			 T5G = T3Z - T3O;
			 T74 = T4H - T4I;
			 T75 = T3Y - T3T;
			 T76 = T74 + T75;
			 T8k = T74 - T75;
		    }
		    {
			 E T4J, T4M, T6z, T6A;
			 T4J = T4H + T4I;
			 T4M = T4K + T4L;
			 T4N = T4J + T4M;
			 T5D = T4J - T4M;
			 T6z = T4p - T4q;
			 T6A = T15 - T1e;
			 T6B = T6z + T6A;
			 T89 = T6z - T6A;
		    }
		    {
			 E T6X, T6Y, T6w, T6x;
			 T6X = T3N - T3I;
			 T6Y = T4K - T4L;
			 T6Z = T6X - T6Y;
			 T8h = T6X + T6Y;
			 T6w = TM - TV;
			 T6x = T4s - T4t;
			 T6y = T6w - T6x;
			 T88 = T6w + T6x;
		    }
	       }
	       {
		    E T1h, T5i, T5c, T5m, T5f, T5n, T2s, T58, T42, T4y, T4w, T57, T54, T56, T4h;
		    E T5h;
		    {
			 E TD, T1g, T5a, T5b;
			 TD = Tj + TC;
			 T1g = TW + T1f;
			 T1h = TD + T1g;
			 T5i = TD - T1g;
			 T5a = T4N - T4G;
			 T5b = T3D - T40;
			 T5c = T5a + T5b;
			 T5m = T5a - T5b;
		    }
		    {
			 E T5d, T5e, T1U, T2r;
			 T5d = T3f + T2S;
			 T5e = T52 - T4V;
			 T5f = T5d - T5e;
			 T5n = T5d + T5e;
			 T1U = T1A + T1T;
			 T2r = T2d + T2q;
			 T2s = T1U + T2r;
			 T58 = T2r - T1U;
		    }
		    {
			 E T3g, T41, T4o, T4v;
			 T3g = T2S - T3f;
			 T41 = T3D + T40;
			 T42 = T3g - T41;
			 T4y = T41 + T3g;
			 T4o = T4k + T4n;
			 T4v = T4r + T4u;
			 T4w = T4o + T4v;
			 T57 = T4v - T4o;
		    }
		    {
			 E T4O, T53, T49, T4g;
			 T4O = T4G + T4N;
			 T53 = T4V + T52;
			 T54 = T4O - T53;
			 T56 = T4O + T53;
			 T49 = T45 + T48;
			 T4g = T4c + T4f;
			 T4h = T49 + T4g;
			 T5h = T49 - T4g;
		    }
		    {
			 E T2t, T55, T4x, T4z;
			 T2t = T1h + T2s;
			 Ip[0] = KP500000000 * (T2t + T42);
			 Im[WS(rs, 15)] = KP500000000 * (T42 - T2t);
			 T55 = T4h + T4w;
			 Rm[WS(rs, 15)] = KP500000000 * (T55 - T56);
			 Rp[0] = KP500000000 * (T55 + T56);
			 T4x = T4h - T4w;
			 Rm[WS(rs, 7)] = KP500000000 * (T4x - T4y);
			 Rp[WS(rs, 8)] = KP500000000 * (T4x + T4y);
			 T4z = T2s - T1h;
			 Ip[WS(rs, 8)] = KP500000000 * (T4z + T54);
			 Im[WS(rs, 7)] = KP500000000 * (T54 - T4z);
		    }
		    {
			 E T59, T5g, T5p, T5q;
			 T59 = KP500000000 * (T57 + T58);
			 T5g = KP353553390 * (T5c + T5f);
			 Ip[WS(rs, 4)] = T59 + T5g;
			 Im[WS(rs, 11)] = T5g - T59;
			 T5p = KP500000000 * (T5h + T5i);
			 T5q = KP353553390 * (T5m + T5n);
			 Rm[WS(rs, 11)] = T5p - T5q;
			 Rp[WS(rs, 4)] = T5p + T5q;
		    }
		    {
			 E T5j, T5k, T5l, T5o;
			 T5j = KP500000000 * (T5h - T5i);
			 T5k = KP353553390 * (T5f - T5c);
			 Rm[WS(rs, 3)] = T5j - T5k;
			 Rp[WS(rs, 12)] = T5j + T5k;
			 T5l = KP500000000 * (T58 - T57);
			 T5o = KP353553390 * (T5m - T5n);
			 Ip[WS(rs, 12)] = T5l + T5o;
			 Im[WS(rs, 3)] = T5o - T5l;
		    }
	       }
	       {
		    E T5x, T6g, T6a, T6k, T6d, T6l, T5A, T66, T5I, T60, T5T, T6f, T5W, T65, T5P;
		    E T61;
		    {
			 E T5t, T5w, T68, T69;
			 T5t = T5r - T5s;
			 T5w = T5u + T5v;
			 T5x = KP353553390 * (T5t + T5w);
			 T6g = KP353553390 * (T5t - T5w);
			 T68 = T5D - T5C;
			 T69 = T5G - T5F;
			 T6a = FMA(KP461939766, T68, KP191341716 * T69);
			 T6k = FNMS(KP461939766, T69, KP191341716 * T68);
		    }
		    {
			 E T6b, T6c, T5y, T5z;
			 T6b = T5K - T5J;
			 T6c = T5N - T5M;
			 T6d = FNMS(KP461939766, T6c, KP191341716 * T6b);
			 T6l = FMA(KP461939766, T6b, KP191341716 * T6c);
			 T5y = T4f - T4c;
			 T5z = T2q - T2d;
			 T5A = KP500000000 * (T5y + T5z);
			 T66 = KP500000000 * (T5z - T5y);
		    }
		    {
			 E T5E, T5H, T5R, T5S;
			 T5E = T5C + T5D;
			 T5H = T5F + T5G;
			 T5I = FMA(KP191341716, T5E, KP461939766 * T5H);
			 T60 = FNMS(KP191341716, T5H, KP461939766 * T5E);
			 T5R = T45 - T48;
			 T5S = T1A - T1T;
			 T5T = KP500000000 * (T5R + T5S);
			 T6f = KP500000000 * (T5R - T5S);
		    }
		    {
			 E T5U, T5V, T5L, T5O;
			 T5U = T5s + T5r;
			 T5V = T5u - T5v;
			 T5W = KP353553390 * (T5U + T5V);
			 T65 = KP353553390 * (T5V - T5U);
			 T5L = T5J + T5K;
			 T5O = T5M + T5N;
			 T5P = FNMS(KP191341716, T5O, KP461939766 * T5L);
			 T61 = FMA(KP191341716, T5L, KP461939766 * T5O);
		    }
		    {
			 E T5B, T5Q, T63, T64;
			 T5B = T5x + T5A;
			 T5Q = T5I + T5P;
			 Ip[WS(rs, 2)] = T5B + T5Q;
			 Im[WS(rs, 13)] = T5Q - T5B;
			 T63 = T5T + T5W;
			 T64 = T60 + T61;
			 Rm[WS(rs, 13)] = T63 - T64;
			 Rp[WS(rs, 2)] = T63 + T64;
		    }
		    {
			 E T5X, T5Y, T5Z, T62;
			 T5X = T5T - T5W;
			 T5Y = T5P - T5I;
			 Rm[WS(rs, 5)] = T5X - T5Y;
			 Rp[WS(rs, 10)] = T5X + T5Y;
			 T5Z = T5A - T5x;
			 T62 = T60 - T61;
			 Ip[WS(rs, 10)] = T5Z + T62;
			 Im[WS(rs, 5)] = T62 - T5Z;
		    }
		    {
			 E T67, T6e, T6n, T6o;
			 T67 = T65 + T66;
			 T6e = T6a + T6d;
			 Ip[WS(rs, 6)] = T67 + T6e;
			 Im[WS(rs, 9)] = T6e - T67;
			 T6n = T6f + T6g;
			 T6o = T6k + T6l;
			 Rm[WS(rs, 9)] = T6n - T6o;
			 Rp[WS(rs, 6)] = T6n + T6o;
		    }
		    {
			 E T6h, T6i, T6j, T6m;
			 T6h = T6f - T6g;
			 T6i = T6d - T6a;
			 Rm[WS(rs, 1)] = T6h - T6i;
			 Rp[WS(rs, 14)] = T6h + T6i;
			 T6j = T66 - T65;
			 T6m = T6k - T6l;
			 Ip[WS(rs, 14)] = T6j + T6m;
			 Im[WS(rs, 1)] = T6m - T6j;
		    }
	       }
	       {
		    E T6D, T7W, T6O, T7M, T7C, T7L, T7z, T7V, T7r, T81, T7H, T7T, T78, T80, T7G;
		    E T7Q;
		    {
			 E T6v, T6C, T7v, T7y;
			 T6v = FNMS(KP191341716, T6u, KP461939766 * T6r);
			 T6C = FMA(KP461939766, T6y, KP191341716 * T6B);
			 T6D = T6v + T6C;
			 T7W = T6v - T6C;
			 {
			      E T6K, T6N, T7A, T7B;
			      T6K = KP353553390 * (T6G + T6J);
			      T6N = KP500000000 * (T6L - T6M);
			      T6O = T6K + T6N;
			      T7M = T6N - T6K;
			      T7A = FMA(KP191341716, T6r, KP461939766 * T6u);
			      T7B = FNMS(KP191341716, T6y, KP461939766 * T6B);
			      T7C = T7A + T7B;
			      T7L = T7B - T7A;
			 }
			 T7v = KP500000000 * (T7t + T7u);
			 T7y = KP353553390 * (T7w + T7x);
			 T7z = T7v + T7y;
			 T7V = T7v - T7y;
			 {
			      E T7j, T7R, T7q, T7S, T7f, T7m;
			      T7f = KP707106781 * (T7b + T7e);
			      T7j = T7f + T7i;
			      T7R = T7i - T7f;
			      T7m = KP707106781 * (T7k + T7l);
			      T7q = T7m + T7p;
			      T7S = T7p - T7m;
			      T7r = FNMS(KP097545161, T7q, KP490392640 * T7j);
			      T81 = FMA(KP415734806, T7R, KP277785116 * T7S);
			      T7H = FMA(KP097545161, T7j, KP490392640 * T7q);
			      T7T = FNMS(KP415734806, T7S, KP277785116 * T7R);
			 }
			 {
			      E T70, T7O, T77, T7P, T6W, T73;
			      T6W = KP707106781 * (T6S + T6V);
			      T70 = T6W + T6Z;
			      T7O = T6Z - T6W;
			      T73 = KP707106781 * (T71 + T72);
			      T77 = T73 + T76;
			      T7P = T76 - T73;
			      T78 = FMA(KP490392640, T70, KP097545161 * T77);
			      T80 = FNMS(KP415734806, T7O, KP277785116 * T7P);
			      T7G = FNMS(KP097545161, T70, KP490392640 * T77);
			      T7Q = FMA(KP277785116, T7O, KP415734806 * T7P);
			 }
		    }
		    {
			 E T6P, T7s, T7J, T7K;
			 T6P = T6D + T6O;
			 T7s = T78 + T7r;
			 Ip[WS(rs, 1)] = T6P + T7s;
			 Im[WS(rs, 14)] = T7s - T6P;
			 T7J = T7z + T7C;
			 T7K = T7G + T7H;
			 Rm[WS(rs, 14)] = T7J - T7K;
			 Rp[WS(rs, 1)] = T7J + T7K;
		    }
		    {
			 E T7D, T7E, T7F, T7I;
			 T7D = T7z - T7C;
			 T7E = T7r - T78;
			 Rm[WS(rs, 6)] = T7D - T7E;
			 Rp[WS(rs, 9)] = T7D + T7E;
			 T7F = T6O - T6D;
			 T7I = T7G - T7H;
			 Ip[WS(rs, 9)] = T7F + T7I;
			 Im[WS(rs, 6)] = T7I - T7F;
		    }
		    {
			 E T7N, T7U, T83, T84;
			 T7N = T7L + T7M;
			 T7U = T7Q + T7T;
			 Ip[WS(rs, 5)] = T7N + T7U;
			 Im[WS(rs, 10)] = T7U - T7N;
			 T83 = T7V + T7W;
			 T84 = T80 + T81;
			 Rm[WS(rs, 10)] = T83 - T84;
			 Rp[WS(rs, 5)] = T83 + T84;
		    }
		    {
			 E T7X, T7Y, T7Z, T82;
			 T7X = T7V - T7W;
			 T7Y = T7T - T7Q;
			 Rm[WS(rs, 2)] = T7X - T7Y;
			 Rp[WS(rs, 13)] = T7X + T7Y;
			 T7Z = T7M - T7L;
			 T82 = T80 - T81;
			 Ip[WS(rs, 13)] = T7Z + T82;
			 Im[WS(rs, 2)] = T82 - T7Z;
		    }
	       }
	       {
		    E T8b, T8U, T8e, T8K, T8A, T8J, T8x, T8T, T8t, T8Z, T8F, T8R, T8m, T8Y, T8E;
		    E T8O;
		    {
			 E T87, T8a, T8v, T8w;
			 T87 = FNMS(KP461939766, T86, KP191341716 * T85);
			 T8a = FMA(KP191341716, T88, KP461939766 * T89);
			 T8b = T87 + T8a;
			 T8U = T87 - T8a;
			 {
			      E T8c, T8d, T8y, T8z;
			      T8c = KP353553390 * (T7x - T7w);
			      T8d = KP500000000 * (T6M + T6L);
			      T8e = T8c + T8d;
			      T8K = T8d - T8c;
			      T8y = FMA(KP461939766, T85, KP191341716 * T86);
			      T8z = FNMS(KP461939766, T88, KP191341716 * T89);
			      T8A = T8y + T8z;
			      T8J = T8z - T8y;
			 }
			 T8v = KP500000000 * (T7t - T7u);
			 T8w = KP353553390 * (T6G - T6J);
			 T8x = T8v + T8w;
			 T8T = T8v - T8w;
			 {
			      E T8p, T8P, T8s, T8Q, T8n, T8q;
			      T8n = KP707106781 * (T7l - T7k);
			      T8p = T8n + T8o;
			      T8P = T8o - T8n;
			      T8q = KP707106781 * (T7b - T7e);
			      T8s = T8q + T8r;
			      T8Q = T8r - T8q;
			      T8t = FNMS(KP277785116, T8s, KP415734806 * T8p);
			      T8Z = FMA(KP490392640, T8P, KP097545161 * T8Q);
			      T8F = FMA(KP277785116, T8p, KP415734806 * T8s);
			      T8R = FNMS(KP490392640, T8Q, KP097545161 * T8P);
			 }
			 {
			      E T8i, T8M, T8l, T8N, T8g, T8j;
			      T8g = KP707106781 * (T72 - T71);
			      T8i = T8g + T8h;
			      T8M = T8h - T8g;
			      T8j = KP707106781 * (T6S - T6V);
			      T8l = T8j + T8k;
			      T8N = T8k - T8j;
			      T8m = FMA(KP415734806, T8i, KP277785116 * T8l);
			      T8Y = FNMS(KP490392640, T8M, KP097545161 * T8N);
			      T8E = FNMS(KP277785116, T8i, KP415734806 * T8l);
			      T8O = FMA(KP097545161, T8M, KP490392640 * T8N);
			 }
		    }
		    {
			 E T8f, T8u, T8H, T8I;
			 T8f = T8b + T8e;
			 T8u = T8m + T8t;
			 Ip[WS(rs, 3)] = T8f + T8u;
			 Im[WS(rs, 12)] = T8u - T8f;
			 T8H = T8x + T8A;
			 T8I = T8E + T8F;
			 Rm[WS(rs, 12)] = T8H - T8I;
			 Rp[WS(rs, 3)] = T8H + T8I;
		    }
		    {
			 E T8B, T8C, T8D, T8G;
			 T8B = T8x - T8A;
			 T8C = T8t - T8m;
			 Rm[WS(rs, 4)] = T8B - T8C;
			 Rp[WS(rs, 11)] = T8B + T8C;
			 T8D = T8e - T8b;
			 T8G = T8E - T8F;
			 Ip[WS(rs, 11)] = T8D + T8G;
			 Im[WS(rs, 4)] = T8G - T8D;
		    }
		    {
			 E T8L, T8S, T91, T92;
			 T8L = T8J + T8K;
			 T8S = T8O + T8R;
			 Ip[WS(rs, 7)] = T8L + T8S;
			 Im[WS(rs, 8)] = T8S - T8L;
			 T91 = T8T + T8U;
			 T92 = T8Y + T8Z;
			 Rm[WS(rs, 8)] = T91 - T92;
			 Rp[WS(rs, 7)] = T91 + T92;
		    }
		    {
			 E T8V, T8W, T8X, T90;
			 T8V = T8T - T8U;
			 T8W = T8R - T8O;
			 Rm[0] = T8V - T8W;
			 Rp[WS(rs, 15)] = T8V + T8W;
			 T8X = T8K - T8J;
			 T90 = T8Y - T8Z;
			 Ip[WS(rs, 15)] = T8X + T90;
			 Im[0] = T90 - T8X;
		    }
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     { TW_FULL, 1, 32 },
     { TW_NEXT, 1, 0 }
};

static const hc2c_desc desc = { 32, "hc2cfdft_32", twinstr, &GENUS, { 404, 134, 94, 0 } };

void X(codelet_hc2cfdft_32) (planner *p) {
     X(khc2c_register) (p, hc2cfdft_32, &desc, HC2C_VIA_DFT);
}
#endif
