/*
 * gwenrenameview.h
 *
 * Copyright (C) 2007 Spiros Georgaras <sng@hellug.gr>
 */
#ifndef GWENRENAMEVIEW_H
#define GWENRENAMEVIEW_H

#include <QtGui/QWidget>

#include "ui_gwenrenameview_base.h"

class QPainter;
class KUrl;

/**
 * This is the main view class for gwenrename.  Most of the non-menu,
 * non-toolbar, and non-statusbar (e.g., non frame) GUI code should go
 * here.
 *
 * @short Main view
 * @author Spiros Georgaras <sng@hellug.gr>
 * @version 1.1
 */

class gwenrenameView : public QWidget, public Ui::gwenrenameview_base
{
    Q_OBJECT
public:
    /**
     * Default constructor
     */
    gwenrenameView(QWidget *parent);

    /**
     * Destructor
     */
    virtual ~gwenrenameView();

private:
    Ui::gwenrenameview_base ui_gwenrenameview_base;

signals:
    /**
     * Use this signal to change the content of the statusbar
     */
    void signalChangeStatusbar(const QString& text);

    /**
     * Use this signal to change the content of the caption
     */
    void signalChangeCaption(const QString& text);

private slots:
    void switchColors();
    void settingsChanged();
};

#endif // gwenrenameVIEW_H
