/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.base;
public class FunctionsTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.base.testModule";
}
public void testComposeOfFunctionsIsAssociative() throws Exception {
  com.google.common.base.FunctionsTest testCase = new com.google.common.base.FunctionsTest();
  testCase.testComposeOfFunctionsIsAssociative();
}

public void testComposeOfPredicateAndFunctionIsAssociative() throws Exception {
  com.google.common.base.FunctionsTest testCase = new com.google.common.base.FunctionsTest();
  testCase.testComposeOfPredicateAndFunctionIsAssociative();
}

public void testComposition() throws Exception {
  com.google.common.base.FunctionsTest testCase = new com.google.common.base.FunctionsTest();
  testCase.testComposition();
}

public void testCompositionWildcard() throws Exception {
  com.google.common.base.FunctionsTest testCase = new com.google.common.base.FunctionsTest();
  testCase.testCompositionWildcard();
}

public void testConstant() throws Exception {
  com.google.common.base.FunctionsTest testCase = new com.google.common.base.FunctionsTest();
  testCase.testConstant();
}

public void testForMapWildCardWithDefault() throws Exception {
  com.google.common.base.FunctionsTest testCase = new com.google.common.base.FunctionsTest();
  testCase.testForMapWildCardWithDefault();
}

public void testForMapWithDefault() throws Exception {
  com.google.common.base.FunctionsTest testCase = new com.google.common.base.FunctionsTest();
  testCase.testForMapWithDefault();
}

public void testForMapWithDefault_null() throws Exception {
  com.google.common.base.FunctionsTest testCase = new com.google.common.base.FunctionsTest();
  testCase.testForMapWithDefault_null();
}

public void testForMapWithoutDefault() throws Exception {
  com.google.common.base.FunctionsTest testCase = new com.google.common.base.FunctionsTest();
  testCase.testForMapWithoutDefault();
}

public void testForPredicate() throws Exception {
  com.google.common.base.FunctionsTest testCase = new com.google.common.base.FunctionsTest();
  testCase.testForPredicate();
}

public void testForSupplier() throws Exception {
  com.google.common.base.FunctionsTest testCase = new com.google.common.base.FunctionsTest();
  testCase.testForSupplier();
}

public void testIdentity_notSame() throws Exception {
  com.google.common.base.FunctionsTest testCase = new com.google.common.base.FunctionsTest();
  testCase.testIdentity_notSame();
}

public void testIdentity_same() throws Exception {
  com.google.common.base.FunctionsTest testCase = new com.google.common.base.FunctionsTest();
  testCase.testIdentity_same();
}

public void testToStringFunction_apply() throws Exception {
  com.google.common.base.FunctionsTest testCase = new com.google.common.base.FunctionsTest();
  testCase.testToStringFunction_apply();
}
}
