//*****************************************************************************
//                             PnlNgSpiceDC.hpp                               *
//                            ------------------                              *
// Description : This class derives from the PnlAnaBase base class and        *
//               provides a GUI for a user to configure a DC Analysis for     *
//               NG-Spice electronic circuit simulator.                       *
// Started     : 08/05/2004                                                   *
// Last Update : 16/04/2010                                                   *
// Copyright   : (C) 2004 by M.S.Waters                                       *
// Email       : M.Waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef PNLNGSPICEDC_HPP
#define PNLNGSPICEDC_HPP

// System Includes


// wxWidgets Library Includes


// Application Includes

#include "base/PnlAnaBase.hpp"
#include "netlist/SimnNgSpice.hpp"

// Local Constant Declarations


//*****************************************************************************

class PnlNgSpiceDC : public PnlAnaBase
{
  public :

    // Enumerated type for specifying the sweep type
    enum  eSweepType
    {
      eSWP_CPNT = 0,
      eSWP_TEMP,

      eSWP_FST = eSWP_CPNT,
      eSWP_LST = eSWP_TEMP
    };

  private :

    // Sweep type
    wxRadioBox  m_oRbxSwpType;

    // Sweep source
    wxLabel     m_oLblSrcCpnt;

    void  Create( void );
    void  InitSwpType( void );
    void  InitSwpUnits( void );

  public :

    PnlNgSpiceDC( wxWindow * poWin );
   ~PnlNgSpiceDC( );

    bool  bClear( void );

    bool  bLoad( SimnNgSpice & roSimn );
    bool  bSave( SimnNgSpice & roSimn );

    // Event handlers
    void  OnSwpType( wxCommandEvent & roEvtCmd );
    void  OnSrcName( wxCommandEvent & roEvtCmd );

    // In order to be able to react to a menu command, it must be given a
    // unique identifier such as a const or an enum.
    enum ePnlItemID
    {
      ID_RBX_SWPTYPE = PnlAnaBase::ID_LST+1,

      ID_UNUSED,

      ID_FST = ID_RBX_SWPTYPE,
      ID_LST = ID_RBX_SWPTYPE
    };

    // Leave this as the last line as private access is envoked by macro
    DECLARE_EVENT_TABLE( )
};

//*****************************************************************************

#endif // PNLNGSPICEDC_HPP
