/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.integtests.samples

import org.gradle.integtests.fixtures.AbstractIntegrationSpec
import org.gradle.integtests.fixtures.Sample
import org.gradle.integtests.fixtures.UsesSample
import org.junit.Rule

class SamplesComponentMetadataRulesIntegrationTest extends AbstractIntegrationSpec {

    @Rule public final Sample sample = new Sample(temporaryFolder, 'componentMetadataRules')

    @UsesSample('componentMetadataRules')
    def "can run custom status scheme sample" () {
        given:
        inDirectory("componentMetadataRules")

        when:
        succeeds "listApi"

        then:
        output.contains("Resolved: api-2.0.jar")
    }

    @UsesSample('componentMetadataRules')
    def "can run custom status scheme with module sample" () {
        given:
        inDirectory("componentMetadataRules")

        when:
        succeeds "listLib"

        then:
        output.contains("Resolved: lib-1.9.jar")
    }

    @UsesSample('componentMetadataRules')
    def "can run custom status scheme with rule source sample" () {
        given:
        inDirectory("componentMetadataRules")

        when:
        succeeds "listWithRule"

        then:
        output.contains("Resolved: api-1.9.jar")
    }

    @UsesSample('componentMetadataRules')
    def "can run ivy metadata rule" () {
        given:
        inDirectory("componentMetadataRules")

        when:
        succeeds "listWithIvyRule"

        then:
        output.contains("Resolved: lib-2.0.jar")
    }
}
