/*
 * Decompiled with CFR 0.152.
 */
package com.dsi.ant.plugins.utility.uuid;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.provider.Settings;
import com.dsi.ant.plugins.utility.log.LogAnt;
import java.io.UnsupportedEncodingException;
import java.util.UUID;

public class UniqueIdGenerator {
    private static final String TAG = UniqueIdGenerator.class.getSimpleName();
    protected static final String PREFS_FILE = "device_id.xml";
    protected static final String PREFS_DEVICE_ID = "device_id";

    public static int getTwoByteUniqueId(Context context) {
        String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        try {
            UUID uuid;
            SharedPreferences prefs = context.getSharedPreferences(PREFS_FILE, 0);
            String id = prefs.getString(PREFS_DEVICE_ID, null);
            if (id != null) {
                uuid = UUID.fromString(id);
            } else {
                uuid = !"9774d56d682e549c".equals(androidId) ? UUID.nameUUIDFromBytes(androidId.getBytes("utf8")) : UUID.randomUUID();
                prefs.edit().putString(PREFS_DEVICE_ID, uuid.toString()).commit();
            }
            int generatedID = (int)(0xFFFFL & uuid.getLeastSignificantBits());
            return generatedID;
        }
        catch (UnsupportedEncodingException e) {
            LogAnt.e(context.getClass().getSimpleName(), "UnsupportedEncodingException trying to decode Andriod ID as utf8");
            return -1;
        }
    }

    public static long getFourByteUniqueId(Context context) {
        String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        try {
            UUID uuid;
            SharedPreferences prefs = context.getSharedPreferences(PREFS_FILE, 4);
            String id = prefs.getString(PREFS_DEVICE_ID, null);
            if (id != null) {
                uuid = UUID.fromString(id);
            } else {
                uuid = !"9774d56d682e549c".equals(androidId) ? UUID.nameUUIDFromBytes(androidId.getBytes("utf8")) : UUID.randomUUID();
                prefs.edit().putString(PREFS_DEVICE_ID, uuid.toString()).commit();
            }
            long generatedDeviceID = 0xFFFFFFFFL & uuid.getLeastSignificantBits();
            return generatedDeviceID;
        }
        catch (UnsupportedEncodingException e) {
            LogAnt.e(TAG, "UnsupportedEncodingException trying to decode Andriod ID as utf8");
            return -1L;
        }
    }
}

