---
title: "Examples"
date: 2019-11-15T23:25:46+01:00
draft: false
---

## CLI Examples

Assumes the `lego` binary has permission to bind to ports 80 and 443.
You can get a pre-built binary from the [releases](https://github.com/go-acme/lego/releases) page.
If your environment does not allow you to bind to these ports, please read [Port Usage](usage/cli#port-usage).

### Obtain a certificate

```bash
lego --email="foo@bar.com" --domains="example.com" --http run
```

You will find your certificate in the `.lego` folder of the current working directory:

```console
$ ls -1 ./.lego/certificates
example.com.crt
example.com.issuer.crt
example.com.json
example.com.key
[maybe more files for different domains...]
```

where

- `example.com.crt` is the server certificate (including the CA certificate),
- `example.com.key` is the private key needed for the server certificate,
- `example.com.issuer.crt` is the CA certificate, and
- `example.com.json` contains some JSON encoded meta information.

For each domain, you will have a set of these four files.
Please note, that for wildcard certificates (`*.example.com`), the filenames will look like `_.example.com.crt`.
The `.crt` and `.key` files are PEM encoded x509 certificates and private keys.
If you're looking for a `cert.pem` and `privkey.pem`, you can just use `example.com.crt` and `example.com.key`.


### Obtain a certificate (and hook)

The hook is executed only when the certificates are effectively created.

```bash
lego --email="foo@bar.com" --domains="example.com" --http run --run-hook="./myscript.sh"
```

Some information are added to the environment variables when the hook is used:

- `LEGO_ACCOUNT_EMAIL`: the email of the account.
- `LEGO_CERT_DOMAIN`: the main domain of the certificate.
- `LEGO_CERT_PATH`: the path of the certificate.
- `LEGO_CERT_KEY_PATH`: the path of the certificate key.

### To renew the certificate

```bash
lego --email="foo@bar.com" --domains="example.com" --http renew
```

### To renew the certificate only if it expires within 45 days

```bash
lego --email="foo@bar.com" --domains="example.com" --http renew --days 45
```

### To renew the certificate (and hook)

The hook is executed only when the certificates are effectively renewed.

```bash
lego --email="foo@bar.com" --domains="example.com" --http renew --renew-hook="./myscript.sh"
```

Some information are added to the environment variables when the hook is used:

- `LEGO_ACCOUNT_EMAIL`: the email of the account.
- `LEGO_CERT_DOMAIN`: the main domain of the certificate.
- `LEGO_CERT_PATH`: the path of the certificate.
- `LEGO_CERT_KEY_PATH`: the path of the certificate key.

### Obtain a certificate using the DNS challenge

```bash
AWS_REGION=us-east-1 \
AWS_ACCESS_KEY_ID=my_id \
AWS_SECRET_ACCESS_KEY=my_key \
lego --email="foo@bar.com" --domains="example.com" --dns="route53" run
```

### Obtain a certificate given a certificate signing request (CSR) generated by something else

```bash
lego --email="foo@bar.com" --http --csr=/path/to/csr.pem run
```

(lego will infer the domains to be validated based on the contents of the CSR, so make sure the CSR's Common Name and optional SubjectAltNames are set correctly.)

## Misc HTTP-01 CLI Examples

### Write HTTP-01 token to already "served" directory

If you have an existing server running on port 80 the `--http` option needs to also use the `--http.webroot` option.
This just writes the token to the given directory in the folder `.well-known/acme-challenge` and does not start a server.

The given directory **should** be publicly served as `/` on the domain(s) for the validation to complete.

If the given directory is not publicly served you will have to support rewriting the request to the directory;

You could also implement a rewrite to rewrite `.well-known/acme-challenge` to the given directory `.well-known/acme-challenge`.

You should be able to run an existing webserver on port 80 and have lego write the token file with the HTTP-01 challenge key authorization to `<webroot dir>/.well-known/acme-challenge/` by running something like:

```bash
lego --accept-tos -m foo@bar.com --http --http.webroot /path/to/webroot -d example.com run
```
