// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: executor/executor.proto

/*
	Package executor is a generated protocol buffer package.

	It is generated from these files:
		executor/executor.proto

	It has these top-level messages:
		Event
		Call
*/
package executor

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import mesos "github.com/mesos/mesos-go/api/v1/lib"
import _ "github.com/gogo/protobuf/gogoproto"

import strconv "strconv"

import bytes "bytes"

import strings "strings"
import reflect "reflect"

import github_com_gogo_protobuf_proto "github.com/gogo/protobuf/proto"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Possible event types, followed by message definitions if
// applicable.
type Event_Type int32

const (
	// This must be the first enum value in this list, to
	// ensure that if 'type' is not set, the default value
	// is UNKNOWN. This enables enum values to be added
	// in a backwards-compatible way. See: MESOS-4997.
	Event_UNKNOWN      Event_Type = 0
	Event_SUBSCRIBED   Event_Type = 1
	Event_LAUNCH       Event_Type = 2
	Event_LAUNCH_GROUP Event_Type = 8
	Event_KILL         Event_Type = 3
	Event_ACKNOWLEDGED Event_Type = 4
	Event_MESSAGE      Event_Type = 5
	Event_ERROR        Event_Type = 6
	// Received when the agent asks the executor to shutdown/kill itself.
	// The executor is then required to kill all its active tasks, send
	// `TASK_KILLED` status updates and gracefully exit. The executor
	// should terminate within a `MESOS_EXECUTOR_SHUTDOWN_GRACE_PERIOD`
	// (an environment variable set by the agent upon executor startup);
	// it can be configured via `ExecutorInfo.shutdown_grace_period`. If
	// the executor fails to do so, the agent will forcefully destroy the
	// container where the executor is running. The agent would then send
	// `TASK_LOST` updates for any remaining active tasks of this executor.
	//
	// NOTE: The executor must not assume that it will always be allotted
	// the full grace period, as the agent may decide to allot a shorter
	// period and failures / forcible terminations may occur.
	//
	// TODO(alexr): Consider adding a duration field into the `Shutdown`
	// message so that the agent can communicate when a shorter period
	// has been allotted.
	Event_SHUTDOWN Event_Type = 7
)

var Event_Type_name = map[int32]string{
	0: "UNKNOWN",
	1: "SUBSCRIBED",
	2: "LAUNCH",
	8: "LAUNCH_GROUP",
	3: "KILL",
	4: "ACKNOWLEDGED",
	5: "MESSAGE",
	6: "ERROR",
	7: "SHUTDOWN",
}
var Event_Type_value = map[string]int32{
	"UNKNOWN":      0,
	"SUBSCRIBED":   1,
	"LAUNCH":       2,
	"LAUNCH_GROUP": 8,
	"KILL":         3,
	"ACKNOWLEDGED": 4,
	"MESSAGE":      5,
	"ERROR":        6,
	"SHUTDOWN":     7,
}

func (x Event_Type) Enum() *Event_Type {
	p := new(Event_Type)
	*p = x
	return p
}
func (x Event_Type) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(Event_Type_name, int32(x))
}
func (x *Event_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Event_Type_value, data, "Event_Type")
	if err != nil {
		return err
	}
	*x = Event_Type(value)
	return nil
}
func (Event_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptorExecutor, []int{0, 0} }

// Possible call types, followed by message definitions if
// applicable.
type Call_Type int32

const (
	// See comments above on `Event::Type` for more details on this enum value.
	Call_UNKNOWN   Call_Type = 0
	Call_SUBSCRIBE Call_Type = 1
	Call_UPDATE    Call_Type = 2
	Call_MESSAGE   Call_Type = 3
)

var Call_Type_name = map[int32]string{
	0: "UNKNOWN",
	1: "SUBSCRIBE",
	2: "UPDATE",
	3: "MESSAGE",
}
var Call_Type_value = map[string]int32{
	"UNKNOWN":   0,
	"SUBSCRIBE": 1,
	"UPDATE":    2,
	"MESSAGE":   3,
}

func (x Call_Type) Enum() *Call_Type {
	p := new(Call_Type)
	*p = x
	return p
}
func (x Call_Type) MarshalJSON() ([]byte, error) {
	return proto.MarshalJSONEnum(Call_Type_name, int32(x))
}
func (x *Call_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Call_Type_value, data, "Call_Type")
	if err != nil {
		return err
	}
	*x = Call_Type(value)
	return nil
}
func (Call_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptorExecutor, []int{1, 0} }

// *
// Executor event API.
//
// An event is described using the standard protocol buffer "union"
// trick, see https://developers.google.com/protocol-buffers/docs/techniques#union.
type Event struct {
	// Type of the event, indicates which optional field below should be
	// present if that type has a nested message definition.
	// Enum fields should be optional, see: MESOS-4997.
	Type         Event_Type          `protobuf:"varint,1,opt,name=type,enum=mesos.executor.Event_Type" json:"type"`
	Subscribed   *Event_Subscribed   `protobuf:"bytes,2,opt,name=subscribed" json:"subscribed,omitempty"`
	Acknowledged *Event_Acknowledged `protobuf:"bytes,3,opt,name=acknowledged" json:"acknowledged,omitempty"`
	Launch       *Event_Launch       `protobuf:"bytes,4,opt,name=launch" json:"launch,omitempty"`
	LaunchGroup  *Event_LaunchGroup  `protobuf:"bytes,8,opt,name=launch_group,json=launchGroup" json:"launch_group,omitempty"`
	Kill         *Event_Kill         `protobuf:"bytes,5,opt,name=kill" json:"kill,omitempty"`
	Message      *Event_Message      `protobuf:"bytes,6,opt,name=message" json:"message,omitempty"`
	Error        *Event_Error        `protobuf:"bytes,7,opt,name=error" json:"error,omitempty"`
}

func (m *Event) Reset()                    { *m = Event{} }
func (*Event) ProtoMessage()               {}
func (*Event) Descriptor() ([]byte, []int) { return fileDescriptorExecutor, []int{0} }

func (m *Event) GetType() Event_Type {
	if m != nil {
		return m.Type
	}
	return Event_UNKNOWN
}

func (m *Event) GetSubscribed() *Event_Subscribed {
	if m != nil {
		return m.Subscribed
	}
	return nil
}

func (m *Event) GetAcknowledged() *Event_Acknowledged {
	if m != nil {
		return m.Acknowledged
	}
	return nil
}

func (m *Event) GetLaunch() *Event_Launch {
	if m != nil {
		return m.Launch
	}
	return nil
}

func (m *Event) GetLaunchGroup() *Event_LaunchGroup {
	if m != nil {
		return m.LaunchGroup
	}
	return nil
}

func (m *Event) GetKill() *Event_Kill {
	if m != nil {
		return m.Kill
	}
	return nil
}

func (m *Event) GetMessage() *Event_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (m *Event) GetError() *Event_Error {
	if m != nil {
		return m.Error
	}
	return nil
}

// First event received when the executor subscribes.
// The 'id' field in the 'framework_info' will be set.
type Event_Subscribed struct {
	ExecutorInfo  mesos.ExecutorInfo  `protobuf:"bytes,1,req,name=executor_info,json=executorInfo" json:"executor_info"`
	FrameworkInfo mesos.FrameworkInfo `protobuf:"bytes,2,req,name=framework_info,json=frameworkInfo" json:"framework_info"`
	AgentInfo     mesos.AgentInfo     `protobuf:"bytes,3,req,name=agent_info,json=agentInfo" json:"agent_info"`
	// Uniquely identifies the container of an executor run.
	ContainerID *mesos.ContainerID `protobuf:"bytes,4,opt,name=container_id,json=containerId" json:"container_id,omitempty"`
}

func (m *Event_Subscribed) Reset()                    { *m = Event_Subscribed{} }
func (*Event_Subscribed) ProtoMessage()               {}
func (*Event_Subscribed) Descriptor() ([]byte, []int) { return fileDescriptorExecutor, []int{0, 0} }

func (m *Event_Subscribed) GetExecutorInfo() mesos.ExecutorInfo {
	if m != nil {
		return m.ExecutorInfo
	}
	return mesos.ExecutorInfo{}
}

func (m *Event_Subscribed) GetFrameworkInfo() mesos.FrameworkInfo {
	if m != nil {
		return m.FrameworkInfo
	}
	return mesos.FrameworkInfo{}
}

func (m *Event_Subscribed) GetAgentInfo() mesos.AgentInfo {
	if m != nil {
		return m.AgentInfo
	}
	return mesos.AgentInfo{}
}

func (m *Event_Subscribed) GetContainerID() *mesos.ContainerID {
	if m != nil {
		return m.ContainerID
	}
	return nil
}

// Received when the framework attempts to launch a task. Once
// the task is successfully launched, the executor must respond with
// a TASK_RUNNING update (See TaskState in v1/mesos.proto).
type Event_Launch struct {
	Task mesos.TaskInfo `protobuf:"bytes,1,req,name=task" json:"task"`
}

func (m *Event_Launch) Reset()                    { *m = Event_Launch{} }
func (*Event_Launch) ProtoMessage()               {}
func (*Event_Launch) Descriptor() ([]byte, []int) { return fileDescriptorExecutor, []int{0, 1} }

func (m *Event_Launch) GetTask() mesos.TaskInfo {
	if m != nil {
		return m.Task
	}
	return mesos.TaskInfo{}
}

// Received when the framework attempts to launch a group of tasks atomically.
// Similar to `Launch` above the executor must send TASK_RUNNING updates for
// tasks that are successfully launched.
type Event_LaunchGroup struct {
	TaskGroup mesos.TaskGroupInfo `protobuf:"bytes,1,req,name=task_group,json=taskGroup" json:"task_group"`
}

func (m *Event_LaunchGroup) Reset()                    { *m = Event_LaunchGroup{} }
func (*Event_LaunchGroup) ProtoMessage()               {}
func (*Event_LaunchGroup) Descriptor() ([]byte, []int) { return fileDescriptorExecutor, []int{0, 2} }

func (m *Event_LaunchGroup) GetTaskGroup() mesos.TaskGroupInfo {
	if m != nil {
		return m.TaskGroup
	}
	return mesos.TaskGroupInfo{}
}

// Received when the scheduler wants to kill a specific task. Once
// the task is terminated, the executor should send a TASK_KILLED
// (or TASK_FAILED) update. The terminal update is necessary so
// Mesos can release the resources associated with the task.
type Event_Kill struct {
	TaskID mesos.TaskID `protobuf:"bytes,1,req,name=task_id,json=taskId" json:"task_id"`
	// If set, overrides any previously specified kill policy for this task.
	// This includes 'TaskInfo.kill_policy' and 'Executor.kill.kill_policy'.
	// Can be used to forcefully kill a task which is already being killed.
	KillPolicy *mesos.KillPolicy `protobuf:"bytes,2,opt,name=kill_policy,json=killPolicy" json:"kill_policy,omitempty"`
}

func (m *Event_Kill) Reset()                    { *m = Event_Kill{} }
func (*Event_Kill) ProtoMessage()               {}
func (*Event_Kill) Descriptor() ([]byte, []int) { return fileDescriptorExecutor, []int{0, 3} }

func (m *Event_Kill) GetTaskID() mesos.TaskID {
	if m != nil {
		return m.TaskID
	}
	return mesos.TaskID{}
}

func (m *Event_Kill) GetKillPolicy() *mesos.KillPolicy {
	if m != nil {
		return m.KillPolicy
	}
	return nil
}

// Received when the agent acknowledges the receipt of status
// update. Schedulers are responsible for explicitly acknowledging
// the receipt of status updates that have 'update.status().uuid()'
// field set. Unacknowledged updates can be retried by the executor.
// They should also be sent by the executor whenever it
// re-subscribes.
type Event_Acknowledged struct {
	TaskID mesos.TaskID `protobuf:"bytes,1,req,name=task_id,json=taskId" json:"task_id"`
	UUID   []byte       `protobuf:"bytes,2,req,name=uuid" json:"uuid,omitempty"`
}

func (m *Event_Acknowledged) Reset()                    { *m = Event_Acknowledged{} }
func (*Event_Acknowledged) ProtoMessage()               {}
func (*Event_Acknowledged) Descriptor() ([]byte, []int) { return fileDescriptorExecutor, []int{0, 4} }

func (m *Event_Acknowledged) GetTaskID() mesos.TaskID {
	if m != nil {
		return m.TaskID
	}
	return mesos.TaskID{}
}

func (m *Event_Acknowledged) GetUUID() []byte {
	if m != nil {
		return m.UUID
	}
	return nil
}

// Received when a custom message generated by the scheduler is
// forwarded by the agent. Note that this message is not
// interpreted by Mesos and is only forwarded (without reliability
// guarantees) to the executor. It is up to the scheduler to retry
// if the message is dropped for any reason.
type Event_Message struct {
	Data []byte `protobuf:"bytes,1,req,name=data" json:"data,omitempty"`
}

func (m *Event_Message) Reset()                    { *m = Event_Message{} }
func (*Event_Message) ProtoMessage()               {}
func (*Event_Message) Descriptor() ([]byte, []int) { return fileDescriptorExecutor, []int{0, 5} }

func (m *Event_Message) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// Received in case the executor sends invalid calls (e.g.,
// required values not set).
// TODO(arojas): Remove this once the old executor driver is no
// longer supported. With HTTP API all errors will be signaled via
// HTTP response codes.
type Event_Error struct {
	Message string `protobuf:"bytes,1,req,name=message" json:"message"`
}

func (m *Event_Error) Reset()                    { *m = Event_Error{} }
func (*Event_Error) ProtoMessage()               {}
func (*Event_Error) Descriptor() ([]byte, []int) { return fileDescriptorExecutor, []int{0, 6} }

func (m *Event_Error) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// *
// Executor call API.
//
// Like Event, a Call is described using the standard protocol buffer
// "union" trick (see above).
type Call struct {
	// Identifies the executor which generated this call.
	ExecutorID  mesos.ExecutorID  `protobuf:"bytes,1,req,name=executor_id,json=executorId" json:"executor_id"`
	FrameworkID mesos.FrameworkID `protobuf:"bytes,2,req,name=framework_id,json=frameworkId" json:"framework_id"`
	// Type of the call, indicates which optional field below should be
	// present if that type has a nested message definition.
	// In case type is SUBSCRIBED, no message needs to be set.
	// See comments on `Event::Type` above on the reasoning behind this
	// field being optional.
	Type      Call_Type       `protobuf:"varint,3,opt,name=type,enum=mesos.executor.Call_Type" json:"type"`
	Subscribe *Call_Subscribe `protobuf:"bytes,4,opt,name=subscribe" json:"subscribe,omitempty"`
	Update    *Call_Update    `protobuf:"bytes,5,opt,name=update" json:"update,omitempty"`
	Message   *Call_Message   `protobuf:"bytes,6,opt,name=message" json:"message,omitempty"`
}

func (m *Call) Reset()                    { *m = Call{} }
func (*Call) ProtoMessage()               {}
func (*Call) Descriptor() ([]byte, []int) { return fileDescriptorExecutor, []int{1} }

func (m *Call) GetExecutorID() mesos.ExecutorID {
	if m != nil {
		return m.ExecutorID
	}
	return mesos.ExecutorID{}
}

func (m *Call) GetFrameworkID() mesos.FrameworkID {
	if m != nil {
		return m.FrameworkID
	}
	return mesos.FrameworkID{}
}

func (m *Call) GetType() Call_Type {
	if m != nil {
		return m.Type
	}
	return Call_UNKNOWN
}

func (m *Call) GetSubscribe() *Call_Subscribe {
	if m != nil {
		return m.Subscribe
	}
	return nil
}

func (m *Call) GetUpdate() *Call_Update {
	if m != nil {
		return m.Update
	}
	return nil
}

func (m *Call) GetMessage() *Call_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

// Request to subscribe with the agent. If subscribing after a disconnection,
// it must include a list of all the tasks and updates which haven't been
// acknowledged by the scheduler.
type Call_Subscribe struct {
	UnacknowledgedTasks   []mesos.TaskInfo `protobuf:"bytes,1,rep,name=unacknowledged_tasks,json=unacknowledgedTasks" json:"unacknowledged_tasks"`
	UnacknowledgedUpdates []Call_Update    `protobuf:"bytes,2,rep,name=unacknowledged_updates,json=unacknowledgedUpdates" json:"unacknowledged_updates"`
}

func (m *Call_Subscribe) Reset()                    { *m = Call_Subscribe{} }
func (*Call_Subscribe) ProtoMessage()               {}
func (*Call_Subscribe) Descriptor() ([]byte, []int) { return fileDescriptorExecutor, []int{1, 0} }

func (m *Call_Subscribe) GetUnacknowledgedTasks() []mesos.TaskInfo {
	if m != nil {
		return m.UnacknowledgedTasks
	}
	return nil
}

func (m *Call_Subscribe) GetUnacknowledgedUpdates() []Call_Update {
	if m != nil {
		return m.UnacknowledgedUpdates
	}
	return nil
}

// Notifies the scheduler that a task has transitioned from one
// state to another. Status updates should be used by executors
// to reliably communicate the status of the tasks that they
// manage. It is crucial that a terminal update (see TaskState
// in v1/mesos.proto) is sent to the scheduler as soon as the task
// terminates, in order for Mesos to release the resources allocated
// to the task. It is the responsibility of the scheduler to
// explicitly acknowledge the receipt of a status update. See
// 'Acknowledged' in the 'Events' section above for the semantics.
type Call_Update struct {
	Status mesos.TaskStatus `protobuf:"bytes,1,req,name=status" json:"status"`
}

func (m *Call_Update) Reset()                    { *m = Call_Update{} }
func (*Call_Update) ProtoMessage()               {}
func (*Call_Update) Descriptor() ([]byte, []int) { return fileDescriptorExecutor, []int{1, 1} }

func (m *Call_Update) GetStatus() mesos.TaskStatus {
	if m != nil {
		return m.Status
	}
	return mesos.TaskStatus{}
}

// Sends arbitrary binary data to the scheduler. Note that Mesos
// neither interprets this data nor makes any guarantees about the
// delivery of this message to the scheduler.
// See 'Message' in the 'Events' section.
type Call_Message struct {
	Data []byte `protobuf:"bytes,2,req,name=data" json:"data,omitempty"`
}

func (m *Call_Message) Reset()                    { *m = Call_Message{} }
func (*Call_Message) ProtoMessage()               {}
func (*Call_Message) Descriptor() ([]byte, []int) { return fileDescriptorExecutor, []int{1, 2} }

func (m *Call_Message) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func init() {
	proto.RegisterType((*Event)(nil), "mesos.executor.Event")
	proto.RegisterType((*Event_Subscribed)(nil), "mesos.executor.Event.Subscribed")
	proto.RegisterType((*Event_Launch)(nil), "mesos.executor.Event.Launch")
	proto.RegisterType((*Event_LaunchGroup)(nil), "mesos.executor.Event.LaunchGroup")
	proto.RegisterType((*Event_Kill)(nil), "mesos.executor.Event.Kill")
	proto.RegisterType((*Event_Acknowledged)(nil), "mesos.executor.Event.Acknowledged")
	proto.RegisterType((*Event_Message)(nil), "mesos.executor.Event.Message")
	proto.RegisterType((*Event_Error)(nil), "mesos.executor.Event.Error")
	proto.RegisterType((*Call)(nil), "mesos.executor.Call")
	proto.RegisterType((*Call_Subscribe)(nil), "mesos.executor.Call.Subscribe")
	proto.RegisterType((*Call_Update)(nil), "mesos.executor.Call.Update")
	proto.RegisterType((*Call_Message)(nil), "mesos.executor.Call.Message")
	proto.RegisterEnum("mesos.executor.Event_Type", Event_Type_name, Event_Type_value)
	proto.RegisterEnum("mesos.executor.Call_Type", Call_Type_name, Call_Type_value)
}
func (x Event_Type) String() string {
	s, ok := Event_Type_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x Call_Type) String() string {
	s, ok := Call_Type_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (this *Event) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Event)
	if !ok {
		that2, ok := that.(Event)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Event")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Event but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Event but is not nil && this == nil")
	}
	if this.Type != that1.Type {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.Subscribed.Equal(that1.Subscribed) {
		return fmt.Errorf("Subscribed this(%v) Not Equal that(%v)", this.Subscribed, that1.Subscribed)
	}
	if !this.Acknowledged.Equal(that1.Acknowledged) {
		return fmt.Errorf("Acknowledged this(%v) Not Equal that(%v)", this.Acknowledged, that1.Acknowledged)
	}
	if !this.Launch.Equal(that1.Launch) {
		return fmt.Errorf("Launch this(%v) Not Equal that(%v)", this.Launch, that1.Launch)
	}
	if !this.LaunchGroup.Equal(that1.LaunchGroup) {
		return fmt.Errorf("LaunchGroup this(%v) Not Equal that(%v)", this.LaunchGroup, that1.LaunchGroup)
	}
	if !this.Kill.Equal(that1.Kill) {
		return fmt.Errorf("Kill this(%v) Not Equal that(%v)", this.Kill, that1.Kill)
	}
	if !this.Message.Equal(that1.Message) {
		return fmt.Errorf("Message this(%v) Not Equal that(%v)", this.Message, that1.Message)
	}
	if !this.Error.Equal(that1.Error) {
		return fmt.Errorf("Error this(%v) Not Equal that(%v)", this.Error, that1.Error)
	}
	return nil
}
func (this *Event) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Event)
	if !ok {
		that2, ok := that.(Event)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if !this.Subscribed.Equal(that1.Subscribed) {
		return false
	}
	if !this.Acknowledged.Equal(that1.Acknowledged) {
		return false
	}
	if !this.Launch.Equal(that1.Launch) {
		return false
	}
	if !this.LaunchGroup.Equal(that1.LaunchGroup) {
		return false
	}
	if !this.Kill.Equal(that1.Kill) {
		return false
	}
	if !this.Message.Equal(that1.Message) {
		return false
	}
	if !this.Error.Equal(that1.Error) {
		return false
	}
	return true
}
func (this *Event_Subscribed) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Event_Subscribed)
	if !ok {
		that2, ok := that.(Event_Subscribed)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Event_Subscribed")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Event_Subscribed but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Event_Subscribed but is not nil && this == nil")
	}
	if !this.ExecutorInfo.Equal(&that1.ExecutorInfo) {
		return fmt.Errorf("ExecutorInfo this(%v) Not Equal that(%v)", this.ExecutorInfo, that1.ExecutorInfo)
	}
	if !this.FrameworkInfo.Equal(&that1.FrameworkInfo) {
		return fmt.Errorf("FrameworkInfo this(%v) Not Equal that(%v)", this.FrameworkInfo, that1.FrameworkInfo)
	}
	if !this.AgentInfo.Equal(&that1.AgentInfo) {
		return fmt.Errorf("AgentInfo this(%v) Not Equal that(%v)", this.AgentInfo, that1.AgentInfo)
	}
	if !this.ContainerID.Equal(that1.ContainerID) {
		return fmt.Errorf("ContainerID this(%v) Not Equal that(%v)", this.ContainerID, that1.ContainerID)
	}
	return nil
}
func (this *Event_Subscribed) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Event_Subscribed)
	if !ok {
		that2, ok := that.(Event_Subscribed)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.ExecutorInfo.Equal(&that1.ExecutorInfo) {
		return false
	}
	if !this.FrameworkInfo.Equal(&that1.FrameworkInfo) {
		return false
	}
	if !this.AgentInfo.Equal(&that1.AgentInfo) {
		return false
	}
	if !this.ContainerID.Equal(that1.ContainerID) {
		return false
	}
	return true
}
func (this *Event_Launch) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Event_Launch)
	if !ok {
		that2, ok := that.(Event_Launch)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Event_Launch")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Event_Launch but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Event_Launch but is not nil && this == nil")
	}
	if !this.Task.Equal(&that1.Task) {
		return fmt.Errorf("Task this(%v) Not Equal that(%v)", this.Task, that1.Task)
	}
	return nil
}
func (this *Event_Launch) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Event_Launch)
	if !ok {
		that2, ok := that.(Event_Launch)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Task.Equal(&that1.Task) {
		return false
	}
	return true
}
func (this *Event_LaunchGroup) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Event_LaunchGroup)
	if !ok {
		that2, ok := that.(Event_LaunchGroup)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Event_LaunchGroup")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Event_LaunchGroup but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Event_LaunchGroup but is not nil && this == nil")
	}
	if !this.TaskGroup.Equal(&that1.TaskGroup) {
		return fmt.Errorf("TaskGroup this(%v) Not Equal that(%v)", this.TaskGroup, that1.TaskGroup)
	}
	return nil
}
func (this *Event_LaunchGroup) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Event_LaunchGroup)
	if !ok {
		that2, ok := that.(Event_LaunchGroup)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.TaskGroup.Equal(&that1.TaskGroup) {
		return false
	}
	return true
}
func (this *Event_Kill) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Event_Kill)
	if !ok {
		that2, ok := that.(Event_Kill)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Event_Kill")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Event_Kill but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Event_Kill but is not nil && this == nil")
	}
	if !this.TaskID.Equal(&that1.TaskID) {
		return fmt.Errorf("TaskID this(%v) Not Equal that(%v)", this.TaskID, that1.TaskID)
	}
	if !this.KillPolicy.Equal(that1.KillPolicy) {
		return fmt.Errorf("KillPolicy this(%v) Not Equal that(%v)", this.KillPolicy, that1.KillPolicy)
	}
	return nil
}
func (this *Event_Kill) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Event_Kill)
	if !ok {
		that2, ok := that.(Event_Kill)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.TaskID.Equal(&that1.TaskID) {
		return false
	}
	if !this.KillPolicy.Equal(that1.KillPolicy) {
		return false
	}
	return true
}
func (this *Event_Acknowledged) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Event_Acknowledged)
	if !ok {
		that2, ok := that.(Event_Acknowledged)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Event_Acknowledged")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Event_Acknowledged but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Event_Acknowledged but is not nil && this == nil")
	}
	if !this.TaskID.Equal(&that1.TaskID) {
		return fmt.Errorf("TaskID this(%v) Not Equal that(%v)", this.TaskID, that1.TaskID)
	}
	if !bytes.Equal(this.UUID, that1.UUID) {
		return fmt.Errorf("UUID this(%v) Not Equal that(%v)", this.UUID, that1.UUID)
	}
	return nil
}
func (this *Event_Acknowledged) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Event_Acknowledged)
	if !ok {
		that2, ok := that.(Event_Acknowledged)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.TaskID.Equal(&that1.TaskID) {
		return false
	}
	if !bytes.Equal(this.UUID, that1.UUID) {
		return false
	}
	return true
}
func (this *Event_Message) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Event_Message)
	if !ok {
		that2, ok := that.(Event_Message)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Event_Message")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Event_Message but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Event_Message but is not nil && this == nil")
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return fmt.Errorf("Data this(%v) Not Equal that(%v)", this.Data, that1.Data)
	}
	return nil
}
func (this *Event_Message) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Event_Message)
	if !ok {
		that2, ok := that.(Event_Message)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return false
	}
	return true
}
func (this *Event_Error) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Event_Error)
	if !ok {
		that2, ok := that.(Event_Error)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Event_Error")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Event_Error but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Event_Error but is not nil && this == nil")
	}
	if this.Message != that1.Message {
		return fmt.Errorf("Message this(%v) Not Equal that(%v)", this.Message, that1.Message)
	}
	return nil
}
func (this *Event_Error) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Event_Error)
	if !ok {
		that2, ok := that.(Event_Error)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Message != that1.Message {
		return false
	}
	return true
}
func (this *Call) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call)
	if !ok {
		that2, ok := that.(Call)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call but is not nil && this == nil")
	}
	if !this.ExecutorID.Equal(&that1.ExecutorID) {
		return fmt.Errorf("ExecutorID this(%v) Not Equal that(%v)", this.ExecutorID, that1.ExecutorID)
	}
	if !this.FrameworkID.Equal(&that1.FrameworkID) {
		return fmt.Errorf("FrameworkID this(%v) Not Equal that(%v)", this.FrameworkID, that1.FrameworkID)
	}
	if this.Type != that1.Type {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.Subscribe.Equal(that1.Subscribe) {
		return fmt.Errorf("Subscribe this(%v) Not Equal that(%v)", this.Subscribe, that1.Subscribe)
	}
	if !this.Update.Equal(that1.Update) {
		return fmt.Errorf("Update this(%v) Not Equal that(%v)", this.Update, that1.Update)
	}
	if !this.Message.Equal(that1.Message) {
		return fmt.Errorf("Message this(%v) Not Equal that(%v)", this.Message, that1.Message)
	}
	return nil
}
func (this *Call) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call)
	if !ok {
		that2, ok := that.(Call)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.ExecutorID.Equal(&that1.ExecutorID) {
		return false
	}
	if !this.FrameworkID.Equal(&that1.FrameworkID) {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if !this.Subscribe.Equal(that1.Subscribe) {
		return false
	}
	if !this.Update.Equal(that1.Update) {
		return false
	}
	if !this.Message.Equal(that1.Message) {
		return false
	}
	return true
}
func (this *Call_Subscribe) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_Subscribe)
	if !ok {
		that2, ok := that.(Call_Subscribe)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_Subscribe")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_Subscribe but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_Subscribe but is not nil && this == nil")
	}
	if len(this.UnacknowledgedTasks) != len(that1.UnacknowledgedTasks) {
		return fmt.Errorf("UnacknowledgedTasks this(%v) Not Equal that(%v)", len(this.UnacknowledgedTasks), len(that1.UnacknowledgedTasks))
	}
	for i := range this.UnacknowledgedTasks {
		if !this.UnacknowledgedTasks[i].Equal(&that1.UnacknowledgedTasks[i]) {
			return fmt.Errorf("UnacknowledgedTasks this[%v](%v) Not Equal that[%v](%v)", i, this.UnacknowledgedTasks[i], i, that1.UnacknowledgedTasks[i])
		}
	}
	if len(this.UnacknowledgedUpdates) != len(that1.UnacknowledgedUpdates) {
		return fmt.Errorf("UnacknowledgedUpdates this(%v) Not Equal that(%v)", len(this.UnacknowledgedUpdates), len(that1.UnacknowledgedUpdates))
	}
	for i := range this.UnacknowledgedUpdates {
		if !this.UnacknowledgedUpdates[i].Equal(&that1.UnacknowledgedUpdates[i]) {
			return fmt.Errorf("UnacknowledgedUpdates this[%v](%v) Not Equal that[%v](%v)", i, this.UnacknowledgedUpdates[i], i, that1.UnacknowledgedUpdates[i])
		}
	}
	return nil
}
func (this *Call_Subscribe) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_Subscribe)
	if !ok {
		that2, ok := that.(Call_Subscribe)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.UnacknowledgedTasks) != len(that1.UnacknowledgedTasks) {
		return false
	}
	for i := range this.UnacknowledgedTasks {
		if !this.UnacknowledgedTasks[i].Equal(&that1.UnacknowledgedTasks[i]) {
			return false
		}
	}
	if len(this.UnacknowledgedUpdates) != len(that1.UnacknowledgedUpdates) {
		return false
	}
	for i := range this.UnacknowledgedUpdates {
		if !this.UnacknowledgedUpdates[i].Equal(&that1.UnacknowledgedUpdates[i]) {
			return false
		}
	}
	return true
}
func (this *Call_Update) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_Update)
	if !ok {
		that2, ok := that.(Call_Update)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_Update")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_Update but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_Update but is not nil && this == nil")
	}
	if !this.Status.Equal(&that1.Status) {
		return fmt.Errorf("Status this(%v) Not Equal that(%v)", this.Status, that1.Status)
	}
	return nil
}
func (this *Call_Update) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_Update)
	if !ok {
		that2, ok := that.(Call_Update)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Status.Equal(&that1.Status) {
		return false
	}
	return true
}
func (this *Call_Message) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Call_Message)
	if !ok {
		that2, ok := that.(Call_Message)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *Call_Message")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Call_Message but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Call_Message but is not nil && this == nil")
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return fmt.Errorf("Data this(%v) Not Equal that(%v)", this.Data, that1.Data)
	}
	return nil
}
func (this *Call_Message) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Call_Message)
	if !ok {
		that2, ok := that.(Call_Message)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.Data, that1.Data) {
		return false
	}
	return true
}
func (this *Event) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 12)
	s = append(s, "&executor.Event{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	if this.Subscribed != nil {
		s = append(s, "Subscribed: "+fmt.Sprintf("%#v", this.Subscribed)+",\n")
	}
	if this.Acknowledged != nil {
		s = append(s, "Acknowledged: "+fmt.Sprintf("%#v", this.Acknowledged)+",\n")
	}
	if this.Launch != nil {
		s = append(s, "Launch: "+fmt.Sprintf("%#v", this.Launch)+",\n")
	}
	if this.LaunchGroup != nil {
		s = append(s, "LaunchGroup: "+fmt.Sprintf("%#v", this.LaunchGroup)+",\n")
	}
	if this.Kill != nil {
		s = append(s, "Kill: "+fmt.Sprintf("%#v", this.Kill)+",\n")
	}
	if this.Message != nil {
		s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	}
	if this.Error != nil {
		s = append(s, "Error: "+fmt.Sprintf("%#v", this.Error)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Event_Subscribed) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&executor.Event_Subscribed{")
	s = append(s, "ExecutorInfo: "+strings.Replace(this.ExecutorInfo.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "FrameworkInfo: "+strings.Replace(this.FrameworkInfo.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "AgentInfo: "+strings.Replace(this.AgentInfo.GoString(), `&`, ``, 1)+",\n")
	if this.ContainerID != nil {
		s = append(s, "ContainerID: "+fmt.Sprintf("%#v", this.ContainerID)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Event_Launch) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&executor.Event_Launch{")
	s = append(s, "Task: "+strings.Replace(this.Task.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Event_LaunchGroup) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&executor.Event_LaunchGroup{")
	s = append(s, "TaskGroup: "+strings.Replace(this.TaskGroup.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Event_Kill) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&executor.Event_Kill{")
	s = append(s, "TaskID: "+strings.Replace(this.TaskID.GoString(), `&`, ``, 1)+",\n")
	if this.KillPolicy != nil {
		s = append(s, "KillPolicy: "+fmt.Sprintf("%#v", this.KillPolicy)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Event_Acknowledged) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&executor.Event_Acknowledged{")
	s = append(s, "TaskID: "+strings.Replace(this.TaskID.GoString(), `&`, ``, 1)+",\n")
	if this.UUID != nil {
		s = append(s, "UUID: "+valueToGoStringExecutor(this.UUID, "byte")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Event_Message) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&executor.Event_Message{")
	if this.Data != nil {
		s = append(s, "Data: "+valueToGoStringExecutor(this.Data, "byte")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Event_Error) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&executor.Event_Error{")
	s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&executor.Call{")
	s = append(s, "ExecutorID: "+strings.Replace(this.ExecutorID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "FrameworkID: "+strings.Replace(this.FrameworkID.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	if this.Subscribe != nil {
		s = append(s, "Subscribe: "+fmt.Sprintf("%#v", this.Subscribe)+",\n")
	}
	if this.Update != nil {
		s = append(s, "Update: "+fmt.Sprintf("%#v", this.Update)+",\n")
	}
	if this.Message != nil {
		s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_Subscribe) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&executor.Call_Subscribe{")
	if this.UnacknowledgedTasks != nil {
		s = append(s, "UnacknowledgedTasks: "+fmt.Sprintf("%#v", this.UnacknowledgedTasks)+",\n")
	}
	if this.UnacknowledgedUpdates != nil {
		s = append(s, "UnacknowledgedUpdates: "+fmt.Sprintf("%#v", this.UnacknowledgedUpdates)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_Update) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&executor.Call_Update{")
	s = append(s, "Status: "+strings.Replace(this.Status.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Call_Message) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&executor.Call_Message{")
	if this.Data != nil {
		s = append(s, "Data: "+valueToGoStringExecutor(this.Data, "byte")+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringExecutor(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *Event) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintExecutor(dAtA, i, uint64(m.Type))
	if m.Subscribed != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintExecutor(dAtA, i, uint64(m.Subscribed.ProtoSize()))
		n1, err := m.Subscribed.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.Acknowledged != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintExecutor(dAtA, i, uint64(m.Acknowledged.ProtoSize()))
		n2, err := m.Acknowledged.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.Launch != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintExecutor(dAtA, i, uint64(m.Launch.ProtoSize()))
		n3, err := m.Launch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.Kill != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintExecutor(dAtA, i, uint64(m.Kill.ProtoSize()))
		n4, err := m.Kill.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.Message != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintExecutor(dAtA, i, uint64(m.Message.ProtoSize()))
		n5, err := m.Message.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.Error != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintExecutor(dAtA, i, uint64(m.Error.ProtoSize()))
		n6, err := m.Error.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.LaunchGroup != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintExecutor(dAtA, i, uint64(m.LaunchGroup.ProtoSize()))
		n7, err := m.LaunchGroup.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	return i, nil
}

func (m *Event_Subscribed) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event_Subscribed) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintExecutor(dAtA, i, uint64(m.ExecutorInfo.ProtoSize()))
	n8, err := m.ExecutorInfo.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n8
	dAtA[i] = 0x12
	i++
	i = encodeVarintExecutor(dAtA, i, uint64(m.FrameworkInfo.ProtoSize()))
	n9, err := m.FrameworkInfo.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n9
	dAtA[i] = 0x1a
	i++
	i = encodeVarintExecutor(dAtA, i, uint64(m.AgentInfo.ProtoSize()))
	n10, err := m.AgentInfo.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n10
	if m.ContainerID != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintExecutor(dAtA, i, uint64(m.ContainerID.ProtoSize()))
		n11, err := m.ContainerID.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	return i, nil
}

func (m *Event_Launch) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event_Launch) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintExecutor(dAtA, i, uint64(m.Task.ProtoSize()))
	n12, err := m.Task.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n12
	return i, nil
}

func (m *Event_LaunchGroup) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event_LaunchGroup) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintExecutor(dAtA, i, uint64(m.TaskGroup.ProtoSize()))
	n13, err := m.TaskGroup.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n13
	return i, nil
}

func (m *Event_Kill) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event_Kill) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintExecutor(dAtA, i, uint64(m.TaskID.ProtoSize()))
	n14, err := m.TaskID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n14
	if m.KillPolicy != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintExecutor(dAtA, i, uint64(m.KillPolicy.ProtoSize()))
		n15, err := m.KillPolicy.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	return i, nil
}

func (m *Event_Acknowledged) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event_Acknowledged) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintExecutor(dAtA, i, uint64(m.TaskID.ProtoSize()))
	n16, err := m.TaskID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n16
	if m.UUID == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("uuid")
	} else {
		dAtA[i] = 0x12
		i++
		i = encodeVarintExecutor(dAtA, i, uint64(len(m.UUID)))
		i += copy(dAtA[i:], m.UUID)
	}
	return i, nil
}

func (m *Event_Message) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event_Message) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Data == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("data")
	} else {
		dAtA[i] = 0xa
		i++
		i = encodeVarintExecutor(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	return i, nil
}

func (m *Event_Error) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event_Error) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintExecutor(dAtA, i, uint64(len(m.Message)))
	i += copy(dAtA[i:], m.Message)
	return i, nil
}

func (m *Call) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintExecutor(dAtA, i, uint64(m.ExecutorID.ProtoSize()))
	n17, err := m.ExecutorID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n17
	dAtA[i] = 0x12
	i++
	i = encodeVarintExecutor(dAtA, i, uint64(m.FrameworkID.ProtoSize()))
	n18, err := m.FrameworkID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n18
	dAtA[i] = 0x18
	i++
	i = encodeVarintExecutor(dAtA, i, uint64(m.Type))
	if m.Subscribe != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintExecutor(dAtA, i, uint64(m.Subscribe.ProtoSize()))
		n19, err := m.Subscribe.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	if m.Update != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintExecutor(dAtA, i, uint64(m.Update.ProtoSize()))
		n20, err := m.Update.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n20
	}
	if m.Message != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintExecutor(dAtA, i, uint64(m.Message.ProtoSize()))
		n21, err := m.Message.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n21
	}
	return i, nil
}

func (m *Call_Subscribe) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_Subscribe) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.UnacknowledgedTasks) > 0 {
		for _, msg := range m.UnacknowledgedTasks {
			dAtA[i] = 0xa
			i++
			i = encodeVarintExecutor(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.UnacknowledgedUpdates) > 0 {
		for _, msg := range m.UnacknowledgedUpdates {
			dAtA[i] = 0x12
			i++
			i = encodeVarintExecutor(dAtA, i, uint64(msg.ProtoSize()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Call_Update) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_Update) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintExecutor(dAtA, i, uint64(m.Status.ProtoSize()))
	n22, err := m.Status.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n22
	return i, nil
}

func (m *Call_Message) Marshal() (dAtA []byte, err error) {
	size := m.ProtoSize()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Call_Message) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Data == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("data")
	} else {
		dAtA[i] = 0x12
		i++
		i = encodeVarintExecutor(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	return i, nil
}

func encodeFixed64Executor(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Executor(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintExecutor(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func NewPopulatedEvent(r randyExecutor, easy bool) *Event {
	this := &Event{}
	this.Type = Event_Type([]int32{0, 1, 2, 8, 3, 4, 5, 6, 7}[r.Intn(9)])
	if r.Intn(10) == 0 {
		this.Subscribed = NewPopulatedEvent_Subscribed(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Acknowledged = NewPopulatedEvent_Acknowledged(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Launch = NewPopulatedEvent_Launch(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Kill = NewPopulatedEvent_Kill(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Message = NewPopulatedEvent_Message(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Error = NewPopulatedEvent_Error(r, easy)
	}
	if r.Intn(10) != 0 {
		this.LaunchGroup = NewPopulatedEvent_LaunchGroup(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedEvent_Subscribed(r randyExecutor, easy bool) *Event_Subscribed {
	this := &Event_Subscribed{}
	v1 := mesos.NewPopulatedExecutorInfo(r, easy)
	this.ExecutorInfo = *v1
	v2 := mesos.NewPopulatedFrameworkInfo(r, easy)
	this.FrameworkInfo = *v2
	v3 := mesos.NewPopulatedAgentInfo(r, easy)
	this.AgentInfo = *v3
	if r.Intn(10) == 0 {
		this.ContainerID = mesos.NewPopulatedContainerID(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedEvent_Launch(r randyExecutor, easy bool) *Event_Launch {
	this := &Event_Launch{}
	v4 := mesos.NewPopulatedTaskInfo(r, easy)
	this.Task = *v4
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedEvent_LaunchGroup(r randyExecutor, easy bool) *Event_LaunchGroup {
	this := &Event_LaunchGroup{}
	v5 := mesos.NewPopulatedTaskGroupInfo(r, easy)
	this.TaskGroup = *v5
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedEvent_Kill(r randyExecutor, easy bool) *Event_Kill {
	this := &Event_Kill{}
	v6 := mesos.NewPopulatedTaskID(r, easy)
	this.TaskID = *v6
	if r.Intn(10) != 0 {
		this.KillPolicy = mesos.NewPopulatedKillPolicy(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedEvent_Acknowledged(r randyExecutor, easy bool) *Event_Acknowledged {
	this := &Event_Acknowledged{}
	v7 := mesos.NewPopulatedTaskID(r, easy)
	this.TaskID = *v7
	v8 := r.Intn(100)
	this.UUID = make([]byte, v8)
	for i := 0; i < v8; i++ {
		this.UUID[i] = byte(r.Intn(256))
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedEvent_Message(r randyExecutor, easy bool) *Event_Message {
	this := &Event_Message{}
	v9 := r.Intn(100)
	this.Data = make([]byte, v9)
	for i := 0; i < v9; i++ {
		this.Data[i] = byte(r.Intn(256))
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedEvent_Error(r randyExecutor, easy bool) *Event_Error {
	this := &Event_Error{}
	this.Message = string(randStringExecutor(r))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall(r randyExecutor, easy bool) *Call {
	this := &Call{}
	v10 := mesos.NewPopulatedExecutorID(r, easy)
	this.ExecutorID = *v10
	v11 := mesos.NewPopulatedFrameworkID(r, easy)
	this.FrameworkID = *v11
	this.Type = Call_Type([]int32{0, 1, 2, 3}[r.Intn(4)])
	if r.Intn(10) == 0 {
		this.Subscribe = NewPopulatedCall_Subscribe(r, easy)
	}
	if r.Intn(10) == 0 {
		this.Update = NewPopulatedCall_Update(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Message = NewPopulatedCall_Message(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_Subscribe(r randyExecutor, easy bool) *Call_Subscribe {
	this := &Call_Subscribe{}
	if r.Intn(10) != 0 {
		v12 := r.Intn(5)
		this.UnacknowledgedTasks = make([]mesos.TaskInfo, v12)
		for i := 0; i < v12; i++ {
			v13 := mesos.NewPopulatedTaskInfo(r, easy)
			this.UnacknowledgedTasks[i] = *v13
		}
	}
	if r.Intn(10) == 0 {
		v14 := r.Intn(5)
		this.UnacknowledgedUpdates = make([]Call_Update, v14)
		for i := 0; i < v14; i++ {
			v15 := NewPopulatedCall_Update(r, easy)
			this.UnacknowledgedUpdates[i] = *v15
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_Update(r randyExecutor, easy bool) *Call_Update {
	this := &Call_Update{}
	v16 := mesos.NewPopulatedTaskStatus(r, easy)
	this.Status = *v16
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCall_Message(r randyExecutor, easy bool) *Call_Message {
	this := &Call_Message{}
	v17 := r.Intn(100)
	this.Data = make([]byte, v17)
	for i := 0; i < v17; i++ {
		this.Data[i] = byte(r.Intn(256))
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

type randyExecutor interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneExecutor(r randyExecutor) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringExecutor(r randyExecutor) string {
	v18 := r.Intn(100)
	tmps := make([]rune, v18)
	for i := 0; i < v18; i++ {
		tmps[i] = randUTF8RuneExecutor(r)
	}
	return string(tmps)
}
func randUnrecognizedExecutor(r randyExecutor, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldExecutor(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldExecutor(dAtA []byte, r randyExecutor, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulateExecutor(dAtA, uint64(key))
		v19 := r.Int63()
		if r.Intn(2) == 0 {
			v19 *= -1
		}
		dAtA = encodeVarintPopulateExecutor(dAtA, uint64(v19))
	case 1:
		dAtA = encodeVarintPopulateExecutor(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulateExecutor(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulateExecutor(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulateExecutor(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulateExecutor(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *Event) ProtoSize() (n int) {
	var l int
	_ = l
	n += 1 + sovExecutor(uint64(m.Type))
	if m.Subscribed != nil {
		l = m.Subscribed.ProtoSize()
		n += 1 + l + sovExecutor(uint64(l))
	}
	if m.Acknowledged != nil {
		l = m.Acknowledged.ProtoSize()
		n += 1 + l + sovExecutor(uint64(l))
	}
	if m.Launch != nil {
		l = m.Launch.ProtoSize()
		n += 1 + l + sovExecutor(uint64(l))
	}
	if m.Kill != nil {
		l = m.Kill.ProtoSize()
		n += 1 + l + sovExecutor(uint64(l))
	}
	if m.Message != nil {
		l = m.Message.ProtoSize()
		n += 1 + l + sovExecutor(uint64(l))
	}
	if m.Error != nil {
		l = m.Error.ProtoSize()
		n += 1 + l + sovExecutor(uint64(l))
	}
	if m.LaunchGroup != nil {
		l = m.LaunchGroup.ProtoSize()
		n += 1 + l + sovExecutor(uint64(l))
	}
	return n
}

func (m *Event_Subscribed) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.ExecutorInfo.ProtoSize()
	n += 1 + l + sovExecutor(uint64(l))
	l = m.FrameworkInfo.ProtoSize()
	n += 1 + l + sovExecutor(uint64(l))
	l = m.AgentInfo.ProtoSize()
	n += 1 + l + sovExecutor(uint64(l))
	if m.ContainerID != nil {
		l = m.ContainerID.ProtoSize()
		n += 1 + l + sovExecutor(uint64(l))
	}
	return n
}

func (m *Event_Launch) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.Task.ProtoSize()
	n += 1 + l + sovExecutor(uint64(l))
	return n
}

func (m *Event_LaunchGroup) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.TaskGroup.ProtoSize()
	n += 1 + l + sovExecutor(uint64(l))
	return n
}

func (m *Event_Kill) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.TaskID.ProtoSize()
	n += 1 + l + sovExecutor(uint64(l))
	if m.KillPolicy != nil {
		l = m.KillPolicy.ProtoSize()
		n += 1 + l + sovExecutor(uint64(l))
	}
	return n
}

func (m *Event_Acknowledged) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.TaskID.ProtoSize()
	n += 1 + l + sovExecutor(uint64(l))
	if m.UUID != nil {
		l = len(m.UUID)
		n += 1 + l + sovExecutor(uint64(l))
	}
	return n
}

func (m *Event_Message) ProtoSize() (n int) {
	var l int
	_ = l
	if m.Data != nil {
		l = len(m.Data)
		n += 1 + l + sovExecutor(uint64(l))
	}
	return n
}

func (m *Event_Error) ProtoSize() (n int) {
	var l int
	_ = l
	l = len(m.Message)
	n += 1 + l + sovExecutor(uint64(l))
	return n
}

func (m *Call) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.ExecutorID.ProtoSize()
	n += 1 + l + sovExecutor(uint64(l))
	l = m.FrameworkID.ProtoSize()
	n += 1 + l + sovExecutor(uint64(l))
	n += 1 + sovExecutor(uint64(m.Type))
	if m.Subscribe != nil {
		l = m.Subscribe.ProtoSize()
		n += 1 + l + sovExecutor(uint64(l))
	}
	if m.Update != nil {
		l = m.Update.ProtoSize()
		n += 1 + l + sovExecutor(uint64(l))
	}
	if m.Message != nil {
		l = m.Message.ProtoSize()
		n += 1 + l + sovExecutor(uint64(l))
	}
	return n
}

func (m *Call_Subscribe) ProtoSize() (n int) {
	var l int
	_ = l
	if len(m.UnacknowledgedTasks) > 0 {
		for _, e := range m.UnacknowledgedTasks {
			l = e.ProtoSize()
			n += 1 + l + sovExecutor(uint64(l))
		}
	}
	if len(m.UnacknowledgedUpdates) > 0 {
		for _, e := range m.UnacknowledgedUpdates {
			l = e.ProtoSize()
			n += 1 + l + sovExecutor(uint64(l))
		}
	}
	return n
}

func (m *Call_Update) ProtoSize() (n int) {
	var l int
	_ = l
	l = m.Status.ProtoSize()
	n += 1 + l + sovExecutor(uint64(l))
	return n
}

func (m *Call_Message) ProtoSize() (n int) {
	var l int
	_ = l
	if m.Data != nil {
		l = len(m.Data)
		n += 1 + l + sovExecutor(uint64(l))
	}
	return n
}

func sovExecutor(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozExecutor(x uint64) (n int) {
	return sovExecutor(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Event) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Event{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`Subscribed:` + strings.Replace(fmt.Sprintf("%v", this.Subscribed), "Event_Subscribed", "Event_Subscribed", 1) + `,`,
		`Acknowledged:` + strings.Replace(fmt.Sprintf("%v", this.Acknowledged), "Event_Acknowledged", "Event_Acknowledged", 1) + `,`,
		`Launch:` + strings.Replace(fmt.Sprintf("%v", this.Launch), "Event_Launch", "Event_Launch", 1) + `,`,
		`Kill:` + strings.Replace(fmt.Sprintf("%v", this.Kill), "Event_Kill", "Event_Kill", 1) + `,`,
		`Message:` + strings.Replace(fmt.Sprintf("%v", this.Message), "Event_Message", "Event_Message", 1) + `,`,
		`Error:` + strings.Replace(fmt.Sprintf("%v", this.Error), "Event_Error", "Event_Error", 1) + `,`,
		`LaunchGroup:` + strings.Replace(fmt.Sprintf("%v", this.LaunchGroup), "Event_LaunchGroup", "Event_LaunchGroup", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Event_Subscribed) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Event_Subscribed{`,
		`ExecutorInfo:` + strings.Replace(strings.Replace(this.ExecutorInfo.String(), "ExecutorInfo", "mesos.ExecutorInfo", 1), `&`, ``, 1) + `,`,
		`FrameworkInfo:` + strings.Replace(strings.Replace(this.FrameworkInfo.String(), "FrameworkInfo", "mesos.FrameworkInfo", 1), `&`, ``, 1) + `,`,
		`AgentInfo:` + strings.Replace(strings.Replace(this.AgentInfo.String(), "AgentInfo", "mesos.AgentInfo", 1), `&`, ``, 1) + `,`,
		`ContainerID:` + strings.Replace(fmt.Sprintf("%v", this.ContainerID), "ContainerID", "mesos.ContainerID", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Event_Launch) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Event_Launch{`,
		`Task:` + strings.Replace(strings.Replace(this.Task.String(), "TaskInfo", "mesos.TaskInfo", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Event_LaunchGroup) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Event_LaunchGroup{`,
		`TaskGroup:` + strings.Replace(strings.Replace(this.TaskGroup.String(), "TaskGroupInfo", "mesos.TaskGroupInfo", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Event_Kill) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Event_Kill{`,
		`TaskID:` + strings.Replace(strings.Replace(this.TaskID.String(), "TaskID", "mesos.TaskID", 1), `&`, ``, 1) + `,`,
		`KillPolicy:` + strings.Replace(fmt.Sprintf("%v", this.KillPolicy), "KillPolicy", "mesos.KillPolicy", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Event_Acknowledged) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Event_Acknowledged{`,
		`TaskID:` + strings.Replace(strings.Replace(this.TaskID.String(), "TaskID", "mesos.TaskID", 1), `&`, ``, 1) + `,`,
		`UUID:` + valueToStringExecutor(this.UUID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Event_Message) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Event_Message{`,
		`Data:` + valueToStringExecutor(this.Data) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Event_Error) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Event_Error{`,
		`Message:` + fmt.Sprintf("%v", this.Message) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call{`,
		`ExecutorID:` + strings.Replace(strings.Replace(this.ExecutorID.String(), "ExecutorID", "mesos.ExecutorID", 1), `&`, ``, 1) + `,`,
		`FrameworkID:` + strings.Replace(strings.Replace(this.FrameworkID.String(), "FrameworkID", "mesos.FrameworkID", 1), `&`, ``, 1) + `,`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`Subscribe:` + strings.Replace(fmt.Sprintf("%v", this.Subscribe), "Call_Subscribe", "Call_Subscribe", 1) + `,`,
		`Update:` + strings.Replace(fmt.Sprintf("%v", this.Update), "Call_Update", "Call_Update", 1) + `,`,
		`Message:` + strings.Replace(fmt.Sprintf("%v", this.Message), "Call_Message", "Call_Message", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_Subscribe) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_Subscribe{`,
		`UnacknowledgedTasks:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.UnacknowledgedTasks), "TaskInfo", "mesos.TaskInfo", 1), `&`, ``, 1) + `,`,
		`UnacknowledgedUpdates:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.UnacknowledgedUpdates), "Call_Update", "Call_Update", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_Update) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_Update{`,
		`Status:` + strings.Replace(strings.Replace(this.Status.String(), "TaskStatus", "mesos.TaskStatus", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Call_Message) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Call_Message{`,
		`Data:` + valueToStringExecutor(this.Data) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringExecutor(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Event) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutor
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Event: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Event: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (Event_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subscribed", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Subscribed == nil {
				m.Subscribed = &Event_Subscribed{}
			}
			if err := m.Subscribed.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Acknowledged", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Acknowledged == nil {
				m.Acknowledged = &Event_Acknowledged{}
			}
			if err := m.Acknowledged.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Launch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Launch == nil {
				m.Launch = &Event_Launch{}
			}
			if err := m.Launch.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kill", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Kill == nil {
				m.Kill = &Event_Kill{}
			}
			if err := m.Kill.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Message == nil {
				m.Message = &Event_Message{}
			}
			if err := m.Message.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Error == nil {
				m.Error = &Event_Error{}
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LaunchGroup", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LaunchGroup == nil {
				m.LaunchGroup = &Event_LaunchGroup{}
			}
			if err := m.LaunchGroup.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipExecutor(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutor
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Event_Subscribed) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutor
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Subscribed: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Subscribed: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecutorInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ExecutorInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FrameworkInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.FrameworkInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgentInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.AgentInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000004)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ContainerID == nil {
				m.ContainerID = &mesos.ContainerID{}
			}
			if err := m.ContainerID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipExecutor(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutor
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("executor_info")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("framework_info")
	}
	if hasFields[0]&uint64(0x00000004) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("agent_info")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Event_Launch) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutor
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Launch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Launch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Task", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Task.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipExecutor(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutor
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("task")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Event_LaunchGroup) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutor
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LaunchGroup: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LaunchGroup: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskGroup", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TaskGroup.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipExecutor(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutor
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("task_group")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Event_Kill) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutor
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Kill: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Kill: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TaskID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KillPolicy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.KillPolicy == nil {
				m.KillPolicy = &mesos.KillPolicy{}
			}
			if err := m.KillPolicy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipExecutor(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutor
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("task_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Event_Acknowledged) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutor
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Acknowledged: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Acknowledged: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TaskID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UUID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UUID = append(m.UUID[:0], dAtA[iNdEx:postIndex]...)
			if m.UUID == nil {
				m.UUID = []byte{}
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		default:
			iNdEx = preIndex
			skippy, err := skipExecutor(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutor
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("task_id")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("uuid")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Event_Message) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutor
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Message: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Message: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipExecutor(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutor
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("data")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Event_Error) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutor
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Error: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Error: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipExecutor(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutor
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("message")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutor
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Call: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Call: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecutorID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ExecutorID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FrameworkID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.FrameworkID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (Call_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subscribe", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Subscribe == nil {
				m.Subscribe = &Call_Subscribe{}
			}
			if err := m.Subscribe.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Update", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Update == nil {
				m.Update = &Call_Update{}
			}
			if err := m.Update.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Message == nil {
				m.Message = &Call_Message{}
			}
			if err := m.Message.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipExecutor(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutor
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("executor_id")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("framework_id")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_Subscribe) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutor
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Subscribe: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Subscribe: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UnacknowledgedTasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UnacknowledgedTasks = append(m.UnacknowledgedTasks, mesos.TaskInfo{})
			if err := m.UnacknowledgedTasks[len(m.UnacknowledgedTasks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UnacknowledgedUpdates", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UnacknowledgedUpdates = append(m.UnacknowledgedUpdates, Call_Update{})
			if err := m.UnacknowledgedUpdates[len(m.UnacknowledgedUpdates)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipExecutor(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutor
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_Update) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutor
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Update: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Update: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipExecutor(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutor
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("status")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Call_Message) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExecutor
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Message: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Message: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthExecutor
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			iNdEx = preIndex
			skippy, err := skipExecutor(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExecutor
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("data")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipExecutor(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowExecutor
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowExecutor
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthExecutor
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowExecutor
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipExecutor(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthExecutor = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowExecutor   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("executor/executor.proto", fileDescriptorExecutor) }

var fileDescriptorExecutor = []byte{
	// 1019 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x54, 0xbf, 0x6f, 0xdb, 0x46,
	0x14, 0xd6, 0x49, 0x14, 0x25, 0x3d, 0xca, 0x0e, 0x73, 0x49, 0x5b, 0x96, 0x71, 0x68, 0xd7, 0x4b,
	0xdd, 0x21, 0x52, 0x63, 0xa7, 0x2d, 0x02, 0x14, 0x45, 0x25, 0x93, 0xb6, 0x55, 0x3b, 0xb6, 0x71,
	0xb2, 0xd0, 0xa2, 0x8b, 0x40, 0x8b, 0xb4, 0x42, 0x88, 0x16, 0x05, 0xfe, 0x48, 0xea, 0xad, 0x63,
	0xbb, 0x14, 0xfd, 0x07, 0x0a, 0x14, 0xe8, 0xd2, 0xad, 0x6b, 0xc7, 0x8e, 0xe9, 0x96, 0xb1, 0x93,
	0x51, 0x31, 0x4b, 0xc7, 0x8c, 0x1d, 0x8b, 0x3b, 0x1e, 0x25, 0x4a, 0x61, 0x32, 0x74, 0x21, 0xee,
	0xde, 0xfb, 0xbe, 0x8f, 0x77, 0xef, 0xde, 0xf7, 0xe0, 0x1d, 0xfb, 0x1b, 0x7b, 0x10, 0x85, 0x9e,
	0xdf, 0x4c, 0x17, 0x8d, 0x89, 0xef, 0x85, 0x1e, 0x5e, 0xbd, 0xb4, 0x03, 0x2f, 0x68, 0xa4, 0x51,
	0xf5, 0xc3, 0xa1, 0x13, 0x3e, 0x8e, 0xce, 0x1b, 0x03, 0xef, 0xb2, 0xc9, 0x52, 0xc9, 0xf7, 0xde,
	0xd0, 0x6b, 0x9a, 0x13, 0xa7, 0xf9, 0xe4, 0x7e, 0xd3, 0x75, 0xce, 0x93, 0x58, 0xa2, 0xa0, 0xde,
	0xcb, 0x30, 0x86, 0xde, 0xd0, 0x6b, 0xb2, 0xf0, 0x79, 0x74, 0xc1, 0x76, 0x6c, 0xc3, 0x56, 0x09,
	0x7c, 0xf3, 0x27, 0x80, 0xb2, 0xf1, 0xc4, 0x1e, 0x87, 0xf8, 0x01, 0x08, 0xe1, 0xd5, 0xc4, 0x56,
	0xd0, 0x06, 0xda, 0x5a, 0xdd, 0x56, 0x1b, 0x8b, 0x27, 0x69, 0x30, 0x50, 0xe3, 0xec, 0x6a, 0x62,
	0xb7, 0x85, 0x67, 0xd7, 0xeb, 0x05, 0xc2, 0xd0, 0xf8, 0x73, 0x80, 0x20, 0x3a, 0x0f, 0x06, 0xbe,
	0x73, 0x6e, 0x5b, 0x4a, 0x71, 0x03, 0x6d, 0x49, 0xdb, 0x1b, 0xf9, 0xdc, 0xee, 0x0c, 0x47, 0x32,
	0x1c, 0xbc, 0x07, 0x75, 0x73, 0x30, 0x1a, 0x7b, 0x4f, 0x5d, 0xdb, 0x1a, 0xda, 0x96, 0x52, 0x62,
	0x1a, 0x9b, 0xf9, 0x1a, 0xad, 0x0c, 0x92, 0x2c, 0xf0, 0xf0, 0x03, 0x10, 0x5d, 0x33, 0x1a, 0x0f,
	0x1e, 0x2b, 0x02, 0x53, 0x58, 0xcb, 0x57, 0x38, 0x62, 0x18, 0xc2, 0xb1, 0xb8, 0x01, 0xc2, 0xc8,
	0x71, 0x5d, 0xa5, 0xcc, 0x38, 0xaf, 0xb9, 0xf5, 0xa1, 0xe3, 0xba, 0x84, 0xe1, 0xf0, 0x27, 0x50,
	0xb9, 0xb4, 0x83, 0xc0, 0x1c, 0xda, 0x8a, 0xc8, 0x28, 0x77, 0xf3, 0x29, 0x8f, 0x12, 0x10, 0x49,
	0xd1, 0xf8, 0x3e, 0x94, 0x6d, 0xdf, 0xf7, 0x7c, 0xa5, 0xc2, 0x68, 0x77, 0xf2, 0x69, 0x06, 0x85,
	0x90, 0x04, 0x89, 0x75, 0xa8, 0x27, 0xa7, 0xec, 0x0f, 0x7d, 0x2f, 0x9a, 0x28, 0x55, 0xc6, 0x7c,
	0xef, 0x4d, 0xf7, 0xda, 0xa7, 0x40, 0x22, 0xb9, 0xf3, 0x8d, 0xfa, 0x43, 0x11, 0x60, 0x5e, 0x7a,
	0xfc, 0x19, 0xac, 0xa4, 0xcc, 0xbe, 0x33, 0xbe, 0xf0, 0x14, 0xb4, 0x51, 0xdc, 0x92, 0xb6, 0x6f,
	0x71, 0x55, 0x83, 0xe7, 0x3a, 0xe3, 0x0b, 0x8f, 0x3f, 0x74, 0xdd, 0xce, 0xc4, 0x70, 0x0b, 0x56,
	0x2f, 0x7c, 0xf3, 0xd2, 0x7e, 0xea, 0xf9, 0xa3, 0x44, 0xa0, 0xc8, 0x04, 0x6e, 0x73, 0x81, 0xbd,
	0x34, 0x99, 0x51, 0x58, 0xb9, 0xc8, 0x06, 0xf1, 0x47, 0x00, 0xe6, 0xd0, 0x1e, 0x87, 0x09, 0xbd,
	0xc4, 0xe8, 0x32, 0xa7, 0xb7, 0x68, 0x22, 0x43, 0xad, 0x99, 0x69, 0x80, 0x36, 0xca, 0xc0, 0x1b,
	0x87, 0xa6, 0x33, 0xb6, 0xfd, 0xbe, 0x63, 0xf1, 0x67, 0xc6, 0x9c, 0xb8, 0x9b, 0xa6, 0x3a, 0x7a,
	0xfb, 0x46, 0x7c, 0xbd, 0x2e, 0x65, 0x02, 0x44, 0x9a, 0x11, 0x3b, 0x96, 0xba, 0x03, 0x62, 0x52,
	0x2c, 0xfc, 0x01, 0x08, 0xa1, 0x19, 0x8c, 0x78, 0x09, 0x6e, 0x70, 0xa5, 0x33, 0x33, 0xc8, 0x1e,
	0x9e, 0x41, 0xd4, 0x03, 0x90, 0x32, 0x15, 0xc6, 0x0f, 0x01, 0x68, 0x98, 0x3f, 0x0c, 0x5a, 0xa8,
	0x00, 0xe5, 0x33, 0x54, 0xf6, 0x1a, 0x61, 0x1a, 0x54, 0x7d, 0x10, 0x68, 0x3f, 0xe1, 0x8f, 0xa1,
	0xc2, 0x24, 0x1c, 0x8b, 0xf3, 0x57, 0xb2, 0xff, 0xd7, 0xdb, 0xab, 0x94, 0x18, 0x5f, 0xaf, 0x8b,
	0xc9, 0x9e, 0x88, 0x14, 0xdd, 0xb1, 0xf0, 0x36, 0x48, 0xb4, 0x13, 0xfb, 0x13, 0xcf, 0x75, 0x06,
	0x57, 0xdc, 0x72, 0x37, 0x39, 0x97, 0x2a, 0x9f, 0xb2, 0x04, 0x81, 0xd1, 0x6c, 0xad, 0x5a, 0x50,
	0xcf, 0x3a, 0xe7, 0x7f, 0xff, 0x7b, 0x0d, 0x84, 0x28, 0x72, 0x2c, 0xf6, 0xe4, 0xf5, 0x76, 0x35,
	0xbe, 0x5e, 0x17, 0x7a, 0xbd, 0x8e, 0x4e, 0x58, 0x54, 0xbd, 0x0b, 0x15, 0xde, 0xf6, 0x18, 0x83,
	0x60, 0x99, 0xa1, 0xc9, 0xd4, 0xeb, 0x84, 0xad, 0xd5, 0xf7, 0xa1, 0xcc, 0xda, 0x1b, 0x6b, 0x73,
	0x0f, 0xd1, 0x7c, 0x8d, 0xd7, 0x28, 0x0d, 0x6e, 0x7e, 0x8f, 0x40, 0xa0, 0x83, 0x06, 0x4b, 0x50,
	0xe9, 0x1d, 0x1f, 0x1e, 0x9f, 0x7c, 0x79, 0x2c, 0x17, 0xf0, 0x2a, 0x40, 0xb7, 0xd7, 0xee, 0xee,
	0x92, 0x4e, 0xdb, 0xd0, 0x65, 0x84, 0x01, 0xc4, 0xa3, 0x56, 0xef, 0x78, 0xf7, 0x40, 0x2e, 0x62,
	0x19, 0xea, 0xc9, 0xba, 0xbf, 0x4f, 0x4e, 0x7a, 0xa7, 0x72, 0x15, 0x57, 0x41, 0x38, 0xec, 0x1c,
	0x1d, 0xc9, 0x25, 0x9a, 0x6b, 0xed, 0x52, 0x91, 0x23, 0x43, 0xdf, 0x37, 0x74, 0x59, 0xa0, 0xb2,
	0x8f, 0x8c, 0x6e, 0xb7, 0xb5, 0x6f, 0xc8, 0x65, 0x5c, 0x83, 0xb2, 0x41, 0xc8, 0x09, 0x91, 0x45,
	0x5c, 0x87, 0x6a, 0xf7, 0xa0, 0x77, 0xa6, 0xd3, 0xff, 0x55, 0x54, 0xe1, 0xbb, 0x5f, 0x34, 0xb4,
	0xf9, 0x67, 0x19, 0x84, 0x5d, 0xd3, 0x75, 0xf1, 0x1e, 0x48, 0x73, 0xdf, 0xa4, 0x65, 0xbb, 0xb9,
	0xec, 0x1a, 0xbd, 0x8d, 0x79, 0xe9, 0x60, 0x1e, 0x23, 0x30, 0x73, 0x90, 0x85, 0xbf, 0x80, 0x7a,
	0xc6, 0x3f, 0x16, 0x77, 0x0f, 0x7e, 0xc5, 0x3d, 0x7a, 0xfb, 0x16, 0x57, 0x92, 0x32, 0x41, 0x22,
	0xcd, 0xad, 0x64, 0xe1, 0x1d, 0x3e, 0xb2, 0x4b, 0x6c, 0x64, 0xbf, 0xbb, 0x3c, 0x18, 0xe8, 0xb9,
	0x5f, 0x9d, 0xd8, 0x9f, 0x42, 0x6d, 0x36, 0x7d, 0xb9, 0x87, 0xb4, 0x5c, 0xe6, 0x6c, 0x68, 0x90,
	0x39, 0x01, 0xef, 0x80, 0x18, 0x4d, 0x2c, 0x33, 0xb4, 0xf9, 0xc4, 0xbc, 0x93, 0x4b, 0xed, 0x31,
	0x08, 0xe1, 0x50, 0xda, 0x6e, 0x8b, 0x43, 0x73, 0x2d, 0x97, 0xb5, 0x3c, 0x33, 0xd5, 0xdf, 0x10,
	0xd4, 0x66, 0xa7, 0xc0, 0x07, 0x70, 0x3b, 0x1a, 0x67, 0x47, 0x7e, 0x9f, 0x76, 0x65, 0xa0, 0xa0,
	0x8d, 0xd2, 0xeb, 0xdd, 0x7b, 0x6b, 0x91, 0x42, 0xb3, 0x01, 0xfe, 0x0a, 0xde, 0x5e, 0x52, 0x4a,
	0x0e, 0x1a, 0x28, 0x45, 0xa6, 0xf5, 0xa6, 0x4b, 0x71, 0xdd, 0xb7, 0x16, 0x05, 0x92, 0x5c, 0xa0,
	0x3e, 0x04, 0x31, 0x59, 0xe2, 0x26, 0x88, 0x41, 0x68, 0x86, 0x51, 0xb0, 0xd4, 0x2a, 0xf4, 0x04,
	0x5d, 0x96, 0xe0, 0x4a, 0x1c, 0x96, 0xe7, 0x9e, 0xe2, 0xdc, 0x3d, 0x9b, 0xad, 0x3c, 0x4f, 0xac,
	0x40, 0x6d, 0xe6, 0x89, 0xc4, 0x12, 0xbd, 0x53, 0xbd, 0x75, 0x66, 0xc8, 0xc5, 0x6c, 0x93, 0x97,
	0x92, 0x5e, 0x6e, 0xef, 0x3d, 0x9f, 0x6a, 0x85, 0xbf, 0xa6, 0x5a, 0xe1, 0xef, 0xa9, 0x86, 0x5e,
	0x4e, 0x35, 0xf4, 0xef, 0x54, 0x43, 0xdf, 0xc6, 0x1a, 0xfa, 0x35, 0xd6, 0xd0, 0xef, 0xb1, 0x86,
	0xfe, 0x88, 0x35, 0xf4, 0x2c, 0xd6, 0xd0, 0xf3, 0x58, 0x43, 0xff, 0xc4, 0x5a, 0xe1, 0x65, 0xac,
	0xa1, 0x1f, 0x5f, 0x68, 0x85, 0x9f, 0x5f, 0x68, 0xe8, 0xeb, 0x6a, 0x5a, 0x8d, 0xff, 0x02, 0x00,
	0x00, 0xff, 0xff, 0x42, 0x17, 0xcd, 0x0d, 0xbe, 0x08, 0x00, 0x00,
}
