// Code generated by protoc-gen-gogo.
// source: log.proto
// DO NOT EDIT!

package mesosproto

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"

// discarding unused import gogoproto "github.com/gogo/protobuf/gogoproto"

import bytes "bytes"

import strings "strings"
import github_com_gogo_protobuf_proto "github.com/gogo/protobuf/proto"
import sort "sort"
import strconv "strconv"
import reflect "reflect"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type Action_Type int32

const (
	Action_NOP      Action_Type = 1
	Action_APPEND   Action_Type = 2
	Action_TRUNCATE Action_Type = 3
)

var Action_Type_name = map[int32]string{
	1: "NOP",
	2: "APPEND",
	3: "TRUNCATE",
}
var Action_Type_value = map[string]int32{
	"NOP":      1,
	"APPEND":   2,
	"TRUNCATE": 3,
}

func (x Action_Type) Enum() *Action_Type {
	p := new(Action_Type)
	*p = x
	return p
}
func (x Action_Type) String() string {
	return proto.EnumName(Action_Type_name, int32(x))
}
func (x *Action_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Action_Type_value, data, "Action_Type")
	if err != nil {
		return err
	}
	*x = Action_Type(value)
	return nil
}

type Metadata_Status int32

const (
	Metadata_VOTING     Metadata_Status = 1
	Metadata_RECOVERING Metadata_Status = 2
	Metadata_STARTING   Metadata_Status = 3
	Metadata_EMPTY      Metadata_Status = 4
)

var Metadata_Status_name = map[int32]string{
	1: "VOTING",
	2: "RECOVERING",
	3: "STARTING",
	4: "EMPTY",
}
var Metadata_Status_value = map[string]int32{
	"VOTING":     1,
	"RECOVERING": 2,
	"STARTING":   3,
	"EMPTY":      4,
}

func (x Metadata_Status) Enum() *Metadata_Status {
	p := new(Metadata_Status)
	*p = x
	return p
}
func (x Metadata_Status) String() string {
	return proto.EnumName(Metadata_Status_name, int32(x))
}
func (x *Metadata_Status) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Metadata_Status_value, data, "Metadata_Status")
	if err != nil {
		return err
	}
	*x = Metadata_Status(value)
	return nil
}

type Record_Type int32

const (
	Record_PROMISE  Record_Type = 1
	Record_ACTION   Record_Type = 2
	Record_METADATA Record_Type = 3
)

var Record_Type_name = map[int32]string{
	1: "PROMISE",
	2: "ACTION",
	3: "METADATA",
}
var Record_Type_value = map[string]int32{
	"PROMISE":  1,
	"ACTION":   2,
	"METADATA": 3,
}

func (x Record_Type) Enum() *Record_Type {
	p := new(Record_Type)
	*p = x
	return p
}
func (x Record_Type) String() string {
	return proto.EnumName(Record_Type_name, int32(x))
}
func (x *Record_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Record_Type_value, data, "Record_Type")
	if err != nil {
		return err
	}
	*x = Record_Type(value)
	return nil
}

// Represents a "promise" that a replica has made. A promise is
// *implicitly* valid for _all_ future actions that get performed on
// the replicated log (provided the action comes from the same
// proposer), until a new promise is made to a proposer with a higher
// proposal number. Each replica writes every promise it makes as a
// log record so that it can recover this information after a failure.
// TODO(benh): Does the promise actually need to be written to stable
// storage? Can we get away with looking at the last written action
// and using it's promised value? In this case, what happens if we
// make a promise but don't receive an action from that coordinator?
type Promise struct {
	Proposal         *uint64 `protobuf:"varint,1,req,name=proposal" json:"proposal,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Promise) Reset()      { *m = Promise{} }
func (*Promise) ProtoMessage() {}

func (m *Promise) GetProposal() uint64 {
	if m != nil && m.Proposal != nil {
		return *m.Proposal
	}
	return 0
}

// Represents an "action" performed on the log. Each action has an
// associated position in the log. In addition, each action (i.e.,
// position) will have been "promised" to a specific proposer
// (implicitly or explicitly) and may have been "performed" from a
// specific proposer. An action may also be "learned" to have reached
// consensus. There are three types of possible actions that can be
// performed on the log: nop (no action), append, and truncate.
type Action struct {
	Position         *uint64          `protobuf:"varint,1,req,name=position" json:"position,omitempty"`
	Promised         *uint64          `protobuf:"varint,2,req,name=promised" json:"promised,omitempty"`
	Performed        *uint64          `protobuf:"varint,3,opt,name=performed" json:"performed,omitempty"`
	Learned          *bool            `protobuf:"varint,4,opt,name=learned" json:"learned,omitempty"`
	Type             *Action_Type     `protobuf:"varint,5,opt,name=type,enum=mesosproto.Action_Type" json:"type,omitempty"`
	Nop              *Action_Nop      `protobuf:"bytes,6,opt,name=nop" json:"nop,omitempty"`
	Append           *Action_Append   `protobuf:"bytes,7,opt,name=append" json:"append,omitempty"`
	Truncate         *Action_Truncate `protobuf:"bytes,8,opt,name=truncate" json:"truncate,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *Action) Reset()      { *m = Action{} }
func (*Action) ProtoMessage() {}

func (m *Action) GetPosition() uint64 {
	if m != nil && m.Position != nil {
		return *m.Position
	}
	return 0
}

func (m *Action) GetPromised() uint64 {
	if m != nil && m.Promised != nil {
		return *m.Promised
	}
	return 0
}

func (m *Action) GetPerformed() uint64 {
	if m != nil && m.Performed != nil {
		return *m.Performed
	}
	return 0
}

func (m *Action) GetLearned() bool {
	if m != nil && m.Learned != nil {
		return *m.Learned
	}
	return false
}

func (m *Action) GetType() Action_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Action_NOP
}

func (m *Action) GetNop() *Action_Nop {
	if m != nil {
		return m.Nop
	}
	return nil
}

func (m *Action) GetAppend() *Action_Append {
	if m != nil {
		return m.Append
	}
	return nil
}

func (m *Action) GetTruncate() *Action_Truncate {
	if m != nil {
		return m.Truncate
	}
	return nil
}

type Action_Nop struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *Action_Nop) Reset()      { *m = Action_Nop{} }
func (*Action_Nop) ProtoMessage() {}

type Action_Append struct {
	Bytes            []byte `protobuf:"bytes,1,req,name=bytes" json:"bytes,omitempty"`
	Cksum            []byte `protobuf:"bytes,2,opt,name=cksum" json:"cksum,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *Action_Append) Reset()      { *m = Action_Append{} }
func (*Action_Append) ProtoMessage() {}

func (m *Action_Append) GetBytes() []byte {
	if m != nil {
		return m.Bytes
	}
	return nil
}

func (m *Action_Append) GetCksum() []byte {
	if m != nil {
		return m.Cksum
	}
	return nil
}

type Action_Truncate struct {
	To               *uint64 `protobuf:"varint,1,req,name=to" json:"to,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Action_Truncate) Reset()      { *m = Action_Truncate{} }
func (*Action_Truncate) ProtoMessage() {}

func (m *Action_Truncate) GetTo() uint64 {
	if m != nil && m.To != nil {
		return *m.To
	}
	return 0
}

// The metadata of a replica. It has to be persisted on the disk. We
// store the current status of the replica as well as the implicit
// promise that a replica has made. This message is intended to
// replace the old Promise message to support catch-up.
type Metadata struct {
	Status           *Metadata_Status `protobuf:"varint,1,req,name=status,enum=mesosproto.Metadata_Status,def=4" json:"status,omitempty"`
	Promised         *uint64          `protobuf:"varint,2,req,name=promised,def=0" json:"promised,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *Metadata) Reset()      { *m = Metadata{} }
func (*Metadata) ProtoMessage() {}

const Default_Metadata_Status Metadata_Status = Metadata_EMPTY
const Default_Metadata_Promised uint64 = 0

func (m *Metadata) GetStatus() Metadata_Status {
	if m != nil && m.Status != nil {
		return *m.Status
	}
	return Default_Metadata_Status
}

func (m *Metadata) GetPromised() uint64 {
	if m != nil && m.Promised != nil {
		return *m.Promised
	}
	return Default_Metadata_Promised
}

// Represents a log record written to the local filesystem by a
// replica. A log record may store a promise (DEPRECATED), an action
// or metadata (defined above).
type Record struct {
	Type             *Record_Type `protobuf:"varint,1,req,name=type,enum=mesosproto.Record_Type" json:"type,omitempty"`
	Promise          *Promise     `protobuf:"bytes,2,opt,name=promise" json:"promise,omitempty"`
	Action           *Action      `protobuf:"bytes,3,opt,name=action" json:"action,omitempty"`
	Metadata         *Metadata    `protobuf:"bytes,4,opt,name=metadata" json:"metadata,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *Record) Reset()      { *m = Record{} }
func (*Record) ProtoMessage() {}

func (m *Record) GetType() Record_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Record_PROMISE
}

func (m *Record) GetPromise() *Promise {
	if m != nil {
		return m.Promise
	}
	return nil
}

func (m *Record) GetAction() *Action {
	if m != nil {
		return m.Action
	}
	return nil
}

func (m *Record) GetMetadata() *Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

// Represents a "promise" request from a proposer with the specified
// 'proposal' to a replica. If the proposer is a coordinator, most
// such requests will occur after a coordinator has failed and a new
// coordinator is elected. In such a case, the position that the
// coordinator is asking the replica to promise is implicitly *all*
// positions that the replica has made no promises (thus the position
// field is not be used). In other instances, however, a proposer
// might be explicitly trying to request that a replica promise a
// specific position in the log (such as when trying to fill holes
// discovered during a client read), and then the 'position' field
// will be present.
type PromiseRequest struct {
	Proposal         *uint64 `protobuf:"varint,1,req,name=proposal" json:"proposal,omitempty"`
	Position         *uint64 `protobuf:"varint,2,opt,name=position" json:"position,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *PromiseRequest) Reset()      { *m = PromiseRequest{} }
func (*PromiseRequest) ProtoMessage() {}

func (m *PromiseRequest) GetProposal() uint64 {
	if m != nil && m.Proposal != nil {
		return *m.Proposal
	}
	return 0
}

func (m *PromiseRequest) GetPosition() uint64 {
	if m != nil && m.Position != nil {
		return *m.Position
	}
	return 0
}

// Represents a "promise" response from a replica back to a proposer.
// A replica represents a NACK (because it has promised a proposer
// with a higher proposal number) by setting the okay field to false.
// The 'proposal' is either the aforementioned higher proposal number
// when the response is a NACK, or the corresponding request's
// proposal number if it is an ACK. The replica either sends back the
// highest position it has recorded in the log (using the 'position'
// field) or the specific action (if any) it has at the position
// requested in PromiseRequest (using the 'action' field).
type PromiseResponse struct {
	Okay             *bool   `protobuf:"varint,1,req,name=okay" json:"okay,omitempty"`
	Proposal         *uint64 `protobuf:"varint,2,req,name=proposal" json:"proposal,omitempty"`
	Position         *uint64 `protobuf:"varint,4,opt,name=position" json:"position,omitempty"`
	Action           *Action `protobuf:"bytes,3,opt,name=action" json:"action,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *PromiseResponse) Reset()      { *m = PromiseResponse{} }
func (*PromiseResponse) ProtoMessage() {}

func (m *PromiseResponse) GetOkay() bool {
	if m != nil && m.Okay != nil {
		return *m.Okay
	}
	return false
}

func (m *PromiseResponse) GetProposal() uint64 {
	if m != nil && m.Proposal != nil {
		return *m.Proposal
	}
	return 0
}

func (m *PromiseResponse) GetPosition() uint64 {
	if m != nil && m.Position != nil {
		return *m.Position
	}
	return 0
}

func (m *PromiseResponse) GetAction() *Action {
	if m != nil {
		return m.Action
	}
	return nil
}

// Represents a write request for a specific type of action. Note that
// we deliberately do not include the entire Action as it contains
// fields that are not relevant to a write request (e.g., promised,
// performed) and rather than ignore them we exclude them for safety.
type WriteRequest struct {
	Proposal         *uint64          `protobuf:"varint,1,req,name=proposal" json:"proposal,omitempty"`
	Position         *uint64          `protobuf:"varint,2,req,name=position" json:"position,omitempty"`
	Learned          *bool            `protobuf:"varint,3,opt,name=learned" json:"learned,omitempty"`
	Type             *Action_Type     `protobuf:"varint,4,req,name=type,enum=mesosproto.Action_Type" json:"type,omitempty"`
	Nop              *Action_Nop      `protobuf:"bytes,5,opt,name=nop" json:"nop,omitempty"`
	Append           *Action_Append   `protobuf:"bytes,6,opt,name=append" json:"append,omitempty"`
	Truncate         *Action_Truncate `protobuf:"bytes,7,opt,name=truncate" json:"truncate,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *WriteRequest) Reset()      { *m = WriteRequest{} }
func (*WriteRequest) ProtoMessage() {}

func (m *WriteRequest) GetProposal() uint64 {
	if m != nil && m.Proposal != nil {
		return *m.Proposal
	}
	return 0
}

func (m *WriteRequest) GetPosition() uint64 {
	if m != nil && m.Position != nil {
		return *m.Position
	}
	return 0
}

func (m *WriteRequest) GetLearned() bool {
	if m != nil && m.Learned != nil {
		return *m.Learned
	}
	return false
}

func (m *WriteRequest) GetType() Action_Type {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Action_NOP
}

func (m *WriteRequest) GetNop() *Action_Nop {
	if m != nil {
		return m.Nop
	}
	return nil
}

func (m *WriteRequest) GetAppend() *Action_Append {
	if m != nil {
		return m.Append
	}
	return nil
}

func (m *WriteRequest) GetTruncate() *Action_Truncate {
	if m != nil {
		return m.Truncate
	}
	return nil
}

// Represents a write response corresponding to a write request. A
// replica represents a NACK (because it has promised a proposer with
// a higher proposal number) by setting the okay field to false. If
// the proposer is a coordinator, then it has been demoted. The
// 'position' should always correspond to the position set in the
// request. The 'proposal' is either the same proposal number set in
// the request in the case of an ACK, or the higher proposal number
// this position has been promised to in the case of a NACK.
type WriteResponse struct {
	Okay             *bool   `protobuf:"varint,1,req,name=okay" json:"okay,omitempty"`
	Proposal         *uint64 `protobuf:"varint,2,req,name=proposal" json:"proposal,omitempty"`
	Position         *uint64 `protobuf:"varint,3,req,name=position" json:"position,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *WriteResponse) Reset()      { *m = WriteResponse{} }
func (*WriteResponse) ProtoMessage() {}

func (m *WriteResponse) GetOkay() bool {
	if m != nil && m.Okay != nil {
		return *m.Okay
	}
	return false
}

func (m *WriteResponse) GetProposal() uint64 {
	if m != nil && m.Proposal != nil {
		return *m.Proposal
	}
	return 0
}

func (m *WriteResponse) GetPosition() uint64 {
	if m != nil && m.Position != nil {
		return *m.Position
	}
	return 0
}

// Represents a "learned" event, that is, when a particular action has
// been agreed upon (reached consensus).
type LearnedMessage struct {
	Action           *Action `protobuf:"bytes,1,req,name=action" json:"action,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *LearnedMessage) Reset()      { *m = LearnedMessage{} }
func (*LearnedMessage) ProtoMessage() {}

func (m *LearnedMessage) GetAction() *Action {
	if m != nil {
		return m.Action
	}
	return nil
}

// Represents a recover request. A recover request is used to initiate
// the recovery (by broadcasting it).
type RecoverRequest struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *RecoverRequest) Reset()      { *m = RecoverRequest{} }
func (*RecoverRequest) ProtoMessage() {}

// When a replica receives a RecoverRequest, it will reply with its
// current status, and the begin and the end of its current log.
type RecoverResponse struct {
	Status           *Metadata_Status `protobuf:"varint,1,req,name=status,enum=mesosproto.Metadata_Status" json:"status,omitempty"`
	Begin            *uint64          `protobuf:"varint,2,opt,name=begin" json:"begin,omitempty"`
	End              *uint64          `protobuf:"varint,3,opt,name=end" json:"end,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *RecoverResponse) Reset()      { *m = RecoverResponse{} }
func (*RecoverResponse) ProtoMessage() {}

func (m *RecoverResponse) GetStatus() Metadata_Status {
	if m != nil && m.Status != nil {
		return *m.Status
	}
	return Metadata_VOTING
}

func (m *RecoverResponse) GetBegin() uint64 {
	if m != nil && m.Begin != nil {
		return *m.Begin
	}
	return 0
}

func (m *RecoverResponse) GetEnd() uint64 {
	if m != nil && m.End != nil {
		return *m.End
	}
	return 0
}

func init() {
	proto.RegisterEnum("mesosproto.Action_Type", Action_Type_name, Action_Type_value)
	proto.RegisterEnum("mesosproto.Metadata_Status", Metadata_Status_name, Metadata_Status_value)
	proto.RegisterEnum("mesosproto.Record_Type", Record_Type_name, Record_Type_value)
}
func (this *Promise) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Promise)
	if !ok {
		return fmt.Errorf("that is not of type *Promise")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Promise but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Promisebut is not nil && this == nil")
	}
	if this.Proposal != nil && that1.Proposal != nil {
		if *this.Proposal != *that1.Proposal {
			return fmt.Errorf("Proposal this(%v) Not Equal that(%v)", *this.Proposal, *that1.Proposal)
		}
	} else if this.Proposal != nil {
		return fmt.Errorf("this.Proposal == nil && that.Proposal != nil")
	} else if that1.Proposal != nil {
		return fmt.Errorf("Proposal this(%v) Not Equal that(%v)", this.Proposal, that1.Proposal)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Promise) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Promise)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Proposal != nil && that1.Proposal != nil {
		if *this.Proposal != *that1.Proposal {
			return false
		}
	} else if this.Proposal != nil {
		return false
	} else if that1.Proposal != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Action) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Action)
	if !ok {
		return fmt.Errorf("that is not of type *Action")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Action but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Actionbut is not nil && this == nil")
	}
	if this.Position != nil && that1.Position != nil {
		if *this.Position != *that1.Position {
			return fmt.Errorf("Position this(%v) Not Equal that(%v)", *this.Position, *that1.Position)
		}
	} else if this.Position != nil {
		return fmt.Errorf("this.Position == nil && that.Position != nil")
	} else if that1.Position != nil {
		return fmt.Errorf("Position this(%v) Not Equal that(%v)", this.Position, that1.Position)
	}
	if this.Promised != nil && that1.Promised != nil {
		if *this.Promised != *that1.Promised {
			return fmt.Errorf("Promised this(%v) Not Equal that(%v)", *this.Promised, *that1.Promised)
		}
	} else if this.Promised != nil {
		return fmt.Errorf("this.Promised == nil && that.Promised != nil")
	} else if that1.Promised != nil {
		return fmt.Errorf("Promised this(%v) Not Equal that(%v)", this.Promised, that1.Promised)
	}
	if this.Performed != nil && that1.Performed != nil {
		if *this.Performed != *that1.Performed {
			return fmt.Errorf("Performed this(%v) Not Equal that(%v)", *this.Performed, *that1.Performed)
		}
	} else if this.Performed != nil {
		return fmt.Errorf("this.Performed == nil && that.Performed != nil")
	} else if that1.Performed != nil {
		return fmt.Errorf("Performed this(%v) Not Equal that(%v)", this.Performed, that1.Performed)
	}
	if this.Learned != nil && that1.Learned != nil {
		if *this.Learned != *that1.Learned {
			return fmt.Errorf("Learned this(%v) Not Equal that(%v)", *this.Learned, *that1.Learned)
		}
	} else if this.Learned != nil {
		return fmt.Errorf("this.Learned == nil && that.Learned != nil")
	} else if that1.Learned != nil {
		return fmt.Errorf("Learned this(%v) Not Equal that(%v)", this.Learned, that1.Learned)
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return fmt.Errorf("Type this(%v) Not Equal that(%v)", *this.Type, *that1.Type)
		}
	} else if this.Type != nil {
		return fmt.Errorf("this.Type == nil && that.Type != nil")
	} else if that1.Type != nil {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.Nop.Equal(that1.Nop) {
		return fmt.Errorf("Nop this(%v) Not Equal that(%v)", this.Nop, that1.Nop)
	}
	if !this.Append.Equal(that1.Append) {
		return fmt.Errorf("Append this(%v) Not Equal that(%v)", this.Append, that1.Append)
	}
	if !this.Truncate.Equal(that1.Truncate) {
		return fmt.Errorf("Truncate this(%v) Not Equal that(%v)", this.Truncate, that1.Truncate)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Action) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Action)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Position != nil && that1.Position != nil {
		if *this.Position != *that1.Position {
			return false
		}
	} else if this.Position != nil {
		return false
	} else if that1.Position != nil {
		return false
	}
	if this.Promised != nil && that1.Promised != nil {
		if *this.Promised != *that1.Promised {
			return false
		}
	} else if this.Promised != nil {
		return false
	} else if that1.Promised != nil {
		return false
	}
	if this.Performed != nil && that1.Performed != nil {
		if *this.Performed != *that1.Performed {
			return false
		}
	} else if this.Performed != nil {
		return false
	} else if that1.Performed != nil {
		return false
	}
	if this.Learned != nil && that1.Learned != nil {
		if *this.Learned != *that1.Learned {
			return false
		}
	} else if this.Learned != nil {
		return false
	} else if that1.Learned != nil {
		return false
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return false
		}
	} else if this.Type != nil {
		return false
	} else if that1.Type != nil {
		return false
	}
	if !this.Nop.Equal(that1.Nop) {
		return false
	}
	if !this.Append.Equal(that1.Append) {
		return false
	}
	if !this.Truncate.Equal(that1.Truncate) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Action_Nop) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Action_Nop)
	if !ok {
		return fmt.Errorf("that is not of type *Action_Nop")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Action_Nop but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Action_Nopbut is not nil && this == nil")
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Action_Nop) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Action_Nop)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Action_Append) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Action_Append)
	if !ok {
		return fmt.Errorf("that is not of type *Action_Append")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Action_Append but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Action_Appendbut is not nil && this == nil")
	}
	if !bytes.Equal(this.Bytes, that1.Bytes) {
		return fmt.Errorf("Bytes this(%v) Not Equal that(%v)", this.Bytes, that1.Bytes)
	}
	if !bytes.Equal(this.Cksum, that1.Cksum) {
		return fmt.Errorf("Cksum this(%v) Not Equal that(%v)", this.Cksum, that1.Cksum)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Action_Append) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Action_Append)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.Bytes, that1.Bytes) {
		return false
	}
	if !bytes.Equal(this.Cksum, that1.Cksum) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Action_Truncate) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Action_Truncate)
	if !ok {
		return fmt.Errorf("that is not of type *Action_Truncate")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Action_Truncate but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Action_Truncatebut is not nil && this == nil")
	}
	if this.To != nil && that1.To != nil {
		if *this.To != *that1.To {
			return fmt.Errorf("To this(%v) Not Equal that(%v)", *this.To, *that1.To)
		}
	} else if this.To != nil {
		return fmt.Errorf("this.To == nil && that.To != nil")
	} else if that1.To != nil {
		return fmt.Errorf("To this(%v) Not Equal that(%v)", this.To, that1.To)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Action_Truncate) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Action_Truncate)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.To != nil && that1.To != nil {
		if *this.To != *that1.To {
			return false
		}
	} else if this.To != nil {
		return false
	} else if that1.To != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Metadata) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Metadata)
	if !ok {
		return fmt.Errorf("that is not of type *Metadata")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Metadata but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Metadatabut is not nil && this == nil")
	}
	if this.Status != nil && that1.Status != nil {
		if *this.Status != *that1.Status {
			return fmt.Errorf("Status this(%v) Not Equal that(%v)", *this.Status, *that1.Status)
		}
	} else if this.Status != nil {
		return fmt.Errorf("this.Status == nil && that.Status != nil")
	} else if that1.Status != nil {
		return fmt.Errorf("Status this(%v) Not Equal that(%v)", this.Status, that1.Status)
	}
	if this.Promised != nil && that1.Promised != nil {
		if *this.Promised != *that1.Promised {
			return fmt.Errorf("Promised this(%v) Not Equal that(%v)", *this.Promised, *that1.Promised)
		}
	} else if this.Promised != nil {
		return fmt.Errorf("this.Promised == nil && that.Promised != nil")
	} else if that1.Promised != nil {
		return fmt.Errorf("Promised this(%v) Not Equal that(%v)", this.Promised, that1.Promised)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Metadata) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Metadata)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Status != nil && that1.Status != nil {
		if *this.Status != *that1.Status {
			return false
		}
	} else if this.Status != nil {
		return false
	} else if that1.Status != nil {
		return false
	}
	if this.Promised != nil && that1.Promised != nil {
		if *this.Promised != *that1.Promised {
			return false
		}
	} else if this.Promised != nil {
		return false
	} else if that1.Promised != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Record) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Record)
	if !ok {
		return fmt.Errorf("that is not of type *Record")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Record but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Recordbut is not nil && this == nil")
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return fmt.Errorf("Type this(%v) Not Equal that(%v)", *this.Type, *that1.Type)
		}
	} else if this.Type != nil {
		return fmt.Errorf("this.Type == nil && that.Type != nil")
	} else if that1.Type != nil {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.Promise.Equal(that1.Promise) {
		return fmt.Errorf("Promise this(%v) Not Equal that(%v)", this.Promise, that1.Promise)
	}
	if !this.Action.Equal(that1.Action) {
		return fmt.Errorf("Action this(%v) Not Equal that(%v)", this.Action, that1.Action)
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return fmt.Errorf("Metadata this(%v) Not Equal that(%v)", this.Metadata, that1.Metadata)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Record) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Record)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return false
		}
	} else if this.Type != nil {
		return false
	} else if that1.Type != nil {
		return false
	}
	if !this.Promise.Equal(that1.Promise) {
		return false
	}
	if !this.Action.Equal(that1.Action) {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *PromiseRequest) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*PromiseRequest)
	if !ok {
		return fmt.Errorf("that is not of type *PromiseRequest")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *PromiseRequest but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *PromiseRequestbut is not nil && this == nil")
	}
	if this.Proposal != nil && that1.Proposal != nil {
		if *this.Proposal != *that1.Proposal {
			return fmt.Errorf("Proposal this(%v) Not Equal that(%v)", *this.Proposal, *that1.Proposal)
		}
	} else if this.Proposal != nil {
		return fmt.Errorf("this.Proposal == nil && that.Proposal != nil")
	} else if that1.Proposal != nil {
		return fmt.Errorf("Proposal this(%v) Not Equal that(%v)", this.Proposal, that1.Proposal)
	}
	if this.Position != nil && that1.Position != nil {
		if *this.Position != *that1.Position {
			return fmt.Errorf("Position this(%v) Not Equal that(%v)", *this.Position, *that1.Position)
		}
	} else if this.Position != nil {
		return fmt.Errorf("this.Position == nil && that.Position != nil")
	} else if that1.Position != nil {
		return fmt.Errorf("Position this(%v) Not Equal that(%v)", this.Position, that1.Position)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *PromiseRequest) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*PromiseRequest)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Proposal != nil && that1.Proposal != nil {
		if *this.Proposal != *that1.Proposal {
			return false
		}
	} else if this.Proposal != nil {
		return false
	} else if that1.Proposal != nil {
		return false
	}
	if this.Position != nil && that1.Position != nil {
		if *this.Position != *that1.Position {
			return false
		}
	} else if this.Position != nil {
		return false
	} else if that1.Position != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *PromiseResponse) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*PromiseResponse)
	if !ok {
		return fmt.Errorf("that is not of type *PromiseResponse")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *PromiseResponse but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *PromiseResponsebut is not nil && this == nil")
	}
	if this.Okay != nil && that1.Okay != nil {
		if *this.Okay != *that1.Okay {
			return fmt.Errorf("Okay this(%v) Not Equal that(%v)", *this.Okay, *that1.Okay)
		}
	} else if this.Okay != nil {
		return fmt.Errorf("this.Okay == nil && that.Okay != nil")
	} else if that1.Okay != nil {
		return fmt.Errorf("Okay this(%v) Not Equal that(%v)", this.Okay, that1.Okay)
	}
	if this.Proposal != nil && that1.Proposal != nil {
		if *this.Proposal != *that1.Proposal {
			return fmt.Errorf("Proposal this(%v) Not Equal that(%v)", *this.Proposal, *that1.Proposal)
		}
	} else if this.Proposal != nil {
		return fmt.Errorf("this.Proposal == nil && that.Proposal != nil")
	} else if that1.Proposal != nil {
		return fmt.Errorf("Proposal this(%v) Not Equal that(%v)", this.Proposal, that1.Proposal)
	}
	if this.Position != nil && that1.Position != nil {
		if *this.Position != *that1.Position {
			return fmt.Errorf("Position this(%v) Not Equal that(%v)", *this.Position, *that1.Position)
		}
	} else if this.Position != nil {
		return fmt.Errorf("this.Position == nil && that.Position != nil")
	} else if that1.Position != nil {
		return fmt.Errorf("Position this(%v) Not Equal that(%v)", this.Position, that1.Position)
	}
	if !this.Action.Equal(that1.Action) {
		return fmt.Errorf("Action this(%v) Not Equal that(%v)", this.Action, that1.Action)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *PromiseResponse) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*PromiseResponse)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Okay != nil && that1.Okay != nil {
		if *this.Okay != *that1.Okay {
			return false
		}
	} else if this.Okay != nil {
		return false
	} else if that1.Okay != nil {
		return false
	}
	if this.Proposal != nil && that1.Proposal != nil {
		if *this.Proposal != *that1.Proposal {
			return false
		}
	} else if this.Proposal != nil {
		return false
	} else if that1.Proposal != nil {
		return false
	}
	if this.Position != nil && that1.Position != nil {
		if *this.Position != *that1.Position {
			return false
		}
	} else if this.Position != nil {
		return false
	} else if that1.Position != nil {
		return false
	}
	if !this.Action.Equal(that1.Action) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *WriteRequest) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*WriteRequest)
	if !ok {
		return fmt.Errorf("that is not of type *WriteRequest")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *WriteRequest but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *WriteRequestbut is not nil && this == nil")
	}
	if this.Proposal != nil && that1.Proposal != nil {
		if *this.Proposal != *that1.Proposal {
			return fmt.Errorf("Proposal this(%v) Not Equal that(%v)", *this.Proposal, *that1.Proposal)
		}
	} else if this.Proposal != nil {
		return fmt.Errorf("this.Proposal == nil && that.Proposal != nil")
	} else if that1.Proposal != nil {
		return fmt.Errorf("Proposal this(%v) Not Equal that(%v)", this.Proposal, that1.Proposal)
	}
	if this.Position != nil && that1.Position != nil {
		if *this.Position != *that1.Position {
			return fmt.Errorf("Position this(%v) Not Equal that(%v)", *this.Position, *that1.Position)
		}
	} else if this.Position != nil {
		return fmt.Errorf("this.Position == nil && that.Position != nil")
	} else if that1.Position != nil {
		return fmt.Errorf("Position this(%v) Not Equal that(%v)", this.Position, that1.Position)
	}
	if this.Learned != nil && that1.Learned != nil {
		if *this.Learned != *that1.Learned {
			return fmt.Errorf("Learned this(%v) Not Equal that(%v)", *this.Learned, *that1.Learned)
		}
	} else if this.Learned != nil {
		return fmt.Errorf("this.Learned == nil && that.Learned != nil")
	} else if that1.Learned != nil {
		return fmt.Errorf("Learned this(%v) Not Equal that(%v)", this.Learned, that1.Learned)
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return fmt.Errorf("Type this(%v) Not Equal that(%v)", *this.Type, *that1.Type)
		}
	} else if this.Type != nil {
		return fmt.Errorf("this.Type == nil && that.Type != nil")
	} else if that1.Type != nil {
		return fmt.Errorf("Type this(%v) Not Equal that(%v)", this.Type, that1.Type)
	}
	if !this.Nop.Equal(that1.Nop) {
		return fmt.Errorf("Nop this(%v) Not Equal that(%v)", this.Nop, that1.Nop)
	}
	if !this.Append.Equal(that1.Append) {
		return fmt.Errorf("Append this(%v) Not Equal that(%v)", this.Append, that1.Append)
	}
	if !this.Truncate.Equal(that1.Truncate) {
		return fmt.Errorf("Truncate this(%v) Not Equal that(%v)", this.Truncate, that1.Truncate)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *WriteRequest) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*WriteRequest)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Proposal != nil && that1.Proposal != nil {
		if *this.Proposal != *that1.Proposal {
			return false
		}
	} else if this.Proposal != nil {
		return false
	} else if that1.Proposal != nil {
		return false
	}
	if this.Position != nil && that1.Position != nil {
		if *this.Position != *that1.Position {
			return false
		}
	} else if this.Position != nil {
		return false
	} else if that1.Position != nil {
		return false
	}
	if this.Learned != nil && that1.Learned != nil {
		if *this.Learned != *that1.Learned {
			return false
		}
	} else if this.Learned != nil {
		return false
	} else if that1.Learned != nil {
		return false
	}
	if this.Type != nil && that1.Type != nil {
		if *this.Type != *that1.Type {
			return false
		}
	} else if this.Type != nil {
		return false
	} else if that1.Type != nil {
		return false
	}
	if !this.Nop.Equal(that1.Nop) {
		return false
	}
	if !this.Append.Equal(that1.Append) {
		return false
	}
	if !this.Truncate.Equal(that1.Truncate) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *WriteResponse) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*WriteResponse)
	if !ok {
		return fmt.Errorf("that is not of type *WriteResponse")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *WriteResponse but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *WriteResponsebut is not nil && this == nil")
	}
	if this.Okay != nil && that1.Okay != nil {
		if *this.Okay != *that1.Okay {
			return fmt.Errorf("Okay this(%v) Not Equal that(%v)", *this.Okay, *that1.Okay)
		}
	} else if this.Okay != nil {
		return fmt.Errorf("this.Okay == nil && that.Okay != nil")
	} else if that1.Okay != nil {
		return fmt.Errorf("Okay this(%v) Not Equal that(%v)", this.Okay, that1.Okay)
	}
	if this.Proposal != nil && that1.Proposal != nil {
		if *this.Proposal != *that1.Proposal {
			return fmt.Errorf("Proposal this(%v) Not Equal that(%v)", *this.Proposal, *that1.Proposal)
		}
	} else if this.Proposal != nil {
		return fmt.Errorf("this.Proposal == nil && that.Proposal != nil")
	} else if that1.Proposal != nil {
		return fmt.Errorf("Proposal this(%v) Not Equal that(%v)", this.Proposal, that1.Proposal)
	}
	if this.Position != nil && that1.Position != nil {
		if *this.Position != *that1.Position {
			return fmt.Errorf("Position this(%v) Not Equal that(%v)", *this.Position, *that1.Position)
		}
	} else if this.Position != nil {
		return fmt.Errorf("this.Position == nil && that.Position != nil")
	} else if that1.Position != nil {
		return fmt.Errorf("Position this(%v) Not Equal that(%v)", this.Position, that1.Position)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *WriteResponse) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*WriteResponse)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Okay != nil && that1.Okay != nil {
		if *this.Okay != *that1.Okay {
			return false
		}
	} else if this.Okay != nil {
		return false
	} else if that1.Okay != nil {
		return false
	}
	if this.Proposal != nil && that1.Proposal != nil {
		if *this.Proposal != *that1.Proposal {
			return false
		}
	} else if this.Proposal != nil {
		return false
	} else if that1.Proposal != nil {
		return false
	}
	if this.Position != nil && that1.Position != nil {
		if *this.Position != *that1.Position {
			return false
		}
	} else if this.Position != nil {
		return false
	} else if that1.Position != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *LearnedMessage) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*LearnedMessage)
	if !ok {
		return fmt.Errorf("that is not of type *LearnedMessage")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *LearnedMessage but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *LearnedMessagebut is not nil && this == nil")
	}
	if !this.Action.Equal(that1.Action) {
		return fmt.Errorf("Action this(%v) Not Equal that(%v)", this.Action, that1.Action)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *LearnedMessage) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*LearnedMessage)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Action.Equal(that1.Action) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *RecoverRequest) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*RecoverRequest)
	if !ok {
		return fmt.Errorf("that is not of type *RecoverRequest")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *RecoverRequest but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *RecoverRequestbut is not nil && this == nil")
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *RecoverRequest) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RecoverRequest)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *RecoverResponse) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*RecoverResponse)
	if !ok {
		return fmt.Errorf("that is not of type *RecoverResponse")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *RecoverResponse but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *RecoverResponsebut is not nil && this == nil")
	}
	if this.Status != nil && that1.Status != nil {
		if *this.Status != *that1.Status {
			return fmt.Errorf("Status this(%v) Not Equal that(%v)", *this.Status, *that1.Status)
		}
	} else if this.Status != nil {
		return fmt.Errorf("this.Status == nil && that.Status != nil")
	} else if that1.Status != nil {
		return fmt.Errorf("Status this(%v) Not Equal that(%v)", this.Status, that1.Status)
	}
	if this.Begin != nil && that1.Begin != nil {
		if *this.Begin != *that1.Begin {
			return fmt.Errorf("Begin this(%v) Not Equal that(%v)", *this.Begin, *that1.Begin)
		}
	} else if this.Begin != nil {
		return fmt.Errorf("this.Begin == nil && that.Begin != nil")
	} else if that1.Begin != nil {
		return fmt.Errorf("Begin this(%v) Not Equal that(%v)", this.Begin, that1.Begin)
	}
	if this.End != nil && that1.End != nil {
		if *this.End != *that1.End {
			return fmt.Errorf("End this(%v) Not Equal that(%v)", *this.End, *that1.End)
		}
	} else if this.End != nil {
		return fmt.Errorf("this.End == nil && that.End != nil")
	} else if that1.End != nil {
		return fmt.Errorf("End this(%v) Not Equal that(%v)", this.End, that1.End)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *RecoverResponse) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RecoverResponse)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Status != nil && that1.Status != nil {
		if *this.Status != *that1.Status {
			return false
		}
	} else if this.Status != nil {
		return false
	} else if that1.Status != nil {
		return false
	}
	if this.Begin != nil && that1.Begin != nil {
		if *this.Begin != *that1.Begin {
			return false
		}
	} else if this.Begin != nil {
		return false
	} else if that1.Begin != nil {
		return false
	}
	if this.End != nil && that1.End != nil {
		if *this.End != *that1.End {
			return false
		}
	} else if this.End != nil {
		return false
	} else if that1.End != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Promise) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.Promise{")
	if this.Proposal != nil {
		s = append(s, "Proposal: "+valueToGoStringLog(this.Proposal, "uint64")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Action) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 12)
	s = append(s, "&mesosproto.Action{")
	if this.Position != nil {
		s = append(s, "Position: "+valueToGoStringLog(this.Position, "uint64")+",\n")
	}
	if this.Promised != nil {
		s = append(s, "Promised: "+valueToGoStringLog(this.Promised, "uint64")+",\n")
	}
	if this.Performed != nil {
		s = append(s, "Performed: "+valueToGoStringLog(this.Performed, "uint64")+",\n")
	}
	if this.Learned != nil {
		s = append(s, "Learned: "+valueToGoStringLog(this.Learned, "bool")+",\n")
	}
	if this.Type != nil {
		s = append(s, "Type: "+valueToGoStringLog(this.Type, "mesosproto.Action_Type")+",\n")
	}
	if this.Nop != nil {
		s = append(s, "Nop: "+fmt.Sprintf("%#v", this.Nop)+",\n")
	}
	if this.Append != nil {
		s = append(s, "Append: "+fmt.Sprintf("%#v", this.Append)+",\n")
	}
	if this.Truncate != nil {
		s = append(s, "Truncate: "+fmt.Sprintf("%#v", this.Truncate)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Action_Nop) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&mesosproto.Action_Nop{")
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Action_Append) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesosproto.Action_Append{")
	if this.Bytes != nil {
		s = append(s, "Bytes: "+valueToGoStringLog(this.Bytes, "byte")+",\n")
	}
	if this.Cksum != nil {
		s = append(s, "Cksum: "+valueToGoStringLog(this.Cksum, "byte")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Action_Truncate) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.Action_Truncate{")
	if this.To != nil {
		s = append(s, "To: "+valueToGoStringLog(this.To, "uint64")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Metadata) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesosproto.Metadata{")
	if this.Status != nil {
		s = append(s, "Status: "+valueToGoStringLog(this.Status, "mesosproto.Metadata_Status")+",\n")
	}
	if this.Promised != nil {
		s = append(s, "Promised: "+valueToGoStringLog(this.Promised, "uint64")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Record) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&mesosproto.Record{")
	if this.Type != nil {
		s = append(s, "Type: "+valueToGoStringLog(this.Type, "mesosproto.Record_Type")+",\n")
	}
	if this.Promise != nil {
		s = append(s, "Promise: "+fmt.Sprintf("%#v", this.Promise)+",\n")
	}
	if this.Action != nil {
		s = append(s, "Action: "+fmt.Sprintf("%#v", this.Action)+",\n")
	}
	if this.Metadata != nil {
		s = append(s, "Metadata: "+fmt.Sprintf("%#v", this.Metadata)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PromiseRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesosproto.PromiseRequest{")
	if this.Proposal != nil {
		s = append(s, "Proposal: "+valueToGoStringLog(this.Proposal, "uint64")+",\n")
	}
	if this.Position != nil {
		s = append(s, "Position: "+valueToGoStringLog(this.Position, "uint64")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PromiseResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&mesosproto.PromiseResponse{")
	if this.Okay != nil {
		s = append(s, "Okay: "+valueToGoStringLog(this.Okay, "bool")+",\n")
	}
	if this.Proposal != nil {
		s = append(s, "Proposal: "+valueToGoStringLog(this.Proposal, "uint64")+",\n")
	}
	if this.Position != nil {
		s = append(s, "Position: "+valueToGoStringLog(this.Position, "uint64")+",\n")
	}
	if this.Action != nil {
		s = append(s, "Action: "+fmt.Sprintf("%#v", this.Action)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *WriteRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&mesosproto.WriteRequest{")
	if this.Proposal != nil {
		s = append(s, "Proposal: "+valueToGoStringLog(this.Proposal, "uint64")+",\n")
	}
	if this.Position != nil {
		s = append(s, "Position: "+valueToGoStringLog(this.Position, "uint64")+",\n")
	}
	if this.Learned != nil {
		s = append(s, "Learned: "+valueToGoStringLog(this.Learned, "bool")+",\n")
	}
	if this.Type != nil {
		s = append(s, "Type: "+valueToGoStringLog(this.Type, "mesosproto.Action_Type")+",\n")
	}
	if this.Nop != nil {
		s = append(s, "Nop: "+fmt.Sprintf("%#v", this.Nop)+",\n")
	}
	if this.Append != nil {
		s = append(s, "Append: "+fmt.Sprintf("%#v", this.Append)+",\n")
	}
	if this.Truncate != nil {
		s = append(s, "Truncate: "+fmt.Sprintf("%#v", this.Truncate)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *WriteResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&mesosproto.WriteResponse{")
	if this.Okay != nil {
		s = append(s, "Okay: "+valueToGoStringLog(this.Okay, "bool")+",\n")
	}
	if this.Proposal != nil {
		s = append(s, "Proposal: "+valueToGoStringLog(this.Proposal, "uint64")+",\n")
	}
	if this.Position != nil {
		s = append(s, "Position: "+valueToGoStringLog(this.Position, "uint64")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *LearnedMessage) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.LearnedMessage{")
	if this.Action != nil {
		s = append(s, "Action: "+fmt.Sprintf("%#v", this.Action)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RecoverRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&mesosproto.RecoverRequest{")
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *RecoverResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&mesosproto.RecoverResponse{")
	if this.Status != nil {
		s = append(s, "Status: "+valueToGoStringLog(this.Status, "mesosproto.Metadata_Status")+",\n")
	}
	if this.Begin != nil {
		s = append(s, "Begin: "+valueToGoStringLog(this.Begin, "uint64")+",\n")
	}
	if this.End != nil {
		s = append(s, "End: "+valueToGoStringLog(this.End, "uint64")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringLog(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func extensionToGoStringLog(e map[int32]github_com_gogo_protobuf_proto.Extension) string {
	if e == nil {
		return "nil"
	}
	s := "map[int32]proto.Extension{"
	keys := make([]int, 0, len(e))
	for k := range e {
		keys = append(keys, int(k))
	}
	sort.Ints(keys)
	ss := []string{}
	for _, k := range keys {
		ss = append(ss, strconv.Itoa(k)+": "+e[int32(k)].GoString())
	}
	s += strings.Join(ss, ",") + "}"
	return s
}
func (m *Promise) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Promise) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Proposal == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("proposal")
	} else {
		data[i] = 0x8
		i++
		i = encodeVarintLog(data, i, uint64(*m.Proposal))
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Action) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Action) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Position == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("position")
	} else {
		data[i] = 0x8
		i++
		i = encodeVarintLog(data, i, uint64(*m.Position))
	}
	if m.Promised == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("promised")
	} else {
		data[i] = 0x10
		i++
		i = encodeVarintLog(data, i, uint64(*m.Promised))
	}
	if m.Performed != nil {
		data[i] = 0x18
		i++
		i = encodeVarintLog(data, i, uint64(*m.Performed))
	}
	if m.Learned != nil {
		data[i] = 0x20
		i++
		if *m.Learned {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.Type != nil {
		data[i] = 0x28
		i++
		i = encodeVarintLog(data, i, uint64(*m.Type))
	}
	if m.Nop != nil {
		data[i] = 0x32
		i++
		i = encodeVarintLog(data, i, uint64(m.Nop.Size()))
		n1, err := m.Nop.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.Append != nil {
		data[i] = 0x3a
		i++
		i = encodeVarintLog(data, i, uint64(m.Append.Size()))
		n2, err := m.Append.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.Truncate != nil {
		data[i] = 0x42
		i++
		i = encodeVarintLog(data, i, uint64(m.Truncate.Size()))
		n3, err := m.Truncate.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Action_Nop) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Action_Nop) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Action_Append) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Action_Append) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Bytes == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("bytes")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintLog(data, i, uint64(len(m.Bytes)))
		i += copy(data[i:], m.Bytes)
	}
	if m.Cksum != nil {
		data[i] = 0x12
		i++
		i = encodeVarintLog(data, i, uint64(len(m.Cksum)))
		i += copy(data[i:], m.Cksum)
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Action_Truncate) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Action_Truncate) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.To == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("to")
	} else {
		data[i] = 0x8
		i++
		i = encodeVarintLog(data, i, uint64(*m.To))
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Metadata) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Metadata) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Status == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("status")
	} else {
		data[i] = 0x8
		i++
		i = encodeVarintLog(data, i, uint64(*m.Status))
	}
	if m.Promised == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("promised")
	} else {
		data[i] = 0x10
		i++
		i = encodeVarintLog(data, i, uint64(*m.Promised))
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Record) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Record) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("type")
	} else {
		data[i] = 0x8
		i++
		i = encodeVarintLog(data, i, uint64(*m.Type))
	}
	if m.Promise != nil {
		data[i] = 0x12
		i++
		i = encodeVarintLog(data, i, uint64(m.Promise.Size()))
		n4, err := m.Promise.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.Action != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintLog(data, i, uint64(m.Action.Size()))
		n5, err := m.Action.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.Metadata != nil {
		data[i] = 0x22
		i++
		i = encodeVarintLog(data, i, uint64(m.Metadata.Size()))
		n6, err := m.Metadata.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PromiseRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *PromiseRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Proposal == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("proposal")
	} else {
		data[i] = 0x8
		i++
		i = encodeVarintLog(data, i, uint64(*m.Proposal))
	}
	if m.Position != nil {
		data[i] = 0x10
		i++
		i = encodeVarintLog(data, i, uint64(*m.Position))
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PromiseResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *PromiseResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Okay == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("okay")
	} else {
		data[i] = 0x8
		i++
		if *m.Okay {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.Proposal == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("proposal")
	} else {
		data[i] = 0x10
		i++
		i = encodeVarintLog(data, i, uint64(*m.Proposal))
	}
	if m.Action != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintLog(data, i, uint64(m.Action.Size()))
		n7, err := m.Action.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.Position != nil {
		data[i] = 0x20
		i++
		i = encodeVarintLog(data, i, uint64(*m.Position))
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *WriteRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *WriteRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Proposal == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("proposal")
	} else {
		data[i] = 0x8
		i++
		i = encodeVarintLog(data, i, uint64(*m.Proposal))
	}
	if m.Position == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("position")
	} else {
		data[i] = 0x10
		i++
		i = encodeVarintLog(data, i, uint64(*m.Position))
	}
	if m.Learned != nil {
		data[i] = 0x18
		i++
		if *m.Learned {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.Type == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("type")
	} else {
		data[i] = 0x20
		i++
		i = encodeVarintLog(data, i, uint64(*m.Type))
	}
	if m.Nop != nil {
		data[i] = 0x2a
		i++
		i = encodeVarintLog(data, i, uint64(m.Nop.Size()))
		n8, err := m.Nop.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.Append != nil {
		data[i] = 0x32
		i++
		i = encodeVarintLog(data, i, uint64(m.Append.Size()))
		n9, err := m.Append.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.Truncate != nil {
		data[i] = 0x3a
		i++
		i = encodeVarintLog(data, i, uint64(m.Truncate.Size()))
		n10, err := m.Truncate.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *WriteResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *WriteResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Okay == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("okay")
	} else {
		data[i] = 0x8
		i++
		if *m.Okay {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.Proposal == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("proposal")
	} else {
		data[i] = 0x10
		i++
		i = encodeVarintLog(data, i, uint64(*m.Proposal))
	}
	if m.Position == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("position")
	} else {
		data[i] = 0x18
		i++
		i = encodeVarintLog(data, i, uint64(*m.Position))
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *LearnedMessage) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *LearnedMessage) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Action == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("action")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintLog(data, i, uint64(m.Action.Size()))
		n11, err := m.Action.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RecoverRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *RecoverRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RecoverResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *RecoverResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Status == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("status")
	} else {
		data[i] = 0x8
		i++
		i = encodeVarintLog(data, i, uint64(*m.Status))
	}
	if m.Begin != nil {
		data[i] = 0x10
		i++
		i = encodeVarintLog(data, i, uint64(*m.Begin))
	}
	if m.End != nil {
		data[i] = 0x18
		i++
		i = encodeVarintLog(data, i, uint64(*m.End))
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeFixed64Log(data []byte, offset int, v uint64) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	data[offset+4] = uint8(v >> 32)
	data[offset+5] = uint8(v >> 40)
	data[offset+6] = uint8(v >> 48)
	data[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Log(data []byte, offset int, v uint32) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintLog(data []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		data[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	data[offset] = uint8(v)
	return offset + 1
}
func NewPopulatedPromise(r randyLog, easy bool) *Promise {
	this := &Promise{}
	v1 := uint64(uint64(r.Uint32()))
	this.Proposal = &v1
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedLog(r, 2)
	}
	return this
}

func NewPopulatedAction(r randyLog, easy bool) *Action {
	this := &Action{}
	v2 := uint64(uint64(r.Uint32()))
	this.Position = &v2
	v3 := uint64(uint64(r.Uint32()))
	this.Promised = &v3
	if r.Intn(10) != 0 {
		v4 := uint64(uint64(r.Uint32()))
		this.Performed = &v4
	}
	if r.Intn(10) != 0 {
		v5 := bool(bool(r.Intn(2) == 0))
		this.Learned = &v5
	}
	if r.Intn(10) != 0 {
		v6 := Action_Type([]int32{1, 2, 3}[r.Intn(3)])
		this.Type = &v6
	}
	if r.Intn(10) != 0 {
		this.Nop = NewPopulatedAction_Nop(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Append = NewPopulatedAction_Append(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Truncate = NewPopulatedAction_Truncate(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedLog(r, 9)
	}
	return this
}

func NewPopulatedAction_Nop(r randyLog, easy bool) *Action_Nop {
	this := &Action_Nop{}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedLog(r, 1)
	}
	return this
}

func NewPopulatedAction_Append(r randyLog, easy bool) *Action_Append {
	this := &Action_Append{}
	v7 := r.Intn(100)
	this.Bytes = make([]byte, v7)
	for i := 0; i < v7; i++ {
		this.Bytes[i] = byte(r.Intn(256))
	}
	if r.Intn(10) != 0 {
		v8 := r.Intn(100)
		this.Cksum = make([]byte, v8)
		for i := 0; i < v8; i++ {
			this.Cksum[i] = byte(r.Intn(256))
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedLog(r, 3)
	}
	return this
}

func NewPopulatedAction_Truncate(r randyLog, easy bool) *Action_Truncate {
	this := &Action_Truncate{}
	v9 := uint64(uint64(r.Uint32()))
	this.To = &v9
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedLog(r, 2)
	}
	return this
}

func NewPopulatedMetadata(r randyLog, easy bool) *Metadata {
	this := &Metadata{}
	v10 := Metadata_Status([]int32{1, 2, 3, 4}[r.Intn(4)])
	this.Status = &v10
	v11 := uint64(uint64(r.Uint32()))
	this.Promised = &v11
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedLog(r, 3)
	}
	return this
}

func NewPopulatedRecord(r randyLog, easy bool) *Record {
	this := &Record{}
	v12 := Record_Type([]int32{1, 2, 3}[r.Intn(3)])
	this.Type = &v12
	if r.Intn(10) != 0 {
		this.Promise = NewPopulatedPromise(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Action = NewPopulatedAction(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Metadata = NewPopulatedMetadata(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedLog(r, 5)
	}
	return this
}

func NewPopulatedPromiseRequest(r randyLog, easy bool) *PromiseRequest {
	this := &PromiseRequest{}
	v13 := uint64(uint64(r.Uint32()))
	this.Proposal = &v13
	if r.Intn(10) != 0 {
		v14 := uint64(uint64(r.Uint32()))
		this.Position = &v14
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedLog(r, 3)
	}
	return this
}

func NewPopulatedPromiseResponse(r randyLog, easy bool) *PromiseResponse {
	this := &PromiseResponse{}
	v15 := bool(bool(r.Intn(2) == 0))
	this.Okay = &v15
	v16 := uint64(uint64(r.Uint32()))
	this.Proposal = &v16
	if r.Intn(10) != 0 {
		this.Action = NewPopulatedAction(r, easy)
	}
	if r.Intn(10) != 0 {
		v17 := uint64(uint64(r.Uint32()))
		this.Position = &v17
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedLog(r, 5)
	}
	return this
}

func NewPopulatedWriteRequest(r randyLog, easy bool) *WriteRequest {
	this := &WriteRequest{}
	v18 := uint64(uint64(r.Uint32()))
	this.Proposal = &v18
	v19 := uint64(uint64(r.Uint32()))
	this.Position = &v19
	if r.Intn(10) != 0 {
		v20 := bool(bool(r.Intn(2) == 0))
		this.Learned = &v20
	}
	v21 := Action_Type([]int32{1, 2, 3}[r.Intn(3)])
	this.Type = &v21
	if r.Intn(10) != 0 {
		this.Nop = NewPopulatedAction_Nop(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Append = NewPopulatedAction_Append(r, easy)
	}
	if r.Intn(10) != 0 {
		this.Truncate = NewPopulatedAction_Truncate(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedLog(r, 8)
	}
	return this
}

func NewPopulatedWriteResponse(r randyLog, easy bool) *WriteResponse {
	this := &WriteResponse{}
	v22 := bool(bool(r.Intn(2) == 0))
	this.Okay = &v22
	v23 := uint64(uint64(r.Uint32()))
	this.Proposal = &v23
	v24 := uint64(uint64(r.Uint32()))
	this.Position = &v24
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedLog(r, 4)
	}
	return this
}

func NewPopulatedLearnedMessage(r randyLog, easy bool) *LearnedMessage {
	this := &LearnedMessage{}
	this.Action = NewPopulatedAction(r, easy)
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedLog(r, 2)
	}
	return this
}

func NewPopulatedRecoverRequest(r randyLog, easy bool) *RecoverRequest {
	this := &RecoverRequest{}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedLog(r, 1)
	}
	return this
}

func NewPopulatedRecoverResponse(r randyLog, easy bool) *RecoverResponse {
	this := &RecoverResponse{}
	v25 := Metadata_Status([]int32{1, 2, 3, 4}[r.Intn(4)])
	this.Status = &v25
	if r.Intn(10) != 0 {
		v26 := uint64(uint64(r.Uint32()))
		this.Begin = &v26
	}
	if r.Intn(10) != 0 {
		v27 := uint64(uint64(r.Uint32()))
		this.End = &v27
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedLog(r, 4)
	}
	return this
}

type randyLog interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneLog(r randyLog) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringLog(r randyLog) string {
	v28 := r.Intn(100)
	tmps := make([]rune, v28)
	for i := 0; i < v28; i++ {
		tmps[i] = randUTF8RuneLog(r)
	}
	return string(tmps)
}
func randUnrecognizedLog(r randyLog, maxFieldNumber int) (data []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		data = randFieldLog(data, r, fieldNumber, wire)
	}
	return data
}
func randFieldLog(data []byte, r randyLog, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		data = encodeVarintPopulateLog(data, uint64(key))
		v29 := r.Int63()
		if r.Intn(2) == 0 {
			v29 *= -1
		}
		data = encodeVarintPopulateLog(data, uint64(v29))
	case 1:
		data = encodeVarintPopulateLog(data, uint64(key))
		data = append(data, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		data = encodeVarintPopulateLog(data, uint64(key))
		ll := r.Intn(100)
		data = encodeVarintPopulateLog(data, uint64(ll))
		for j := 0; j < ll; j++ {
			data = append(data, byte(r.Intn(256)))
		}
	default:
		data = encodeVarintPopulateLog(data, uint64(key))
		data = append(data, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return data
}
func encodeVarintPopulateLog(data []byte, v uint64) []byte {
	for v >= 1<<7 {
		data = append(data, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	data = append(data, uint8(v))
	return data
}
func (m *Promise) Size() (n int) {
	var l int
	_ = l
	if m.Proposal != nil {
		n += 1 + sovLog(uint64(*m.Proposal))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Action) Size() (n int) {
	var l int
	_ = l
	if m.Position != nil {
		n += 1 + sovLog(uint64(*m.Position))
	}
	if m.Promised != nil {
		n += 1 + sovLog(uint64(*m.Promised))
	}
	if m.Performed != nil {
		n += 1 + sovLog(uint64(*m.Performed))
	}
	if m.Learned != nil {
		n += 2
	}
	if m.Type != nil {
		n += 1 + sovLog(uint64(*m.Type))
	}
	if m.Nop != nil {
		l = m.Nop.Size()
		n += 1 + l + sovLog(uint64(l))
	}
	if m.Append != nil {
		l = m.Append.Size()
		n += 1 + l + sovLog(uint64(l))
	}
	if m.Truncate != nil {
		l = m.Truncate.Size()
		n += 1 + l + sovLog(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Action_Nop) Size() (n int) {
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Action_Append) Size() (n int) {
	var l int
	_ = l
	if m.Bytes != nil {
		l = len(m.Bytes)
		n += 1 + l + sovLog(uint64(l))
	}
	if m.Cksum != nil {
		l = len(m.Cksum)
		n += 1 + l + sovLog(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Action_Truncate) Size() (n int) {
	var l int
	_ = l
	if m.To != nil {
		n += 1 + sovLog(uint64(*m.To))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Metadata) Size() (n int) {
	var l int
	_ = l
	if m.Status != nil {
		n += 1 + sovLog(uint64(*m.Status))
	}
	if m.Promised != nil {
		n += 1 + sovLog(uint64(*m.Promised))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Record) Size() (n int) {
	var l int
	_ = l
	if m.Type != nil {
		n += 1 + sovLog(uint64(*m.Type))
	}
	if m.Promise != nil {
		l = m.Promise.Size()
		n += 1 + l + sovLog(uint64(l))
	}
	if m.Action != nil {
		l = m.Action.Size()
		n += 1 + l + sovLog(uint64(l))
	}
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovLog(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PromiseRequest) Size() (n int) {
	var l int
	_ = l
	if m.Proposal != nil {
		n += 1 + sovLog(uint64(*m.Proposal))
	}
	if m.Position != nil {
		n += 1 + sovLog(uint64(*m.Position))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PromiseResponse) Size() (n int) {
	var l int
	_ = l
	if m.Okay != nil {
		n += 2
	}
	if m.Proposal != nil {
		n += 1 + sovLog(uint64(*m.Proposal))
	}
	if m.Action != nil {
		l = m.Action.Size()
		n += 1 + l + sovLog(uint64(l))
	}
	if m.Position != nil {
		n += 1 + sovLog(uint64(*m.Position))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *WriteRequest) Size() (n int) {
	var l int
	_ = l
	if m.Proposal != nil {
		n += 1 + sovLog(uint64(*m.Proposal))
	}
	if m.Position != nil {
		n += 1 + sovLog(uint64(*m.Position))
	}
	if m.Learned != nil {
		n += 2
	}
	if m.Type != nil {
		n += 1 + sovLog(uint64(*m.Type))
	}
	if m.Nop != nil {
		l = m.Nop.Size()
		n += 1 + l + sovLog(uint64(l))
	}
	if m.Append != nil {
		l = m.Append.Size()
		n += 1 + l + sovLog(uint64(l))
	}
	if m.Truncate != nil {
		l = m.Truncate.Size()
		n += 1 + l + sovLog(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *WriteResponse) Size() (n int) {
	var l int
	_ = l
	if m.Okay != nil {
		n += 2
	}
	if m.Proposal != nil {
		n += 1 + sovLog(uint64(*m.Proposal))
	}
	if m.Position != nil {
		n += 1 + sovLog(uint64(*m.Position))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *LearnedMessage) Size() (n int) {
	var l int
	_ = l
	if m.Action != nil {
		l = m.Action.Size()
		n += 1 + l + sovLog(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RecoverRequest) Size() (n int) {
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RecoverResponse) Size() (n int) {
	var l int
	_ = l
	if m.Status != nil {
		n += 1 + sovLog(uint64(*m.Status))
	}
	if m.Begin != nil {
		n += 1 + sovLog(uint64(*m.Begin))
	}
	if m.End != nil {
		n += 1 + sovLog(uint64(*m.End))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovLog(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozLog(x uint64) (n int) {
	return sovLog(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Promise) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Promise{`,
		`Proposal:` + valueToStringLog(this.Proposal) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Action) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Action{`,
		`Position:` + valueToStringLog(this.Position) + `,`,
		`Promised:` + valueToStringLog(this.Promised) + `,`,
		`Performed:` + valueToStringLog(this.Performed) + `,`,
		`Learned:` + valueToStringLog(this.Learned) + `,`,
		`Type:` + valueToStringLog(this.Type) + `,`,
		`Nop:` + strings.Replace(fmt.Sprintf("%v", this.Nop), "Action_Nop", "Action_Nop", 1) + `,`,
		`Append:` + strings.Replace(fmt.Sprintf("%v", this.Append), "Action_Append", "Action_Append", 1) + `,`,
		`Truncate:` + strings.Replace(fmt.Sprintf("%v", this.Truncate), "Action_Truncate", "Action_Truncate", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Action_Nop) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Action_Nop{`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Action_Append) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Action_Append{`,
		`Bytes:` + valueToStringLog(this.Bytes) + `,`,
		`Cksum:` + valueToStringLog(this.Cksum) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Action_Truncate) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Action_Truncate{`,
		`To:` + valueToStringLog(this.To) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Metadata) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Metadata{`,
		`Status:` + valueToStringLog(this.Status) + `,`,
		`Promised:` + valueToStringLog(this.Promised) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Record) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Record{`,
		`Type:` + valueToStringLog(this.Type) + `,`,
		`Promise:` + strings.Replace(fmt.Sprintf("%v", this.Promise), "Promise", "Promise", 1) + `,`,
		`Action:` + strings.Replace(fmt.Sprintf("%v", this.Action), "Action", "Action", 1) + `,`,
		`Metadata:` + strings.Replace(fmt.Sprintf("%v", this.Metadata), "Metadata", "Metadata", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PromiseRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PromiseRequest{`,
		`Proposal:` + valueToStringLog(this.Proposal) + `,`,
		`Position:` + valueToStringLog(this.Position) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PromiseResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PromiseResponse{`,
		`Okay:` + valueToStringLog(this.Okay) + `,`,
		`Proposal:` + valueToStringLog(this.Proposal) + `,`,
		`Action:` + strings.Replace(fmt.Sprintf("%v", this.Action), "Action", "Action", 1) + `,`,
		`Position:` + valueToStringLog(this.Position) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WriteRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WriteRequest{`,
		`Proposal:` + valueToStringLog(this.Proposal) + `,`,
		`Position:` + valueToStringLog(this.Position) + `,`,
		`Learned:` + valueToStringLog(this.Learned) + `,`,
		`Type:` + valueToStringLog(this.Type) + `,`,
		`Nop:` + strings.Replace(fmt.Sprintf("%v", this.Nop), "Action_Nop", "Action_Nop", 1) + `,`,
		`Append:` + strings.Replace(fmt.Sprintf("%v", this.Append), "Action_Append", "Action_Append", 1) + `,`,
		`Truncate:` + strings.Replace(fmt.Sprintf("%v", this.Truncate), "Action_Truncate", "Action_Truncate", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WriteResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WriteResponse{`,
		`Okay:` + valueToStringLog(this.Okay) + `,`,
		`Proposal:` + valueToStringLog(this.Proposal) + `,`,
		`Position:` + valueToStringLog(this.Position) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LearnedMessage) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&LearnedMessage{`,
		`Action:` + strings.Replace(fmt.Sprintf("%v", this.Action), "Action", "Action", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RecoverRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RecoverRequest{`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RecoverResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RecoverResponse{`,
		`Status:` + valueToStringLog(this.Status) + `,`,
		`Begin:` + valueToStringLog(this.Begin) + `,`,
		`End:` + valueToStringLog(this.End) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringLog(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Promise) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Proposal", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Proposal = &v
			hasFields[0] |= uint64(0x00000001)
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			iNdEx -= sizeOfWire
			skippy, err := skipLog(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthLog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("proposal")
	}

	return nil
}
func (m *Action) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Position", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Position = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Promised", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Promised = &v
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Performed", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Performed = &v
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Learned", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Learned = &b
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var v Action_Type
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (Action_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Type = &v
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nop", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLog
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Nop == nil {
				m.Nop = &Action_Nop{}
			}
			if err := m.Nop.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Append", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLog
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Append == nil {
				m.Append = &Action_Append{}
			}
			if err := m.Append.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Truncate", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLog
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Truncate == nil {
				m.Truncate = &Action_Truncate{}
			}
			if err := m.Truncate.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			iNdEx -= sizeOfWire
			skippy, err := skipLog(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthLog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("position")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("promised")
	}

	return nil
}
func (m *Action_Nop) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		switch fieldNum {
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			iNdEx -= sizeOfWire
			skippy, err := skipLog(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthLog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	return nil
}
func (m *Action_Append) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bytes", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthLog
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Bytes = append([]byte{}, data[iNdEx:postIndex]...)
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cksum", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthLog
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cksum = append([]byte{}, data[iNdEx:postIndex]...)
			iNdEx = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			iNdEx -= sizeOfWire
			skippy, err := skipLog(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthLog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("bytes")
	}

	return nil
}
func (m *Action_Truncate) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field To", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.To = &v
			hasFields[0] |= uint64(0x00000001)
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			iNdEx -= sizeOfWire
			skippy, err := skipLog(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthLog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("to")
	}

	return nil
}
func (m *Metadata) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var v Metadata_Status
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (Metadata_Status(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Status = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Promised", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Promised = &v
			hasFields[0] |= uint64(0x00000002)
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			iNdEx -= sizeOfWire
			skippy, err := skipLog(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthLog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("status")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("promised")
	}

	return nil
}
func (m *Record) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var v Record_Type
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (Record_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Type = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Promise", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLog
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Promise == nil {
				m.Promise = &Promise{}
			}
			if err := m.Promise.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Action", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLog
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Action == nil {
				m.Action = &Action{}
			}
			if err := m.Action.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLog
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &Metadata{}
			}
			if err := m.Metadata.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			iNdEx -= sizeOfWire
			skippy, err := skipLog(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthLog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("type")
	}

	return nil
}
func (m *PromiseRequest) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Proposal", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Proposal = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Position", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Position = &v
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			iNdEx -= sizeOfWire
			skippy, err := skipLog(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthLog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("proposal")
	}

	return nil
}
func (m *PromiseResponse) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Okay", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Okay = &b
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Proposal", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Proposal = &v
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Action", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLog
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Action == nil {
				m.Action = &Action{}
			}
			if err := m.Action.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Position", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Position = &v
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			iNdEx -= sizeOfWire
			skippy, err := skipLog(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthLog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("okay")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("proposal")
	}

	return nil
}
func (m *WriteRequest) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Proposal", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Proposal = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Position", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Position = &v
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Learned", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Learned = &b
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var v Action_Type
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (Action_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Type = &v
			hasFields[0] |= uint64(0x00000004)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nop", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLog
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Nop == nil {
				m.Nop = &Action_Nop{}
			}
			if err := m.Nop.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Append", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLog
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Append == nil {
				m.Append = &Action_Append{}
			}
			if err := m.Append.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Truncate", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLog
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Truncate == nil {
				m.Truncate = &Action_Truncate{}
			}
			if err := m.Truncate.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			iNdEx -= sizeOfWire
			skippy, err := skipLog(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthLog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("proposal")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("position")
	}
	if hasFields[0]&uint64(0x00000004) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("type")
	}

	return nil
}
func (m *WriteResponse) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Okay", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Okay = &b
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Proposal", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Proposal = &v
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Position", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Position = &v
			hasFields[0] |= uint64(0x00000004)
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			iNdEx -= sizeOfWire
			skippy, err := skipLog(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthLog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("okay")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("proposal")
	}
	if hasFields[0]&uint64(0x00000004) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("position")
	}

	return nil
}
func (m *LearnedMessage) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Action", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthLog
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Action == nil {
				m.Action = &Action{}
			}
			if err := m.Action.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			iNdEx -= sizeOfWire
			skippy, err := skipLog(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthLog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("action")
	}

	return nil
}
func (m *RecoverRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		switch fieldNum {
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			iNdEx -= sizeOfWire
			skippy, err := skipLog(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthLog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	return nil
}
func (m *RecoverResponse) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var v Metadata_Status
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (Metadata_Status(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Status = &v
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Begin", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Begin = &v
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field End", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.End = &v
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			iNdEx -= sizeOfWire
			skippy, err := skipLog(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthLog
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("status")
	}

	return nil
}
func skipLog(data []byte) (n int, err error) {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for {
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if data[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthLog
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := data[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipLog(data[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthLog = fmt.Errorf("proto: negative length found during unmarshaling")
)
