package yarn

import "github.com/knqyf263/go-dep-parser/pkg/types"

var (
	// docker run --name composer --rm -it node:12-alpine sh
	// yarn init
	// yarn add promise jquery
	// yarn list | grep -E -o "\S+@[^\^~]\S+" | awk -F@ 'NR>0 {printf("{\""$1"\", \""$2"\"},\n")}'
	YarnNormal = []types.Library{
		{"asap", "2.0.6"},
		{"jquery", "3.4.1"},
		{"promise", "8.0.3"},
	}

	// ... and
	// yarn add react redux
	// yarn list | grep -E -o "\S+@[^\^~]\S+" | awk -F@ 'NR>0 {printf("{\""$1"\", \""$2"\"},\n")}'
	YarnReact = []types.Library{
		{"asap", "2.0.6"},
		{"jquery", "3.4.1"},
		{"js-tokens", "4.0.0"},
		{"loose-envify", "1.4.0"},
		{"object-assign", "4.1.1"},
		{"promise", "8.0.3"},
		{"prop-types", "15.7.2"},
		{"react-is", "16.8.6"},
		{"react", "16.8.6"},
		{"redux", "4.0.1"},
		{"scheduler", "0.13.6"},
		{"symbol-observable", "1.2.0"},
	}

	// ... and
	// yarn add -D mocha
	// yarn list | grep -E -o "\S+@[^\^~]\S+" | awk -F@ 'NR>0 {printf("{\""$1"\", \""$2"\"},\n")}' | sort | uniq
	YarnWithDev = []types.Library{
		{"ansi-colors", "3.2.3"},
		{"ansi-regex", "2.1.1"},
		{"ansi-regex", "3.0.0"},
		{"ansi-regex", "4.1.0"},
		{"ansi-styles", "3.2.1"},
		{"argparse", "1.0.10"},
		{"asap", "2.0.6"},
		{"balanced-match", "1.0.0"},
		{"brace-expansion", "1.1.11"},
		{"browser-stdout", "1.3.1"},
		{"camelcase", "5.3.1"},
		{"chalk", "2.4.2"},
		{"cliui", "4.1.0"},
		{"code-point-at", "1.1.0"},
		{"color-convert", "1.9.3"},
		{"color-name", "1.1.3"},
		{"concat-map", "0.0.1"},
		{"cross-spawn", "6.0.5"},
		{"debug", "3.2.6"},
		{"decamelize", "1.2.0"},
		{"define-properties", "1.1.3"},
		{"diff", "3.5.0"},
		{"emoji-regex", "7.0.3"},
		{"end-of-stream", "1.4.1"},
		{"es-abstract", "1.13.0"},
		{"es-to-primitive", "1.2.0"},
		{"escape-string-regexp", "1.0.5"},
		{"esprima", "4.0.1"},
		{"execa", "1.0.0"},
		{"find-up", "3.0.0"},
		{"flat", "4.1.0"},
		{"fs.realpath", "1.0.0"},
		{"function-bind", "1.1.1"},
		{"get-caller-file", "1.0.3"},
		{"get-caller-file", "2.0.5"},
		{"get-stream", "4.1.0"},
		{"glob", "7.1.3"},
		{"growl", "1.10.5"},
		{"has", "1.0.3"},
		{"has-flag", "3.0.0"},
		{"has-symbols", "1.0.0"},
		{"he", "1.2.0"},
		{"inflight", "1.0.6"},
		{"inherits", "2.0.3"},
		{"invert-kv", "2.0.0"},
		{"is-buffer", "2.0.3"},
		{"is-callable", "1.1.4"},
		{"is-date-object", "1.0.1"},
		{"is-fullwidth-code-point", "1.0.0"},
		{"is-fullwidth-code-point", "2.0.0"},
		{"is-regex", "1.0.4"},
		{"is-stream", "1.1.0"},
		{"is-symbol", "1.0.2"},
		{"isexe", "2.0.0"},
		{"jquery", "3.4.1"},
		{"js-tokens", "4.0.0"},
		{"js-yaml", "3.13.1"},
		{"lcid", "2.0.0"},
		{"locate-path", "3.0.0"},
		{"lodash", "4.17.11"},
		{"log-symbols", "2.2.0"},
		{"loose-envify", "1.4.0"},
		{"map-age-cleaner", "0.1.3"},
		{"mem", "4.3.0"},
		{"mimic-fn", "2.1.0"},
		{"minimatch", "3.0.4"},
		{"minimist", "0.0.8"},
		{"mkdirp", "0.5.1"},
		{"mocha", "6.1.4"},
		{"ms", "2.1.1"},
		{"nice-try", "1.0.5"},
		{"node-environment-flags", "1.0.5"},
		{"npm-run-path", "2.0.2"},
		{"number-is-nan", "1.0.1"},
		{"object-assign", "4.1.1"},
		{"object-keys", "1.1.1"},
		{"object.assign", "4.1.0"},
		{"object.getownpropertydescriptors", "2.0.3"},
		{"once", "1.4.0"},
		{"os-locale", "3.1.0"},
		{"p-defer", "1.0.0"},
		{"p-finally", "1.0.0"},
		{"p-is-promise", "2.1.0"},
		{"p-limit", "2.2.0"},
		{"p-locate", "3.0.0"},
		{"p-try", "2.2.0"},
		{"path-exists", "3.0.0"},
		{"path-is-absolute", "1.0.1"},
		{"path-key", "2.0.1"},
		{"promise", "8.0.3"},
		{"prop-types", "15.7.2"},
		{"pump", "3.0.0"},
		{"react", "16.8.6"},
		{"react-is", "16.8.6"},
		{"redux", "4.0.1"},
		{"require-directory", "2.1.1"},
		{"require-main-filename", "1.0.1"},
		{"require-main-filename", "2.0.0"},
		{"scheduler", "0.13.6"},
		{"semver", "5.7.0"},
		{"set-blocking", "2.0.0"},
		{"shebang-command", "1.2.0"},
		{"shebang-regex", "1.0.0"},
		{"signal-exit", "3.0.2"},
		{"sprintf-js", "1.0.3"},
		{"string-width", "1.0.2"},
		{"string-width", "2.1.1"},
		{"string-width", "3.1.0"},
		{"strip-ansi", "3.0.1"},
		{"strip-ansi", "4.0.0"},
		{"strip-ansi", "5.2.0"},
		{"strip-eof", "1.0.0"},
		{"strip-json-comments", "2.0.1"},
		{"supports-color", "5.5.0"},
		{"supports-color", "6.0.0"},
		{"symbol-observable", "1.2.0"},
		{"which", "1.3.1"},
		{"which-module", "2.0.0"},
		{"wide-align", "1.1.3"},
		{"wrap-ansi", "2.1.0"},
		{"wrappy", "1.0.2"},
		{"y18n", "4.0.0"},
		{"yargs", "12.0.5"},
		{"yargs", "13.2.2"},
		{"yargs-parser", "11.1.1"},
		{"yargs-parser", "13.0.0"},
		{"yargs-parser", "13.1.0"},
		{"yargs-unparser", "1.5.0"},
	}

	// ... and
	// yarn add lodash request chalk commander express async axios vue
	// yarn list | grep -E -o "\S+@[^\^~]\S+" | awk -F@ 'NR>0 {printf("{\""$1"\", \""$2"\"},\n")}' | sort | uniq
	YarnMany = []types.Library{
		{"accepts", "1.3.7"},
		{"ajv", "6.10.0"},
		{"ansi-colors", "3.2.3"},
		{"ansi-regex", "2.1.1"},
		{"ansi-regex", "3.0.0"},
		{"ansi-regex", "4.1.0"},
		{"ansi-styles", "3.2.1"},
		{"argparse", "1.0.10"},
		{"array-flatten", "1.1.1"},
		{"asap", "2.0.6"},
		{"asn1", "0.2.4"},
		{"assert-plus", "1.0.0"},
		{"async", "2.6.2"},
		{"asynckit", "0.4.0"},
		{"aws-sign2", "0.7.0"},
		{"aws4", "1.8.0"},
		{"axios", "0.18.0"},
		{"balanced-match", "1.0.0"},
		{"bcrypt-pbkdf", "1.0.2"},
		{"body-parser", "1.18.3"},
		{"brace-expansion", "1.1.11"},
		{"browser-stdout", "1.3.1"},
		{"bytes", "3.0.0"},
		{"camelcase", "5.3.1"},
		{"caseless", "0.12.0"},
		{"chalk", "2.4.2"},
		{"cliui", "4.1.0"},
		{"code-point-at", "1.1.0"},
		{"color-convert", "1.9.3"},
		{"color-name", "1.1.3"},
		{"combined-stream", "1.0.8"},
		{"commander", "2.20.0"},
		{"concat-map", "0.0.1"},
		{"content-disposition", "0.5.2"},
		{"content-type", "1.0.4"},
		{"cookie", "0.3.1"},
		{"cookie-signature", "1.0.6"},
		{"core-util-is", "1.0.2"},
		{"cross-spawn", "6.0.5"},
		{"dashdash", "1.14.1"},
		{"debug", "2.6.9"},
		{"debug", "3.2.6"},
		{"decamelize", "1.2.0"},
		{"define-properties", "1.1.3"},
		{"delayed-stream", "1.0.0"},
		{"depd", "1.1.2"},
		{"destroy", "1.0.4"},
		{"diff", "3.5.0"},
		{"ecc-jsbn", "0.1.2"},
		{"ee-first", "1.1.1"},
		{"emoji-regex", "7.0.3"},
		{"encodeurl", "1.0.2"},
		{"end-of-stream", "1.4.1"},
		{"es-abstract", "1.13.0"},
		{"es-to-primitive", "1.2.0"},
		{"escape-html", "1.0.3"},
		{"escape-string-regexp", "1.0.5"},
		{"esprima", "4.0.1"},
		{"etag", "1.8.1"},
		{"execa", "1.0.0"},
		{"express", "4.16.4"},
		{"extend", "3.0.2"},
		{"extsprintf", "1.3.0"},
		{"extsprintf", "1.4.0"},
		{"fast-deep-equal", "2.0.1"},
		{"fast-json-stable-stringify", "2.0.0"},
		{"finalhandler", "1.1.1"},
		{"find-up", "3.0.0"},
		{"flat", "4.1.0"},
		{"follow-redirects", "1.7.0"},
		{"forever-agent", "0.6.1"},
		{"form-data", "2.3.3"},
		{"forwarded", "0.1.2"},
		{"fresh", "0.5.2"},
		{"fs.realpath", "1.0.0"},
		{"function-bind", "1.1.1"},
		{"get-caller-file", "1.0.3"},
		{"get-caller-file", "2.0.5"},
		{"get-stream", "4.1.0"},
		{"getpass", "0.1.7"},
		{"glob", "7.1.3"},
		{"growl", "1.10.5"},
		{"har-schema", "2.0.0"},
		{"har-validator", "5.1.3"},
		{"has", "1.0.3"},
		{"has-flag", "3.0.0"},
		{"has-symbols", "1.0.0"},
		{"he", "1.2.0"},
		{"http-errors", "1.6.3"},
		{"http-signature", "1.2.0"},
		{"iconv-lite", "0.4.23"},
		{"inflight", "1.0.6"},
		{"inherits", "2.0.3"},
		{"invert-kv", "2.0.0"},
		{"ipaddr.js", "1.9.0"},
		{"is-buffer", "1.1.6"},
		{"is-buffer", "2.0.3"},
		{"is-callable", "1.1.4"},
		{"is-date-object", "1.0.1"},
		{"is-fullwidth-code-point", "1.0.0"},
		{"is-fullwidth-code-point", "2.0.0"},
		{"is-regex", "1.0.4"},
		{"is-stream", "1.1.0"},
		{"is-symbol", "1.0.2"},
		{"is-typedarray", "1.0.0"},
		{"isexe", "2.0.0"},
		{"isstream", "0.1.2"},
		{"jquery", "3.4.1"},
		{"js-tokens", "4.0.0"},
		{"js-yaml", "3.13.1"},
		{"jsbn", "0.1.1"},
		{"json-schema", "0.2.3"},
		{"json-schema-traverse", "0.4.1"},
		{"json-stringify-safe", "5.0.1"},
		{"jsprim", "1.4.1"},
		{"lcid", "2.0.0"},
		{"locate-path", "3.0.0"},
		{"lodash", "4.17.11"},
		{"log-symbols", "2.2.0"},
		{"loose-envify", "1.4.0"},
		{"map-age-cleaner", "0.1.3"},
		{"media-typer", "0.3.0"},
		{"mem", "4.3.0"},
		{"merge-descriptors", "1.0.1"},
		{"methods", "1.1.2"},
		{"mime", "1.4.1"},
		{"mime-db", "1.40.0"},
		{"mime-types", "2.1.24"},
		{"mimic-fn", "2.1.0"},
		{"minimatch", "3.0.4"},
		{"minimist", "0.0.8"},
		{"mkdirp", "0.5.1"},
		{"mocha", "6.1.4"},
		{"ms", "2.0.0"},
		{"ms", "2.1.1"},
		{"negotiator", "0.6.2"},
		{"nice-try", "1.0.5"},
		{"node-environment-flags", "1.0.5"},
		{"npm-run-path", "2.0.2"},
		{"number-is-nan", "1.0.1"},
		{"oauth-sign", "0.9.0"},
		{"object-assign", "4.1.1"},
		{"object-keys", "1.1.1"},
		{"object.assign", "4.1.0"},
		{"object.getownpropertydescriptors", "2.0.3"},
		{"on-finished", "2.3.0"},
		{"once", "1.4.0"},
		{"os-locale", "3.1.0"},
		{"p-defer", "1.0.0"},
		{"p-finally", "1.0.0"},
		{"p-is-promise", "2.1.0"},
		{"p-limit", "2.2.0"},
		{"p-locate", "3.0.0"},
		{"p-try", "2.2.0"},
		{"parseurl", "1.3.3"},
		{"path-exists", "3.0.0"},
		{"path-is-absolute", "1.0.1"},
		{"path-key", "2.0.1"},
		{"path-to-regexp", "0.1.7"},
		{"performance-now", "2.1.0"},
		{"promise", "8.0.3"},
		{"prop-types", "15.7.2"},
		{"proxy-addr", "2.0.5"},
		{"psl", "1.1.31"},
		{"pump", "3.0.0"},
		{"punycode", "1.4.1"},
		{"punycode", "2.1.1"},
		{"qs", "6.5.2"},
		{"range-parser", "1.2.1"},
		{"raw-body", "2.3.3"},
		{"react", "16.8.6"},
		{"react-is", "16.8.6"},
		{"redux", "4.0.1"},
		{"request", "2.88.0"},
		{"require-directory", "2.1.1"},
		{"require-main-filename", "1.0.1"},
		{"require-main-filename", "2.0.0"},
		{"safe-buffer", "5.1.2"},
		{"safer-buffer", "2.1.2"},
		{"scheduler", "0.13.6"},
		{"semver", "5.7.0"},
		{"send", "0.16.2"},
		{"serve-static", "1.13.2"},
		{"set-blocking", "2.0.0"},
		{"setprototypeof", "1.1.0"},
		{"shebang-command", "1.2.0"},
		{"shebang-regex", "1.0.0"},
		{"signal-exit", "3.0.2"},
		{"sprintf-js", "1.0.3"},
		{"sshpk", "1.16.1"},
		{"statuses", "1.4.0"},
		{"statuses", "1.5.0"},
		{"string-width", "1.0.2"},
		{"string-width", "2.1.1"},
		{"string-width", "3.1.0"},
		{"strip-ansi", "3.0.1"},
		{"strip-ansi", "4.0.0"},
		{"strip-ansi", "5.2.0"},
		{"strip-eof", "1.0.0"},
		{"strip-json-comments", "2.0.1"},
		{"supports-color", "5.5.0"},
		{"supports-color", "6.0.0"},
		{"symbol-observable", "1.2.0"},
		{"tough-cookie", "2.4.3"},
		{"tunnel-agent", "0.6.0"},
		{"tweetnacl", "0.14.5"},
		{"type-is", "1.6.18"},
		{"unpipe", "1.0.0"},
		{"uri-js", "4.2.2"},
		{"utils-merge", "1.0.1"},
		{"uuid", "3.3.2"},
		{"vary", "1.1.2"},
		{"verror", "1.10.0"},
		{"vue", "2.6.10"},
		{"which", "1.3.1"},
		{"which-module", "2.0.0"},
		{"wide-align", "1.1.3"},
		{"wrap-ansi", "2.1.0"},
		{"wrappy", "1.0.2"},
		{"y18n", "4.0.0"},
		{"yargs", "12.0.5"},
		{"yargs", "13.2.2"},
		{"yargs-parser", "11.1.1"},
		{"yargs-parser", "13.0.0"},
		{"yargs-parser", "13.1.0"},
		{"yargs-unparser", "1.5.0"},
	}

	// yarn list | grep -E -o "\S+@[^\^~]\S+" | awk -F@ 'NR>0 {printf("{\""$1"\", \""$2"\"},\n")}'
	// yarn list | grep -E -o "@.+@[^\^~]\S+" | awk -F@ 'NR>0 {printf("{\"@"$2"\", \""$3"\"},\n")}' | sort | uniq
	YarnRealWorld = []types.Library{
		{"@babel/code-frame", "7.0.0"},
		{"@babel/code-frame", "7.0.0-beta.44"},
		{"@babel/core", "7.1.0"},
		{"@babel/core", "7.4.4"},
		{"@babel/generator", "7.0.0-beta.44"},
		{"@babel/generator", "7.4.4"},
		{"@babel/helper-annotate-as-pure", "7.0.0"},
		{"@babel/helper-builder-binary-assignment-operator-visitor", "7.1.0"},
		{"@babel/helper-builder-react-jsx", "7.3.0"},
		{"@babel/helper-call-delegate", "7.4.4"},
		{"@babel/helper-create-class-features-plugin", "7.4.4"},
		{"@babel/helper-define-map", "7.4.4"},
		{"@babel/helper-explode-assignable-expression", "7.1.0"},
		{"@babel/helper-function-name", "7.0.0-beta.44"},
		{"@babel/helper-function-name", "7.1.0"},
		{"@babel/helper-get-function-arity", "7.0.0"},
		{"@babel/helper-get-function-arity", "7.0.0-beta.44"},
		{"@babel/helper-hoist-variables", "7.4.4"},
		{"@babel/helper-member-expression-to-functions", "7.0.0"},
		{"@babel/helper-module-imports", "7.0.0"},
		{"@babel/helper-module-transforms", "7.4.4"},
		{"@babel/helper-optimise-call-expression", "7.0.0"},
		{"@babel/helper-plugin-utils", "7.0.0"},
		{"@babel/helper-regex", "7.4.4"},
		{"@babel/helper-remap-async-to-generator", "7.1.0"},
		{"@babel/helper-replace-supers", "7.4.4"},
		{"@babel/helper-simple-access", "7.1.0"},
		{"@babel/helper-split-export-declaration", "7.0.0-beta.44"},
		{"@babel/helper-split-export-declaration", "7.4.4"},
		{"@babel/helper-wrap-function", "7.2.0"},
		{"@babel/helpers", "7.4.4"},
		{"@babel/highlight", "7.0.0"},
		{"@babel/highlight", "7.0.0-beta.44"},
		{"@babel/parser", "7.4.4"},
		{"@babel/plugin-proposal-async-generator-functions", "7.2.0"},
		{"@babel/plugin-proposal-class-properties", "7.1.0"},
		{"@babel/plugin-proposal-class-properties", "7.4.4"},
		{"@babel/plugin-proposal-decorators", "7.1.2"},
		{"@babel/plugin-proposal-json-strings", "7.2.0"},
		{"@babel/plugin-proposal-object-rest-spread", "7.0.0"},
		{"@babel/plugin-proposal-object-rest-spread", "7.4.4"},
		{"@babel/plugin-proposal-optional-catch-binding", "7.2.0"},
		{"@babel/plugin-proposal-unicode-property-regex", "7.4.4"},
		{"@babel/plugin-syntax-async-generators", "7.2.0"},
		{"@babel/plugin-syntax-class-properties", "7.2.0"},
		{"@babel/plugin-syntax-decorators", "7.2.0"},
		{"@babel/plugin-syntax-dynamic-import", "7.0.0"},
		{"@babel/plugin-syntax-dynamic-import", "7.2.0"},
		{"@babel/plugin-syntax-flow", "7.2.0"},
		{"@babel/plugin-syntax-json-strings", "7.2.0"},
		{"@babel/plugin-syntax-jsx", "7.2.0"},
		{"@babel/plugin-syntax-object-rest-spread", "7.2.0"},
		{"@babel/plugin-syntax-optional-catch-binding", "7.2.0"},
		{"@babel/plugin-syntax-typescript", "7.3.3"},
		{"@babel/plugin-transform-arrow-functions", "7.2.0"},
		{"@babel/plugin-transform-async-to-generator", "7.4.4"},
		{"@babel/plugin-transform-block-scoped-functions", "7.2.0"},
		{"@babel/plugin-transform-block-scoping", "7.4.4"},
		{"@babel/plugin-transform-classes", "7.1.0"},
		{"@babel/plugin-transform-classes", "7.4.4"},
		{"@babel/plugin-transform-computed-properties", "7.2.0"},
		{"@babel/plugin-transform-destructuring", "7.0.0"},
		{"@babel/plugin-transform-destructuring", "7.4.4"},
		{"@babel/plugin-transform-dotall-regex", "7.4.4"},
		{"@babel/plugin-transform-duplicate-keys", "7.2.0"},
		{"@babel/plugin-transform-exponentiation-operator", "7.2.0"},
		{"@babel/plugin-transform-flow-strip-types", "7.0.0"},
		{"@babel/plugin-transform-flow-strip-types", "7.4.4"},
		{"@babel/plugin-transform-for-of", "7.4.4"},
		{"@babel/plugin-transform-function-name", "7.4.4"},
		{"@babel/plugin-transform-literals", "7.2.0"},
		{"@babel/plugin-transform-member-expression-literals", "7.2.0"},
		{"@babel/plugin-transform-modules-amd", "7.2.0"},
		{"@babel/plugin-transform-modules-commonjs", "7.4.4"},
		{"@babel/plugin-transform-modules-systemjs", "7.4.4"},
		{"@babel/plugin-transform-modules-umd", "7.2.0"},
		{"@babel/plugin-transform-named-capturing-groups-regex", "7.4.4"},
		{"@babel/plugin-transform-new-target", "7.4.4"},
		{"@babel/plugin-transform-object-super", "7.2.0"},
		{"@babel/plugin-transform-parameters", "7.4.4"},
		{"@babel/plugin-transform-property-literals", "7.2.0"},
		{"@babel/plugin-transform-react-constant-elements", "7.0.0"},
		{"@babel/plugin-transform-react-constant-elements", "7.2.0"},
		{"@babel/plugin-transform-react-display-name", "7.0.0"},
		{"@babel/plugin-transform-react-display-name", "7.2.0"},
		{"@babel/plugin-transform-react-jsx", "7.3.0"},
		{"@babel/plugin-transform-react-jsx-self", "7.2.0"},
		{"@babel/plugin-transform-react-jsx-source", "7.2.0"},
		{"@babel/plugin-transform-regenerator", "7.4.4"},
		{"@babel/plugin-transform-reserved-words", "7.2.0"},
		{"@babel/plugin-transform-runtime", "7.1.0"},
		{"@babel/plugin-transform-shorthand-properties", "7.2.0"},
		{"@babel/plugin-transform-spread", "7.2.2"},
		{"@babel/plugin-transform-sticky-regex", "7.2.0"},
		{"@babel/plugin-transform-template-literals", "7.4.4"},
		{"@babel/plugin-transform-typeof-symbol", "7.2.0"},
		{"@babel/plugin-transform-typescript", "7.4.4"},
		{"@babel/plugin-transform-unicode-regex", "7.4.4"},
		{"@babel/preset-env", "7.1.0"},
		{"@babel/preset-env", "7.4.4"},
		{"@babel/preset-flow", "7.0.0"},
		{"@babel/preset-react", "7.0.0"},
		{"@babel/preset-typescript", "7.1.0"},
		{"@babel/register", "7.4.4"},
		{"@babel/runtime", "7.0.0"},
		{"@babel/runtime", "7.4.4"},
		{"@babel/template", "7.0.0-beta.44"},
		{"@babel/template", "7.4.4"},
		{"@babel/traverse", "7.0.0-beta.44"},
		{"@babel/traverse", "7.4.4"},
		{"@babel/types", "7.0.0-beta.44"},
		{"@babel/types", "7.4.4"},
		{"@emotion/cache", "0.8.8"},
		{"@emotion/core", "0.13.1"},
		{"@emotion/css", "0.9.8"},
		{"@emotion/hash", "0.6.6"},
		{"@emotion/is-prop-valid", "0.6.8"},
		{"@emotion/is-prop-valid", "0.7.3"},
		{"@emotion/memoize", "0.6.6"},
		{"@emotion/memoize", "0.7.1"},
		{"@emotion/provider", "0.11.2"},
		{"@emotion/serialize", "0.9.1"},
		{"@emotion/sheet", "0.8.1"},
		{"@emotion/styled", "0.10.6"},
		{"@emotion/styled-base", "0.10.6"},
		{"@emotion/stylis", "0.7.1"},
		{"@emotion/unitless", "0.6.7"},
		{"@emotion/unitless", "0.7.3"},
		{"@emotion/utils", "0.8.2"},
		{"@emotion/weak-memoize", "0.1.3"},
		{"@icons/material", "0.2.4"},
		{"@loadable/component", "5.10.1"},
		{"@material-ui/core", "3.9.3"},
		{"@material-ui/icons", "3.0.2"},
		{"@material-ui/system", "3.0.0-alpha.2"},
		{"@material-ui/utils", "3.0.0-alpha.3"},
		{"@mrmlnc/readdir-enhanced", "2.2.1"},
		{"@nodelib/fs.stat", "1.1.3"},
		{"@octokit/rest", "15.18.1"},
		{"@samverschueren/stream-to-observable", "0.3.0"},
		{"@storybook/addon-actions", "4.1.18"},
		{"@storybook/addon-info", "4.1.18"},
		{"@storybook/addon-knobs", "4.1.18"},
		{"@storybook/addons", "4.1.18"},
		{"@storybook/channel-postmessage", "4.1.18"},
		{"@storybook/channels", "4.1.18"},
		{"@storybook/cli", "4.1.18"},
		{"@storybook/client-logger", "4.1.18"},
		{"@storybook/codemod", "4.1.18"},
		{"@storybook/components", "4.1.18"},
		{"@storybook/core", "4.1.18"},
		{"@storybook/core-events", "4.1.18"},
		{"@storybook/mantra-core", "1.7.2"},
		{"@storybook/node-logger", "4.1.18"},
		{"@storybook/podda", "1.2.3"},
		{"@storybook/react", "4.1.18"},
		{"@storybook/react-komposer", "2.0.5"},
		{"@storybook/react-simple-di", "1.3.0"},
		{"@storybook/react-stubber", "1.0.1"},
		{"@storybook/ui", "4.1.18"},
		{"@svgr/babel-plugin-add-jsx-attribute", "4.2.0"},
		{"@svgr/babel-plugin-remove-jsx-attribute", "4.2.0"},
		{"@svgr/babel-plugin-remove-jsx-empty-expression", "4.2.0"},
		{"@svgr/babel-plugin-replace-jsx-attribute-value", "4.2.0"},
		{"@svgr/babel-plugin-svg-dynamic-title", "4.2.0"},
		{"@svgr/babel-plugin-svg-em-dimensions", "4.2.0"},
		{"@svgr/babel-plugin-transform-react-native-svg", "4.2.0"},
		{"@svgr/babel-plugin-transform-svg-component", "4.2.0"},
		{"@svgr/babel-preset", "4.2.0"},
		{"@svgr/core", "4.2.0"},
		{"@svgr/hast-util-to-babel-ast", "4.2.0"},
		{"@svgr/plugin-jsx", "4.2.0"},
		{"@svgr/plugin-svgo", "4.2.0"},
		{"@svgr/webpack", "4.2.0"},
		{"@types/events", "3.0.0"},
		{"@types/glob", "7.1.1"},
		{"@types/jss", "9.5.8"},
		{"@types/minimatch", "3.0.3"},
		{"@types/node", "12.0.2"},
		{"@types/prop-types", "15.7.1"},
		{"@types/q", "1.5.2"},
		{"@types/react", "16.8.17"},
		{"@types/react-transition-group", "2.9.1"},
		{"@types/unist", "2.0.3"},
		{"@types/vfile", "3.0.2"},
		{"@types/vfile-message", "1.0.1"},
		{"@webassemblyjs/ast", "1.8.5"},
		{"@webassemblyjs/floating-point-hex-parser", "1.8.5"},
		{"@webassemblyjs/helper-api-error", "1.8.5"},
		{"@webassemblyjs/helper-buffer", "1.8.5"},
		{"@webassemblyjs/helper-code-frame", "1.8.5"},
		{"@webassemblyjs/helper-fsm", "1.8.5"},
		{"@webassemblyjs/helper-module-context", "1.8.5"},
		{"@webassemblyjs/helper-wasm-bytecode", "1.8.5"},
		{"@webassemblyjs/helper-wasm-section", "1.8.5"},
		{"@webassemblyjs/ieee754", "1.8.5"},
		{"@webassemblyjs/leb128", "1.8.5"},
		{"@webassemblyjs/utf8", "1.8.5"},
		{"@webassemblyjs/wasm-edit", "1.8.5"},
		{"@webassemblyjs/wasm-gen", "1.8.5"},
		{"@webassemblyjs/wasm-opt", "1.8.5"},
		{"@webassemblyjs/wasm-parser", "1.8.5"},
		{"@webassemblyjs/wast-parser", "1.8.5"},
		{"@webassemblyjs/wast-printer", "1.8.5"},
		{"@xtuc/ieee754", "1.2.0"},
		{"@xtuc/long", "4.2.2"},

		{"JSONStream", "1.3.5"},
		{"abab", "2.0.0"},
		{"abbrev", "1.1.1"},
		{"accepts", "1.3.7"},
		{"acorn", "5.7.3"},
		{"acorn", "6.1.1"},
		{"acorn-dynamic-import", "4.0.0"},
		{"acorn-globals", "4.3.2"},
		{"acorn-jsx", "5.0.1"},
		{"acorn-walk", "6.1.1"},
		{"address", "1.0.3"},
		{"address", "1.1.0"},
		{"after", "0.8.2"},
		{"agent-base", "4.2.1"},
		{"agentkeepalive", "3.5.2"},
		{"airbnb-js-shims", "2.2.0"},
		{"airbnb-prop-types", "2.13.2"},
		{"ajv", "6.10.0"},
		{"ajv-errors", "1.0.1"},
		{"ajv-keywords", "3.4.0"},
		{"ansi-align", "2.0.0"},
		{"ansi-align", "3.0.0"},
		{"ansi-colors", "3.2.4"},
		{"ansi-escapes", "1.4.0"},
		{"ansi-escapes", "3.2.0"},
		{"ansi-html", "0.0.7"},
		{"ansi-regex", "2.1.1"},
		{"ansi-regex", "3.0.0"},
		{"ansi-regex", "4.1.0"},
		{"ansi-styles", "1.0.0"},
		{"ansi-styles", "2.2.1"},
		{"ansi-styles", "3.2.1"},
		{"ansicolors", "0.3.2"},
		{"ansistyles", "0.1.3"},
		{"any-observable", "0.3.0"},
		{"anymatch", "1.3.2"},
		{"anymatch", "2.0.0"},
		{"app-root-dir", "1.0.2"},
		{"append-transform", "0.4.0"},
		{"aproba", "1.2.0"},
		{"aproba", "2.0.0"},
		{"archy", "1.0.0"},
		{"are-we-there-yet", "1.1.5"},
		{"argparse", "1.0.10"},
		{"aria-query", "3.0.0"},
		{"arr-diff", "2.0.0"},
		{"arr-diff", "4.0.0"},
		{"arr-flatten", "1.1.0"},
		{"arr-union", "3.1.0"},
		{"array-equal", "1.0.0"},
		{"array-filter", "0.0.1"},
		{"array-filter", "1.0.0"},
		{"array-flatten", "1.1.1"},
		{"array-flatten", "2.1.2"},
		{"array-includes", "3.0.3"},
		{"array-map", "0.0.0"},
		{"array-reduce", "0.0.0"},
		{"array-union", "1.0.2"},
		{"array-uniq", "1.0.3"},
		{"array-unique", "0.2.1"},
		{"array-unique", "0.3.2"},
		{"array.prototype.find", "2.0.4"},
		{"array.prototype.flat", "1.2.1"},
		{"array.prototype.flatmap", "1.2.1"},
		{"arraybuffer.slice", "0.0.7"},
		{"arrify", "1.0.1"},
		{"asap", "2.0.6"},
		{"asn1", "0.2.4"},
		{"asn1.js", "4.10.1"},
		{"assert", "1.5.0"},
		{"assert-plus", "1.0.0"},
		{"assign-symbols", "1.0.0"},
		{"ast-types", "0.11.3"},
		{"ast-types", "0.11.5"},
		{"ast-types", "0.11.7"},
		{"ast-types-flow", "0.0.7"},
		{"astral-regex", "1.0.0"},
		{"async", "1.5.2"},
		{"async", "2.6.2"},
		{"async-each", "1.0.3"},
		{"async-limiter", "1.0.0"},
		{"asynckit", "0.4.0"},
		{"atob", "2.1.2"},
		{"attr-accept", "1.1.3"},
		{"autodll-webpack-plugin", "0.4.2"},
		{"autoprefixer", "8.6.5"},
		{"autoprefixer", "9.5.1"},
		{"aws-sign2", "0.7.0"},
		{"aws4", "1.8.0"},
		{"axios", "0.18.0"},
		{"axobject-query", "2.0.2"},
		{"babel-cli", "6.26.0"},
		{"babel-code-frame", "6.26.0"},
		{"babel-core", "6.26.3"},
		{"babel-eslint", "8.2.6"},
		{"babel-generator", "6.26.1"},
		{"babel-helper-bindify-decorators", "6.24.1"},
		{"babel-helper-builder-binary-assignment-operator-visitor", "6.24.1"},
		{"babel-helper-builder-react-jsx", "6.26.0"},
		{"babel-helper-call-delegate", "6.24.1"},
		{"babel-helper-define-map", "6.26.0"},
		{"babel-helper-evaluate-path", "0.5.0"},
		{"babel-helper-explode-assignable-expression", "6.24.1"},
		{"babel-helper-explode-class", "6.24.1"},
		{"babel-helper-flip-expressions", "0.4.3"},
		{"babel-helper-function-name", "6.24.1"},
		{"babel-helper-get-function-arity", "6.24.1"},
		{"babel-helper-hoist-variables", "6.24.1"},
		{"babel-helper-is-nodes-equiv", "0.0.1"},
		{"babel-helper-is-void-0", "0.4.3"},
		{"babel-helper-mark-eval-scopes", "0.4.3"},
		{"babel-helper-optimise-call-expression", "6.24.1"},
		{"babel-helper-regex", "6.26.0"},
		{"babel-helper-remap-async-to-generator", "6.24.1"},
		{"babel-helper-remove-or-void", "0.4.3"},
		{"babel-helper-replace-supers", "6.24.1"},
		{"babel-helper-to-multiple-sequence-expressions", "0.5.0"},
		{"babel-helpers", "6.24.1"},
		{"babel-jest", "23.6.0"},
		{"babel-loader", "7.1.5"},
		{"babel-loader", "8.0.4"},
		{"babel-messages", "6.23.0"},
		{"babel-plugin-check-es2015-constants", "6.22.0"},
		{"babel-plugin-dynamic-import-node", "2.2.0"},
		{"babel-plugin-istanbul", "4.1.6"},
		{"babel-plugin-jest-hoist", "23.2.0"},
		{"babel-plugin-macros", "2.4.2"},
		{"babel-plugin-macros", "2.5.1"},
		{"babel-plugin-minify-builtins", "0.5.0"},
		{"babel-plugin-minify-constant-folding", "0.5.0"},
		{"babel-plugin-minify-dead-code-elimination", "0.5.0"},
		{"babel-plugin-minify-flip-comparisons", "0.4.3"},
		{"babel-plugin-minify-guarded-expressions", "0.4.3"},
		{"babel-plugin-minify-infinity", "0.4.3"},
		{"babel-plugin-minify-mangle-names", "0.5.0"},
		{"babel-plugin-minify-numeric-literals", "0.4.3"},
		{"babel-plugin-minify-replace", "0.5.0"},
		{"babel-plugin-minify-simplify", "0.5.0"},
		{"babel-plugin-minify-type-constructors", "0.4.3"},
		{"babel-plugin-named-asset-import", "0.2.3"},
		{"babel-plugin-react-docgen", "2.0.2"},
		{"babel-plugin-react-html-attrs", "2.1.0"},
		{"babel-plugin-styled-components", "1.10.0"},
		{"babel-plugin-syntax-async-functions", "6.13.0"},
		{"babel-plugin-syntax-async-generators", "6.13.0"},
		{"babel-plugin-syntax-class-constructor-call", "6.18.0"},
		{"babel-plugin-syntax-class-properties", "6.13.0"},
		{"babel-plugin-syntax-decorators", "6.13.0"},
		{"babel-plugin-syntax-dynamic-import", "6.18.0"},
		{"babel-plugin-syntax-exponentiation-operator", "6.13.0"},
		{"babel-plugin-syntax-export-extensions", "6.13.0"},
		{"babel-plugin-syntax-flow", "6.18.0"},
		{"babel-plugin-syntax-jsx", "6.18.0"},
		{"babel-plugin-syntax-object-rest-spread", "6.13.0"},
		{"babel-plugin-syntax-trailing-function-commas", "6.22.0"},
		{"babel-plugin-transform-async-generator-functions", "6.24.1"},
		{"babel-plugin-transform-async-to-generator", "6.24.1"},
		{"babel-plugin-transform-class-constructor-call", "6.24.1"},
		{"babel-plugin-transform-class-properties", "6.24.1"},
		{"babel-plugin-transform-decorators", "6.24.1"},
		{"babel-plugin-transform-es2015-arrow-functions", "6.22.0"},
		{"babel-plugin-transform-es2015-block-scoped-functions", "6.22.0"},
		{"babel-plugin-transform-es2015-block-scoping", "6.26.0"},
		{"babel-plugin-transform-es2015-classes", "6.24.1"},
		{"babel-plugin-transform-es2015-computed-properties", "6.24.1"},
		{"babel-plugin-transform-es2015-destructuring", "6.23.0"},
		{"babel-plugin-transform-es2015-duplicate-keys", "6.24.1"},
		{"babel-plugin-transform-es2015-for-of", "6.23.0"},
		{"babel-plugin-transform-es2015-function-name", "6.24.1"},
		{"babel-plugin-transform-es2015-literals", "6.22.0"},
		{"babel-plugin-transform-es2015-modules-amd", "6.24.1"},
		{"babel-plugin-transform-es2015-modules-commonjs", "6.26.2"},
		{"babel-plugin-transform-es2015-modules-systemjs", "6.24.1"},
		{"babel-plugin-transform-es2015-modules-umd", "6.24.1"},
		{"babel-plugin-transform-es2015-object-super", "6.24.1"},
		{"babel-plugin-transform-es2015-parameters", "6.24.1"},
		{"babel-plugin-transform-es2015-shorthand-properties", "6.24.1"},
		{"babel-plugin-transform-es2015-spread", "6.22.0"},
		{"babel-plugin-transform-es2015-sticky-regex", "6.24.1"},
		{"babel-plugin-transform-es2015-template-literals", "6.22.0"},
		{"babel-plugin-transform-es2015-typeof-symbol", "6.23.0"},
		{"babel-plugin-transform-es2015-unicode-regex", "6.24.1"},
		{"babel-plugin-transform-exponentiation-operator", "6.24.1"},
		{"babel-plugin-transform-export-extensions", "6.22.0"},
		{"babel-plugin-transform-flow-strip-types", "6.22.0"},
		{"babel-plugin-transform-inline-consecutive-adds", "0.4.3"},
		{"babel-plugin-transform-member-expression-literals", "6.9.4"},
		{"babel-plugin-transform-merge-sibling-variables", "6.9.4"},
		{"babel-plugin-transform-minify-booleans", "6.9.4"},
		{"babel-plugin-transform-object-rest-spread", "6.26.0"},
		{"babel-plugin-transform-property-literals", "6.9.4"},
		{"babel-plugin-transform-react-display-name", "6.25.0"},
		{"babel-plugin-transform-react-jsx", "6.24.1"},
		{"babel-plugin-transform-react-jsx-self", "6.22.0"},
		{"babel-plugin-transform-react-jsx-source", "6.22.0"},
		{"babel-plugin-transform-react-remove-prop-types", "0.4.18"},
		{"babel-plugin-transform-regenerator", "6.26.0"},
		{"babel-plugin-transform-regexp-constructors", "0.4.3"},
		{"babel-plugin-transform-remove-console", "6.9.4"},
		{"babel-plugin-transform-remove-debugger", "6.9.4"},
		{"babel-plugin-transform-remove-undefined", "0.5.0"},
		{"babel-plugin-transform-runtime", "6.23.0"},
		{"babel-plugin-transform-simplify-comparison-operators", "6.9.4"},
		{"babel-plugin-transform-strict-mode", "6.24.1"},
		{"babel-plugin-transform-undefined-to-void", "6.9.4"},
		{"babel-polyfill", "6.26.0"},
		{"babel-preset-env", "1.7.0"},
		{"babel-preset-es2015", "6.24.1"},
		{"babel-preset-flow", "6.23.0"},
		{"babel-preset-jest", "23.2.0"},
		{"babel-preset-minify", "0.5.0"},
		{"babel-preset-react", "6.24.1"},
		{"babel-preset-react-app", "6.1.0"},
		{"babel-preset-stage-1", "6.24.1"},
		{"babel-preset-stage-2", "6.24.1"},
		{"babel-preset-stage-3", "6.24.1"},
		{"babel-register", "6.26.0"},
		{"babel-runtime", "6.26.0"},
		{"babel-standalone", "6.26.0"},
		{"babel-template", "6.26.0"},
		{"babel-traverse", "6.26.0"},
		{"babel-types", "6.26.0"},
		{"babylon", "6.18.0"},
		{"babylon", "7.0.0-beta.44"},
		{"babylon", "7.0.0-beta.47"},
		{"backo2", "1.0.2"},
		{"bail", "1.0.4"},
		{"balanced-match", "1.0.0"},
		{"base", "0.11.2"},
		{"base64-arraybuffer", "0.1.5"},
		{"base64-js", "1.3.0"},
		{"base64id", "1.0.0"},
		{"batch", "0.6.1"},
		{"bcrypt-pbkdf", "1.0.2"},
		{"before-after-hook", "1.4.0"},
		{"better-assert", "1.0.2"},
		{"bfj", "6.1.1"},
		{"big-integer", "1.6.43"},
		{"big.js", "3.2.0"},
		{"big.js", "5.2.2"},
		{"bin-links", "1.1.2"},
		{"binary", "0.3.0"},
		{"binary-extensions", "1.13.1"},
		{"blob", "0.0.5"},
		{"block-stream", "0.0.9"},
		{"bluebird", "3.4.7"},
		{"bluebird", "3.5.4"},
		{"bn.js", "4.11.8"},
		{"body-parser", "1.18.3"},
		{"bonjour", "3.5.0"},
		{"boolbase", "1.0.0"},
		{"boxen", "1.3.0"},
		{"boxen", "2.1.0"},
		{"brace-expansion", "1.1.11"},
		{"braces", "1.8.5"},
		{"braces", "2.3.2"},
		{"brcast", "3.0.1"},
		{"brorand", "1.1.0"},
		{"browser-process-hrtime", "0.1.3"},
		{"browser-resolve", "1.11.3"},
		{"browserify-aes", "1.2.0"},
		{"browserify-cipher", "1.0.1"},
		{"browserify-des", "1.0.2"},
		{"browserify-rsa", "4.0.1"},
		{"browserify-sign", "4.0.4"},
		{"browserify-zlib", "0.2.0"},
		{"browserslist", "3.2.8"},
		{"browserslist", "4.1.1"},
		{"browserslist", "4.6.0"},
		{"bser", "2.0.0"},
		{"btoa-lite", "1.0.0"},
		{"buffer", "4.9.1"},
		{"buffer-from", "1.1.1"},
		{"buffer-indexof", "1.1.1"},
		{"buffer-indexof-polyfill", "1.0.1"},
		{"buffer-shims", "1.0.0"},
		{"buffer-xor", "1.0.3"},
		{"buffers", "0.1.1"},
		{"builtin-status-codes", "3.0.0"},
		{"builtins", "1.0.3"},
		{"byline", "5.0.0"},
		{"byte-size", "5.0.1"},
		{"bytes", "3.0.0"},
		{"cacache", "10.0.4"},
		{"cacache", "11.3.2"},
		{"cache-base", "1.0.1"},
		{"cache-loader", "1.2.5"},
		{"call-limit", "1.1.0"},
		{"call-me-maybe", "1.0.1"},
		{"caller-callsite", "2.0.0"},
		{"caller-path", "2.0.0"},
		{"callsite", "1.0.0"},
		{"callsites", "2.0.0"},
		{"callsites", "3.1.0"},
		{"camel-case", "3.0.0"},
		{"camelcase", "3.0.0"},
		{"camelcase", "4.1.0"},
		{"camelcase", "5.3.1"},
		{"camelize", "1.0.0"},
		{"caniuse-lite", "1.0.30000967"},
		{"capture-exit", "1.2.0"},
		{"capture-stack-trace", "1.0.1"},
		{"case-sensitive-paths-webpack-plugin", "2.2.0"},
		{"caseless", "0.12.0"},
		{"ccount", "1.0.4"},
		{"chainsaw", "0.1.0"},
		{"chalk", "0.4.0"},
		{"chalk", "1.1.3"},
		{"chalk", "2.4.1"},
		{"chalk", "2.4.2"},
		{"change-emitter", "0.1.6"},
		{"chardet", "0.7.0"},
		{"charenc", "0.0.2"},
		{"check-types", "7.4.0"},
		{"cheerio", "1.0.0-rc.3"},
		{"child-process-promise", "2.2.1"},
		{"chokidar", "1.7.0"},
		{"chokidar", "2.1.5"},
		{"chownr", "1.1.1"},
		{"chrome-trace-event", "1.0.0"},
		{"ci-info", "1.6.0"},
		{"ci-info", "2.0.0"},
		{"cidr-regex", "2.0.10"},
		{"cipher-base", "1.0.4"},
		{"class-utils", "0.3.6"},
		{"classnames", "2.2.6"},
		{"clean-css", "4.2.1"},
		{"clean-webpack-plugin", "0.1.19"},
		{"cli-boxes", "1.0.0"},
		{"cli-columns", "3.1.2"},
		{"cli-cursor", "1.0.2"},
		{"cli-cursor", "2.1.0"},
		{"cli-table3", "0.5.1"},
		{"cli-truncate", "0.2.1"},
		{"cli-width", "1.1.1"},
		{"cli-width", "2.2.0"},
		{"cliui", "3.2.0"},
		{"cliui", "4.1.0"},
		{"clone", "1.0.4"},
		{"clone-deep", "0.2.4"},
		{"clsx", "1.0.4"},
		{"cmd-shim", "2.0.2"},
		{"co", "4.6.0"},
		{"coa", "2.0.2"},
		{"code-point-at", "1.1.0"},
		{"collection-visit", "1.0.0"},
		{"color-convert", "1.9.3"},
		{"color-name", "1.1.3"},
		{"colors", "1.3.3"},
		{"columnify", "1.5.4"},
		{"combined-stream", "1.0.8"},
		{"comma-separated-tokens", "1.0.7"},
		{"commander", "2.17.1"},
		{"commander", "2.19.0"},
		{"commander", "2.20.0"},
		{"common-tags", "1.8.0"},
		{"commondir", "1.0.1"},
		{"component-bind", "1.0.0"},
		{"component-emitter", "1.2.1"},
		{"component-emitter", "1.3.0"},
		{"component-inherit", "0.0.3"},
		{"compressible", "2.0.17"},
		{"compression", "1.7.4"},
		{"concat-map", "0.0.1"},
		{"concat-stream", "1.6.2"},
		{"config-chain", "1.1.12"},
		{"configstore", "3.1.2"},
		{"connect-history-api-fallback", "1.6.0"},
		{"console-browserify", "1.1.0"},
		{"console-control-strings", "1.1.0"},
		{"console-polyfill", "0.3.0"},
		{"constants-browserify", "1.0.0"},
		{"contains-path", "0.1.0"},
		{"content-disposition", "0.5.2"},
		{"content-type", "1.0.4"},
		{"convert-source-map", "1.6.0"},
		{"cookie", "0.3.1"},
		{"cookie-signature", "1.0.6"},
		{"copy-concurrently", "1.0.5"},
		{"copy-descriptor", "0.1.1"},
		{"copy-to-clipboard", "3.2.0"},
		{"copy-webpack-plugin", "4.6.0"},
		{"core-js", "1.2.7"},
		{"core-js", "2.6.5"},
		{"core-js", "3.0.1"},
		{"core-js-compat", "3.0.1"},
		{"core-js-pure", "3.0.1"},
		{"core-util-is", "1.0.2"},
		{"cosmiconfig", "4.0.0"},
		{"cosmiconfig", "5.2.1"},
		{"create-ecdh", "4.0.3"},
		{"create-error-class", "3.0.2"},
		{"create-hash", "1.2.0"},
		{"create-hmac", "1.1.7"},
		{"create-react-class", "15.6.3"},
		{"create-react-context", "0.2.2"},
		{"create-react-context", "0.2.3"},
		{"cross-spawn", "4.0.2"},
		{"cross-spawn", "5.1.0"},
		{"cross-spawn", "6.0.5"},
		{"crypt", "0.0.2"},
		{"crypto-browserify", "3.12.0"},
		{"crypto-random-string", "1.0.0"},
		{"css-color-keywords", "1.0.0"},
		{"css-loader", "1.0.1"},
		{"css-select", "1.2.0"},
		{"css-select", "2.0.2"},
		{"css-select-base-adapter", "0.1.1"},
		{"css-selector-tokenizer", "0.7.1"},
		{"css-to-react-native", "2.3.1"},
		{"css-tree", "1.0.0-alpha.28"},
		{"css-tree", "1.0.0-alpha.29"},
		{"css-url-regex", "1.1.0"},
		{"css-vendor", "0.3.8"},
		{"css-what", "2.1.3"},
		{"cssesc", "0.1.0"},
		{"csso", "3.5.1"},
		{"cssom", "0.3.6"},
		{"cssstyle", "1.2.2"},
		{"csstype", "2.6.4"},
		{"cyclist", "0.2.2"},
		{"damerau-levenshtein", "1.0.5"},
		{"dashdash", "1.14.1"},
		{"data-urls", "1.1.0"},
		{"date-fns", "1.30.1"},
		{"date-fns", "2.0.0-alpha.27"},
		{"date-now", "0.1.4"},
		{"debounce", "1.2.0"},
		{"debug", "2.6.9"},
		{"debug", "3.1.0"},
		{"debug", "3.2.6"},
		{"debug", "4.1.1"},
		{"debuglog", "1.0.1"},
		{"decamelize", "1.2.0"},
		{"decode-uri-component", "0.2.0"},
		{"decompress-response", "3.3.0"},
		{"dedent", "0.7.0"},
		{"deep-equal", "1.0.1"},
		{"deep-extend", "0.6.0"},
		{"deep-is", "0.1.3"},
		{"deepmerge", "2.2.1"},
		{"deepmerge", "3.2.0"},
		{"default-gateway", "4.2.0"},
		{"default-require-extensions", "1.0.0"},
		{"defaults", "1.0.3"},
		{"define-properties", "1.1.3"},
		{"define-property", "0.2.5"},
		{"define-property", "1.0.0"},
		{"define-property", "2.0.2"},
		{"del", "3.0.0"},
		{"del", "4.1.1"},
		{"delayed-stream", "1.0.0"},
		{"delegates", "1.0.0"},
		{"depd", "1.1.2"},
		{"des.js", "1.0.0"},
		{"destroy", "1.0.4"},
		{"detect-file", "1.0.0"},
		{"detect-indent", "4.0.0"},
		{"detect-indent", "5.0.0"},
		{"detect-libc", "1.0.3"},
		{"detect-newline", "2.1.0"},
		{"detect-node", "2.0.4"},
		{"detect-port", "1.3.0"},
		{"detect-port-alt", "1.1.6"},
		{"dezalgo", "1.0.3"},
		{"diff", "3.5.0"},
		{"diffie-hellman", "5.0.3"},
		{"dir-glob", "2.2.2"},
		{"discontinuous-range", "1.0.0"},
		{"dns-equal", "1.0.0"},
		{"dns-packet", "1.3.1"},
		{"dns-txt", "2.0.2"},
		{"doctrine", "1.5.0"},
		{"doctrine", "2.1.0"},
		{"doctrine", "3.0.0"},
		{"dom-converter", "0.2.0"},
		{"dom-helpers", "3.4.0"},
		{"dom-serializer", "0.1.1"},
		{"dom-walk", "0.1.1"},
		{"domain-browser", "1.2.0"},
		{"domelementtype", "1.3.1"},
		{"domexception", "1.0.1"},
		{"domhandler", "2.4.2"},
		{"domutils", "1.5.1"},
		{"domutils", "1.7.0"},
		{"dot-prop", "4.2.0"},
		{"dotenv", "5.0.1"},
		{"dotenv", "6.2.0"},
		{"dotenv-defaults", "1.0.2"},
		{"dotenv-expand", "4.2.0"},
		{"dotenv-webpack", "1.7.0"},
		{"duplexer", "0.1.1"},
		{"duplexer2", "0.1.4"},
		{"duplexer3", "0.1.4"},
		{"duplexify", "3.7.1"},
		{"ecc-jsbn", "0.1.2"},
		{"editor", "1.0.0"},
		{"ee-first", "1.1.1"},
		{"ejs", "2.6.1"},
		{"electron-to-chromium", "1.3.134"},
		{"elegant-spinner", "1.0.1"},
		{"elliptic", "6.4.1"},
		{"emoji-regex", "7.0.3"},
		{"emojis-list", "2.1.0"},
		{"encodeurl", "1.0.2"},
		{"encoding", "0.1.12"},
		{"end-of-stream", "1.4.1"},
		{"engine.io", "3.3.2"},
		{"engine.io-client", "3.3.2"},
		{"engine.io-parser", "2.1.3"},
		{"enhanced-resolve", "4.1.0"},
		{"entities", "1.1.2"},
		{"enzyme", "3.9.0"},
		{"enzyme-adapter-react-16", "1.13.0"},
		{"enzyme-adapter-utils", "1.12.0"},
		{"err-code", "1.1.2"},
		{"errno", "0.1.7"},
		{"error-ex", "1.3.2"},
		{"es-abstract", "1.13.0"},
		{"es-to-primitive", "1.2.0"},
		{"es5-shim", "4.5.13"},
		{"es6-promise", "3.3.1"},
		{"es6-promise", "4.2.6"},
		{"es6-promise-promise", "1.0.0"},
		{"es6-promisify", "5.0.0"},
		{"es6-shim", "0.35.5"},
		{"escape-html", "1.0.3"},
		{"escape-string-regexp", "1.0.5"},
		{"escodegen", "1.11.1"},
		{"eslint", "5.16.0"},
		{"eslint-config-airbnb", "17.1.0"},
		{"eslint-config-airbnb-base", "13.1.0"},
		{"eslint-import-resolver-node", "0.3.2"},
		{"eslint-loader", "2.1.2"},
		{"eslint-module-utils", "2.4.0"},
		{"eslint-plugin-import", "2.17.2"},
		{"eslint-plugin-jsx-a11y", "6.2.1"},
		{"eslint-plugin-react", "7.13.0"},
		{"eslint-restricted-globals", "0.1.1"},
		{"eslint-scope", "3.7.1"},
		{"eslint-scope", "4.0.3"},
		{"eslint-utils", "1.3.1"},
		{"eslint-visitor-keys", "1.0.0"},
		{"espree", "5.0.1"},
		{"esprima", "3.1.3"},
		{"esprima", "4.0.1"},
		{"esquery", "1.0.1"},
		{"esrecurse", "4.2.1"},
		{"estraverse", "4.2.0"},
		{"esutils", "2.0.2"},
		{"etag", "1.8.1"},
		{"eventemitter3", "3.1.2"},
		{"events", "3.0.0"},
		{"eventsource", "0.1.6"},
		{"eventsource", "1.0.7"},
		{"evp_bytestokey", "1.0.3"},
		{"exec-sh", "0.2.2"},
		{"execa", "0.7.0"},
		{"execa", "0.9.0"},
		{"execa", "1.0.0"},
		{"exenv", "1.2.2"},
		{"exit", "0.1.2"},
		{"exit-hook", "1.1.1"},
		{"expand-brackets", "0.1.5"},
		{"expand-brackets", "2.1.4"},
		{"expand-range", "1.8.2"},
		{"expand-tilde", "2.0.2"},
		{"expect", "23.6.0"},
		{"express", "4.16.4"},
		{"extend", "3.0.2"},
		{"extend-shallow", "2.0.1"},
		{"extend-shallow", "3.0.2"},
		{"external-editor", "3.0.3"},
		{"extglob", "0.3.2"},
		{"extglob", "2.0.4"},
		{"extract-text-webpack-plugin", "4.0.0-beta.0"},
		{"extsprintf", "1.3.0"},
		{"extsprintf", "1.4.0"},
		{"faker", "4.1.0"},
		{"fast-deep-equal", "2.0.1"},
		{"fast-glob", "2.2.6"},
		{"fast-json-stable-stringify", "2.0.0"},
		{"fast-levenshtein", "2.0.6"},
		{"fastparse", "1.1.2"},
		{"faye-websocket", "0.10.0"},
		{"faye-websocket", "0.11.1"},
		{"fb-watchman", "2.0.0"},
		{"fbjs", "0.8.17"},
		{"figgy-pudding", "3.5.1"},
		{"figures", "1.7.0"},
		{"figures", "2.0.0"},
		{"file-entry-cache", "5.0.1"},
		{"file-loader", "1.1.11"},
		{"file-loader", "2.0.0"},
		{"file-selector", "0.1.11"},
		{"file-system-cache", "1.0.5"},
		{"filename-regex", "2.0.1"},
		{"fileset", "2.0.3"},
		{"filesize", "3.6.1"},
		{"fill-range", "2.2.4"},
		{"fill-range", "4.0.0"},
		{"finalhandler", "1.1.1"},
		{"find-cache-dir", "0.1.1"},
		{"find-cache-dir", "1.0.0"},
		{"find-cache-dir", "2.1.0"},
		{"find-npm-prefix", "1.0.2"},
		{"find-parent-dir", "0.3.0"},
		{"find-up", "1.1.2"},
		{"find-up", "2.1.0"},
		{"find-up", "3.0.0"},
		{"findup-sync", "2.0.0"},
		{"flat-cache", "2.0.1"},
		{"flatted", "2.0.0"},
		{"flow-bin", "0.89.0"},
		{"flow-parser", "0.98.1"},
		{"flow-typed", "2.5.1"},
		{"flush-write-stream", "1.1.1"},
		{"follow-redirects", "1.7.0"},
		{"for-in", "0.1.8"},
		{"for-in", "1.0.2"},
		{"for-own", "0.1.5"},
		{"forever-agent", "0.6.1"},
		{"form-data", "2.3.3"},
		{"formik", "1.5.1"},
		{"forwarded", "0.1.2"},
		{"fragment-cache", "0.2.1"},
		{"fresh", "0.5.2"},
		{"from2", "1.3.0"},
		{"from2", "2.3.0"},
		{"fs-extra", "0.30.0"},
		{"fs-extra", "5.0.0"},
		{"fs-extra", "7.0.1"},
		{"fs-minipass", "1.2.5"},
		{"fs-readdir-recursive", "1.1.0"},
		{"fs-vacuum", "1.2.10"},
		{"fs-write-stream-atomic", "1.0.10"},
		{"fs.realpath", "1.0.0"},
		{"fsevents", "1.2.9"},
		{"fstream", "1.0.12"},
		{"function-bind", "1.1.1"},
		{"function.prototype.name", "1.1.0"},
		{"functional-red-black-tree", "1.0.1"},
		{"fuse.js", "3.4.4"},
		{"gauge", "2.7.4"},
		{"genfun", "5.0.0"},
		{"gentle-fs", "2.0.1"},
		{"get-caller-file", "1.0.3"},
		{"get-own-enumerable-property-symbols", "3.0.0"},
		{"get-stdin", "6.0.0"},
		{"get-stream", "3.0.0"},
		{"get-stream", "4.1.0"},
		{"get-value", "2.0.6"},
		{"getpass", "0.1.7"},
		{"glob", "7.1.4"},
		{"glob-base", "0.3.0"},
		{"glob-parent", "2.0.0"},
		{"glob-parent", "3.1.0"},
		{"glob-to-regexp", "0.3.0"},
		{"global", "4.3.2"},
		{"global-dirs", "0.1.1"},
		{"global-modules", "1.0.0"},
		{"global-prefix", "1.0.2"},
		{"globals", "11.12.0"},
		{"globals", "9.18.0"},
		{"globalthis", "1.0.0"},
		{"globby", "6.1.0"},
		{"globby", "7.1.1"},
		{"globby", "8.0.1"},
		{"got", "6.7.1"},
		{"got", "7.1.0"},
		{"graceful-fs", "4.1.15"},
		{"growly", "1.3.0"},
		{"gud", "1.0.0"},
		{"gzip-size", "5.0.0"},
		{"gzip-size", "5.1.0"},
		{"handle-thing", "2.0.0"},
		{"handlebars", "4.1.2"},
		{"har-schema", "2.0.0"},
		{"har-validator", "5.1.3"},
		{"hard-source-webpack-plugin", "0.13.1"},
		{"has", "1.0.3"},
		{"has-ansi", "2.0.0"},
		{"has-binary2", "1.0.3"},
		{"has-color", "0.1.7"},
		{"has-cors", "1.1.0"},
		{"has-flag", "1.0.0"},
		{"has-flag", "3.0.0"},
		{"has-symbol-support-x", "1.4.2"},
		{"has-symbols", "1.0.0"},
		{"has-to-string-tag-x", "1.4.1"},
		{"has-unicode", "2.0.1"},
		{"has-value", "0.3.1"},
		{"has-value", "1.0.0"},
		{"has-values", "0.1.4"},
		{"has-values", "1.0.0"},
		{"hash-base", "3.0.4"},
		{"hash.js", "1.1.7"},
		{"hast-util-from-parse5", "5.0.0"},
		{"hast-util-parse-selector", "2.2.1"},
		{"hastscript", "5.0.0"},
		{"he", "1.2.0"},
		{"history", "4.9.0"},
		{"hmac-drbg", "1.0.1"},
		{"hoist-non-react-statics", "1.2.0"},
		{"hoist-non-react-statics", "2.5.5"},
		{"hoist-non-react-statics", "3.3.0"},
		{"home-or-tmp", "2.0.0"},
		{"homedir-polyfill", "1.0.3"},
		{"hoopy", "0.1.4"},
		{"hosted-git-info", "2.7.1"},
		{"hpack.js", "2.1.6"},
		{"html-element-map", "1.0.1"},
		{"html-encoding-sniffer", "1.0.2"},
		{"html-entities", "1.2.1"},
		{"html-minifier", "3.5.21"},
		{"html-webpack-harddisk-plugin", "1.0.1"},
		{"html-webpack-plugin", "3.2.0"},
		{"html-webpack-plugin", "4.0.0-beta.5"},
		{"htmlparser2", "3.10.1"},
		{"http-cache-semantics", "3.8.1"},
		{"http-deceiver", "1.2.7"},
		{"http-errors", "1.6.3"},
		{"http-parser-js", "0.5.0"},
		{"http-proxy", "1.17.0"},
		{"http-proxy-agent", "2.1.0"},
		{"http-proxy-middleware", "0.19.1"},
		{"http-signature", "1.2.0"},
		{"https-browserify", "1.0.0"},
		{"https-proxy-agent", "2.2.1"},
		{"humanize-ms", "1.2.1"},
		{"husky", "1.3.1"},
		{"hyphenate-style-name", "1.0.3"},
		{"i", "0.3.6"},
		{"iconv-lite", "0.4.23"},
		{"iconv-lite", "0.4.24"},
		{"icss-replace-symbols", "1.1.0"},
		{"icss-utils", "2.1.0"},
		{"ieee754", "1.1.13"},
		{"iferr", "0.1.5"},
		{"iferr", "1.0.2"},
		{"ignore", "3.3.10"},
		{"ignore", "4.0.6"},
		{"ignore-walk", "3.0.1"},
		{"immer", "1.7.2"},
		{"immutable", "3.8.2"},
		{"import-cwd", "2.1.0"},
		{"import-fresh", "2.0.0"},
		{"import-fresh", "3.0.0"},
		{"import-from", "2.1.0"},
		{"import-lazy", "2.1.0"},
		{"import-local", "1.0.0"},
		{"import-local", "2.0.0"},
		{"imurmurhash", "0.1.4"},
		{"indefinite-observable", "1.0.2"},
		{"indent-string", "3.2.0"},
		{"indexof", "0.0.1"},
		{"inflight", "1.0.6"},
		{"inherits", "2.0.1"},
		{"inherits", "2.0.3"},
		{"ini", "1.3.5"},
		{"init-package-json", "1.10.3"},
		{"inquirer", "0.11.4"},
		{"inquirer", "6.2.0"},
		{"inquirer", "6.3.1"},
		{"internal-ip", "4.3.0"},
		{"interpret", "1.2.0"},
		{"intl", "1.2.5"},
		{"intl-messageformat", "2.2.0"},
		{"intl-messageformat-parser", "1.4.0"},
		{"invariant", "2.2.4"},
		{"invert-kv", "1.0.0"},
		{"invert-kv", "2.0.0"},
		{"ip", "1.1.5"},
		{"ip-regex", "2.1.0"},
		{"ipaddr.js", "1.9.0"},
		{"is-accessor-descriptor", "0.1.6"},
		{"is-accessor-descriptor", "1.0.0"},
		{"is-arrayish", "0.2.1"},
		{"is-binary-path", "1.0.1"},
		{"is-boolean-object", "1.0.0"},
		{"is-buffer", "1.1.6"},
		{"is-buffer", "2.0.3"},
		{"is-callable", "1.1.4"},
		{"is-ci", "1.2.1"},
		{"is-ci", "2.0.0"},
		{"is-cidr", "3.0.0"},
		{"is-data-descriptor", "0.1.4"},
		{"is-data-descriptor", "1.0.0"},
		{"is-date-object", "1.0.1"},
		{"is-descriptor", "0.1.6"},
		{"is-descriptor", "1.0.2"},
		{"is-directory", "0.3.1"},
		{"is-dom", "1.0.9"},
		{"is-dotfile", "1.0.3"},
		{"is-electron", "2.2.0"},
		{"is-equal-shallow", "0.1.3"},
		{"is-extendable", "0.1.1"},
		{"is-extendable", "1.0.1"},
		{"is-extglob", "1.0.0"},
		{"is-extglob", "2.1.1"},
		{"is-finite", "1.0.2"},
		{"is-fullwidth-code-point", "1.0.0"},
		{"is-fullwidth-code-point", "2.0.0"},
		{"is-generator-fn", "1.0.0"},
		{"is-glob", "2.0.1"},
		{"is-glob", "3.1.0"},
		{"is-glob", "4.0.1"},
		{"is-in-browser", "1.1.3"},
		{"is-installed-globally", "0.1.0"},
		{"is-npm", "1.0.0"},
		{"is-number", "2.1.0"},
		{"is-number", "3.0.0"},
		{"is-number", "4.0.0"},
		{"is-number-object", "1.0.3"},
		{"is-obj", "1.0.1"},
		{"is-object", "1.0.1"},
		{"is-observable", "1.1.0"},
		{"is-path-cwd", "1.0.0"},
		{"is-path-cwd", "2.1.0"},
		{"is-path-in-cwd", "1.0.1"},
		{"is-path-in-cwd", "2.1.0"},
		{"is-path-inside", "1.0.1"},
		{"is-path-inside", "2.1.0"},
		{"is-plain-obj", "1.1.0"},
		{"is-plain-object", "2.0.4"},
		{"is-posix-bracket", "0.1.1"},
		{"is-primitive", "2.0.0"},
		{"is-promise", "2.1.0"},
		{"is-redirect", "1.0.0"},
		{"is-regex", "1.0.4"},
		{"is-regexp", "1.0.0"},
		{"is-retry-allowed", "1.1.0"},
		{"is-root", "2.0.0"},
		{"is-stream", "1.1.0"},
		{"is-string", "1.0.4"},
		{"is-subset", "0.1.1"},
		{"is-symbol", "1.0.2"},
		{"is-typedarray", "1.0.0"},
		{"is-utf8", "0.2.1"},
		{"is-windows", "1.0.2"},
		{"is-wsl", "1.1.0"},
		{"isarray", "0.0.1"},
		{"isarray", "1.0.0"},
		{"isarray", "2.0.1"},
		{"isexe", "2.0.0"},
		{"isobject", "2.1.0"},
		{"isobject", "3.0.1"},
		{"isomorphic-fetch", "2.2.1"},
		{"isstream", "0.1.2"},
		{"istanbul-api", "1.3.7"},
		{"istanbul-lib-coverage", "1.2.1"},
		{"istanbul-lib-hook", "1.2.2"},
		{"istanbul-lib-instrument", "1.10.2"},
		{"istanbul-lib-report", "1.1.5"},
		{"istanbul-lib-source-maps", "1.2.6"},
		{"istanbul-reports", "1.5.1"},
		{"isurl", "1.0.0"},
		{"jest", "23.6.0"},
		{"jest-changed-files", "23.4.2"},
		{"jest-cli", "23.6.0"},
		{"jest-config", "23.6.0"},
		{"jest-diff", "23.6.0"},
		{"jest-docblock", "23.2.0"},
		{"jest-each", "23.6.0"},
		{"jest-environment-jsdom", "23.4.0"},
		{"jest-environment-node", "23.4.0"},
		{"jest-get-type", "22.4.3"},
		{"jest-haste-map", "23.6.0"},
		{"jest-jasmine2", "23.6.0"},
		{"jest-leak-detector", "23.6.0"},
		{"jest-matcher-utils", "23.6.0"},
		{"jest-message-util", "23.4.0"},
		{"jest-mock", "23.2.0"},
		{"jest-regex-util", "23.3.0"},
		{"jest-resolve", "23.6.0"},
		{"jest-resolve-dependencies", "23.6.0"},
		{"jest-runner", "23.6.0"},
		{"jest-runtime", "23.6.0"},
		{"jest-serializer", "23.0.1"},
		{"jest-snapshot", "23.6.0"},
		{"jest-util", "23.4.0"},
		{"jest-validate", "23.6.0"},
		{"jest-watcher", "23.4.0"},
		{"jest-worker", "23.2.0"},
		{"js-file-download", "0.4.5"},
		{"js-levenshtein", "1.1.6"},
		{"js-tokens", "3.0.2"},
		{"js-tokens", "4.0.0"},
		{"js-yaml", "3.13.1"},
		{"jsbn", "0.1.1"},
		{"jscodeshift", "0.5.1"},
		{"jsdom", "11.12.0"},
		{"jsesc", "0.5.0"},
		{"jsesc", "1.3.0"},
		{"jsesc", "2.5.2"},
		{"json-parse-better-errors", "1.0.2"},
		{"json-schema", "0.2.3"},
		{"json-schema-traverse", "0.4.1"},
		{"json-stable-stringify-without-jsonify", "1.0.1"},
		{"json-stringify-safe", "5.0.1"},
		{"json3", "3.3.2"},
		{"json5", "0.5.1"},
		{"json5", "1.0.1"},
		{"json5", "2.1.0"},
		{"jsonfile", "2.4.0"},
		{"jsonfile", "4.0.0"},
		{"jsonify", "0.0.0"},
		{"jsonparse", "1.3.1"},
		{"jsprim", "1.4.1"},
		{"jss", "9.8.7"},
		{"jss-camel-case", "6.1.0"},
		{"jss-default-unit", "8.0.2"},
		{"jss-global", "3.0.0"},
		{"jss-nested", "6.0.1"},
		{"jss-props-sort", "6.0.0"},
		{"jss-vendor-prefixer", "7.0.0"},
		{"jsx-ast-utils", "2.1.0"},
		{"keycode", "2.2.0"},
		{"killable", "1.0.1"},
		{"kind-of", "2.0.1"},
		{"kind-of", "3.2.2"},
		{"kind-of", "4.0.0"},
		{"kind-of", "5.1.0"},
		{"kind-of", "6.0.2"},
		{"klaw", "1.3.1"},
		{"kleur", "2.0.2"},
		{"latest-version", "3.1.0"},
		{"lazy-cache", "0.2.7"},
		{"lazy-cache", "1.0.4"},
		{"lazy-property", "1.0.0"},
		{"lazy-universal-dotenv", "2.0.0"},
		{"lcid", "1.0.0"},
		{"lcid", "2.0.0"},
		{"left-pad", "1.3.0"},
		{"leven", "2.1.0"},
		{"levn", "0.3.0"},
		{"libcipm", "3.0.3"},
		{"libnpm", "2.0.1"},
		{"libnpmaccess", "3.0.1"},
		{"libnpmconfig", "1.2.1"},
		{"libnpmhook", "5.0.2"},
		{"libnpmorg", "1.0.0"},
		{"libnpmpublish", "1.1.1"},
		{"libnpmsearch", "2.0.0"},
		{"libnpmteam", "1.0.1"},
		{"libnpx", "10.2.0"},
		{"linear-layout-vector", "0.0.1"},
		{"lint-staged", "7.3.0"},
		{"listenercount", "1.0.1"},
		{"listr", "0.14.3"},
		{"listr-silent-renderer", "1.1.1"},
		{"listr-update-renderer", "0.5.0"},
		{"listr-verbose-renderer", "0.5.0"},
		{"load-json-file", "1.1.0"},
		{"load-json-file", "2.0.0"},
		{"load-json-file", "4.0.0"},
		{"load-script", "1.0.0"},
		{"loader-fs-cache", "1.0.2"},
		{"loader-runner", "2.4.0"},
		{"loader-utils", "0.2.17"},
		{"loader-utils", "1.1.0"},
		{"loader-utils", "1.2.3"},
		{"locate-path", "2.0.0"},
		{"locate-path", "3.0.0"},
		{"lock-verify", "2.1.0"},
		{"lockfile", "1.0.4"},
		{"lodash", "3.10.1"},
		{"lodash", "4.17.11"},
		{"lodash-es", "4.17.11"},
		{"lodash._baseuniq", "4.6.0"},
		{"lodash._createset", "4.0.3"},
		{"lodash._root", "3.0.1"},
		{"lodash.assign", "4.2.0"},
		{"lodash.clonedeep", "4.5.0"},
		{"lodash.escape", "4.0.1"},
		{"lodash.flattendeep", "4.4.0"},
		{"lodash.isequal", "4.5.0"},
		{"lodash.isplainobject", "4.0.6"},
		{"lodash.merge", "4.6.1"},
		{"lodash.some", "4.6.0"},
		{"lodash.sortby", "4.7.0"},
		{"lodash.union", "4.6.0"},
		{"lodash.uniq", "4.5.0"},
		{"lodash.without", "4.4.0"},
		{"log-symbols", "1.0.2"},
		{"log-symbols", "2.2.0"},
		{"log-update", "2.3.0"},
		{"loglevel", "1.6.1"},
		{"loose-envify", "1.4.0"},
		{"lower-case", "1.1.4"},
		{"lowercase-keys", "1.0.1"},
		{"lru-cache", "4.1.5"},
		{"lru-cache", "5.1.1"},
		{"macos-release", "2.2.0"},
		{"make-dir", "1.3.0"},
		{"make-dir", "2.1.0"},
		{"make-error", "1.3.5"},
		{"make-fetch-happen", "4.0.1"},
		{"makeerror", "1.0.11"},
		{"mamacro", "0.0.3"},
		{"map-age-cleaner", "0.1.3"},
		{"map-cache", "0.2.2"},
		{"map-visit", "1.0.0"},
		{"marked", "0.3.19"},
		{"marksy", "6.1.0"},
		{"material-colors", "1.2.6"},
		{"math-random", "1.0.4"},
		{"md5", "2.2.1"},
		{"md5.js", "1.3.5"},
		{"mdn-data", "1.1.4"},
		{"meant", "1.0.1"},
		{"media-typer", "0.3.0"},
		{"mem", "1.1.0"},
		{"mem", "4.3.0"},
		{"memoize-one", "4.1.0"},
		{"memory-fs", "0.4.1"},
		{"memorystream", "0.3.1"},
		{"merge", "1.2.1"},
		{"merge-deep", "3.0.2"},
		{"merge-descriptors", "1.0.1"},
		{"merge-dirs", "0.2.1"},
		{"merge-stream", "1.0.1"},
		{"merge2", "1.2.3"},
		{"methods", "1.1.2"},
		{"micromatch", "2.3.11"},
		{"micromatch", "3.1.10"},
		{"miller-rabin", "4.0.1"},
		{"mime", "1.4.1"},
		{"mime", "2.4.2"},
		{"mime-db", "1.40.0"},
		{"mime-types", "2.1.24"},
		{"mimic-fn", "1.2.0"},
		{"mimic-fn", "2.1.0"},
		{"mimic-response", "1.0.1"},
		{"min-document", "2.19.0"},
		{"mini-css-extract-plugin", "0.4.5"},
		{"minimalistic-assert", "1.0.1"},
		{"minimalistic-crypto-utils", "1.0.1"},
		{"minimatch", "3.0.4"},
		{"minimist", "0.0.10"},
		{"minimist", "0.0.8"},
		{"minimist", "1.2.0"},
		{"minipass", "2.3.5"},
		{"minizlib", "1.2.1"},
		{"mississippi", "2.0.0"},
		{"mississippi", "3.0.0"},
		{"mixin-deep", "1.3.1"},
		{"mixin-object", "2.0.1"},
		{"mkdirp", "0.5.1"},
		{"moment", "2.23.0"},
		{"moment", "2.24.0"},
		{"moment-timezone", "0.5.23"},
		{"moo", "0.4.3"},
		{"move-concurrently", "1.0.1"},
		{"ms", "2.0.0"},
		{"ms", "2.1.1"},
		{"multicast-dns", "6.2.3"},
		{"multicast-dns-service-types", "1.1.0"},
		{"mute-stream", "0.0.5"},
		{"mute-stream", "0.0.7"},
		{"mute-stream", "0.0.8"},
		{"nan", "2.13.2"},
		{"nanomatch", "1.2.13"},
		{"natural-compare", "1.4.0"},
		{"nearley", "2.16.0"},
		{"needle", "2.4.0"},
		{"negotiator", "0.6.2"},
		{"neo-async", "2.6.1"},
		{"nested-object-assign", "1.0.3"},
		{"nice-try", "1.0.5"},
		{"no-case", "2.3.2"},
		{"node-dir", "0.1.17"},
		{"node-dir", "0.1.8"},
		{"node-fetch", "1.7.3"},
		{"node-fetch", "2.5.0"},
		{"node-fetch-npm", "2.0.2"},
		{"node-forge", "0.7.5"},
		{"node-fs", "0.1.7"},
		{"node-gyp", "3.8.0"},
		{"node-gyp", "4.0.0"},
		{"node-int64", "0.4.0"},
		{"node-libs-browser", "2.2.0"},
		{"node-modules-regexp", "1.0.0"},
		{"node-notifier", "5.4.0"},
		{"node-object-hash", "1.4.2"},
		{"node-pre-gyp", "0.12.0"},
		{"node-releases", "1.1.19"},
		{"node-version", "1.2.0"},
		{"nomnom", "1.8.1"},
		{"nopt", "3.0.6"},
		{"nopt", "4.0.1"},
		{"normalize-package-data", "2.5.0"},
		{"normalize-path", "2.1.1"},
		{"normalize-path", "3.0.0"},
		{"normalize-range", "0.1.2"},
		{"normalize-scroll-left", "0.1.2"},
		{"npm", "6.9.0"},
		{"npm-audit-report", "1.3.2"},
		{"npm-bundled", "1.0.6"},
		{"npm-cache-filename", "1.0.2"},
		{"npm-install-checks", "3.0.0"},
		{"npm-lifecycle", "2.1.1"},
		{"npm-logical-tree", "1.2.1"},
		{"npm-package-arg", "6.1.0"},
		{"npm-packlist", "1.4.1"},
		{"npm-path", "2.0.4"},
		{"npm-pick-manifest", "2.2.3"},
		{"npm-profile", "4.0.1"},
		{"npm-registry-fetch", "3.9.0"},
		{"npm-run-all", "4.1.5"},
		{"npm-run-path", "2.0.2"},
		{"npm-user-validate", "1.0.0"},
		{"npm-which", "3.0.1"},
		{"npmlog", "4.1.2"},
		{"nth-check", "1.0.2"},
		{"num2fraction", "1.2.2"},
		{"number-is-nan", "1.0.1"},
		{"nwsapi", "2.1.4"},
		{"oauth-sign", "0.9.0"},
		{"object-assign", "4.1.1"},
		{"object-component", "0.0.3"},
		{"object-copy", "0.1.0"},
		{"object-hash", "1.3.1"},
		{"object-inspect", "1.6.0"},
		{"object-is", "1.0.1"},
		{"object-keys", "1.1.1"},
		{"object-visit", "1.0.1"},
		{"object.assign", "4.1.0"},
		{"object.entries", "1.1.0"},
		{"object.fromentries", "2.0.0"},
		{"object.getownpropertydescriptors", "2.0.3"},
		{"object.omit", "2.0.1"},
		{"object.pick", "1.3.0"},
		{"object.values", "1.1.0"},
		{"obuf", "1.1.2"},
		{"on-finished", "2.3.0"},
		{"on-headers", "1.0.2"},
		{"once", "1.4.0"},
		{"onetime", "1.1.0"},
		{"onetime", "2.0.1"},
		{"opener", "1.5.1"},
		{"opn", "5.4.0"},
		{"opn", "5.5.0"},
		{"optimist", "0.6.1"},
		{"optionator", "0.8.2"},
		{"original", "1.0.2"},
		{"os-browserify", "0.3.0"},
		{"os-homedir", "1.0.2"},
		{"os-locale", "1.4.0"},
		{"os-locale", "2.1.0"},
		{"os-locale", "3.1.0"},
		{"os-name", "3.1.0"},
		{"os-tmpdir", "1.0.2"},
		{"osenv", "0.1.5"},
		{"output-file-sync", "1.1.2"},
		{"p-cancelable", "0.3.0"},
		{"p-defer", "1.0.0"},
		{"p-finally", "1.0.0"},
		{"p-is-promise", "2.1.0"},
		{"p-limit", "1.3.0"},
		{"p-limit", "2.2.0"},
		{"p-locate", "2.0.0"},
		{"p-locate", "3.0.0"},
		{"p-map", "1.2.0"},
		{"p-map", "2.1.0"},
		{"p-timeout", "1.2.1"},
		{"p-try", "1.0.0"},
		{"p-try", "2.2.0"},
		{"package-json", "4.0.1"},
		{"pacote", "9.5.0"},
		{"pako", "1.0.10"},
		{"parallel-transform", "1.1.0"},
		{"param-case", "2.1.1"},
		{"parent-module", "1.0.1"},
		{"parse-asn1", "5.1.4"},
		{"parse-glob", "3.0.4"},
		{"parse-json", "2.2.0"},
		{"parse-json", "4.0.0"},
		{"parse-passwd", "1.0.0"},
		{"parse5", "3.0.3"},
		{"parse5", "4.0.0"},
		{"parse5", "5.1.0"},
		{"parseqs", "0.0.5"},
		{"parseuri", "0.0.5"},
		{"parseurl", "1.3.3"},
		{"pascalcase", "0.1.1"},
		{"path", "0.12.7"},
		{"path-browserify", "0.0.0"},
		{"path-dirname", "1.0.2"},
		{"path-exists", "2.1.0"},
		{"path-exists", "3.0.0"},
		{"path-is-absolute", "1.0.1"},
		{"path-is-inside", "1.0.2"},
		{"path-key", "2.0.1"},
		{"path-parse", "1.0.6"},
		{"path-to-regexp", "0.1.7"},
		{"path-to-regexp", "1.7.0"},
		{"path-type", "1.1.0"},
		{"path-type", "2.0.0"},
		{"path-type", "3.0.0"},
		{"pbkdf2", "3.0.17"},
		{"performance-now", "2.1.0"},
		{"pidtree", "0.3.0"},
		{"pify", "2.3.0"},
		{"pify", "3.0.0"},
		{"pify", "4.0.1"},
		{"pinkie", "2.0.4"},
		{"pinkie-promise", "2.0.1"},
		{"pirates", "4.0.1"},
		{"pkg-dir", "1.0.0"},
		{"pkg-dir", "2.0.0"},
		{"pkg-dir", "3.0.0"},
		{"pkg-up", "2.0.0"},
		{"please-upgrade-node", "3.1.1"},
		{"pn", "1.1.0"},
		{"popper.js", "1.15.0"},
		{"portfinder", "1.0.20"},
		{"posix-character-classes", "0.1.1"},
		{"postcss", "6.0.23"},
		{"postcss", "7.0.16"},
		{"postcss-flexbugs-fixes", "4.1.0"},
		{"postcss-load-config", "2.0.0"},
		{"postcss-loader", "3.0.0"},
		{"postcss-modules-extract-imports", "1.2.1"},
		{"postcss-modules-local-by-default", "1.2.0"},
		{"postcss-modules-scope", "1.1.0"},
		{"postcss-modules-values", "1.3.0"},
		{"postcss-value-parser", "3.3.1"},
		{"prelude-ls", "1.1.2"},
		{"prepend-http", "1.0.4"},
		{"preserve", "0.2.0"},
		{"pretty-error", "2.1.1"},
		{"pretty-format", "23.6.0"},
		{"pretty-hrtime", "1.0.3"},
		{"private", "0.1.8"},
		{"process", "0.11.10"},
		{"process", "0.5.2"},
		{"process-nextick-args", "1.0.7"},
		{"process-nextick-args", "2.0.0"},
		{"progress", "2.0.3"},
		{"promise", "7.3.1"},
		{"promise-inflight", "1.0.1"},
		{"promise-polyfill", "6.1.0"},
		{"promise-retry", "1.1.1"},
		{"promise.allsettled", "1.0.1"},
		{"promise.prototype.finally", "3.1.0"},
		{"prompts", "0.1.14"},
		{"promzard", "0.3.0"},
		{"prop-types", "15.7.2"},
		{"prop-types-exact", "1.2.0"},
		{"property-information", "5.1.0"},
		{"proto-list", "1.2.4"},
		{"protoduck", "5.0.1"},
		{"proxy-addr", "2.0.5"},
		{"prr", "1.0.1"},
		{"pseudomap", "1.0.2"},
		{"psl", "1.1.31"},
		{"public-encrypt", "4.0.3"},
		{"pump", "2.0.1"},
		{"pump", "3.0.0"},
		{"pumpify", "1.5.1"},
		{"punycode", "1.3.2"},
		{"punycode", "1.4.1"},
		{"punycode", "2.1.1"},
		{"q", "1.5.1"},
		{"qrcode-terminal", "0.12.0"},
		{"qs", "6.5.2"},
		{"qs", "6.7.0"},
		{"query-string", "6.5.0"},
		{"querystring", "0.2.0"},
		{"querystring-es3", "0.2.1"},
		{"querystringify", "2.1.1"},
		{"qw", "1.0.1"},
		{"raf", "3.4.1"},
		{"railroad-diagrams", "1.0.0"},
		{"ramda", "0.21.0"},
		{"randexp", "0.4.6"},
		{"randomatic", "3.1.1"},
		{"randombytes", "2.1.0"},
		{"randomfill", "1.0.4"},
		{"range-parser", "1.2.1"},
		{"raven-for-redux", "1.4.0"},
		{"raven-js", "3.27.0"},
		{"raw-body", "2.3.3"},
		{"raw-loader", "0.5.1"},
		{"rc", "1.2.8"},
		{"react", "16.8.3"},
		{"react", "16.8.6"},
		{"react-addons-create-fragment", "15.6.2"},
		{"react-color", "2.17.3"},
		{"react-datepicker", "2.5.0"},
		{"react-dev-utils", "6.1.1"},
		{"react-docgen", "3.0.0"},
		{"react-dom", "16.8.3"},
		{"react-dom", "16.8.6"},
		{"react-dropzone", "10.1.4"},
		{"react-error-overlay", "5.1.6"},
		{"react-event-listener", "0.6.6"},
		{"react-fast-compare", "2.0.4"},
		{"react-fuzzy", "0.5.2"},
		{"react-ga", "2.5.7"},
		{"react-gateway", "3.0.0"},
		{"react-inspector", "2.3.1"},
		{"react-intl-universal", "1.16.2"},
		{"react-is", "16.8.6"},
		{"react-lifecycles-compat", "3.0.4"},
		{"react-modal", "3.8.1"},
		{"react-onclickoutside", "6.8.0"},
		{"react-popper", "1.3.3"},
		{"react-prop-types", "0.4.0"},
		{"react-redux", "6.0.1"},
		{"react-router", "4.3.1"},
		{"react-router-dom", "4.3.1"},
		{"react-split-pane", "0.1.87"},
		{"react-style-proptype", "3.2.2"},
		{"react-test-renderer", "16.8.6"},
		{"react-textarea-autosize", "7.1.0"},
		{"react-transition-group", "2.9.0"},
		{"react-treebeard", "3.1.0"},
		{"react-virtualized", "9.21.1"},
		{"reactcss", "1.2.3"},
		{"read", "1.0.7"},
		{"read-cmd-shim", "1.0.1"},
		{"read-installed", "4.0.3"},
		{"read-package-json", "2.0.13"},
		{"read-package-tree", "5.2.2"},
		{"read-pkg", "1.1.0"},
		{"read-pkg", "2.0.0"},
		{"read-pkg", "3.0.0"},
		{"read-pkg", "4.0.1"},
		{"read-pkg-up", "1.0.1"},
		{"read-pkg-up", "2.0.0"},
		{"readable-stream", "1.1.14"},
		{"readable-stream", "2.1.5"},
		{"readable-stream", "2.3.6"},
		{"readable-stream", "3.3.0"},
		{"readdir-scoped-modules", "1.0.2"},
		{"readdirp", "2.2.1"},
		{"readline2", "1.0.1"},
		{"realpath-native", "1.1.0"},
		{"recast", "0.14.7"},
		{"recast", "0.15.5"},
		{"recast", "0.16.2"},
		{"rechoir", "0.6.2"},
		{"recompose", "0.30.0"},
		{"recursive-readdir", "2.2.2"},
		{"redux", "4.0.1"},
		{"redux-thunk", "2.3.0"},
		{"reflect.ownkeys", "0.2.0"},
		{"regenerate", "1.4.0"},
		{"regenerate-unicode-properties", "8.1.0"},
		{"regenerator-runtime", "0.10.5"},
		{"regenerator-runtime", "0.11.1"},
		{"regenerator-runtime", "0.12.1"},
		{"regenerator-runtime", "0.13.2"},
		{"regenerator-transform", "0.10.1"},
		{"regenerator-transform", "0.13.4"},
		{"regex-cache", "0.4.4"},
		{"regex-not", "1.0.2"},
		{"regexp-tree", "0.1.6"},
		{"regexp.prototype.flags", "1.2.0"},
		{"regexpp", "2.0.1"},
		{"regexpu-core", "1.0.0"},
		{"regexpu-core", "2.0.0"},
		{"regexpu-core", "4.5.4"},
		{"registry-auth-token", "3.4.0"},
		{"registry-url", "3.1.0"},
		{"regjsgen", "0.2.0"},
		{"regjsgen", "0.5.0"},
		{"regjsparser", "0.1.5"},
		{"regjsparser", "0.6.0"},
		{"rehype-parse", "6.0.0"},
		{"relateurl", "0.2.7"},
		{"remove-trailing-separator", "1.1.0"},
		{"render-fragment", "0.1.1"},
		{"renderkid", "2.0.3"},
		{"repeat-element", "1.1.3"},
		{"repeat-string", "1.6.1"},
		{"repeating", "2.0.1"},
		{"replace-ext", "1.0.0"},
		{"request", "2.88.0"},
		{"request-promise-core", "1.1.2"},
		{"request-promise-native", "1.0.7"},
		{"require-directory", "2.1.1"},
		{"require-from-string", "2.0.2"},
		{"require-main-filename", "1.0.1"},
		{"requires-port", "1.0.0"},
		{"resolve", "1.1.7"},
		{"resolve", "1.10.1"},
		{"resolve-cwd", "2.0.0"},
		{"resolve-dir", "1.0.1"},
		{"resolve-from", "3.0.0"},
		{"resolve-from", "4.0.0"},
		{"resolve-pathname", "2.2.0"},
		{"resolve-url", "0.2.1"},
		{"restore-cursor", "1.0.1"},
		{"restore-cursor", "2.0.0"},
		{"ret", "0.1.15"},
		{"retry", "0.10.1"},
		{"retry", "0.12.0"},
		{"rimraf", "2.2.8"},
		{"rimraf", "2.6.3"},
		{"ripemd160", "2.0.2"},
		{"rst-selector-parser", "2.2.3"},
		{"rsvp", "3.6.2"},
		{"run-async", "0.1.0"},
		{"run-async", "2.3.0"},
		{"run-node", "1.0.0"},
		{"run-queue", "1.0.3"},
		{"rx-lite", "3.1.2"},
		{"rxjs", "6.5.2"},
		{"safe-buffer", "5.1.1"},
		{"safe-buffer", "5.1.2"},
		{"safe-regex", "1.1.0"},
		{"safer-buffer", "2.1.2"},
		{"sane", "2.5.2"},
		{"sax", "1.2.4"},
		{"scheduler", "0.13.6"},
		{"schema-utils", "0.4.7"},
		{"schema-utils", "1.0.0"},
		{"select-hose", "2.0.0"},
		{"selfsigned", "1.10.4"},
		{"semver", "5.3.0"},
		{"semver", "5.7.0"},
		{"semver", "6.0.0"},
		{"semver-compare", "1.0.0"},
		{"semver-diff", "2.1.0"},
		{"send", "0.16.2"},
		{"serialize-javascript", "1.7.0"},
		{"serve-favicon", "2.5.0"},
		{"serve-index", "1.9.1"},
		{"serve-static", "1.13.2"},
		{"set-blocking", "2.0.0"},
		{"set-value", "0.4.3"},
		{"set-value", "2.0.0"},
		{"setimmediate", "1.0.5"},
		{"setprototypeof", "1.1.0"},
		{"sha", "2.0.1"},
		{"sha.js", "2.4.11"},
		{"shallow-clone", "0.1.2"},
		{"shallowequal", "1.1.0"},
		{"shebang-command", "1.2.0"},
		{"shebang-regex", "1.0.0"},
		{"shell-quote", "1.6.1"},
		{"shelljs", "0.8.3"},
		{"shellwords", "0.1.1"},
		{"signal-exit", "3.0.2"},
		{"sisteransi", "0.1.1"},
		{"slash", "1.0.0"},
		{"slash", "2.0.0"},
		{"slice-ansi", "0.0.4"},
		{"slice-ansi", "1.0.0"},
		{"slice-ansi", "2.1.0"},
		{"slide", "1.1.6"},
		{"smart-buffer", "4.0.2"},
		{"snapdragon", "0.8.2"},
		{"snapdragon-node", "2.1.1"},
		{"snapdragon-util", "3.0.1"},
		{"socket.io", "2.2.0"},
		{"socket.io-adapter", "1.1.1"},
		{"socket.io-client", "2.2.0"},
		{"socket.io-parser", "3.3.0"},
		{"sockjs", "0.3.19"},
		{"sockjs-client", "1.1.5"},
		{"sockjs-client", "1.3.0"},
		{"socks", "2.3.2"},
		{"socks-proxy-agent", "4.0.2"},
		{"sort-keys", "2.0.0"},
		{"sorted-object", "2.0.1"},
		{"sorted-union-stream", "2.1.3"},
		{"source-list-map", "2.0.1"},
		{"source-map", "0.5.7"},
		{"source-map", "0.6.1"},
		{"source-map-resolve", "0.5.2"},
		{"source-map-support", "0.4.18"},
		{"source-map-support", "0.5.12"},
		{"source-map-url", "0.4.0"},
		{"space-separated-tokens", "1.1.4"},
		{"spawn-promise", "0.1.8"},
		{"spdx-correct", "3.1.0"},
		{"spdx-exceptions", "2.2.0"},
		{"spdx-expression-parse", "3.0.0"},
		{"spdx-license-ids", "3.0.4"},
		{"spdy", "4.0.0"},
		{"spdy-transport", "3.0.0"},
		{"split-on-first", "1.1.0"},
		{"split-string", "3.1.0"},
		{"sprintf-js", "1.0.3"},
		{"sshpk", "1.16.1"},
		{"ssri", "5.3.0"},
		{"ssri", "6.0.1"},
		{"stable", "0.1.8"},
		{"stack-utils", "1.0.2"},
		{"staged-git-files", "1.1.1"},
		{"static-extend", "0.1.2"},
		{"statuses", "1.4.0"},
		{"statuses", "1.5.0"},
		{"stealthy-require", "1.1.1"},
		{"stream-browserify", "2.0.2"},
		{"stream-each", "1.2.3"},
		{"stream-http", "2.8.3"},
		{"stream-iterate", "1.2.0"},
		{"stream-shift", "1.0.0"},
		{"strict-uri-encode", "2.0.0"},
		{"string-argv", "0.0.2"},
		{"string-length", "2.0.0"},
		{"string-width", "1.0.2"},
		{"string-width", "2.1.1"},
		{"string-width", "3.1.0"},
		{"string.prototype.matchall", "3.0.1"},
		{"string.prototype.padend", "3.0.0"},
		{"string.prototype.padstart", "3.0.0"},
		{"string.prototype.trim", "1.1.2"},
		{"string_decoder", "0.10.31"},
		{"string_decoder", "1.1.1"},
		{"string_decoder", "1.2.0"},
		{"stringify-object", "3.3.0"},
		{"stringify-package", "1.0.0"},
		{"strip-ansi", "0.1.1"},
		{"strip-ansi", "3.0.1"},
		{"strip-ansi", "4.0.0"},
		{"strip-ansi", "5.2.0"},
		{"strip-bom", "2.0.0"},
		{"strip-bom", "3.0.0"},
		{"strip-eof", "1.0.0"},
		{"strip-json-comments", "2.0.1"},
		{"style-loader", "0.23.1"},
		{"styled-components", "4.1.3"},
		{"stylis", "3.5.4"},
		{"stylis-rule-sheet", "0.0.10"},
		{"supports-color", "2.0.0"},
		{"supports-color", "3.2.3"},
		{"supports-color", "5.5.0"},
		{"supports-color", "6.1.0"},
		{"svg-url-loader", "2.3.2"},
		{"svgo", "1.2.2"},
		{"symbol-observable", "1.2.0"},
		{"symbol-tree", "3.2.2"},
		{"symbol.prototype.description", "1.0.0"},
		{"table", "4.0.3"},
		{"table", "5.3.3"},
		{"tapable", "1.1.3"},
		{"tar", "2.2.2"},
		{"tar", "4.4.8"},
		{"temp", "0.8.3"},
		{"term-size", "1.2.0"},
		{"terser", "3.17.0"},
		{"terser-webpack-plugin", "1.2.4"},
		{"test-exclude", "4.2.3"},
		{"text-table", "0.2.0"},
		{"throat", "4.1.0"},
		{"through", "2.3.8"},
		{"through2", "2.0.5"},
		{"thunky", "1.0.3"},
		{"timed-out", "4.0.1"},
		{"timers-browserify", "2.0.10"},
		{"tiny-invariant", "1.0.4"},
		{"tiny-relative-date", "1.3.0"},
		{"tiny-warning", "1.0.2"},
		{"tinycolor2", "1.4.1"},
		{"tmp", "0.0.33"},
		{"tmpl", "1.0.4"},
		{"to-array", "0.1.4"},
		{"to-arraybuffer", "1.0.1"},
		{"to-fast-properties", "1.0.3"},
		{"to-fast-properties", "2.0.0"},
		{"to-object-path", "0.3.0"},
		{"to-regex", "3.0.2"},
		{"to-regex-range", "2.1.1"},
		{"toggle-selection", "1.0.6"},
		{"toposort", "1.0.7"},
		{"tough-cookie", "2.4.3"},
		{"tough-cookie", "2.5.0"},
		{"tr46", "1.0.1"},
		{"traverse", "0.3.9"},
		{"trim-right", "1.0.1"},
		{"trough", "1.0.4"},
		{"tryer", "1.0.1"},
		{"tslib", "1.9.3"},
		{"tty-browserify", "0.0.0"},
		{"tunnel-agent", "0.6.0"},
		{"tweetnacl", "0.14.5"},
		{"type-check", "0.3.2"},
		{"type-is", "1.6.18"},
		{"typed-styles", "0.0.7"},
		{"typedarray", "0.0.6"},
		{"ua-parser-js", "0.7.19"},
		{"uglify-js", "3.4.10"},
		{"uglify-js", "3.5.12"},
		{"uid-number", "0.0.6"},
		{"umask", "1.1.0"},
		{"underscore", "1.6.0"},
		{"unicode-canonical-property-names-ecmascript", "1.0.4"},
		{"unicode-match-property-ecmascript", "1.0.4"},
		{"unicode-match-property-value-ecmascript", "1.1.0"},
		{"unicode-property-aliases-ecmascript", "1.0.5"},
		{"unified", "7.1.0"},
		{"union-value", "1.0.0"},
		{"unique-filename", "1.1.1"},
		{"unique-slug", "2.0.1"},
		{"unique-string", "1.0.0"},
		{"unist-util-stringify-position", "1.1.2"},
		{"unist-util-stringify-position", "2.0.0"},
		{"universal-user-agent", "2.1.0"},
		{"universalify", "0.1.2"},
		{"unpipe", "1.0.0"},
		{"unquote", "1.1.1"},
		{"unset-value", "1.0.0"},
		{"unzip-response", "2.0.1"},
		{"unzipper", "0.8.14"},
		{"upath", "1.1.2"},
		{"update-notifier", "2.5.0"},
		{"upper-case", "1.1.3"},
		{"uri-js", "4.2.2"},
		{"urix", "0.1.0"},
		{"url", "0.11.0"},
		{"url-loader", "1.1.2"},
		{"url-parse", "1.4.7"},
		{"url-parse-lax", "1.0.0"},
		{"url-template", "2.0.8"},
		{"url-to-options", "1.0.1"},
		{"use", "3.1.1"},
		{"user-home", "1.1.1"},
		{"util", "0.10.3"},
		{"util", "0.10.4"},
		{"util", "0.11.1"},
		{"util-deprecate", "1.0.2"},
		{"util-extend", "1.0.3"},
		{"util.promisify", "1.0.0"},
		{"utila", "0.4.0"},
		{"utils-merge", "1.0.1"},
		{"uuid", "3.3.2"},
		{"v8-compile-cache", "2.0.3"},
		{"v8flags", "2.1.1"},
		{"validate-npm-package-license", "3.0.4"},
		{"validate-npm-package-name", "3.0.0"},
		{"value-equal", "0.4.0"},
		{"vary", "1.1.2"},
		{"velocity-animate", "1.5.2"},
		{"velocity-react", "1.4.3"},
		{"verror", "1.10.0"},
		{"vfile", "3.0.1"},
		{"vfile", "4.0.0"},
		{"vfile-message", "1.1.1"},
		{"vfile-message", "2.0.0"},
		{"vm-browserify", "0.0.4"},
		{"w3c-hr-time", "1.0.1"},
		{"walker", "1.0.7"},
		{"warning", "3.0.0"},
		{"warning", "4.0.3"},
		{"watch", "0.18.0"},
		{"watchpack", "1.6.0"},
		{"wbuf", "1.7.3"},
		{"wcwidth", "1.0.1"},
		{"web-namespaces", "1.1.3"},
		{"webidl-conversions", "4.0.2"},
		{"webpack", "4.31.0"},
		{"webpack-bundle-analyzer", "3.3.2"},
		{"webpack-cli", "3.3.2"},
		{"webpack-dev-middleware", "3.7.0"},
		{"webpack-dev-server", "3.3.1"},
		{"webpack-hot-middleware", "2.25.0"},
		{"webpack-log", "2.0.0"},
		{"webpack-merge", "4.2.1"},
		{"webpack-sources", "1.3.0"},
		{"websocket-driver", "0.7.0"},
		{"websocket-extensions", "0.1.3"},
		{"whatwg-encoding", "1.0.5"},
		{"whatwg-fetch", "3.0.0"},
		{"whatwg-mimetype", "2.3.0"},
		{"whatwg-url", "6.5.0"},
		{"whatwg-url", "7.0.0"},
		{"which", "1.3.1"},
		{"which-module", "1.0.0"},
		{"which-module", "2.0.0"},
		{"wide-align", "1.1.3"},
		{"widest-line", "2.0.1"},
		{"window-size", "0.2.0"},
		{"windows-release", "3.2.0"},
		{"wordwrap", "0.0.3"},
		{"wordwrap", "1.0.0"},
		{"worker-farm", "1.7.0"},
		{"wrap-ansi", "2.1.0"},
		{"wrap-ansi", "3.0.1"},
		{"wrappy", "1.0.2"},
		{"write", "1.0.3"},
		{"write-file-atomic", "1.3.4"},
		{"write-file-atomic", "2.4.2"},
		{"write-json-file", "2.3.0"},
		{"ws", "5.2.2"},
		{"ws", "6.1.4"},
		{"ws", "6.2.1"},
		{"x-is-string", "0.1.0"},
		{"xdg-basedir", "3.0.0"},
		{"xml-name-validator", "3.0.0"},
		{"xmlhttprequest-ssl", "1.5.5"},
		{"xtend", "4.0.1"},
		{"y18n", "3.2.1"},
		{"y18n", "4.0.0"},
		{"yallist", "2.1.2"},
		{"yallist", "3.0.3"},
		{"yargs", "11.1.0"},
		{"yargs", "12.0.5"},
		{"yargs", "4.8.1"},
		{"yargs-parser", "11.1.1"},
		{"yargs-parser", "2.4.1"},
		{"yargs-parser", "9.0.2"},
		{"yeast", "0.1.2"},
	}
)
