/*
 * CLOUD API
 *
 * IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"encoding/json"
)

// S3KeyProperties struct for S3KeyProperties
type S3KeyProperties struct {
	// Denotes weather the S3 key is active.
	Active *bool `json:"active,omitempty"`
	// Secret of the S3 key.
	SecretKey *string `json:"secretKey,omitempty"`
}

// NewS3KeyProperties instantiates a new S3KeyProperties object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewS3KeyProperties() *S3KeyProperties {
	this := S3KeyProperties{}

	return &this
}

// NewS3KeyPropertiesWithDefaults instantiates a new S3KeyProperties object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewS3KeyPropertiesWithDefaults() *S3KeyProperties {
	this := S3KeyProperties{}
	return &this
}

// GetActive returns the Active field value
// If the value is explicit nil, nil is returned
func (o *S3KeyProperties) GetActive() *bool {
	if o == nil {
		return nil
	}

	return o.Active

}

// GetActiveOk returns a tuple with the Active field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *S3KeyProperties) GetActiveOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}

	return o.Active, true
}

// SetActive sets field value
func (o *S3KeyProperties) SetActive(v bool) {

	o.Active = &v

}

// HasActive returns a boolean if a field has been set.
func (o *S3KeyProperties) HasActive() bool {
	if o != nil && o.Active != nil {
		return true
	}

	return false
}

// GetSecretKey returns the SecretKey field value
// If the value is explicit nil, nil is returned
func (o *S3KeyProperties) GetSecretKey() *string {
	if o == nil {
		return nil
	}

	return o.SecretKey

}

// GetSecretKeyOk returns a tuple with the SecretKey field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *S3KeyProperties) GetSecretKeyOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.SecretKey, true
}

// SetSecretKey sets field value
func (o *S3KeyProperties) SetSecretKey(v string) {

	o.SecretKey = &v

}

// HasSecretKey returns a boolean if a field has been set.
func (o *S3KeyProperties) HasSecretKey() bool {
	if o != nil && o.SecretKey != nil {
		return true
	}

	return false
}

func (o S3KeyProperties) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Active != nil {
		toSerialize["active"] = o.Active
	}

	if o.SecretKey != nil {
		toSerialize["secretKey"] = o.SecretKey
	}

	return json.Marshal(toSerialize)
}

type NullableS3KeyProperties struct {
	value *S3KeyProperties
	isSet bool
}

func (v NullableS3KeyProperties) Get() *S3KeyProperties {
	return v.value
}

func (v *NullableS3KeyProperties) Set(val *S3KeyProperties) {
	v.value = val
	v.isSet = true
}

func (v NullableS3KeyProperties) IsSet() bool {
	return v.isSet
}

func (v *NullableS3KeyProperties) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableS3KeyProperties(val *S3KeyProperties) *NullableS3KeyProperties {
	return &NullableS3KeyProperties{value: val, isSet: true}
}

func (v NullableS3KeyProperties) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableS3KeyProperties) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
