// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.1
// 	protoc        v3.21.12
// source: tdx.proto

// Package tdx represents a TDX attestation quote.

package tdx

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type QuoteV4 struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Header of quote structure
	Header *Header `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"` // should be 48 bytes
	// TD report by which quote is generated
	TdQuoteBody *TDQuoteBody `protobuf:"bytes,2,opt,name=td_quote_body,json=tdQuoteBody,proto3" json:"td_quote_body,omitempty"` // should be 584 bytes
	// Size of the Quote Signature Data structure
	SignedDataSize uint32 `protobuf:"varint,3,opt,name=signed_data_size,json=signedDataSize,proto3" json:"signed_data_size,omitempty"`
	// Quote Signature Data structure.
	SignedData *Ecdsa256BitQuoteV4AuthData `protobuf:"bytes,4,opt,name=signed_data,json=signedData,proto3" json:"signed_data,omitempty"` // The size should be same as signed_data_size
	// Extra bytes included to fill the quote buffer
	ExtraBytes []byte `protobuf:"bytes,5,opt,name=extra_bytes,json=extraBytes,proto3" json:"extra_bytes,omitempty"` // These trailing bytes can be ignored
}

func (x *QuoteV4) Reset() {
	*x = QuoteV4{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tdx_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QuoteV4) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuoteV4) ProtoMessage() {}

func (x *QuoteV4) ProtoReflect() protoreflect.Message {
	mi := &file_tdx_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuoteV4.ProtoReflect.Descriptor instead.
func (*QuoteV4) Descriptor() ([]byte, []int) {
	return file_tdx_proto_rawDescGZIP(), []int{0}
}

func (x *QuoteV4) GetHeader() *Header {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *QuoteV4) GetTdQuoteBody() *TDQuoteBody {
	if x != nil {
		return x.TdQuoteBody
	}
	return nil
}

func (x *QuoteV4) GetSignedDataSize() uint32 {
	if x != nil {
		return x.SignedDataSize
	}
	return 0
}

func (x *QuoteV4) GetSignedData() *Ecdsa256BitQuoteV4AuthData {
	if x != nil {
		return x.SignedData
	}
	return nil
}

func (x *QuoteV4) GetExtraBytes() []byte {
	if x != nil {
		return x.ExtraBytes
	}
	return nil
}

type Header struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Version 4 supported
	Version uint32 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// Type of attestation key used by quoting enclave
	// Values :
	// 2 (ECDSA-256-with-P-256 curve)
	// 3 (ECDSA-384-with-P-384 curve) (Currently not supported)
	AttestationKeyType uint32 `protobuf:"varint,2,opt,name=attestation_key_type,json=attestationKeyType,proto3" json:"attestation_key_type,omitempty"`
	// TEE for this attestation
	// TDX : 0x00000081
	TeeType uint32 `protobuf:"varint,3,opt,name=tee_type,json=teeType,proto3" json:"tee_type,omitempty"`
	QeSvn   []byte `protobuf:"bytes,4,opt,name=qe_svn,json=qeSvn,proto3" json:"qe_svn,omitempty"`    // should be 2 bytes
	PceSvn  []byte `protobuf:"bytes,5,opt,name=pce_svn,json=pceSvn,proto3" json:"pce_svn,omitempty"` // should be 2 bytes
	// Unique vendor id of QE vendor
	QeVendorId []byte `protobuf:"bytes,6,opt,name=qe_vendor_id,json=qeVendorId,proto3" json:"qe_vendor_id,omitempty"` // should be 16 bytes
	// Custom user defined data
	UserData []byte `protobuf:"bytes,7,opt,name=user_data,json=userData,proto3" json:"user_data,omitempty"` // should be 20 bytes
}

func (x *Header) Reset() {
	*x = Header{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tdx_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Header) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Header) ProtoMessage() {}

func (x *Header) ProtoReflect() protoreflect.Message {
	mi := &file_tdx_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Header.ProtoReflect.Descriptor instead.
func (*Header) Descriptor() ([]byte, []int) {
	return file_tdx_proto_rawDescGZIP(), []int{1}
}

func (x *Header) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *Header) GetAttestationKeyType() uint32 {
	if x != nil {
		return x.AttestationKeyType
	}
	return 0
}

func (x *Header) GetTeeType() uint32 {
	if x != nil {
		return x.TeeType
	}
	return 0
}

func (x *Header) GetQeSvn() []byte {
	if x != nil {
		return x.QeSvn
	}
	return nil
}

func (x *Header) GetPceSvn() []byte {
	if x != nil {
		return x.PceSvn
	}
	return nil
}

func (x *Header) GetQeVendorId() []byte {
	if x != nil {
		return x.QeVendorId
	}
	return nil
}

func (x *Header) GetUserData() []byte {
	if x != nil {
		return x.UserData
	}
	return nil
}

type TDQuoteBody struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TeeTcbSvn      []byte   `protobuf:"bytes,1,opt,name=tee_tcb_svn,json=teeTcbSvn,proto3" json:"tee_tcb_svn,omitempty"`              // should be 16 bytes
	MrSeam         []byte   `protobuf:"bytes,2,opt,name=mr_seam,json=mrSeam,proto3" json:"mr_seam,omitempty"`                         // should be 48 bytes
	MrSignerSeam   []byte   `protobuf:"bytes,3,opt,name=mr_signer_seam,json=mrSignerSeam,proto3" json:"mr_signer_seam,omitempty"`     // should be 48 bytes
	SeamAttributes []byte   `protobuf:"bytes,4,opt,name=seam_attributes,json=seamAttributes,proto3" json:"seam_attributes,omitempty"` // should be 8 bytes
	TdAttributes   []byte   `protobuf:"bytes,5,opt,name=td_attributes,json=tdAttributes,proto3" json:"td_attributes,omitempty"`       // should be 8 bytes
	Xfam           []byte   `protobuf:"bytes,6,opt,name=xfam,proto3" json:"xfam,omitempty"`                                           // should be 8 bytes
	MrTd           []byte   `protobuf:"bytes,7,opt,name=mr_td,json=mrTd,proto3" json:"mr_td,omitempty"`                               // should be 48 bytes
	MrConfigId     []byte   `protobuf:"bytes,8,opt,name=mr_config_id,json=mrConfigId,proto3" json:"mr_config_id,omitempty"`           // should be 48 bytes
	MrOwner        []byte   `protobuf:"bytes,9,opt,name=mr_owner,json=mrOwner,proto3" json:"mr_owner,omitempty"`                      // should be 48 bytes
	MrOwnerConfig  []byte   `protobuf:"bytes,10,opt,name=mr_owner_config,json=mrOwnerConfig,proto3" json:"mr_owner_config,omitempty"` // should be 48 bytes
	Rtmrs          [][]byte `protobuf:"bytes,11,rep,name=rtmrs,proto3" json:"rtmrs,omitempty"`                                        // should be 48 * rtmrsCount
	ReportData     []byte   `protobuf:"bytes,12,opt,name=report_data,json=reportData,proto3" json:"report_data,omitempty"`            // should be 64 bytes
}

func (x *TDQuoteBody) Reset() {
	*x = TDQuoteBody{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tdx_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TDQuoteBody) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TDQuoteBody) ProtoMessage() {}

func (x *TDQuoteBody) ProtoReflect() protoreflect.Message {
	mi := &file_tdx_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TDQuoteBody.ProtoReflect.Descriptor instead.
func (*TDQuoteBody) Descriptor() ([]byte, []int) {
	return file_tdx_proto_rawDescGZIP(), []int{2}
}

func (x *TDQuoteBody) GetTeeTcbSvn() []byte {
	if x != nil {
		return x.TeeTcbSvn
	}
	return nil
}

func (x *TDQuoteBody) GetMrSeam() []byte {
	if x != nil {
		return x.MrSeam
	}
	return nil
}

func (x *TDQuoteBody) GetMrSignerSeam() []byte {
	if x != nil {
		return x.MrSignerSeam
	}
	return nil
}

func (x *TDQuoteBody) GetSeamAttributes() []byte {
	if x != nil {
		return x.SeamAttributes
	}
	return nil
}

func (x *TDQuoteBody) GetTdAttributes() []byte {
	if x != nil {
		return x.TdAttributes
	}
	return nil
}

func (x *TDQuoteBody) GetXfam() []byte {
	if x != nil {
		return x.Xfam
	}
	return nil
}

func (x *TDQuoteBody) GetMrTd() []byte {
	if x != nil {
		return x.MrTd
	}
	return nil
}

func (x *TDQuoteBody) GetMrConfigId() []byte {
	if x != nil {
		return x.MrConfigId
	}
	return nil
}

func (x *TDQuoteBody) GetMrOwner() []byte {
	if x != nil {
		return x.MrOwner
	}
	return nil
}

func (x *TDQuoteBody) GetMrOwnerConfig() []byte {
	if x != nil {
		return x.MrOwnerConfig
	}
	return nil
}

func (x *TDQuoteBody) GetRtmrs() [][]byte {
	if x != nil {
		return x.Rtmrs
	}
	return nil
}

func (x *TDQuoteBody) GetReportData() []byte {
	if x != nil {
		return x.ReportData
	}
	return nil
}

type Ecdsa256BitQuoteV4AuthData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ECDSA 256-bit signature.
	Signature []byte `protobuf:"bytes,1,opt,name=signature,proto3" json:"signature,omitempty"` // should be 64 bytes
	// The ECDSA 256-bit public key of the attestation key.
	EcdsaAttestationKey []byte `protobuf:"bytes,2,opt,name=ecdsa_attestation_key,json=ecdsaAttestationKey,proto3" json:"ecdsa_attestation_key,omitempty"` // should be 64 bytes
	// The certification data.
	CertificationData *CertificationData `protobuf:"bytes,3,opt,name=certification_data,json=certificationData,proto3" json:"certification_data,omitempty"`
}

func (x *Ecdsa256BitQuoteV4AuthData) Reset() {
	*x = Ecdsa256BitQuoteV4AuthData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tdx_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Ecdsa256BitQuoteV4AuthData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Ecdsa256BitQuoteV4AuthData) ProtoMessage() {}

func (x *Ecdsa256BitQuoteV4AuthData) ProtoReflect() protoreflect.Message {
	mi := &file_tdx_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Ecdsa256BitQuoteV4AuthData.ProtoReflect.Descriptor instead.
func (*Ecdsa256BitQuoteV4AuthData) Descriptor() ([]byte, []int) {
	return file_tdx_proto_rawDescGZIP(), []int{3}
}

func (x *Ecdsa256BitQuoteV4AuthData) GetSignature() []byte {
	if x != nil {
		return x.Signature
	}
	return nil
}

func (x *Ecdsa256BitQuoteV4AuthData) GetEcdsaAttestationKey() []byte {
	if x != nil {
		return x.EcdsaAttestationKey
	}
	return nil
}

func (x *Ecdsa256BitQuoteV4AuthData) GetCertificationData() *CertificationData {
	if x != nil {
		return x.CertificationData
	}
	return nil
}

type CertificationData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	//	Supported values:
	//
	// - 1 (PCK identifier: PPID in plain text,  CPUSVN and PCESVN)
	// - 2 (PCK identifier: PPID encrypted using RSA-2048-OAEP, CPUSVN and PCESVN)
	// - 3 (PCK identifier: PPID encrypted using RSA-3072-OAEP, CPUSVN and PCESVN)
	// - 4 (PCK Leaf Certificate in plain text,  currently not supported)
	// - 5 (Concatenated PCK Cert Chain)
	// - 6 (QE Report Certification Data)
	// - 7 (PLATFORM_MANIFEST, currently  not supported)
	CertificateDataType uint32 `protobuf:"varint,1,opt,name=certificate_data_type,json=certificateDataType,proto3" json:"certificate_data_type,omitempty"`
	// Size of Certification Data field
	Size                      uint32                     `protobuf:"varint,2,opt,name=size,proto3" json:"size,omitempty"`
	QeReportCertificationData *QEReportCertificationData `protobuf:"bytes,3,opt,name=qe_report_certification_data,json=qeReportCertificationData,proto3" json:"qe_report_certification_data,omitempty"`
}

func (x *CertificationData) Reset() {
	*x = CertificationData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tdx_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificationData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificationData) ProtoMessage() {}

func (x *CertificationData) ProtoReflect() protoreflect.Message {
	mi := &file_tdx_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificationData.ProtoReflect.Descriptor instead.
func (*CertificationData) Descriptor() ([]byte, []int) {
	return file_tdx_proto_rawDescGZIP(), []int{4}
}

func (x *CertificationData) GetCertificateDataType() uint32 {
	if x != nil {
		return x.CertificateDataType
	}
	return 0
}

func (x *CertificationData) GetSize() uint32 {
	if x != nil {
		return x.Size
	}
	return 0
}

func (x *CertificationData) GetQeReportCertificationData() *QEReportCertificationData {
	if x != nil {
		return x.QeReportCertificationData
	}
	return nil
}

type QEReportCertificationData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	QeReport                *EnclaveReport           `protobuf:"bytes,1,opt,name=qe_report,json=qeReport,proto3" json:"qe_report,omitempty"`
	QeReportSignature       []byte                   `protobuf:"bytes,2,opt,name=qe_report_signature,json=qeReportSignature,proto3" json:"qe_report_signature,omitempty"` // should be 64 bytes
	QeAuthData              *QeAuthData              `protobuf:"bytes,3,opt,name=qe_auth_data,json=qeAuthData,proto3" json:"qe_auth_data,omitempty"`
	PckCertificateChainData *PCKCertificateChainData `protobuf:"bytes,4,opt,name=pck_certificate_chain_data,json=pckCertificateChainData,proto3" json:"pck_certificate_chain_data,omitempty"`
}

func (x *QEReportCertificationData) Reset() {
	*x = QEReportCertificationData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tdx_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QEReportCertificationData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QEReportCertificationData) ProtoMessage() {}

func (x *QEReportCertificationData) ProtoReflect() protoreflect.Message {
	mi := &file_tdx_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QEReportCertificationData.ProtoReflect.Descriptor instead.
func (*QEReportCertificationData) Descriptor() ([]byte, []int) {
	return file_tdx_proto_rawDescGZIP(), []int{5}
}

func (x *QEReportCertificationData) GetQeReport() *EnclaveReport {
	if x != nil {
		return x.QeReport
	}
	return nil
}

func (x *QEReportCertificationData) GetQeReportSignature() []byte {
	if x != nil {
		return x.QeReportSignature
	}
	return nil
}

func (x *QEReportCertificationData) GetQeAuthData() *QeAuthData {
	if x != nil {
		return x.QeAuthData
	}
	return nil
}

func (x *QEReportCertificationData) GetPckCertificateChainData() *PCKCertificateChainData {
	if x != nil {
		return x.PckCertificateChainData
	}
	return nil
}

type PCKCertificateChainData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	//	Supported values:
	//
	// - 1 (PCK identifier: PPID in plain text,  CPUSVN and PCESVN)
	// - 2 (PCK identifier: PPID encrypted using RSA-2048-OAEP, CPUSVN and PCESVN)
	// - 3 (PCK identifier: PPID encrypted using RSA-3072-OAEP, CPUSVN and PCESVN)
	// - 4 (PCK Leaf Certificate in plain text,  currently not supported)
	// - 5 (Concatenated PCK Cert Chain)
	// - 6 (QE Report Certification Data)
	// - 7 (PLATFORM_MANIFEST, currently  not supported)
	CertificateDataType uint32 `protobuf:"varint,1,opt,name=certificate_data_type,json=certificateDataType,proto3" json:"certificate_data_type,omitempty"`
	// Size of Certification Data field
	Size         uint32 `protobuf:"varint,2,opt,name=size,proto3" json:"size,omitempty"`
	PckCertChain []byte `protobuf:"bytes,3,opt,name=pck_cert_chain,json=pckCertChain,proto3" json:"pck_cert_chain,omitempty"`
}

func (x *PCKCertificateChainData) Reset() {
	*x = PCKCertificateChainData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tdx_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PCKCertificateChainData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PCKCertificateChainData) ProtoMessage() {}

func (x *PCKCertificateChainData) ProtoReflect() protoreflect.Message {
	mi := &file_tdx_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PCKCertificateChainData.ProtoReflect.Descriptor instead.
func (*PCKCertificateChainData) Descriptor() ([]byte, []int) {
	return file_tdx_proto_rawDescGZIP(), []int{6}
}

func (x *PCKCertificateChainData) GetCertificateDataType() uint32 {
	if x != nil {
		return x.CertificateDataType
	}
	return 0
}

func (x *PCKCertificateChainData) GetSize() uint32 {
	if x != nil {
		return x.Size
	}
	return 0
}

func (x *PCKCertificateChainData) GetPckCertChain() []byte {
	if x != nil {
		return x.PckCertChain
	}
	return nil
}

type QeAuthData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The parsed data size.
	ParsedDataSize uint32 `protobuf:"varint,1,opt,name=parsed_data_size,json=parsedDataSize,proto3" json:"parsed_data_size,omitempty"` // should be 2 bytes
	// The data.
	Data []byte `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
}

func (x *QeAuthData) Reset() {
	*x = QeAuthData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tdx_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QeAuthData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QeAuthData) ProtoMessage() {}

func (x *QeAuthData) ProtoReflect() protoreflect.Message {
	mi := &file_tdx_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QeAuthData.ProtoReflect.Descriptor instead.
func (*QeAuthData) Descriptor() ([]byte, []int) {
	return file_tdx_proto_rawDescGZIP(), []int{7}
}

func (x *QeAuthData) GetParsedDataSize() uint32 {
	if x != nil {
		return x.ParsedDataSize
	}
	return 0
}

func (x *QeAuthData) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

type EnclaveReport struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	CpuSvn     []byte `protobuf:"bytes,1,opt,name=cpu_svn,json=cpuSvn,proto3" json:"cpu_svn,omitempty"`              // should be 16 bytes
	MiscSelect uint32 `protobuf:"varint,2,opt,name=misc_select,json=miscSelect,proto3" json:"misc_select,omitempty"` // should be 4 bytes
	Reserved1  []byte `protobuf:"bytes,3,opt,name=reserved1,proto3" json:"reserved1,omitempty"`                      // should be 28 bytes
	Attributes []byte `protobuf:"bytes,4,opt,name=attributes,proto3" json:"attributes,omitempty"`                    // should be 16 bytes
	MrEnclave  []byte `protobuf:"bytes,5,opt,name=mr_enclave,json=mrEnclave,proto3" json:"mr_enclave,omitempty"`     // should be 32 bytes
	Reserved2  []byte `protobuf:"bytes,6,opt,name=reserved2,proto3" json:"reserved2,omitempty"`                      // should be 32 bytes
	MrSigner   []byte `protobuf:"bytes,7,opt,name=mr_signer,json=mrSigner,proto3" json:"mr_signer,omitempty"`        // should be 32 bytes
	Reserved3  []byte `protobuf:"bytes,8,opt,name=reserved3,proto3" json:"reserved3,omitempty"`                      // should be 96 bytes
	IsvProdId  uint32 `protobuf:"varint,9,opt,name=isv_prod_id,json=isvProdId,proto3" json:"isv_prod_id,omitempty"`  // should be 2 bytes
	IsvSvn     uint32 `protobuf:"varint,10,opt,name=isv_svn,json=isvSvn,proto3" json:"isv_svn,omitempty"`            // should be 2 bytes
	Reserved4  []byte `protobuf:"bytes,11,opt,name=reserved4,proto3" json:"reserved4,omitempty"`                     // should be 60 bytes
	ReportData []byte `protobuf:"bytes,12,opt,name=report_data,json=reportData,proto3" json:"report_data,omitempty"` // should be 64 bytes
}

func (x *EnclaveReport) Reset() {
	*x = EnclaveReport{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tdx_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnclaveReport) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnclaveReport) ProtoMessage() {}

func (x *EnclaveReport) ProtoReflect() protoreflect.Message {
	mi := &file_tdx_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnclaveReport.ProtoReflect.Descriptor instead.
func (*EnclaveReport) Descriptor() ([]byte, []int) {
	return file_tdx_proto_rawDescGZIP(), []int{8}
}

func (x *EnclaveReport) GetCpuSvn() []byte {
	if x != nil {
		return x.CpuSvn
	}
	return nil
}

func (x *EnclaveReport) GetMiscSelect() uint32 {
	if x != nil {
		return x.MiscSelect
	}
	return 0
}

func (x *EnclaveReport) GetReserved1() []byte {
	if x != nil {
		return x.Reserved1
	}
	return nil
}

func (x *EnclaveReport) GetAttributes() []byte {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *EnclaveReport) GetMrEnclave() []byte {
	if x != nil {
		return x.MrEnclave
	}
	return nil
}

func (x *EnclaveReport) GetReserved2() []byte {
	if x != nil {
		return x.Reserved2
	}
	return nil
}

func (x *EnclaveReport) GetMrSigner() []byte {
	if x != nil {
		return x.MrSigner
	}
	return nil
}

func (x *EnclaveReport) GetReserved3() []byte {
	if x != nil {
		return x.Reserved3
	}
	return nil
}

func (x *EnclaveReport) GetIsvProdId() uint32 {
	if x != nil {
		return x.IsvProdId
	}
	return 0
}

func (x *EnclaveReport) GetIsvSvn() uint32 {
	if x != nil {
		return x.IsvSvn
	}
	return 0
}

func (x *EnclaveReport) GetReserved4() []byte {
	if x != nil {
		return x.Reserved4
	}
	return nil
}

func (x *EnclaveReport) GetReportData() []byte {
	if x != nil {
		return x.ReportData
	}
	return nil
}

var File_tdx_proto protoreflect.FileDescriptor

var file_tdx_proto_rawDesc = []byte{
	0x0a, 0x09, 0x74, 0x64, 0x78, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x03, 0x74, 0x64, 0x78,
	0x22, 0xf1, 0x01, 0x0a, 0x07, 0x51, 0x75, 0x6f, 0x74, 0x65, 0x56, 0x34, 0x12, 0x23, 0x0a, 0x06,
	0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0b, 0x2e, 0x74,
	0x64, 0x78, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x12, 0x34, 0x0a, 0x0d, 0x74, 0x64, 0x5f, 0x71, 0x75, 0x6f, 0x74, 0x65, 0x5f, 0x62, 0x6f,
	0x64, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x74, 0x64, 0x78, 0x2e, 0x54,
	0x44, 0x51, 0x75, 0x6f, 0x74, 0x65, 0x42, 0x6f, 0x64, 0x79, 0x52, 0x0b, 0x74, 0x64, 0x51, 0x75,
	0x6f, 0x74, 0x65, 0x42, 0x6f, 0x64, 0x79, 0x12, 0x28, 0x0a, 0x10, 0x73, 0x69, 0x67, 0x6e, 0x65,
	0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x0e, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x74, 0x64, 0x78, 0x2e, 0x45, 0x63, 0x64,
	0x73, 0x61, 0x32, 0x35, 0x36, 0x42, 0x69, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x65, 0x56, 0x34, 0x41,
	0x75, 0x74, 0x68, 0x44, 0x61, 0x74, 0x61, 0x52, 0x0a, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x44,
	0x61, 0x74, 0x61, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x78, 0x74, 0x72, 0x61, 0x5f, 0x62, 0x79, 0x74,
	0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x65, 0x78, 0x74, 0x72, 0x61, 0x42,
	0x79, 0x74, 0x65, 0x73, 0x22, 0xde, 0x01, 0x0a, 0x06, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12,
	0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x0a, 0x14, 0x61, 0x74, 0x74,
	0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x12, 0x61, 0x74, 0x74, 0x65, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x74,
	0x65, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x74,
	0x65, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x15, 0x0a, 0x06, 0x71, 0x65, 0x5f, 0x73, 0x76, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x71, 0x65, 0x53, 0x76, 0x6e, 0x12, 0x17, 0x0a,
	0x07, 0x70, 0x63, 0x65, 0x5f, 0x73, 0x76, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06,
	0x70, 0x63, 0x65, 0x53, 0x76, 0x6e, 0x12, 0x20, 0x0a, 0x0c, 0x71, 0x65, 0x5f, 0x76, 0x65, 0x6e,
	0x64, 0x6f, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x71, 0x65,
	0x56, 0x65, 0x6e, 0x64, 0x6f, 0x72, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x75, 0x73, 0x65, 0x72,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x75, 0x73, 0x65,
	0x72, 0x44, 0x61, 0x74, 0x61, 0x22, 0xff, 0x02, 0x0a, 0x0b, 0x54, 0x44, 0x51, 0x75, 0x6f, 0x74,
	0x65, 0x42, 0x6f, 0x64, 0x79, 0x12, 0x1e, 0x0a, 0x0b, 0x74, 0x65, 0x65, 0x5f, 0x74, 0x63, 0x62,
	0x5f, 0x73, 0x76, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x74, 0x65, 0x65, 0x54,
	0x63, 0x62, 0x53, 0x76, 0x6e, 0x12, 0x17, 0x0a, 0x07, 0x6d, 0x72, 0x5f, 0x73, 0x65, 0x61, 0x6d,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x6d, 0x72, 0x53, 0x65, 0x61, 0x6d, 0x12, 0x24,
	0x0a, 0x0e, 0x6d, 0x72, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x61, 0x6d,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0c, 0x6d, 0x72, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x72,
	0x53, 0x65, 0x61, 0x6d, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x65, 0x61, 0x6d, 0x5f, 0x61, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0e, 0x73,
	0x65, 0x61, 0x6d, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x23, 0x0a,
	0x0d, 0x74, 0x64, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x0c, 0x74, 0x64, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x78, 0x66, 0x61, 0x6d, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x04, 0x78, 0x66, 0x61, 0x6d, 0x12, 0x13, 0x0a, 0x05, 0x6d, 0x72, 0x5f, 0x74, 0x64, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x6d, 0x72, 0x54, 0x64, 0x12, 0x20, 0x0a, 0x0c, 0x6d,
	0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x0a, 0x6d, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x64, 0x12, 0x19, 0x0a,
	0x08, 0x6d, 0x72, 0x5f, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x07, 0x6d, 0x72, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x12, 0x26, 0x0a, 0x0f, 0x6d, 0x72, 0x5f, 0x6f,
	0x77, 0x6e, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x0d, 0x6d, 0x72, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x14, 0x0a, 0x05, 0x72, 0x74, 0x6d, 0x72, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0c, 0x52,
	0x05, 0x72, 0x74, 0x6d, 0x72, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x72, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x22, 0xb5, 0x01, 0x0a, 0x1a, 0x45, 0x63, 0x64, 0x73,
	0x61, 0x32, 0x35, 0x36, 0x42, 0x69, 0x74, 0x51, 0x75, 0x6f, 0x74, 0x65, 0x56, 0x34, 0x41, 0x75,
	0x74, 0x68, 0x44, 0x61, 0x74, 0x61, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x73, 0x69, 0x67, 0x6e, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x12, 0x32, 0x0a, 0x15, 0x65, 0x63, 0x64, 0x73, 0x61, 0x5f, 0x61, 0x74,
	0x74, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x13, 0x65, 0x63, 0x64, 0x73, 0x61, 0x41, 0x74, 0x74, 0x65, 0x73, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x45, 0x0a, 0x12, 0x63, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x74, 0x64, 0x78, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x52, 0x11, 0x63, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x22,
	0xbc, 0x01, 0x0a, 0x11, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x44, 0x61, 0x74, 0x61, 0x12, 0x32, 0x0a, 0x15, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x13, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x44, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x12, 0x5f, 0x0a,
	0x1c, 0x71, 0x65, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x74, 0x64, 0x78, 0x2e, 0x51, 0x45, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44,
	0x61, 0x74, 0x61, 0x52, 0x19, 0x71, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x22, 0x8a,
	0x02, 0x0a, 0x19, 0x51, 0x45, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x12, 0x2f, 0x0a, 0x09,
	0x71, 0x65, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x12, 0x2e, 0x74, 0x64, 0x78, 0x2e, 0x45, 0x6e, 0x63, 0x6c, 0x61, 0x76, 0x65, 0x52, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x52, 0x08, 0x71, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x2e, 0x0a,
	0x13, 0x71, 0x65, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x11, 0x71, 0x65, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x31, 0x0a,
	0x0c, 0x71, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x74, 0x64, 0x78, 0x2e, 0x51, 0x65, 0x41, 0x75, 0x74, 0x68,
	0x44, 0x61, 0x74, 0x61, 0x52, 0x0a, 0x71, 0x65, 0x41, 0x75, 0x74, 0x68, 0x44, 0x61, 0x74, 0x61,
	0x12, 0x59, 0x0a, 0x1a, 0x70, 0x63, 0x6b, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x74, 0x64, 0x78, 0x2e, 0x50, 0x43, 0x4b, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x44, 0x61,
	0x74, 0x61, 0x52, 0x17, 0x70, 0x63, 0x6b, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x22, 0x87, 0x01, 0x0a, 0x17,
	0x50, 0x43, 0x4b, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x68,
	0x61, 0x69, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x12, 0x32, 0x0a, 0x15, 0x63, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x13, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x12,
	0x24, 0x0a, 0x0e, 0x70, 0x63, 0x6b, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x69,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0c, 0x70, 0x63, 0x6b, 0x43, 0x65, 0x72, 0x74,
	0x43, 0x68, 0x61, 0x69, 0x6e, 0x22, 0x4a, 0x0a, 0x0a, 0x51, 0x65, 0x41, 0x75, 0x74, 0x68, 0x44,
	0x61, 0x74, 0x61, 0x12, 0x28, 0x0a, 0x10, 0x70, 0x61, 0x72, 0x73, 0x65, 0x64, 0x5f, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0e, 0x70,
	0x61, 0x72, 0x73, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x64, 0x61, 0x74,
	0x61, 0x22, 0xf7, 0x02, 0x0a, 0x0d, 0x45, 0x6e, 0x63, 0x6c, 0x61, 0x76, 0x65, 0x52, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x12, 0x17, 0x0a, 0x07, 0x63, 0x70, 0x75, 0x5f, 0x73, 0x76, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x63, 0x70, 0x75, 0x53, 0x76, 0x6e, 0x12, 0x1f, 0x0a, 0x0b,
	0x6d, 0x69, 0x73, 0x63, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x0a, 0x6d, 0x69, 0x73, 0x63, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x12, 0x1c, 0x0a,
	0x09, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x31, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x09, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x31, 0x12, 0x1e, 0x0a, 0x0a, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x6d,
	0x72, 0x5f, 0x65, 0x6e, 0x63, 0x6c, 0x61, 0x76, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x09, 0x6d, 0x72, 0x45, 0x6e, 0x63, 0x6c, 0x61, 0x76, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x72, 0x65,
	0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x32, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x72,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x32, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x72, 0x5f, 0x73,
	0x69, 0x67, 0x6e, 0x65, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x6d, 0x72, 0x53,
	0x69, 0x67, 0x6e, 0x65, 0x72, 0x12, 0x1c, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x64, 0x33, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76,
	0x65, 0x64, 0x33, 0x12, 0x1e, 0x0a, 0x0b, 0x69, 0x73, 0x76, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x5f,
	0x69, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x69, 0x73, 0x76, 0x50, 0x72, 0x6f,
	0x64, 0x49, 0x64, 0x12, 0x17, 0x0a, 0x07, 0x69, 0x73, 0x76, 0x5f, 0x73, 0x76, 0x6e, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x06, 0x69, 0x73, 0x76, 0x53, 0x76, 0x6e, 0x12, 0x1c, 0x0a, 0x09,
	0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x34, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x09, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x34, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x0a, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x42, 0x2a, 0x5a, 0x28, 0x67,
	0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x67, 0x6f, 0x2d, 0x74, 0x64, 0x78, 0x2d, 0x67, 0x75, 0x65, 0x73, 0x74, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2f, 0x74, 0x64, 0x78, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_tdx_proto_rawDescOnce sync.Once
	file_tdx_proto_rawDescData = file_tdx_proto_rawDesc
)

func file_tdx_proto_rawDescGZIP() []byte {
	file_tdx_proto_rawDescOnce.Do(func() {
		file_tdx_proto_rawDescData = protoimpl.X.CompressGZIP(file_tdx_proto_rawDescData)
	})
	return file_tdx_proto_rawDescData
}

var file_tdx_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_tdx_proto_goTypes = []interface{}{
	(*QuoteV4)(nil),                    // 0: tdx.QuoteV4
	(*Header)(nil),                     // 1: tdx.Header
	(*TDQuoteBody)(nil),                // 2: tdx.TDQuoteBody
	(*Ecdsa256BitQuoteV4AuthData)(nil), // 3: tdx.Ecdsa256BitQuoteV4AuthData
	(*CertificationData)(nil),          // 4: tdx.CertificationData
	(*QEReportCertificationData)(nil),  // 5: tdx.QEReportCertificationData
	(*PCKCertificateChainData)(nil),    // 6: tdx.PCKCertificateChainData
	(*QeAuthData)(nil),                 // 7: tdx.QeAuthData
	(*EnclaveReport)(nil),              // 8: tdx.EnclaveReport
}
var file_tdx_proto_depIdxs = []int32{
	1, // 0: tdx.QuoteV4.header:type_name -> tdx.Header
	2, // 1: tdx.QuoteV4.td_quote_body:type_name -> tdx.TDQuoteBody
	3, // 2: tdx.QuoteV4.signed_data:type_name -> tdx.Ecdsa256BitQuoteV4AuthData
	4, // 3: tdx.Ecdsa256BitQuoteV4AuthData.certification_data:type_name -> tdx.CertificationData
	5, // 4: tdx.CertificationData.qe_report_certification_data:type_name -> tdx.QEReportCertificationData
	8, // 5: tdx.QEReportCertificationData.qe_report:type_name -> tdx.EnclaveReport
	7, // 6: tdx.QEReportCertificationData.qe_auth_data:type_name -> tdx.QeAuthData
	6, // 7: tdx.QEReportCertificationData.pck_certificate_chain_data:type_name -> tdx.PCKCertificateChainData
	8, // [8:8] is the sub-list for method output_type
	8, // [8:8] is the sub-list for method input_type
	8, // [8:8] is the sub-list for extension type_name
	8, // [8:8] is the sub-list for extension extendee
	0, // [0:8] is the sub-list for field type_name
}

func init() { file_tdx_proto_init() }
func file_tdx_proto_init() {
	if File_tdx_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_tdx_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QuoteV4); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tdx_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Header); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tdx_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TDQuoteBody); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tdx_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Ecdsa256BitQuoteV4AuthData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tdx_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificationData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tdx_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QEReportCertificationData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tdx_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PCKCertificateChainData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tdx_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QeAuthData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tdx_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnclaveReport); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_tdx_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_tdx_proto_goTypes,
		DependencyIndexes: file_tdx_proto_depIdxs,
		MessageInfos:      file_tdx_proto_msgTypes,
	}.Build()
	File_tdx_proto = out.File
	file_tdx_proto_rawDesc = nil
	file_tdx_proto_goTypes = nil
	file_tdx_proto_depIdxs = nil
}
