# free-for-dev
Developers and Open Source authors now have a massive amount of services offering free tiers, but it can be hard to find them all in order to make informed decisions.

This is a list of software (SaaS, PaaS, IaaS, etc.) and other offerings that have free tiers for developers.

The scope of this particular list is limited to things infrastructure developers (System Administrator, DevOps Practitioners, etc.) are likely to find useful. We love all the free services out there, but it would be good to keep it on topic. It's a bit of a grey line at times so this is a bit opinionated; do not be offended if I do not accept your contribution.

You can help by sending Pull Requests to add more services. Once I have a good set of links in this README file, I'll look into a better layout for the information and links (help with that is appreciated too).

*NOTE:* This list is only for as-a-Service offerings, not for self-hosted software. For a service to be eligible it has to offer a Free Tier and not just a free trial. If the Free Tier is time bucketed it has to be at least a year.

Table of Contents
=================

   * [Source Code Repos](#source-code-repos)
   * [Artifact Repos](#artifact-repos)
   * [Tools for Teams and Collaboration](#tools-for-teams-and-collaboration)
   * [Code Quality](#code-quality)
   * [Code Search and Browsing](#code-search-and-browsing)
   * [CI / CD](#ci--cd)
   * [Automated Browser Testing](#automated-browser-testing)
   * [Security and PKI](#security-and-pki)
   * [Management Systems](#management-system)
   * [Log Management](#log-management)
   * [Translation Management](#translation-management)
   * [Monitoring](#monitoring)
   * [Crash and Exception Handling](#crash-and-exception-handling)
   * [Search](#search)
   * [Email](#email)
   * [CDN and Protection](#cdn-and-protection)
   * [PaaS](#paas)
   * [BaaS](#baas)
   * [Web Hosting](#web-hosting)
   * [DNS](#dns)
   * [IaaS](#iaas)
   * [DBaaS](#dbaas)
   * [STUN, WebRTC, Web Socket Servers and Other Routers](#stun-webrtc-web-socket-servers-and-other-routers)
   * [Issue Tracking and Project Management](#issue-tracking-and-project-management)
   * [Storage and Media Processing](#storage-and-media-processing)
   * [Design and UI](#design-and-ui)
   * [Data Visualization on Maps](#data-visualization-on-maps)
   * [Package Build System](#package-build-system)
   * [IDE and Code Editing](#ide-and-code-editing)
   * [Analytics, Events and Statistics](#analytics-events-and-statistics)
   * [Visitor Session Recording](#visitor-session-recording)
   * [International Mobile Number Verification API and SDK](#international-mobile-number-verification-api-and-sdk)
   * [Payment / Billing Integration](#payment--billing-integration)
   * [Docker Related](#docker-related)
   * [Vagrant Related](#vagrant-related)
   * [Miscellaneous](#miscellaneous)
   * [APIs, Data and ML](#apis-data-and-ml)
   * [Other Free Resources](#other-free-resources)

## Source Code Repos

  * [bitbucket.org](https://bitbucket.org/) — Unlimited public and private repos (Git and Mercurial) for up to 5 users with Pipelines for CI/CD
  * [chiselapp.com](http://chiselapp.com/) — Unlimited public and private Fossil repositories
  * [github.com](https://github.com/) — Unlimited number of public repositories
  * [about.gitlab.com](https://about.gitlab.com/) — Unlimited public and private Git repos with unlimited collaborators
  * [visualstudio.com](https://www.visualstudio.com/) — Unlimited private repos (Git and TFS) for up to 5 users/team
  * [plasticscm.com](https://plasticscm.com/) — Free for individuals, OSS and nonprofit organizations
  * [cloud.google.com](https://cloud.google.com/tools/cloud-repositories/) — Free private Git repositories hosted on Google Cloud Platform. Supports syncing with existing GitHub and Bitbucket repos. Free Beta for up to 500 MB of storage
  * [buddy.works](https://buddy.works/) — One free private project with a Git repository and continuous delivery integrated
  * [codebasehq.com](https://www.codebasehq.com/) — One free project with 100 MB space and 2 users
  * [NotABug](https://notabug.org) - NotABug.org is a free-software code collaboration platform for freely licensed projects, Git-based
  * [Deveo](https://deveo.com/) - [free](https://deveo.com/pricing/) cloud and  Git, Mercurial, or SVN repositories.
  * [projectlocker.com](https://projectlocker.com) — One free private project (Git and Subversion) with 50 MB space

## Artifact Repos

 * [central.sonatype.org](http://central.sonatype.org) - The default artifact repository for Apache Maven, SBT and other build systems.
 * [packagecloud.io](https://packagecloud.io) - Easy to use repository hosting for: Maven, RPM, DEB, PyPi and RubyGem packages (has free tier).

## Tools for Teams and Collaboration

  * [scinote.net](http://scinote.net) — Scientific data management and team collaboration. One Team with unlimited number of users, backup and 1 GB storage space
  * [appear.in](https://appear.in/) — One click video conversations, for free
  * [meet.jit.si](https://meet.jit.si/) — One click video conversations, screen sharing, for free
  * [flowdock.com](https://www.flowdock.com/) — Chat and inbox, free for teams up to 5
  * [slack.com](https://slack.com/) — Free for unlimited users with some feature limitations
  * [stride.com](https://www.stride.com/) — Free for unlimited users with some feature limitations
  * [gitter.im](https://gitter.im/) — Chat, for GitHub. Unlimited public and private rooms, free for teams up to 25
  * [hangouts.google.com](https://hangouts.google.com/) — One place for all your conversations, for free, need a Google account
  * [seafile.com](https://www.seafile.com/) — Private or cloud storage, file sharing, sync, discussions. Private version is full. Cloud version has just 1 GB
  * [yammer.com](https://www.yammer.com/) — Private social network standalone or for MS Office 365. Free with a bit less admin tools and users management features
  * [helpmonks.com](https://helpmonks.com/) — Shared inbox for teams, free for Open Source and nonprofit organizations
  * [typetalk.in](http://www.typetalk.in/) — Share and discuss ideas with your team through instant messaging on the web or on your mobile
  * [talky.io](https://talky.io/) — Free group video chat. Anonymous. Peer‑to‑peer. No plugins, signup, or payment required
  * [sourcetalk.net](http://sourcetalk.net/) — Code discussion tool, free for open code talks
  * [helplightning.com](https://www.helplightning.com/) — Help over video with augmented reality. Free without analytics, encryption, support
  * [evernote.com](https://evernote.com/) — Tool for organizing information. Share your notes and work together with others
  * [doodle.com](http://doodle.com/) — The scheduling tool you'll actually use. Find a date for a meeting two times faster
  * [sendtoinc.com](https://sendtoinc.com/) — Share links, notes, files and have discussions. Free for 3 and 100 MB
  * [zoom.us](https://zoom.us/) — Secure Video and Web conferencing, add-ons available. Free limited to 40 minutes
  * [ideascale.com](https://ideascale.com/) — Allow clients to submit ideas and vote, free for 25 members in 1 community
  * [wistia.com](http://wistia.com/) — Video hosting with viewer analytics, HD video delivery and marketing tools to help understand your visitors, 25 videos and Wistia branded player
  * [cnverg.com](http://cnverg.com/) — Real-time shared visual workspace, whiteboard, GitHub integration. Free 5 GB, 5 spaces and 5 collaborators, no GitHub repos
  * [flock.com](https://flock.com) — A faster way for your team to communicate. Free Unlimited Messages, Channels, Users, Apps & Integrations
  * [Igloo](https://www.igloosoftware.com/) — Internal portal for sharing documents, blogs and calendars etc. Free for up to 10 users.
  * [riot.im](https://about.riot.im/) — A decentralized communication tool built on Matrix. Group chats, direct messaging, encrypted file transfers, voice and video chats, and easy integration with other services.

## Code Quality

  * [tachikoma.io](http://tachikoma.io/) — Dependency Update for Ruby, Node.js, Perl projects, free for Open Source
  * [gemnasium.com](https://gemnasium.com/) — Dependency Update for Ruby, Node.js projects, free for Open Source
  * [deppbot.com](https://www.deppbot.com/) — Automated Dependency Updates for Ruby projects, free for Open Source
  * [landscape.io](https://landscape.io/) — Code Quality for Python projects, free for Open Source
  * [codeclimate.com](https://codeclimate.com/) — Automated code review, free for Open Source
  * [houndci.com](https://houndci.com/) — Comments on GitHub commits about code quality, free for Open Source
  * [coveralls.io](https://coveralls.io/) — Display test coverage reports, free for Open Source
  * [scrutinizer-ci.com](https://scrutinizer-ci.com/) — Continuous inspection platform, free for Open Source
  * [codecov.io](https://codecov.io/) — Code coverage tool (SaaS), free for Open Source
  * [insight.sensiolabs.com](https://insight.sensiolabs.com/) — Code Quality for PHP/Symfony projects, free for Open Source
  * [codacy.com](https://codacy.com/) — Automated code reviews for PHP, Python, Ruby, Java, JavaScript, Scala, CSS and CoffeeScript, free for Open Source
  * [pullreview.com](https://www.pullreview.com/) — Automated Code Review for Ruby in GitHub, Bitbucket and GitLab, free for Open Source
  * [gocover.io](http://gocover.io/) — Code coverage for any [Go](https://golang.org/) package
  * [goreportcard.com](http://goreportcard.com/) — Code Quality for Go projects, free for Open Source
  * [inch-ci.org](http://inch-ci.org/) — Documentation badges for Ruby, JS and Elixir
  * [scan.coverity.com](https://scan.coverity.com/) — Static code analysis for Java, C/C++, C# and JavaScript, free for Open Source
  * [webceo.com](https://www.webceo.com/) — SEO tools but with also code verifications and different type of advices
  * [zoompf.com](https://zoompf.com/) — Fix the performance of your web sites, detailed analysis
  * [websitetest.com](http://websitetest.com/) — Yotta's tool to optimize web sites, free limited version online
  * [gtmetrix.com](https://gtmetrix.com/) — Reports and thorough recommendations to optimize websites
  * [browserling.com](https://www.browserling.com/) — Live interactive cross-browser testing, free only 3 minutes sessions with MS IE 9 under Vista at 1024 x 768 resolution
  * [versioneye.com](https://www.versioneye.com/) — Monitor your source code and notify about outdated dependencies. Free for Open Source and public repos
  * [shields.io](https://shields.io) — Quality metadata badges for open source projects
  * [beanstalkapp.com](http://beanstalkapp.com/) — A complete workflow to write, review and deploy code), free account for 1 user and 1 repository with 100 MB of storage
  * [testanywhere.co](https://testanywhere.co/) — Automatic test website or web app continuously and catch bugs in the early stages, free 1,000 tests/month
  * [srcclr.com](https://srcclr.com/) — SourceClear to scan source code for vulnerabilities, multi-languages and OS
  * [blamewarrior.com](https://blamewarrior.com/) — Tool to automatically assign reviewers for new pull requests and track statistics of review process, free for Open Source
  * [gerrithub.io](https://review.gerrithub.io/) — Gerrit code review for GitHub repositories for free
  * [reviewable.io](https://reviewable.io/) — Code review for GitHub repositories, free for public or personal repos
  * [sonarqube.com](https://sonarqube.com) — Automated source code analysis for Java, JavaScript, C/C++, C#, VB.NET, PHP, Objective-C, Swift, Python, Groovy and even more languages, free for Open Source

## Code Search and Browsing

  * [codota.com](https://www.codota.com/) — Codota helps developers create better software, faster by providing insights learned from all the code in the world. Plugin available.
  * [libraries.io](https://libraries.io/) — Search and dependency update notifications for 32 different package managers, free for open source
  * [sourcegraph.com](https://sourcegraph.com/) — Java, Go, Python, Node.js, etc., code search/cross-references, free for Open Source
  * [searchcode.com](https://searchcode.com/) — Comprehensive text-based code search, free for Open Source

## CI / CD

  * [codefresh.io](https://codefresh.io) — Free-for-Life plan: 1 build, 1 environment, shared servers, unlimited public repos
  * [codeship.com](https://codeship.com/) — 100 private builds/month, 5 private projects, unlimited for Open Source
  * [circleci.com](https://circleci.com/) — Free for one concurrent build
  * [stackahoy.io](https://stackahoy.io) — 100% free. Unlimited deployments, branches and builds
  * [travis-ci.org](https://travis-ci.org/) — Free for public GitHub repositories
  * [wercker.com](http://wercker.com/) — Free for public and private repositories
  * [semaphoreci.com](https://semaphoreci.com/) — Free for Open Source, 100 private builds per month
  * [shippable.com](https://app.shippable.com/) — 150 private builds/month, free for 1 build container, private and public repos
  * [appveyor.com](http://www.appveyor.com/) — CD service for Windows, free for Open Source
  * [github.com](https://github.com/ligurio/Continuous-Integration-services) — Comparison of Continuous Integration services
  * [ftploy.com](http://ftploy.com/) — 1 project with unlimited deployments
  * [deployhq.com](http://www.deployhq.com/) — 1 project with 10 daily deployments
  * [hub.jazz.net](https://hub.jazz.net/) — 60 minutes of free build time/month
  * [styleci.io](https://styleci.io/) — Public GitHub repositories only
  * [bitrise.io](https://www.bitrise.io/) — An iOS CI/CD with 200 free builds/month
  * [buddybuild.com](https://www.buddybuild.com/) — Build, deploy and gather feedback for your iOS and Android apps in one seamless, iterative system
  * [gitlab.com](https://about.gitlab.com/gitlab-ci/) — Create pipelines directly from Git repositories using GitLab's CI service
  * [dependencyci.com](https://dependencyci.com/) — Continuous dependency checking for GitHub repositories, free for open source

## Automated Browser Testing

  * [gridlastic.com](https://www.gridlastic.com/) — Selenium Grid testing with free plan up to 4 simultaneous selenium nodes/10 grid starts/4,000 test minutes/month
  * [saucelabs.com](https://saucelabs.com/) — Cross browser testing, Selenium testing and mobile testing, [free for Open Source](https://saucelabs.com/open-source)
  * [browserstack.com](https://www.browserstack.com/) — Manual and automated browser testing, free for Open Source
  * [everystep-automation.com](https://www.everystep-automation.com/) — Records and replays all steps made in a web browser and creates scripts,... free with fewer options
  * [Applitools.com](https://applitools.com/) — smart visual validation for web, native mobile and desktop apps. Integrates with almost all automation solutions (like Selenium and Karma) and remote runners (Sauce Labs, Browser Stack). free for open source. A free tier for a single user with limited checkpoints per week.

## Security and PKI

  * [pyup.io](https://pyup.io) — Monitory Python dependencies for security vulnerabilities and update them automatically. Free for one private project, unlimited projects for open source.
  * [threatconnect.com](https://www.threatconnect.com) — Threat intelligence: It is designed for individual researchers, analysts and organizations who are starting to learn about cyber threat intelligence. Free up to 3 Users
  * [crypteron.com](https://www.crypteron.com/) — Cloud-first, developer-friendly security platform prevents data breaches in .NET and Java applications
  * [snyk.io](https://snyk.io) — Snyk found and reported several vulnerabilities in the package.Limited to 1 private project (unlimited for open source projects)
  * [vaddy.net](http://vaddy.net/) — Continuous web security testing with continuous integration (CI) tools. 3 domains, 10 scans history for free
  * [letsencrypt.org](https://letsencrypt.org/) — Free SSL Certificate Authority with certs trusted by all major browsers
  * [globalsign.com](https://www.globalsign.com/en/ssl/ssl-open-source/) — Free SSL certificates for Open Source
  * [stormpath.com](https://stormpath.com/) — Free user management, authentication, social login and SSO
  * [auth0.com](https://auth0.com/) — Hosted free for development SSO
  * [getclef.com](https://getclef.com/) — New take on auth unlimited free tier for anyone not using premium features
  * [ringcaptcha.com](https://ringcaptcha.com/) — Tools to use phone number as id, available for free
  * [ssllabs.com](https://www.ssllabs.com/ssltest/) — Very deep analysis of the configuration of any SSL web server
  * [qualys.com](https://www.qualys.com/forms/freescan/owasp/) — Find web app vulnerabilities, audit for OWASP Risks
  * [alienvault.com](https://www.alienvault.com/open-threat-exchange/reputation-monitor) — Uncovers compromised systems in your network
  * [duo.com](https://duo.com/) — Two-factor authentication (2FA) for website or app. Free 10 users, all authentication methods, unlimited, integrations, hardware tokens
  * [tinfoilsecurity.com](https://www.tinfoilsecurity.com/) — Automated vulnerability scanning. Free plan allows weekly XSS scans
  * [acunetix.com](https://www.acunetix.com/free-network-security-scanner/) — Free vulnerability and network scanning for 3 targets
  * [ponycheckup.com](https://www.ponycheckup.com/) — An automated security checkup tool for Django websites
  * [foxpass.com](https://www.foxpass.com/) — Hosted LDAP and RADIUS. Easy per-user logins to servers, VPNs and wireless networks. Free for 10 users
  * [opswatgears.com](https://www.opswatgears.com/) — Security Monitoring of computers, devices, applications, configurations,... Free 25 users and 30 days history
  * [bitninja.io](https://bitninja.io/) — Botnet protection through a blacklist, free plan only reports limited information on each attack
  * [onelogin.com](https://www.onelogin.com/) — Identity as a Service (IDaaS), Single Sign-On Identity Provider, Cloud SSO IdP, 3 company apps and 5 personal apps, unlimited users
  * [logintc.com](https://www.logintc.com/) — Two-factor authentication (2FA) by push notifications, free for 10 users, VPN, Websites and SSH
  * [report-uri.io](https://report-uri.io/) — CSP and HPKP violation reporting
  * [cloudsploit.com](https://cloudsploit.com/) — Amazon Web Services (AWS) security and compliance auditing and monitoring
  * [Have I been pwned?](https://haveibeenpwned.com) — REST API for fetching the information on the breaches.
  * [Internet.nl](https://internet.nl) — Test for modern Internet Standards like IPv6, DNSSEC, HTTPS, DMARC, STARTTLS and DANE
  
## Management System

  * [bitnami.com](https://bitnami.com/) — Deploy prepared apps on IaaS. Management of 1 AWS micro instance free
  * [visualops.io](http://visualops.io/) — 3,600 instance hours/month free
  * [jamf.com](https://www.jamf.com/) —  Device management for iPads, iPhones and Macs, 3 devices free

## Log Management

  * [logentries.com](https://logentries.com/) — Free up to 5 GB/month with 7 days retention
  * [loggly.com](https://www.loggly.com/) — Free for a single user, see the lite option
  * [logz.io](http://logz.io/) — Free up to 1 GB/day, 3 days retention
  * [papertrailapp.com](https://papertrailapp.com/) — 48 hours search, 7 days archive, 100 MB/month
  * [rollbar.com](https://rollbar.com) — Free up to 5000 events/month, 30 days retention
  * [sematext.com](https://sematext.com//logsene) — Free up to 500 MB/day, 7 days retention
  * [sumologic.com](https://www.sumologic.com/) — Free up to 500 MB/day, 7 days retention

## Translation Management

  * [lingohub.com](https://lingohub.com/) — Free up to 3 users, always free for Open Source
  * [getlocalization.com](https://www.getlocalization.com/) — Free for public projects
  * [webtranslateit.com](http://webtranslateit.com/) — Free up to 500 strings
  * [transifex.com](https://www.transifex.com/) — Free for Open Source
  * [oneskyapp.com](http://www.oneskyapp.com/) — Limited free edition for up to 5 users, free for Open Source
  * [crowdin.com](https://crowdin.com/) — Unlimited projects, unlimited strings and collaborators for Open Source
  * [instant.cm](https://instant.cm/) — Free for up to 2 languages and 20,000 requests/month
  * [Loco](https://localise.biz/) - Free up to 2000 translations, Unlimited translators, 10 languages/project, 1000 translatable assets/project

## Monitoring

  * [cloudsploit.com](https://cloudSploit.com) — AWS security and configuration monitoring. Free: unlimited on-demand scans, unlimited users, unlimited stored accounts. Subscription: automated scanning, API access, etc
  * [opbeat.com](https://opbeat.com/) — ​Instant performance insights for JS developers. Free with 24 hours data retention
  * [checkmy.ws](https://checkmy.ws/en/solutions/free-forever-for-foss/) — Free 15 days full demo and 3 websites, forever free for Open Source
  * [appneta.com](http://www.appneta.com/) — Free with 1 hour data retention
  * [thousandeyes.com](https://www.thousandeyes.com/) — Network and user experience monitoring. 3 locations and 20 data feeds of major web services free
  * [datadoghq.com](https://www.datadoghq.com/) — Free for up to 5 nodes
  * [stackdriver.com](http://www.stackdriver.com/) — Free monitoring up to 10 servers/hosted services
  * [keymetrics.io](https://keymetrics.io/) — Free for 2 servers and 1 user
  * [newrelic.com](https://newrelic.com/) — Free with 24 hours data retention
  * [nodequery.com](https://nodequery.com/) — Free basic server monitor up to 10 servers
  * [watchsumo.com](http://www.watchsumo.com/) — Free website monitoring, 50 http(s), Ping or keywords, every 5+ minutes
  * [circonus.com](http://www.circonus.com/) — Free for 20 metrics
  * [uptimerobot.com](https://uptimerobot.com/) — Website monitoring, 50 monitors free
  * [statuscake.com](https://www.statuscake.com/) — Website monitoring, unlimited tests free with limitations
  * [bmc.com](http://www.bmc.com/truesightpulse/) — Free 1 second resolution for up to 10 servers
  * [ghostinspector.com](https://ghostinspector.com/) — Free website and web application monitoring. Single user, 100 test runs/month
  * [java-monitor.com](http://java-monitor.com/forum/welcome.php/) — Free monitoring of JVM's and uptime
  * [sematext.com](https://sematext.com/) — Free for 24 hours metrics, unlimited number of servers, 10 custom metrics, 500,000 custom metrics data points, unlimited dashboards, users, etc
  * [stathat.com](https://www.stathat.com/) — Get started with 10 stats for free, no expiration
  * [skylight.io](https://www.skylight.io/) — Free for first 100,000 requests (Rails only)
  * [appdynamics.com](https://www.appdynamics.com/) — Free for 24 hours metrics, application performance management agents limited to one Java, one .NET, one PHP and one Node.js
  * [deadmanssnitch.com](https://deadmanssnitch.com/) — Monitoring for cron jobs. 1 free snitch (monitor), more if you refer others to sign up
  * [librato.com](https://www.librato.com/) — Free up to 100 metrics at 60 seconds resolution
  * [freeboard.io](https://freeboard.io/) — Free for public projects. Dashboards for your Internet of Things (IoT) projects
  * [loader.io](https://loader.io/) — Free load testing tools with limitations
  * [speedchecker.xyz](http://probeapi.speedchecker.xyz/) — Performance Monitoring API, checks Ping, DNS, etc
  * [blackfire.io](https://blackfire.io/) — Blackfire is the SaaS-delivered Application Performance Solution. Free Hacker plan (PHP only)
  * [apimetrics.io](http://apimetrics.io/) — Automated API Performance Monitoring, Testing and Analytics. Free Plan, manually make API calls and Run from their West Coast servers
  * [opsdash.com](https://www.opsdash.com/) — Self-hoster server, clusters and services monitoring, free for 5 servers and 5 services
  * [healthchecks.io](https://healthchecks.io) — Monitor your cron jobs and background tasks. Unlimited free checks
  * [appbeat.io](https://appbeat.io) — Website monitoring, 3 monitors free. They offer very reliable and affordable monitor service.
  * [monique.io](https://monique.io) — Create dashboards directly from SQL results, JSON data, API respones, Unix commands' output. Define alarms in Javascript. Free for 25000 submissions per month.
  * [assertible.com](https://assertible.com) - Automated API testing and monitoring. Free plans for teams and individuals.
  * [letsmonitor.org](http://letsmonitor.org/) - TLS certificate expiration and connectivity monitoring with email and SMS alerts.

## Crash and Exception Handling

  * [rollbar.com](https://rollbar.com/) — Exception and error monitoring, free plan with 5,000 errors/month, unlimited users, 30 days retention
  * [bugsnag.com](https://bugsnag.com/) — Free for up to 2,000 errors/month after the initial trial
  * [sentry.io](https://sentry.io/) — Sentry tracks app exceptions in real-time, has a small free plan. Free, unrestricted use if self-hosted

## Search

  * [algolia.com](https://www.algolia.com/) — Hosted search-as-you-type (instant). Free hacker plan up to 10,000 documents and 100,000 operations. Bigger free plans available for community/Open Source projects
  * [swiftype.com](https://swiftype.com/) — Hosted search solution (API and crawler). Free for a single search engine with up to 1,000 documents. Free upgrade to premium level for Open Source
  * [bonsai.io](https://bonsai.io/) — Free 1 GB memory and 1 GB storage
  * [searchly.com](http://www.searchly.com/) — Free 2 indices and 5 MB storage
  * [indexisto.com](https://indexisto.com/) — Site search, free 10 million documents index limit with advertisement block

## Email

  * [mailinator.com](https://www.mailinator.com/) — Free, public, email system where you can use any inbox you want
  * [sparkpost.com](https://www.sparkpost.com/) — First 15,000 emails/month free
  * [mailgun.com](https://www.mailgun.com/) — First 10,000 emails/month free
  * [tinyletter.com](https://tinyletter.com/) — 5,000 subscribers/month free
  * [sendloop.com](https://start.sendloop.com/) - 2,000 subscribers and unlimited emails/month free
  * [mailchimp.com](http://mailchimp.com/) — 2,000 subscribers and 12,000 emails/month free
  * [sendgrid.com](https://sendgrid.com/) — 100 emails/day and 2,000 contacts free
  * [phplist.com](https://phplist.com/) — Hosted version allow 300 emails/month free
  * [mailjet.com](https://www.mailjet.com/) — 6,000 emails/month free
  * [sendinblue.com](https://www.sendinblue.com/) — 9,000 emails/month free
  * [mailtrap.io](https://mailtrap.io/) — Fake SMTP server for development, free plan with 1 inbox, 50 messages, no team member, 2 emails/second, no forward rules
  * [postmarkapp.com](https://postmarkapp.com/) — First 25,000 emails free
  * [zoho.com](https://www.zoho.com/mail/) — Free email management and collaboration for up to 25 users
  * [domain.yandex.com](https://domain.yandex.com/domains_add/) — Free email and DNS hosting for up to 1,000 users
  * [moosend.com](http://moosend.com/) — Mailing list management service. Free account for 6 months for startups
  * [debugmail.io](https://debugmail.io/) — Easy to use testing mail server for developers
  * [mailboxlayer.com](https://mailboxlayer.com/) — Email validation and verification JSON API for developers. 1,000 free API requests/month
  * [mailcatcher.me](http://mailcatcher.me/) — Catches mail and serves it through a web interface
  * [yopmail.fr](http://www.yopmail.fr/en/) — Disposable email addresses
  * [kickbox.io](http://kickbox.io/) — Verify 100 emails free, real-time API available
  * [inumbo.com](http://inumbo.com/) — SMTP based spam filter, free for 10 users
  * [biz.mail.ru](https://biz.mail.ru/) — 5,000 mailboxes with 25 GB each per custom domain with DNS hosting
  * [maildocker.com](http://maildocker.com) — First 10,000 emails/month free
  * [sendpulse.com](https://sendpulse.com) — 50 emails free/hour, first 12,000 emails/month free
  * [pepipost.com](http://www.pepipost.com) — Unlimited emails free for first three months, then first 25,000 emails/month free
  * [elasticemail.com](https://elasticemail.com) — First 150,000 emails/month free
  * [appmail.io](https://appmail.io) — First 10,000 emails free
  * [mail-tester.com](https://www.mail-tester.com) — Test if email's dns/spf/dkim/dmarc settings are correct, 20 free/month

## CDN and Protection

  * [cloudflare.com](https://www.cloudflare.com/) — Basic service is free, good for a blog, it also offers a free SSL certificate service
  * [bootstrapcdn.com](http://www.bootstrapcdn.com/) — CDN for bootstrap, bootswatch and fontawesome.io
  * [cdnjs.com](https://cdnjs.com/) — CDN for JavaScript libraries, CSS libraries, SWF, images, etc
  * [jsdelivr.com](http://www.jsdelivr.com/) — CDN of OSS (JS, CSS, fonts) for developers and webmasters, accepts PRs to add more
  * [developers.google.com](https://developers.google.com/speed/libraries/) — The Google Hosted Libraries is a content distribution network for the most popular, Open Source JavaScript libraries
  * [asp.net](https://www.asp.net/ajax/cdn/) — The Microsoft Ajax CDN hosts popular third party JavaScript libraries such as jQuery and enables you to easily add them to your Web application
  * [toranproxy.com](https://toranproxy.com/) — Proxy for Packagist and GitHub. Never fail CD. Free for personal use, 1 developer, no support
  * [rawgit.com](https://rawgit.com/) — Free limited traffic, serves raw files directly from GitHub with proper Content-Type headers
  * [incapsula.com](https://www.incapsula.com/) — Free CDN and DDoS protection
  * [fastly.com](https://www.fastly.com/) — Free CDN, all features until USD 50/month is reached, enough for most, then pay or suspended
  * [Web Support Revolution](https://w.tools/) — Free CDN, backup, firewall, antivirus and monitoring.
  * [athenalayer.com](http://athenalayer.com/) — Free DDoS protection with unlimited websites
  * [section.io](https://www.section.io/) — A simple way to spin up and manage a complete Varnish Cache solution. Supposedly free forever for one site
  * [netdepot.com](https://www.netdepot.com/cdn/) — First 100 GB free/month
  * [speeder.io](https://speeder.io/) — Uses KeyCDN. Automatic image optimization and free CDN boost. Free and does not require any server changes
  * [jare.io](http://www.jare.io) — You should log in using your GitHub account and register your domain. Uses AWS CloudFront

## PaaS

  * [cloud.google.com](https://cloud.google.com/appengine/) — Google App Engine gives 28 instance hours/day free, 1 GB NoSQL database and more
  * [engineyard.com](https://www.engineyard.com/) — Engine Yard provides 500 free hours
  * [azure.microsoft.com](https://azure.microsoft.com/) — MS Azure gives USD 200 worth of free usage for a trial
  * [appharbor.com](https://appharbor.com/) — A .Net PaaS that provides 1 free worker
  * [heroku.com](https://www.heroku.com/) — Host your apps in the cloud, free for single process apps
  * [hasura.io](https://www.hasura.io/) — Platform to build and deploy app backends fast, free for single node cluster.
  * [firebase.com](https://www.firebase.com/) — Build real-time apps, the free plan has 100 max connections, 10 GB data transfer, 1 GB data storage, 1 GB hosting storage and 10 GB hosting transfer
  * [bluemix.net](https://console.ng.bluemix.net/) — IBM PaaS with a monthly free allowance
  * [outsystems.com](http://www.outsystems.com/) — Enterprise web development PaaS for on-premise or cloud, free "personal environment" offering allows for unlimited code and up to 1 GB database
  * [platform.telerik.com](https://platform.telerik.com/) — Build and deploy mobile applications using JavaScript. Free plan has 100 MB data storage, 1 GB file storage, 5 GB bandwidth, 1 million push notifications for BaaS offering, 100 active devices for analytics
  * [scn.sap.com](https://scn.sap.com/docs/DOC-56411) — The in-memory Platform-as-a-Service offering from SAP. Free developer accounts come with 1 GB structured, 1 GB unstructured, 1 GB of Git data and allow you to run HTML5, Java and HANA XS apps
  * [mendix.com](https://www.mendix.com/) — Rapid Application Development for Enterprises, unlimited number of free sandbox environments supporting 10 users, 100 MB of files and 100 MB database storage each
  * [pythonanywhere.com](https://www.pythonanywhere.com/) — Cloud Python app hosting. Beginner account is free, 1 Python web application at your-username.pythonanywhere.com domain, 512 MB private file storage, one MySQL database
  * [configure.it](http://www.configure.it/) — Mobile app development platform, free for 2 projects, limited features but no resource limits
  * [pagodabox.io](http://pagodabox.io/) — Small worker, web server, cache and database for free
  * [zeit.co/now](https://zeit.co/now) — Managed platform for Node.js, static sites and Docker deployments. Limited to 3 concurrent instances, 1 GB storage and 1 GB bandwidth for OSS projects (source files are exposed on a public URL)
  * [sandstorm.io](https://sandstorm.io/) — Sandstorm is an open source operating system for personal and private clouds. Free plan offers 200 MB storage and 5 grains free
  * [gearhost.com](https://www.gearhost.com/pricing) — Platform for .NET and PHP apps. 256 MB of RAM for free on a shared server with limited resources
  * [glitch.com](https://www.glitch.com/) — Free unlimited public/private hosting for Node.js apps with features such as code sharing and real-time collaboration

## BaaS

  * [appacitive.com](http://appacitive.com/) — Mobile backend, free for the first 3 months with 100,000 API calls, push notifications
  * [bip.io](https://bip.io/) — A web-automation platform for easily connecting web services. Fully open GPLv3 to power the backend of your Open Source project. Commercial OEM License available
  * [blockspring.com](https://www.blockspring.com/) — Cloud functions. Free for 5 million runs/month
  * [kinvey.com](http://www.kinvey.com/) — Mobile backend, starter plan has unlimited requests/second, with 2 GB of data storage, as well as push notifications for up 5 million unique recipients. Enterprise application support
  * [backendless.com](https://backendless.com/) — Mobile and Web Baas, with 1 GB file storage free, push notifications 50000/month, and 1000 data objects in table.
  * [pusher.com](https://pusher.com/push-notifications/) - Free, unlimited push notifications at scale. A single API for iOS and Android devices
  * [konacloud.io](http://konacloud.io/) — Web and Mobile Backend as a Service, with 5 GB free account
  * [layer.com](https://layer.com/) — The full-stack building block for communications
  * [quickblox.com](http://quickblox.com/) — A communication backend for instant messaging, video and voice calling and push notifications
  * [pushbots.com](https://pushbots.com/) — Push notification service. Free for up to 1.5 million pushes/month
  * [onesignal.com](https://onesignal.com/) — Unlimited free push notifications
  * [getstream.io](https://getstream.io/) — Build scalable news feeds and activity streams in a few hours instead of weeks, free for 3 million feed updates/month
  * [tyk.io](https://tyk.io/) — API management with authentication, quotas, monitoring and analytics. Free cloud offering
  * [iron.io](http://www.iron.io/) — Async task processing (like AWS Lambda) with free tier and 1 month free trial
  * [stackhut.com](http://stackhut.com/) — Async task processing (like AWS Lambda). 10 free private services and unlimited free public services
  * [pubnub.com](https://www.pubnub.com/) — Free push notifications for up to 1 million messages/month and 100 active daily devices
  * [reappt.io](https://reappt.io) — Real-time Messaging for browsers, smartphones and everyone. 100 concurrent connections. Free 10 GB data/month
  * [webtask.io](https://webtask.io/) — Run code with an HTTP call. No provisioning. No deployment
  * [zapier.com](https://zapier.com/) — Connect the apps you use, to automate tasks. 5 zaps, every 15 minutes and 100 tasks/month
  * [stackstorm.com](https://stackstorm.com/) — Event-driven automation for apps, services and workflows, free without flow, access control, LDAP,...
  * [simperium.com](https://simperium.com/) — Move data everywhere instantly and automatically, multi-platform, unlimited sending and storage of structured data, max. 2,500 users/month
  * [stamplay.com](https://stamplay.com/) — Connect services together with a visual interface. 50,000 API calls, 100 GB data transfer and 1 GB storage for free
  * [pushcrew.com](https://pushcrew.com/) — Push notification service. Unlimited notifications up to 2000 Subscribers

## Web Hosting

  * [pages.github.com](https://pages.github.com/) — Hosting static site directly from GitHub repository
  * [closeheat.com](https://closeheat.com/) — Development Environment in the Cloud for Static Websites with Free Hosting and GitHub integration. 1 free website with custom domain support
  * [serverpilot.io](https://serverpilot.io/) ServerPilot, and we'll install everything you need to host PHP apps like WordPress. Unlimited servers, 1 SSH/SFTP user
  * [sourceforge.net](https://sourceforge.net/) — Find, Create and Publish Open Source software for free
  * [devport.co](http://devport.co/) — Turn GitHub projects, apps and websites into a personal developer portfolio
  * [netlify.com](https://www.netlify.com/) — Builds, deploy and hosts static site or app, free for 100 GB data and 100 GB/month bandwidth
  * [pantheon.io](https://pantheon.io/) — Drupal and WordPress hosting, automated DevOps and scalable infrastructure. Free for developers and agencies
  * [acquia.com](https://www.acquia.com/) — Hosting for Drupal sites. Free tier for developers. Free development tools (such as Acquia Dev Desktop) also available
  * [bitballoon.com](https://www.bitballoon.com/) — Hosting for static sites and apps. Free on a subdomain
  * [readthedocs.org](https://readthedocs.org/) — Free documentation hosting with versioning, PDF generation and more
  * [bubble.is](https://bubble.is/) — Visual programming to build web and mobile apps without code, free 100 visitors/month, 2 apps
  * [contentful.com](https://www.contentful.com/) — Content as a Service. Content management and delivery APIs in the cloud. 3 users, 3 repositories and 100,000 API requests/month for free
  * [tilda.cc](https://tilda.cc/) — One site, 50 pages, 50 MB storage, only the main pre-defined blocks among 170+ available, no fonts, no favicon and no custom domain
  * [surge.sh](https://surge.sh/) — Static web publishing for Front-End developers. Unlimited sites with custom domain support
  * [neocities.org](https://neocities.org) — Static, 1 GB free storage with 200 GB Bandwidth.
  * [txti.es](http://txti.es/) — Quickly create web pages with markdown.

## DNS

  * [freedns.afraid.org](https://freedns.afraid.org/) — Free DNS hosting
  * [dns.he.net](https://dns.he.net/) — Free DNS hosting service with Dynamic DNS Support
  * [luadns.com](http://www.luadns.com/) — Free DNS hosting, 3 domains, all features with reasonable limits
  * [domain.yandex.com](https://domain.yandex.com/domains_add/) — Free email and DNS hosting for up to 1,000 users
  * [selectel.com](https://selectel.com/services/dns/) — Free DNS hosting, anycast, 10 geo zones
  * [cloudns.net](https://www.cloudns.net/) — Free DNS hosting up to 3 domains with unlimited records
  * [ns1.com](https://ns1.com/) — Data Driven DNS, automatic traffic management, 1 million free queries
  * [zonewatcher.com](https://zonewatcher.com) — Automatic backups and DNS change monitoring. 1 domain free
  * [namecheap.com](https://www.namecheap.com/domains/freedns.aspx) — Free DNS. No limit on number of domains
   * [dynu.com](https://www.dynu.com/) — Free dynamic DNS service

## IaaS

  * [aws.amazon.com](https://aws.amazon.com/free/) — AWS Free Tier, free for 12 months
  * [developer.rackspace.com](https://developer.rackspace.com/) — Rackspace Cloud gives USD 50/month for 12 months
  * [cloud.google.com/compute](https://cloud.google.com/compute/) — Google Compute Engine gives USD 300 over 12 months
  * [virtzone.net](http://www.virtzone.net/) — Free VPS. You must meet certain minor qualifications
  * [backblaze.com](https://backblaze.com/b2/) — Backblaze B2 cloud storage. Free 10 GB (Amazon S3-like) object storage for unlimited time
  * [trystack.org](http://trystack.org/) — Free Openstack hosting. The environment is resets every 24 hours, suitable for testing only
  * [dply.co](https://dply.co/) — Create a cloud server FREE for 2 hours. Backend host is Digitalocean.

## DBaaS

   * [cloudant.com](https://cloudant.com/) — Hosted database from IBM, free if usage is below USD 50/month
   * [orchestrate.io](https://orchestrate.io/) — 1 application free
   * [redislabs.com](https://redislabs.com/redis-cloud) — Redis as a Service, 30 MB and 30 concurrent connections free
   * [backand.com](https://www.backand.com/) — Back-end as a service for AngularJS
   * [zenginehq.com](http://www.zenginehq.com/) — Build business workflow apps in minutes, free for single users
   * [redsmin.com](https://redsmin.com/) — Online real-time monitoring and administration service for Redis, 1 Redis instance free
   * [graphstory.com](http://graphstory.com/) — GraphStory offers Neo4j (a Graph Database) as a service
   * [elephantsql.com](http://www.elephantsql.com/) — PostgreSQL as a service, 20 MB free
   * [graphenedb.com](http://www.graphenedb.com/) — Neo4j as a service, up to 1,000 nodes and 10,000 relations free
   * [mlab.com](https://mlab.com/) — MongoDB as a service, 500 MB free
   * [MongoDB Atlas](https://www.mongodb.com/cloud/atlas) — free tier gives 512 MB
   * [scalingo.com](https://scalingo.com/) — Primarily a PaaS but offers a 512 MB free tier of MySQL, PostgreSQL or MongoDB
   * [skyvia.com](https://skyvia.com/) — Cloud Data Platform, offers free tier and all plans are completely free while in beta
   * [airtable.com](https://airtable.com/) — Looks like a spreadsheet, but it's a relational database, unlimited bases, 1,200 rows/base and 1,000 API requests/month
   * [fieldbook.com](https://fieldbook.com/) — Fieldbook lets anyone create a simple tracking database, as easily as a spreadsheet. Automatic API. Unlimited free sheets, share with unlimited users
   * [spreadsheetdb.io](https://www.spreadsheetdb.io) - Database that can be queried with spreadsheets, 3 spreadsheets and 200 rows
     free

## STUN, WebRTC, Web Socket Servers and Other Routers

   * [scaledrone.com](https://www.scaledrone.com/) — Push messaging service. Free for up to 20 simultaneous connections and 100,000 messages/day
   * [pusher.com](https://pusher.com/) — Realtime messaging service. Free for up to 100 simultaneous connections and 200,000 messages/day
   * [stun:stun.l.google.com:19302](stun:stun.l.google.com:19302) — Google STUN
   * [stun:global.stun.twilio.com:3478?transport=udp](stun:global.stun.twilio.com:3478?transport=udp) — Twilio STUN
   * [segment.com](https://segment.com/) — Hub to translate and route events to other third party services. 100,000 events/month free
   * [ngrok.com](https://ngrok.com/) — Expose locally running servers over a tunnel to a public URL.
   * [cloudamqp.com](https://www.cloudamqp.com/) — RabbitMQ as a Service. Little Lemur plan: max 1 million messages/month, max 20 concurrent connections, max 100 queues, max 10,000 queued messages, multiple nodes in different AZ's
   * [serveo.net](https://serveo.net/) - Quickly expose any local port to the public internet on a servo subdomain using an SSH tunnel, includes SSH GUI to replay requests over HTTP.
   * [ZeroTier](https://www.zerotier.com) - FOSS managed virtual Ethernet as a service. Unlimited end-to-end encrypted networks of 100 clients on free plan. Clients for desktop/mobile/NA; web interface for configuration of custom routing rules and approval of new client nodes on private networks.

## Issue Tracking and Project Management

   * [bitrix24.com](https://www.bitrix24.com/) — Free intranet and project management tool
   * [pivotaltracker.com](http://www.pivotaltracker.com/) — Pivotal Tracker, free for public projects
   * [atlassian.com](https://atlassian.com/opensource/overview) — Free Jira etc for Open Source
   * [kanbantool.com](http://kanbantool.com/) — Kanban board based project management. Free, paid plans with more options
   * [kanbanflow.com](https://kanbanflow.com/) — Board based project management. Free, premium version with more options
   * [zenhub.io](https://zenhub.io/) — The only project management solution inside GitHub. Free for public repos, OSS and nonprofit organizations
   * [trello.com](https://trello.com/) — Board based project management. Free
   * [producteev.com](https://producteev.com/) — Task management tool. Free, premium version with more options. Mobile applications available
   * [fogcreek.com](http://fogcreek.com/fogbugz/) — Bug tracking and project management. Free for 2 users
   * [waffle.io](https://waffle.io/) — Board based project management solution from your existing GitHub Issues, free for Open Source
   * [huboard.com](https://huboard.com/) — Instant project management for your GitHub issues, free for Open Source
   * [taiga.io](https://taiga.io/) — Project management platform for startups and agile developers, free for Open Source
   * [jetbrains.com](https://jetbrains.com/youtrack/buy/open_source_incloud.jsp) — Free hosted YouTrack (InCloud) for FOSS projects, private projects {[free for 10 users](https://www.jetbrains.com/youtrack/buy/)}
   * [github.com](https://github.com/) — In addition to its Git storage facility, GitHub offers basic issue tracking
   * [asana.com](https://asana.com/) — Free for private project with collaborators
   * [acunote.com](http://acunote.com/) — Free project management and SCRUM software for up to 5 team members
   * [gliffy.com](http://gliffy.com/) — Online diagrams: flowchart, UML, wireframe,... Also plugins for Jira and Confluence. 5 diagrams and 2 MB free
   * [cacoo.com](https://cacoo.com/) — Online diagrams in real-time: flowchart, UML, network. Free max. 15 users/diagram, 25 sheets
   * [draw.io](https://www.draw.io/) — Online diagrams stored locally, in Google Drive, OneDrive or Dropbox. Free for all features and storage levels
   * [visualstudio.com](https://www.visualstudio.com//products/what-is-visual-studio-online-vs) — Unlimited free private code repositories; Tracks bugs, work items, feedback and more
   * [testlio.com](https://testlio.com/) — Issue tracking, test management and beta testing platform. Free for private use
   * [vivifyscrum.com](https://vivifyscrum.com/) — Free tool for Agile project management. Scrum Compatible
   * [targetprocess.com](http://targetprocess.com/) — Visual project management, from Kanban and Scrum to almost any operational process. Free for unlimited users, up to 1,000 data entities {[more details](http://www.targetprocess.com/pricing/)}
   * [overv.io](https://overv.io/) — Agile project management for teams who love GitHub
   * [taskulu.com](https://taskulu.com/) — Role based project management. Free up to 5 users. Integration with GitHub/Trello/Dropbox/Google Drive
   * [contriber.com](https://contriber.com/) — Customizable project management platform, free starter plan, 5 workspaces
   * [planitpoker.com](http://planitpoker.com/) — Free online planning poker (estimation tool)
   * [ubertesters.com](https://ubertesters.com/) — Test platform, integration and crowdtesters, 2 projects, 5 members
   * [jetbrains.com](https://www.jetbrains.com/youtrack/buy/#edition=incloud) — search based on time tracking, attachments on Agile Board, and many other improvements. 10 users 5 GB free
   * [plan.io](https://plan.io/) — Project Management with Repository Hosting and mor options. Free for 2 users with 10 customers and 500MB Storage
   * [taskade.com](https://taskade.com/) — Real-time collaborative task lists and outlines for teams



## Storage and Media Processing

   * [aerofs.com](https://aerofs.com/) — P2P file syncing, free for up to 30 users
   * [bintray.com](https://bintray.com/) — Binary File storage, free for Open Source. Includes SSL, CDN and a limited number of REST calls
   * [cloudinary.com](http://cloudinary.com/) — Image upload, powerful manipulations, storage and delivery for sites and apps, with libraries for Ruby, Python, Java, PHP, Objective-C and more. Perpetual free tier includes 7,500 images/month, 2 GB storage, 5 GB bandwidth
   * [plot.ly](https://plot.ly/) — Graph and share your data. Free tier includes unlimited public files and 10 private files
   * [transloadit.com](https://transloadit.com/) — Handles file uploads and encoding of video, audio, images, documents. Free for Open Source and other do-gooders. Commercial applications get 1 GB free for test driving
   * [podio.com](https://podio.com/) — You can use Podio with a team of up to five people and try out the features of the Basic Plan, except users management
   * [shrinkray.io](https://shrinkray.io/) — Free image optimization of GitHub repos
   * [kraken.io](https://kraken.io/) — Image optimization for website performance as a service, free plan up to 1 MB file size
   * [placehold.it](https://placehold.it/) — A quick and simple image placeholder service
   * [placekitten.com](https://placekitten.com/) — A quick and simple service for getting pictures of kittens for use as placeholders
   * [embed.ly](http://embed.ly/) — Provides APIs for embedding media in a webpage, responsive image scaling, extracting elements from a webpage. Free for up to 5,000 URLs/month at 15 requests/second
   * [backhub.co](https://backhub.co/) — Backup and archive your GitHub repositories. Free for public repos
   * [otixo.com](http://otixo.com/) — Encrypt, share, copy and move all your cloud storage files from one place. Basic plan provides unlimited files transfer with 250 MB max. file size and allows 5 encrypted files
   * [tinypng.com](https://tinypng.com/) — API to compress and resize PNG and JPEG images, offers 500 compressions for free each month
   * [filestack.com](https://filestack.com/) — File picker, transform and deliver, free for 250 files, 500 transformations and 3 GB bandwidth
   * [packagecloud.io](https://packagecloud.io/) — Hosted Package Repositories for YUM, APT, RubyGem and PyPI.  Limited free plans, open source plans available via request
   * [image-charts.com](https://image-charts.com/) - Unlimited image chart generation with a watermark
   * [jsonbin.io](https://jsonbin.io/) - Free JSON data storage service, ideal for small-scale web apps, website, mobile apps.

## Design and UI

  * [pixlr.com](http://pixlr.com/) — Free online browser editor on the level of commercial ones
  * [imagebin.ca](http://imagebin.ca/) — Pastebin for images
  * [cloudconvert.com](https://cloudconvert.com/) — Convert anything to anything. 208 supported formats including videos to gif
  * [resizeappicon.com](https://resizeappicon.com/) — A simple service to resize and manage your app icons
  * [vectr.com](https://vectr.com/) — Free Design App For Web + Desktop
  * [walkme.com](https://www.walkme.com/) — Enterprise Class Guidance and Engagement Platform, free plan 3 walk-thrus up to 5 steps/walk
  * [marvelapp.com](https://marvelapp.com/) — Design, prototyping and collaboration, free limited for 3 projects
  * [Zeplin](https://zeplin.io/) — Designer and developer collaboration platform. Show designs, assets and styleguides. Free for 1 project.
  * [figma.com](https://figma.com) — Online, collaborative design tool for teams; free tier includes unlimited files and viewers with a max of 2 editors and 3 projects

## Data Visualization on Maps

   * [geocoder.opencagedata.com](https://geocoder.opencagedata.com/) — Geocoding API that aggregates OpenStreetMap and other open geo sources. 2,500 free queries/day
   * [datamaps.co](https://datamaps.co/) — a free platform for creating visualizations with data maps
   * [geocod.io](http://geocod.io/) — Geocoding via API or CSV Upload. 2,500 free queries/day
   * [gogeo.io](http://gogeo.io/) — Maps and geospatial services with an easy to use API and support for big data
   * [carto.com](https://carto.com/) — Create maps and geospatial APIs from your data and public data
   * [giscloud.com](http://giscloud.com/) — Visualize, analyze and share geo data online
   * [latlon.io](https://latlon.io/) — Geocoding API + school districts, census geography divisons and other address based data. 2,500 free requests/month
   * [mapbox.com](https://mapbox.com/) — Maps, geospatial services and SDKs for displaying map data
   * [osmnames](https://osmnames.org/) — Geocoding, search results ranked by the popularity of related Wikipedia page
   * [tilehosting](https://www.tilehosting.com/) — Vector maps, map services and SDKs for map visualisation. Free vector tiles with weekly update and four map styles.

## Package Build System

   * [build.opensuse.org](https://build.opensuse.org/) — Package build service for multiple distros (SUSE, EL, Fedora, Debian etc.)
   * [copr.fedoraproject.org](https://copr.fedoraproject.org/) — Mock-based RPM build service for Fedora and EL
   * [help.launchpad.net](https://help.launchpad.net/Packaging) — Ubuntu and Debian build service

## IDE and Code Editing

   * [c9.io](https://c9.io/) — IDE in a browser. Incorporates an Ubuntu virtual machine and in-browser terminal access. Integrates with GitHub and BitBucket, but also adds SFTP and generic Git access
   * [codeanywhere.com](https://codeanywhere.com/) — Full IDE in the browser and mobile apps. Access FTP, SFTP, Dropbox, Google Drive, GitHub and BitBucket. Hosted virtual machines with terminal access. Collaboration features like share links, live editing, permissions and version tracking (free tier includes 256MB RAM, 2GB HDD, 1 remote connection, no always on machine)
   * [codenvy.com](https://codenvy.com/) — IDE and automated developer workspaces in a browser, collaborative, Git/SVN integration, build and run your app in customizable Docker-based runners (free tier includes: 3 GB RAM, ability to run multiple machines simultaneously), pre-integrated deploy to Google Apps
   * [visualstudio.com](http://visualstudio.com/community) — Fully-featured IDE with thousands of extensions, cross-platform app development (Microsoft extensions available for download for iOS and Android), desktop, web and cloud development, multi-language support (C#, C++, JavaScript, Python, PHP and more)
   * [cocalc.com](https://cocalc.com/) (formerly SageMathCloud at cloud.sagemath.com) — Collaborative calculation in the cloud. Browser access to full Ubuntu with built-in collaboration and lots of free software for mathematics, science, data science, preinstalled: Python, LaTeX, Jupyter Notebooks, SageMath, scikitlearn, etc
   * [wakatime.com](https://wakatime.com/) — Quantified self-metrics about your coding activity, using text editor plugins, limited plan for free
   * [apiary.io](https://apiary.io/) — Collaborative design API with instant API mock and generated documentation (Free for unlimited API blueprints and unlimited user with one admin account and hosted documentation)
   * [mockable.io](https://www.mockable.io/) — Mockable is a simple configurable service to mock out RESTful API or SOAP web-services. This online service allows you to quickly define REST API or SOAP endpoints and have them return JSON or XML data
   * [jetbrains.com](https://jetbrains.com/products.html) — Productivity tools, IDEs and deploy tools. Free license for students, teachers, Open Source and user groups
   * [stackhive.com](http://stackhive.com/) — Cloud-based IDE in browser that supports HTML5/CSS3/jQuery/Bootstrap
   * [tadpoledb.com](http://tadpoledb.com/) — IDE in browser Database tool. Support Amazon RDS, Apache Hive, Apache Tajo, CUBRID, MariaDB, MySQL, Oracle, SQLite, MSSQL, PostgreSQL and MongoDB databases
   * [codepen.io](https://codepen.io/) — CodePen is a playground for the front end side of the web
   * [repl.it](https://repl.it/) — A cloud coding environment for various program languages
   * [codesandbox.io](https://codesandbox.io/) — Online React playground
   * [stackblitz.com](https://stackblitz.com/) — Online VS Code IDE for Angular & React


## Analytics, Events and Statistics

   * [analytics.google.com](https://analytics.google.com/) — Google Analytics
   * [heapanalytics.com](https://heapanalytics.com/) — Automatically captures every user action in iOS or web apps. Free for up to 5,000 visits/month
   * [sematext.com](https://sematext.com//search-analytics) — Free for up to 50 K actions/month, 1 day data retention, unlimited dashboards, users, etc
   * [usabilityhub.com](https://usabilityhub.com/) — Test designs and mockups on real people, track visitors. Free for one user, unlimited tests
   * [gosquared.com](https://gosquared.com/) — Track up to 1,000 data points for free
   * [mixpanel.com](https://mixpanel.com/) — Free 25,000 points or 200,000 with their badge on your site
   * [amplitude.com](https://amplitude.com/) — 1 million monthly events, up to 2 apps
   * [keen.io](https://keen.io/) — Custom Analytics for data collection, analysis and visualization. 50,000 events/month free
   * [metrica.yandex.com](https://metrica.yandex.com/) — Unlimited free analytics
   * [hotjar.com](https://hotjar.com/) — Per site: 2,000 pages views/day, 3 heatmaps, data stored for 3 months,...
   * [imprace.com](http://imprace.com/) — Landing page analysis with suggestions to improve bounce rates. Free 5 landing pages/domain
   * [baremetrics.com](https://baremetrics.com/) — Analytics and Insights for stripe
   * [optimizely.com](https://optimizely.com) — A/B Testing solution, free starter plan, 1 website, 1 iOS and 1 Android app
   * [expensify.com](https://expensify.com/) — Expense reporting, free personal reporting approval workflow
   * [ironSource atom](http://www.ironsrc.com/data-flow-management/) — Atom Data Flow Management is a data pipeline solution, 10 million monthly events free
   * [botan.io](http://botan.io/) — Free analytics for your Telegram bot

## Visitor Session Recording
   * [inspectlet.com](http://inspectlet.com/) — 100 sessions/month free for 1 website
   * [mousestats.com](https://mousestats.com/) — 100 sessions/month free for 1 website
   * [hotjar.com](https://hotjar.com/) — Per site: 2,000 pages views/day, 3 heatmaps, data stored for 3 months,...
   * [getWisdom.io](https://getWisdom.io/?ref=github) — 100 visitors/month, with unlimited page views, domains, and live-view.
   * [usersurge.com](http://www.usersurge.com/) — 250K sessions per month for individuals.


## International Mobile Number Verification API and SDK
  * [cognalys.com](https://cognalys.com/) — Freemium mobile number verification through an innovative and reliable method than using SMS gateway. Free 10 tries and 15 verifications/day
  * [numverify.com](https://numverify.com/) — Global phone number validation and lookup JSON API. 250 API requests/month
  * [sumome.com](https://sumome.com/) — Heat map and conversion enhancement tools, free without few advanced features

## Payment / Billing Integration

  * [braintreepayments.com](https://braintreepayments.com/) — Credit Card, Paypal, Venmo, Bitcoin, Apple Pay,... integration. Single and Recurrent Payments. First USD 50,000 free
  * [taxratesapi.avalara.com](http://taxratesapi.avalara.com/) — Get the right sales tax rates to charge for the close to 10,000 sales tax jurisdictions in the USA. Free REST API. Registration required
  * [currencylayer.com](https://currencylayer.com/) — Reliable Exchange Rates and Currency Conversion for your Business, 1,000 API requests/month free
  * [vatlayer.com](https://vatlayer.com/) — Instant VAT number validation and EU VAT rates API, free 100 API requests/month
  * [fraudlabspro.com](https://www.fraudlabspro.com) - Help merchants to prevent payment fraud and chargebacks. Free Micro Plan available with 500 queries/month.

## Docker Related

  * [openshift.com](https://www.openshift.com/) —  Container platform based on Docker and Kubernetes. Free for 2 vCPU, 1GiB Memory, 1GiB Storage.
  * [Docker Cloud](https://cloud.docker.com) — Manages the deployments of Docker containers to your (separate) cloud environment with one free repository
  * [Docker Hub](https://hub.docker.com) — One free private repository and unlimited public repositories to build and store Docker images
  * [quay.io](https://quay.io/) — Build and store container images with unlimited free public repositories
  * [canister.io](https://canister.io/) — 20 free private repositories for developers, 30 free private repositories for teams to build and store Docker images
  * [Whales](https://github.com/Gueils/whales) - A tool to automatically dockerize your applications for free.

## Vagrant Related

  * [atlas.hashicorp.com](https://atlas.hashicorp.com/boxes/search) — HashiCorp's index of boxes
  * [vagrantbox.es](http://vagrantbox.es/) — An alternative public box index

## Miscellaneous
  * [apichangelog.com](https://apichangelog.com/) — Subscribe to be notified each time API Documentation is updated (Facebook, Twitter, Google,...)
  * [docsapp.io](https://www.docsapp.io/) — Easiest way to publish documentation, free for Open Source
  * [instadiff.com](http://www.instadiff.com/) — Compare website versions with highlighted changes before you deploy, free for 100 pages/month
  * [fullcontact.com](https://fullcontact.com/developer/pricing/) — Help your users know more about their contacts by adding social profile into your app. 500 free Person API matches/month
  * [formlets.com](https://formlets.com/) — Online forms, unlimited single page forms/month, 100 submissions/month, email notifications
  * [superfeedr.com](https://superfeedr.com/) — Real-time PubSubHubbub compliant feeds, export, analytics. Free with less customization
  * [screenshotlayer.com](https://screenshotlayer.com/) — Capture highly customizable snapshots of any website. Free 100 snapshots/month
  * [screenshotmachine.com](https://screenshotmachine.com/) — Capture 100 snapshots/month, png, gif and jpg, including full-length captures, not only home page
  * [readme.io](https://readme.io/) — Beautiful documentation made easy, free for Open Source
  * [formaholic.com](https://formaholic.com) — Simple form endpoint. Perfect for static sites
  * [http2.pro](https://http2.pro) — HTTP/2 protocol readiness test and client HTTP/2 support detection API.
  * [Formspree.io](https://formspree.io/) — Send email using an HTTP POST request. Free tier limits to 1000 submissions per month and must expose email address in the API call.
  * [Typeform.com](https://www.typeform.com/) — Include beautifully designed forms on websites.  Free plan allows only 10 fields per form and 100 responses per month.
  * [SurveyMonkey.com](https://www.surveymonkey.com) — Create online surveys. Analyze the results online.  Free plan allows only 10 questions and 100 responses per survey.

## APIs, Data and ML

  * [dreamfactory.com](http://dreamfactory.com/) — Open source REST API backend for mobile, web, and IoT applications. Hook up any SQL/NoSQL database, file storage system, or external service and it instantly creates a comprehensive REST API platform with live documentation, user management,...
  * [monkeylearn.com](http://monkeylearn.com/) — Text analysis with machine learning, free 100,000 queries/month
  * [wit.ai](https://wit.ai/) — NLP for developers
  * [wolfram.com](https://wolfram.com/language/) — Built-in knowledge-based algorithms in the cloud
  * [parsehub.com](https://parsehub.com/) — Extract data from dynamic sites, turn dynamic websites into APIs, 5 projects free
  * [import.io](https://import.io/) — Easily turn websites into APIs, completely free for life
  * [wrapapi.com](https://wrapapi.com/) — Turn any website into a parameterized API
  * [algorithmia.com](https://algorithmia.com/) — Host algorithms for free. Includes free monthly allowance for running algorithms. Now with CLI support
  * [bigml.com](https://bigml.com/) — Hosted machine learning algorithms. Unlimited free tasks for development, limit of 16 MB data/task
  * [mashape.com](https://www.mashape.com/) — API Marketplace and powerful tools for private and public APIs. With the free tier, some features are limited such as monitoring, alerting and support
  * [dominodatalab.com](https://www.dominodatalab.com) — Data science with support for Python, R, Spark, Hadoop, Matlab and others
  * [havenondemand.com](https://www.havenondemand.com) — APIs for machine learning
  * [restlet.com](http://restlet.com/products/apispark/) — APISpark enables any API, application or data owner to become an API provider in minutes via an intuitive browser interface
  * [scrapinghub.com](http://scrapinghub.com) — Data scraping with visual interface and plugins. Free plan includes unlimited scraping on a shared server
  * [context.io](https://context.io) — Create simple email webhooks and code against a free, RESTful, IMAP API to leverage email data
  * [cloudrail.com](https://cloudrail.com) — API integration solution. Unified interfaces for multiple web APIs, API change management
  * [Meya.ai](https://meya.ai) — Create and deploy a chatbot.  Free tier allows only 1 bot.
  * [RequestBin](https://requestb.in) — Inspect and debug HTTP POST requests from an HTTP client.
  * [Apify](https://www.apify.com/) — Web scraping and automation platform that lets you create an API extracting websites data. Free tier with 10k monthly crawls and 7 days data retention.

## Other Free Resources
  * [github.com - FOSS for Dev](https://github.com/httpsGithubParty/FOSS-for-Dev) — A hub of free and Open Source software for developers
  * [github.com - Free for nonprofit](https://github.com/pborreli/free-for-nonprofit) — List of free services for nonprofit organizations
  * [getawesomeness](https://getawesomeness.herokuapp.com) — Retrieve all amazing awesomeness from GitHub... a must see
  * [education.github.com](https://education.github.com/pack) — Collection of free services for students. Registration required
