package security

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/gofrs/uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/security/mgmt/v3.0/security"

// AadConnectivityState1 describes an Azure resource with kind
type AadConnectivityState1 struct {
	// ConnectivityState - Possible values include: 'Discovered', 'NotLicensed', 'Connected'
	ConnectivityState AadConnectivityState `json:"connectivityState,omitempty"`
}

// AadExternalSecuritySolution represents an AAD identity protection solution which sends logs to an OMS
// workspace.
type AadExternalSecuritySolution struct {
	Properties *AadSolutionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty"`
	// Kind - Possible values include: 'KindExternalSecuritySolution', 'KindCEF', 'KindATA', 'KindAAD'
	Kind KindEnum `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AadExternalSecuritySolution.
func (aess AadExternalSecuritySolution) MarshalJSON() ([]byte, error) {
	aess.Kind = KindAAD
	objectMap := make(map[string]interface{})
	if aess.Properties != nil {
		objectMap["properties"] = aess.Properties
	}
	if aess.Kind != "" {
		objectMap["kind"] = aess.Kind
	}
	return json.Marshal(objectMap)
}

// AsCefExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AadExternalSecuritySolution.
func (aess AadExternalSecuritySolution) AsCefExternalSecuritySolution() (*CefExternalSecuritySolution, bool) {
	return nil, false
}

// AsAtaExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AadExternalSecuritySolution.
func (aess AadExternalSecuritySolution) AsAtaExternalSecuritySolution() (*AtaExternalSecuritySolution, bool) {
	return nil, false
}

// AsAadExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AadExternalSecuritySolution.
func (aess AadExternalSecuritySolution) AsAadExternalSecuritySolution() (*AadExternalSecuritySolution, bool) {
	return &aess, true
}

// AsExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AadExternalSecuritySolution.
func (aess AadExternalSecuritySolution) AsExternalSecuritySolution() (*ExternalSecuritySolution, bool) {
	return nil, false
}

// AsBasicExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AadExternalSecuritySolution.
func (aess AadExternalSecuritySolution) AsBasicExternalSecuritySolution() (BasicExternalSecuritySolution, bool) {
	return &aess, true
}

// AadSolutionProperties ...
type AadSolutionProperties struct {
	DeviceVendor *string             `json:"deviceVendor,omitempty"`
	DeviceType   *string             `json:"deviceType,omitempty"`
	Workspace    *ConnectedWorkspace `json:"workspace,omitempty"`
	// ConnectivityState - Possible values include: 'Discovered', 'NotLicensed', 'Connected'
	ConnectivityState AadConnectivityState `json:"connectivityState,omitempty"`
}

// ActiveConnectionsNotInAllowedRange number of active connections is not in allowed range.
type ActiveConnectionsNotInAllowedRange struct {
	// TimeWindowSize - The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeConnectionFromIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) MarshalJSON() ([]byte, error) {
	acniar.RuleType = RuleTypeActiveConnectionsNotInAllowedRange
	objectMap := make(map[string]interface{})
	if acniar.TimeWindowSize != nil {
		objectMap["timeWindowSize"] = acniar.TimeWindowSize
	}
	if acniar.MinThreshold != nil {
		objectMap["minThreshold"] = acniar.MinThreshold
	}
	if acniar.MaxThreshold != nil {
		objectMap["maxThreshold"] = acniar.MaxThreshold
	}
	if acniar.IsEnabled != nil {
		objectMap["isEnabled"] = acniar.IsEnabled
	}
	if acniar.RuleType != "" {
		objectMap["ruleType"] = acniar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return &acniar, true
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return &acniar, true
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsConnectionFromIPNotAllowed is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsConnectionFromIPNotAllowed() (*ConnectionFromIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return &acniar, true
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for ActiveConnectionsNotInAllowedRange.
func (acniar ActiveConnectionsNotInAllowedRange) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &acniar, true
}

// AdaptiveApplicationControlGroup ...
type AdaptiveApplicationControlGroup struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Location where the resource is stored
	Location                             *string `json:"location,omitempty"`
	*AdaptiveApplicationControlGroupData `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AdaptiveApplicationControlGroup.
func (aacg AdaptiveApplicationControlGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aacg.AdaptiveApplicationControlGroupData != nil {
		objectMap["properties"] = aacg.AdaptiveApplicationControlGroupData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AdaptiveApplicationControlGroup struct.
func (aacg *AdaptiveApplicationControlGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				aacg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				aacg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				aacg.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				aacg.Location = &location
			}
		case "properties":
			if v != nil {
				var adaptiveApplicationControlGroupData AdaptiveApplicationControlGroupData
				err = json.Unmarshal(*v, &adaptiveApplicationControlGroupData)
				if err != nil {
					return err
				}
				aacg.AdaptiveApplicationControlGroupData = &adaptiveApplicationControlGroupData
			}
		}
	}

	return nil
}

// AdaptiveApplicationControlGroupData represents a machines group and set of rules to be allowed running
// on a machine
type AdaptiveApplicationControlGroupData struct {
	// EnforcementMode - Possible values include: 'EnforcementModeAudit', 'EnforcementModeEnforce', 'EnforcementModeNone'
	EnforcementMode EnforcementMode `json:"enforcementMode,omitempty"`
	ProtectionMode  *ProtectionMode `json:"protectionMode,omitempty"`
	// ConfigurationStatus - READ-ONLY; Possible values include: 'ConfigurationStatus2Configured', 'ConfigurationStatus2NotConfigured', 'ConfigurationStatus2InProgress', 'ConfigurationStatus2Failed', 'ConfigurationStatus2NoStatus'
	ConfigurationStatus ConfigurationStatus2 `json:"configurationStatus,omitempty"`
	// RecommendationStatus - READ-ONLY; Possible values include: 'RecommendationStatusRecommended', 'RecommendationStatusNotRecommended', 'RecommendationStatusNotAvailable', 'RecommendationStatusNoStatus'
	RecommendationStatus RecommendationStatus `json:"recommendationStatus,omitempty"`
	// Issues - READ-ONLY
	Issues *[]AdaptiveApplicationControlIssueSummary `json:"issues,omitempty"`
	// SourceSystem - READ-ONLY; Possible values include: 'SourceSystemAzureAppLocker', 'SourceSystemAzureAuditD', 'SourceSystemNonAzureAppLocker', 'SourceSystemNonAzureAuditD', 'SourceSystemNone'
	SourceSystem        SourceSystem          `json:"sourceSystem,omitempty"`
	VMRecommendations   *[]VMRecommendation   `json:"vmRecommendations,omitempty"`
	PathRecommendations *[]PathRecommendation `json:"pathRecommendations,omitempty"`
}

// MarshalJSON is the custom marshaler for AdaptiveApplicationControlGroupData.
func (aacgd AdaptiveApplicationControlGroupData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aacgd.EnforcementMode != "" {
		objectMap["enforcementMode"] = aacgd.EnforcementMode
	}
	if aacgd.ProtectionMode != nil {
		objectMap["protectionMode"] = aacgd.ProtectionMode
	}
	if aacgd.VMRecommendations != nil {
		objectMap["vmRecommendations"] = aacgd.VMRecommendations
	}
	if aacgd.PathRecommendations != nil {
		objectMap["pathRecommendations"] = aacgd.PathRecommendations
	}
	return json.Marshal(objectMap)
}

// AdaptiveApplicationControlGroups represents a list of VM/server groups and set of rules that are
// Recommended by Microsoft Defender for Cloud to be allowed
type AdaptiveApplicationControlGroups struct {
	autorest.Response `json:"-"`
	Value             *[]AdaptiveApplicationControlGroup `json:"value,omitempty"`
}

// AdaptiveApplicationControlIssueSummary represents a summary of the alerts of the machine group
type AdaptiveApplicationControlIssueSummary struct {
	// Issue - Possible values include: 'ViolationsAudited', 'ViolationsBlocked', 'MsiAndScriptViolationsAudited', 'MsiAndScriptViolationsBlocked', 'ExecutableViolationsAudited', 'RulesViolatedManually'
	Issue Issue `json:"issue,omitempty"`
	// NumberOfVms - The number of machines in the group that have this alert
	NumberOfVms *float64 `json:"numberOfVms,omitempty"`
}

// AdaptiveNetworkHardening the resource whose properties describes the Adaptive Network Hardening settings
// for some Azure resource
type AdaptiveNetworkHardening struct {
	autorest.Response `json:"-"`
	// AdaptiveNetworkHardeningProperties - Properties of the Adaptive Network Hardening resource
	*AdaptiveNetworkHardeningProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AdaptiveNetworkHardening.
func (anh AdaptiveNetworkHardening) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if anh.AdaptiveNetworkHardeningProperties != nil {
		objectMap["properties"] = anh.AdaptiveNetworkHardeningProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AdaptiveNetworkHardening struct.
func (anh *AdaptiveNetworkHardening) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var adaptiveNetworkHardeningProperties AdaptiveNetworkHardeningProperties
				err = json.Unmarshal(*v, &adaptiveNetworkHardeningProperties)
				if err != nil {
					return err
				}
				anh.AdaptiveNetworkHardeningProperties = &adaptiveNetworkHardeningProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				anh.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				anh.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				anh.Type = &typeVar
			}
		}
	}

	return nil
}

// AdaptiveNetworkHardeningEnforceRequest ...
type AdaptiveNetworkHardeningEnforceRequest struct {
	// Rules - The rules to enforce
	Rules *[]Rule `json:"rules,omitempty"`
	// NetworkSecurityGroups - The Azure resource IDs of the effective network security groups that will be updated with the created security rules from the Adaptive Network Hardening rules
	NetworkSecurityGroups *[]string `json:"networkSecurityGroups,omitempty"`
}

// AdaptiveNetworkHardeningProperties adaptive Network Hardening resource properties
type AdaptiveNetworkHardeningProperties struct {
	// Rules - The security rules which are recommended to be effective on the VM
	Rules *[]Rule `json:"rules,omitempty"`
	// RulesCalculationTime - The UTC time on which the rules were calculated
	RulesCalculationTime *date.Time `json:"rulesCalculationTime,omitempty"`
	// EffectiveNetworkSecurityGroups - The Network Security Groups effective on the network interfaces of the protected resource
	EffectiveNetworkSecurityGroups *[]EffectiveNetworkSecurityGroups `json:"effectiveNetworkSecurityGroups,omitempty"`
}

// AdaptiveNetworkHardeningsEnforceFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AdaptiveNetworkHardeningsEnforceFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AdaptiveNetworkHardeningsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AdaptiveNetworkHardeningsEnforceFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AdaptiveNetworkHardeningsEnforceFuture.Result.
func (future *AdaptiveNetworkHardeningsEnforceFuture) result(client AdaptiveNetworkHardeningsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AdaptiveNetworkHardeningsEnforceFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("security.AdaptiveNetworkHardeningsEnforceFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// AdaptiveNetworkHardeningsList response for ListAdaptiveNetworkHardenings API service call
type AdaptiveNetworkHardeningsList struct {
	autorest.Response `json:"-"`
	// Value - A list of Adaptive Network Hardenings resources
	Value *[]AdaptiveNetworkHardening `json:"value,omitempty"`
	// NextLink - The URL to get the next set of results
	NextLink *string `json:"nextLink,omitempty"`
}

// AdaptiveNetworkHardeningsListIterator provides access to a complete listing of AdaptiveNetworkHardening
// values.
type AdaptiveNetworkHardeningsListIterator struct {
	i    int
	page AdaptiveNetworkHardeningsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AdaptiveNetworkHardeningsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AdaptiveNetworkHardeningsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AdaptiveNetworkHardeningsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AdaptiveNetworkHardeningsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AdaptiveNetworkHardeningsListIterator) Response() AdaptiveNetworkHardeningsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AdaptiveNetworkHardeningsListIterator) Value() AdaptiveNetworkHardening {
	if !iter.page.NotDone() {
		return AdaptiveNetworkHardening{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AdaptiveNetworkHardeningsListIterator type.
func NewAdaptiveNetworkHardeningsListIterator(page AdaptiveNetworkHardeningsListPage) AdaptiveNetworkHardeningsListIterator {
	return AdaptiveNetworkHardeningsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (anhl AdaptiveNetworkHardeningsList) IsEmpty() bool {
	return anhl.Value == nil || len(*anhl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (anhl AdaptiveNetworkHardeningsList) hasNextLink() bool {
	return anhl.NextLink != nil && len(*anhl.NextLink) != 0
}

// adaptiveNetworkHardeningsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (anhl AdaptiveNetworkHardeningsList) adaptiveNetworkHardeningsListPreparer(ctx context.Context) (*http.Request, error) {
	if !anhl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(anhl.NextLink)))
}

// AdaptiveNetworkHardeningsListPage contains a page of AdaptiveNetworkHardening values.
type AdaptiveNetworkHardeningsListPage struct {
	fn   func(context.Context, AdaptiveNetworkHardeningsList) (AdaptiveNetworkHardeningsList, error)
	anhl AdaptiveNetworkHardeningsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AdaptiveNetworkHardeningsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AdaptiveNetworkHardeningsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.anhl)
		if err != nil {
			return err
		}
		page.anhl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AdaptiveNetworkHardeningsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AdaptiveNetworkHardeningsListPage) NotDone() bool {
	return !page.anhl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AdaptiveNetworkHardeningsListPage) Response() AdaptiveNetworkHardeningsList {
	return page.anhl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AdaptiveNetworkHardeningsListPage) Values() []AdaptiveNetworkHardening {
	if page.anhl.IsEmpty() {
		return nil
	}
	return *page.anhl.Value
}

// Creates a new instance of the AdaptiveNetworkHardeningsListPage type.
func NewAdaptiveNetworkHardeningsListPage(cur AdaptiveNetworkHardeningsList, getNextPage func(context.Context, AdaptiveNetworkHardeningsList) (AdaptiveNetworkHardeningsList, error)) AdaptiveNetworkHardeningsListPage {
	return AdaptiveNetworkHardeningsListPage{
		fn:   getNextPage,
		anhl: cur,
	}
}

// BasicAdditionalData details of the sub-assessment
type BasicAdditionalData interface {
	AsSQLServerVulnerabilityProperties() (*SQLServerVulnerabilityProperties, bool)
	AsContainerRegistryVulnerabilityProperties() (*ContainerRegistryVulnerabilityProperties, bool)
	AsServerVulnerabilityProperties() (*ServerVulnerabilityProperties, bool)
	AsAdditionalData() (*AdditionalData, bool)
}

// AdditionalData details of the sub-assessment
type AdditionalData struct {
	// AssessedResourceType - Possible values include: 'AssessedResourceTypeAdditionalData', 'AssessedResourceTypeSQLServerVulnerability', 'AssessedResourceTypeContainerRegistryVulnerability', 'AssessedResourceTypeServerVulnerabilityAssessment'
	AssessedResourceType AssessedResourceType `json:"assessedResourceType,omitempty"`
}

func unmarshalBasicAdditionalData(body []byte) (BasicAdditionalData, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["assessedResourceType"] {
	case string(AssessedResourceTypeSQLServerVulnerability):
		var ssvp SQLServerVulnerabilityProperties
		err := json.Unmarshal(body, &ssvp)
		return ssvp, err
	case string(AssessedResourceTypeContainerRegistryVulnerability):
		var crvp ContainerRegistryVulnerabilityProperties
		err := json.Unmarshal(body, &crvp)
		return crvp, err
	case string(AssessedResourceTypeServerVulnerabilityAssessment):
		var svp ServerVulnerabilityProperties
		err := json.Unmarshal(body, &svp)
		return svp, err
	default:
		var ad AdditionalData
		err := json.Unmarshal(body, &ad)
		return ad, err
	}
}
func unmarshalBasicAdditionalDataArray(body []byte) ([]BasicAdditionalData, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	adArray := make([]BasicAdditionalData, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ad, err := unmarshalBasicAdditionalData(*rawMessage)
		if err != nil {
			return nil, err
		}
		adArray[index] = ad
	}
	return adArray, nil
}

// MarshalJSON is the custom marshaler for AdditionalData.
func (ad AdditionalData) MarshalJSON() ([]byte, error) {
	ad.AssessedResourceType = AssessedResourceTypeAdditionalData
	objectMap := make(map[string]interface{})
	if ad.AssessedResourceType != "" {
		objectMap["assessedResourceType"] = ad.AssessedResourceType
	}
	return json.Marshal(objectMap)
}

// AsSQLServerVulnerabilityProperties is the BasicAdditionalData implementation for AdditionalData.
func (ad AdditionalData) AsSQLServerVulnerabilityProperties() (*SQLServerVulnerabilityProperties, bool) {
	return nil, false
}

// AsContainerRegistryVulnerabilityProperties is the BasicAdditionalData implementation for AdditionalData.
func (ad AdditionalData) AsContainerRegistryVulnerabilityProperties() (*ContainerRegistryVulnerabilityProperties, bool) {
	return nil, false
}

// AsServerVulnerabilityProperties is the BasicAdditionalData implementation for AdditionalData.
func (ad AdditionalData) AsServerVulnerabilityProperties() (*ServerVulnerabilityProperties, bool) {
	return nil, false
}

// AsAdditionalData is the BasicAdditionalData implementation for AdditionalData.
func (ad AdditionalData) AsAdditionalData() (*AdditionalData, bool) {
	return &ad, true
}

// AsBasicAdditionalData is the BasicAdditionalData implementation for AdditionalData.
func (ad AdditionalData) AsBasicAdditionalData() (BasicAdditionalData, bool) {
	return &ad, true
}

// AdditionalWorkspacesProperties properties of the additional workspaces.
type AdditionalWorkspacesProperties struct {
	// Workspace - Workspace resource id
	Workspace *string `json:"workspace,omitempty"`
	// Type - Workspace type. Possible values include: 'Sentinel'
	Type AdditionalWorkspaceType `json:"type,omitempty"`
	// DataTypes - List of data types sent to workspace
	DataTypes *[]AdditionalWorkspaceDataType `json:"dataTypes,omitempty"`
}

// AdvancedThreatProtectionProperties the Advanced Threat Protection settings.
type AdvancedThreatProtectionProperties struct {
	// IsEnabled - Indicates whether Advanced Threat Protection is enabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// AdvancedThreatProtectionSetting the Advanced Threat Protection resource.
type AdvancedThreatProtectionSetting struct {
	autorest.Response                   `json:"-"`
	*AdvancedThreatProtectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AdvancedThreatProtectionSetting.
func (atps AdvancedThreatProtectionSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if atps.AdvancedThreatProtectionProperties != nil {
		objectMap["properties"] = atps.AdvancedThreatProtectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AdvancedThreatProtectionSetting struct.
func (atps *AdvancedThreatProtectionSetting) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var advancedThreatProtectionProperties AdvancedThreatProtectionProperties
				err = json.Unmarshal(*v, &advancedThreatProtectionProperties)
				if err != nil {
					return err
				}
				atps.AdvancedThreatProtectionProperties = &advancedThreatProtectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				atps.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				atps.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				atps.Type = &typeVar
			}
		}
	}

	return nil
}

// Alert security alert
type Alert struct {
	autorest.Response `json:"-"`
	// AlertProperties - describes security alert properties.
	*AlertProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Alert.
func (a Alert) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.AlertProperties != nil {
		objectMap["properties"] = a.AlertProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Alert struct.
func (a *Alert) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var alertProperties AlertProperties
				err = json.Unmarshal(*v, &alertProperties)
				if err != nil {
					return err
				}
				a.AlertProperties = &alertProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		}
	}

	return nil
}

// AlertEntity changing set of properties depending on the entity type.
type AlertEntity struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Type - READ-ONLY; Type of entity
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertEntity.
func (ae AlertEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	for k, v := range ae.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AlertEntity struct.
func (ae *AlertEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if ae.AdditionalProperties == nil {
					ae.AdditionalProperties = make(map[string]interface{})
				}
				ae.AdditionalProperties[k] = additionalProperties
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ae.Type = &typeVar
			}
		}
	}

	return nil
}

// AlertList list of security alerts
type AlertList struct {
	autorest.Response `json:"-"`
	// Value - describes security alert properties.
	Value *[]Alert `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertList.
func (al AlertList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if al.Value != nil {
		objectMap["value"] = al.Value
	}
	return json.Marshal(objectMap)
}

// AlertListIterator provides access to a complete listing of Alert values.
type AlertListIterator struct {
	i    int
	page AlertListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AlertListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AlertListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AlertListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AlertListIterator) Response() AlertList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AlertListIterator) Value() Alert {
	if !iter.page.NotDone() {
		return Alert{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AlertListIterator type.
func NewAlertListIterator(page AlertListPage) AlertListIterator {
	return AlertListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (al AlertList) IsEmpty() bool {
	return al.Value == nil || len(*al.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (al AlertList) hasNextLink() bool {
	return al.NextLink != nil && len(*al.NextLink) != 0
}

// alertListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (al AlertList) alertListPreparer(ctx context.Context) (*http.Request, error) {
	if !al.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(al.NextLink)))
}

// AlertListPage contains a page of Alert values.
type AlertListPage struct {
	fn func(context.Context, AlertList) (AlertList, error)
	al AlertList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AlertListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.al)
		if err != nil {
			return err
		}
		page.al = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AlertListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AlertListPage) NotDone() bool {
	return !page.al.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AlertListPage) Response() AlertList {
	return page.al
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AlertListPage) Values() []Alert {
	if page.al.IsEmpty() {
		return nil
	}
	return *page.al.Value
}

// Creates a new instance of the AlertListPage type.
func NewAlertListPage(cur AlertList, getNextPage func(context.Context, AlertList) (AlertList, error)) AlertListPage {
	return AlertListPage{
		fn: getNextPage,
		al: cur,
	}
}

// AlertProperties describes security alert properties.
type AlertProperties struct {
	// Version - READ-ONLY; Schema version.
	Version *string `json:"version,omitempty"`
	// AlertType - READ-ONLY; Unique identifier for the detection logic (all alert instances from the same detection logic will have the same alertType).
	AlertType *string `json:"alertType,omitempty"`
	// SystemAlertID - READ-ONLY; Unique identifier for the alert.
	SystemAlertID *string `json:"systemAlertId,omitempty"`
	// ProductComponentName - READ-ONLY; The name of Azure Security Center pricing tier which powering this alert. Learn more: https://docs.microsoft.com/en-us/azure/security-center/security-center-pricing
	ProductComponentName *string `json:"productComponentName,omitempty"`
	// AlertDisplayName - READ-ONLY; The display name of the alert.
	AlertDisplayName *string `json:"alertDisplayName,omitempty"`
	// Description - READ-ONLY; Description of the suspicious activity that was detected.
	Description *string `json:"description,omitempty"`
	// Severity - READ-ONLY; The risk level of the threat that was detected. Learn more: https://docs.microsoft.com/en-us/azure/security-center/security-center-alerts-overview#how-are-alerts-classified. Possible values include: 'Informational', 'Low', 'Medium', 'High'
	Severity AlertSeverity `json:"severity,omitempty"`
	// Intent - READ-ONLY; The kill chain related intent behind the alert. For list of supported values, and explanations of Azure Security Center's supported kill chain intents. Possible values include: 'IntentUnknown', 'IntentPreAttack', 'IntentInitialAccess', 'IntentPersistence', 'IntentPrivilegeEscalation', 'IntentDefenseEvasion', 'IntentCredentialAccess', 'IntentDiscovery', 'IntentLateralMovement', 'IntentExecution', 'IntentCollection', 'IntentExfiltration', 'IntentCommandAndControl', 'IntentImpact', 'IntentProbing', 'IntentExploitation'
	Intent Intent `json:"intent,omitempty"`
	// StartTimeUtc - READ-ONLY; The UTC time of the first event or activity included in the alert in ISO8601 format.
	StartTimeUtc *date.Time `json:"startTimeUtc,omitempty"`
	// EndTimeUtc - READ-ONLY; The UTC time of the last event or activity included in the alert in ISO8601 format.
	EndTimeUtc *date.Time `json:"endTimeUtc,omitempty"`
	// ResourceIdentifiers - READ-ONLY; The resource identifiers that can be used to direct the alert to the right product exposure group (tenant, workspace, subscription etc.). There can be multiple identifiers of different type per alert.
	ResourceIdentifiers *[]BasicResourceIdentifier `json:"resourceIdentifiers,omitempty"`
	// RemediationSteps - READ-ONLY; Manual action items to take to remediate the alert.
	RemediationSteps *[]string `json:"remediationSteps,omitempty"`
	// VendorName - READ-ONLY; The name of the vendor that raises the alert.
	VendorName *string `json:"vendorName,omitempty"`
	// Status - READ-ONLY; The life cycle status of the alert. Possible values include: 'Active', 'InProgress', 'Resolved', 'Dismissed'
	Status AlertStatus `json:"status,omitempty"`
	// ExtendedLinks - READ-ONLY; Links related to the alert
	ExtendedLinks *[]map[string]*string `json:"extendedLinks,omitempty"`
	// AlertURI - READ-ONLY; A direct link to the alert page in Azure Portal.
	AlertURI *string `json:"alertUri,omitempty"`
	// TimeGeneratedUtc - READ-ONLY; The UTC time the alert was generated in ISO8601 format.
	TimeGeneratedUtc *date.Time `json:"timeGeneratedUtc,omitempty"`
	// ProductName - READ-ONLY; The name of the product which published this alert (Azure Security Center, Azure ATP, Microsoft Defender ATP, O365 ATP, MCAS, and so on).
	ProductName *string `json:"productName,omitempty"`
	// ProcessingEndTimeUtc - READ-ONLY; The UTC processing end time of the alert in ISO8601 format.
	ProcessingEndTimeUtc *date.Time `json:"processingEndTimeUtc,omitempty"`
	// Entities - READ-ONLY; A list of entities related to the alert.
	Entities *[]AlertEntity `json:"entities,omitempty"`
	// IsIncident - READ-ONLY; This field determines whether the alert is an incident (a compound grouping of several alerts) or a single alert.
	IsIncident *bool `json:"isIncident,omitempty"`
	// CorrelationKey - READ-ONLY; Key for corelating related alerts. Alerts with the same correlation key considered to be related.
	CorrelationKey *string `json:"correlationKey,omitempty"`
	// ExtendedProperties - Custom properties for the alert.
	ExtendedProperties map[string]*string `json:"extendedProperties"`
	// CompromisedEntity - READ-ONLY; The display name of the resource most related to this alert.
	CompromisedEntity *string `json:"compromisedEntity,omitempty"`
	// Techniques - READ-ONLY; kill chain related techniques behind the alert.
	Techniques *[]string `json:"techniques,omitempty"`
	// SubTechniques - READ-ONLY; Kill chain related sub-techniques behind the alert.
	SubTechniques *[]string `json:"subTechniques,omitempty"`
	// SupportingEvidence - Changing set of properties depending on the supportingEvidence type.
	SupportingEvidence *AlertPropertiesSupportingEvidence `json:"supportingEvidence,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertProperties.
func (ap AlertProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.ExtendedProperties != nil {
		objectMap["extendedProperties"] = ap.ExtendedProperties
	}
	if ap.SupportingEvidence != nil {
		objectMap["supportingEvidence"] = ap.SupportingEvidence
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AlertProperties struct.
func (ap *AlertProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "version":
			if v != nil {
				var version string
				err = json.Unmarshal(*v, &version)
				if err != nil {
					return err
				}
				ap.Version = &version
			}
		case "alertType":
			if v != nil {
				var alertType string
				err = json.Unmarshal(*v, &alertType)
				if err != nil {
					return err
				}
				ap.AlertType = &alertType
			}
		case "systemAlertId":
			if v != nil {
				var systemAlertID string
				err = json.Unmarshal(*v, &systemAlertID)
				if err != nil {
					return err
				}
				ap.SystemAlertID = &systemAlertID
			}
		case "productComponentName":
			if v != nil {
				var productComponentName string
				err = json.Unmarshal(*v, &productComponentName)
				if err != nil {
					return err
				}
				ap.ProductComponentName = &productComponentName
			}
		case "alertDisplayName":
			if v != nil {
				var alertDisplayName string
				err = json.Unmarshal(*v, &alertDisplayName)
				if err != nil {
					return err
				}
				ap.AlertDisplayName = &alertDisplayName
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				ap.Description = &description
			}
		case "severity":
			if v != nil {
				var severity AlertSeverity
				err = json.Unmarshal(*v, &severity)
				if err != nil {
					return err
				}
				ap.Severity = severity
			}
		case "intent":
			if v != nil {
				var intent Intent
				err = json.Unmarshal(*v, &intent)
				if err != nil {
					return err
				}
				ap.Intent = intent
			}
		case "startTimeUtc":
			if v != nil {
				var startTimeUtc date.Time
				err = json.Unmarshal(*v, &startTimeUtc)
				if err != nil {
					return err
				}
				ap.StartTimeUtc = &startTimeUtc
			}
		case "endTimeUtc":
			if v != nil {
				var endTimeUtc date.Time
				err = json.Unmarshal(*v, &endTimeUtc)
				if err != nil {
					return err
				}
				ap.EndTimeUtc = &endTimeUtc
			}
		case "resourceIdentifiers":
			if v != nil {
				resourceIdentifiers, err := unmarshalBasicResourceIdentifierArray(*v)
				if err != nil {
					return err
				}
				ap.ResourceIdentifiers = &resourceIdentifiers
			}
		case "remediationSteps":
			if v != nil {
				var remediationSteps []string
				err = json.Unmarshal(*v, &remediationSteps)
				if err != nil {
					return err
				}
				ap.RemediationSteps = &remediationSteps
			}
		case "vendorName":
			if v != nil {
				var vendorName string
				err = json.Unmarshal(*v, &vendorName)
				if err != nil {
					return err
				}
				ap.VendorName = &vendorName
			}
		case "status":
			if v != nil {
				var status AlertStatus
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				ap.Status = status
			}
		case "extendedLinks":
			if v != nil {
				var extendedLinks []map[string]*string
				err = json.Unmarshal(*v, &extendedLinks)
				if err != nil {
					return err
				}
				ap.ExtendedLinks = &extendedLinks
			}
		case "alertUri":
			if v != nil {
				var alertURI string
				err = json.Unmarshal(*v, &alertURI)
				if err != nil {
					return err
				}
				ap.AlertURI = &alertURI
			}
		case "timeGeneratedUtc":
			if v != nil {
				var timeGeneratedUtc date.Time
				err = json.Unmarshal(*v, &timeGeneratedUtc)
				if err != nil {
					return err
				}
				ap.TimeGeneratedUtc = &timeGeneratedUtc
			}
		case "productName":
			if v != nil {
				var productName string
				err = json.Unmarshal(*v, &productName)
				if err != nil {
					return err
				}
				ap.ProductName = &productName
			}
		case "processingEndTimeUtc":
			if v != nil {
				var processingEndTimeUtc date.Time
				err = json.Unmarshal(*v, &processingEndTimeUtc)
				if err != nil {
					return err
				}
				ap.ProcessingEndTimeUtc = &processingEndTimeUtc
			}
		case "entities":
			if v != nil {
				var entities []AlertEntity
				err = json.Unmarshal(*v, &entities)
				if err != nil {
					return err
				}
				ap.Entities = &entities
			}
		case "isIncident":
			if v != nil {
				var isIncident bool
				err = json.Unmarshal(*v, &isIncident)
				if err != nil {
					return err
				}
				ap.IsIncident = &isIncident
			}
		case "correlationKey":
			if v != nil {
				var correlationKey string
				err = json.Unmarshal(*v, &correlationKey)
				if err != nil {
					return err
				}
				ap.CorrelationKey = &correlationKey
			}
		case "extendedProperties":
			if v != nil {
				var extendedProperties map[string]*string
				err = json.Unmarshal(*v, &extendedProperties)
				if err != nil {
					return err
				}
				ap.ExtendedProperties = extendedProperties
			}
		case "compromisedEntity":
			if v != nil {
				var compromisedEntity string
				err = json.Unmarshal(*v, &compromisedEntity)
				if err != nil {
					return err
				}
				ap.CompromisedEntity = &compromisedEntity
			}
		case "techniques":
			if v != nil {
				var techniques []string
				err = json.Unmarshal(*v, &techniques)
				if err != nil {
					return err
				}
				ap.Techniques = &techniques
			}
		case "subTechniques":
			if v != nil {
				var subTechniques []string
				err = json.Unmarshal(*v, &subTechniques)
				if err != nil {
					return err
				}
				ap.SubTechniques = &subTechniques
			}
		case "supportingEvidence":
			if v != nil {
				var supportingEvidence AlertPropertiesSupportingEvidence
				err = json.Unmarshal(*v, &supportingEvidence)
				if err != nil {
					return err
				}
				ap.SupportingEvidence = &supportingEvidence
			}
		}
	}

	return nil
}

// AlertPropertiesSupportingEvidence changing set of properties depending on the supportingEvidence type.
type AlertPropertiesSupportingEvidence struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Type - READ-ONLY; Type of the supportingEvidence
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertPropertiesSupportingEvidence.
func (apE AlertPropertiesSupportingEvidence) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	for k, v := range apE.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AlertPropertiesSupportingEvidence struct.
func (apE *AlertPropertiesSupportingEvidence) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if apE.AdditionalProperties == nil {
					apE.AdditionalProperties = make(map[string]interface{})
				}
				apE.AdditionalProperties[k] = additionalProperties
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				apE.Type = &typeVar
			}
		}
	}

	return nil
}

// AlertSimulatorBundlesRequestProperties simulate alerts according to this bundles.
type AlertSimulatorBundlesRequestProperties struct {
	// Bundles - Bundles list.
	Bundles *[]BundleType `json:"bundles,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Kind - Possible values include: 'KindAlertSimulatorRequestProperties', 'KindBundles'
	Kind KindEnum1 `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertSimulatorBundlesRequestProperties.
func (asbrp AlertSimulatorBundlesRequestProperties) MarshalJSON() ([]byte, error) {
	asbrp.Kind = KindBundles
	objectMap := make(map[string]interface{})
	if asbrp.Bundles != nil {
		objectMap["bundles"] = asbrp.Bundles
	}
	if asbrp.Kind != "" {
		objectMap["kind"] = asbrp.Kind
	}
	for k, v := range asbrp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAlertSimulatorBundlesRequestProperties is the BasicAlertSimulatorRequestProperties implementation for AlertSimulatorBundlesRequestProperties.
func (asbrp AlertSimulatorBundlesRequestProperties) AsAlertSimulatorBundlesRequestProperties() (*AlertSimulatorBundlesRequestProperties, bool) {
	return &asbrp, true
}

// AsAlertSimulatorRequestProperties is the BasicAlertSimulatorRequestProperties implementation for AlertSimulatorBundlesRequestProperties.
func (asbrp AlertSimulatorBundlesRequestProperties) AsAlertSimulatorRequestProperties() (*AlertSimulatorRequestProperties, bool) {
	return nil, false
}

// AsBasicAlertSimulatorRequestProperties is the BasicAlertSimulatorRequestProperties implementation for AlertSimulatorBundlesRequestProperties.
func (asbrp AlertSimulatorBundlesRequestProperties) AsBasicAlertSimulatorRequestProperties() (BasicAlertSimulatorRequestProperties, bool) {
	return &asbrp, true
}

// UnmarshalJSON is the custom unmarshaler for AlertSimulatorBundlesRequestProperties struct.
func (asbrp *AlertSimulatorBundlesRequestProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "bundles":
			if v != nil {
				var bundles []BundleType
				err = json.Unmarshal(*v, &bundles)
				if err != nil {
					return err
				}
				asbrp.Bundles = &bundles
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if asbrp.AdditionalProperties == nil {
					asbrp.AdditionalProperties = make(map[string]interface{})
				}
				asbrp.AdditionalProperties[k] = additionalProperties
			}
		case "kind":
			if v != nil {
				var kind KindEnum1
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				asbrp.Kind = kind
			}
		}
	}

	return nil
}

// AlertSimulatorRequestBody alert Simulator request body.
type AlertSimulatorRequestBody struct {
	// Properties - Alert Simulator request body data.
	Properties BasicAlertSimulatorRequestProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AlertSimulatorRequestBody struct.
func (asrb *AlertSimulatorRequestBody) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicAlertSimulatorRequestProperties(*v)
				if err != nil {
					return err
				}
				asrb.Properties = properties
			}
		}
	}

	return nil
}

// BasicAlertSimulatorRequestProperties describes properties of an alert simulation request
type BasicAlertSimulatorRequestProperties interface {
	AsAlertSimulatorBundlesRequestProperties() (*AlertSimulatorBundlesRequestProperties, bool)
	AsAlertSimulatorRequestProperties() (*AlertSimulatorRequestProperties, bool)
}

// AlertSimulatorRequestProperties describes properties of an alert simulation request
type AlertSimulatorRequestProperties struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Kind - Possible values include: 'KindAlertSimulatorRequestProperties', 'KindBundles'
	Kind KindEnum1 `json:"kind,omitempty"`
}

func unmarshalBasicAlertSimulatorRequestProperties(body []byte) (BasicAlertSimulatorRequestProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindBundles):
		var asbrp AlertSimulatorBundlesRequestProperties
		err := json.Unmarshal(body, &asbrp)
		return asbrp, err
	default:
		var asrp AlertSimulatorRequestProperties
		err := json.Unmarshal(body, &asrp)
		return asrp, err
	}
}
func unmarshalBasicAlertSimulatorRequestPropertiesArray(body []byte) ([]BasicAlertSimulatorRequestProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	asrpArray := make([]BasicAlertSimulatorRequestProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		asrp, err := unmarshalBasicAlertSimulatorRequestProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		asrpArray[index] = asrp
	}
	return asrpArray, nil
}

// MarshalJSON is the custom marshaler for AlertSimulatorRequestProperties.
func (asrp AlertSimulatorRequestProperties) MarshalJSON() ([]byte, error) {
	asrp.Kind = KindAlertSimulatorRequestProperties
	objectMap := make(map[string]interface{})
	if asrp.Kind != "" {
		objectMap["kind"] = asrp.Kind
	}
	for k, v := range asrp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsAlertSimulatorBundlesRequestProperties is the BasicAlertSimulatorRequestProperties implementation for AlertSimulatorRequestProperties.
func (asrp AlertSimulatorRequestProperties) AsAlertSimulatorBundlesRequestProperties() (*AlertSimulatorBundlesRequestProperties, bool) {
	return nil, false
}

// AsAlertSimulatorRequestProperties is the BasicAlertSimulatorRequestProperties implementation for AlertSimulatorRequestProperties.
func (asrp AlertSimulatorRequestProperties) AsAlertSimulatorRequestProperties() (*AlertSimulatorRequestProperties, bool) {
	return &asrp, true
}

// AsBasicAlertSimulatorRequestProperties is the BasicAlertSimulatorRequestProperties implementation for AlertSimulatorRequestProperties.
func (asrp AlertSimulatorRequestProperties) AsBasicAlertSimulatorRequestProperties() (BasicAlertSimulatorRequestProperties, bool) {
	return &asrp, true
}

// UnmarshalJSON is the custom unmarshaler for AlertSimulatorRequestProperties struct.
func (asrp *AlertSimulatorRequestProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if asrp.AdditionalProperties == nil {
					asrp.AdditionalProperties = make(map[string]interface{})
				}
				asrp.AdditionalProperties[k] = additionalProperties
			}
		case "kind":
			if v != nil {
				var kind KindEnum1
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				asrp.Kind = kind
			}
		}
	}

	return nil
}

// AlertsSimulateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AlertsSimulateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AlertsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AlertsSimulateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AlertsSimulateFuture.Result.
func (future *AlertsSimulateFuture) result(client AlertsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.AlertsSimulateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("security.AlertsSimulateFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// AlertsSuppressionRule describes the suppression rule
type AlertsSuppressionRule struct {
	autorest.Response                `json:"-"`
	*AlertsSuppressionRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertsSuppressionRule.
func (asr AlertsSuppressionRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asr.AlertsSuppressionRuleProperties != nil {
		objectMap["properties"] = asr.AlertsSuppressionRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AlertsSuppressionRule struct.
func (asr *AlertsSuppressionRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var alertsSuppressionRuleProperties AlertsSuppressionRuleProperties
				err = json.Unmarshal(*v, &alertsSuppressionRuleProperties)
				if err != nil {
					return err
				}
				asr.AlertsSuppressionRuleProperties = &alertsSuppressionRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				asr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				asr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asr.Type = &typeVar
			}
		}
	}

	return nil
}

// AlertsSuppressionRuleProperties describes AlertsSuppressionRule properties
type AlertsSuppressionRuleProperties struct {
	// AlertType - Type of the alert to automatically suppress. For all alert types, use '*'
	AlertType *string `json:"alertType,omitempty"`
	// LastModifiedUtc - READ-ONLY; The last time this rule was modified
	LastModifiedUtc *date.Time `json:"lastModifiedUtc,omitempty"`
	// ExpirationDateUtc - Expiration date of the rule, if value is not provided or provided as null this field will default to the maximum allowed expiration date.
	ExpirationDateUtc *date.Time `json:"expirationDateUtc,omitempty"`
	// Reason - The reason for dismissing the alert
	Reason *string `json:"reason,omitempty"`
	// State - Possible states of the rule. Possible values include: 'RuleStateEnabled', 'RuleStateDisabled', 'RuleStateExpired'
	State RuleState `json:"state,omitempty"`
	// Comment - Any comment regarding the rule
	Comment *string `json:"comment,omitempty"`
	// SuppressionAlertsScope - The suppression conditions
	SuppressionAlertsScope *SuppressionAlertsScope `json:"suppressionAlertsScope,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertsSuppressionRuleProperties.
func (asrp AlertsSuppressionRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asrp.AlertType != nil {
		objectMap["alertType"] = asrp.AlertType
	}
	if asrp.ExpirationDateUtc != nil {
		objectMap["expirationDateUtc"] = asrp.ExpirationDateUtc
	}
	if asrp.Reason != nil {
		objectMap["reason"] = asrp.Reason
	}
	if asrp.State != "" {
		objectMap["state"] = asrp.State
	}
	if asrp.Comment != nil {
		objectMap["comment"] = asrp.Comment
	}
	if asrp.SuppressionAlertsScope != nil {
		objectMap["suppressionAlertsScope"] = asrp.SuppressionAlertsScope
	}
	return json.Marshal(objectMap)
}

// AlertsSuppressionRulesList suppression rules list for subscription.
type AlertsSuppressionRulesList struct {
	autorest.Response `json:"-"`
	Value             *[]AlertsSuppressionRule `json:"value,omitempty"`
	// NextLink - READ-ONLY; URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertsSuppressionRulesList.
func (asrl AlertsSuppressionRulesList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asrl.Value != nil {
		objectMap["value"] = asrl.Value
	}
	return json.Marshal(objectMap)
}

// AlertsSuppressionRulesListIterator provides access to a complete listing of AlertsSuppressionRule
// values.
type AlertsSuppressionRulesListIterator struct {
	i    int
	page AlertsSuppressionRulesListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AlertsSuppressionRulesListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsSuppressionRulesListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AlertsSuppressionRulesListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AlertsSuppressionRulesListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AlertsSuppressionRulesListIterator) Response() AlertsSuppressionRulesList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AlertsSuppressionRulesListIterator) Value() AlertsSuppressionRule {
	if !iter.page.NotDone() {
		return AlertsSuppressionRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AlertsSuppressionRulesListIterator type.
func NewAlertsSuppressionRulesListIterator(page AlertsSuppressionRulesListPage) AlertsSuppressionRulesListIterator {
	return AlertsSuppressionRulesListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (asrl AlertsSuppressionRulesList) IsEmpty() bool {
	return asrl.Value == nil || len(*asrl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (asrl AlertsSuppressionRulesList) hasNextLink() bool {
	return asrl.NextLink != nil && len(*asrl.NextLink) != 0
}

// alertsSuppressionRulesListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (asrl AlertsSuppressionRulesList) alertsSuppressionRulesListPreparer(ctx context.Context) (*http.Request, error) {
	if !asrl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(asrl.NextLink)))
}

// AlertsSuppressionRulesListPage contains a page of AlertsSuppressionRule values.
type AlertsSuppressionRulesListPage struct {
	fn   func(context.Context, AlertsSuppressionRulesList) (AlertsSuppressionRulesList, error)
	asrl AlertsSuppressionRulesList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AlertsSuppressionRulesListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AlertsSuppressionRulesListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.asrl)
		if err != nil {
			return err
		}
		page.asrl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AlertsSuppressionRulesListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AlertsSuppressionRulesListPage) NotDone() bool {
	return !page.asrl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AlertsSuppressionRulesListPage) Response() AlertsSuppressionRulesList {
	return page.asrl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AlertsSuppressionRulesListPage) Values() []AlertsSuppressionRule {
	if page.asrl.IsEmpty() {
		return nil
	}
	return *page.asrl.Value
}

// Creates a new instance of the AlertsSuppressionRulesListPage type.
func NewAlertsSuppressionRulesListPage(cur AlertsSuppressionRulesList, getNextPage func(context.Context, AlertsSuppressionRulesList) (AlertsSuppressionRulesList, error)) AlertsSuppressionRulesListPage {
	return AlertsSuppressionRulesListPage{
		fn:   getNextPage,
		asrl: cur,
	}
}

// AlertSyncSettingProperties the alert sync setting properties
type AlertSyncSettingProperties struct {
	// Enabled - Is the alert sync setting enabled
	Enabled *bool `json:"enabled,omitempty"`
}

// AlertSyncSettings represents an alert sync setting
type AlertSyncSettings struct {
	// AlertSyncSettingProperties - Alert sync setting data
	*AlertSyncSettingProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Kind - Possible values include: 'KindSetting', 'KindDataExportSettings', 'KindAlertSyncSettings'
	Kind KindEnum2 `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AlertSyncSettings.
func (ass AlertSyncSettings) MarshalJSON() ([]byte, error) {
	ass.Kind = KindAlertSyncSettings
	objectMap := make(map[string]interface{})
	if ass.AlertSyncSettingProperties != nil {
		objectMap["properties"] = ass.AlertSyncSettingProperties
	}
	if ass.Kind != "" {
		objectMap["kind"] = ass.Kind
	}
	return json.Marshal(objectMap)
}

// AsDataExportSettings is the BasicSetting implementation for AlertSyncSettings.
func (ass AlertSyncSettings) AsDataExportSettings() (*DataExportSettings, bool) {
	return nil, false
}

// AsAlertSyncSettings is the BasicSetting implementation for AlertSyncSettings.
func (ass AlertSyncSettings) AsAlertSyncSettings() (*AlertSyncSettings, bool) {
	return &ass, true
}

// AsSetting is the BasicSetting implementation for AlertSyncSettings.
func (ass AlertSyncSettings) AsSetting() (*Setting, bool) {
	return nil, false
}

// AsBasicSetting is the BasicSetting implementation for AlertSyncSettings.
func (ass AlertSyncSettings) AsBasicSetting() (BasicSetting, bool) {
	return &ass, true
}

// UnmarshalJSON is the custom unmarshaler for AlertSyncSettings struct.
func (ass *AlertSyncSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var alertSyncSettingProperties AlertSyncSettingProperties
				err = json.Unmarshal(*v, &alertSyncSettingProperties)
				if err != nil {
					return err
				}
				ass.AlertSyncSettingProperties = &alertSyncSettingProperties
			}
		case "kind":
			if v != nil {
				var kind KindEnum2
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ass.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ass.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ass.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ass.Type = &typeVar
			}
		}
	}

	return nil
}

// AllowedConnectionsList list of all possible traffic between Azure resources
type AllowedConnectionsList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY
	Value *[]AllowedConnectionsResource `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AllowedConnectionsList.
func (ACL AllowedConnectionsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AllowedConnectionsListIterator provides access to a complete listing of AllowedConnectionsResource
// values.
type AllowedConnectionsListIterator struct {
	i    int
	page AllowedConnectionsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AllowedConnectionsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AllowedConnectionsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AllowedConnectionsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AllowedConnectionsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AllowedConnectionsListIterator) Response() AllowedConnectionsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AllowedConnectionsListIterator) Value() AllowedConnectionsResource {
	if !iter.page.NotDone() {
		return AllowedConnectionsResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AllowedConnectionsListIterator type.
func NewAllowedConnectionsListIterator(page AllowedConnectionsListPage) AllowedConnectionsListIterator {
	return AllowedConnectionsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ACL AllowedConnectionsList) IsEmpty() bool {
	return ACL.Value == nil || len(*ACL.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ACL AllowedConnectionsList) hasNextLink() bool {
	return ACL.NextLink != nil && len(*ACL.NextLink) != 0
}

// allowedConnectionsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ACL AllowedConnectionsList) allowedConnectionsListPreparer(ctx context.Context) (*http.Request, error) {
	if !ACL.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ACL.NextLink)))
}

// AllowedConnectionsListPage contains a page of AllowedConnectionsResource values.
type AllowedConnectionsListPage struct {
	fn  func(context.Context, AllowedConnectionsList) (AllowedConnectionsList, error)
	ACL AllowedConnectionsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AllowedConnectionsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AllowedConnectionsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ACL)
		if err != nil {
			return err
		}
		page.ACL = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AllowedConnectionsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AllowedConnectionsListPage) NotDone() bool {
	return !page.ACL.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AllowedConnectionsListPage) Response() AllowedConnectionsList {
	return page.ACL
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AllowedConnectionsListPage) Values() []AllowedConnectionsResource {
	if page.ACL.IsEmpty() {
		return nil
	}
	return *page.ACL.Value
}

// Creates a new instance of the AllowedConnectionsListPage type.
func NewAllowedConnectionsListPage(cur AllowedConnectionsList, getNextPage func(context.Context, AllowedConnectionsList) (AllowedConnectionsList, error)) AllowedConnectionsListPage {
	return AllowedConnectionsListPage{
		fn:  getNextPage,
		ACL: cur,
	}
}

// AllowedConnectionsResource the resource whose properties describes the allowed traffic between Azure
// resources
type AllowedConnectionsResource struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty"`
	// AllowedConnectionsResourceProperties - READ-ONLY
	*AllowedConnectionsResourceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AllowedConnectionsResource.
func (acr AllowedConnectionsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AllowedConnectionsResource struct.
func (acr *AllowedConnectionsResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				acr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				acr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				acr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				acr.Location = &location
			}
		case "properties":
			if v != nil {
				var allowedConnectionsResourceProperties AllowedConnectionsResourceProperties
				err = json.Unmarshal(*v, &allowedConnectionsResourceProperties)
				if err != nil {
					return err
				}
				acr.AllowedConnectionsResourceProperties = &allowedConnectionsResourceProperties
			}
		}
	}

	return nil
}

// AllowedConnectionsResourceProperties describes the allowed traffic between Azure resources
type AllowedConnectionsResourceProperties struct {
	// CalculatedDateTime - READ-ONLY; The UTC time on which the allowed connections resource was calculated
	CalculatedDateTime *date.Time `json:"calculatedDateTime,omitempty"`
	// ConnectableResources - READ-ONLY; List of connectable resources
	ConnectableResources *[]ConnectableResource `json:"connectableResources,omitempty"`
}

// MarshalJSON is the custom marshaler for AllowedConnectionsResourceProperties.
func (acrp AllowedConnectionsResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// BasicAllowlistCustomAlertRule a custom alert rule that checks if a value (depends on the custom alert type) is
// allowed.
type BasicAllowlistCustomAlertRule interface {
	AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool)
	AsConnectionFromIPNotAllowed() (*ConnectionFromIPNotAllowed, bool)
	AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool)
	AsProcessNotAllowed() (*ProcessNotAllowed, bool)
	AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool)
}

// AllowlistCustomAlertRule a custom alert rule that checks if a value (depends on the custom alert type) is
// allowed.
type AllowlistCustomAlertRule struct {
	// AllowlistValues - The values to allow. The format of the values depends on the rule type.
	AllowlistValues *[]string `json:"allowlistValues,omitempty"`
	// ValueType - READ-ONLY; The value type of the items in the list. Possible values include: 'ValueTypeIPCidr', 'ValueTypeString'
	ValueType ValueType `json:"valueType,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeConnectionFromIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

func unmarshalBasicAllowlistCustomAlertRule(body []byte) (BasicAllowlistCustomAlertRule, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["ruleType"] {
	case string(RuleTypeConnectionToIPNotAllowed):
		var ctina ConnectionToIPNotAllowed
		err := json.Unmarshal(body, &ctina)
		return ctina, err
	case string(RuleTypeConnectionFromIPNotAllowed):
		var cfina ConnectionFromIPNotAllowed
		err := json.Unmarshal(body, &cfina)
		return cfina, err
	case string(RuleTypeLocalUserNotAllowed):
		var luna LocalUserNotAllowed
		err := json.Unmarshal(body, &luna)
		return luna, err
	case string(RuleTypeProcessNotAllowed):
		var pna ProcessNotAllowed
		err := json.Unmarshal(body, &pna)
		return pna, err
	default:
		var acar AllowlistCustomAlertRule
		err := json.Unmarshal(body, &acar)
		return acar, err
	}
}
func unmarshalBasicAllowlistCustomAlertRuleArray(body []byte) ([]BasicAllowlistCustomAlertRule, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	acarArray := make([]BasicAllowlistCustomAlertRule, len(rawMessages))

	for index, rawMessage := range rawMessages {
		acar, err := unmarshalBasicAllowlistCustomAlertRule(*rawMessage)
		if err != nil {
			return nil, err
		}
		acarArray[index] = acar
	}
	return acarArray, nil
}

// MarshalJSON is the custom marshaler for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) MarshalJSON() ([]byte, error) {
	acar.RuleType = RuleTypeAllowlistCustomAlertRule
	objectMap := make(map[string]interface{})
	if acar.AllowlistValues != nil {
		objectMap["allowlistValues"] = acar.AllowlistValues
	}
	if acar.IsEnabled != nil {
		objectMap["isEnabled"] = acar.IsEnabled
	}
	if acar.RuleType != "" {
		objectMap["ruleType"] = acar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return &acar, true
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return &acar, true
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return &acar, true
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsConnectionFromIPNotAllowed is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsConnectionFromIPNotAllowed() (*ConnectionFromIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for AllowlistCustomAlertRule.
func (acar AllowlistCustomAlertRule) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &acar, true
}

// AmqpC2DMessagesNotInAllowedRange number of cloud to device messages (AMQP protocol) is not in allowed
// range.
type AmqpC2DMessagesNotInAllowedRange struct {
	// TimeWindowSize - The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeConnectionFromIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	acmniar.RuleType = RuleTypeAmqpC2DMessagesNotInAllowedRange
	objectMap := make(map[string]interface{})
	if acmniar.TimeWindowSize != nil {
		objectMap["timeWindowSize"] = acmniar.TimeWindowSize
	}
	if acmniar.MinThreshold != nil {
		objectMap["minThreshold"] = acmniar.MinThreshold
	}
	if acmniar.MaxThreshold != nil {
		objectMap["maxThreshold"] = acmniar.MaxThreshold
	}
	if acmniar.IsEnabled != nil {
		objectMap["isEnabled"] = acmniar.IsEnabled
	}
	if acmniar.RuleType != "" {
		objectMap["ruleType"] = acmniar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return &acmniar, true
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return &acmniar, true
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsConnectionFromIPNotAllowed is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsConnectionFromIPNotAllowed() (*ConnectionFromIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return &acmniar, true
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DMessagesNotInAllowedRange.
func (acmniar AmqpC2DMessagesNotInAllowedRange) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &acmniar, true
}

// AmqpC2DRejectedMessagesNotInAllowedRange number of rejected cloud to device messages (AMQP protocol) is
// not in allowed range.
type AmqpC2DRejectedMessagesNotInAllowedRange struct {
	// TimeWindowSize - The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeConnectionFromIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	acrmniar.RuleType = RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange
	objectMap := make(map[string]interface{})
	if acrmniar.TimeWindowSize != nil {
		objectMap["timeWindowSize"] = acrmniar.TimeWindowSize
	}
	if acrmniar.MinThreshold != nil {
		objectMap["minThreshold"] = acrmniar.MinThreshold
	}
	if acrmniar.MaxThreshold != nil {
		objectMap["maxThreshold"] = acrmniar.MaxThreshold
	}
	if acrmniar.IsEnabled != nil {
		objectMap["isEnabled"] = acrmniar.IsEnabled
	}
	if acrmniar.RuleType != "" {
		objectMap["ruleType"] = acrmniar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return &acrmniar, true
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return &acrmniar, true
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsConnectionFromIPNotAllowed is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsConnectionFromIPNotAllowed() (*ConnectionFromIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return &acrmniar, true
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for AmqpC2DRejectedMessagesNotInAllowedRange.
func (acrmniar AmqpC2DRejectedMessagesNotInAllowedRange) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &acrmniar, true
}

// AmqpD2CMessagesNotInAllowedRange number of device to cloud messages (AMQP protocol) is not in allowed
// range.
type AmqpD2CMessagesNotInAllowedRange struct {
	// TimeWindowSize - The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeConnectionFromIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	admniar.RuleType = RuleTypeAmqpD2CMessagesNotInAllowedRange
	objectMap := make(map[string]interface{})
	if admniar.TimeWindowSize != nil {
		objectMap["timeWindowSize"] = admniar.TimeWindowSize
	}
	if admniar.MinThreshold != nil {
		objectMap["minThreshold"] = admniar.MinThreshold
	}
	if admniar.MaxThreshold != nil {
		objectMap["maxThreshold"] = admniar.MaxThreshold
	}
	if admniar.IsEnabled != nil {
		objectMap["isEnabled"] = admniar.IsEnabled
	}
	if admniar.RuleType != "" {
		objectMap["ruleType"] = admniar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return &admniar, true
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return &admniar, true
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsConnectionFromIPNotAllowed is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsConnectionFromIPNotAllowed() (*ConnectionFromIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return &admniar, true
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for AmqpD2CMessagesNotInAllowedRange.
func (admniar AmqpD2CMessagesNotInAllowedRange) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &admniar, true
}

// Application security Application over a given scope
type Application struct {
	autorest.Response `json:"-"`
	// ApplicationProperties - Properties of a security application
	*ApplicationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Application.
func (a Application) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.ApplicationProperties != nil {
		objectMap["properties"] = a.ApplicationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Application struct.
func (a *Application) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationProperties ApplicationProperties
				err = json.Unmarshal(*v, &applicationProperties)
				if err != nil {
					return err
				}
				a.ApplicationProperties = &applicationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		}
	}

	return nil
}

// ApplicationCondition application's condition
type ApplicationCondition struct {
	// Property - The application Condition's Property, e.g. ID, see examples
	Property *string `json:"property,omitempty"`
	// Value - The application Condition's Value like IDs that contain some string, see examples
	Value *string `json:"value,omitempty"`
	// Operator - The application Condition's Operator, for example Contains for id or In for list of possible IDs, see examples. Possible values include: 'In', 'Equals'
	Operator ApplicationConditionOperator `json:"operator,omitempty"`
}

// ApplicationProperties describes properties of an application
type ApplicationProperties struct {
	// DisplayName - display name of the application
	DisplayName *string `json:"displayName,omitempty"`
	// Description - description of the application
	Description *string `json:"description,omitempty"`
	// SourceResourceType - The application source, what it affects, e.g. Assessments
	SourceResourceType *string `json:"sourceResourceType,omitempty"`
	// ConditionSets - The application conditionSets - see examples
	ConditionSets *[]interface{} `json:"conditionSets,omitempty"`
}

// ApplicationsList page of a security applications list
type ApplicationsList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Collection of applications in this page
	Value *[]Application `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationsList.
func (al ApplicationsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ApplicationsListIterator provides access to a complete listing of Application values.
type ApplicationsListIterator struct {
	i    int
	page ApplicationsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplicationsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ApplicationsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplicationsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplicationsListIterator) Response() ApplicationsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplicationsListIterator) Value() Application {
	if !iter.page.NotDone() {
		return Application{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ApplicationsListIterator type.
func NewApplicationsListIterator(page ApplicationsListPage) ApplicationsListIterator {
	return ApplicationsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (al ApplicationsList) IsEmpty() bool {
	return al.Value == nil || len(*al.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (al ApplicationsList) hasNextLink() bool {
	return al.NextLink != nil && len(*al.NextLink) != 0
}

// applicationsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (al ApplicationsList) applicationsListPreparer(ctx context.Context) (*http.Request, error) {
	if !al.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(al.NextLink)))
}

// ApplicationsListPage contains a page of Application values.
type ApplicationsListPage struct {
	fn func(context.Context, ApplicationsList) (ApplicationsList, error)
	al ApplicationsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplicationsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.al)
		if err != nil {
			return err
		}
		page.al = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ApplicationsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplicationsListPage) NotDone() bool {
	return !page.al.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplicationsListPage) Response() ApplicationsList {
	return page.al
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplicationsListPage) Values() []Application {
	if page.al.IsEmpty() {
		return nil
	}
	return *page.al.Value
}

// Creates a new instance of the ApplicationsListPage type.
func NewApplicationsListPage(cur ApplicationsList, getNextPage func(context.Context, ApplicationsList) (ApplicationsList, error)) ApplicationsListPage {
	return ApplicationsListPage{
		fn: getNextPage,
		al: cur,
	}
}

// AscLocation the ASC location of the subscription is in the "name" field
type AscLocation struct {
	autorest.Response `json:"-"`
	Properties        interface{} `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AscLocation.
func (al AscLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if al.Properties != nil {
		objectMap["properties"] = al.Properties
	}
	return json.Marshal(objectMap)
}

// AscLocationList list of locations where ASC saves your data
type AscLocationList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY
	Value *[]AscLocation `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AscLocationList.
func (all AscLocationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AscLocationListIterator provides access to a complete listing of AscLocation values.
type AscLocationListIterator struct {
	i    int
	page AscLocationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AscLocationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AscLocationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AscLocationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AscLocationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AscLocationListIterator) Response() AscLocationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AscLocationListIterator) Value() AscLocation {
	if !iter.page.NotDone() {
		return AscLocation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AscLocationListIterator type.
func NewAscLocationListIterator(page AscLocationListPage) AscLocationListIterator {
	return AscLocationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (all AscLocationList) IsEmpty() bool {
	return all.Value == nil || len(*all.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (all AscLocationList) hasNextLink() bool {
	return all.NextLink != nil && len(*all.NextLink) != 0
}

// ascLocationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (all AscLocationList) ascLocationListPreparer(ctx context.Context) (*http.Request, error) {
	if !all.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(all.NextLink)))
}

// AscLocationListPage contains a page of AscLocation values.
type AscLocationListPage struct {
	fn  func(context.Context, AscLocationList) (AscLocationList, error)
	all AscLocationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AscLocationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AscLocationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.all)
		if err != nil {
			return err
		}
		page.all = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AscLocationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AscLocationListPage) NotDone() bool {
	return !page.all.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AscLocationListPage) Response() AscLocationList {
	return page.all
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AscLocationListPage) Values() []AscLocation {
	if page.all.IsEmpty() {
		return nil
	}
	return *page.all.Value
}

// Creates a new instance of the AscLocationListPage type.
func NewAscLocationListPage(cur AscLocationList, getNextPage func(context.Context, AscLocationList) (AscLocationList, error)) AscLocationListPage {
	return AscLocationListPage{
		fn:  getNextPage,
		all: cur,
	}
}

// Assessment security assessment on a resource
type Assessment struct {
	*AssessmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Assessment.
func (a Assessment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.AssessmentProperties != nil {
		objectMap["properties"] = a.AssessmentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Assessment struct.
func (a *Assessment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var assessmentProperties AssessmentProperties
				err = json.Unmarshal(*v, &assessmentProperties)
				if err != nil {
					return err
				}
				a.AssessmentProperties = &assessmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		}
	}

	return nil
}

// AssessmentLinks links relevant to the assessment
type AssessmentLinks struct {
	// AzurePortalURI - READ-ONLY; Link to assessment in Azure Portal
	AzurePortalURI *string `json:"azurePortalUri,omitempty"`
}

// MarshalJSON is the custom marshaler for AssessmentLinks.
func (al AssessmentLinks) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AssessmentList page of a security assessments list
type AssessmentList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Collection of security assessments in this page
	Value *[]AssessmentResponse `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AssessmentList.
func (al AssessmentList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AssessmentListIterator provides access to a complete listing of AssessmentResponse values.
type AssessmentListIterator struct {
	i    int
	page AssessmentListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AssessmentListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AssessmentListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AssessmentListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AssessmentListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AssessmentListIterator) Response() AssessmentList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AssessmentListIterator) Value() AssessmentResponse {
	if !iter.page.NotDone() {
		return AssessmentResponse{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AssessmentListIterator type.
func NewAssessmentListIterator(page AssessmentListPage) AssessmentListIterator {
	return AssessmentListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (al AssessmentList) IsEmpty() bool {
	return al.Value == nil || len(*al.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (al AssessmentList) hasNextLink() bool {
	return al.NextLink != nil && len(*al.NextLink) != 0
}

// assessmentListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (al AssessmentList) assessmentListPreparer(ctx context.Context) (*http.Request, error) {
	if !al.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(al.NextLink)))
}

// AssessmentListPage contains a page of AssessmentResponse values.
type AssessmentListPage struct {
	fn func(context.Context, AssessmentList) (AssessmentList, error)
	al AssessmentList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AssessmentListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AssessmentListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.al)
		if err != nil {
			return err
		}
		page.al = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AssessmentListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AssessmentListPage) NotDone() bool {
	return !page.al.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AssessmentListPage) Response() AssessmentList {
	return page.al
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AssessmentListPage) Values() []AssessmentResponse {
	if page.al.IsEmpty() {
		return nil
	}
	return *page.al.Value
}

// Creates a new instance of the AssessmentListPage type.
func NewAssessmentListPage(cur AssessmentList, getNextPage func(context.Context, AssessmentList) (AssessmentList, error)) AssessmentListPage {
	return AssessmentListPage{
		fn: getNextPage,
		al: cur,
	}
}

// AssessmentMetadata security assessment metadata
type AssessmentMetadata struct {
	*AssessmentMetadataProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AssessmentMetadata.
func (am AssessmentMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if am.AssessmentMetadataProperties != nil {
		objectMap["properties"] = am.AssessmentMetadataProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AssessmentMetadata struct.
func (am *AssessmentMetadata) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var assessmentMetadataProperties AssessmentMetadataProperties
				err = json.Unmarshal(*v, &assessmentMetadataProperties)
				if err != nil {
					return err
				}
				am.AssessmentMetadataProperties = &assessmentMetadataProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				am.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				am.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				am.Type = &typeVar
			}
		}
	}

	return nil
}

// AssessmentMetadataPartnerData describes the partner that created the assessment
type AssessmentMetadataPartnerData struct {
	// PartnerName - Name of the company of the partner
	PartnerName *string `json:"partnerName,omitempty"`
	// ProductName - Name of the product of the partner that created the assessment
	ProductName *string `json:"productName,omitempty"`
	// Secret - Secret to authenticate the partner and verify it created the assessment - write only
	Secret *string `json:"secret,omitempty"`
}

// AssessmentMetadataProperties describes properties of an assessment metadata.
type AssessmentMetadataProperties struct {
	// DisplayName - User friendly display name of the assessment
	DisplayName *string `json:"displayName,omitempty"`
	// PolicyDefinitionID - READ-ONLY; Azure resource ID of the policy definition that turns this assessment calculation on
	PolicyDefinitionID *string `json:"policyDefinitionId,omitempty"`
	// Description - Human readable description of the assessment
	Description *string `json:"description,omitempty"`
	// RemediationDescription - Human readable description of what you should do to mitigate this security issue
	RemediationDescription *string       `json:"remediationDescription,omitempty"`
	Categories             *[]Categories `json:"categories,omitempty"`
	// Severity - The severity level of the assessment. Possible values include: 'SeverityLow', 'SeverityMedium', 'SeverityHigh'
	Severity Severity `json:"severity,omitempty"`
	// UserImpact - The user impact of the assessment. Possible values include: 'UserImpactLow', 'UserImpactModerate', 'UserImpactHigh'
	UserImpact UserImpact `json:"userImpact,omitempty"`
	// ImplementationEffort - The implementation effort required to remediate this assessment. Possible values include: 'ImplementationEffortLow', 'ImplementationEffortModerate', 'ImplementationEffortHigh'
	ImplementationEffort ImplementationEffort `json:"implementationEffort,omitempty"`
	Threats              *[]Threats           `json:"threats,omitempty"`
	// Preview - True if this assessment is in preview release status
	Preview *bool `json:"preview,omitempty"`
	// AssessmentType - BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition. Possible values include: 'BuiltIn', 'CustomPolicy', 'CustomerManaged', 'VerifiedPartner'
	AssessmentType AssessmentType                 `json:"assessmentType,omitempty"`
	PartnerData    *AssessmentMetadataPartnerData `json:"partnerData,omitempty"`
}

// MarshalJSON is the custom marshaler for AssessmentMetadataProperties.
func (amp AssessmentMetadataProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if amp.DisplayName != nil {
		objectMap["displayName"] = amp.DisplayName
	}
	if amp.Description != nil {
		objectMap["description"] = amp.Description
	}
	if amp.RemediationDescription != nil {
		objectMap["remediationDescription"] = amp.RemediationDescription
	}
	if amp.Categories != nil {
		objectMap["categories"] = amp.Categories
	}
	if amp.Severity != "" {
		objectMap["severity"] = amp.Severity
	}
	if amp.UserImpact != "" {
		objectMap["userImpact"] = amp.UserImpact
	}
	if amp.ImplementationEffort != "" {
		objectMap["implementationEffort"] = amp.ImplementationEffort
	}
	if amp.Threats != nil {
		objectMap["threats"] = amp.Threats
	}
	if amp.Preview != nil {
		objectMap["preview"] = amp.Preview
	}
	if amp.AssessmentType != "" {
		objectMap["assessmentType"] = amp.AssessmentType
	}
	if amp.PartnerData != nil {
		objectMap["partnerData"] = amp.PartnerData
	}
	return json.Marshal(objectMap)
}

// AssessmentMetadataPropertiesResponse describes properties of an assessment metadata response.
type AssessmentMetadataPropertiesResponse struct {
	PublishDates           *AssessmentMetadataPropertiesResponsePublishDates `json:"publishDates,omitempty"`
	PlannedDeprecationDate *string                                           `json:"plannedDeprecationDate,omitempty"`
	Tactics                *[]Tactics                                        `json:"tactics,omitempty"`
	Techniques             *[]Techniques                                     `json:"techniques,omitempty"`
	// DisplayName - User friendly display name of the assessment
	DisplayName *string `json:"displayName,omitempty"`
	// PolicyDefinitionID - READ-ONLY; Azure resource ID of the policy definition that turns this assessment calculation on
	PolicyDefinitionID *string `json:"policyDefinitionId,omitempty"`
	// Description - Human readable description of the assessment
	Description *string `json:"description,omitempty"`
	// RemediationDescription - Human readable description of what you should do to mitigate this security issue
	RemediationDescription *string       `json:"remediationDescription,omitempty"`
	Categories             *[]Categories `json:"categories,omitempty"`
	// Severity - The severity level of the assessment. Possible values include: 'SeverityLow', 'SeverityMedium', 'SeverityHigh'
	Severity Severity `json:"severity,omitempty"`
	// UserImpact - The user impact of the assessment. Possible values include: 'UserImpactLow', 'UserImpactModerate', 'UserImpactHigh'
	UserImpact UserImpact `json:"userImpact,omitempty"`
	// ImplementationEffort - The implementation effort required to remediate this assessment. Possible values include: 'ImplementationEffortLow', 'ImplementationEffortModerate', 'ImplementationEffortHigh'
	ImplementationEffort ImplementationEffort `json:"implementationEffort,omitempty"`
	Threats              *[]Threats           `json:"threats,omitempty"`
	// Preview - True if this assessment is in preview release status
	Preview *bool `json:"preview,omitempty"`
	// AssessmentType - BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition. Possible values include: 'BuiltIn', 'CustomPolicy', 'CustomerManaged', 'VerifiedPartner'
	AssessmentType AssessmentType                 `json:"assessmentType,omitempty"`
	PartnerData    *AssessmentMetadataPartnerData `json:"partnerData,omitempty"`
}

// MarshalJSON is the custom marshaler for AssessmentMetadataPropertiesResponse.
func (ampr AssessmentMetadataPropertiesResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ampr.PublishDates != nil {
		objectMap["publishDates"] = ampr.PublishDates
	}
	if ampr.PlannedDeprecationDate != nil {
		objectMap["plannedDeprecationDate"] = ampr.PlannedDeprecationDate
	}
	if ampr.Tactics != nil {
		objectMap["tactics"] = ampr.Tactics
	}
	if ampr.Techniques != nil {
		objectMap["techniques"] = ampr.Techniques
	}
	if ampr.DisplayName != nil {
		objectMap["displayName"] = ampr.DisplayName
	}
	if ampr.Description != nil {
		objectMap["description"] = ampr.Description
	}
	if ampr.RemediationDescription != nil {
		objectMap["remediationDescription"] = ampr.RemediationDescription
	}
	if ampr.Categories != nil {
		objectMap["categories"] = ampr.Categories
	}
	if ampr.Severity != "" {
		objectMap["severity"] = ampr.Severity
	}
	if ampr.UserImpact != "" {
		objectMap["userImpact"] = ampr.UserImpact
	}
	if ampr.ImplementationEffort != "" {
		objectMap["implementationEffort"] = ampr.ImplementationEffort
	}
	if ampr.Threats != nil {
		objectMap["threats"] = ampr.Threats
	}
	if ampr.Preview != nil {
		objectMap["preview"] = ampr.Preview
	}
	if ampr.AssessmentType != "" {
		objectMap["assessmentType"] = ampr.AssessmentType
	}
	if ampr.PartnerData != nil {
		objectMap["partnerData"] = ampr.PartnerData
	}
	return json.Marshal(objectMap)
}

// AssessmentMetadataPropertiesResponsePublishDates ...
type AssessmentMetadataPropertiesResponsePublishDates struct {
	GA     *string `json:"GA,omitempty"`
	Public *string `json:"public,omitempty"`
}

// AssessmentMetadataResponse security assessment metadata response
type AssessmentMetadataResponse struct {
	autorest.Response                     `json:"-"`
	*AssessmentMetadataPropertiesResponse `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AssessmentMetadataResponse.
func (amr AssessmentMetadataResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if amr.AssessmentMetadataPropertiesResponse != nil {
		objectMap["properties"] = amr.AssessmentMetadataPropertiesResponse
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AssessmentMetadataResponse struct.
func (amr *AssessmentMetadataResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var assessmentMetadataPropertiesResponse AssessmentMetadataPropertiesResponse
				err = json.Unmarshal(*v, &assessmentMetadataPropertiesResponse)
				if err != nil {
					return err
				}
				amr.AssessmentMetadataPropertiesResponse = &assessmentMetadataPropertiesResponse
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				amr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				amr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				amr.Type = &typeVar
			}
		}
	}

	return nil
}

// AssessmentMetadataResponseList list of security assessment metadata
type AssessmentMetadataResponseList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY
	Value *[]AssessmentMetadataResponse `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AssessmentMetadataResponseList.
func (amrl AssessmentMetadataResponseList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AssessmentMetadataResponseListIterator provides access to a complete listing of
// AssessmentMetadataResponse values.
type AssessmentMetadataResponseListIterator struct {
	i    int
	page AssessmentMetadataResponseListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AssessmentMetadataResponseListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AssessmentMetadataResponseListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AssessmentMetadataResponseListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AssessmentMetadataResponseListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AssessmentMetadataResponseListIterator) Response() AssessmentMetadataResponseList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AssessmentMetadataResponseListIterator) Value() AssessmentMetadataResponse {
	if !iter.page.NotDone() {
		return AssessmentMetadataResponse{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AssessmentMetadataResponseListIterator type.
func NewAssessmentMetadataResponseListIterator(page AssessmentMetadataResponseListPage) AssessmentMetadataResponseListIterator {
	return AssessmentMetadataResponseListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (amrl AssessmentMetadataResponseList) IsEmpty() bool {
	return amrl.Value == nil || len(*amrl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (amrl AssessmentMetadataResponseList) hasNextLink() bool {
	return amrl.NextLink != nil && len(*amrl.NextLink) != 0
}

// assessmentMetadataResponseListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (amrl AssessmentMetadataResponseList) assessmentMetadataResponseListPreparer(ctx context.Context) (*http.Request, error) {
	if !amrl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(amrl.NextLink)))
}

// AssessmentMetadataResponseListPage contains a page of AssessmentMetadataResponse values.
type AssessmentMetadataResponseListPage struct {
	fn   func(context.Context, AssessmentMetadataResponseList) (AssessmentMetadataResponseList, error)
	amrl AssessmentMetadataResponseList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AssessmentMetadataResponseListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AssessmentMetadataResponseListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.amrl)
		if err != nil {
			return err
		}
		page.amrl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AssessmentMetadataResponseListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AssessmentMetadataResponseListPage) NotDone() bool {
	return !page.amrl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AssessmentMetadataResponseListPage) Response() AssessmentMetadataResponseList {
	return page.amrl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AssessmentMetadataResponseListPage) Values() []AssessmentMetadataResponse {
	if page.amrl.IsEmpty() {
		return nil
	}
	return *page.amrl.Value
}

// Creates a new instance of the AssessmentMetadataResponseListPage type.
func NewAssessmentMetadataResponseListPage(cur AssessmentMetadataResponseList, getNextPage func(context.Context, AssessmentMetadataResponseList) (AssessmentMetadataResponseList, error)) AssessmentMetadataResponseListPage {
	return AssessmentMetadataResponseListPage{
		fn:   getNextPage,
		amrl: cur,
	}
}

// AssessmentPartnerData data regarding 3rd party partner integration
type AssessmentPartnerData struct {
	// PartnerName - Name of the company of the partner
	PartnerName *string `json:"partnerName,omitempty"`
	// Secret - secret to authenticate the partner - write only
	Secret *string `json:"secret,omitempty"`
}

// AssessmentProperties describes properties of an assessment.
type AssessmentProperties struct {
	Status          *AssessmentStatus    `json:"status,omitempty"`
	ResourceDetails BasicResourceDetails `json:"resourceDetails,omitempty"`
	// DisplayName - READ-ONLY; User friendly display name of the assessment
	DisplayName *string `json:"displayName,omitempty"`
	// AdditionalData - Additional data regarding the assessment
	AdditionalData map[string]*string            `json:"additionalData"`
	Links          *AssessmentLinks              `json:"links,omitempty"`
	Metadata       *AssessmentMetadataProperties `json:"metadata,omitempty"`
	PartnersData   *AssessmentPartnerData        `json:"partnersData,omitempty"`
}

// MarshalJSON is the custom marshaler for AssessmentProperties.
func (ap AssessmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.Status != nil {
		objectMap["status"] = ap.Status
	}
	objectMap["resourceDetails"] = ap.ResourceDetails
	if ap.AdditionalData != nil {
		objectMap["additionalData"] = ap.AdditionalData
	}
	if ap.Links != nil {
		objectMap["links"] = ap.Links
	}
	if ap.Metadata != nil {
		objectMap["metadata"] = ap.Metadata
	}
	if ap.PartnersData != nil {
		objectMap["partnersData"] = ap.PartnersData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AssessmentProperties struct.
func (ap *AssessmentProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "status":
			if v != nil {
				var status AssessmentStatus
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				ap.Status = &status
			}
		case "resourceDetails":
			if v != nil {
				resourceDetails, err := unmarshalBasicResourceDetails(*v)
				if err != nil {
					return err
				}
				ap.ResourceDetails = resourceDetails
			}
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				ap.DisplayName = &displayName
			}
		case "additionalData":
			if v != nil {
				var additionalData map[string]*string
				err = json.Unmarshal(*v, &additionalData)
				if err != nil {
					return err
				}
				ap.AdditionalData = additionalData
			}
		case "links":
			if v != nil {
				var links AssessmentLinks
				err = json.Unmarshal(*v, &links)
				if err != nil {
					return err
				}
				ap.Links = &links
			}
		case "metadata":
			if v != nil {
				var metadata AssessmentMetadataProperties
				err = json.Unmarshal(*v, &metadata)
				if err != nil {
					return err
				}
				ap.Metadata = &metadata
			}
		case "partnersData":
			if v != nil {
				var partnersData AssessmentPartnerData
				err = json.Unmarshal(*v, &partnersData)
				if err != nil {
					return err
				}
				ap.PartnersData = &partnersData
			}
		}
	}

	return nil
}

// AssessmentPropertiesBase describes properties of an assessment.
type AssessmentPropertiesBase struct {
	ResourceDetails BasicResourceDetails `json:"resourceDetails,omitempty"`
	// DisplayName - READ-ONLY; User friendly display name of the assessment
	DisplayName *string `json:"displayName,omitempty"`
	// AdditionalData - Additional data regarding the assessment
	AdditionalData map[string]*string            `json:"additionalData"`
	Links          *AssessmentLinks              `json:"links,omitempty"`
	Metadata       *AssessmentMetadataProperties `json:"metadata,omitempty"`
	PartnersData   *AssessmentPartnerData        `json:"partnersData,omitempty"`
}

// MarshalJSON is the custom marshaler for AssessmentPropertiesBase.
func (apb AssessmentPropertiesBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["resourceDetails"] = apb.ResourceDetails
	if apb.AdditionalData != nil {
		objectMap["additionalData"] = apb.AdditionalData
	}
	if apb.Links != nil {
		objectMap["links"] = apb.Links
	}
	if apb.Metadata != nil {
		objectMap["metadata"] = apb.Metadata
	}
	if apb.PartnersData != nil {
		objectMap["partnersData"] = apb.PartnersData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AssessmentPropertiesBase struct.
func (apb *AssessmentPropertiesBase) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "resourceDetails":
			if v != nil {
				resourceDetails, err := unmarshalBasicResourceDetails(*v)
				if err != nil {
					return err
				}
				apb.ResourceDetails = resourceDetails
			}
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				apb.DisplayName = &displayName
			}
		case "additionalData":
			if v != nil {
				var additionalData map[string]*string
				err = json.Unmarshal(*v, &additionalData)
				if err != nil {
					return err
				}
				apb.AdditionalData = additionalData
			}
		case "links":
			if v != nil {
				var links AssessmentLinks
				err = json.Unmarshal(*v, &links)
				if err != nil {
					return err
				}
				apb.Links = &links
			}
		case "metadata":
			if v != nil {
				var metadata AssessmentMetadataProperties
				err = json.Unmarshal(*v, &metadata)
				if err != nil {
					return err
				}
				apb.Metadata = &metadata
			}
		case "partnersData":
			if v != nil {
				var partnersData AssessmentPartnerData
				err = json.Unmarshal(*v, &partnersData)
				if err != nil {
					return err
				}
				apb.PartnersData = &partnersData
			}
		}
	}

	return nil
}

// AssessmentPropertiesResponse describes properties of an assessment.
type AssessmentPropertiesResponse struct {
	Status          *AssessmentStatusResponse `json:"status,omitempty"`
	ResourceDetails BasicResourceDetails      `json:"resourceDetails,omitempty"`
	// DisplayName - READ-ONLY; User friendly display name of the assessment
	DisplayName *string `json:"displayName,omitempty"`
	// AdditionalData - Additional data regarding the assessment
	AdditionalData map[string]*string            `json:"additionalData"`
	Links          *AssessmentLinks              `json:"links,omitempty"`
	Metadata       *AssessmentMetadataProperties `json:"metadata,omitempty"`
	PartnersData   *AssessmentPartnerData        `json:"partnersData,omitempty"`
}

// MarshalJSON is the custom marshaler for AssessmentPropertiesResponse.
func (apr AssessmentPropertiesResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if apr.Status != nil {
		objectMap["status"] = apr.Status
	}
	objectMap["resourceDetails"] = apr.ResourceDetails
	if apr.AdditionalData != nil {
		objectMap["additionalData"] = apr.AdditionalData
	}
	if apr.Links != nil {
		objectMap["links"] = apr.Links
	}
	if apr.Metadata != nil {
		objectMap["metadata"] = apr.Metadata
	}
	if apr.PartnersData != nil {
		objectMap["partnersData"] = apr.PartnersData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AssessmentPropertiesResponse struct.
func (apr *AssessmentPropertiesResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "status":
			if v != nil {
				var status AssessmentStatusResponse
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				apr.Status = &status
			}
		case "resourceDetails":
			if v != nil {
				resourceDetails, err := unmarshalBasicResourceDetails(*v)
				if err != nil {
					return err
				}
				apr.ResourceDetails = resourceDetails
			}
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				apr.DisplayName = &displayName
			}
		case "additionalData":
			if v != nil {
				var additionalData map[string]*string
				err = json.Unmarshal(*v, &additionalData)
				if err != nil {
					return err
				}
				apr.AdditionalData = additionalData
			}
		case "links":
			if v != nil {
				var links AssessmentLinks
				err = json.Unmarshal(*v, &links)
				if err != nil {
					return err
				}
				apr.Links = &links
			}
		case "metadata":
			if v != nil {
				var metadata AssessmentMetadataProperties
				err = json.Unmarshal(*v, &metadata)
				if err != nil {
					return err
				}
				apr.Metadata = &metadata
			}
		case "partnersData":
			if v != nil {
				var partnersData AssessmentPartnerData
				err = json.Unmarshal(*v, &partnersData)
				if err != nil {
					return err
				}
				apr.PartnersData = &partnersData
			}
		}
	}

	return nil
}

// AssessmentResponse security assessment on a resource - response format
type AssessmentResponse struct {
	autorest.Response             `json:"-"`
	*AssessmentPropertiesResponse `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AssessmentResponse.
func (ar AssessmentResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ar.AssessmentPropertiesResponse != nil {
		objectMap["properties"] = ar.AssessmentPropertiesResponse
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AssessmentResponse struct.
func (ar *AssessmentResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var assessmentPropertiesResponse AssessmentPropertiesResponse
				err = json.Unmarshal(*v, &assessmentPropertiesResponse)
				if err != nil {
					return err
				}
				ar.AssessmentPropertiesResponse = &assessmentPropertiesResponse
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ar.Type = &typeVar
			}
		}
	}

	return nil
}

// AssessmentStatus the result of the assessment
type AssessmentStatus struct {
	// Code - Programmatic code for the status of the assessment. Possible values include: 'Healthy', 'Unhealthy', 'NotApplicable'
	Code AssessmentStatusCode `json:"code,omitempty"`
	// Cause - Programmatic code for the cause of the assessment status
	Cause *string `json:"cause,omitempty"`
	// Description - Human readable description of the assessment status
	Description *string `json:"description,omitempty"`
}

// AssessmentStatusResponse the result of the assessment
type AssessmentStatusResponse struct {
	// FirstEvaluationDate - READ-ONLY; The time that the assessment was created and first evaluated. Returned as UTC time in ISO 8601 format
	FirstEvaluationDate *date.Time `json:"firstEvaluationDate,omitempty"`
	// StatusChangeDate - READ-ONLY; The time that the status of the assessment last changed. Returned as UTC time in ISO 8601 format
	StatusChangeDate *date.Time `json:"statusChangeDate,omitempty"`
	// Code - Programmatic code for the status of the assessment. Possible values include: 'Healthy', 'Unhealthy', 'NotApplicable'
	Code AssessmentStatusCode `json:"code,omitempty"`
	// Cause - Programmatic code for the cause of the assessment status
	Cause *string `json:"cause,omitempty"`
	// Description - Human readable description of the assessment status
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for AssessmentStatusResponse.
func (asr AssessmentStatusResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asr.Code != "" {
		objectMap["code"] = asr.Code
	}
	if asr.Cause != nil {
		objectMap["cause"] = asr.Cause
	}
	if asr.Description != nil {
		objectMap["description"] = asr.Description
	}
	return json.Marshal(objectMap)
}

// AtaExternalSecuritySolution represents an ATA security solution which sends logs to an OMS workspace
type AtaExternalSecuritySolution struct {
	Properties *AtaSolutionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty"`
	// Kind - Possible values include: 'KindExternalSecuritySolution', 'KindCEF', 'KindATA', 'KindAAD'
	Kind KindEnum `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for AtaExternalSecuritySolution.
func (aess AtaExternalSecuritySolution) MarshalJSON() ([]byte, error) {
	aess.Kind = KindATA
	objectMap := make(map[string]interface{})
	if aess.Properties != nil {
		objectMap["properties"] = aess.Properties
	}
	if aess.Kind != "" {
		objectMap["kind"] = aess.Kind
	}
	return json.Marshal(objectMap)
}

// AsCefExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AtaExternalSecuritySolution.
func (aess AtaExternalSecuritySolution) AsCefExternalSecuritySolution() (*CefExternalSecuritySolution, bool) {
	return nil, false
}

// AsAtaExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AtaExternalSecuritySolution.
func (aess AtaExternalSecuritySolution) AsAtaExternalSecuritySolution() (*AtaExternalSecuritySolution, bool) {
	return &aess, true
}

// AsAadExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AtaExternalSecuritySolution.
func (aess AtaExternalSecuritySolution) AsAadExternalSecuritySolution() (*AadExternalSecuritySolution, bool) {
	return nil, false
}

// AsExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AtaExternalSecuritySolution.
func (aess AtaExternalSecuritySolution) AsExternalSecuritySolution() (*ExternalSecuritySolution, bool) {
	return nil, false
}

// AsBasicExternalSecuritySolution is the BasicExternalSecuritySolution implementation for AtaExternalSecuritySolution.
func (aess AtaExternalSecuritySolution) AsBasicExternalSecuritySolution() (BasicExternalSecuritySolution, bool) {
	return &aess, true
}

// AtaSolutionProperties ...
type AtaSolutionProperties struct {
	LastEventReceived *string `json:"lastEventReceived,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	DeviceVendor         *string                `json:"deviceVendor,omitempty"`
	DeviceType           *string                `json:"deviceType,omitempty"`
	Workspace            *ConnectedWorkspace    `json:"workspace,omitempty"`
}

// MarshalJSON is the custom marshaler for AtaSolutionProperties.
func (asp AtaSolutionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asp.LastEventReceived != nil {
		objectMap["lastEventReceived"] = asp.LastEventReceived
	}
	if asp.DeviceVendor != nil {
		objectMap["deviceVendor"] = asp.DeviceVendor
	}
	if asp.DeviceType != nil {
		objectMap["deviceType"] = asp.DeviceType
	}
	if asp.Workspace != nil {
		objectMap["workspace"] = asp.Workspace
	}
	for k, v := range asp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AtaSolutionProperties struct.
func (asp *AtaSolutionProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "lastEventReceived":
			if v != nil {
				var lastEventReceived string
				err = json.Unmarshal(*v, &lastEventReceived)
				if err != nil {
					return err
				}
				asp.LastEventReceived = &lastEventReceived
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if asp.AdditionalProperties == nil {
					asp.AdditionalProperties = make(map[string]interface{})
				}
				asp.AdditionalProperties[k] = additionalProperties
			}
		case "deviceVendor":
			if v != nil {
				var deviceVendor string
				err = json.Unmarshal(*v, &deviceVendor)
				if err != nil {
					return err
				}
				asp.DeviceVendor = &deviceVendor
			}
		case "deviceType":
			if v != nil {
				var deviceType string
				err = json.Unmarshal(*v, &deviceType)
				if err != nil {
					return err
				}
				asp.DeviceType = &deviceType
			}
		case "workspace":
			if v != nil {
				var workspace ConnectedWorkspace
				err = json.Unmarshal(*v, &workspace)
				if err != nil {
					return err
				}
				asp.Workspace = &workspace
			}
		}
	}

	return nil
}

// BasicAuthenticationDetailsProperties settings for cloud authentication management
type BasicAuthenticationDetailsProperties interface {
	AsAwsCredsAuthenticationDetailsProperties() (*AwsCredsAuthenticationDetailsProperties, bool)
	AsAwAssumeRoleAuthenticationDetailsProperties() (*AwAssumeRoleAuthenticationDetailsProperties, bool)
	AsGcpCredentialsDetailsProperties() (*GcpCredentialsDetailsProperties, bool)
	AsAuthenticationDetailsProperties() (*AuthenticationDetailsProperties, bool)
}

// AuthenticationDetailsProperties settings for cloud authentication management
type AuthenticationDetailsProperties struct {
	// AuthenticationProvisioningState - READ-ONLY; State of the multi-cloud connector. Possible values include: 'Valid', 'Invalid', 'Expired', 'IncorrectPolicy'
	AuthenticationProvisioningState AuthenticationProvisioningState `json:"authenticationProvisioningState,omitempty"`
	// GrantedPermissions - READ-ONLY; The permissions detected in the cloud account.
	GrantedPermissions *[]PermissionProperty `json:"grantedPermissions,omitempty"`
	// AuthenticationType - Possible values include: 'AuthenticationTypeAuthenticationDetailsProperties', 'AuthenticationTypeAwsCreds', 'AuthenticationTypeAwsAssumeRole', 'AuthenticationTypeGcpCredentials'
	AuthenticationType AuthenticationType `json:"authenticationType,omitempty"`
}

func unmarshalBasicAuthenticationDetailsProperties(body []byte) (BasicAuthenticationDetailsProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["authenticationType"] {
	case string(AuthenticationTypeAwsCreds):
		var acadp AwsCredsAuthenticationDetailsProperties
		err := json.Unmarshal(body, &acadp)
		return acadp, err
	case string(AuthenticationTypeAwsAssumeRole):
		var aaradp AwAssumeRoleAuthenticationDetailsProperties
		err := json.Unmarshal(body, &aaradp)
		return aaradp, err
	case string(AuthenticationTypeGcpCredentials):
		var gcdp GcpCredentialsDetailsProperties
		err := json.Unmarshal(body, &gcdp)
		return gcdp, err
	default:
		var adp AuthenticationDetailsProperties
		err := json.Unmarshal(body, &adp)
		return adp, err
	}
}
func unmarshalBasicAuthenticationDetailsPropertiesArray(body []byte) ([]BasicAuthenticationDetailsProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	adpArray := make([]BasicAuthenticationDetailsProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		adp, err := unmarshalBasicAuthenticationDetailsProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		adpArray[index] = adp
	}
	return adpArray, nil
}

// MarshalJSON is the custom marshaler for AuthenticationDetailsProperties.
func (adp AuthenticationDetailsProperties) MarshalJSON() ([]byte, error) {
	adp.AuthenticationType = AuthenticationTypeAuthenticationDetailsProperties
	objectMap := make(map[string]interface{})
	if adp.AuthenticationType != "" {
		objectMap["authenticationType"] = adp.AuthenticationType
	}
	return json.Marshal(objectMap)
}

// AsAwsCredsAuthenticationDetailsProperties is the BasicAuthenticationDetailsProperties implementation for AuthenticationDetailsProperties.
func (adp AuthenticationDetailsProperties) AsAwsCredsAuthenticationDetailsProperties() (*AwsCredsAuthenticationDetailsProperties, bool) {
	return nil, false
}

// AsAwAssumeRoleAuthenticationDetailsProperties is the BasicAuthenticationDetailsProperties implementation for AuthenticationDetailsProperties.
func (adp AuthenticationDetailsProperties) AsAwAssumeRoleAuthenticationDetailsProperties() (*AwAssumeRoleAuthenticationDetailsProperties, bool) {
	return nil, false
}

// AsGcpCredentialsDetailsProperties is the BasicAuthenticationDetailsProperties implementation for AuthenticationDetailsProperties.
func (adp AuthenticationDetailsProperties) AsGcpCredentialsDetailsProperties() (*GcpCredentialsDetailsProperties, bool) {
	return nil, false
}

// AsAuthenticationDetailsProperties is the BasicAuthenticationDetailsProperties implementation for AuthenticationDetailsProperties.
func (adp AuthenticationDetailsProperties) AsAuthenticationDetailsProperties() (*AuthenticationDetailsProperties, bool) {
	return &adp, true
}

// AsBasicAuthenticationDetailsProperties is the BasicAuthenticationDetailsProperties implementation for AuthenticationDetailsProperties.
func (adp AuthenticationDetailsProperties) AsBasicAuthenticationDetailsProperties() (BasicAuthenticationDetailsProperties, bool) {
	return &adp, true
}

// Automation the security automation resource.
type Automation struct {
	autorest.Response `json:"-"`
	// AutomationProperties - Security automation data
	*AutomationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Location where the resource is stored
	Location *string `json:"location,omitempty"`
	// Kind - Kind of the resource
	Kind *string `json:"kind,omitempty"`
	// Etag - Entity tag is used for comparing two or more entities from the same requested resource.
	Etag *string `json:"etag,omitempty"`
	// Tags - A list of key value pairs that describe the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Automation.
func (a Automation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.AutomationProperties != nil {
		objectMap["properties"] = a.AutomationProperties
	}
	if a.Location != nil {
		objectMap["location"] = a.Location
	}
	if a.Kind != nil {
		objectMap["kind"] = a.Kind
	}
	if a.Etag != nil {
		objectMap["etag"] = a.Etag
	}
	if a.Tags != nil {
		objectMap["tags"] = a.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Automation struct.
func (a *Automation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var automationProperties AutomationProperties
				err = json.Unmarshal(*v, &automationProperties)
				if err != nil {
					return err
				}
				a.AutomationProperties = &automationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				a.Location = &location
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				a.Kind = &kind
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				a.Etag = &etag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				a.Tags = tags
			}
		}
	}

	return nil
}

// BasicAutomationAction the action that should be triggered.
type BasicAutomationAction interface {
	AsAutomationActionLogicApp() (*AutomationActionLogicApp, bool)
	AsAutomationActionEventHub() (*AutomationActionEventHub, bool)
	AsAutomationActionWorkspace() (*AutomationActionWorkspace, bool)
	AsAutomationAction() (*AutomationAction, bool)
}

// AutomationAction the action that should be triggered.
type AutomationAction struct {
	// ActionType - Possible values include: 'ActionTypeAutomationAction', 'ActionTypeLogicApp', 'ActionTypeEventHub', 'ActionTypeWorkspace'
	ActionType ActionType `json:"actionType,omitempty"`
}

func unmarshalBasicAutomationAction(body []byte) (BasicAutomationAction, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["actionType"] {
	case string(ActionTypeLogicApp):
		var aala AutomationActionLogicApp
		err := json.Unmarshal(body, &aala)
		return aala, err
	case string(ActionTypeEventHub):
		var aaeh AutomationActionEventHub
		err := json.Unmarshal(body, &aaeh)
		return aaeh, err
	case string(ActionTypeWorkspace):
		var aaw AutomationActionWorkspace
		err := json.Unmarshal(body, &aaw)
		return aaw, err
	default:
		var aa AutomationAction
		err := json.Unmarshal(body, &aa)
		return aa, err
	}
}
func unmarshalBasicAutomationActionArray(body []byte) ([]BasicAutomationAction, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aaArray := make([]BasicAutomationAction, len(rawMessages))

	for index, rawMessage := range rawMessages {
		aa, err := unmarshalBasicAutomationAction(*rawMessage)
		if err != nil {
			return nil, err
		}
		aaArray[index] = aa
	}
	return aaArray, nil
}

// MarshalJSON is the custom marshaler for AutomationAction.
func (aa AutomationAction) MarshalJSON() ([]byte, error) {
	aa.ActionType = ActionTypeAutomationAction
	objectMap := make(map[string]interface{})
	if aa.ActionType != "" {
		objectMap["actionType"] = aa.ActionType
	}
	return json.Marshal(objectMap)
}

// AsAutomationActionLogicApp is the BasicAutomationAction implementation for AutomationAction.
func (aa AutomationAction) AsAutomationActionLogicApp() (*AutomationActionLogicApp, bool) {
	return nil, false
}

// AsAutomationActionEventHub is the BasicAutomationAction implementation for AutomationAction.
func (aa AutomationAction) AsAutomationActionEventHub() (*AutomationActionEventHub, bool) {
	return nil, false
}

// AsAutomationActionWorkspace is the BasicAutomationAction implementation for AutomationAction.
func (aa AutomationAction) AsAutomationActionWorkspace() (*AutomationActionWorkspace, bool) {
	return nil, false
}

// AsAutomationAction is the BasicAutomationAction implementation for AutomationAction.
func (aa AutomationAction) AsAutomationAction() (*AutomationAction, bool) {
	return &aa, true
}

// AsBasicAutomationAction is the BasicAutomationAction implementation for AutomationAction.
func (aa AutomationAction) AsBasicAutomationAction() (BasicAutomationAction, bool) {
	return &aa, true
}

// AutomationActionEventHub the target Event Hub to which event data will be exported. To learn more about
// Microsoft Defender for Cloud continuous export capabilities, visit https://aka.ms/ASCExportLearnMore
type AutomationActionEventHub struct {
	// EventHubResourceID - The target Event Hub Azure Resource ID.
	EventHubResourceID *string `json:"eventHubResourceId,omitempty"`
	// SasPolicyName - READ-ONLY; The target Event Hub SAS policy name.
	SasPolicyName *string `json:"sasPolicyName,omitempty"`
	// ConnectionString - The target Event Hub connection string (it will not be included in any response).
	ConnectionString *string `json:"connectionString,omitempty"`
	// ActionType - Possible values include: 'ActionTypeAutomationAction', 'ActionTypeLogicApp', 'ActionTypeEventHub', 'ActionTypeWorkspace'
	ActionType ActionType `json:"actionType,omitempty"`
}

// MarshalJSON is the custom marshaler for AutomationActionEventHub.
func (aaeh AutomationActionEventHub) MarshalJSON() ([]byte, error) {
	aaeh.ActionType = ActionTypeEventHub
	objectMap := make(map[string]interface{})
	if aaeh.EventHubResourceID != nil {
		objectMap["eventHubResourceId"] = aaeh.EventHubResourceID
	}
	if aaeh.ConnectionString != nil {
		objectMap["connectionString"] = aaeh.ConnectionString
	}
	if aaeh.ActionType != "" {
		objectMap["actionType"] = aaeh.ActionType
	}
	return json.Marshal(objectMap)
}

// AsAutomationActionLogicApp is the BasicAutomationAction implementation for AutomationActionEventHub.
func (aaeh AutomationActionEventHub) AsAutomationActionLogicApp() (*AutomationActionLogicApp, bool) {
	return nil, false
}

// AsAutomationActionEventHub is the BasicAutomationAction implementation for AutomationActionEventHub.
func (aaeh AutomationActionEventHub) AsAutomationActionEventHub() (*AutomationActionEventHub, bool) {
	return &aaeh, true
}

// AsAutomationActionWorkspace is the BasicAutomationAction implementation for AutomationActionEventHub.
func (aaeh AutomationActionEventHub) AsAutomationActionWorkspace() (*AutomationActionWorkspace, bool) {
	return nil, false
}

// AsAutomationAction is the BasicAutomationAction implementation for AutomationActionEventHub.
func (aaeh AutomationActionEventHub) AsAutomationAction() (*AutomationAction, bool) {
	return nil, false
}

// AsBasicAutomationAction is the BasicAutomationAction implementation for AutomationActionEventHub.
func (aaeh AutomationActionEventHub) AsBasicAutomationAction() (BasicAutomationAction, bool) {
	return &aaeh, true
}

// AutomationActionLogicApp the logic app action that should be triggered. To learn more about Microsoft
// Defender for Cloud's Workflow Automation capabilities, visit
// https://aka.ms/ASCWorkflowAutomationLearnMore
type AutomationActionLogicApp struct {
	// LogicAppResourceID - The triggered Logic App Azure Resource ID. This can also reside on other subscriptions, given that you have permissions to trigger the Logic App
	LogicAppResourceID *string `json:"logicAppResourceId,omitempty"`
	// URI - The Logic App trigger URI endpoint (it will not be included in any response).
	URI *string `json:"uri,omitempty"`
	// ActionType - Possible values include: 'ActionTypeAutomationAction', 'ActionTypeLogicApp', 'ActionTypeEventHub', 'ActionTypeWorkspace'
	ActionType ActionType `json:"actionType,omitempty"`
}

// MarshalJSON is the custom marshaler for AutomationActionLogicApp.
func (aala AutomationActionLogicApp) MarshalJSON() ([]byte, error) {
	aala.ActionType = ActionTypeLogicApp
	objectMap := make(map[string]interface{})
	if aala.LogicAppResourceID != nil {
		objectMap["logicAppResourceId"] = aala.LogicAppResourceID
	}
	if aala.URI != nil {
		objectMap["uri"] = aala.URI
	}
	if aala.ActionType != "" {
		objectMap["actionType"] = aala.ActionType
	}
	return json.Marshal(objectMap)
}

// AsAutomationActionLogicApp is the BasicAutomationAction implementation for AutomationActionLogicApp.
func (aala AutomationActionLogicApp) AsAutomationActionLogicApp() (*AutomationActionLogicApp, bool) {
	return &aala, true
}

// AsAutomationActionEventHub is the BasicAutomationAction implementation for AutomationActionLogicApp.
func (aala AutomationActionLogicApp) AsAutomationActionEventHub() (*AutomationActionEventHub, bool) {
	return nil, false
}

// AsAutomationActionWorkspace is the BasicAutomationAction implementation for AutomationActionLogicApp.
func (aala AutomationActionLogicApp) AsAutomationActionWorkspace() (*AutomationActionWorkspace, bool) {
	return nil, false
}

// AsAutomationAction is the BasicAutomationAction implementation for AutomationActionLogicApp.
func (aala AutomationActionLogicApp) AsAutomationAction() (*AutomationAction, bool) {
	return nil, false
}

// AsBasicAutomationAction is the BasicAutomationAction implementation for AutomationActionLogicApp.
func (aala AutomationActionLogicApp) AsBasicAutomationAction() (BasicAutomationAction, bool) {
	return &aala, true
}

// AutomationActionWorkspace the Log Analytics Workspace to which event data will be exported. Security
// alerts data will reside in the 'SecurityAlert' table and the assessments data will reside in the
// 'SecurityRecommendation' table (under the 'Security'/'SecurityCenterFree' solutions). Note that in order
// to view the data in the workspace, the Security Center Log Analytics free/standard solution needs to be
// enabled on that workspace. To learn more about Microsoft Defender for Cloud continuous export
// capabilities, visit https://aka.ms/ASCExportLearnMore
type AutomationActionWorkspace struct {
	// WorkspaceResourceID - The fully qualified Log Analytics Workspace Azure Resource ID.
	WorkspaceResourceID *string `json:"workspaceResourceId,omitempty"`
	// ActionType - Possible values include: 'ActionTypeAutomationAction', 'ActionTypeLogicApp', 'ActionTypeEventHub', 'ActionTypeWorkspace'
	ActionType ActionType `json:"actionType,omitempty"`
}

// MarshalJSON is the custom marshaler for AutomationActionWorkspace.
func (aaw AutomationActionWorkspace) MarshalJSON() ([]byte, error) {
	aaw.ActionType = ActionTypeWorkspace
	objectMap := make(map[string]interface{})
	if aaw.WorkspaceResourceID != nil {
		objectMap["workspaceResourceId"] = aaw.WorkspaceResourceID
	}
	if aaw.ActionType != "" {
		objectMap["actionType"] = aaw.ActionType
	}
	return json.Marshal(objectMap)
}

// AsAutomationActionLogicApp is the BasicAutomationAction implementation for AutomationActionWorkspace.
func (aaw AutomationActionWorkspace) AsAutomationActionLogicApp() (*AutomationActionLogicApp, bool) {
	return nil, false
}

// AsAutomationActionEventHub is the BasicAutomationAction implementation for AutomationActionWorkspace.
func (aaw AutomationActionWorkspace) AsAutomationActionEventHub() (*AutomationActionEventHub, bool) {
	return nil, false
}

// AsAutomationActionWorkspace is the BasicAutomationAction implementation for AutomationActionWorkspace.
func (aaw AutomationActionWorkspace) AsAutomationActionWorkspace() (*AutomationActionWorkspace, bool) {
	return &aaw, true
}

// AsAutomationAction is the BasicAutomationAction implementation for AutomationActionWorkspace.
func (aaw AutomationActionWorkspace) AsAutomationAction() (*AutomationAction, bool) {
	return nil, false
}

// AsBasicAutomationAction is the BasicAutomationAction implementation for AutomationActionWorkspace.
func (aaw AutomationActionWorkspace) AsBasicAutomationAction() (BasicAutomationAction, bool) {
	return &aaw, true
}

// AutomationList list of security automations response.
type AutomationList struct {
	autorest.Response `json:"-"`
	// Value - The list of security automations under the given scope.
	Value *[]Automation `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AutomationList.
func (al AutomationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if al.Value != nil {
		objectMap["value"] = al.Value
	}
	return json.Marshal(objectMap)
}

// AutomationListIterator provides access to a complete listing of Automation values.
type AutomationListIterator struct {
	i    int
	page AutomationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AutomationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AutomationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AutomationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AutomationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AutomationListIterator) Response() AutomationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AutomationListIterator) Value() Automation {
	if !iter.page.NotDone() {
		return Automation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AutomationListIterator type.
func NewAutomationListIterator(page AutomationListPage) AutomationListIterator {
	return AutomationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (al AutomationList) IsEmpty() bool {
	return al.Value == nil || len(*al.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (al AutomationList) hasNextLink() bool {
	return al.NextLink != nil && len(*al.NextLink) != 0
}

// automationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (al AutomationList) automationListPreparer(ctx context.Context) (*http.Request, error) {
	if !al.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(al.NextLink)))
}

// AutomationListPage contains a page of Automation values.
type AutomationListPage struct {
	fn func(context.Context, AutomationList) (AutomationList, error)
	al AutomationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AutomationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AutomationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.al)
		if err != nil {
			return err
		}
		page.al = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AutomationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AutomationListPage) NotDone() bool {
	return !page.al.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AutomationListPage) Response() AutomationList {
	return page.al
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AutomationListPage) Values() []Automation {
	if page.al.IsEmpty() {
		return nil
	}
	return *page.al.Value
}

// Creates a new instance of the AutomationListPage type.
func NewAutomationListPage(cur AutomationList, getNextPage func(context.Context, AutomationList) (AutomationList, error)) AutomationListPage {
	return AutomationListPage{
		fn: getNextPage,
		al: cur,
	}
}

// AutomationProperties a set of properties that defines the behavior of the automation configuration. To
// learn more about the supported security events data models schemas - please visit
// https://aka.ms/ASCAutomationSchemas.
type AutomationProperties struct {
	// Description - The security automation description.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Indicates whether the security automation is enabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// Scopes - A collection of scopes on which the security automations logic is applied. Supported scopes are the subscription itself or a resource group under that subscription. The automation will only apply on defined scopes.
	Scopes *[]AutomationScope `json:"scopes,omitempty"`
	// Sources - A collection of the source event types which evaluate the security automation set of rules.
	Sources *[]AutomationSource `json:"sources,omitempty"`
	// Actions - A collection of the actions which are triggered if all the configured rules evaluations, within at least one rule set, are true.
	Actions *[]BasicAutomationAction `json:"actions,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AutomationProperties struct.
func (ap *AutomationProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				ap.Description = &description
			}
		case "isEnabled":
			if v != nil {
				var isEnabled bool
				err = json.Unmarshal(*v, &isEnabled)
				if err != nil {
					return err
				}
				ap.IsEnabled = &isEnabled
			}
		case "scopes":
			if v != nil {
				var scopes []AutomationScope
				err = json.Unmarshal(*v, &scopes)
				if err != nil {
					return err
				}
				ap.Scopes = &scopes
			}
		case "sources":
			if v != nil {
				var sources []AutomationSource
				err = json.Unmarshal(*v, &sources)
				if err != nil {
					return err
				}
				ap.Sources = &sources
			}
		case "actions":
			if v != nil {
				actions, err := unmarshalBasicAutomationActionArray(*v)
				if err != nil {
					return err
				}
				ap.Actions = &actions
			}
		}
	}

	return nil
}

// AutomationRuleSet a rule set which evaluates all its rules upon an event interception. Only when all the
// included rules in the rule set will be evaluated as 'true', will the event trigger the defined actions.
type AutomationRuleSet struct {
	Rules *[]AutomationTriggeringRule `json:"rules,omitempty"`
}

// AutomationScope a single automation scope.
type AutomationScope struct {
	// Description - The resources scope description.
	Description *string `json:"description,omitempty"`
	// ScopePath - The resources scope path. Can be the subscription on which the automation is defined on or a resource group under that subscription (fully qualified Azure resource IDs).
	ScopePath *string `json:"scopePath,omitempty"`
}

// AutomationSource the source event types which evaluate the security automation set of rules. For example
// - security alerts and security assessments. To learn more about the supported security events data
// models schemas - please visit https://aka.ms/ASCAutomationSchemas.
type AutomationSource struct {
	// EventSource - A valid event source type. Possible values include: 'EventSourceAssessments', 'EventSourceAssessmentsSnapshot', 'EventSourceSubAssessments', 'EventSourceSubAssessmentsSnapshot', 'EventSourceAlerts', 'EventSourceSecureScores', 'EventSourceSecureScoresSnapshot', 'EventSourceSecureScoreControls', 'EventSourceSecureScoreControlsSnapshot', 'EventSourceRegulatoryComplianceAssessment', 'EventSourceRegulatoryComplianceAssessmentSnapshot'
	EventSource EventSource `json:"eventSource,omitempty"`
	// RuleSets - A set of rules which evaluate upon event interception. A logical disjunction is applied between defined rule sets (logical 'or').
	RuleSets *[]AutomationRuleSet `json:"ruleSets,omitempty"`
}

// AutomationTriggeringRule a rule which is evaluated upon event interception. The rule is configured by
// comparing a specific value from the event model to an expected value. This comparison is done by using
// one of the supported operators set.
type AutomationTriggeringRule struct {
	// PropertyJPath - The JPath of the entity model property that should be checked.
	PropertyJPath *string `json:"propertyJPath,omitempty"`
	// PropertyType - The data type of the compared operands (string, integer, floating point number or a boolean [true/false]]. Possible values include: 'String', 'Integer', 'Number', 'Boolean'
	PropertyType PropertyType `json:"propertyType,omitempty"`
	// ExpectedValue - The expected value.
	ExpectedValue *string `json:"expectedValue,omitempty"`
	// Operator - A valid comparer operator to use. A case-insensitive comparison will be applied for String PropertyType. Possible values include: 'OperatorEquals', 'OperatorGreaterThan', 'OperatorGreaterThanOrEqualTo', 'OperatorLesserThan', 'OperatorLesserThanOrEqualTo', 'OperatorNotEquals', 'OperatorContains', 'OperatorStartsWith', 'OperatorEndsWith'
	Operator Operator `json:"operator,omitempty"`
}

// AutomationValidationStatus the security automation model state property bag.
type AutomationValidationStatus struct {
	autorest.Response `json:"-"`
	// IsValid - Indicates whether the model is valid or not.
	IsValid *bool `json:"isValid,omitempty"`
	// Message - The validation message.
	Message *string `json:"message,omitempty"`
}

// AutoProvisioningSetting auto provisioning setting
type AutoProvisioningSetting struct {
	autorest.Response `json:"-"`
	// AutoProvisioningSettingProperties - Auto provisioning setting data
	*AutoProvisioningSettingProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AutoProvisioningSetting.
func (aps AutoProvisioningSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aps.AutoProvisioningSettingProperties != nil {
		objectMap["properties"] = aps.AutoProvisioningSettingProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AutoProvisioningSetting struct.
func (aps *AutoProvisioningSetting) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var autoProvisioningSettingProperties AutoProvisioningSettingProperties
				err = json.Unmarshal(*v, &autoProvisioningSettingProperties)
				if err != nil {
					return err
				}
				aps.AutoProvisioningSettingProperties = &autoProvisioningSettingProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				aps.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				aps.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				aps.Type = &typeVar
			}
		}
	}

	return nil
}

// AutoProvisioningSettingList list of all the auto provisioning settings response
type AutoProvisioningSettingList struct {
	autorest.Response `json:"-"`
	// Value - List of all the auto provisioning settings
	Value *[]AutoProvisioningSetting `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AutoProvisioningSettingList.
func (apsl AutoProvisioningSettingList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if apsl.Value != nil {
		objectMap["value"] = apsl.Value
	}
	return json.Marshal(objectMap)
}

// AutoProvisioningSettingListIterator provides access to a complete listing of AutoProvisioningSetting
// values.
type AutoProvisioningSettingListIterator struct {
	i    int
	page AutoProvisioningSettingListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AutoProvisioningSettingListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AutoProvisioningSettingListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AutoProvisioningSettingListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AutoProvisioningSettingListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AutoProvisioningSettingListIterator) Response() AutoProvisioningSettingList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AutoProvisioningSettingListIterator) Value() AutoProvisioningSetting {
	if !iter.page.NotDone() {
		return AutoProvisioningSetting{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AutoProvisioningSettingListIterator type.
func NewAutoProvisioningSettingListIterator(page AutoProvisioningSettingListPage) AutoProvisioningSettingListIterator {
	return AutoProvisioningSettingListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (apsl AutoProvisioningSettingList) IsEmpty() bool {
	return apsl.Value == nil || len(*apsl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (apsl AutoProvisioningSettingList) hasNextLink() bool {
	return apsl.NextLink != nil && len(*apsl.NextLink) != 0
}

// autoProvisioningSettingListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (apsl AutoProvisioningSettingList) autoProvisioningSettingListPreparer(ctx context.Context) (*http.Request, error) {
	if !apsl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(apsl.NextLink)))
}

// AutoProvisioningSettingListPage contains a page of AutoProvisioningSetting values.
type AutoProvisioningSettingListPage struct {
	fn   func(context.Context, AutoProvisioningSettingList) (AutoProvisioningSettingList, error)
	apsl AutoProvisioningSettingList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AutoProvisioningSettingListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AutoProvisioningSettingListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.apsl)
		if err != nil {
			return err
		}
		page.apsl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AutoProvisioningSettingListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AutoProvisioningSettingListPage) NotDone() bool {
	return !page.apsl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AutoProvisioningSettingListPage) Response() AutoProvisioningSettingList {
	return page.apsl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AutoProvisioningSettingListPage) Values() []AutoProvisioningSetting {
	if page.apsl.IsEmpty() {
		return nil
	}
	return *page.apsl.Value
}

// Creates a new instance of the AutoProvisioningSettingListPage type.
func NewAutoProvisioningSettingListPage(cur AutoProvisioningSettingList, getNextPage func(context.Context, AutoProvisioningSettingList) (AutoProvisioningSettingList, error)) AutoProvisioningSettingListPage {
	return AutoProvisioningSettingListPage{
		fn:   getNextPage,
		apsl: cur,
	}
}

// AutoProvisioningSettingProperties describes properties of an auto provisioning setting
type AutoProvisioningSettingProperties struct {
	// AutoProvision - Describes what kind of security agent provisioning action to take. Possible values include: 'On', 'Off'
	AutoProvision AutoProvision `json:"autoProvision,omitempty"`
}

// AwAssumeRoleAuthenticationDetailsProperties AWS cloud account connector based assume role, the role
// enables delegating access to your AWS resources. The role is composed of role Amazon Resource Name (ARN)
// and external ID. For more details, refer to <a
// href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user.html">Creating a Role to
// Delegate Permissions to an IAM User (write only)</a>
type AwAssumeRoleAuthenticationDetailsProperties struct {
	// AccountID - READ-ONLY; The ID of the cloud account
	AccountID *string `json:"accountId,omitempty"`
	// AwsAssumeRoleArn - Assumed role ID is an identifier that you can use to create temporary security credentials.
	AwsAssumeRoleArn *string `json:"awsAssumeRoleArn,omitempty"`
	// AwsExternalID - A unique identifier that is required when you assume a role in another account.
	AwsExternalID *string `json:"awsExternalId,omitempty"`
	// AuthenticationProvisioningState - READ-ONLY; State of the multi-cloud connector. Possible values include: 'Valid', 'Invalid', 'Expired', 'IncorrectPolicy'
	AuthenticationProvisioningState AuthenticationProvisioningState `json:"authenticationProvisioningState,omitempty"`
	// GrantedPermissions - READ-ONLY; The permissions detected in the cloud account.
	GrantedPermissions *[]PermissionProperty `json:"grantedPermissions,omitempty"`
	// AuthenticationType - Possible values include: 'AuthenticationTypeAuthenticationDetailsProperties', 'AuthenticationTypeAwsCreds', 'AuthenticationTypeAwsAssumeRole', 'AuthenticationTypeGcpCredentials'
	AuthenticationType AuthenticationType `json:"authenticationType,omitempty"`
}

// MarshalJSON is the custom marshaler for AwAssumeRoleAuthenticationDetailsProperties.
func (aaradp AwAssumeRoleAuthenticationDetailsProperties) MarshalJSON() ([]byte, error) {
	aaradp.AuthenticationType = AuthenticationTypeAwsAssumeRole
	objectMap := make(map[string]interface{})
	if aaradp.AwsAssumeRoleArn != nil {
		objectMap["awsAssumeRoleArn"] = aaradp.AwsAssumeRoleArn
	}
	if aaradp.AwsExternalID != nil {
		objectMap["awsExternalId"] = aaradp.AwsExternalID
	}
	if aaradp.AuthenticationType != "" {
		objectMap["authenticationType"] = aaradp.AuthenticationType
	}
	return json.Marshal(objectMap)
}

// AsAwsCredsAuthenticationDetailsProperties is the BasicAuthenticationDetailsProperties implementation for AwAssumeRoleAuthenticationDetailsProperties.
func (aaradp AwAssumeRoleAuthenticationDetailsProperties) AsAwsCredsAuthenticationDetailsProperties() (*AwsCredsAuthenticationDetailsProperties, bool) {
	return nil, false
}

// AsAwAssumeRoleAuthenticationDetailsProperties is the BasicAuthenticationDetailsProperties implementation for AwAssumeRoleAuthenticationDetailsProperties.
func (aaradp AwAssumeRoleAuthenticationDetailsProperties) AsAwAssumeRoleAuthenticationDetailsProperties() (*AwAssumeRoleAuthenticationDetailsProperties, bool) {
	return &aaradp, true
}

// AsGcpCredentialsDetailsProperties is the BasicAuthenticationDetailsProperties implementation for AwAssumeRoleAuthenticationDetailsProperties.
func (aaradp AwAssumeRoleAuthenticationDetailsProperties) AsGcpCredentialsDetailsProperties() (*GcpCredentialsDetailsProperties, bool) {
	return nil, false
}

// AsAuthenticationDetailsProperties is the BasicAuthenticationDetailsProperties implementation for AwAssumeRoleAuthenticationDetailsProperties.
func (aaradp AwAssumeRoleAuthenticationDetailsProperties) AsAuthenticationDetailsProperties() (*AuthenticationDetailsProperties, bool) {
	return nil, false
}

// AsBasicAuthenticationDetailsProperties is the BasicAuthenticationDetailsProperties implementation for AwAssumeRoleAuthenticationDetailsProperties.
func (aaradp AwAssumeRoleAuthenticationDetailsProperties) AsBasicAuthenticationDetailsProperties() (BasicAuthenticationDetailsProperties, bool) {
	return &aaradp, true
}

// AwsCredsAuthenticationDetailsProperties AWS cloud account connector based credentials, the credentials
// is composed of access key ID and secret key, for more details, refer to <a
// href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_create.html">Creating an IAM User in
// Your AWS Account (write only)</a>
type AwsCredsAuthenticationDetailsProperties struct {
	// AccountID - READ-ONLY; The ID of the cloud account
	AccountID *string `json:"accountId,omitempty"`
	// AwsAccessKeyID - Public key element of the AWS credential object (write only)
	AwsAccessKeyID *string `json:"awsAccessKeyId,omitempty"`
	// AwsSecretAccessKey - Secret key element of the AWS credential object (write only)
	AwsSecretAccessKey *string `json:"awsSecretAccessKey,omitempty"`
	// AuthenticationProvisioningState - READ-ONLY; State of the multi-cloud connector. Possible values include: 'Valid', 'Invalid', 'Expired', 'IncorrectPolicy'
	AuthenticationProvisioningState AuthenticationProvisioningState `json:"authenticationProvisioningState,omitempty"`
	// GrantedPermissions - READ-ONLY; The permissions detected in the cloud account.
	GrantedPermissions *[]PermissionProperty `json:"grantedPermissions,omitempty"`
	// AuthenticationType - Possible values include: 'AuthenticationTypeAuthenticationDetailsProperties', 'AuthenticationTypeAwsCreds', 'AuthenticationTypeAwsAssumeRole', 'AuthenticationTypeGcpCredentials'
	AuthenticationType AuthenticationType `json:"authenticationType,omitempty"`
}

// MarshalJSON is the custom marshaler for AwsCredsAuthenticationDetailsProperties.
func (acadp AwsCredsAuthenticationDetailsProperties) MarshalJSON() ([]byte, error) {
	acadp.AuthenticationType = AuthenticationTypeAwsCreds
	objectMap := make(map[string]interface{})
	if acadp.AwsAccessKeyID != nil {
		objectMap["awsAccessKeyId"] = acadp.AwsAccessKeyID
	}
	if acadp.AwsSecretAccessKey != nil {
		objectMap["awsSecretAccessKey"] = acadp.AwsSecretAccessKey
	}
	if acadp.AuthenticationType != "" {
		objectMap["authenticationType"] = acadp.AuthenticationType
	}
	return json.Marshal(objectMap)
}

// AsAwsCredsAuthenticationDetailsProperties is the BasicAuthenticationDetailsProperties implementation for AwsCredsAuthenticationDetailsProperties.
func (acadp AwsCredsAuthenticationDetailsProperties) AsAwsCredsAuthenticationDetailsProperties() (*AwsCredsAuthenticationDetailsProperties, bool) {
	return &acadp, true
}

// AsAwAssumeRoleAuthenticationDetailsProperties is the BasicAuthenticationDetailsProperties implementation for AwsCredsAuthenticationDetailsProperties.
func (acadp AwsCredsAuthenticationDetailsProperties) AsAwAssumeRoleAuthenticationDetailsProperties() (*AwAssumeRoleAuthenticationDetailsProperties, bool) {
	return nil, false
}

// AsGcpCredentialsDetailsProperties is the BasicAuthenticationDetailsProperties implementation for AwsCredsAuthenticationDetailsProperties.
func (acadp AwsCredsAuthenticationDetailsProperties) AsGcpCredentialsDetailsProperties() (*GcpCredentialsDetailsProperties, bool) {
	return nil, false
}

// AsAuthenticationDetailsProperties is the BasicAuthenticationDetailsProperties implementation for AwsCredsAuthenticationDetailsProperties.
func (acadp AwsCredsAuthenticationDetailsProperties) AsAuthenticationDetailsProperties() (*AuthenticationDetailsProperties, bool) {
	return nil, false
}

// AsBasicAuthenticationDetailsProperties is the BasicAuthenticationDetailsProperties implementation for AwsCredsAuthenticationDetailsProperties.
func (acadp AwsCredsAuthenticationDetailsProperties) AsBasicAuthenticationDetailsProperties() (BasicAuthenticationDetailsProperties, bool) {
	return &acadp, true
}

// AwsEnvironmentData the aws connector environment data
type AwsEnvironmentData struct {
	// OrganizationalData - The AWS account's organizational data
	OrganizationalData BasicAwsOrganizationalData `json:"organizationalData,omitempty"`
	// EnvironmentType - Possible values include: 'EnvironmentTypeEnvironmentData', 'EnvironmentTypeAwsAccount', 'EnvironmentTypeGcpProject', 'EnvironmentTypeGithubScope', 'EnvironmentTypeAzureDevOpsScope'
	EnvironmentType EnvironmentType `json:"environmentType,omitempty"`
}

// MarshalJSON is the custom marshaler for AwsEnvironmentData.
func (aed AwsEnvironmentData) MarshalJSON() ([]byte, error) {
	aed.EnvironmentType = EnvironmentTypeAwsAccount
	objectMap := make(map[string]interface{})
	objectMap["organizationalData"] = aed.OrganizationalData
	if aed.EnvironmentType != "" {
		objectMap["environmentType"] = aed.EnvironmentType
	}
	return json.Marshal(objectMap)
}

// AsAwsEnvironmentData is the BasicEnvironmentData implementation for AwsEnvironmentData.
func (aed AwsEnvironmentData) AsAwsEnvironmentData() (*AwsEnvironmentData, bool) {
	return &aed, true
}

// AsGcpProjectEnvironmentData is the BasicEnvironmentData implementation for AwsEnvironmentData.
func (aed AwsEnvironmentData) AsGcpProjectEnvironmentData() (*GcpProjectEnvironmentData, bool) {
	return nil, false
}

// AsGithubScopeEnvironmentData is the BasicEnvironmentData implementation for AwsEnvironmentData.
func (aed AwsEnvironmentData) AsGithubScopeEnvironmentData() (*GithubScopeEnvironmentData, bool) {
	return nil, false
}

// AsAzureDevOpsScopeEnvironmentData is the BasicEnvironmentData implementation for AwsEnvironmentData.
func (aed AwsEnvironmentData) AsAzureDevOpsScopeEnvironmentData() (*AzureDevOpsScopeEnvironmentData, bool) {
	return nil, false
}

// AsEnvironmentData is the BasicEnvironmentData implementation for AwsEnvironmentData.
func (aed AwsEnvironmentData) AsEnvironmentData() (*EnvironmentData, bool) {
	return nil, false
}

// AsBasicEnvironmentData is the BasicEnvironmentData implementation for AwsEnvironmentData.
func (aed AwsEnvironmentData) AsBasicEnvironmentData() (BasicEnvironmentData, bool) {
	return &aed, true
}

// UnmarshalJSON is the custom unmarshaler for AwsEnvironmentData struct.
func (aed *AwsEnvironmentData) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "organizationalData":
			if v != nil {
				organizationalData, err := unmarshalBasicAwsOrganizationalData(*v)
				if err != nil {
					return err
				}
				aed.OrganizationalData = organizationalData
			}
		case "environmentType":
			if v != nil {
				var environmentType EnvironmentType
				err = json.Unmarshal(*v, &environmentType)
				if err != nil {
					return err
				}
				aed.EnvironmentType = environmentType
			}
		}
	}

	return nil
}

// BasicAwsOrganizationalData the awsOrganization data
type BasicAwsOrganizationalData interface {
	AsAwsOrganizationalDataMaster() (*AwsOrganizationalDataMaster, bool)
	AsAwsOrganizationalDataMember() (*AwsOrganizationalDataMember, bool)
	AsAwsOrganizationalData() (*AwsOrganizationalData, bool)
}

// AwsOrganizationalData the awsOrganization data
type AwsOrganizationalData struct {
	// OrganizationMembershipType - Possible values include: 'OrganizationMembershipTypeAwsOrganizationalData', 'OrganizationMembershipTypeOrganization', 'OrganizationMembershipTypeMember'
	OrganizationMembershipType OrganizationMembershipType `json:"organizationMembershipType,omitempty"`
}

func unmarshalBasicAwsOrganizationalData(body []byte) (BasicAwsOrganizationalData, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["organizationMembershipType"] {
	case string(OrganizationMembershipTypeOrganization):
		var aodm AwsOrganizationalDataMaster
		err := json.Unmarshal(body, &aodm)
		return aodm, err
	case string(OrganizationMembershipTypeMember):
		var aodm AwsOrganizationalDataMember
		err := json.Unmarshal(body, &aodm)
		return aodm, err
	default:
		var aod AwsOrganizationalData
		err := json.Unmarshal(body, &aod)
		return aod, err
	}
}
func unmarshalBasicAwsOrganizationalDataArray(body []byte) ([]BasicAwsOrganizationalData, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aodArray := make([]BasicAwsOrganizationalData, len(rawMessages))

	for index, rawMessage := range rawMessages {
		aod, err := unmarshalBasicAwsOrganizationalData(*rawMessage)
		if err != nil {
			return nil, err
		}
		aodArray[index] = aod
	}
	return aodArray, nil
}

// MarshalJSON is the custom marshaler for AwsOrganizationalData.
func (aod AwsOrganizationalData) MarshalJSON() ([]byte, error) {
	aod.OrganizationMembershipType = OrganizationMembershipTypeAwsOrganizationalData
	objectMap := make(map[string]interface{})
	if aod.OrganizationMembershipType != "" {
		objectMap["organizationMembershipType"] = aod.OrganizationMembershipType
	}
	return json.Marshal(objectMap)
}

// AsAwsOrganizationalDataMaster is the BasicAwsOrganizationalData implementation for AwsOrganizationalData.
func (aod AwsOrganizationalData) AsAwsOrganizationalDataMaster() (*AwsOrganizationalDataMaster, bool) {
	return nil, false
}

// AsAwsOrganizationalDataMember is the BasicAwsOrganizationalData implementation for AwsOrganizationalData.
func (aod AwsOrganizationalData) AsAwsOrganizationalDataMember() (*AwsOrganizationalDataMember, bool) {
	return nil, false
}

// AsAwsOrganizationalData is the BasicAwsOrganizationalData implementation for AwsOrganizationalData.
func (aod AwsOrganizationalData) AsAwsOrganizationalData() (*AwsOrganizationalData, bool) {
	return &aod, true
}

// AsBasicAwsOrganizationalData is the BasicAwsOrganizationalData implementation for AwsOrganizationalData.
func (aod AwsOrganizationalData) AsBasicAwsOrganizationalData() (BasicAwsOrganizationalData, bool) {
	return &aod, true
}

// AwsOrganizationalDataMaster the awsOrganization data for the master account
type AwsOrganizationalDataMaster struct {
	// StacksetName - If the multi cloud account is of membership type organization, this will be the name of the onboarding stackset
	StacksetName *string `json:"stacksetName,omitempty"`
	// ExcludedAccountIds - If the multi cloud account is of membership type organization, list of accounts excluded from offering
	ExcludedAccountIds *[]string `json:"excludedAccountIds,omitempty"`
	// OrganizationMembershipType - Possible values include: 'OrganizationMembershipTypeAwsOrganizationalData', 'OrganizationMembershipTypeOrganization', 'OrganizationMembershipTypeMember'
	OrganizationMembershipType OrganizationMembershipType `json:"organizationMembershipType,omitempty"`
}

// MarshalJSON is the custom marshaler for AwsOrganizationalDataMaster.
func (aodm AwsOrganizationalDataMaster) MarshalJSON() ([]byte, error) {
	aodm.OrganizationMembershipType = OrganizationMembershipTypeOrganization
	objectMap := make(map[string]interface{})
	if aodm.StacksetName != nil {
		objectMap["stacksetName"] = aodm.StacksetName
	}
	if aodm.ExcludedAccountIds != nil {
		objectMap["excludedAccountIds"] = aodm.ExcludedAccountIds
	}
	if aodm.OrganizationMembershipType != "" {
		objectMap["organizationMembershipType"] = aodm.OrganizationMembershipType
	}
	return json.Marshal(objectMap)
}

// AsAwsOrganizationalDataMaster is the BasicAwsOrganizationalData implementation for AwsOrganizationalDataMaster.
func (aodm AwsOrganizationalDataMaster) AsAwsOrganizationalDataMaster() (*AwsOrganizationalDataMaster, bool) {
	return &aodm, true
}

// AsAwsOrganizationalDataMember is the BasicAwsOrganizationalData implementation for AwsOrganizationalDataMaster.
func (aodm AwsOrganizationalDataMaster) AsAwsOrganizationalDataMember() (*AwsOrganizationalDataMember, bool) {
	return nil, false
}

// AsAwsOrganizationalData is the BasicAwsOrganizationalData implementation for AwsOrganizationalDataMaster.
func (aodm AwsOrganizationalDataMaster) AsAwsOrganizationalData() (*AwsOrganizationalData, bool) {
	return nil, false
}

// AsBasicAwsOrganizationalData is the BasicAwsOrganizationalData implementation for AwsOrganizationalDataMaster.
func (aodm AwsOrganizationalDataMaster) AsBasicAwsOrganizationalData() (BasicAwsOrganizationalData, bool) {
	return &aodm, true
}

// AwsOrganizationalDataMember the awsOrganization data for the member account
type AwsOrganizationalDataMember struct {
	// ParentHierarchyID - If the multi cloud account is not of membership type organization, this will be the ID of the account's parent
	ParentHierarchyID *string `json:"parentHierarchyId,omitempty"`
	// OrganizationMembershipType - Possible values include: 'OrganizationMembershipTypeAwsOrganizationalData', 'OrganizationMembershipTypeOrganization', 'OrganizationMembershipTypeMember'
	OrganizationMembershipType OrganizationMembershipType `json:"organizationMembershipType,omitempty"`
}

// MarshalJSON is the custom marshaler for AwsOrganizationalDataMember.
func (aodm AwsOrganizationalDataMember) MarshalJSON() ([]byte, error) {
	aodm.OrganizationMembershipType = OrganizationMembershipTypeMember
	objectMap := make(map[string]interface{})
	if aodm.ParentHierarchyID != nil {
		objectMap["parentHierarchyId"] = aodm.ParentHierarchyID
	}
	if aodm.OrganizationMembershipType != "" {
		objectMap["organizationMembershipType"] = aodm.OrganizationMembershipType
	}
	return json.Marshal(objectMap)
}

// AsAwsOrganizationalDataMaster is the BasicAwsOrganizationalData implementation for AwsOrganizationalDataMember.
func (aodm AwsOrganizationalDataMember) AsAwsOrganizationalDataMaster() (*AwsOrganizationalDataMaster, bool) {
	return nil, false
}

// AsAwsOrganizationalDataMember is the BasicAwsOrganizationalData implementation for AwsOrganizationalDataMember.
func (aodm AwsOrganizationalDataMember) AsAwsOrganizationalDataMember() (*AwsOrganizationalDataMember, bool) {
	return &aodm, true
}

// AsAwsOrganizationalData is the BasicAwsOrganizationalData implementation for AwsOrganizationalDataMember.
func (aodm AwsOrganizationalDataMember) AsAwsOrganizationalData() (*AwsOrganizationalData, bool) {
	return nil, false
}

// AsBasicAwsOrganizationalData is the BasicAwsOrganizationalData implementation for AwsOrganizationalDataMember.
func (aodm AwsOrganizationalDataMember) AsBasicAwsOrganizationalData() (BasicAwsOrganizationalData, bool) {
	return &aodm, true
}

// AzureDevOpsScopeEnvironmentData the AzureDevOps scope connector's environment data
type AzureDevOpsScopeEnvironmentData struct {
	// EnvironmentType - Possible values include: 'EnvironmentTypeEnvironmentData', 'EnvironmentTypeAwsAccount', 'EnvironmentTypeGcpProject', 'EnvironmentTypeGithubScope', 'EnvironmentTypeAzureDevOpsScope'
	EnvironmentType EnvironmentType `json:"environmentType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDevOpsScopeEnvironmentData.
func (adosed AzureDevOpsScopeEnvironmentData) MarshalJSON() ([]byte, error) {
	adosed.EnvironmentType = EnvironmentTypeAzureDevOpsScope
	objectMap := make(map[string]interface{})
	if adosed.EnvironmentType != "" {
		objectMap["environmentType"] = adosed.EnvironmentType
	}
	return json.Marshal(objectMap)
}

// AsAwsEnvironmentData is the BasicEnvironmentData implementation for AzureDevOpsScopeEnvironmentData.
func (adosed AzureDevOpsScopeEnvironmentData) AsAwsEnvironmentData() (*AwsEnvironmentData, bool) {
	return nil, false
}

// AsGcpProjectEnvironmentData is the BasicEnvironmentData implementation for AzureDevOpsScopeEnvironmentData.
func (adosed AzureDevOpsScopeEnvironmentData) AsGcpProjectEnvironmentData() (*GcpProjectEnvironmentData, bool) {
	return nil, false
}

// AsGithubScopeEnvironmentData is the BasicEnvironmentData implementation for AzureDevOpsScopeEnvironmentData.
func (adosed AzureDevOpsScopeEnvironmentData) AsGithubScopeEnvironmentData() (*GithubScopeEnvironmentData, bool) {
	return nil, false
}

// AsAzureDevOpsScopeEnvironmentData is the BasicEnvironmentData implementation for AzureDevOpsScopeEnvironmentData.
func (adosed AzureDevOpsScopeEnvironmentData) AsAzureDevOpsScopeEnvironmentData() (*AzureDevOpsScopeEnvironmentData, bool) {
	return &adosed, true
}

// AsEnvironmentData is the BasicEnvironmentData implementation for AzureDevOpsScopeEnvironmentData.
func (adosed AzureDevOpsScopeEnvironmentData) AsEnvironmentData() (*EnvironmentData, bool) {
	return nil, false
}

// AsBasicEnvironmentData is the BasicEnvironmentData implementation for AzureDevOpsScopeEnvironmentData.
func (adosed AzureDevOpsScopeEnvironmentData) AsBasicEnvironmentData() (BasicEnvironmentData, bool) {
	return &adosed, true
}

// AzureResourceDetails details of the Azure resource that was assessed
type AzureResourceDetails struct {
	// ID - READ-ONLY; Azure resource Id of the assessed resource
	ID *string `json:"id,omitempty"`
	// Source - Possible values include: 'SourceResourceDetails', 'SourceOnPremiseSQL', 'SourceOnPremise', 'SourceAzure'
	Source Source `json:"source,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureResourceDetails.
func (ard AzureResourceDetails) MarshalJSON() ([]byte, error) {
	ard.Source = SourceAzure
	objectMap := make(map[string]interface{})
	if ard.Source != "" {
		objectMap["source"] = ard.Source
	}
	return json.Marshal(objectMap)
}

// AsOnPremiseSQLResourceDetails is the BasicResourceDetails implementation for AzureResourceDetails.
func (ard AzureResourceDetails) AsOnPremiseSQLResourceDetails() (*OnPremiseSQLResourceDetails, bool) {
	return nil, false
}

// AsOnPremiseResourceDetails is the BasicResourceDetails implementation for AzureResourceDetails.
func (ard AzureResourceDetails) AsOnPremiseResourceDetails() (*OnPremiseResourceDetails, bool) {
	return nil, false
}

// AsBasicOnPremiseResourceDetails is the BasicResourceDetails implementation for AzureResourceDetails.
func (ard AzureResourceDetails) AsBasicOnPremiseResourceDetails() (BasicOnPremiseResourceDetails, bool) {
	return nil, false
}

// AsAzureResourceDetails is the BasicResourceDetails implementation for AzureResourceDetails.
func (ard AzureResourceDetails) AsAzureResourceDetails() (*AzureResourceDetails, bool) {
	return &ard, true
}

// AsResourceDetails is the BasicResourceDetails implementation for AzureResourceDetails.
func (ard AzureResourceDetails) AsResourceDetails() (*ResourceDetails, bool) {
	return nil, false
}

// AsBasicResourceDetails is the BasicResourceDetails implementation for AzureResourceDetails.
func (ard AzureResourceDetails) AsBasicResourceDetails() (BasicResourceDetails, bool) {
	return &ard, true
}

// AzureResourceIdentifier azure resource identifier.
type AzureResourceIdentifier struct {
	// AzureResourceID - READ-ONLY; ARM resource identifier for the cloud resource being alerted on
	AzureResourceID *string `json:"azureResourceId,omitempty"`
	// Type - Possible values include: 'TypeResourceIdentifier', 'TypeAzureResource', 'TypeLogAnalytics'
	Type TypeBasicResourceIdentifier `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureResourceIdentifier.
func (ari AzureResourceIdentifier) MarshalJSON() ([]byte, error) {
	ari.Type = TypeAzureResource
	objectMap := make(map[string]interface{})
	if ari.Type != "" {
		objectMap["type"] = ari.Type
	}
	return json.Marshal(objectMap)
}

// AsAzureResourceIdentifier is the BasicResourceIdentifier implementation for AzureResourceIdentifier.
func (ari AzureResourceIdentifier) AsAzureResourceIdentifier() (*AzureResourceIdentifier, bool) {
	return &ari, true
}

// AsLogAnalyticsIdentifier is the BasicResourceIdentifier implementation for AzureResourceIdentifier.
func (ari AzureResourceIdentifier) AsLogAnalyticsIdentifier() (*LogAnalyticsIdentifier, bool) {
	return nil, false
}

// AsResourceIdentifier is the BasicResourceIdentifier implementation for AzureResourceIdentifier.
func (ari AzureResourceIdentifier) AsResourceIdentifier() (*ResourceIdentifier, bool) {
	return nil, false
}

// AsBasicResourceIdentifier is the BasicResourceIdentifier implementation for AzureResourceIdentifier.
func (ari AzureResourceIdentifier) AsBasicResourceIdentifier() (BasicResourceIdentifier, bool) {
	return &ari, true
}

// AzureResourceLink describes an Azure resource with kind
type AzureResourceLink struct {
	// ID - READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureResourceLink.
func (arl AzureResourceLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AzureTrackedResourceLocation describes an Azure resource with location
type AzureTrackedResourceLocation struct {
	// Location - Location where the resource is stored
	Location *string `json:"location,omitempty"`
}

// Baseline baseline details.
type Baseline struct {
	// ExpectedResults - Expected results.
	ExpectedResults *[][]string `json:"expectedResults,omitempty"`
	// UpdatedTime - Baseline update time (UTC).
	UpdatedTime *date.Time `json:"updatedTime,omitempty"`
}

// BaselineAdjustedResult the rule result adjusted with baseline.
type BaselineAdjustedResult struct {
	Baseline *Baseline `json:"baseline,omitempty"`
	// Status - Possible values include: 'NonFinding', 'Finding', 'InternalError'
	Status RuleStatus `json:"status,omitempty"`
	// ResultsNotInBaseline - Results the are not in baseline.
	ResultsNotInBaseline *[][]string `json:"resultsNotInBaseline,omitempty"`
	// ResultsOnlyInBaseline - Results the are in baseline.
	ResultsOnlyInBaseline *[][]string `json:"resultsOnlyInBaseline,omitempty"`
}

// BenchmarkReference the benchmark references.
type BenchmarkReference struct {
	// Benchmark - The benchmark name.
	Benchmark *string `json:"benchmark,omitempty"`
	// Reference - The benchmark reference.
	Reference *string `json:"reference,omitempty"`
}

// CefExternalSecuritySolution represents a security solution which sends CEF logs to an OMS workspace
type CefExternalSecuritySolution struct {
	Properties *CefSolutionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty"`
	// Kind - Possible values include: 'KindExternalSecuritySolution', 'KindCEF', 'KindATA', 'KindAAD'
	Kind KindEnum `json:"kind,omitempty"`
}

// MarshalJSON is the custom marshaler for CefExternalSecuritySolution.
func (cess CefExternalSecuritySolution) MarshalJSON() ([]byte, error) {
	cess.Kind = KindCEF
	objectMap := make(map[string]interface{})
	if cess.Properties != nil {
		objectMap["properties"] = cess.Properties
	}
	if cess.Kind != "" {
		objectMap["kind"] = cess.Kind
	}
	return json.Marshal(objectMap)
}

// AsCefExternalSecuritySolution is the BasicExternalSecuritySolution implementation for CefExternalSecuritySolution.
func (cess CefExternalSecuritySolution) AsCefExternalSecuritySolution() (*CefExternalSecuritySolution, bool) {
	return &cess, true
}

// AsAtaExternalSecuritySolution is the BasicExternalSecuritySolution implementation for CefExternalSecuritySolution.
func (cess CefExternalSecuritySolution) AsAtaExternalSecuritySolution() (*AtaExternalSecuritySolution, bool) {
	return nil, false
}

// AsAadExternalSecuritySolution is the BasicExternalSecuritySolution implementation for CefExternalSecuritySolution.
func (cess CefExternalSecuritySolution) AsAadExternalSecuritySolution() (*AadExternalSecuritySolution, bool) {
	return nil, false
}

// AsExternalSecuritySolution is the BasicExternalSecuritySolution implementation for CefExternalSecuritySolution.
func (cess CefExternalSecuritySolution) AsExternalSecuritySolution() (*ExternalSecuritySolution, bool) {
	return nil, false
}

// AsBasicExternalSecuritySolution is the BasicExternalSecuritySolution implementation for CefExternalSecuritySolution.
func (cess CefExternalSecuritySolution) AsBasicExternalSecuritySolution() (BasicExternalSecuritySolution, bool) {
	return &cess, true
}

// CefSolutionProperties ...
type CefSolutionProperties struct {
	Hostname          *string `json:"hostname,omitempty"`
	Agent             *string `json:"agent,omitempty"`
	LastEventReceived *string `json:"lastEventReceived,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	DeviceVendor         *string                `json:"deviceVendor,omitempty"`
	DeviceType           *string                `json:"deviceType,omitempty"`
	Workspace            *ConnectedWorkspace    `json:"workspace,omitempty"`
}

// MarshalJSON is the custom marshaler for CefSolutionProperties.
func (csp CefSolutionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if csp.Hostname != nil {
		objectMap["hostname"] = csp.Hostname
	}
	if csp.Agent != nil {
		objectMap["agent"] = csp.Agent
	}
	if csp.LastEventReceived != nil {
		objectMap["lastEventReceived"] = csp.LastEventReceived
	}
	if csp.DeviceVendor != nil {
		objectMap["deviceVendor"] = csp.DeviceVendor
	}
	if csp.DeviceType != nil {
		objectMap["deviceType"] = csp.DeviceType
	}
	if csp.Workspace != nil {
		objectMap["workspace"] = csp.Workspace
	}
	for k, v := range csp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CefSolutionProperties struct.
func (csp *CefSolutionProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "hostname":
			if v != nil {
				var hostname string
				err = json.Unmarshal(*v, &hostname)
				if err != nil {
					return err
				}
				csp.Hostname = &hostname
			}
		case "agent":
			if v != nil {
				var agent string
				err = json.Unmarshal(*v, &agent)
				if err != nil {
					return err
				}
				csp.Agent = &agent
			}
		case "lastEventReceived":
			if v != nil {
				var lastEventReceived string
				err = json.Unmarshal(*v, &lastEventReceived)
				if err != nil {
					return err
				}
				csp.LastEventReceived = &lastEventReceived
			}
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if csp.AdditionalProperties == nil {
					csp.AdditionalProperties = make(map[string]interface{})
				}
				csp.AdditionalProperties[k] = additionalProperties
			}
		case "deviceVendor":
			if v != nil {
				var deviceVendor string
				err = json.Unmarshal(*v, &deviceVendor)
				if err != nil {
					return err
				}
				csp.DeviceVendor = &deviceVendor
			}
		case "deviceType":
			if v != nil {
				var deviceType string
				err = json.Unmarshal(*v, &deviceType)
				if err != nil {
					return err
				}
				csp.DeviceType = &deviceType
			}
		case "workspace":
			if v != nil {
				var workspace ConnectedWorkspace
				err = json.Unmarshal(*v, &workspace)
				if err != nil {
					return err
				}
				csp.Workspace = &workspace
			}
		}
	}

	return nil
}

// CloudError common error response for all Azure Resource Manager APIs to return error details for failed
// operations. (This also follows the OData error response format.).
type CloudError struct {
	// CloudErrorBody - The error object.
	*CloudErrorBody `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for CloudError.
func (ce CloudError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ce.CloudErrorBody != nil {
		objectMap["error"] = ce.CloudErrorBody
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CloudError struct.
func (ce *CloudError) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "error":
			if v != nil {
				var cloudErrorBody CloudErrorBody
				err = json.Unmarshal(*v, &cloudErrorBody)
				if err != nil {
					return err
				}
				ce.CloudErrorBody = &cloudErrorBody
			}
		}
	}

	return nil
}

// CloudErrorBody the error detail.
type CloudErrorBody struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]CloudErrorBody `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for CloudErrorBody.
func (ceb CloudErrorBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// BasicCloudOffering the security offering details
type BasicCloudOffering interface {
	AsCspmMonitorAwsOffering() (*CspmMonitorAwsOffering, bool)
	AsDefenderForContainersAwsOffering() (*DefenderForContainersAwsOffering, bool)
	AsDefenderForServersAwsOffering() (*DefenderForServersAwsOffering, bool)
	AsDefenderFoDatabasesAwsOffering() (*DefenderFoDatabasesAwsOffering, bool)
	AsInformationProtectionAwsOffering() (*InformationProtectionAwsOffering, bool)
	AsCspmMonitorGcpOffering() (*CspmMonitorGcpOffering, bool)
	AsDefenderForServersGcpOffering() (*DefenderForServersGcpOffering, bool)
	AsDefenderForDatabasesGcpOffering() (*DefenderForDatabasesGcpOffering, bool)
	AsDefenderForContainersGcpOffering() (*DefenderForContainersGcpOffering, bool)
	AsCspmMonitorGithubOffering() (*CspmMonitorGithubOffering, bool)
	AsCspmMonitorAzureDevOpsOffering() (*CspmMonitorAzureDevOpsOffering, bool)
	AsDefenderCspmAwsOffering() (*DefenderCspmAwsOffering, bool)
	AsDefenderCspmGcpOffering() (*DefenderCspmGcpOffering, bool)
	AsDefenderForDevOpsGithubOffering() (*DefenderForDevOpsGithubOffering, bool)
	AsDefenderForDevOpsAzureDevOpsOffering() (*DefenderForDevOpsAzureDevOpsOffering, bool)
	AsCloudOffering() (*CloudOffering, bool)
}

// CloudOffering the security offering details
type CloudOffering struct {
	// Description - READ-ONLY; The offering description.
	Description *string `json:"description,omitempty"`
	// OfferingType - Possible values include: 'OfferingTypeCloudOffering', 'OfferingTypeCspmMonitorAws', 'OfferingTypeDefenderForContainersAws', 'OfferingTypeDefenderForServersAws', 'OfferingTypeDefenderForDatabasesAws', 'OfferingTypeInformationProtectionAws', 'OfferingTypeCspmMonitorGcp', 'OfferingTypeDefenderForServersGcp', 'OfferingTypeDefenderForDatabasesGcp', 'OfferingTypeDefenderForContainersGcp', 'OfferingTypeCspmMonitorGithub', 'OfferingTypeCspmMonitorAzureDevOps', 'OfferingTypeDefenderCspmAws', 'OfferingTypeDefenderCspmGcp', 'OfferingTypeDefenderForDevOpsGithub', 'OfferingTypeDefenderForDevOpsAzureDevOps'
	OfferingType OfferingType `json:"offeringType,omitempty"`
}

func unmarshalBasicCloudOffering(body []byte) (BasicCloudOffering, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["offeringType"] {
	case string(OfferingTypeCspmMonitorAws):
		var cmao CspmMonitorAwsOffering
		err := json.Unmarshal(body, &cmao)
		return cmao, err
	case string(OfferingTypeDefenderForContainersAws):
		var dfcao DefenderForContainersAwsOffering
		err := json.Unmarshal(body, &dfcao)
		return dfcao, err
	case string(OfferingTypeDefenderForServersAws):
		var dfsao DefenderForServersAwsOffering
		err := json.Unmarshal(body, &dfsao)
		return dfsao, err
	case string(OfferingTypeDefenderForDatabasesAws):
		var dfdao DefenderFoDatabasesAwsOffering
		err := json.Unmarshal(body, &dfdao)
		return dfdao, err
	case string(OfferingTypeInformationProtectionAws):
		var ipao InformationProtectionAwsOffering
		err := json.Unmarshal(body, &ipao)
		return ipao, err
	case string(OfferingTypeCspmMonitorGcp):
		var cmgo CspmMonitorGcpOffering
		err := json.Unmarshal(body, &cmgo)
		return cmgo, err
	case string(OfferingTypeDefenderForServersGcp):
		var dfsgo DefenderForServersGcpOffering
		err := json.Unmarshal(body, &dfsgo)
		return dfsgo, err
	case string(OfferingTypeDefenderForDatabasesGcp):
		var dfdgo DefenderForDatabasesGcpOffering
		err := json.Unmarshal(body, &dfdgo)
		return dfdgo, err
	case string(OfferingTypeDefenderForContainersGcp):
		var dfcgo DefenderForContainersGcpOffering
		err := json.Unmarshal(body, &dfcgo)
		return dfcgo, err
	case string(OfferingTypeCspmMonitorGithub):
		var cmgo CspmMonitorGithubOffering
		err := json.Unmarshal(body, &cmgo)
		return cmgo, err
	case string(OfferingTypeCspmMonitorAzureDevOps):
		var cmadoo CspmMonitorAzureDevOpsOffering
		err := json.Unmarshal(body, &cmadoo)
		return cmadoo, err
	case string(OfferingTypeDefenderCspmAws):
		var dcao DefenderCspmAwsOffering
		err := json.Unmarshal(body, &dcao)
		return dcao, err
	case string(OfferingTypeDefenderCspmGcp):
		var dcgo DefenderCspmGcpOffering
		err := json.Unmarshal(body, &dcgo)
		return dcgo, err
	case string(OfferingTypeDefenderForDevOpsGithub):
		var dfdogo DefenderForDevOpsGithubOffering
		err := json.Unmarshal(body, &dfdogo)
		return dfdogo, err
	case string(OfferingTypeDefenderForDevOpsAzureDevOps):
		var dfdoadoo DefenderForDevOpsAzureDevOpsOffering
		err := json.Unmarshal(body, &dfdoadoo)
		return dfdoadoo, err
	default:
		var co CloudOffering
		err := json.Unmarshal(body, &co)
		return co, err
	}
}
func unmarshalBasicCloudOfferingArray(body []byte) ([]BasicCloudOffering, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	coArray := make([]BasicCloudOffering, len(rawMessages))

	for index, rawMessage := range rawMessages {
		co, err := unmarshalBasicCloudOffering(*rawMessage)
		if err != nil {
			return nil, err
		}
		coArray[index] = co
	}
	return coArray, nil
}

// MarshalJSON is the custom marshaler for CloudOffering.
func (co CloudOffering) MarshalJSON() ([]byte, error) {
	co.OfferingType = OfferingTypeCloudOffering
	objectMap := make(map[string]interface{})
	if co.OfferingType != "" {
		objectMap["offeringType"] = co.OfferingType
	}
	return json.Marshal(objectMap)
}

// AsCspmMonitorAwsOffering is the BasicCloudOffering implementation for CloudOffering.
func (co CloudOffering) AsCspmMonitorAwsOffering() (*CspmMonitorAwsOffering, bool) {
	return nil, false
}

// AsDefenderForContainersAwsOffering is the BasicCloudOffering implementation for CloudOffering.
func (co CloudOffering) AsDefenderForContainersAwsOffering() (*DefenderForContainersAwsOffering, bool) {
	return nil, false
}

// AsDefenderForServersAwsOffering is the BasicCloudOffering implementation for CloudOffering.
func (co CloudOffering) AsDefenderForServersAwsOffering() (*DefenderForServersAwsOffering, bool) {
	return nil, false
}

// AsDefenderFoDatabasesAwsOffering is the BasicCloudOffering implementation for CloudOffering.
func (co CloudOffering) AsDefenderFoDatabasesAwsOffering() (*DefenderFoDatabasesAwsOffering, bool) {
	return nil, false
}

// AsInformationProtectionAwsOffering is the BasicCloudOffering implementation for CloudOffering.
func (co CloudOffering) AsInformationProtectionAwsOffering() (*InformationProtectionAwsOffering, bool) {
	return nil, false
}

// AsCspmMonitorGcpOffering is the BasicCloudOffering implementation for CloudOffering.
func (co CloudOffering) AsCspmMonitorGcpOffering() (*CspmMonitorGcpOffering, bool) {
	return nil, false
}

// AsDefenderForServersGcpOffering is the BasicCloudOffering implementation for CloudOffering.
func (co CloudOffering) AsDefenderForServersGcpOffering() (*DefenderForServersGcpOffering, bool) {
	return nil, false
}

// AsDefenderForDatabasesGcpOffering is the BasicCloudOffering implementation for CloudOffering.
func (co CloudOffering) AsDefenderForDatabasesGcpOffering() (*DefenderForDatabasesGcpOffering, bool) {
	return nil, false
}

// AsDefenderForContainersGcpOffering is the BasicCloudOffering implementation for CloudOffering.
func (co CloudOffering) AsDefenderForContainersGcpOffering() (*DefenderForContainersGcpOffering, bool) {
	return nil, false
}

// AsCspmMonitorGithubOffering is the BasicCloudOffering implementation for CloudOffering.
func (co CloudOffering) AsCspmMonitorGithubOffering() (*CspmMonitorGithubOffering, bool) {
	return nil, false
}

// AsCspmMonitorAzureDevOpsOffering is the BasicCloudOffering implementation for CloudOffering.
func (co CloudOffering) AsCspmMonitorAzureDevOpsOffering() (*CspmMonitorAzureDevOpsOffering, bool) {
	return nil, false
}

// AsDefenderCspmAwsOffering is the BasicCloudOffering implementation for CloudOffering.
func (co CloudOffering) AsDefenderCspmAwsOffering() (*DefenderCspmAwsOffering, bool) {
	return nil, false
}

// AsDefenderCspmGcpOffering is the BasicCloudOffering implementation for CloudOffering.
func (co CloudOffering) AsDefenderCspmGcpOffering() (*DefenderCspmGcpOffering, bool) {
	return nil, false
}

// AsDefenderForDevOpsGithubOffering is the BasicCloudOffering implementation for CloudOffering.
func (co CloudOffering) AsDefenderForDevOpsGithubOffering() (*DefenderForDevOpsGithubOffering, bool) {
	return nil, false
}

// AsDefenderForDevOpsAzureDevOpsOffering is the BasicCloudOffering implementation for CloudOffering.
func (co CloudOffering) AsDefenderForDevOpsAzureDevOpsOffering() (*DefenderForDevOpsAzureDevOpsOffering, bool) {
	return nil, false
}

// AsCloudOffering is the BasicCloudOffering implementation for CloudOffering.
func (co CloudOffering) AsCloudOffering() (*CloudOffering, bool) {
	return &co, true
}

// AsBasicCloudOffering is the BasicCloudOffering implementation for CloudOffering.
func (co CloudOffering) AsBasicCloudOffering() (BasicCloudOffering, bool) {
	return &co, true
}

// Compliance compliance of a scope
type Compliance struct {
	autorest.Response `json:"-"`
	// ComplianceProperties - Compliance data
	*ComplianceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Compliance.
func (c Compliance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.ComplianceProperties != nil {
		objectMap["properties"] = c.ComplianceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Compliance struct.
func (c *Compliance) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var complianceProperties ComplianceProperties
				err = json.Unmarshal(*v, &complianceProperties)
				if err != nil {
					return err
				}
				c.ComplianceProperties = &complianceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		}
	}

	return nil
}

// ComplianceList list of Compliance objects response
type ComplianceList struct {
	autorest.Response `json:"-"`
	// Value - List of Compliance objects
	Value *[]Compliance `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ComplianceList.
func (cl ComplianceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cl.Value != nil {
		objectMap["value"] = cl.Value
	}
	return json.Marshal(objectMap)
}

// ComplianceListIterator provides access to a complete listing of Compliance values.
type ComplianceListIterator struct {
	i    int
	page ComplianceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ComplianceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ComplianceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ComplianceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ComplianceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ComplianceListIterator) Response() ComplianceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ComplianceListIterator) Value() Compliance {
	if !iter.page.NotDone() {
		return Compliance{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ComplianceListIterator type.
func NewComplianceListIterator(page ComplianceListPage) ComplianceListIterator {
	return ComplianceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cl ComplianceList) IsEmpty() bool {
	return cl.Value == nil || len(*cl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cl ComplianceList) hasNextLink() bool {
	return cl.NextLink != nil && len(*cl.NextLink) != 0
}

// complianceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cl ComplianceList) complianceListPreparer(ctx context.Context) (*http.Request, error) {
	if !cl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cl.NextLink)))
}

// ComplianceListPage contains a page of Compliance values.
type ComplianceListPage struct {
	fn func(context.Context, ComplianceList) (ComplianceList, error)
	cl ComplianceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ComplianceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ComplianceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cl)
		if err != nil {
			return err
		}
		page.cl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ComplianceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ComplianceListPage) NotDone() bool {
	return !page.cl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ComplianceListPage) Response() ComplianceList {
	return page.cl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ComplianceListPage) Values() []Compliance {
	if page.cl.IsEmpty() {
		return nil
	}
	return *page.cl.Value
}

// Creates a new instance of the ComplianceListPage type.
func NewComplianceListPage(cur ComplianceList, getNextPage func(context.Context, ComplianceList) (ComplianceList, error)) ComplianceListPage {
	return ComplianceListPage{
		fn: getNextPage,
		cl: cur,
	}
}

// ComplianceProperties the Compliance score (percentage) of a Subscription is a sum of all Resources'
// Compliances under the given Subscription. A Resource Compliance is defined as the compliant ('healthy')
// Policy Definitions out of all Policy Definitions applicable to a given resource.
type ComplianceProperties struct {
	// AssessmentTimestampUtcDate - READ-ONLY; The timestamp when the Compliance calculation was conducted.
	AssessmentTimestampUtcDate *date.Time `json:"assessmentTimestampUtcDate,omitempty"`
	// ResourceCount - READ-ONLY; The resource count of the given subscription for which the Compliance calculation was conducted (needed for Management Group Compliance calculation).
	ResourceCount *int32 `json:"resourceCount,omitempty"`
	// AssessmentResult - READ-ONLY; An array of segment, which is the actually the compliance assessment.
	AssessmentResult *[]ComplianceSegment `json:"assessmentResult,omitempty"`
}

// MarshalJSON is the custom marshaler for ComplianceProperties.
func (cp ComplianceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ComplianceResult a compliance result
type ComplianceResult struct {
	autorest.Response `json:"-"`
	// ComplianceResultProperties - Compliance result data
	*ComplianceResultProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ComplianceResult.
func (cr ComplianceResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cr.ComplianceResultProperties != nil {
		objectMap["properties"] = cr.ComplianceResultProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ComplianceResult struct.
func (cr *ComplianceResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var complianceResultProperties ComplianceResultProperties
				err = json.Unmarshal(*v, &complianceResultProperties)
				if err != nil {
					return err
				}
				cr.ComplianceResultProperties = &complianceResultProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cr.Type = &typeVar
			}
		}
	}

	return nil
}

// ComplianceResultList list of compliance results response
type ComplianceResultList struct {
	autorest.Response `json:"-"`
	// Value - List of compliance results
	Value *[]ComplianceResult `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ComplianceResultList.
func (crl ComplianceResultList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if crl.Value != nil {
		objectMap["value"] = crl.Value
	}
	return json.Marshal(objectMap)
}

// ComplianceResultListIterator provides access to a complete listing of ComplianceResult values.
type ComplianceResultListIterator struct {
	i    int
	page ComplianceResultListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ComplianceResultListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ComplianceResultListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ComplianceResultListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ComplianceResultListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ComplianceResultListIterator) Response() ComplianceResultList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ComplianceResultListIterator) Value() ComplianceResult {
	if !iter.page.NotDone() {
		return ComplianceResult{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ComplianceResultListIterator type.
func NewComplianceResultListIterator(page ComplianceResultListPage) ComplianceResultListIterator {
	return ComplianceResultListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (crl ComplianceResultList) IsEmpty() bool {
	return crl.Value == nil || len(*crl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (crl ComplianceResultList) hasNextLink() bool {
	return crl.NextLink != nil && len(*crl.NextLink) != 0
}

// complianceResultListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (crl ComplianceResultList) complianceResultListPreparer(ctx context.Context) (*http.Request, error) {
	if !crl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(crl.NextLink)))
}

// ComplianceResultListPage contains a page of ComplianceResult values.
type ComplianceResultListPage struct {
	fn  func(context.Context, ComplianceResultList) (ComplianceResultList, error)
	crl ComplianceResultList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ComplianceResultListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ComplianceResultListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.crl)
		if err != nil {
			return err
		}
		page.crl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ComplianceResultListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ComplianceResultListPage) NotDone() bool {
	return !page.crl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ComplianceResultListPage) Response() ComplianceResultList {
	return page.crl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ComplianceResultListPage) Values() []ComplianceResult {
	if page.crl.IsEmpty() {
		return nil
	}
	return *page.crl.Value
}

// Creates a new instance of the ComplianceResultListPage type.
func NewComplianceResultListPage(cur ComplianceResultList, getNextPage func(context.Context, ComplianceResultList) (ComplianceResultList, error)) ComplianceResultListPage {
	return ComplianceResultListPage{
		fn:  getNextPage,
		crl: cur,
	}
}

// ComplianceResultProperties compliance result data
type ComplianceResultProperties struct {
	// ResourceStatus - READ-ONLY; The status of the resource regarding a single assessment. Possible values include: 'ResourceStatusHealthy', 'ResourceStatusNotApplicable', 'ResourceStatusOffByPolicy', 'ResourceStatusNotHealthy'
	ResourceStatus ResourceStatus `json:"resourceStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for ComplianceResultProperties.
func (crp ComplianceResultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ComplianceSegment a segment of a compliance assessment.
type ComplianceSegment struct {
	// SegmentType - READ-ONLY; The segment type, e.g. compliant, non-compliance, insufficient coverage, N/A, etc.
	SegmentType *string `json:"segmentType,omitempty"`
	// Percentage - READ-ONLY; The size (%) of the segment.
	Percentage *float64 `json:"percentage,omitempty"`
}

// MarshalJSON is the custom marshaler for ComplianceSegment.
func (cs ComplianceSegment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Condition governance rule's condition
type Condition struct {
	// Property - The governance rule Condition's Property, e.g. Severity or AssessmentKey, see examples
	Property *string `json:"property,omitempty"`
	// Value - The governance rule Condition's Value like severity Low, High or assessments keys, see examples
	Value *string `json:"value,omitempty"`
	// Operator - The governance rule Condition's Operator, for example Equals for severity or In for list of assessments, see examples. Possible values include: 'GovernanceRuleConditionOperatorEquals', 'GovernanceRuleConditionOperatorIn'
	Operator GovernanceRuleConditionOperator `json:"operator,omitempty"`
}

// ConnectableResource describes the allowed inbound and outbound traffic of an Azure resource
type ConnectableResource struct {
	// ID - READ-ONLY; The Azure resource id
	ID *string `json:"id,omitempty"`
	// InboundConnectedResources - READ-ONLY; The list of Azure resources that the resource has inbound allowed connection from
	InboundConnectedResources *[]ConnectedResource `json:"inboundConnectedResources,omitempty"`
	// OutboundConnectedResources - READ-ONLY; The list of Azure resources that the resource has outbound allowed connection to
	OutboundConnectedResources *[]ConnectedResource `json:"outboundConnectedResources,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectableResource.
func (cr ConnectableResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ConnectedResource describes properties of a connected resource
type ConnectedResource struct {
	// ConnectedResourceID - READ-ONLY; The Azure resource id of the connected resource
	ConnectedResourceID *string `json:"connectedResourceId,omitempty"`
	// TCPPorts - READ-ONLY; The allowed tcp ports
	TCPPorts *string `json:"tcpPorts,omitempty"`
	// UDPPorts - READ-ONLY; The allowed udp ports
	UDPPorts *string `json:"udpPorts,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectedResource.
func (cr ConnectedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ConnectedWorkspace ...
type ConnectedWorkspace struct {
	// ID - Azure resource ID of the connected OMS workspace
	ID *string `json:"id,omitempty"`
}

// ConnectionFromIPNotAllowed inbound connection from an ip that isn't allowed. Allow list consists of ipv4
// or ipv6 range in CIDR notation.
type ConnectionFromIPNotAllowed struct {
	// AllowlistValues - The values to allow. The format of the values depends on the rule type.
	AllowlistValues *[]string `json:"allowlistValues,omitempty"`
	// ValueType - READ-ONLY; The value type of the items in the list. Possible values include: 'ValueTypeIPCidr', 'ValueTypeString'
	ValueType ValueType `json:"valueType,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeConnectionFromIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectionFromIPNotAllowed.
func (cfina ConnectionFromIPNotAllowed) MarshalJSON() ([]byte, error) {
	cfina.RuleType = RuleTypeConnectionFromIPNotAllowed
	objectMap := make(map[string]interface{})
	if cfina.AllowlistValues != nil {
		objectMap["allowlistValues"] = cfina.AllowlistValues
	}
	if cfina.IsEnabled != nil {
		objectMap["isEnabled"] = cfina.IsEnabled
	}
	if cfina.RuleType != "" {
		objectMap["ruleType"] = cfina.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for ConnectionFromIPNotAllowed.
func (cfina ConnectionFromIPNotAllowed) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for ConnectionFromIPNotAllowed.
func (cfina ConnectionFromIPNotAllowed) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for ConnectionFromIPNotAllowed.
func (cfina ConnectionFromIPNotAllowed) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for ConnectionFromIPNotAllowed.
func (cfina ConnectionFromIPNotAllowed) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for ConnectionFromIPNotAllowed.
func (cfina ConnectionFromIPNotAllowed) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for ConnectionFromIPNotAllowed.
func (cfina ConnectionFromIPNotAllowed) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return &cfina, true
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for ConnectionFromIPNotAllowed.
func (cfina ConnectionFromIPNotAllowed) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for ConnectionFromIPNotAllowed.
func (cfina ConnectionFromIPNotAllowed) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for ConnectionFromIPNotAllowed.
func (cfina ConnectionFromIPNotAllowed) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return &cfina, true
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for ConnectionFromIPNotAllowed.
func (cfina ConnectionFromIPNotAllowed) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsConnectionFromIPNotAllowed is the BasicCustomAlertRule implementation for ConnectionFromIPNotAllowed.
func (cfina ConnectionFromIPNotAllowed) AsConnectionFromIPNotAllowed() (*ConnectionFromIPNotAllowed, bool) {
	return &cfina, true
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for ConnectionFromIPNotAllowed.
func (cfina ConnectionFromIPNotAllowed) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for ConnectionFromIPNotAllowed.
func (cfina ConnectionFromIPNotAllowed) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionFromIPNotAllowed.
func (cfina ConnectionFromIPNotAllowed) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionFromIPNotAllowed.
func (cfina ConnectionFromIPNotAllowed) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionFromIPNotAllowed.
func (cfina ConnectionFromIPNotAllowed) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionFromIPNotAllowed.
func (cfina ConnectionFromIPNotAllowed) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionFromIPNotAllowed.
func (cfina ConnectionFromIPNotAllowed) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionFromIPNotAllowed.
func (cfina ConnectionFromIPNotAllowed) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionFromIPNotAllowed.
func (cfina ConnectionFromIPNotAllowed) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionFromIPNotAllowed.
func (cfina ConnectionFromIPNotAllowed) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionFromIPNotAllowed.
func (cfina ConnectionFromIPNotAllowed) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionFromIPNotAllowed.
func (cfina ConnectionFromIPNotAllowed) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionFromIPNotAllowed.
func (cfina ConnectionFromIPNotAllowed) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionFromIPNotAllowed.
func (cfina ConnectionFromIPNotAllowed) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionFromIPNotAllowed.
func (cfina ConnectionFromIPNotAllowed) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionFromIPNotAllowed.
func (cfina ConnectionFromIPNotAllowed) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionFromIPNotAllowed.
func (cfina ConnectionFromIPNotAllowed) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionFromIPNotAllowed.
func (cfina ConnectionFromIPNotAllowed) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for ConnectionFromIPNotAllowed.
func (cfina ConnectionFromIPNotAllowed) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for ConnectionFromIPNotAllowed.
func (cfina ConnectionFromIPNotAllowed) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &cfina, true
}

// ConnectionStrings connection string for ingesting security data and logs
type ConnectionStrings struct {
	autorest.Response `json:"-"`
	// Value - Connection strings
	Value *[]IngestionConnectionString `json:"value,omitempty"`
}

// ConnectionToIPNotAllowed outbound connection to an ip that isn't allowed. Allow list consists of ipv4 or
// ipv6 range in CIDR notation.
type ConnectionToIPNotAllowed struct {
	// AllowlistValues - The values to allow. The format of the values depends on the rule type.
	AllowlistValues *[]string `json:"allowlistValues,omitempty"`
	// ValueType - READ-ONLY; The value type of the items in the list. Possible values include: 'ValueTypeIPCidr', 'ValueTypeString'
	ValueType ValueType `json:"valueType,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeConnectionFromIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) MarshalJSON() ([]byte, error) {
	ctina.RuleType = RuleTypeConnectionToIPNotAllowed
	objectMap := make(map[string]interface{})
	if ctina.AllowlistValues != nil {
		objectMap["allowlistValues"] = ctina.AllowlistValues
	}
	if ctina.IsEnabled != nil {
		objectMap["isEnabled"] = ctina.IsEnabled
	}
	if ctina.RuleType != "" {
		objectMap["ruleType"] = ctina.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return &ctina, true
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return &ctina, true
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return &ctina, true
}

// AsConnectionFromIPNotAllowed is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsConnectionFromIPNotAllowed() (*ConnectionFromIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for ConnectionToIPNotAllowed.
func (ctina ConnectionToIPNotAllowed) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &ctina, true
}

// Connector the security connector resource.
type Connector struct {
	autorest.Response `json:"-"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
	// ConnectorProperties - Security connector data
	*ConnectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Location where the resource is stored
	Location *string `json:"location,omitempty"`
	// Kind - Kind of the resource
	Kind *string `json:"kind,omitempty"`
	// Etag - Entity tag is used for comparing two or more entities from the same requested resource.
	Etag *string `json:"etag,omitempty"`
	// Tags - A list of key value pairs that describe the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Connector.
func (c Connector) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.ConnectorProperties != nil {
		objectMap["properties"] = c.ConnectorProperties
	}
	if c.Location != nil {
		objectMap["location"] = c.Location
	}
	if c.Kind != nil {
		objectMap["kind"] = c.Kind
	}
	if c.Etag != nil {
		objectMap["etag"] = c.Etag
	}
	if c.Tags != nil {
		objectMap["tags"] = c.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Connector struct.
func (c *Connector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				c.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var connectorProperties ConnectorProperties
				err = json.Unmarshal(*v, &connectorProperties)
				if err != nil {
					return err
				}
				c.ConnectorProperties = &connectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				c.Location = &location
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				c.Kind = &kind
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				c.Etag = &etag
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				c.Tags = tags
			}
		}
	}

	return nil
}

// ConnectorGovernanceRulesExecuteStatusGetFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ConnectorGovernanceRulesExecuteStatusGetFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ConnectorGovernanceRulesExecuteStatusClient) (ExecuteRuleStatus, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ConnectorGovernanceRulesExecuteStatusGetFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ConnectorGovernanceRulesExecuteStatusGetFuture.Result.
func (future *ConnectorGovernanceRulesExecuteStatusGetFuture) result(client ConnectorGovernanceRulesExecuteStatusClient) (ers ExecuteRuleStatus, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.ConnectorGovernanceRulesExecuteStatusGetFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ers.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("security.ConnectorGovernanceRulesExecuteStatusGetFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ers.Response.Response, err = future.GetResult(sender); err == nil && ers.Response.Response.StatusCode != http.StatusNoContent {
		ers, err = client.GetResponder(ers.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "security.ConnectorGovernanceRulesExecuteStatusGetFuture", "Result", ers.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ConnectorProperties a set of properties that defines the security connector configuration.
type ConnectorProperties struct {
	// HierarchyIdentifier - The multi cloud resource identifier (account id in case of AWS connector, project number in case of GCP connector).
	HierarchyIdentifier *string `json:"hierarchyIdentifier,omitempty"`
	// HierarchyIdentifierTrialEndDate - READ-ONLY; The date on which the trial period will end, if applicable. Trial period exists for 30 days after upgrading to payed offerings.
	HierarchyIdentifierTrialEndDate *date.Time `json:"hierarchyIdentifierTrialEndDate,omitempty"`
	// EnvironmentName - The multi cloud resource's cloud name. Possible values include: 'Azure', 'AWS', 'GCP', 'Github', 'AzureDevOps'
	EnvironmentName CloudName `json:"environmentName,omitempty"`
	// Offerings - A collection of offerings for the security connector.
	Offerings *[]BasicCloudOffering `json:"offerings,omitempty"`
	// EnvironmentData - The security connector environment data.
	EnvironmentData BasicEnvironmentData `json:"environmentData,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectorProperties.
func (cp ConnectorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.HierarchyIdentifier != nil {
		objectMap["hierarchyIdentifier"] = cp.HierarchyIdentifier
	}
	if cp.EnvironmentName != "" {
		objectMap["environmentName"] = cp.EnvironmentName
	}
	if cp.Offerings != nil {
		objectMap["offerings"] = cp.Offerings
	}
	objectMap["environmentData"] = cp.EnvironmentData
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ConnectorProperties struct.
func (cp *ConnectorProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "hierarchyIdentifier":
			if v != nil {
				var hierarchyIdentifier string
				err = json.Unmarshal(*v, &hierarchyIdentifier)
				if err != nil {
					return err
				}
				cp.HierarchyIdentifier = &hierarchyIdentifier
			}
		case "hierarchyIdentifierTrialEndDate":
			if v != nil {
				var hierarchyIdentifierTrialEndDate date.Time
				err = json.Unmarshal(*v, &hierarchyIdentifierTrialEndDate)
				if err != nil {
					return err
				}
				cp.HierarchyIdentifierTrialEndDate = &hierarchyIdentifierTrialEndDate
			}
		case "environmentName":
			if v != nil {
				var environmentName CloudName
				err = json.Unmarshal(*v, &environmentName)
				if err != nil {
					return err
				}
				cp.EnvironmentName = environmentName
			}
		case "offerings":
			if v != nil {
				offerings, err := unmarshalBasicCloudOfferingArray(*v)
				if err != nil {
					return err
				}
				cp.Offerings = &offerings
			}
		case "environmentData":
			if v != nil {
				environmentData, err := unmarshalBasicEnvironmentData(*v)
				if err != nil {
					return err
				}
				cp.EnvironmentData = environmentData
			}
		}
	}

	return nil
}

// ConnectorSetting the connector setting
type ConnectorSetting struct {
	autorest.Response `json:"-"`
	// ConnectorSettingProperties - Connector setting data
	*ConnectorSettingProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectorSetting.
func (cs ConnectorSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cs.ConnectorSettingProperties != nil {
		objectMap["properties"] = cs.ConnectorSettingProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ConnectorSetting struct.
func (cs *ConnectorSetting) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var connectorSettingProperties ConnectorSettingProperties
				err = json.Unmarshal(*v, &connectorSettingProperties)
				if err != nil {
					return err
				}
				cs.ConnectorSettingProperties = &connectorSettingProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cs.Type = &typeVar
			}
		}
	}

	return nil
}

// ConnectorSettingList for a subscription, list of all cloud account connectors and their settings
type ConnectorSettingList struct {
	autorest.Response `json:"-"`
	// Value - List of all the cloud account connector settings
	Value *[]ConnectorSetting `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectorSettingList.
func (csl ConnectorSettingList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if csl.Value != nil {
		objectMap["value"] = csl.Value
	}
	return json.Marshal(objectMap)
}

// ConnectorSettingListIterator provides access to a complete listing of ConnectorSetting values.
type ConnectorSettingListIterator struct {
	i    int
	page ConnectorSettingListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ConnectorSettingListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConnectorSettingListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ConnectorSettingListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ConnectorSettingListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ConnectorSettingListIterator) Response() ConnectorSettingList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ConnectorSettingListIterator) Value() ConnectorSetting {
	if !iter.page.NotDone() {
		return ConnectorSetting{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ConnectorSettingListIterator type.
func NewConnectorSettingListIterator(page ConnectorSettingListPage) ConnectorSettingListIterator {
	return ConnectorSettingListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (csl ConnectorSettingList) IsEmpty() bool {
	return csl.Value == nil || len(*csl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (csl ConnectorSettingList) hasNextLink() bool {
	return csl.NextLink != nil && len(*csl.NextLink) != 0
}

// connectorSettingListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (csl ConnectorSettingList) connectorSettingListPreparer(ctx context.Context) (*http.Request, error) {
	if !csl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(csl.NextLink)))
}

// ConnectorSettingListPage contains a page of ConnectorSetting values.
type ConnectorSettingListPage struct {
	fn  func(context.Context, ConnectorSettingList) (ConnectorSettingList, error)
	csl ConnectorSettingList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ConnectorSettingListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConnectorSettingListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.csl)
		if err != nil {
			return err
		}
		page.csl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ConnectorSettingListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ConnectorSettingListPage) NotDone() bool {
	return !page.csl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ConnectorSettingListPage) Response() ConnectorSettingList {
	return page.csl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ConnectorSettingListPage) Values() []ConnectorSetting {
	if page.csl.IsEmpty() {
		return nil
	}
	return *page.csl.Value
}

// Creates a new instance of the ConnectorSettingListPage type.
func NewConnectorSettingListPage(cur ConnectorSettingList, getNextPage func(context.Context, ConnectorSettingList) (ConnectorSettingList, error)) ConnectorSettingListPage {
	return ConnectorSettingListPage{
		fn:  getNextPage,
		csl: cur,
	}
}

// ConnectorSettingProperties describes properties of a connector setting
type ConnectorSettingProperties struct {
	// HybridComputeSettings - Settings for hybrid compute management. These settings are relevant only for Arc autoProvision (Hybrid Compute).
	HybridComputeSettings *HybridComputeSettingsProperties `json:"hybridComputeSettings,omitempty"`
	// AuthenticationDetails - Settings for authentication management, these settings are relevant only for the cloud connector.
	AuthenticationDetails BasicAuthenticationDetailsProperties `json:"authenticationDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ConnectorSettingProperties struct.
func (csp *ConnectorSettingProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "hybridComputeSettings":
			if v != nil {
				var hybridComputeSettings HybridComputeSettingsProperties
				err = json.Unmarshal(*v, &hybridComputeSettings)
				if err != nil {
					return err
				}
				csp.HybridComputeSettings = &hybridComputeSettings
			}
		case "authenticationDetails":
			if v != nil {
				authenticationDetails, err := unmarshalBasicAuthenticationDetailsProperties(*v)
				if err != nil {
					return err
				}
				csp.AuthenticationDetails = authenticationDetails
			}
		}
	}

	return nil
}

// ConnectorsList list of security connectors response.
type ConnectorsList struct {
	autorest.Response `json:"-"`
	// Value - The list of security connectors under the given scope.
	Value *[]Connector `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectorsList.
func (cl ConnectorsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cl.Value != nil {
		objectMap["value"] = cl.Value
	}
	return json.Marshal(objectMap)
}

// ConnectorsListIterator provides access to a complete listing of Connector values.
type ConnectorsListIterator struct {
	i    int
	page ConnectorsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ConnectorsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConnectorsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ConnectorsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ConnectorsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ConnectorsListIterator) Response() ConnectorsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ConnectorsListIterator) Value() Connector {
	if !iter.page.NotDone() {
		return Connector{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ConnectorsListIterator type.
func NewConnectorsListIterator(page ConnectorsListPage) ConnectorsListIterator {
	return ConnectorsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cl ConnectorsList) IsEmpty() bool {
	return cl.Value == nil || len(*cl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cl ConnectorsList) hasNextLink() bool {
	return cl.NextLink != nil && len(*cl.NextLink) != 0
}

// connectorsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cl ConnectorsList) connectorsListPreparer(ctx context.Context) (*http.Request, error) {
	if !cl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cl.NextLink)))
}

// ConnectorsListPage contains a page of Connector values.
type ConnectorsListPage struct {
	fn func(context.Context, ConnectorsList) (ConnectorsList, error)
	cl ConnectorsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ConnectorsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConnectorsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cl)
		if err != nil {
			return err
		}
		page.cl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ConnectorsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ConnectorsListPage) NotDone() bool {
	return !page.cl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ConnectorsListPage) Response() ConnectorsList {
	return page.cl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ConnectorsListPage) Values() []Connector {
	if page.cl.IsEmpty() {
		return nil
	}
	return *page.cl.Value
}

// Creates a new instance of the ConnectorsListPage type.
func NewConnectorsListPage(cur ConnectorsList, getNextPage func(context.Context, ConnectorsList) (ConnectorsList, error)) ConnectorsListPage {
	return ConnectorsListPage{
		fn: getNextPage,
		cl: cur,
	}
}

// Contact contact details and configurations for notifications coming from Microsoft Defender for Cloud.
type Contact struct {
	autorest.Response `json:"-"`
	// ContactProperties - Security contact data
	*ContactProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Contact.
func (c Contact) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.ContactProperties != nil {
		objectMap["properties"] = c.ContactProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Contact struct.
func (c *Contact) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var contactProperties ContactProperties
				err = json.Unmarshal(*v, &contactProperties)
				if err != nil {
					return err
				}
				c.ContactProperties = &contactProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		}
	}

	return nil
}

// ContactList list of security contacts response
type ContactList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of security contacts
	Value *[]Contact `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ContactList.
func (cl ContactList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ContactListIterator provides access to a complete listing of Contact values.
type ContactListIterator struct {
	i    int
	page ContactListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ContactListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ContactListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ContactListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ContactListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ContactListIterator) Response() ContactList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ContactListIterator) Value() Contact {
	if !iter.page.NotDone() {
		return Contact{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ContactListIterator type.
func NewContactListIterator(page ContactListPage) ContactListIterator {
	return ContactListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cl ContactList) IsEmpty() bool {
	return cl.Value == nil || len(*cl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cl ContactList) hasNextLink() bool {
	return cl.NextLink != nil && len(*cl.NextLink) != 0
}

// contactListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cl ContactList) contactListPreparer(ctx context.Context) (*http.Request, error) {
	if !cl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cl.NextLink)))
}

// ContactListPage contains a page of Contact values.
type ContactListPage struct {
	fn func(context.Context, ContactList) (ContactList, error)
	cl ContactList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ContactListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ContactListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cl)
		if err != nil {
			return err
		}
		page.cl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ContactListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ContactListPage) NotDone() bool {
	return !page.cl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ContactListPage) Response() ContactList {
	return page.cl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ContactListPage) Values() []Contact {
	if page.cl.IsEmpty() {
		return nil
	}
	return *page.cl.Value
}

// Creates a new instance of the ContactListPage type.
func NewContactListPage(cur ContactList, getNextPage func(context.Context, ContactList) (ContactList, error)) ContactListPage {
	return ContactListPage{
		fn: getNextPage,
		cl: cur,
	}
}

// ContactProperties describes security contact properties
type ContactProperties struct {
	// Emails - List of email addresses which will get notifications from Microsoft Defender for Cloud by the configurations defined in this security contact.
	Emails *string `json:"emails,omitempty"`
	// Phone - The security contact's phone number
	Phone *string `json:"phone,omitempty"`
	// AlertNotifications - Defines whether to send email notifications about new security alerts
	AlertNotifications *ContactPropertiesAlertNotifications `json:"alertNotifications,omitempty"`
	// NotificationsByRole - Defines whether to send email notifications from Microsoft Defender for Cloud to persons with specific RBAC roles on the subscription.
	NotificationsByRole *ContactPropertiesNotificationsByRole `json:"notificationsByRole,omitempty"`
}

// ContactPropertiesAlertNotifications defines whether to send email notifications about new security
// alerts
type ContactPropertiesAlertNotifications struct {
	// State - Defines if email notifications will be sent about new security alerts. Possible values include: 'StateForAlertNotificationsOn', 'StateForAlertNotificationsOff'
	State StateForAlertNotifications `json:"state,omitempty"`
	// MinimalSeverity - Defines the minimal alert severity which will be sent as email notifications. Possible values include: 'MinimalSeverityHigh', 'MinimalSeverityMedium', 'MinimalSeverityLow'
	MinimalSeverity MinimalSeverity `json:"minimalSeverity,omitempty"`
}

// ContactPropertiesNotificationsByRole defines whether to send email notifications from Microsoft Defender
// for Cloud to persons with specific RBAC roles on the subscription.
type ContactPropertiesNotificationsByRole struct {
	// State - Defines whether to send email notifications from AMicrosoft Defender for Cloud to persons with specific RBAC roles on the subscription. Possible values include: 'StateForNotificationsByRoleOn', 'StateForNotificationsByRoleOff'
	State StateForNotificationsByRole `json:"state,omitempty"`
	// Roles - Defines which RBAC roles will get email notifications from Microsoft Defender for Cloud. List of allowed RBAC roles:
	Roles *[]Roles `json:"roles,omitempty"`
}

// ContainerRegistryVulnerabilityProperties additional context fields for container registry Vulnerability
// assessment
type ContainerRegistryVulnerabilityProperties struct {
	// Type - READ-ONLY; Vulnerability Type. e.g: Vulnerability, Potential Vulnerability, Information Gathered, Vulnerability
	Type *string `json:"type,omitempty"`
	// Cvss - READ-ONLY; Dictionary from cvss version to cvss details object
	Cvss map[string]*CVSS `json:"cvss"`
	// Patchable - READ-ONLY; Indicates whether a patch is available or not
	Patchable *bool `json:"patchable,omitempty"`
	// Cve - READ-ONLY; List of CVEs
	Cve *[]CVE `json:"cve,omitempty"`
	// PublishedTime - READ-ONLY; Published time
	PublishedTime *date.Time `json:"publishedTime,omitempty"`
	// VendorReferences - READ-ONLY
	VendorReferences *[]VendorReference `json:"vendorReferences,omitempty"`
	// RepositoryName - READ-ONLY; Name of the repository which the vulnerable image belongs to
	RepositoryName *string `json:"repositoryName,omitempty"`
	// ImageDigest - READ-ONLY; Digest of the vulnerable image
	ImageDigest *string `json:"imageDigest,omitempty"`
	// AssessedResourceType - Possible values include: 'AssessedResourceTypeAdditionalData', 'AssessedResourceTypeSQLServerVulnerability', 'AssessedResourceTypeContainerRegistryVulnerability', 'AssessedResourceTypeServerVulnerabilityAssessment'
	AssessedResourceType AssessedResourceType `json:"assessedResourceType,omitempty"`
}

// MarshalJSON is the custom marshaler for ContainerRegistryVulnerabilityProperties.
func (crvp ContainerRegistryVulnerabilityProperties) MarshalJSON() ([]byte, error) {
	crvp.AssessedResourceType = AssessedResourceTypeContainerRegistryVulnerability
	objectMap := make(map[string]interface{})
	if crvp.AssessedResourceType != "" {
		objectMap["assessedResourceType"] = crvp.AssessedResourceType
	}
	return json.Marshal(objectMap)
}

// AsSQLServerVulnerabilityProperties is the BasicAdditionalData implementation for ContainerRegistryVulnerabilityProperties.
func (crvp ContainerRegistryVulnerabilityProperties) AsSQLServerVulnerabilityProperties() (*SQLServerVulnerabilityProperties, bool) {
	return nil, false
}

// AsContainerRegistryVulnerabilityProperties is the BasicAdditionalData implementation for ContainerRegistryVulnerabilityProperties.
func (crvp ContainerRegistryVulnerabilityProperties) AsContainerRegistryVulnerabilityProperties() (*ContainerRegistryVulnerabilityProperties, bool) {
	return &crvp, true
}

// AsServerVulnerabilityProperties is the BasicAdditionalData implementation for ContainerRegistryVulnerabilityProperties.
func (crvp ContainerRegistryVulnerabilityProperties) AsServerVulnerabilityProperties() (*ServerVulnerabilityProperties, bool) {
	return nil, false
}

// AsAdditionalData is the BasicAdditionalData implementation for ContainerRegistryVulnerabilityProperties.
func (crvp ContainerRegistryVulnerabilityProperties) AsAdditionalData() (*AdditionalData, bool) {
	return nil, false
}

// AsBasicAdditionalData is the BasicAdditionalData implementation for ContainerRegistryVulnerabilityProperties.
func (crvp ContainerRegistryVulnerabilityProperties) AsBasicAdditionalData() (BasicAdditionalData, bool) {
	return &crvp, true
}

// CspmMonitorAwsOffering the CSPM monitoring for AWS offering
type CspmMonitorAwsOffering struct {
	// NativeCloudConnection - The native cloud connection configuration
	NativeCloudConnection *CspmMonitorAwsOfferingNativeCloudConnection `json:"nativeCloudConnection,omitempty"`
	// Description - READ-ONLY; The offering description.
	Description *string `json:"description,omitempty"`
	// OfferingType - Possible values include: 'OfferingTypeCloudOffering', 'OfferingTypeCspmMonitorAws', 'OfferingTypeDefenderForContainersAws', 'OfferingTypeDefenderForServersAws', 'OfferingTypeDefenderForDatabasesAws', 'OfferingTypeInformationProtectionAws', 'OfferingTypeCspmMonitorGcp', 'OfferingTypeDefenderForServersGcp', 'OfferingTypeDefenderForDatabasesGcp', 'OfferingTypeDefenderForContainersGcp', 'OfferingTypeCspmMonitorGithub', 'OfferingTypeCspmMonitorAzureDevOps', 'OfferingTypeDefenderCspmAws', 'OfferingTypeDefenderCspmGcp', 'OfferingTypeDefenderForDevOpsGithub', 'OfferingTypeDefenderForDevOpsAzureDevOps'
	OfferingType OfferingType `json:"offeringType,omitempty"`
}

// MarshalJSON is the custom marshaler for CspmMonitorAwsOffering.
func (cmao CspmMonitorAwsOffering) MarshalJSON() ([]byte, error) {
	cmao.OfferingType = OfferingTypeCspmMonitorAws
	objectMap := make(map[string]interface{})
	if cmao.NativeCloudConnection != nil {
		objectMap["nativeCloudConnection"] = cmao.NativeCloudConnection
	}
	if cmao.OfferingType != "" {
		objectMap["offeringType"] = cmao.OfferingType
	}
	return json.Marshal(objectMap)
}

// AsCspmMonitorAwsOffering is the BasicCloudOffering implementation for CspmMonitorAwsOffering.
func (cmao CspmMonitorAwsOffering) AsCspmMonitorAwsOffering() (*CspmMonitorAwsOffering, bool) {
	return &cmao, true
}

// AsDefenderForContainersAwsOffering is the BasicCloudOffering implementation for CspmMonitorAwsOffering.
func (cmao CspmMonitorAwsOffering) AsDefenderForContainersAwsOffering() (*DefenderForContainersAwsOffering, bool) {
	return nil, false
}

// AsDefenderForServersAwsOffering is the BasicCloudOffering implementation for CspmMonitorAwsOffering.
func (cmao CspmMonitorAwsOffering) AsDefenderForServersAwsOffering() (*DefenderForServersAwsOffering, bool) {
	return nil, false
}

// AsDefenderFoDatabasesAwsOffering is the BasicCloudOffering implementation for CspmMonitorAwsOffering.
func (cmao CspmMonitorAwsOffering) AsDefenderFoDatabasesAwsOffering() (*DefenderFoDatabasesAwsOffering, bool) {
	return nil, false
}

// AsInformationProtectionAwsOffering is the BasicCloudOffering implementation for CspmMonitorAwsOffering.
func (cmao CspmMonitorAwsOffering) AsInformationProtectionAwsOffering() (*InformationProtectionAwsOffering, bool) {
	return nil, false
}

// AsCspmMonitorGcpOffering is the BasicCloudOffering implementation for CspmMonitorAwsOffering.
func (cmao CspmMonitorAwsOffering) AsCspmMonitorGcpOffering() (*CspmMonitorGcpOffering, bool) {
	return nil, false
}

// AsDefenderForServersGcpOffering is the BasicCloudOffering implementation for CspmMonitorAwsOffering.
func (cmao CspmMonitorAwsOffering) AsDefenderForServersGcpOffering() (*DefenderForServersGcpOffering, bool) {
	return nil, false
}

// AsDefenderForDatabasesGcpOffering is the BasicCloudOffering implementation for CspmMonitorAwsOffering.
func (cmao CspmMonitorAwsOffering) AsDefenderForDatabasesGcpOffering() (*DefenderForDatabasesGcpOffering, bool) {
	return nil, false
}

// AsDefenderForContainersGcpOffering is the BasicCloudOffering implementation for CspmMonitorAwsOffering.
func (cmao CspmMonitorAwsOffering) AsDefenderForContainersGcpOffering() (*DefenderForContainersGcpOffering, bool) {
	return nil, false
}

// AsCspmMonitorGithubOffering is the BasicCloudOffering implementation for CspmMonitorAwsOffering.
func (cmao CspmMonitorAwsOffering) AsCspmMonitorGithubOffering() (*CspmMonitorGithubOffering, bool) {
	return nil, false
}

// AsCspmMonitorAzureDevOpsOffering is the BasicCloudOffering implementation for CspmMonitorAwsOffering.
func (cmao CspmMonitorAwsOffering) AsCspmMonitorAzureDevOpsOffering() (*CspmMonitorAzureDevOpsOffering, bool) {
	return nil, false
}

// AsDefenderCspmAwsOffering is the BasicCloudOffering implementation for CspmMonitorAwsOffering.
func (cmao CspmMonitorAwsOffering) AsDefenderCspmAwsOffering() (*DefenderCspmAwsOffering, bool) {
	return nil, false
}

// AsDefenderCspmGcpOffering is the BasicCloudOffering implementation for CspmMonitorAwsOffering.
func (cmao CspmMonitorAwsOffering) AsDefenderCspmGcpOffering() (*DefenderCspmGcpOffering, bool) {
	return nil, false
}

// AsDefenderForDevOpsGithubOffering is the BasicCloudOffering implementation for CspmMonitorAwsOffering.
func (cmao CspmMonitorAwsOffering) AsDefenderForDevOpsGithubOffering() (*DefenderForDevOpsGithubOffering, bool) {
	return nil, false
}

// AsDefenderForDevOpsAzureDevOpsOffering is the BasicCloudOffering implementation for CspmMonitorAwsOffering.
func (cmao CspmMonitorAwsOffering) AsDefenderForDevOpsAzureDevOpsOffering() (*DefenderForDevOpsAzureDevOpsOffering, bool) {
	return nil, false
}

// AsCloudOffering is the BasicCloudOffering implementation for CspmMonitorAwsOffering.
func (cmao CspmMonitorAwsOffering) AsCloudOffering() (*CloudOffering, bool) {
	return nil, false
}

// AsBasicCloudOffering is the BasicCloudOffering implementation for CspmMonitorAwsOffering.
func (cmao CspmMonitorAwsOffering) AsBasicCloudOffering() (BasicCloudOffering, bool) {
	return &cmao, true
}

// CspmMonitorAwsOfferingNativeCloudConnection the native cloud connection configuration
type CspmMonitorAwsOfferingNativeCloudConnection struct {
	// CloudRoleArn - The cloud role ARN in AWS for this feature
	CloudRoleArn *string `json:"cloudRoleArn,omitempty"`
}

// CspmMonitorAzureDevOpsOffering the CSPM monitoring for AzureDevOps offering
type CspmMonitorAzureDevOpsOffering struct {
	// Description - READ-ONLY; The offering description.
	Description *string `json:"description,omitempty"`
	// OfferingType - Possible values include: 'OfferingTypeCloudOffering', 'OfferingTypeCspmMonitorAws', 'OfferingTypeDefenderForContainersAws', 'OfferingTypeDefenderForServersAws', 'OfferingTypeDefenderForDatabasesAws', 'OfferingTypeInformationProtectionAws', 'OfferingTypeCspmMonitorGcp', 'OfferingTypeDefenderForServersGcp', 'OfferingTypeDefenderForDatabasesGcp', 'OfferingTypeDefenderForContainersGcp', 'OfferingTypeCspmMonitorGithub', 'OfferingTypeCspmMonitorAzureDevOps', 'OfferingTypeDefenderCspmAws', 'OfferingTypeDefenderCspmGcp', 'OfferingTypeDefenderForDevOpsGithub', 'OfferingTypeDefenderForDevOpsAzureDevOps'
	OfferingType OfferingType `json:"offeringType,omitempty"`
}

// MarshalJSON is the custom marshaler for CspmMonitorAzureDevOpsOffering.
func (cmadoo CspmMonitorAzureDevOpsOffering) MarshalJSON() ([]byte, error) {
	cmadoo.OfferingType = OfferingTypeCspmMonitorAzureDevOps
	objectMap := make(map[string]interface{})
	if cmadoo.OfferingType != "" {
		objectMap["offeringType"] = cmadoo.OfferingType
	}
	return json.Marshal(objectMap)
}

// AsCspmMonitorAwsOffering is the BasicCloudOffering implementation for CspmMonitorAzureDevOpsOffering.
func (cmadoo CspmMonitorAzureDevOpsOffering) AsCspmMonitorAwsOffering() (*CspmMonitorAwsOffering, bool) {
	return nil, false
}

// AsDefenderForContainersAwsOffering is the BasicCloudOffering implementation for CspmMonitorAzureDevOpsOffering.
func (cmadoo CspmMonitorAzureDevOpsOffering) AsDefenderForContainersAwsOffering() (*DefenderForContainersAwsOffering, bool) {
	return nil, false
}

// AsDefenderForServersAwsOffering is the BasicCloudOffering implementation for CspmMonitorAzureDevOpsOffering.
func (cmadoo CspmMonitorAzureDevOpsOffering) AsDefenderForServersAwsOffering() (*DefenderForServersAwsOffering, bool) {
	return nil, false
}

// AsDefenderFoDatabasesAwsOffering is the BasicCloudOffering implementation for CspmMonitorAzureDevOpsOffering.
func (cmadoo CspmMonitorAzureDevOpsOffering) AsDefenderFoDatabasesAwsOffering() (*DefenderFoDatabasesAwsOffering, bool) {
	return nil, false
}

// AsInformationProtectionAwsOffering is the BasicCloudOffering implementation for CspmMonitorAzureDevOpsOffering.
func (cmadoo CspmMonitorAzureDevOpsOffering) AsInformationProtectionAwsOffering() (*InformationProtectionAwsOffering, bool) {
	return nil, false
}

// AsCspmMonitorGcpOffering is the BasicCloudOffering implementation for CspmMonitorAzureDevOpsOffering.
func (cmadoo CspmMonitorAzureDevOpsOffering) AsCspmMonitorGcpOffering() (*CspmMonitorGcpOffering, bool) {
	return nil, false
}

// AsDefenderForServersGcpOffering is the BasicCloudOffering implementation for CspmMonitorAzureDevOpsOffering.
func (cmadoo CspmMonitorAzureDevOpsOffering) AsDefenderForServersGcpOffering() (*DefenderForServersGcpOffering, bool) {
	return nil, false
}

// AsDefenderForDatabasesGcpOffering is the BasicCloudOffering implementation for CspmMonitorAzureDevOpsOffering.
func (cmadoo CspmMonitorAzureDevOpsOffering) AsDefenderForDatabasesGcpOffering() (*DefenderForDatabasesGcpOffering, bool) {
	return nil, false
}

// AsDefenderForContainersGcpOffering is the BasicCloudOffering implementation for CspmMonitorAzureDevOpsOffering.
func (cmadoo CspmMonitorAzureDevOpsOffering) AsDefenderForContainersGcpOffering() (*DefenderForContainersGcpOffering, bool) {
	return nil, false
}

// AsCspmMonitorGithubOffering is the BasicCloudOffering implementation for CspmMonitorAzureDevOpsOffering.
func (cmadoo CspmMonitorAzureDevOpsOffering) AsCspmMonitorGithubOffering() (*CspmMonitorGithubOffering, bool) {
	return nil, false
}

// AsCspmMonitorAzureDevOpsOffering is the BasicCloudOffering implementation for CspmMonitorAzureDevOpsOffering.
func (cmadoo CspmMonitorAzureDevOpsOffering) AsCspmMonitorAzureDevOpsOffering() (*CspmMonitorAzureDevOpsOffering, bool) {
	return &cmadoo, true
}

// AsDefenderCspmAwsOffering is the BasicCloudOffering implementation for CspmMonitorAzureDevOpsOffering.
func (cmadoo CspmMonitorAzureDevOpsOffering) AsDefenderCspmAwsOffering() (*DefenderCspmAwsOffering, bool) {
	return nil, false
}

// AsDefenderCspmGcpOffering is the BasicCloudOffering implementation for CspmMonitorAzureDevOpsOffering.
func (cmadoo CspmMonitorAzureDevOpsOffering) AsDefenderCspmGcpOffering() (*DefenderCspmGcpOffering, bool) {
	return nil, false
}

// AsDefenderForDevOpsGithubOffering is the BasicCloudOffering implementation for CspmMonitorAzureDevOpsOffering.
func (cmadoo CspmMonitorAzureDevOpsOffering) AsDefenderForDevOpsGithubOffering() (*DefenderForDevOpsGithubOffering, bool) {
	return nil, false
}

// AsDefenderForDevOpsAzureDevOpsOffering is the BasicCloudOffering implementation for CspmMonitorAzureDevOpsOffering.
func (cmadoo CspmMonitorAzureDevOpsOffering) AsDefenderForDevOpsAzureDevOpsOffering() (*DefenderForDevOpsAzureDevOpsOffering, bool) {
	return nil, false
}

// AsCloudOffering is the BasicCloudOffering implementation for CspmMonitorAzureDevOpsOffering.
func (cmadoo CspmMonitorAzureDevOpsOffering) AsCloudOffering() (*CloudOffering, bool) {
	return nil, false
}

// AsBasicCloudOffering is the BasicCloudOffering implementation for CspmMonitorAzureDevOpsOffering.
func (cmadoo CspmMonitorAzureDevOpsOffering) AsBasicCloudOffering() (BasicCloudOffering, bool) {
	return &cmadoo, true
}

// CspmMonitorGcpOffering the CSPM monitoring for GCP offering
type CspmMonitorGcpOffering struct {
	// NativeCloudConnection - The native cloud connection configuration
	NativeCloudConnection *CspmMonitorGcpOfferingNativeCloudConnection `json:"nativeCloudConnection,omitempty"`
	// Description - READ-ONLY; The offering description.
	Description *string `json:"description,omitempty"`
	// OfferingType - Possible values include: 'OfferingTypeCloudOffering', 'OfferingTypeCspmMonitorAws', 'OfferingTypeDefenderForContainersAws', 'OfferingTypeDefenderForServersAws', 'OfferingTypeDefenderForDatabasesAws', 'OfferingTypeInformationProtectionAws', 'OfferingTypeCspmMonitorGcp', 'OfferingTypeDefenderForServersGcp', 'OfferingTypeDefenderForDatabasesGcp', 'OfferingTypeDefenderForContainersGcp', 'OfferingTypeCspmMonitorGithub', 'OfferingTypeCspmMonitorAzureDevOps', 'OfferingTypeDefenderCspmAws', 'OfferingTypeDefenderCspmGcp', 'OfferingTypeDefenderForDevOpsGithub', 'OfferingTypeDefenderForDevOpsAzureDevOps'
	OfferingType OfferingType `json:"offeringType,omitempty"`
}

// MarshalJSON is the custom marshaler for CspmMonitorGcpOffering.
func (cmgo CspmMonitorGcpOffering) MarshalJSON() ([]byte, error) {
	cmgo.OfferingType = OfferingTypeCspmMonitorGcp
	objectMap := make(map[string]interface{})
	if cmgo.NativeCloudConnection != nil {
		objectMap["nativeCloudConnection"] = cmgo.NativeCloudConnection
	}
	if cmgo.OfferingType != "" {
		objectMap["offeringType"] = cmgo.OfferingType
	}
	return json.Marshal(objectMap)
}

// AsCspmMonitorAwsOffering is the BasicCloudOffering implementation for CspmMonitorGcpOffering.
func (cmgo CspmMonitorGcpOffering) AsCspmMonitorAwsOffering() (*CspmMonitorAwsOffering, bool) {
	return nil, false
}

// AsDefenderForContainersAwsOffering is the BasicCloudOffering implementation for CspmMonitorGcpOffering.
func (cmgo CspmMonitorGcpOffering) AsDefenderForContainersAwsOffering() (*DefenderForContainersAwsOffering, bool) {
	return nil, false
}

// AsDefenderForServersAwsOffering is the BasicCloudOffering implementation for CspmMonitorGcpOffering.
func (cmgo CspmMonitorGcpOffering) AsDefenderForServersAwsOffering() (*DefenderForServersAwsOffering, bool) {
	return nil, false
}

// AsDefenderFoDatabasesAwsOffering is the BasicCloudOffering implementation for CspmMonitorGcpOffering.
func (cmgo CspmMonitorGcpOffering) AsDefenderFoDatabasesAwsOffering() (*DefenderFoDatabasesAwsOffering, bool) {
	return nil, false
}

// AsInformationProtectionAwsOffering is the BasicCloudOffering implementation for CspmMonitorGcpOffering.
func (cmgo CspmMonitorGcpOffering) AsInformationProtectionAwsOffering() (*InformationProtectionAwsOffering, bool) {
	return nil, false
}

// AsCspmMonitorGcpOffering is the BasicCloudOffering implementation for CspmMonitorGcpOffering.
func (cmgo CspmMonitorGcpOffering) AsCspmMonitorGcpOffering() (*CspmMonitorGcpOffering, bool) {
	return &cmgo, true
}

// AsDefenderForServersGcpOffering is the BasicCloudOffering implementation for CspmMonitorGcpOffering.
func (cmgo CspmMonitorGcpOffering) AsDefenderForServersGcpOffering() (*DefenderForServersGcpOffering, bool) {
	return nil, false
}

// AsDefenderForDatabasesGcpOffering is the BasicCloudOffering implementation for CspmMonitorGcpOffering.
func (cmgo CspmMonitorGcpOffering) AsDefenderForDatabasesGcpOffering() (*DefenderForDatabasesGcpOffering, bool) {
	return nil, false
}

// AsDefenderForContainersGcpOffering is the BasicCloudOffering implementation for CspmMonitorGcpOffering.
func (cmgo CspmMonitorGcpOffering) AsDefenderForContainersGcpOffering() (*DefenderForContainersGcpOffering, bool) {
	return nil, false
}

// AsCspmMonitorGithubOffering is the BasicCloudOffering implementation for CspmMonitorGcpOffering.
func (cmgo CspmMonitorGcpOffering) AsCspmMonitorGithubOffering() (*CspmMonitorGithubOffering, bool) {
	return nil, false
}

// AsCspmMonitorAzureDevOpsOffering is the BasicCloudOffering implementation for CspmMonitorGcpOffering.
func (cmgo CspmMonitorGcpOffering) AsCspmMonitorAzureDevOpsOffering() (*CspmMonitorAzureDevOpsOffering, bool) {
	return nil, false
}

// AsDefenderCspmAwsOffering is the BasicCloudOffering implementation for CspmMonitorGcpOffering.
func (cmgo CspmMonitorGcpOffering) AsDefenderCspmAwsOffering() (*DefenderCspmAwsOffering, bool) {
	return nil, false
}

// AsDefenderCspmGcpOffering is the BasicCloudOffering implementation for CspmMonitorGcpOffering.
func (cmgo CspmMonitorGcpOffering) AsDefenderCspmGcpOffering() (*DefenderCspmGcpOffering, bool) {
	return nil, false
}

// AsDefenderForDevOpsGithubOffering is the BasicCloudOffering implementation for CspmMonitorGcpOffering.
func (cmgo CspmMonitorGcpOffering) AsDefenderForDevOpsGithubOffering() (*DefenderForDevOpsGithubOffering, bool) {
	return nil, false
}

// AsDefenderForDevOpsAzureDevOpsOffering is the BasicCloudOffering implementation for CspmMonitorGcpOffering.
func (cmgo CspmMonitorGcpOffering) AsDefenderForDevOpsAzureDevOpsOffering() (*DefenderForDevOpsAzureDevOpsOffering, bool) {
	return nil, false
}

// AsCloudOffering is the BasicCloudOffering implementation for CspmMonitorGcpOffering.
func (cmgo CspmMonitorGcpOffering) AsCloudOffering() (*CloudOffering, bool) {
	return nil, false
}

// AsBasicCloudOffering is the BasicCloudOffering implementation for CspmMonitorGcpOffering.
func (cmgo CspmMonitorGcpOffering) AsBasicCloudOffering() (BasicCloudOffering, bool) {
	return &cmgo, true
}

// CspmMonitorGcpOfferingNativeCloudConnection the native cloud connection configuration
type CspmMonitorGcpOfferingNativeCloudConnection struct {
	// WorkloadIdentityProviderID - The GCP workload identity provider id for the offering
	WorkloadIdentityProviderID *string `json:"workloadIdentityProviderId,omitempty"`
	// ServiceAccountEmailAddress - The service account email address in GCP for this offering
	ServiceAccountEmailAddress *string `json:"serviceAccountEmailAddress,omitempty"`
}

// CspmMonitorGithubOffering the CSPM monitoring for github offering
type CspmMonitorGithubOffering struct {
	// Description - READ-ONLY; The offering description.
	Description *string `json:"description,omitempty"`
	// OfferingType - Possible values include: 'OfferingTypeCloudOffering', 'OfferingTypeCspmMonitorAws', 'OfferingTypeDefenderForContainersAws', 'OfferingTypeDefenderForServersAws', 'OfferingTypeDefenderForDatabasesAws', 'OfferingTypeInformationProtectionAws', 'OfferingTypeCspmMonitorGcp', 'OfferingTypeDefenderForServersGcp', 'OfferingTypeDefenderForDatabasesGcp', 'OfferingTypeDefenderForContainersGcp', 'OfferingTypeCspmMonitorGithub', 'OfferingTypeCspmMonitorAzureDevOps', 'OfferingTypeDefenderCspmAws', 'OfferingTypeDefenderCspmGcp', 'OfferingTypeDefenderForDevOpsGithub', 'OfferingTypeDefenderForDevOpsAzureDevOps'
	OfferingType OfferingType `json:"offeringType,omitempty"`
}

// MarshalJSON is the custom marshaler for CspmMonitorGithubOffering.
func (cmgo CspmMonitorGithubOffering) MarshalJSON() ([]byte, error) {
	cmgo.OfferingType = OfferingTypeCspmMonitorGithub
	objectMap := make(map[string]interface{})
	if cmgo.OfferingType != "" {
		objectMap["offeringType"] = cmgo.OfferingType
	}
	return json.Marshal(objectMap)
}

// AsCspmMonitorAwsOffering is the BasicCloudOffering implementation for CspmMonitorGithubOffering.
func (cmgo CspmMonitorGithubOffering) AsCspmMonitorAwsOffering() (*CspmMonitorAwsOffering, bool) {
	return nil, false
}

// AsDefenderForContainersAwsOffering is the BasicCloudOffering implementation for CspmMonitorGithubOffering.
func (cmgo CspmMonitorGithubOffering) AsDefenderForContainersAwsOffering() (*DefenderForContainersAwsOffering, bool) {
	return nil, false
}

// AsDefenderForServersAwsOffering is the BasicCloudOffering implementation for CspmMonitorGithubOffering.
func (cmgo CspmMonitorGithubOffering) AsDefenderForServersAwsOffering() (*DefenderForServersAwsOffering, bool) {
	return nil, false
}

// AsDefenderFoDatabasesAwsOffering is the BasicCloudOffering implementation for CspmMonitorGithubOffering.
func (cmgo CspmMonitorGithubOffering) AsDefenderFoDatabasesAwsOffering() (*DefenderFoDatabasesAwsOffering, bool) {
	return nil, false
}

// AsInformationProtectionAwsOffering is the BasicCloudOffering implementation for CspmMonitorGithubOffering.
func (cmgo CspmMonitorGithubOffering) AsInformationProtectionAwsOffering() (*InformationProtectionAwsOffering, bool) {
	return nil, false
}

// AsCspmMonitorGcpOffering is the BasicCloudOffering implementation for CspmMonitorGithubOffering.
func (cmgo CspmMonitorGithubOffering) AsCspmMonitorGcpOffering() (*CspmMonitorGcpOffering, bool) {
	return nil, false
}

// AsDefenderForServersGcpOffering is the BasicCloudOffering implementation for CspmMonitorGithubOffering.
func (cmgo CspmMonitorGithubOffering) AsDefenderForServersGcpOffering() (*DefenderForServersGcpOffering, bool) {
	return nil, false
}

// AsDefenderForDatabasesGcpOffering is the BasicCloudOffering implementation for CspmMonitorGithubOffering.
func (cmgo CspmMonitorGithubOffering) AsDefenderForDatabasesGcpOffering() (*DefenderForDatabasesGcpOffering, bool) {
	return nil, false
}

// AsDefenderForContainersGcpOffering is the BasicCloudOffering implementation for CspmMonitorGithubOffering.
func (cmgo CspmMonitorGithubOffering) AsDefenderForContainersGcpOffering() (*DefenderForContainersGcpOffering, bool) {
	return nil, false
}

// AsCspmMonitorGithubOffering is the BasicCloudOffering implementation for CspmMonitorGithubOffering.
func (cmgo CspmMonitorGithubOffering) AsCspmMonitorGithubOffering() (*CspmMonitorGithubOffering, bool) {
	return &cmgo, true
}

// AsCspmMonitorAzureDevOpsOffering is the BasicCloudOffering implementation for CspmMonitorGithubOffering.
func (cmgo CspmMonitorGithubOffering) AsCspmMonitorAzureDevOpsOffering() (*CspmMonitorAzureDevOpsOffering, bool) {
	return nil, false
}

// AsDefenderCspmAwsOffering is the BasicCloudOffering implementation for CspmMonitorGithubOffering.
func (cmgo CspmMonitorGithubOffering) AsDefenderCspmAwsOffering() (*DefenderCspmAwsOffering, bool) {
	return nil, false
}

// AsDefenderCspmGcpOffering is the BasicCloudOffering implementation for CspmMonitorGithubOffering.
func (cmgo CspmMonitorGithubOffering) AsDefenderCspmGcpOffering() (*DefenderCspmGcpOffering, bool) {
	return nil, false
}

// AsDefenderForDevOpsGithubOffering is the BasicCloudOffering implementation for CspmMonitorGithubOffering.
func (cmgo CspmMonitorGithubOffering) AsDefenderForDevOpsGithubOffering() (*DefenderForDevOpsGithubOffering, bool) {
	return nil, false
}

// AsDefenderForDevOpsAzureDevOpsOffering is the BasicCloudOffering implementation for CspmMonitorGithubOffering.
func (cmgo CspmMonitorGithubOffering) AsDefenderForDevOpsAzureDevOpsOffering() (*DefenderForDevOpsAzureDevOpsOffering, bool) {
	return nil, false
}

// AsCloudOffering is the BasicCloudOffering implementation for CspmMonitorGithubOffering.
func (cmgo CspmMonitorGithubOffering) AsCloudOffering() (*CloudOffering, bool) {
	return nil, false
}

// AsBasicCloudOffering is the BasicCloudOffering implementation for CspmMonitorGithubOffering.
func (cmgo CspmMonitorGithubOffering) AsBasicCloudOffering() (BasicCloudOffering, bool) {
	return &cmgo, true
}

// BasicCustomAlertRule a custom alert rule.
type BasicCustomAlertRule interface {
	AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool)
	AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool)
	AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool)
	AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool)
	AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool)
	AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool)
	AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool)
	AsListCustomAlertRule() (*ListCustomAlertRule, bool)
	AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool)
	AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool)
	AsConnectionFromIPNotAllowed() (*ConnectionFromIPNotAllowed, bool)
	AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool)
	AsProcessNotAllowed() (*ProcessNotAllowed, bool)
	AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool)
	AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool)
	AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool)
	AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool)
	AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool)
	AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool)
	AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool)
	AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool)
	AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool)
	AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool)
	AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool)
	AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool)
	AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool)
	AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool)
	AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool)
	AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool)
	AsCustomAlertRule() (*CustomAlertRule, bool)
}

// CustomAlertRule a custom alert rule.
type CustomAlertRule struct {
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeConnectionFromIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

func unmarshalBasicCustomAlertRule(body []byte) (BasicCustomAlertRule, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["ruleType"] {
	case string(RuleTypeThresholdCustomAlertRule):
		var tcar ThresholdCustomAlertRule
		err := json.Unmarshal(body, &tcar)
		return tcar, err
	case string(RuleTypeTimeWindowCustomAlertRule):
		var twcar TimeWindowCustomAlertRule
		err := json.Unmarshal(body, &twcar)
		return twcar, err
	case string(RuleTypeAllowlistCustomAlertRule):
		var acar AllowlistCustomAlertRule
		err := json.Unmarshal(body, &acar)
		return acar, err
	case string(RuleTypeDenylistCustomAlertRule):
		var dcar DenylistCustomAlertRule
		err := json.Unmarshal(body, &dcar)
		return dcar, err
	case string(RuleTypeListCustomAlertRule):
		var lcar ListCustomAlertRule
		err := json.Unmarshal(body, &lcar)
		return lcar, err
	case string(RuleTypeConnectionToIPNotAllowed):
		var ctina ConnectionToIPNotAllowed
		err := json.Unmarshal(body, &ctina)
		return ctina, err
	case string(RuleTypeConnectionFromIPNotAllowed):
		var cfina ConnectionFromIPNotAllowed
		err := json.Unmarshal(body, &cfina)
		return cfina, err
	case string(RuleTypeLocalUserNotAllowed):
		var luna LocalUserNotAllowed
		err := json.Unmarshal(body, &luna)
		return luna, err
	case string(RuleTypeProcessNotAllowed):
		var pna ProcessNotAllowed
		err := json.Unmarshal(body, &pna)
		return pna, err
	case string(RuleTypeActiveConnectionsNotInAllowedRange):
		var acniar ActiveConnectionsNotInAllowedRange
		err := json.Unmarshal(body, &acniar)
		return acniar, err
	case string(RuleTypeAmqpC2DMessagesNotInAllowedRange):
		var acmniar AmqpC2DMessagesNotInAllowedRange
		err := json.Unmarshal(body, &acmniar)
		return acmniar, err
	case string(RuleTypeMqttC2DMessagesNotInAllowedRange):
		var mcmniar MqttC2DMessagesNotInAllowedRange
		err := json.Unmarshal(body, &mcmniar)
		return mcmniar, err
	case string(RuleTypeHTTPC2DMessagesNotInAllowedRange):
		var hcmniar HTTPC2DMessagesNotInAllowedRange
		err := json.Unmarshal(body, &hcmniar)
		return hcmniar, err
	case string(RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange):
		var acrmniar AmqpC2DRejectedMessagesNotInAllowedRange
		err := json.Unmarshal(body, &acrmniar)
		return acrmniar, err
	case string(RuleTypeMqttC2DRejectedMessagesNotInAllowedRange):
		var mcrmniar MqttC2DRejectedMessagesNotInAllowedRange
		err := json.Unmarshal(body, &mcrmniar)
		return mcrmniar, err
	case string(RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange):
		var hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange
		err := json.Unmarshal(body, &hcrmniar)
		return hcrmniar, err
	case string(RuleTypeAmqpD2CMessagesNotInAllowedRange):
		var admniar AmqpD2CMessagesNotInAllowedRange
		err := json.Unmarshal(body, &admniar)
		return admniar, err
	case string(RuleTypeMqttD2CMessagesNotInAllowedRange):
		var mdmniar MqttD2CMessagesNotInAllowedRange
		err := json.Unmarshal(body, &mdmniar)
		return mdmniar, err
	case string(RuleTypeHTTPD2CMessagesNotInAllowedRange):
		var hdmniar HTTPD2CMessagesNotInAllowedRange
		err := json.Unmarshal(body, &hdmniar)
		return hdmniar, err
	case string(RuleTypeDirectMethodInvokesNotInAllowedRange):
		var dminiar DirectMethodInvokesNotInAllowedRange
		err := json.Unmarshal(body, &dminiar)
		return dminiar, err
	case string(RuleTypeFailedLocalLoginsNotInAllowedRange):
		var fllniar FailedLocalLoginsNotInAllowedRange
		err := json.Unmarshal(body, &fllniar)
		return fllniar, err
	case string(RuleTypeFileUploadsNotInAllowedRange):
		var funiar FileUploadsNotInAllowedRange
		err := json.Unmarshal(body, &funiar)
		return funiar, err
	case string(RuleTypeQueuePurgesNotInAllowedRange):
		var qpniar QueuePurgesNotInAllowedRange
		err := json.Unmarshal(body, &qpniar)
		return qpniar, err
	case string(RuleTypeTwinUpdatesNotInAllowedRange):
		var tuniar TwinUpdatesNotInAllowedRange
		err := json.Unmarshal(body, &tuniar)
		return tuniar, err
	case string(RuleTypeUnauthorizedOperationsNotInAllowedRange):
		var uoniar UnauthorizedOperationsNotInAllowedRange
		err := json.Unmarshal(body, &uoniar)
		return uoniar, err
	default:
		var car CustomAlertRule
		err := json.Unmarshal(body, &car)
		return car, err
	}
}
func unmarshalBasicCustomAlertRuleArray(body []byte) ([]BasicCustomAlertRule, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	carArray := make([]BasicCustomAlertRule, len(rawMessages))

	for index, rawMessage := range rawMessages {
		car, err := unmarshalBasicCustomAlertRule(*rawMessage)
		if err != nil {
			return nil, err
		}
		carArray[index] = car
	}
	return carArray, nil
}

// MarshalJSON is the custom marshaler for CustomAlertRule.
func (car CustomAlertRule) MarshalJSON() ([]byte, error) {
	car.RuleType = RuleTypeCustomAlertRule
	objectMap := make(map[string]interface{})
	if car.IsEnabled != nil {
		objectMap["isEnabled"] = car.IsEnabled
	}
	if car.RuleType != "" {
		objectMap["ruleType"] = car.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsConnectionFromIPNotAllowed is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsConnectionFromIPNotAllowed() (*ConnectionFromIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return &car, true
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for CustomAlertRule.
func (car CustomAlertRule) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &car, true
}

// CustomAssessmentAutomation custom Assessment Automation
type CustomAssessmentAutomation struct {
	autorest.Response `json:"-"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
	// CustomAssessmentAutomationProperties - describes Custom Assessment Automation properties.
	*CustomAssessmentAutomationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomAssessmentAutomation.
func (caa CustomAssessmentAutomation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if caa.CustomAssessmentAutomationProperties != nil {
		objectMap["properties"] = caa.CustomAssessmentAutomationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CustomAssessmentAutomation struct.
func (caa *CustomAssessmentAutomation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				caa.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var customAssessmentAutomationProperties CustomAssessmentAutomationProperties
				err = json.Unmarshal(*v, &customAssessmentAutomationProperties)
				if err != nil {
					return err
				}
				caa.CustomAssessmentAutomationProperties = &customAssessmentAutomationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				caa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				caa.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				caa.Type = &typeVar
			}
		}
	}

	return nil
}

// CustomAssessmentAutomationProperties describes the Custom Assessment Automation properties
type CustomAssessmentAutomationProperties struct {
	// CompressedQuery - GZip encoded KQL query representing the assessment automation results required.
	CompressedQuery *string `json:"compressedQuery,omitempty"`
	// SupportedCloud - Relevant cloud for the custom assessment automation. Possible values include: 'SupportedCloudEnumAWS', 'SupportedCloudEnumGCP'
	SupportedCloud SupportedCloudEnum `json:"supportedCloud,omitempty"`
	// Severity - The severity to relate to the assessments generated by this assessment automation. Possible values include: 'SeverityEnumHigh', 'SeverityEnumMedium', 'SeverityEnumLow'
	Severity SeverityEnum `json:"severity,omitempty"`
	// DisplayName - The display name of the assessments generated by this assessment automation.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - The description to relate to the assessments generated by this assessment automation.
	Description *string `json:"description,omitempty"`
	// RemediationDescription - The remediation description to relate to the assessments generated by this assessment automation.
	RemediationDescription *string `json:"remediationDescription,omitempty"`
	// AssessmentKey - The assessment metadata key used when an assessment is generated for this assessment automation.
	AssessmentKey *string `json:"assessmentKey,omitempty"`
}

// CustomAssessmentAutomationRequest custom Assessment Automation request
type CustomAssessmentAutomationRequest struct {
	// CustomAssessmentAutomationRequestProperties - describes Custom Assessment Automation request properties.
	*CustomAssessmentAutomationRequestProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomAssessmentAutomationRequest.
func (caar CustomAssessmentAutomationRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if caar.CustomAssessmentAutomationRequestProperties != nil {
		objectMap["properties"] = caar.CustomAssessmentAutomationRequestProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CustomAssessmentAutomationRequest struct.
func (caar *CustomAssessmentAutomationRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var customAssessmentAutomationRequestProperties CustomAssessmentAutomationRequestProperties
				err = json.Unmarshal(*v, &customAssessmentAutomationRequestProperties)
				if err != nil {
					return err
				}
				caar.CustomAssessmentAutomationRequestProperties = &customAssessmentAutomationRequestProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				caar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				caar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				caar.Type = &typeVar
			}
		}
	}

	return nil
}

// CustomAssessmentAutomationRequestProperties describes the Custom Assessment Automation properties
type CustomAssessmentAutomationRequestProperties struct {
	// CompressedQuery - Base 64 encoded KQL query representing the assessment automation results required.
	CompressedQuery *string `json:"compressedQuery,omitempty"`
	// SupportedCloud - Relevant cloud for the custom assessment automation. Possible values include: 'SupportedCloudEnumAWS', 'SupportedCloudEnumGCP'
	SupportedCloud SupportedCloudEnum `json:"supportedCloud,omitempty"`
	// Severity - The severity to relate to the assessments generated by this assessment automation. Possible values include: 'SeverityEnumHigh', 'SeverityEnumMedium', 'SeverityEnumLow'
	Severity SeverityEnum `json:"severity,omitempty"`
	// DisplayName - The display name of the assessments generated by this assessment automation.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - The description to relate to the assessments generated by this assessment automation.
	Description *string `json:"description,omitempty"`
	// RemediationDescription - The remediation description to relate to the assessments generated by this assessment automation.
	RemediationDescription *string `json:"remediationDescription,omitempty"`
}

// CustomAssessmentAutomationsListResult a list of Custom Assessment Automations
type CustomAssessmentAutomationsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Collection of Custom Assessment Automations
	Value *[]CustomAssessmentAutomation `json:"value,omitempty"`
	// NextLink - The link used to get the next page of operations.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomAssessmentAutomationsListResult.
func (caalr CustomAssessmentAutomationsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if caalr.NextLink != nil {
		objectMap["nextLink"] = caalr.NextLink
	}
	return json.Marshal(objectMap)
}

// CustomAssessmentAutomationsListResultIterator provides access to a complete listing of
// CustomAssessmentAutomation values.
type CustomAssessmentAutomationsListResultIterator struct {
	i    int
	page CustomAssessmentAutomationsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CustomAssessmentAutomationsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CustomAssessmentAutomationsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CustomAssessmentAutomationsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CustomAssessmentAutomationsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CustomAssessmentAutomationsListResultIterator) Response() CustomAssessmentAutomationsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CustomAssessmentAutomationsListResultIterator) Value() CustomAssessmentAutomation {
	if !iter.page.NotDone() {
		return CustomAssessmentAutomation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CustomAssessmentAutomationsListResultIterator type.
func NewCustomAssessmentAutomationsListResultIterator(page CustomAssessmentAutomationsListResultPage) CustomAssessmentAutomationsListResultIterator {
	return CustomAssessmentAutomationsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (caalr CustomAssessmentAutomationsListResult) IsEmpty() bool {
	return caalr.Value == nil || len(*caalr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (caalr CustomAssessmentAutomationsListResult) hasNextLink() bool {
	return caalr.NextLink != nil && len(*caalr.NextLink) != 0
}

// customAssessmentAutomationsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (caalr CustomAssessmentAutomationsListResult) customAssessmentAutomationsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !caalr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(caalr.NextLink)))
}

// CustomAssessmentAutomationsListResultPage contains a page of CustomAssessmentAutomation values.
type CustomAssessmentAutomationsListResultPage struct {
	fn    func(context.Context, CustomAssessmentAutomationsListResult) (CustomAssessmentAutomationsListResult, error)
	caalr CustomAssessmentAutomationsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CustomAssessmentAutomationsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CustomAssessmentAutomationsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.caalr)
		if err != nil {
			return err
		}
		page.caalr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CustomAssessmentAutomationsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CustomAssessmentAutomationsListResultPage) NotDone() bool {
	return !page.caalr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CustomAssessmentAutomationsListResultPage) Response() CustomAssessmentAutomationsListResult {
	return page.caalr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CustomAssessmentAutomationsListResultPage) Values() []CustomAssessmentAutomation {
	if page.caalr.IsEmpty() {
		return nil
	}
	return *page.caalr.Value
}

// Creates a new instance of the CustomAssessmentAutomationsListResultPage type.
func NewCustomAssessmentAutomationsListResultPage(cur CustomAssessmentAutomationsListResult, getNextPage func(context.Context, CustomAssessmentAutomationsListResult) (CustomAssessmentAutomationsListResult, error)) CustomAssessmentAutomationsListResultPage {
	return CustomAssessmentAutomationsListResultPage{
		fn:    getNextPage,
		caalr: cur,
	}
}

// CustomEntityStoreAssignment custom entity store assignment
type CustomEntityStoreAssignment struct {
	autorest.Response `json:"-"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
	// CustomEntityStoreAssignmentProperties - describes custom entity store assignment properties.
	*CustomEntityStoreAssignmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomEntityStoreAssignment.
func (cesa CustomEntityStoreAssignment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cesa.CustomEntityStoreAssignmentProperties != nil {
		objectMap["properties"] = cesa.CustomEntityStoreAssignmentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CustomEntityStoreAssignment struct.
func (cesa *CustomEntityStoreAssignment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				cesa.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var customEntityStoreAssignmentProperties CustomEntityStoreAssignmentProperties
				err = json.Unmarshal(*v, &customEntityStoreAssignmentProperties)
				if err != nil {
					return err
				}
				cesa.CustomEntityStoreAssignmentProperties = &customEntityStoreAssignmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cesa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cesa.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cesa.Type = &typeVar
			}
		}
	}

	return nil
}

// CustomEntityStoreAssignmentProperties describes the custom entity store assignment properties
type CustomEntityStoreAssignmentProperties struct {
	// Principal - The principal assigned with entity store. Format of principal is: [AAD type]=[PrincipalObjectId];[TenantId]
	Principal *string `json:"principal,omitempty"`
	// EntityStoreDatabaseLink - The link to entity store database.
	EntityStoreDatabaseLink *string `json:"entityStoreDatabaseLink,omitempty"`
}

// CustomEntityStoreAssignmentRequest describes the custom entity store assignment request
type CustomEntityStoreAssignmentRequest struct {
	*CustomEntityStoreAssignmentRequestProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomEntityStoreAssignmentRequest.
func (cesar CustomEntityStoreAssignmentRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cesar.CustomEntityStoreAssignmentRequestProperties != nil {
		objectMap["properties"] = cesar.CustomEntityStoreAssignmentRequestProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CustomEntityStoreAssignmentRequest struct.
func (cesar *CustomEntityStoreAssignmentRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var customEntityStoreAssignmentRequestProperties CustomEntityStoreAssignmentRequestProperties
				err = json.Unmarshal(*v, &customEntityStoreAssignmentRequestProperties)
				if err != nil {
					return err
				}
				cesar.CustomEntityStoreAssignmentRequestProperties = &customEntityStoreAssignmentRequestProperties
			}
		}
	}

	return nil
}

// CustomEntityStoreAssignmentRequestProperties describes properties of custom entity store assignment
// request
type CustomEntityStoreAssignmentRequestProperties struct {
	// Principal - The principal assigned with entity store. If not provided, will use caller principal. Format of principal is: [AAD type]=[PrincipalObjectId];[TenantId]
	Principal *string `json:"principal,omitempty"`
}

// CustomEntityStoreAssignmentsListResult a list of custom entity store assignments
type CustomEntityStoreAssignmentsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Collection of custom entity store assignments
	Value *[]CustomEntityStoreAssignment `json:"value,omitempty"`
	// NextLink - The link used to get the next page of operations.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomEntityStoreAssignmentsListResult.
func (cesalr CustomEntityStoreAssignmentsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cesalr.NextLink != nil {
		objectMap["nextLink"] = cesalr.NextLink
	}
	return json.Marshal(objectMap)
}

// CustomEntityStoreAssignmentsListResultIterator provides access to a complete listing of
// CustomEntityStoreAssignment values.
type CustomEntityStoreAssignmentsListResultIterator struct {
	i    int
	page CustomEntityStoreAssignmentsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CustomEntityStoreAssignmentsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CustomEntityStoreAssignmentsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CustomEntityStoreAssignmentsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CustomEntityStoreAssignmentsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CustomEntityStoreAssignmentsListResultIterator) Response() CustomEntityStoreAssignmentsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CustomEntityStoreAssignmentsListResultIterator) Value() CustomEntityStoreAssignment {
	if !iter.page.NotDone() {
		return CustomEntityStoreAssignment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CustomEntityStoreAssignmentsListResultIterator type.
func NewCustomEntityStoreAssignmentsListResultIterator(page CustomEntityStoreAssignmentsListResultPage) CustomEntityStoreAssignmentsListResultIterator {
	return CustomEntityStoreAssignmentsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cesalr CustomEntityStoreAssignmentsListResult) IsEmpty() bool {
	return cesalr.Value == nil || len(*cesalr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cesalr CustomEntityStoreAssignmentsListResult) hasNextLink() bool {
	return cesalr.NextLink != nil && len(*cesalr.NextLink) != 0
}

// customEntityStoreAssignmentsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cesalr CustomEntityStoreAssignmentsListResult) customEntityStoreAssignmentsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !cesalr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cesalr.NextLink)))
}

// CustomEntityStoreAssignmentsListResultPage contains a page of CustomEntityStoreAssignment values.
type CustomEntityStoreAssignmentsListResultPage struct {
	fn     func(context.Context, CustomEntityStoreAssignmentsListResult) (CustomEntityStoreAssignmentsListResult, error)
	cesalr CustomEntityStoreAssignmentsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CustomEntityStoreAssignmentsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CustomEntityStoreAssignmentsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cesalr)
		if err != nil {
			return err
		}
		page.cesalr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CustomEntityStoreAssignmentsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CustomEntityStoreAssignmentsListResultPage) NotDone() bool {
	return !page.cesalr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CustomEntityStoreAssignmentsListResultPage) Response() CustomEntityStoreAssignmentsListResult {
	return page.cesalr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CustomEntityStoreAssignmentsListResultPage) Values() []CustomEntityStoreAssignment {
	if page.cesalr.IsEmpty() {
		return nil
	}
	return *page.cesalr.Value
}

// Creates a new instance of the CustomEntityStoreAssignmentsListResultPage type.
func NewCustomEntityStoreAssignmentsListResultPage(cur CustomEntityStoreAssignmentsListResult, getNextPage func(context.Context, CustomEntityStoreAssignmentsListResult) (CustomEntityStoreAssignmentsListResult, error)) CustomEntityStoreAssignmentsListResultPage {
	return CustomEntityStoreAssignmentsListResultPage{
		fn:     getNextPage,
		cesalr: cur,
	}
}

// CVE CVE details
type CVE struct {
	// Title - READ-ONLY; CVE title
	Title *string `json:"title,omitempty"`
	// Link - READ-ONLY; Link url
	Link *string `json:"link,omitempty"`
}

// MarshalJSON is the custom marshaler for CVE.
func (c CVE) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CVSS CVSS details
type CVSS struct {
	// Base - READ-ONLY; CVSS base
	Base *float64 `json:"base,omitempty"`
}

// MarshalJSON is the custom marshaler for CVSS.
func (c CVSS) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DataExportSettingProperties the data export setting properties
type DataExportSettingProperties struct {
	// Enabled - Is the data export setting enabled
	Enabled *bool `json:"enabled,omitempty"`
}

// DataExportSettings represents a data export setting
type DataExportSettings struct {
	// DataExportSettingProperties - Data export setting data
	*DataExportSettingProperties `json:"properties,omitempty"`
	// Kind - Possible values include: 'KindSetting', 'KindDataExportSettings', 'KindAlertSyncSettings'
	Kind KindEnum2 `json:"kind,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DataExportSettings.
func (desVar DataExportSettings) MarshalJSON() ([]byte, error) {
	desVar.Kind = KindDataExportSettings
	objectMap := make(map[string]interface{})
	if desVar.DataExportSettingProperties != nil {
		objectMap["properties"] = desVar.DataExportSettingProperties
	}
	if desVar.Kind != "" {
		objectMap["kind"] = desVar.Kind
	}
	return json.Marshal(objectMap)
}

// AsDataExportSettings is the BasicSetting implementation for DataExportSettings.
func (desVar DataExportSettings) AsDataExportSettings() (*DataExportSettings, bool) {
	return &desVar, true
}

// AsAlertSyncSettings is the BasicSetting implementation for DataExportSettings.
func (desVar DataExportSettings) AsAlertSyncSettings() (*AlertSyncSettings, bool) {
	return nil, false
}

// AsSetting is the BasicSetting implementation for DataExportSettings.
func (desVar DataExportSettings) AsSetting() (*Setting, bool) {
	return nil, false
}

// AsBasicSetting is the BasicSetting implementation for DataExportSettings.
func (desVar DataExportSettings) AsBasicSetting() (BasicSetting, bool) {
	return &desVar, true
}

// UnmarshalJSON is the custom unmarshaler for DataExportSettings struct.
func (desVar *DataExportSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dataExportSettingProperties DataExportSettingProperties
				err = json.Unmarshal(*v, &dataExportSettingProperties)
				if err != nil {
					return err
				}
				desVar.DataExportSettingProperties = &dataExportSettingProperties
			}
		case "kind":
			if v != nil {
				var kind KindEnum2
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				desVar.Kind = kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				desVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				desVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				desVar.Type = &typeVar
			}
		}
	}

	return nil
}

// DefenderCspmAwsOffering the CSPM P1 for Aws offering
type DefenderCspmAwsOffering struct {
	// VMScanners - The Microsoft Defender for Server VM scanning configuration
	VMScanners *DefenderCspmAwsOfferingVMScanners `json:"vmScanners,omitempty"`
	// Description - READ-ONLY; The offering description.
	Description *string `json:"description,omitempty"`
	// OfferingType - Possible values include: 'OfferingTypeCloudOffering', 'OfferingTypeCspmMonitorAws', 'OfferingTypeDefenderForContainersAws', 'OfferingTypeDefenderForServersAws', 'OfferingTypeDefenderForDatabasesAws', 'OfferingTypeInformationProtectionAws', 'OfferingTypeCspmMonitorGcp', 'OfferingTypeDefenderForServersGcp', 'OfferingTypeDefenderForDatabasesGcp', 'OfferingTypeDefenderForContainersGcp', 'OfferingTypeCspmMonitorGithub', 'OfferingTypeCspmMonitorAzureDevOps', 'OfferingTypeDefenderCspmAws', 'OfferingTypeDefenderCspmGcp', 'OfferingTypeDefenderForDevOpsGithub', 'OfferingTypeDefenderForDevOpsAzureDevOps'
	OfferingType OfferingType `json:"offeringType,omitempty"`
}

// MarshalJSON is the custom marshaler for DefenderCspmAwsOffering.
func (dcao DefenderCspmAwsOffering) MarshalJSON() ([]byte, error) {
	dcao.OfferingType = OfferingTypeDefenderCspmAws
	objectMap := make(map[string]interface{})
	if dcao.VMScanners != nil {
		objectMap["vmScanners"] = dcao.VMScanners
	}
	if dcao.OfferingType != "" {
		objectMap["offeringType"] = dcao.OfferingType
	}
	return json.Marshal(objectMap)
}

// AsCspmMonitorAwsOffering is the BasicCloudOffering implementation for DefenderCspmAwsOffering.
func (dcao DefenderCspmAwsOffering) AsCspmMonitorAwsOffering() (*CspmMonitorAwsOffering, bool) {
	return nil, false
}

// AsDefenderForContainersAwsOffering is the BasicCloudOffering implementation for DefenderCspmAwsOffering.
func (dcao DefenderCspmAwsOffering) AsDefenderForContainersAwsOffering() (*DefenderForContainersAwsOffering, bool) {
	return nil, false
}

// AsDefenderForServersAwsOffering is the BasicCloudOffering implementation for DefenderCspmAwsOffering.
func (dcao DefenderCspmAwsOffering) AsDefenderForServersAwsOffering() (*DefenderForServersAwsOffering, bool) {
	return nil, false
}

// AsDefenderFoDatabasesAwsOffering is the BasicCloudOffering implementation for DefenderCspmAwsOffering.
func (dcao DefenderCspmAwsOffering) AsDefenderFoDatabasesAwsOffering() (*DefenderFoDatabasesAwsOffering, bool) {
	return nil, false
}

// AsInformationProtectionAwsOffering is the BasicCloudOffering implementation for DefenderCspmAwsOffering.
func (dcao DefenderCspmAwsOffering) AsInformationProtectionAwsOffering() (*InformationProtectionAwsOffering, bool) {
	return nil, false
}

// AsCspmMonitorGcpOffering is the BasicCloudOffering implementation for DefenderCspmAwsOffering.
func (dcao DefenderCspmAwsOffering) AsCspmMonitorGcpOffering() (*CspmMonitorGcpOffering, bool) {
	return nil, false
}

// AsDefenderForServersGcpOffering is the BasicCloudOffering implementation for DefenderCspmAwsOffering.
func (dcao DefenderCspmAwsOffering) AsDefenderForServersGcpOffering() (*DefenderForServersGcpOffering, bool) {
	return nil, false
}

// AsDefenderForDatabasesGcpOffering is the BasicCloudOffering implementation for DefenderCspmAwsOffering.
func (dcao DefenderCspmAwsOffering) AsDefenderForDatabasesGcpOffering() (*DefenderForDatabasesGcpOffering, bool) {
	return nil, false
}

// AsDefenderForContainersGcpOffering is the BasicCloudOffering implementation for DefenderCspmAwsOffering.
func (dcao DefenderCspmAwsOffering) AsDefenderForContainersGcpOffering() (*DefenderForContainersGcpOffering, bool) {
	return nil, false
}

// AsCspmMonitorGithubOffering is the BasicCloudOffering implementation for DefenderCspmAwsOffering.
func (dcao DefenderCspmAwsOffering) AsCspmMonitorGithubOffering() (*CspmMonitorGithubOffering, bool) {
	return nil, false
}

// AsCspmMonitorAzureDevOpsOffering is the BasicCloudOffering implementation for DefenderCspmAwsOffering.
func (dcao DefenderCspmAwsOffering) AsCspmMonitorAzureDevOpsOffering() (*CspmMonitorAzureDevOpsOffering, bool) {
	return nil, false
}

// AsDefenderCspmAwsOffering is the BasicCloudOffering implementation for DefenderCspmAwsOffering.
func (dcao DefenderCspmAwsOffering) AsDefenderCspmAwsOffering() (*DefenderCspmAwsOffering, bool) {
	return &dcao, true
}

// AsDefenderCspmGcpOffering is the BasicCloudOffering implementation for DefenderCspmAwsOffering.
func (dcao DefenderCspmAwsOffering) AsDefenderCspmGcpOffering() (*DefenderCspmGcpOffering, bool) {
	return nil, false
}

// AsDefenderForDevOpsGithubOffering is the BasicCloudOffering implementation for DefenderCspmAwsOffering.
func (dcao DefenderCspmAwsOffering) AsDefenderForDevOpsGithubOffering() (*DefenderForDevOpsGithubOffering, bool) {
	return nil, false
}

// AsDefenderForDevOpsAzureDevOpsOffering is the BasicCloudOffering implementation for DefenderCspmAwsOffering.
func (dcao DefenderCspmAwsOffering) AsDefenderForDevOpsAzureDevOpsOffering() (*DefenderForDevOpsAzureDevOpsOffering, bool) {
	return nil, false
}

// AsCloudOffering is the BasicCloudOffering implementation for DefenderCspmAwsOffering.
func (dcao DefenderCspmAwsOffering) AsCloudOffering() (*CloudOffering, bool) {
	return nil, false
}

// AsBasicCloudOffering is the BasicCloudOffering implementation for DefenderCspmAwsOffering.
func (dcao DefenderCspmAwsOffering) AsBasicCloudOffering() (BasicCloudOffering, bool) {
	return &dcao, true
}

// DefenderCspmAwsOfferingVMScanners the Microsoft Defender for Server VM scanning configuration
type DefenderCspmAwsOfferingVMScanners struct {
	// Enabled - Is Microsoft Defender for Server VM scanning enabled
	Enabled *bool `json:"enabled,omitempty"`
	// Configuration - configuration for Microsoft Defender for Server VM scanning
	Configuration *DefenderCspmAwsOfferingVMScannersConfiguration `json:"configuration,omitempty"`
}

// DefenderCspmAwsOfferingVMScannersConfiguration configuration for Microsoft Defender for Server VM
// scanning
type DefenderCspmAwsOfferingVMScannersConfiguration struct {
	// CloudRoleArn - The cloud role ARN in AWS for this feature
	CloudRoleArn *string `json:"cloudRoleArn,omitempty"`
	// ScanningMode - The scanning mode for the vm scan. Possible values include: 'Default'
	ScanningMode ScanningMode `json:"scanningMode,omitempty"`
	// ExclusionTags - VM tags that indicates that VM should not be scanned
	ExclusionTags map[string]*string `json:"exclusionTags"`
}

// MarshalJSON is the custom marshaler for DefenderCspmAwsOfferingVMScannersConfiguration.
func (dcaoS DefenderCspmAwsOfferingVMScannersConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dcaoS.CloudRoleArn != nil {
		objectMap["cloudRoleArn"] = dcaoS.CloudRoleArn
	}
	if dcaoS.ScanningMode != "" {
		objectMap["scanningMode"] = dcaoS.ScanningMode
	}
	if dcaoS.ExclusionTags != nil {
		objectMap["exclusionTags"] = dcaoS.ExclusionTags
	}
	return json.Marshal(objectMap)
}

// DefenderCspmGcpOffering the CSPM P1 for GCP offering
type DefenderCspmGcpOffering struct {
	// Description - READ-ONLY; The offering description.
	Description *string `json:"description,omitempty"`
	// OfferingType - Possible values include: 'OfferingTypeCloudOffering', 'OfferingTypeCspmMonitorAws', 'OfferingTypeDefenderForContainersAws', 'OfferingTypeDefenderForServersAws', 'OfferingTypeDefenderForDatabasesAws', 'OfferingTypeInformationProtectionAws', 'OfferingTypeCspmMonitorGcp', 'OfferingTypeDefenderForServersGcp', 'OfferingTypeDefenderForDatabasesGcp', 'OfferingTypeDefenderForContainersGcp', 'OfferingTypeCspmMonitorGithub', 'OfferingTypeCspmMonitorAzureDevOps', 'OfferingTypeDefenderCspmAws', 'OfferingTypeDefenderCspmGcp', 'OfferingTypeDefenderForDevOpsGithub', 'OfferingTypeDefenderForDevOpsAzureDevOps'
	OfferingType OfferingType `json:"offeringType,omitempty"`
}

// MarshalJSON is the custom marshaler for DefenderCspmGcpOffering.
func (dcgo DefenderCspmGcpOffering) MarshalJSON() ([]byte, error) {
	dcgo.OfferingType = OfferingTypeDefenderCspmGcp
	objectMap := make(map[string]interface{})
	if dcgo.OfferingType != "" {
		objectMap["offeringType"] = dcgo.OfferingType
	}
	return json.Marshal(objectMap)
}

// AsCspmMonitorAwsOffering is the BasicCloudOffering implementation for DefenderCspmGcpOffering.
func (dcgo DefenderCspmGcpOffering) AsCspmMonitorAwsOffering() (*CspmMonitorAwsOffering, bool) {
	return nil, false
}

// AsDefenderForContainersAwsOffering is the BasicCloudOffering implementation for DefenderCspmGcpOffering.
func (dcgo DefenderCspmGcpOffering) AsDefenderForContainersAwsOffering() (*DefenderForContainersAwsOffering, bool) {
	return nil, false
}

// AsDefenderForServersAwsOffering is the BasicCloudOffering implementation for DefenderCspmGcpOffering.
func (dcgo DefenderCspmGcpOffering) AsDefenderForServersAwsOffering() (*DefenderForServersAwsOffering, bool) {
	return nil, false
}

// AsDefenderFoDatabasesAwsOffering is the BasicCloudOffering implementation for DefenderCspmGcpOffering.
func (dcgo DefenderCspmGcpOffering) AsDefenderFoDatabasesAwsOffering() (*DefenderFoDatabasesAwsOffering, bool) {
	return nil, false
}

// AsInformationProtectionAwsOffering is the BasicCloudOffering implementation for DefenderCspmGcpOffering.
func (dcgo DefenderCspmGcpOffering) AsInformationProtectionAwsOffering() (*InformationProtectionAwsOffering, bool) {
	return nil, false
}

// AsCspmMonitorGcpOffering is the BasicCloudOffering implementation for DefenderCspmGcpOffering.
func (dcgo DefenderCspmGcpOffering) AsCspmMonitorGcpOffering() (*CspmMonitorGcpOffering, bool) {
	return nil, false
}

// AsDefenderForServersGcpOffering is the BasicCloudOffering implementation for DefenderCspmGcpOffering.
func (dcgo DefenderCspmGcpOffering) AsDefenderForServersGcpOffering() (*DefenderForServersGcpOffering, bool) {
	return nil, false
}

// AsDefenderForDatabasesGcpOffering is the BasicCloudOffering implementation for DefenderCspmGcpOffering.
func (dcgo DefenderCspmGcpOffering) AsDefenderForDatabasesGcpOffering() (*DefenderForDatabasesGcpOffering, bool) {
	return nil, false
}

// AsDefenderForContainersGcpOffering is the BasicCloudOffering implementation for DefenderCspmGcpOffering.
func (dcgo DefenderCspmGcpOffering) AsDefenderForContainersGcpOffering() (*DefenderForContainersGcpOffering, bool) {
	return nil, false
}

// AsCspmMonitorGithubOffering is the BasicCloudOffering implementation for DefenderCspmGcpOffering.
func (dcgo DefenderCspmGcpOffering) AsCspmMonitorGithubOffering() (*CspmMonitorGithubOffering, bool) {
	return nil, false
}

// AsCspmMonitorAzureDevOpsOffering is the BasicCloudOffering implementation for DefenderCspmGcpOffering.
func (dcgo DefenderCspmGcpOffering) AsCspmMonitorAzureDevOpsOffering() (*CspmMonitorAzureDevOpsOffering, bool) {
	return nil, false
}

// AsDefenderCspmAwsOffering is the BasicCloudOffering implementation for DefenderCspmGcpOffering.
func (dcgo DefenderCspmGcpOffering) AsDefenderCspmAwsOffering() (*DefenderCspmAwsOffering, bool) {
	return nil, false
}

// AsDefenderCspmGcpOffering is the BasicCloudOffering implementation for DefenderCspmGcpOffering.
func (dcgo DefenderCspmGcpOffering) AsDefenderCspmGcpOffering() (*DefenderCspmGcpOffering, bool) {
	return &dcgo, true
}

// AsDefenderForDevOpsGithubOffering is the BasicCloudOffering implementation for DefenderCspmGcpOffering.
func (dcgo DefenderCspmGcpOffering) AsDefenderForDevOpsGithubOffering() (*DefenderForDevOpsGithubOffering, bool) {
	return nil, false
}

// AsDefenderForDevOpsAzureDevOpsOffering is the BasicCloudOffering implementation for DefenderCspmGcpOffering.
func (dcgo DefenderCspmGcpOffering) AsDefenderForDevOpsAzureDevOpsOffering() (*DefenderForDevOpsAzureDevOpsOffering, bool) {
	return nil, false
}

// AsCloudOffering is the BasicCloudOffering implementation for DefenderCspmGcpOffering.
func (dcgo DefenderCspmGcpOffering) AsCloudOffering() (*CloudOffering, bool) {
	return nil, false
}

// AsBasicCloudOffering is the BasicCloudOffering implementation for DefenderCspmGcpOffering.
func (dcgo DefenderCspmGcpOffering) AsBasicCloudOffering() (BasicCloudOffering, bool) {
	return &dcgo, true
}

// DefenderFoDatabasesAwsOffering the Defender for Databases AWS offering
type DefenderFoDatabasesAwsOffering struct {
	// ArcAutoProvisioning - The ARC autoprovisioning configuration
	ArcAutoProvisioning *DefenderFoDatabasesAwsOfferingArcAutoProvisioning `json:"arcAutoProvisioning,omitempty"`
	// Rds - The RDS configuration
	Rds *DefenderFoDatabasesAwsOfferingRds `json:"rds,omitempty"`
	// Description - READ-ONLY; The offering description.
	Description *string `json:"description,omitempty"`
	// OfferingType - Possible values include: 'OfferingTypeCloudOffering', 'OfferingTypeCspmMonitorAws', 'OfferingTypeDefenderForContainersAws', 'OfferingTypeDefenderForServersAws', 'OfferingTypeDefenderForDatabasesAws', 'OfferingTypeInformationProtectionAws', 'OfferingTypeCspmMonitorGcp', 'OfferingTypeDefenderForServersGcp', 'OfferingTypeDefenderForDatabasesGcp', 'OfferingTypeDefenderForContainersGcp', 'OfferingTypeCspmMonitorGithub', 'OfferingTypeCspmMonitorAzureDevOps', 'OfferingTypeDefenderCspmAws', 'OfferingTypeDefenderCspmGcp', 'OfferingTypeDefenderForDevOpsGithub', 'OfferingTypeDefenderForDevOpsAzureDevOps'
	OfferingType OfferingType `json:"offeringType,omitempty"`
}

// MarshalJSON is the custom marshaler for DefenderFoDatabasesAwsOffering.
func (dfdao DefenderFoDatabasesAwsOffering) MarshalJSON() ([]byte, error) {
	dfdao.OfferingType = OfferingTypeDefenderForDatabasesAws
	objectMap := make(map[string]interface{})
	if dfdao.ArcAutoProvisioning != nil {
		objectMap["arcAutoProvisioning"] = dfdao.ArcAutoProvisioning
	}
	if dfdao.Rds != nil {
		objectMap["rds"] = dfdao.Rds
	}
	if dfdao.OfferingType != "" {
		objectMap["offeringType"] = dfdao.OfferingType
	}
	return json.Marshal(objectMap)
}

// AsCspmMonitorAwsOffering is the BasicCloudOffering implementation for DefenderFoDatabasesAwsOffering.
func (dfdao DefenderFoDatabasesAwsOffering) AsCspmMonitorAwsOffering() (*CspmMonitorAwsOffering, bool) {
	return nil, false
}

// AsDefenderForContainersAwsOffering is the BasicCloudOffering implementation for DefenderFoDatabasesAwsOffering.
func (dfdao DefenderFoDatabasesAwsOffering) AsDefenderForContainersAwsOffering() (*DefenderForContainersAwsOffering, bool) {
	return nil, false
}

// AsDefenderForServersAwsOffering is the BasicCloudOffering implementation for DefenderFoDatabasesAwsOffering.
func (dfdao DefenderFoDatabasesAwsOffering) AsDefenderForServersAwsOffering() (*DefenderForServersAwsOffering, bool) {
	return nil, false
}

// AsDefenderFoDatabasesAwsOffering is the BasicCloudOffering implementation for DefenderFoDatabasesAwsOffering.
func (dfdao DefenderFoDatabasesAwsOffering) AsDefenderFoDatabasesAwsOffering() (*DefenderFoDatabasesAwsOffering, bool) {
	return &dfdao, true
}

// AsInformationProtectionAwsOffering is the BasicCloudOffering implementation for DefenderFoDatabasesAwsOffering.
func (dfdao DefenderFoDatabasesAwsOffering) AsInformationProtectionAwsOffering() (*InformationProtectionAwsOffering, bool) {
	return nil, false
}

// AsCspmMonitorGcpOffering is the BasicCloudOffering implementation for DefenderFoDatabasesAwsOffering.
func (dfdao DefenderFoDatabasesAwsOffering) AsCspmMonitorGcpOffering() (*CspmMonitorGcpOffering, bool) {
	return nil, false
}

// AsDefenderForServersGcpOffering is the BasicCloudOffering implementation for DefenderFoDatabasesAwsOffering.
func (dfdao DefenderFoDatabasesAwsOffering) AsDefenderForServersGcpOffering() (*DefenderForServersGcpOffering, bool) {
	return nil, false
}

// AsDefenderForDatabasesGcpOffering is the BasicCloudOffering implementation for DefenderFoDatabasesAwsOffering.
func (dfdao DefenderFoDatabasesAwsOffering) AsDefenderForDatabasesGcpOffering() (*DefenderForDatabasesGcpOffering, bool) {
	return nil, false
}

// AsDefenderForContainersGcpOffering is the BasicCloudOffering implementation for DefenderFoDatabasesAwsOffering.
func (dfdao DefenderFoDatabasesAwsOffering) AsDefenderForContainersGcpOffering() (*DefenderForContainersGcpOffering, bool) {
	return nil, false
}

// AsCspmMonitorGithubOffering is the BasicCloudOffering implementation for DefenderFoDatabasesAwsOffering.
func (dfdao DefenderFoDatabasesAwsOffering) AsCspmMonitorGithubOffering() (*CspmMonitorGithubOffering, bool) {
	return nil, false
}

// AsCspmMonitorAzureDevOpsOffering is the BasicCloudOffering implementation for DefenderFoDatabasesAwsOffering.
func (dfdao DefenderFoDatabasesAwsOffering) AsCspmMonitorAzureDevOpsOffering() (*CspmMonitorAzureDevOpsOffering, bool) {
	return nil, false
}

// AsDefenderCspmAwsOffering is the BasicCloudOffering implementation for DefenderFoDatabasesAwsOffering.
func (dfdao DefenderFoDatabasesAwsOffering) AsDefenderCspmAwsOffering() (*DefenderCspmAwsOffering, bool) {
	return nil, false
}

// AsDefenderCspmGcpOffering is the BasicCloudOffering implementation for DefenderFoDatabasesAwsOffering.
func (dfdao DefenderFoDatabasesAwsOffering) AsDefenderCspmGcpOffering() (*DefenderCspmGcpOffering, bool) {
	return nil, false
}

// AsDefenderForDevOpsGithubOffering is the BasicCloudOffering implementation for DefenderFoDatabasesAwsOffering.
func (dfdao DefenderFoDatabasesAwsOffering) AsDefenderForDevOpsGithubOffering() (*DefenderForDevOpsGithubOffering, bool) {
	return nil, false
}

// AsDefenderForDevOpsAzureDevOpsOffering is the BasicCloudOffering implementation for DefenderFoDatabasesAwsOffering.
func (dfdao DefenderFoDatabasesAwsOffering) AsDefenderForDevOpsAzureDevOpsOffering() (*DefenderForDevOpsAzureDevOpsOffering, bool) {
	return nil, false
}

// AsCloudOffering is the BasicCloudOffering implementation for DefenderFoDatabasesAwsOffering.
func (dfdao DefenderFoDatabasesAwsOffering) AsCloudOffering() (*CloudOffering, bool) {
	return nil, false
}

// AsBasicCloudOffering is the BasicCloudOffering implementation for DefenderFoDatabasesAwsOffering.
func (dfdao DefenderFoDatabasesAwsOffering) AsBasicCloudOffering() (BasicCloudOffering, bool) {
	return &dfdao, true
}

// DefenderFoDatabasesAwsOfferingArcAutoProvisioning the ARC autoprovisioning configuration
type DefenderFoDatabasesAwsOfferingArcAutoProvisioning struct {
	// Enabled - Is arc auto provisioning enabled
	Enabled *bool `json:"enabled,omitempty"`
	// CloudRoleArn - The cloud role ARN in AWS for this feature
	CloudRoleArn *string `json:"cloudRoleArn,omitempty"`
}

// DefenderFoDatabasesAwsOfferingRds the RDS configuration
type DefenderFoDatabasesAwsOfferingRds struct {
	// Enabled - Is RDS protection enabled
	Enabled *bool `json:"enabled,omitempty"`
	// CloudRoleArn - The cloud role ARN in AWS for this feature
	CloudRoleArn *string `json:"cloudRoleArn,omitempty"`
}

// DefenderForContainersAwsOffering the Defender for Containers AWS offering
type DefenderForContainersAwsOffering struct {
	// KubernetesService - The kubernetes service connection configuration
	KubernetesService *DefenderForContainersAwsOfferingKubernetesService `json:"kubernetesService,omitempty"`
	// KubernetesScubaReader - The kubernetes to scuba connection configuration
	KubernetesScubaReader *DefenderForContainersAwsOfferingKubernetesScubaReader `json:"kubernetesScubaReader,omitempty"`
	// CloudWatchToKinesis - The cloudwatch to kinesis connection configuration
	CloudWatchToKinesis *DefenderForContainersAwsOfferingCloudWatchToKinesis `json:"cloudWatchToKinesis,omitempty"`
	// KinesisToS3 - The kinesis to s3 connection configuration
	KinesisToS3 *DefenderForContainersAwsOfferingKinesisToS3 `json:"kinesisToS3,omitempty"`
	// ContainerVulnerabilityAssessment - The container vulnerability assessment configuration
	ContainerVulnerabilityAssessment *DefenderForContainersAwsOfferingContainerVulnerabilityAssessment `json:"containerVulnerabilityAssessment,omitempty"`
	// ContainerVulnerabilityAssessmentTask - The container vulnerability assessment task configuration
	ContainerVulnerabilityAssessmentTask *DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentTask `json:"containerVulnerabilityAssessmentTask,omitempty"`
	// EnableContainerVulnerabilityAssessment - Enable container vulnerability assessment feature
	EnableContainerVulnerabilityAssessment *bool `json:"enableContainerVulnerabilityAssessment,omitempty"`
	// AutoProvisioning - Is audit logs pipeline auto provisioning enabled
	AutoProvisioning *bool `json:"autoProvisioning,omitempty"`
	// KubeAuditRetentionTime - The retention time in days of kube audit logs set on the CloudWatch log group
	KubeAuditRetentionTime *int64 `json:"kubeAuditRetentionTime,omitempty"`
	// ScubaExternalID - The externalId used by the data reader to prevent the confused deputy attack
	ScubaExternalID *string `json:"scubaExternalId,omitempty"`
	// Description - READ-ONLY; The offering description.
	Description *string `json:"description,omitempty"`
	// OfferingType - Possible values include: 'OfferingTypeCloudOffering', 'OfferingTypeCspmMonitorAws', 'OfferingTypeDefenderForContainersAws', 'OfferingTypeDefenderForServersAws', 'OfferingTypeDefenderForDatabasesAws', 'OfferingTypeInformationProtectionAws', 'OfferingTypeCspmMonitorGcp', 'OfferingTypeDefenderForServersGcp', 'OfferingTypeDefenderForDatabasesGcp', 'OfferingTypeDefenderForContainersGcp', 'OfferingTypeCspmMonitorGithub', 'OfferingTypeCspmMonitorAzureDevOps', 'OfferingTypeDefenderCspmAws', 'OfferingTypeDefenderCspmGcp', 'OfferingTypeDefenderForDevOpsGithub', 'OfferingTypeDefenderForDevOpsAzureDevOps'
	OfferingType OfferingType `json:"offeringType,omitempty"`
}

// MarshalJSON is the custom marshaler for DefenderForContainersAwsOffering.
func (dfcao DefenderForContainersAwsOffering) MarshalJSON() ([]byte, error) {
	dfcao.OfferingType = OfferingTypeDefenderForContainersAws
	objectMap := make(map[string]interface{})
	if dfcao.KubernetesService != nil {
		objectMap["kubernetesService"] = dfcao.KubernetesService
	}
	if dfcao.KubernetesScubaReader != nil {
		objectMap["kubernetesScubaReader"] = dfcao.KubernetesScubaReader
	}
	if dfcao.CloudWatchToKinesis != nil {
		objectMap["cloudWatchToKinesis"] = dfcao.CloudWatchToKinesis
	}
	if dfcao.KinesisToS3 != nil {
		objectMap["kinesisToS3"] = dfcao.KinesisToS3
	}
	if dfcao.ContainerVulnerabilityAssessment != nil {
		objectMap["containerVulnerabilityAssessment"] = dfcao.ContainerVulnerabilityAssessment
	}
	if dfcao.ContainerVulnerabilityAssessmentTask != nil {
		objectMap["containerVulnerabilityAssessmentTask"] = dfcao.ContainerVulnerabilityAssessmentTask
	}
	if dfcao.EnableContainerVulnerabilityAssessment != nil {
		objectMap["enableContainerVulnerabilityAssessment"] = dfcao.EnableContainerVulnerabilityAssessment
	}
	if dfcao.AutoProvisioning != nil {
		objectMap["autoProvisioning"] = dfcao.AutoProvisioning
	}
	if dfcao.KubeAuditRetentionTime != nil {
		objectMap["kubeAuditRetentionTime"] = dfcao.KubeAuditRetentionTime
	}
	if dfcao.ScubaExternalID != nil {
		objectMap["scubaExternalId"] = dfcao.ScubaExternalID
	}
	if dfcao.OfferingType != "" {
		objectMap["offeringType"] = dfcao.OfferingType
	}
	return json.Marshal(objectMap)
}

// AsCspmMonitorAwsOffering is the BasicCloudOffering implementation for DefenderForContainersAwsOffering.
func (dfcao DefenderForContainersAwsOffering) AsCspmMonitorAwsOffering() (*CspmMonitorAwsOffering, bool) {
	return nil, false
}

// AsDefenderForContainersAwsOffering is the BasicCloudOffering implementation for DefenderForContainersAwsOffering.
func (dfcao DefenderForContainersAwsOffering) AsDefenderForContainersAwsOffering() (*DefenderForContainersAwsOffering, bool) {
	return &dfcao, true
}

// AsDefenderForServersAwsOffering is the BasicCloudOffering implementation for DefenderForContainersAwsOffering.
func (dfcao DefenderForContainersAwsOffering) AsDefenderForServersAwsOffering() (*DefenderForServersAwsOffering, bool) {
	return nil, false
}

// AsDefenderFoDatabasesAwsOffering is the BasicCloudOffering implementation for DefenderForContainersAwsOffering.
func (dfcao DefenderForContainersAwsOffering) AsDefenderFoDatabasesAwsOffering() (*DefenderFoDatabasesAwsOffering, bool) {
	return nil, false
}

// AsInformationProtectionAwsOffering is the BasicCloudOffering implementation for DefenderForContainersAwsOffering.
func (dfcao DefenderForContainersAwsOffering) AsInformationProtectionAwsOffering() (*InformationProtectionAwsOffering, bool) {
	return nil, false
}

// AsCspmMonitorGcpOffering is the BasicCloudOffering implementation for DefenderForContainersAwsOffering.
func (dfcao DefenderForContainersAwsOffering) AsCspmMonitorGcpOffering() (*CspmMonitorGcpOffering, bool) {
	return nil, false
}

// AsDefenderForServersGcpOffering is the BasicCloudOffering implementation for DefenderForContainersAwsOffering.
func (dfcao DefenderForContainersAwsOffering) AsDefenderForServersGcpOffering() (*DefenderForServersGcpOffering, bool) {
	return nil, false
}

// AsDefenderForDatabasesGcpOffering is the BasicCloudOffering implementation for DefenderForContainersAwsOffering.
func (dfcao DefenderForContainersAwsOffering) AsDefenderForDatabasesGcpOffering() (*DefenderForDatabasesGcpOffering, bool) {
	return nil, false
}

// AsDefenderForContainersGcpOffering is the BasicCloudOffering implementation for DefenderForContainersAwsOffering.
func (dfcao DefenderForContainersAwsOffering) AsDefenderForContainersGcpOffering() (*DefenderForContainersGcpOffering, bool) {
	return nil, false
}

// AsCspmMonitorGithubOffering is the BasicCloudOffering implementation for DefenderForContainersAwsOffering.
func (dfcao DefenderForContainersAwsOffering) AsCspmMonitorGithubOffering() (*CspmMonitorGithubOffering, bool) {
	return nil, false
}

// AsCspmMonitorAzureDevOpsOffering is the BasicCloudOffering implementation for DefenderForContainersAwsOffering.
func (dfcao DefenderForContainersAwsOffering) AsCspmMonitorAzureDevOpsOffering() (*CspmMonitorAzureDevOpsOffering, bool) {
	return nil, false
}

// AsDefenderCspmAwsOffering is the BasicCloudOffering implementation for DefenderForContainersAwsOffering.
func (dfcao DefenderForContainersAwsOffering) AsDefenderCspmAwsOffering() (*DefenderCspmAwsOffering, bool) {
	return nil, false
}

// AsDefenderCspmGcpOffering is the BasicCloudOffering implementation for DefenderForContainersAwsOffering.
func (dfcao DefenderForContainersAwsOffering) AsDefenderCspmGcpOffering() (*DefenderCspmGcpOffering, bool) {
	return nil, false
}

// AsDefenderForDevOpsGithubOffering is the BasicCloudOffering implementation for DefenderForContainersAwsOffering.
func (dfcao DefenderForContainersAwsOffering) AsDefenderForDevOpsGithubOffering() (*DefenderForDevOpsGithubOffering, bool) {
	return nil, false
}

// AsDefenderForDevOpsAzureDevOpsOffering is the BasicCloudOffering implementation for DefenderForContainersAwsOffering.
func (dfcao DefenderForContainersAwsOffering) AsDefenderForDevOpsAzureDevOpsOffering() (*DefenderForDevOpsAzureDevOpsOffering, bool) {
	return nil, false
}

// AsCloudOffering is the BasicCloudOffering implementation for DefenderForContainersAwsOffering.
func (dfcao DefenderForContainersAwsOffering) AsCloudOffering() (*CloudOffering, bool) {
	return nil, false
}

// AsBasicCloudOffering is the BasicCloudOffering implementation for DefenderForContainersAwsOffering.
func (dfcao DefenderForContainersAwsOffering) AsBasicCloudOffering() (BasicCloudOffering, bool) {
	return &dfcao, true
}

// DefenderForContainersAwsOfferingCloudWatchToKinesis the cloudwatch to kinesis connection configuration
type DefenderForContainersAwsOfferingCloudWatchToKinesis struct {
	// CloudRoleArn - The cloud role ARN in AWS used by CloudWatch to transfer data into Kinesis
	CloudRoleArn *string `json:"cloudRoleArn,omitempty"`
}

// DefenderForContainersAwsOfferingContainerVulnerabilityAssessment the container vulnerability assessment
// configuration
type DefenderForContainersAwsOfferingContainerVulnerabilityAssessment struct {
	// CloudRoleArn - The cloud role ARN in AWS for this feature
	CloudRoleArn *string `json:"cloudRoleArn,omitempty"`
}

// DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentTask the container vulnerability
// assessment task configuration
type DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentTask struct {
	// CloudRoleArn - The cloud role ARN in AWS for this feature
	CloudRoleArn *string `json:"cloudRoleArn,omitempty"`
}

// DefenderForContainersAwsOfferingKinesisToS3 the kinesis to s3 connection configuration
type DefenderForContainersAwsOfferingKinesisToS3 struct {
	// CloudRoleArn - The cloud role ARN in AWS used by Kinesis to transfer data into S3
	CloudRoleArn *string `json:"cloudRoleArn,omitempty"`
}

// DefenderForContainersAwsOfferingKubernetesScubaReader the kubernetes to scuba connection configuration
type DefenderForContainersAwsOfferingKubernetesScubaReader struct {
	// CloudRoleArn - The cloud role ARN in AWS for this feature used for reading data
	CloudRoleArn *string `json:"cloudRoleArn,omitempty"`
}

// DefenderForContainersAwsOfferingKubernetesService the kubernetes service connection configuration
type DefenderForContainersAwsOfferingKubernetesService struct {
	// CloudRoleArn - The cloud role ARN in AWS for this feature used for provisioning resources
	CloudRoleArn *string `json:"cloudRoleArn,omitempty"`
}

// DefenderForContainersGcpOffering the containers GCP offering
type DefenderForContainersGcpOffering struct {
	// NativeCloudConnection - The native cloud connection configuration
	NativeCloudConnection *DefenderForContainersGcpOfferingNativeCloudConnection `json:"nativeCloudConnection,omitempty"`
	// DataPipelineNativeCloudConnection - The native cloud connection configuration
	DataPipelineNativeCloudConnection *DefenderForContainersGcpOfferingDataPipelineNativeCloudConnection `json:"dataPipelineNativeCloudConnection,omitempty"`
	// AuditLogsAutoProvisioningFlag - Is audit logs data collection enabled
	AuditLogsAutoProvisioningFlag *bool `json:"auditLogsAutoProvisioningFlag,omitempty"`
	// DefenderAgentAutoProvisioningFlag - Is Microsoft Defender for Cloud Kubernetes agent auto provisioning enabled
	DefenderAgentAutoProvisioningFlag *bool `json:"defenderAgentAutoProvisioningFlag,omitempty"`
	// PolicyAgentAutoProvisioningFlag - Is Policy Kubernetes agent auto provisioning enabled
	PolicyAgentAutoProvisioningFlag *bool `json:"policyAgentAutoProvisioningFlag,omitempty"`
	// Description - READ-ONLY; The offering description.
	Description *string `json:"description,omitempty"`
	// OfferingType - Possible values include: 'OfferingTypeCloudOffering', 'OfferingTypeCspmMonitorAws', 'OfferingTypeDefenderForContainersAws', 'OfferingTypeDefenderForServersAws', 'OfferingTypeDefenderForDatabasesAws', 'OfferingTypeInformationProtectionAws', 'OfferingTypeCspmMonitorGcp', 'OfferingTypeDefenderForServersGcp', 'OfferingTypeDefenderForDatabasesGcp', 'OfferingTypeDefenderForContainersGcp', 'OfferingTypeCspmMonitorGithub', 'OfferingTypeCspmMonitorAzureDevOps', 'OfferingTypeDefenderCspmAws', 'OfferingTypeDefenderCspmGcp', 'OfferingTypeDefenderForDevOpsGithub', 'OfferingTypeDefenderForDevOpsAzureDevOps'
	OfferingType OfferingType `json:"offeringType,omitempty"`
}

// MarshalJSON is the custom marshaler for DefenderForContainersGcpOffering.
func (dfcgo DefenderForContainersGcpOffering) MarshalJSON() ([]byte, error) {
	dfcgo.OfferingType = OfferingTypeDefenderForContainersGcp
	objectMap := make(map[string]interface{})
	if dfcgo.NativeCloudConnection != nil {
		objectMap["nativeCloudConnection"] = dfcgo.NativeCloudConnection
	}
	if dfcgo.DataPipelineNativeCloudConnection != nil {
		objectMap["dataPipelineNativeCloudConnection"] = dfcgo.DataPipelineNativeCloudConnection
	}
	if dfcgo.AuditLogsAutoProvisioningFlag != nil {
		objectMap["auditLogsAutoProvisioningFlag"] = dfcgo.AuditLogsAutoProvisioningFlag
	}
	if dfcgo.DefenderAgentAutoProvisioningFlag != nil {
		objectMap["defenderAgentAutoProvisioningFlag"] = dfcgo.DefenderAgentAutoProvisioningFlag
	}
	if dfcgo.PolicyAgentAutoProvisioningFlag != nil {
		objectMap["policyAgentAutoProvisioningFlag"] = dfcgo.PolicyAgentAutoProvisioningFlag
	}
	if dfcgo.OfferingType != "" {
		objectMap["offeringType"] = dfcgo.OfferingType
	}
	return json.Marshal(objectMap)
}

// AsCspmMonitorAwsOffering is the BasicCloudOffering implementation for DefenderForContainersGcpOffering.
func (dfcgo DefenderForContainersGcpOffering) AsCspmMonitorAwsOffering() (*CspmMonitorAwsOffering, bool) {
	return nil, false
}

// AsDefenderForContainersAwsOffering is the BasicCloudOffering implementation for DefenderForContainersGcpOffering.
func (dfcgo DefenderForContainersGcpOffering) AsDefenderForContainersAwsOffering() (*DefenderForContainersAwsOffering, bool) {
	return nil, false
}

// AsDefenderForServersAwsOffering is the BasicCloudOffering implementation for DefenderForContainersGcpOffering.
func (dfcgo DefenderForContainersGcpOffering) AsDefenderForServersAwsOffering() (*DefenderForServersAwsOffering, bool) {
	return nil, false
}

// AsDefenderFoDatabasesAwsOffering is the BasicCloudOffering implementation for DefenderForContainersGcpOffering.
func (dfcgo DefenderForContainersGcpOffering) AsDefenderFoDatabasesAwsOffering() (*DefenderFoDatabasesAwsOffering, bool) {
	return nil, false
}

// AsInformationProtectionAwsOffering is the BasicCloudOffering implementation for DefenderForContainersGcpOffering.
func (dfcgo DefenderForContainersGcpOffering) AsInformationProtectionAwsOffering() (*InformationProtectionAwsOffering, bool) {
	return nil, false
}

// AsCspmMonitorGcpOffering is the BasicCloudOffering implementation for DefenderForContainersGcpOffering.
func (dfcgo DefenderForContainersGcpOffering) AsCspmMonitorGcpOffering() (*CspmMonitorGcpOffering, bool) {
	return nil, false
}

// AsDefenderForServersGcpOffering is the BasicCloudOffering implementation for DefenderForContainersGcpOffering.
func (dfcgo DefenderForContainersGcpOffering) AsDefenderForServersGcpOffering() (*DefenderForServersGcpOffering, bool) {
	return nil, false
}

// AsDefenderForDatabasesGcpOffering is the BasicCloudOffering implementation for DefenderForContainersGcpOffering.
func (dfcgo DefenderForContainersGcpOffering) AsDefenderForDatabasesGcpOffering() (*DefenderForDatabasesGcpOffering, bool) {
	return nil, false
}

// AsDefenderForContainersGcpOffering is the BasicCloudOffering implementation for DefenderForContainersGcpOffering.
func (dfcgo DefenderForContainersGcpOffering) AsDefenderForContainersGcpOffering() (*DefenderForContainersGcpOffering, bool) {
	return &dfcgo, true
}

// AsCspmMonitorGithubOffering is the BasicCloudOffering implementation for DefenderForContainersGcpOffering.
func (dfcgo DefenderForContainersGcpOffering) AsCspmMonitorGithubOffering() (*CspmMonitorGithubOffering, bool) {
	return nil, false
}

// AsCspmMonitorAzureDevOpsOffering is the BasicCloudOffering implementation for DefenderForContainersGcpOffering.
func (dfcgo DefenderForContainersGcpOffering) AsCspmMonitorAzureDevOpsOffering() (*CspmMonitorAzureDevOpsOffering, bool) {
	return nil, false
}

// AsDefenderCspmAwsOffering is the BasicCloudOffering implementation for DefenderForContainersGcpOffering.
func (dfcgo DefenderForContainersGcpOffering) AsDefenderCspmAwsOffering() (*DefenderCspmAwsOffering, bool) {
	return nil, false
}

// AsDefenderCspmGcpOffering is the BasicCloudOffering implementation for DefenderForContainersGcpOffering.
func (dfcgo DefenderForContainersGcpOffering) AsDefenderCspmGcpOffering() (*DefenderCspmGcpOffering, bool) {
	return nil, false
}

// AsDefenderForDevOpsGithubOffering is the BasicCloudOffering implementation for DefenderForContainersGcpOffering.
func (dfcgo DefenderForContainersGcpOffering) AsDefenderForDevOpsGithubOffering() (*DefenderForDevOpsGithubOffering, bool) {
	return nil, false
}

// AsDefenderForDevOpsAzureDevOpsOffering is the BasicCloudOffering implementation for DefenderForContainersGcpOffering.
func (dfcgo DefenderForContainersGcpOffering) AsDefenderForDevOpsAzureDevOpsOffering() (*DefenderForDevOpsAzureDevOpsOffering, bool) {
	return nil, false
}

// AsCloudOffering is the BasicCloudOffering implementation for DefenderForContainersGcpOffering.
func (dfcgo DefenderForContainersGcpOffering) AsCloudOffering() (*CloudOffering, bool) {
	return nil, false
}

// AsBasicCloudOffering is the BasicCloudOffering implementation for DefenderForContainersGcpOffering.
func (dfcgo DefenderForContainersGcpOffering) AsBasicCloudOffering() (BasicCloudOffering, bool) {
	return &dfcgo, true
}

// DefenderForContainersGcpOfferingDataPipelineNativeCloudConnection the native cloud connection
// configuration
type DefenderForContainersGcpOfferingDataPipelineNativeCloudConnection struct {
	// ServiceAccountEmailAddress - The data collection service account email address in GCP for this offering
	ServiceAccountEmailAddress *string `json:"serviceAccountEmailAddress,omitempty"`
	// WorkloadIdentityProviderID - The data collection GCP workload identity provider id for this offering
	WorkloadIdentityProviderID *string `json:"workloadIdentityProviderId,omitempty"`
}

// DefenderForContainersGcpOfferingNativeCloudConnection the native cloud connection configuration
type DefenderForContainersGcpOfferingNativeCloudConnection struct {
	// ServiceAccountEmailAddress - The service account email address in GCP for this offering
	ServiceAccountEmailAddress *string `json:"serviceAccountEmailAddress,omitempty"`
	// WorkloadIdentityProviderID - The GCP workload identity provider id for this offering
	WorkloadIdentityProviderID *string `json:"workloadIdentityProviderId,omitempty"`
}

// DefenderForDatabasesGcpOffering the Defender for Databases GCP offering configurations
type DefenderForDatabasesGcpOffering struct {
	// ArcAutoProvisioning - The ARC autoprovisioning configuration
	ArcAutoProvisioning *DefenderForDatabasesGcpOfferingArcAutoProvisioning `json:"arcAutoProvisioning,omitempty"`
	// DefenderForDatabasesArcAutoProvisioning - The native cloud connection configuration
	DefenderForDatabasesArcAutoProvisioning *DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioning `json:"defenderForDatabasesArcAutoProvisioning,omitempty"`
	// Description - READ-ONLY; The offering description.
	Description *string `json:"description,omitempty"`
	// OfferingType - Possible values include: 'OfferingTypeCloudOffering', 'OfferingTypeCspmMonitorAws', 'OfferingTypeDefenderForContainersAws', 'OfferingTypeDefenderForServersAws', 'OfferingTypeDefenderForDatabasesAws', 'OfferingTypeInformationProtectionAws', 'OfferingTypeCspmMonitorGcp', 'OfferingTypeDefenderForServersGcp', 'OfferingTypeDefenderForDatabasesGcp', 'OfferingTypeDefenderForContainersGcp', 'OfferingTypeCspmMonitorGithub', 'OfferingTypeCspmMonitorAzureDevOps', 'OfferingTypeDefenderCspmAws', 'OfferingTypeDefenderCspmGcp', 'OfferingTypeDefenderForDevOpsGithub', 'OfferingTypeDefenderForDevOpsAzureDevOps'
	OfferingType OfferingType `json:"offeringType,omitempty"`
}

// MarshalJSON is the custom marshaler for DefenderForDatabasesGcpOffering.
func (dfdgo DefenderForDatabasesGcpOffering) MarshalJSON() ([]byte, error) {
	dfdgo.OfferingType = OfferingTypeDefenderForDatabasesGcp
	objectMap := make(map[string]interface{})
	if dfdgo.ArcAutoProvisioning != nil {
		objectMap["arcAutoProvisioning"] = dfdgo.ArcAutoProvisioning
	}
	if dfdgo.DefenderForDatabasesArcAutoProvisioning != nil {
		objectMap["defenderForDatabasesArcAutoProvisioning"] = dfdgo.DefenderForDatabasesArcAutoProvisioning
	}
	if dfdgo.OfferingType != "" {
		objectMap["offeringType"] = dfdgo.OfferingType
	}
	return json.Marshal(objectMap)
}

// AsCspmMonitorAwsOffering is the BasicCloudOffering implementation for DefenderForDatabasesGcpOffering.
func (dfdgo DefenderForDatabasesGcpOffering) AsCspmMonitorAwsOffering() (*CspmMonitorAwsOffering, bool) {
	return nil, false
}

// AsDefenderForContainersAwsOffering is the BasicCloudOffering implementation for DefenderForDatabasesGcpOffering.
func (dfdgo DefenderForDatabasesGcpOffering) AsDefenderForContainersAwsOffering() (*DefenderForContainersAwsOffering, bool) {
	return nil, false
}

// AsDefenderForServersAwsOffering is the BasicCloudOffering implementation for DefenderForDatabasesGcpOffering.
func (dfdgo DefenderForDatabasesGcpOffering) AsDefenderForServersAwsOffering() (*DefenderForServersAwsOffering, bool) {
	return nil, false
}

// AsDefenderFoDatabasesAwsOffering is the BasicCloudOffering implementation for DefenderForDatabasesGcpOffering.
func (dfdgo DefenderForDatabasesGcpOffering) AsDefenderFoDatabasesAwsOffering() (*DefenderFoDatabasesAwsOffering, bool) {
	return nil, false
}

// AsInformationProtectionAwsOffering is the BasicCloudOffering implementation for DefenderForDatabasesGcpOffering.
func (dfdgo DefenderForDatabasesGcpOffering) AsInformationProtectionAwsOffering() (*InformationProtectionAwsOffering, bool) {
	return nil, false
}

// AsCspmMonitorGcpOffering is the BasicCloudOffering implementation for DefenderForDatabasesGcpOffering.
func (dfdgo DefenderForDatabasesGcpOffering) AsCspmMonitorGcpOffering() (*CspmMonitorGcpOffering, bool) {
	return nil, false
}

// AsDefenderForServersGcpOffering is the BasicCloudOffering implementation for DefenderForDatabasesGcpOffering.
func (dfdgo DefenderForDatabasesGcpOffering) AsDefenderForServersGcpOffering() (*DefenderForServersGcpOffering, bool) {
	return nil, false
}

// AsDefenderForDatabasesGcpOffering is the BasicCloudOffering implementation for DefenderForDatabasesGcpOffering.
func (dfdgo DefenderForDatabasesGcpOffering) AsDefenderForDatabasesGcpOffering() (*DefenderForDatabasesGcpOffering, bool) {
	return &dfdgo, true
}

// AsDefenderForContainersGcpOffering is the BasicCloudOffering implementation for DefenderForDatabasesGcpOffering.
func (dfdgo DefenderForDatabasesGcpOffering) AsDefenderForContainersGcpOffering() (*DefenderForContainersGcpOffering, bool) {
	return nil, false
}

// AsCspmMonitorGithubOffering is the BasicCloudOffering implementation for DefenderForDatabasesGcpOffering.
func (dfdgo DefenderForDatabasesGcpOffering) AsCspmMonitorGithubOffering() (*CspmMonitorGithubOffering, bool) {
	return nil, false
}

// AsCspmMonitorAzureDevOpsOffering is the BasicCloudOffering implementation for DefenderForDatabasesGcpOffering.
func (dfdgo DefenderForDatabasesGcpOffering) AsCspmMonitorAzureDevOpsOffering() (*CspmMonitorAzureDevOpsOffering, bool) {
	return nil, false
}

// AsDefenderCspmAwsOffering is the BasicCloudOffering implementation for DefenderForDatabasesGcpOffering.
func (dfdgo DefenderForDatabasesGcpOffering) AsDefenderCspmAwsOffering() (*DefenderCspmAwsOffering, bool) {
	return nil, false
}

// AsDefenderCspmGcpOffering is the BasicCloudOffering implementation for DefenderForDatabasesGcpOffering.
func (dfdgo DefenderForDatabasesGcpOffering) AsDefenderCspmGcpOffering() (*DefenderCspmGcpOffering, bool) {
	return nil, false
}

// AsDefenderForDevOpsGithubOffering is the BasicCloudOffering implementation for DefenderForDatabasesGcpOffering.
func (dfdgo DefenderForDatabasesGcpOffering) AsDefenderForDevOpsGithubOffering() (*DefenderForDevOpsGithubOffering, bool) {
	return nil, false
}

// AsDefenderForDevOpsAzureDevOpsOffering is the BasicCloudOffering implementation for DefenderForDatabasesGcpOffering.
func (dfdgo DefenderForDatabasesGcpOffering) AsDefenderForDevOpsAzureDevOpsOffering() (*DefenderForDevOpsAzureDevOpsOffering, bool) {
	return nil, false
}

// AsCloudOffering is the BasicCloudOffering implementation for DefenderForDatabasesGcpOffering.
func (dfdgo DefenderForDatabasesGcpOffering) AsCloudOffering() (*CloudOffering, bool) {
	return nil, false
}

// AsBasicCloudOffering is the BasicCloudOffering implementation for DefenderForDatabasesGcpOffering.
func (dfdgo DefenderForDatabasesGcpOffering) AsBasicCloudOffering() (BasicCloudOffering, bool) {
	return &dfdgo, true
}

// DefenderForDatabasesGcpOfferingArcAutoProvisioning the ARC autoprovisioning configuration
type DefenderForDatabasesGcpOfferingArcAutoProvisioning struct {
	// Enabled - Is arc auto provisioning enabled
	Enabled *bool `json:"enabled,omitempty"`
}

// DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioning the native cloud connection
// configuration
type DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioning struct {
	// ServiceAccountEmailAddress - The service account email address in GCP for this offering
	ServiceAccountEmailAddress *string `json:"serviceAccountEmailAddress,omitempty"`
	// WorkloadIdentityProviderID - The GCP workload identity provider id for this offering
	WorkloadIdentityProviderID *string `json:"workloadIdentityProviderId,omitempty"`
}

// DefenderForDevOpsAzureDevOpsOffering the Defender for DevOps for Azure DevOps offering
type DefenderForDevOpsAzureDevOpsOffering struct {
	// Description - READ-ONLY; The offering description.
	Description *string `json:"description,omitempty"`
	// OfferingType - Possible values include: 'OfferingTypeCloudOffering', 'OfferingTypeCspmMonitorAws', 'OfferingTypeDefenderForContainersAws', 'OfferingTypeDefenderForServersAws', 'OfferingTypeDefenderForDatabasesAws', 'OfferingTypeInformationProtectionAws', 'OfferingTypeCspmMonitorGcp', 'OfferingTypeDefenderForServersGcp', 'OfferingTypeDefenderForDatabasesGcp', 'OfferingTypeDefenderForContainersGcp', 'OfferingTypeCspmMonitorGithub', 'OfferingTypeCspmMonitorAzureDevOps', 'OfferingTypeDefenderCspmAws', 'OfferingTypeDefenderCspmGcp', 'OfferingTypeDefenderForDevOpsGithub', 'OfferingTypeDefenderForDevOpsAzureDevOps'
	OfferingType OfferingType `json:"offeringType,omitempty"`
}

// MarshalJSON is the custom marshaler for DefenderForDevOpsAzureDevOpsOffering.
func (dfdoadoo DefenderForDevOpsAzureDevOpsOffering) MarshalJSON() ([]byte, error) {
	dfdoadoo.OfferingType = OfferingTypeDefenderForDevOpsAzureDevOps
	objectMap := make(map[string]interface{})
	if dfdoadoo.OfferingType != "" {
		objectMap["offeringType"] = dfdoadoo.OfferingType
	}
	return json.Marshal(objectMap)
}

// AsCspmMonitorAwsOffering is the BasicCloudOffering implementation for DefenderForDevOpsAzureDevOpsOffering.
func (dfdoadoo DefenderForDevOpsAzureDevOpsOffering) AsCspmMonitorAwsOffering() (*CspmMonitorAwsOffering, bool) {
	return nil, false
}

// AsDefenderForContainersAwsOffering is the BasicCloudOffering implementation for DefenderForDevOpsAzureDevOpsOffering.
func (dfdoadoo DefenderForDevOpsAzureDevOpsOffering) AsDefenderForContainersAwsOffering() (*DefenderForContainersAwsOffering, bool) {
	return nil, false
}

// AsDefenderForServersAwsOffering is the BasicCloudOffering implementation for DefenderForDevOpsAzureDevOpsOffering.
func (dfdoadoo DefenderForDevOpsAzureDevOpsOffering) AsDefenderForServersAwsOffering() (*DefenderForServersAwsOffering, bool) {
	return nil, false
}

// AsDefenderFoDatabasesAwsOffering is the BasicCloudOffering implementation for DefenderForDevOpsAzureDevOpsOffering.
func (dfdoadoo DefenderForDevOpsAzureDevOpsOffering) AsDefenderFoDatabasesAwsOffering() (*DefenderFoDatabasesAwsOffering, bool) {
	return nil, false
}

// AsInformationProtectionAwsOffering is the BasicCloudOffering implementation for DefenderForDevOpsAzureDevOpsOffering.
func (dfdoadoo DefenderForDevOpsAzureDevOpsOffering) AsInformationProtectionAwsOffering() (*InformationProtectionAwsOffering, bool) {
	return nil, false
}

// AsCspmMonitorGcpOffering is the BasicCloudOffering implementation for DefenderForDevOpsAzureDevOpsOffering.
func (dfdoadoo DefenderForDevOpsAzureDevOpsOffering) AsCspmMonitorGcpOffering() (*CspmMonitorGcpOffering, bool) {
	return nil, false
}

// AsDefenderForServersGcpOffering is the BasicCloudOffering implementation for DefenderForDevOpsAzureDevOpsOffering.
func (dfdoadoo DefenderForDevOpsAzureDevOpsOffering) AsDefenderForServersGcpOffering() (*DefenderForServersGcpOffering, bool) {
	return nil, false
}

// AsDefenderForDatabasesGcpOffering is the BasicCloudOffering implementation for DefenderForDevOpsAzureDevOpsOffering.
func (dfdoadoo DefenderForDevOpsAzureDevOpsOffering) AsDefenderForDatabasesGcpOffering() (*DefenderForDatabasesGcpOffering, bool) {
	return nil, false
}

// AsDefenderForContainersGcpOffering is the BasicCloudOffering implementation for DefenderForDevOpsAzureDevOpsOffering.
func (dfdoadoo DefenderForDevOpsAzureDevOpsOffering) AsDefenderForContainersGcpOffering() (*DefenderForContainersGcpOffering, bool) {
	return nil, false
}

// AsCspmMonitorGithubOffering is the BasicCloudOffering implementation for DefenderForDevOpsAzureDevOpsOffering.
func (dfdoadoo DefenderForDevOpsAzureDevOpsOffering) AsCspmMonitorGithubOffering() (*CspmMonitorGithubOffering, bool) {
	return nil, false
}

// AsCspmMonitorAzureDevOpsOffering is the BasicCloudOffering implementation for DefenderForDevOpsAzureDevOpsOffering.
func (dfdoadoo DefenderForDevOpsAzureDevOpsOffering) AsCspmMonitorAzureDevOpsOffering() (*CspmMonitorAzureDevOpsOffering, bool) {
	return nil, false
}

// AsDefenderCspmAwsOffering is the BasicCloudOffering implementation for DefenderForDevOpsAzureDevOpsOffering.
func (dfdoadoo DefenderForDevOpsAzureDevOpsOffering) AsDefenderCspmAwsOffering() (*DefenderCspmAwsOffering, bool) {
	return nil, false
}

// AsDefenderCspmGcpOffering is the BasicCloudOffering implementation for DefenderForDevOpsAzureDevOpsOffering.
func (dfdoadoo DefenderForDevOpsAzureDevOpsOffering) AsDefenderCspmGcpOffering() (*DefenderCspmGcpOffering, bool) {
	return nil, false
}

// AsDefenderForDevOpsGithubOffering is the BasicCloudOffering implementation for DefenderForDevOpsAzureDevOpsOffering.
func (dfdoadoo DefenderForDevOpsAzureDevOpsOffering) AsDefenderForDevOpsGithubOffering() (*DefenderForDevOpsGithubOffering, bool) {
	return nil, false
}

// AsDefenderForDevOpsAzureDevOpsOffering is the BasicCloudOffering implementation for DefenderForDevOpsAzureDevOpsOffering.
func (dfdoadoo DefenderForDevOpsAzureDevOpsOffering) AsDefenderForDevOpsAzureDevOpsOffering() (*DefenderForDevOpsAzureDevOpsOffering, bool) {
	return &dfdoadoo, true
}

// AsCloudOffering is the BasicCloudOffering implementation for DefenderForDevOpsAzureDevOpsOffering.
func (dfdoadoo DefenderForDevOpsAzureDevOpsOffering) AsCloudOffering() (*CloudOffering, bool) {
	return nil, false
}

// AsBasicCloudOffering is the BasicCloudOffering implementation for DefenderForDevOpsAzureDevOpsOffering.
func (dfdoadoo DefenderForDevOpsAzureDevOpsOffering) AsBasicCloudOffering() (BasicCloudOffering, bool) {
	return &dfdoadoo, true
}

// DefenderForDevOpsGithubOffering the Defender for DevOps for Github offering
type DefenderForDevOpsGithubOffering struct {
	// Description - READ-ONLY; The offering description.
	Description *string `json:"description,omitempty"`
	// OfferingType - Possible values include: 'OfferingTypeCloudOffering', 'OfferingTypeCspmMonitorAws', 'OfferingTypeDefenderForContainersAws', 'OfferingTypeDefenderForServersAws', 'OfferingTypeDefenderForDatabasesAws', 'OfferingTypeInformationProtectionAws', 'OfferingTypeCspmMonitorGcp', 'OfferingTypeDefenderForServersGcp', 'OfferingTypeDefenderForDatabasesGcp', 'OfferingTypeDefenderForContainersGcp', 'OfferingTypeCspmMonitorGithub', 'OfferingTypeCspmMonitorAzureDevOps', 'OfferingTypeDefenderCspmAws', 'OfferingTypeDefenderCspmGcp', 'OfferingTypeDefenderForDevOpsGithub', 'OfferingTypeDefenderForDevOpsAzureDevOps'
	OfferingType OfferingType `json:"offeringType,omitempty"`
}

// MarshalJSON is the custom marshaler for DefenderForDevOpsGithubOffering.
func (dfdogo DefenderForDevOpsGithubOffering) MarshalJSON() ([]byte, error) {
	dfdogo.OfferingType = OfferingTypeDefenderForDevOpsGithub
	objectMap := make(map[string]interface{})
	if dfdogo.OfferingType != "" {
		objectMap["offeringType"] = dfdogo.OfferingType
	}
	return json.Marshal(objectMap)
}

// AsCspmMonitorAwsOffering is the BasicCloudOffering implementation for DefenderForDevOpsGithubOffering.
func (dfdogo DefenderForDevOpsGithubOffering) AsCspmMonitorAwsOffering() (*CspmMonitorAwsOffering, bool) {
	return nil, false
}

// AsDefenderForContainersAwsOffering is the BasicCloudOffering implementation for DefenderForDevOpsGithubOffering.
func (dfdogo DefenderForDevOpsGithubOffering) AsDefenderForContainersAwsOffering() (*DefenderForContainersAwsOffering, bool) {
	return nil, false
}

// AsDefenderForServersAwsOffering is the BasicCloudOffering implementation for DefenderForDevOpsGithubOffering.
func (dfdogo DefenderForDevOpsGithubOffering) AsDefenderForServersAwsOffering() (*DefenderForServersAwsOffering, bool) {
	return nil, false
}

// AsDefenderFoDatabasesAwsOffering is the BasicCloudOffering implementation for DefenderForDevOpsGithubOffering.
func (dfdogo DefenderForDevOpsGithubOffering) AsDefenderFoDatabasesAwsOffering() (*DefenderFoDatabasesAwsOffering, bool) {
	return nil, false
}

// AsInformationProtectionAwsOffering is the BasicCloudOffering implementation for DefenderForDevOpsGithubOffering.
func (dfdogo DefenderForDevOpsGithubOffering) AsInformationProtectionAwsOffering() (*InformationProtectionAwsOffering, bool) {
	return nil, false
}

// AsCspmMonitorGcpOffering is the BasicCloudOffering implementation for DefenderForDevOpsGithubOffering.
func (dfdogo DefenderForDevOpsGithubOffering) AsCspmMonitorGcpOffering() (*CspmMonitorGcpOffering, bool) {
	return nil, false
}

// AsDefenderForServersGcpOffering is the BasicCloudOffering implementation for DefenderForDevOpsGithubOffering.
func (dfdogo DefenderForDevOpsGithubOffering) AsDefenderForServersGcpOffering() (*DefenderForServersGcpOffering, bool) {
	return nil, false
}

// AsDefenderForDatabasesGcpOffering is the BasicCloudOffering implementation for DefenderForDevOpsGithubOffering.
func (dfdogo DefenderForDevOpsGithubOffering) AsDefenderForDatabasesGcpOffering() (*DefenderForDatabasesGcpOffering, bool) {
	return nil, false
}

// AsDefenderForContainersGcpOffering is the BasicCloudOffering implementation for DefenderForDevOpsGithubOffering.
func (dfdogo DefenderForDevOpsGithubOffering) AsDefenderForContainersGcpOffering() (*DefenderForContainersGcpOffering, bool) {
	return nil, false
}

// AsCspmMonitorGithubOffering is the BasicCloudOffering implementation for DefenderForDevOpsGithubOffering.
func (dfdogo DefenderForDevOpsGithubOffering) AsCspmMonitorGithubOffering() (*CspmMonitorGithubOffering, bool) {
	return nil, false
}

// AsCspmMonitorAzureDevOpsOffering is the BasicCloudOffering implementation for DefenderForDevOpsGithubOffering.
func (dfdogo DefenderForDevOpsGithubOffering) AsCspmMonitorAzureDevOpsOffering() (*CspmMonitorAzureDevOpsOffering, bool) {
	return nil, false
}

// AsDefenderCspmAwsOffering is the BasicCloudOffering implementation for DefenderForDevOpsGithubOffering.
func (dfdogo DefenderForDevOpsGithubOffering) AsDefenderCspmAwsOffering() (*DefenderCspmAwsOffering, bool) {
	return nil, false
}

// AsDefenderCspmGcpOffering is the BasicCloudOffering implementation for DefenderForDevOpsGithubOffering.
func (dfdogo DefenderForDevOpsGithubOffering) AsDefenderCspmGcpOffering() (*DefenderCspmGcpOffering, bool) {
	return nil, false
}

// AsDefenderForDevOpsGithubOffering is the BasicCloudOffering implementation for DefenderForDevOpsGithubOffering.
func (dfdogo DefenderForDevOpsGithubOffering) AsDefenderForDevOpsGithubOffering() (*DefenderForDevOpsGithubOffering, bool) {
	return &dfdogo, true
}

// AsDefenderForDevOpsAzureDevOpsOffering is the BasicCloudOffering implementation for DefenderForDevOpsGithubOffering.
func (dfdogo DefenderForDevOpsGithubOffering) AsDefenderForDevOpsAzureDevOpsOffering() (*DefenderForDevOpsAzureDevOpsOffering, bool) {
	return nil, false
}

// AsCloudOffering is the BasicCloudOffering implementation for DefenderForDevOpsGithubOffering.
func (dfdogo DefenderForDevOpsGithubOffering) AsCloudOffering() (*CloudOffering, bool) {
	return nil, false
}

// AsBasicCloudOffering is the BasicCloudOffering implementation for DefenderForDevOpsGithubOffering.
func (dfdogo DefenderForDevOpsGithubOffering) AsBasicCloudOffering() (BasicCloudOffering, bool) {
	return &dfdogo, true
}

// DefenderForServersAwsOffering the Defender for Servers AWS offering
type DefenderForServersAwsOffering struct {
	// DefenderForServers - The Defender for servers connection configuration
	DefenderForServers *DefenderForServersAwsOfferingDefenderForServers `json:"defenderForServers,omitempty"`
	// ArcAutoProvisioning - The ARC autoprovisioning configuration
	ArcAutoProvisioning *DefenderForServersAwsOfferingArcAutoProvisioning `json:"arcAutoProvisioning,omitempty"`
	// VaAutoProvisioning - The Vulnerability Assessment autoprovisioning configuration
	VaAutoProvisioning *DefenderForServersAwsOfferingVaAutoProvisioning `json:"vaAutoProvisioning,omitempty"`
	// MdeAutoProvisioning - The Microsoft Defender for Endpoint autoprovisioning configuration
	MdeAutoProvisioning *DefenderForServersAwsOfferingMdeAutoProvisioning `json:"mdeAutoProvisioning,omitempty"`
	// SubPlan - configuration for the servers offering subPlan
	SubPlan *DefenderForServersAwsOfferingSubPlan `json:"subPlan,omitempty"`
	// VMScanners - The Microsoft Defender for Server VM scanning configuration
	VMScanners *DefenderForServersAwsOfferingVMScanners `json:"vmScanners,omitempty"`
	// Description - READ-ONLY; The offering description.
	Description *string `json:"description,omitempty"`
	// OfferingType - Possible values include: 'OfferingTypeCloudOffering', 'OfferingTypeCspmMonitorAws', 'OfferingTypeDefenderForContainersAws', 'OfferingTypeDefenderForServersAws', 'OfferingTypeDefenderForDatabasesAws', 'OfferingTypeInformationProtectionAws', 'OfferingTypeCspmMonitorGcp', 'OfferingTypeDefenderForServersGcp', 'OfferingTypeDefenderForDatabasesGcp', 'OfferingTypeDefenderForContainersGcp', 'OfferingTypeCspmMonitorGithub', 'OfferingTypeCspmMonitorAzureDevOps', 'OfferingTypeDefenderCspmAws', 'OfferingTypeDefenderCspmGcp', 'OfferingTypeDefenderForDevOpsGithub', 'OfferingTypeDefenderForDevOpsAzureDevOps'
	OfferingType OfferingType `json:"offeringType,omitempty"`
}

// MarshalJSON is the custom marshaler for DefenderForServersAwsOffering.
func (dfsao DefenderForServersAwsOffering) MarshalJSON() ([]byte, error) {
	dfsao.OfferingType = OfferingTypeDefenderForServersAws
	objectMap := make(map[string]interface{})
	if dfsao.DefenderForServers != nil {
		objectMap["defenderForServers"] = dfsao.DefenderForServers
	}
	if dfsao.ArcAutoProvisioning != nil {
		objectMap["arcAutoProvisioning"] = dfsao.ArcAutoProvisioning
	}
	if dfsao.VaAutoProvisioning != nil {
		objectMap["vaAutoProvisioning"] = dfsao.VaAutoProvisioning
	}
	if dfsao.MdeAutoProvisioning != nil {
		objectMap["mdeAutoProvisioning"] = dfsao.MdeAutoProvisioning
	}
	if dfsao.SubPlan != nil {
		objectMap["subPlan"] = dfsao.SubPlan
	}
	if dfsao.VMScanners != nil {
		objectMap["vmScanners"] = dfsao.VMScanners
	}
	if dfsao.OfferingType != "" {
		objectMap["offeringType"] = dfsao.OfferingType
	}
	return json.Marshal(objectMap)
}

// AsCspmMonitorAwsOffering is the BasicCloudOffering implementation for DefenderForServersAwsOffering.
func (dfsao DefenderForServersAwsOffering) AsCspmMonitorAwsOffering() (*CspmMonitorAwsOffering, bool) {
	return nil, false
}

// AsDefenderForContainersAwsOffering is the BasicCloudOffering implementation for DefenderForServersAwsOffering.
func (dfsao DefenderForServersAwsOffering) AsDefenderForContainersAwsOffering() (*DefenderForContainersAwsOffering, bool) {
	return nil, false
}

// AsDefenderForServersAwsOffering is the BasicCloudOffering implementation for DefenderForServersAwsOffering.
func (dfsao DefenderForServersAwsOffering) AsDefenderForServersAwsOffering() (*DefenderForServersAwsOffering, bool) {
	return &dfsao, true
}

// AsDefenderFoDatabasesAwsOffering is the BasicCloudOffering implementation for DefenderForServersAwsOffering.
func (dfsao DefenderForServersAwsOffering) AsDefenderFoDatabasesAwsOffering() (*DefenderFoDatabasesAwsOffering, bool) {
	return nil, false
}

// AsInformationProtectionAwsOffering is the BasicCloudOffering implementation for DefenderForServersAwsOffering.
func (dfsao DefenderForServersAwsOffering) AsInformationProtectionAwsOffering() (*InformationProtectionAwsOffering, bool) {
	return nil, false
}

// AsCspmMonitorGcpOffering is the BasicCloudOffering implementation for DefenderForServersAwsOffering.
func (dfsao DefenderForServersAwsOffering) AsCspmMonitorGcpOffering() (*CspmMonitorGcpOffering, bool) {
	return nil, false
}

// AsDefenderForServersGcpOffering is the BasicCloudOffering implementation for DefenderForServersAwsOffering.
func (dfsao DefenderForServersAwsOffering) AsDefenderForServersGcpOffering() (*DefenderForServersGcpOffering, bool) {
	return nil, false
}

// AsDefenderForDatabasesGcpOffering is the BasicCloudOffering implementation for DefenderForServersAwsOffering.
func (dfsao DefenderForServersAwsOffering) AsDefenderForDatabasesGcpOffering() (*DefenderForDatabasesGcpOffering, bool) {
	return nil, false
}

// AsDefenderForContainersGcpOffering is the BasicCloudOffering implementation for DefenderForServersAwsOffering.
func (dfsao DefenderForServersAwsOffering) AsDefenderForContainersGcpOffering() (*DefenderForContainersGcpOffering, bool) {
	return nil, false
}

// AsCspmMonitorGithubOffering is the BasicCloudOffering implementation for DefenderForServersAwsOffering.
func (dfsao DefenderForServersAwsOffering) AsCspmMonitorGithubOffering() (*CspmMonitorGithubOffering, bool) {
	return nil, false
}

// AsCspmMonitorAzureDevOpsOffering is the BasicCloudOffering implementation for DefenderForServersAwsOffering.
func (dfsao DefenderForServersAwsOffering) AsCspmMonitorAzureDevOpsOffering() (*CspmMonitorAzureDevOpsOffering, bool) {
	return nil, false
}

// AsDefenderCspmAwsOffering is the BasicCloudOffering implementation for DefenderForServersAwsOffering.
func (dfsao DefenderForServersAwsOffering) AsDefenderCspmAwsOffering() (*DefenderCspmAwsOffering, bool) {
	return nil, false
}

// AsDefenderCspmGcpOffering is the BasicCloudOffering implementation for DefenderForServersAwsOffering.
func (dfsao DefenderForServersAwsOffering) AsDefenderCspmGcpOffering() (*DefenderCspmGcpOffering, bool) {
	return nil, false
}

// AsDefenderForDevOpsGithubOffering is the BasicCloudOffering implementation for DefenderForServersAwsOffering.
func (dfsao DefenderForServersAwsOffering) AsDefenderForDevOpsGithubOffering() (*DefenderForDevOpsGithubOffering, bool) {
	return nil, false
}

// AsDefenderForDevOpsAzureDevOpsOffering is the BasicCloudOffering implementation for DefenderForServersAwsOffering.
func (dfsao DefenderForServersAwsOffering) AsDefenderForDevOpsAzureDevOpsOffering() (*DefenderForDevOpsAzureDevOpsOffering, bool) {
	return nil, false
}

// AsCloudOffering is the BasicCloudOffering implementation for DefenderForServersAwsOffering.
func (dfsao DefenderForServersAwsOffering) AsCloudOffering() (*CloudOffering, bool) {
	return nil, false
}

// AsBasicCloudOffering is the BasicCloudOffering implementation for DefenderForServersAwsOffering.
func (dfsao DefenderForServersAwsOffering) AsBasicCloudOffering() (BasicCloudOffering, bool) {
	return &dfsao, true
}

// DefenderForServersAwsOfferingArcAutoProvisioning the ARC autoprovisioning configuration
type DefenderForServersAwsOfferingArcAutoProvisioning struct {
	// Enabled - Is arc auto provisioning enabled
	Enabled *bool `json:"enabled,omitempty"`
	// CloudRoleArn - The cloud role ARN in AWS for this feature
	CloudRoleArn *string `json:"cloudRoleArn,omitempty"`
}

// DefenderForServersAwsOfferingDefenderForServers the Defender for servers connection configuration
type DefenderForServersAwsOfferingDefenderForServers struct {
	// CloudRoleArn - The cloud role ARN in AWS for this feature
	CloudRoleArn *string `json:"cloudRoleArn,omitempty"`
}

// DefenderForServersAwsOfferingMdeAutoProvisioning the Microsoft Defender for Endpoint autoprovisioning
// configuration
type DefenderForServersAwsOfferingMdeAutoProvisioning struct {
	// Enabled - Is Microsoft Defender for Endpoint auto provisioning enabled
	Enabled *bool `json:"enabled,omitempty"`
	// Configuration - configuration for Microsoft Defender for Endpoint autoprovisioning
	Configuration interface{} `json:"configuration,omitempty"`
}

// DefenderForServersAwsOfferingSubPlan configuration for the servers offering subPlan
type DefenderForServersAwsOfferingSubPlan struct {
	// Type - The available sub plans. Possible values include: 'P1', 'P2'
	Type SubPlan `json:"type,omitempty"`
}

// DefenderForServersAwsOfferingVaAutoProvisioning the Vulnerability Assessment autoprovisioning
// configuration
type DefenderForServersAwsOfferingVaAutoProvisioning struct {
	// Enabled - Is Vulnerability Assessment auto provisioning enabled
	Enabled *bool `json:"enabled,omitempty"`
	// Configuration - configuration for Vulnerability Assessment autoprovisioning
	Configuration *DefenderForServersAwsOfferingVaAutoProvisioningConfiguration `json:"configuration,omitempty"`
}

// DefenderForServersAwsOfferingVaAutoProvisioningConfiguration configuration for Vulnerability Assessment
// autoprovisioning
type DefenderForServersAwsOfferingVaAutoProvisioningConfiguration struct {
	// Type - The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or 'Qualys'. Possible values include: 'Qualys', 'TVM'
	Type Type `json:"type,omitempty"`
}

// DefenderForServersAwsOfferingVMScanners the Microsoft Defender for Server VM scanning configuration
type DefenderForServersAwsOfferingVMScanners struct {
	// Enabled - Is Microsoft Defender for Server VM scanning enabled
	Enabled *bool `json:"enabled,omitempty"`
	// Configuration - configuration for Microsoft Defender for Server VM scanning
	Configuration *DefenderForServersAwsOfferingVMScannersConfiguration `json:"configuration,omitempty"`
}

// DefenderForServersAwsOfferingVMScannersConfiguration configuration for Microsoft Defender for Server VM
// scanning
type DefenderForServersAwsOfferingVMScannersConfiguration struct {
	// CloudRoleArn - The cloud role ARN in AWS for this feature
	CloudRoleArn *string `json:"cloudRoleArn,omitempty"`
	// ScanningMode - The scanning mode for the vm scan. Possible values include: 'Default'
	ScanningMode ScanningMode `json:"scanningMode,omitempty"`
	// ExclusionTags - VM tags that indicates that VM should not be scanned
	ExclusionTags map[string]*string `json:"exclusionTags"`
}

// MarshalJSON is the custom marshaler for DefenderForServersAwsOfferingVMScannersConfiguration.
func (dfsaoS DefenderForServersAwsOfferingVMScannersConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dfsaoS.CloudRoleArn != nil {
		objectMap["cloudRoleArn"] = dfsaoS.CloudRoleArn
	}
	if dfsaoS.ScanningMode != "" {
		objectMap["scanningMode"] = dfsaoS.ScanningMode
	}
	if dfsaoS.ExclusionTags != nil {
		objectMap["exclusionTags"] = dfsaoS.ExclusionTags
	}
	return json.Marshal(objectMap)
}

// DefenderForServersGcpOffering the Defender for Servers GCP offering configurations
type DefenderForServersGcpOffering struct {
	// DefenderForServers - The Defender for servers connection configuration
	DefenderForServers *DefenderForServersGcpOfferingDefenderForServers `json:"defenderForServers,omitempty"`
	// ArcAutoProvisioning - The ARC autoprovisioning configuration
	ArcAutoProvisioning *DefenderForServersGcpOfferingArcAutoProvisioning `json:"arcAutoProvisioning,omitempty"`
	// VaAutoProvisioning - The Vulnerability Assessment autoprovisioning configuration
	VaAutoProvisioning *DefenderForServersGcpOfferingVaAutoProvisioning `json:"vaAutoProvisioning,omitempty"`
	// MdeAutoProvisioning - The Microsoft Defender for Endpoint autoprovisioning configuration
	MdeAutoProvisioning *DefenderForServersGcpOfferingMdeAutoProvisioning `json:"mdeAutoProvisioning,omitempty"`
	// SubPlan - configuration for the servers offering subPlan
	SubPlan *DefenderForServersGcpOfferingSubPlan `json:"subPlan,omitempty"`
	// Description - READ-ONLY; The offering description.
	Description *string `json:"description,omitempty"`
	// OfferingType - Possible values include: 'OfferingTypeCloudOffering', 'OfferingTypeCspmMonitorAws', 'OfferingTypeDefenderForContainersAws', 'OfferingTypeDefenderForServersAws', 'OfferingTypeDefenderForDatabasesAws', 'OfferingTypeInformationProtectionAws', 'OfferingTypeCspmMonitorGcp', 'OfferingTypeDefenderForServersGcp', 'OfferingTypeDefenderForDatabasesGcp', 'OfferingTypeDefenderForContainersGcp', 'OfferingTypeCspmMonitorGithub', 'OfferingTypeCspmMonitorAzureDevOps', 'OfferingTypeDefenderCspmAws', 'OfferingTypeDefenderCspmGcp', 'OfferingTypeDefenderForDevOpsGithub', 'OfferingTypeDefenderForDevOpsAzureDevOps'
	OfferingType OfferingType `json:"offeringType,omitempty"`
}

// MarshalJSON is the custom marshaler for DefenderForServersGcpOffering.
func (dfsgo DefenderForServersGcpOffering) MarshalJSON() ([]byte, error) {
	dfsgo.OfferingType = OfferingTypeDefenderForServersGcp
	objectMap := make(map[string]interface{})
	if dfsgo.DefenderForServers != nil {
		objectMap["defenderForServers"] = dfsgo.DefenderForServers
	}
	if dfsgo.ArcAutoProvisioning != nil {
		objectMap["arcAutoProvisioning"] = dfsgo.ArcAutoProvisioning
	}
	if dfsgo.VaAutoProvisioning != nil {
		objectMap["vaAutoProvisioning"] = dfsgo.VaAutoProvisioning
	}
	if dfsgo.MdeAutoProvisioning != nil {
		objectMap["mdeAutoProvisioning"] = dfsgo.MdeAutoProvisioning
	}
	if dfsgo.SubPlan != nil {
		objectMap["subPlan"] = dfsgo.SubPlan
	}
	if dfsgo.OfferingType != "" {
		objectMap["offeringType"] = dfsgo.OfferingType
	}
	return json.Marshal(objectMap)
}

// AsCspmMonitorAwsOffering is the BasicCloudOffering implementation for DefenderForServersGcpOffering.
func (dfsgo DefenderForServersGcpOffering) AsCspmMonitorAwsOffering() (*CspmMonitorAwsOffering, bool) {
	return nil, false
}

// AsDefenderForContainersAwsOffering is the BasicCloudOffering implementation for DefenderForServersGcpOffering.
func (dfsgo DefenderForServersGcpOffering) AsDefenderForContainersAwsOffering() (*DefenderForContainersAwsOffering, bool) {
	return nil, false
}

// AsDefenderForServersAwsOffering is the BasicCloudOffering implementation for DefenderForServersGcpOffering.
func (dfsgo DefenderForServersGcpOffering) AsDefenderForServersAwsOffering() (*DefenderForServersAwsOffering, bool) {
	return nil, false
}

// AsDefenderFoDatabasesAwsOffering is the BasicCloudOffering implementation for DefenderForServersGcpOffering.
func (dfsgo DefenderForServersGcpOffering) AsDefenderFoDatabasesAwsOffering() (*DefenderFoDatabasesAwsOffering, bool) {
	return nil, false
}

// AsInformationProtectionAwsOffering is the BasicCloudOffering implementation for DefenderForServersGcpOffering.
func (dfsgo DefenderForServersGcpOffering) AsInformationProtectionAwsOffering() (*InformationProtectionAwsOffering, bool) {
	return nil, false
}

// AsCspmMonitorGcpOffering is the BasicCloudOffering implementation for DefenderForServersGcpOffering.
func (dfsgo DefenderForServersGcpOffering) AsCspmMonitorGcpOffering() (*CspmMonitorGcpOffering, bool) {
	return nil, false
}

// AsDefenderForServersGcpOffering is the BasicCloudOffering implementation for DefenderForServersGcpOffering.
func (dfsgo DefenderForServersGcpOffering) AsDefenderForServersGcpOffering() (*DefenderForServersGcpOffering, bool) {
	return &dfsgo, true
}

// AsDefenderForDatabasesGcpOffering is the BasicCloudOffering implementation for DefenderForServersGcpOffering.
func (dfsgo DefenderForServersGcpOffering) AsDefenderForDatabasesGcpOffering() (*DefenderForDatabasesGcpOffering, bool) {
	return nil, false
}

// AsDefenderForContainersGcpOffering is the BasicCloudOffering implementation for DefenderForServersGcpOffering.
func (dfsgo DefenderForServersGcpOffering) AsDefenderForContainersGcpOffering() (*DefenderForContainersGcpOffering, bool) {
	return nil, false
}

// AsCspmMonitorGithubOffering is the BasicCloudOffering implementation for DefenderForServersGcpOffering.
func (dfsgo DefenderForServersGcpOffering) AsCspmMonitorGithubOffering() (*CspmMonitorGithubOffering, bool) {
	return nil, false
}

// AsCspmMonitorAzureDevOpsOffering is the BasicCloudOffering implementation for DefenderForServersGcpOffering.
func (dfsgo DefenderForServersGcpOffering) AsCspmMonitorAzureDevOpsOffering() (*CspmMonitorAzureDevOpsOffering, bool) {
	return nil, false
}

// AsDefenderCspmAwsOffering is the BasicCloudOffering implementation for DefenderForServersGcpOffering.
func (dfsgo DefenderForServersGcpOffering) AsDefenderCspmAwsOffering() (*DefenderCspmAwsOffering, bool) {
	return nil, false
}

// AsDefenderCspmGcpOffering is the BasicCloudOffering implementation for DefenderForServersGcpOffering.
func (dfsgo DefenderForServersGcpOffering) AsDefenderCspmGcpOffering() (*DefenderCspmGcpOffering, bool) {
	return nil, false
}

// AsDefenderForDevOpsGithubOffering is the BasicCloudOffering implementation for DefenderForServersGcpOffering.
func (dfsgo DefenderForServersGcpOffering) AsDefenderForDevOpsGithubOffering() (*DefenderForDevOpsGithubOffering, bool) {
	return nil, false
}

// AsDefenderForDevOpsAzureDevOpsOffering is the BasicCloudOffering implementation for DefenderForServersGcpOffering.
func (dfsgo DefenderForServersGcpOffering) AsDefenderForDevOpsAzureDevOpsOffering() (*DefenderForDevOpsAzureDevOpsOffering, bool) {
	return nil, false
}

// AsCloudOffering is the BasicCloudOffering implementation for DefenderForServersGcpOffering.
func (dfsgo DefenderForServersGcpOffering) AsCloudOffering() (*CloudOffering, bool) {
	return nil, false
}

// AsBasicCloudOffering is the BasicCloudOffering implementation for DefenderForServersGcpOffering.
func (dfsgo DefenderForServersGcpOffering) AsBasicCloudOffering() (BasicCloudOffering, bool) {
	return &dfsgo, true
}

// DefenderForServersGcpOfferingArcAutoProvisioning the ARC autoprovisioning configuration
type DefenderForServersGcpOfferingArcAutoProvisioning struct {
	// Enabled - Is arc auto provisioning enabled
	Enabled *bool `json:"enabled,omitempty"`
}

// DefenderForServersGcpOfferingDefenderForServers the Defender for servers connection configuration
type DefenderForServersGcpOfferingDefenderForServers struct {
	// WorkloadIdentityProviderID - The workload identity provider id in GCP for this feature
	WorkloadIdentityProviderID *string `json:"workloadIdentityProviderId,omitempty"`
	// ServiceAccountEmailAddress - The service account email address in GCP for this feature
	ServiceAccountEmailAddress *string `json:"serviceAccountEmailAddress,omitempty"`
}

// DefenderForServersGcpOfferingMdeAutoProvisioning the Microsoft Defender for Endpoint autoprovisioning
// configuration
type DefenderForServersGcpOfferingMdeAutoProvisioning struct {
	// Enabled - Is Microsoft Defender for Endpoint auto provisioning enabled
	Enabled *bool `json:"enabled,omitempty"`
	// Configuration - configuration for Microsoft Defender for Endpoint autoprovisioning
	Configuration interface{} `json:"configuration,omitempty"`
}

// DefenderForServersGcpOfferingSubPlan configuration for the servers offering subPlan
type DefenderForServersGcpOfferingSubPlan struct {
	// Type - The available sub plans. Possible values include: 'P1', 'P2'
	Type SubPlan `json:"type,omitempty"`
}

// DefenderForServersGcpOfferingVaAutoProvisioning the Vulnerability Assessment autoprovisioning
// configuration
type DefenderForServersGcpOfferingVaAutoProvisioning struct {
	// Enabled - Is Vulnerability Assessment auto provisioning enabled
	Enabled *bool `json:"enabled,omitempty"`
	// Configuration - configuration for Vulnerability Assessment autoprovisioning
	Configuration *DefenderForServersGcpOfferingVaAutoProvisioningConfiguration `json:"configuration,omitempty"`
}

// DefenderForServersGcpOfferingVaAutoProvisioningConfiguration configuration for Vulnerability Assessment
// autoprovisioning
type DefenderForServersGcpOfferingVaAutoProvisioningConfiguration struct {
	// Type - The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or 'Qualys'. Possible values include: 'Qualys', 'TVM'
	Type Type `json:"type,omitempty"`
}

// DenylistCustomAlertRule a custom alert rule that checks if a value (depends on the custom alert type) is
// denied.
type DenylistCustomAlertRule struct {
	// DenylistValues - The values to deny. The format of the values depends on the rule type.
	DenylistValues *[]string `json:"denylistValues,omitempty"`
	// ValueType - READ-ONLY; The value type of the items in the list. Possible values include: 'ValueTypeIPCidr', 'ValueTypeString'
	ValueType ValueType `json:"valueType,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeConnectionFromIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) MarshalJSON() ([]byte, error) {
	dcar.RuleType = RuleTypeDenylistCustomAlertRule
	objectMap := make(map[string]interface{})
	if dcar.DenylistValues != nil {
		objectMap["denylistValues"] = dcar.DenylistValues
	}
	if dcar.IsEnabled != nil {
		objectMap["isEnabled"] = dcar.IsEnabled
	}
	if dcar.RuleType != "" {
		objectMap["ruleType"] = dcar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return &dcar, true
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return &dcar, true
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsConnectionFromIPNotAllowed is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsConnectionFromIPNotAllowed() (*ConnectionFromIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for DenylistCustomAlertRule.
func (dcar DenylistCustomAlertRule) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &dcar, true
}

// DeviceSecurityGroup the device security group resource
type DeviceSecurityGroup struct {
	autorest.Response `json:"-"`
	// DeviceSecurityGroupProperties - Device Security group data
	*DeviceSecurityGroupProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DeviceSecurityGroup.
func (dsg DeviceSecurityGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dsg.DeviceSecurityGroupProperties != nil {
		objectMap["properties"] = dsg.DeviceSecurityGroupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DeviceSecurityGroup struct.
func (dsg *DeviceSecurityGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var deviceSecurityGroupProperties DeviceSecurityGroupProperties
				err = json.Unmarshal(*v, &deviceSecurityGroupProperties)
				if err != nil {
					return err
				}
				dsg.DeviceSecurityGroupProperties = &deviceSecurityGroupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dsg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dsg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dsg.Type = &typeVar
			}
		}
	}

	return nil
}

// DeviceSecurityGroupList list of device security groups
type DeviceSecurityGroupList struct {
	autorest.Response `json:"-"`
	// Value - List of device security group objects
	Value *[]DeviceSecurityGroup `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DeviceSecurityGroupList.
func (dsgl DeviceSecurityGroupList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dsgl.Value != nil {
		objectMap["value"] = dsgl.Value
	}
	return json.Marshal(objectMap)
}

// DeviceSecurityGroupListIterator provides access to a complete listing of DeviceSecurityGroup values.
type DeviceSecurityGroupListIterator struct {
	i    int
	page DeviceSecurityGroupListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeviceSecurityGroupListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeviceSecurityGroupListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DeviceSecurityGroupListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeviceSecurityGroupListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeviceSecurityGroupListIterator) Response() DeviceSecurityGroupList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeviceSecurityGroupListIterator) Value() DeviceSecurityGroup {
	if !iter.page.NotDone() {
		return DeviceSecurityGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DeviceSecurityGroupListIterator type.
func NewDeviceSecurityGroupListIterator(page DeviceSecurityGroupListPage) DeviceSecurityGroupListIterator {
	return DeviceSecurityGroupListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dsgl DeviceSecurityGroupList) IsEmpty() bool {
	return dsgl.Value == nil || len(*dsgl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dsgl DeviceSecurityGroupList) hasNextLink() bool {
	return dsgl.NextLink != nil && len(*dsgl.NextLink) != 0
}

// deviceSecurityGroupListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dsgl DeviceSecurityGroupList) deviceSecurityGroupListPreparer(ctx context.Context) (*http.Request, error) {
	if !dsgl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dsgl.NextLink)))
}

// DeviceSecurityGroupListPage contains a page of DeviceSecurityGroup values.
type DeviceSecurityGroupListPage struct {
	fn   func(context.Context, DeviceSecurityGroupList) (DeviceSecurityGroupList, error)
	dsgl DeviceSecurityGroupList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeviceSecurityGroupListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeviceSecurityGroupListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dsgl)
		if err != nil {
			return err
		}
		page.dsgl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DeviceSecurityGroupListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeviceSecurityGroupListPage) NotDone() bool {
	return !page.dsgl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeviceSecurityGroupListPage) Response() DeviceSecurityGroupList {
	return page.dsgl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeviceSecurityGroupListPage) Values() []DeviceSecurityGroup {
	if page.dsgl.IsEmpty() {
		return nil
	}
	return *page.dsgl.Value
}

// Creates a new instance of the DeviceSecurityGroupListPage type.
func NewDeviceSecurityGroupListPage(cur DeviceSecurityGroupList, getNextPage func(context.Context, DeviceSecurityGroupList) (DeviceSecurityGroupList, error)) DeviceSecurityGroupListPage {
	return DeviceSecurityGroupListPage{
		fn:   getNextPage,
		dsgl: cur,
	}
}

// DeviceSecurityGroupProperties describes properties of a security group.
type DeviceSecurityGroupProperties struct {
	// ThresholdRules - The list of custom alert threshold rules.
	ThresholdRules *[]BasicThresholdCustomAlertRule `json:"thresholdRules,omitempty"`
	// TimeWindowRules - The list of custom alert time-window rules.
	TimeWindowRules *[]BasicTimeWindowCustomAlertRule `json:"timeWindowRules,omitempty"`
	// AllowlistRules - The allow-list custom alert rules.
	AllowlistRules *[]BasicAllowlistCustomAlertRule `json:"allowlistRules,omitempty"`
	// DenylistRules - The deny-list custom alert rules.
	DenylistRules *[]DenylistCustomAlertRule `json:"denylistRules,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DeviceSecurityGroupProperties struct.
func (dsgp *DeviceSecurityGroupProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "thresholdRules":
			if v != nil {
				thresholdRules, err := unmarshalBasicThresholdCustomAlertRuleArray(*v)
				if err != nil {
					return err
				}
				dsgp.ThresholdRules = &thresholdRules
			}
		case "timeWindowRules":
			if v != nil {
				timeWindowRules, err := unmarshalBasicTimeWindowCustomAlertRuleArray(*v)
				if err != nil {
					return err
				}
				dsgp.TimeWindowRules = &timeWindowRules
			}
		case "allowlistRules":
			if v != nil {
				allowlistRules, err := unmarshalBasicAllowlistCustomAlertRuleArray(*v)
				if err != nil {
					return err
				}
				dsgp.AllowlistRules = &allowlistRules
			}
		case "denylistRules":
			if v != nil {
				var denylistRules []DenylistCustomAlertRule
				err = json.Unmarshal(*v, &denylistRules)
				if err != nil {
					return err
				}
				dsgp.DenylistRules = &denylistRules
			}
		}
	}

	return nil
}

// DirectMethodInvokesNotInAllowedRange number of direct method invokes is not in allowed range.
type DirectMethodInvokesNotInAllowedRange struct {
	// TimeWindowSize - The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeConnectionFromIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	dminiar.RuleType = RuleTypeDirectMethodInvokesNotInAllowedRange
	objectMap := make(map[string]interface{})
	if dminiar.TimeWindowSize != nil {
		objectMap["timeWindowSize"] = dminiar.TimeWindowSize
	}
	if dminiar.MinThreshold != nil {
		objectMap["minThreshold"] = dminiar.MinThreshold
	}
	if dminiar.MaxThreshold != nil {
		objectMap["maxThreshold"] = dminiar.MaxThreshold
	}
	if dminiar.IsEnabled != nil {
		objectMap["isEnabled"] = dminiar.IsEnabled
	}
	if dminiar.RuleType != "" {
		objectMap["ruleType"] = dminiar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return &dminiar, true
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return &dminiar, true
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsConnectionFromIPNotAllowed is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsConnectionFromIPNotAllowed() (*ConnectionFromIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return &dminiar, true
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for DirectMethodInvokesNotInAllowedRange.
func (dminiar DirectMethodInvokesNotInAllowedRange) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &dminiar, true
}

// DiscoveredSecuritySolution ...
type DiscoveredSecuritySolution struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Location where the resource is stored
	Location                              *string `json:"location,omitempty"`
	*DiscoveredSecuritySolutionProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for DiscoveredSecuritySolution.
func (dss DiscoveredSecuritySolution) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dss.DiscoveredSecuritySolutionProperties != nil {
		objectMap["properties"] = dss.DiscoveredSecuritySolutionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DiscoveredSecuritySolution struct.
func (dss *DiscoveredSecuritySolution) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dss.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dss.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dss.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dss.Location = &location
			}
		case "properties":
			if v != nil {
				var discoveredSecuritySolutionProperties DiscoveredSecuritySolutionProperties
				err = json.Unmarshal(*v, &discoveredSecuritySolutionProperties)
				if err != nil {
					return err
				}
				dss.DiscoveredSecuritySolutionProperties = &discoveredSecuritySolutionProperties
			}
		}
	}

	return nil
}

// DiscoveredSecuritySolutionList ...
type DiscoveredSecuritySolutionList struct {
	autorest.Response `json:"-"`
	Value             *[]DiscoveredSecuritySolution `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DiscoveredSecuritySolutionList.
func (dssl DiscoveredSecuritySolutionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dssl.Value != nil {
		objectMap["value"] = dssl.Value
	}
	return json.Marshal(objectMap)
}

// DiscoveredSecuritySolutionListIterator provides access to a complete listing of
// DiscoveredSecuritySolution values.
type DiscoveredSecuritySolutionListIterator struct {
	i    int
	page DiscoveredSecuritySolutionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DiscoveredSecuritySolutionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiscoveredSecuritySolutionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DiscoveredSecuritySolutionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DiscoveredSecuritySolutionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DiscoveredSecuritySolutionListIterator) Response() DiscoveredSecuritySolutionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DiscoveredSecuritySolutionListIterator) Value() DiscoveredSecuritySolution {
	if !iter.page.NotDone() {
		return DiscoveredSecuritySolution{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DiscoveredSecuritySolutionListIterator type.
func NewDiscoveredSecuritySolutionListIterator(page DiscoveredSecuritySolutionListPage) DiscoveredSecuritySolutionListIterator {
	return DiscoveredSecuritySolutionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dssl DiscoveredSecuritySolutionList) IsEmpty() bool {
	return dssl.Value == nil || len(*dssl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dssl DiscoveredSecuritySolutionList) hasNextLink() bool {
	return dssl.NextLink != nil && len(*dssl.NextLink) != 0
}

// discoveredSecuritySolutionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dssl DiscoveredSecuritySolutionList) discoveredSecuritySolutionListPreparer(ctx context.Context) (*http.Request, error) {
	if !dssl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dssl.NextLink)))
}

// DiscoveredSecuritySolutionListPage contains a page of DiscoveredSecuritySolution values.
type DiscoveredSecuritySolutionListPage struct {
	fn   func(context.Context, DiscoveredSecuritySolutionList) (DiscoveredSecuritySolutionList, error)
	dssl DiscoveredSecuritySolutionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DiscoveredSecuritySolutionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiscoveredSecuritySolutionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dssl)
		if err != nil {
			return err
		}
		page.dssl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DiscoveredSecuritySolutionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DiscoveredSecuritySolutionListPage) NotDone() bool {
	return !page.dssl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DiscoveredSecuritySolutionListPage) Response() DiscoveredSecuritySolutionList {
	return page.dssl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DiscoveredSecuritySolutionListPage) Values() []DiscoveredSecuritySolution {
	if page.dssl.IsEmpty() {
		return nil
	}
	return *page.dssl.Value
}

// Creates a new instance of the DiscoveredSecuritySolutionListPage type.
func NewDiscoveredSecuritySolutionListPage(cur DiscoveredSecuritySolutionList, getNextPage func(context.Context, DiscoveredSecuritySolutionList) (DiscoveredSecuritySolutionList, error)) DiscoveredSecuritySolutionListPage {
	return DiscoveredSecuritySolutionListPage{
		fn:   getNextPage,
		dssl: cur,
	}
}

// DiscoveredSecuritySolutionProperties ...
type DiscoveredSecuritySolutionProperties struct {
	// SecurityFamily - The security family of the discovered solution. Possible values include: 'Waf', 'Ngfw', 'SaasWaf', 'Va'
	SecurityFamily Family `json:"securityFamily,omitempty"`
	// Offer - The security solutions' image offer
	Offer *string `json:"offer,omitempty"`
	// Publisher - The security solutions' image publisher
	Publisher *string `json:"publisher,omitempty"`
	// Sku - The security solutions' image sku
	Sku *string `json:"sku,omitempty"`
}

// EffectiveNetworkSecurityGroups describes the Network Security Groups effective on a network interface
type EffectiveNetworkSecurityGroups struct {
	// NetworkInterface - The Azure resource ID of the network interface
	NetworkInterface *string `json:"networkInterface,omitempty"`
	// NetworkSecurityGroups - The Network Security Groups effective on the network interface
	NetworkSecurityGroups *[]string `json:"networkSecurityGroups,omitempty"`
}

// BasicEnvironmentData the security connector environment data.
type BasicEnvironmentData interface {
	AsAwsEnvironmentData() (*AwsEnvironmentData, bool)
	AsGcpProjectEnvironmentData() (*GcpProjectEnvironmentData, bool)
	AsGithubScopeEnvironmentData() (*GithubScopeEnvironmentData, bool)
	AsAzureDevOpsScopeEnvironmentData() (*AzureDevOpsScopeEnvironmentData, bool)
	AsEnvironmentData() (*EnvironmentData, bool)
}

// EnvironmentData the security connector environment data.
type EnvironmentData struct {
	// EnvironmentType - Possible values include: 'EnvironmentTypeEnvironmentData', 'EnvironmentTypeAwsAccount', 'EnvironmentTypeGcpProject', 'EnvironmentTypeGithubScope', 'EnvironmentTypeAzureDevOpsScope'
	EnvironmentType EnvironmentType `json:"environmentType,omitempty"`
}

func unmarshalBasicEnvironmentData(body []byte) (BasicEnvironmentData, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["environmentType"] {
	case string(EnvironmentTypeAwsAccount):
		var aed AwsEnvironmentData
		err := json.Unmarshal(body, &aed)
		return aed, err
	case string(EnvironmentTypeGcpProject):
		var gped GcpProjectEnvironmentData
		err := json.Unmarshal(body, &gped)
		return gped, err
	case string(EnvironmentTypeGithubScope):
		var gsed GithubScopeEnvironmentData
		err := json.Unmarshal(body, &gsed)
		return gsed, err
	case string(EnvironmentTypeAzureDevOpsScope):
		var adosed AzureDevOpsScopeEnvironmentData
		err := json.Unmarshal(body, &adosed)
		return adosed, err
	default:
		var ed EnvironmentData
		err := json.Unmarshal(body, &ed)
		return ed, err
	}
}
func unmarshalBasicEnvironmentDataArray(body []byte) ([]BasicEnvironmentData, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	edArray := make([]BasicEnvironmentData, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ed, err := unmarshalBasicEnvironmentData(*rawMessage)
		if err != nil {
			return nil, err
		}
		edArray[index] = ed
	}
	return edArray, nil
}

// MarshalJSON is the custom marshaler for EnvironmentData.
func (ed EnvironmentData) MarshalJSON() ([]byte, error) {
	ed.EnvironmentType = EnvironmentTypeEnvironmentData
	objectMap := make(map[string]interface{})
	if ed.EnvironmentType != "" {
		objectMap["environmentType"] = ed.EnvironmentType
	}
	return json.Marshal(objectMap)
}

// AsAwsEnvironmentData is the BasicEnvironmentData implementation for EnvironmentData.
func (ed EnvironmentData) AsAwsEnvironmentData() (*AwsEnvironmentData, bool) {
	return nil, false
}

// AsGcpProjectEnvironmentData is the BasicEnvironmentData implementation for EnvironmentData.
func (ed EnvironmentData) AsGcpProjectEnvironmentData() (*GcpProjectEnvironmentData, bool) {
	return nil, false
}

// AsGithubScopeEnvironmentData is the BasicEnvironmentData implementation for EnvironmentData.
func (ed EnvironmentData) AsGithubScopeEnvironmentData() (*GithubScopeEnvironmentData, bool) {
	return nil, false
}

// AsAzureDevOpsScopeEnvironmentData is the BasicEnvironmentData implementation for EnvironmentData.
func (ed EnvironmentData) AsAzureDevOpsScopeEnvironmentData() (*AzureDevOpsScopeEnvironmentData, bool) {
	return nil, false
}

// AsEnvironmentData is the BasicEnvironmentData implementation for EnvironmentData.
func (ed EnvironmentData) AsEnvironmentData() (*EnvironmentData, bool) {
	return &ed, true
}

// AsBasicEnvironmentData is the BasicEnvironmentData implementation for EnvironmentData.
func (ed EnvironmentData) AsBasicEnvironmentData() (BasicEnvironmentData, bool) {
	return &ed, true
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorAdditionalInfo.
func (eai ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ETag entity tag is used for comparing two or more entities from the same requested resource.
type ETag struct {
	// Etag - Entity tag is used for comparing two or more entities from the same requested resource.
	Etag *string `json:"etag,omitempty"`
}

// ExecuteGovernanceRuleParams governance rule execution parameters
type ExecuteGovernanceRuleParams struct {
	// Override - Describe if governance rule should be override
	Override *bool `json:"override,omitempty"`
}

// ExecuteRuleStatus execute status of Security GovernanceRule over a given scope
type ExecuteRuleStatus struct {
	autorest.Response `json:"-"`
	// OperationID - READ-ONLY; Unique key for the execution of GovernanceRule
	OperationID *string `json:"operationId,omitempty"`
}

// MarshalJSON is the custom marshaler for ExecuteRuleStatus.
func (ers ExecuteRuleStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// BasicExternalSecuritySolution represents a security solution external to Microsoft Defender for Cloud which sends
// information to an OMS workspace and whose data is displayed by Microsoft Defender for Cloud.
type BasicExternalSecuritySolution interface {
	AsCefExternalSecuritySolution() (*CefExternalSecuritySolution, bool)
	AsAtaExternalSecuritySolution() (*AtaExternalSecuritySolution, bool)
	AsAadExternalSecuritySolution() (*AadExternalSecuritySolution, bool)
	AsExternalSecuritySolution() (*ExternalSecuritySolution, bool)
}

// ExternalSecuritySolution represents a security solution external to Microsoft Defender for Cloud which sends
// information to an OMS workspace and whose data is displayed by Microsoft Defender for Cloud.
type ExternalSecuritySolution struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty"`
	// Kind - Possible values include: 'KindExternalSecuritySolution', 'KindCEF', 'KindATA', 'KindAAD'
	Kind KindEnum `json:"kind,omitempty"`
}

func unmarshalBasicExternalSecuritySolution(body []byte) (BasicExternalSecuritySolution, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindCEF):
		var cess CefExternalSecuritySolution
		err := json.Unmarshal(body, &cess)
		return cess, err
	case string(KindATA):
		var aess AtaExternalSecuritySolution
		err := json.Unmarshal(body, &aess)
		return aess, err
	case string(KindAAD):
		var aess AadExternalSecuritySolution
		err := json.Unmarshal(body, &aess)
		return aess, err
	default:
		var ess ExternalSecuritySolution
		err := json.Unmarshal(body, &ess)
		return ess, err
	}
}
func unmarshalBasicExternalSecuritySolutionArray(body []byte) ([]BasicExternalSecuritySolution, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	essArray := make([]BasicExternalSecuritySolution, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ess, err := unmarshalBasicExternalSecuritySolution(*rawMessage)
		if err != nil {
			return nil, err
		}
		essArray[index] = ess
	}
	return essArray, nil
}

// MarshalJSON is the custom marshaler for ExternalSecuritySolution.
func (ess ExternalSecuritySolution) MarshalJSON() ([]byte, error) {
	ess.Kind = KindExternalSecuritySolution
	objectMap := make(map[string]interface{})
	if ess.Kind != "" {
		objectMap["kind"] = ess.Kind
	}
	return json.Marshal(objectMap)
}

// AsCefExternalSecuritySolution is the BasicExternalSecuritySolution implementation for ExternalSecuritySolution.
func (ess ExternalSecuritySolution) AsCefExternalSecuritySolution() (*CefExternalSecuritySolution, bool) {
	return nil, false
}

// AsAtaExternalSecuritySolution is the BasicExternalSecuritySolution implementation for ExternalSecuritySolution.
func (ess ExternalSecuritySolution) AsAtaExternalSecuritySolution() (*AtaExternalSecuritySolution, bool) {
	return nil, false
}

// AsAadExternalSecuritySolution is the BasicExternalSecuritySolution implementation for ExternalSecuritySolution.
func (ess ExternalSecuritySolution) AsAadExternalSecuritySolution() (*AadExternalSecuritySolution, bool) {
	return nil, false
}

// AsExternalSecuritySolution is the BasicExternalSecuritySolution implementation for ExternalSecuritySolution.
func (ess ExternalSecuritySolution) AsExternalSecuritySolution() (*ExternalSecuritySolution, bool) {
	return &ess, true
}

// AsBasicExternalSecuritySolution is the BasicExternalSecuritySolution implementation for ExternalSecuritySolution.
func (ess ExternalSecuritySolution) AsBasicExternalSecuritySolution() (BasicExternalSecuritySolution, bool) {
	return &ess, true
}

// ExternalSecuritySolutionKind1 describes an Azure resource with kind
type ExternalSecuritySolutionKind1 struct {
	// Kind - The kind of the external solution. Possible values include: 'CEF', 'ATA', 'AAD'
	Kind ExternalSecuritySolutionKind `json:"kind,omitempty"`
}

// ExternalSecuritySolutionList ...
type ExternalSecuritySolutionList struct {
	autorest.Response `json:"-"`
	Value             *[]BasicExternalSecuritySolution `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ExternalSecuritySolutionList.
func (essl ExternalSecuritySolutionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if essl.Value != nil {
		objectMap["value"] = essl.Value
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExternalSecuritySolutionList struct.
func (essl *ExternalSecuritySolutionList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "value":
			if v != nil {
				value, err := unmarshalBasicExternalSecuritySolutionArray(*v)
				if err != nil {
					return err
				}
				essl.Value = &value
			}
		case "nextLink":
			if v != nil {
				var nextLink string
				err = json.Unmarshal(*v, &nextLink)
				if err != nil {
					return err
				}
				essl.NextLink = &nextLink
			}
		}
	}

	return nil
}

// ExternalSecuritySolutionListIterator provides access to a complete listing of ExternalSecuritySolution
// values.
type ExternalSecuritySolutionListIterator struct {
	i    int
	page ExternalSecuritySolutionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExternalSecuritySolutionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExternalSecuritySolutionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExternalSecuritySolutionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExternalSecuritySolutionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExternalSecuritySolutionListIterator) Response() ExternalSecuritySolutionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExternalSecuritySolutionListIterator) Value() BasicExternalSecuritySolution {
	if !iter.page.NotDone() {
		return ExternalSecuritySolution{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExternalSecuritySolutionListIterator type.
func NewExternalSecuritySolutionListIterator(page ExternalSecuritySolutionListPage) ExternalSecuritySolutionListIterator {
	return ExternalSecuritySolutionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (essl ExternalSecuritySolutionList) IsEmpty() bool {
	return essl.Value == nil || len(*essl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (essl ExternalSecuritySolutionList) hasNextLink() bool {
	return essl.NextLink != nil && len(*essl.NextLink) != 0
}

// externalSecuritySolutionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (essl ExternalSecuritySolutionList) externalSecuritySolutionListPreparer(ctx context.Context) (*http.Request, error) {
	if !essl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(essl.NextLink)))
}

// ExternalSecuritySolutionListPage contains a page of BasicExternalSecuritySolution values.
type ExternalSecuritySolutionListPage struct {
	fn   func(context.Context, ExternalSecuritySolutionList) (ExternalSecuritySolutionList, error)
	essl ExternalSecuritySolutionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExternalSecuritySolutionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExternalSecuritySolutionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.essl)
		if err != nil {
			return err
		}
		page.essl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExternalSecuritySolutionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExternalSecuritySolutionListPage) NotDone() bool {
	return !page.essl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExternalSecuritySolutionListPage) Response() ExternalSecuritySolutionList {
	return page.essl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExternalSecuritySolutionListPage) Values() []BasicExternalSecuritySolution {
	if page.essl.IsEmpty() {
		return nil
	}
	return *page.essl.Value
}

// Creates a new instance of the ExternalSecuritySolutionListPage type.
func NewExternalSecuritySolutionListPage(cur ExternalSecuritySolutionList, getNextPage func(context.Context, ExternalSecuritySolutionList) (ExternalSecuritySolutionList, error)) ExternalSecuritySolutionListPage {
	return ExternalSecuritySolutionListPage{
		fn:   getNextPage,
		essl: cur,
	}
}

// ExternalSecuritySolutionModel ...
type ExternalSecuritySolutionModel struct {
	autorest.Response `json:"-"`
	Value             BasicExternalSecuritySolution `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ExternalSecuritySolutionModel struct.
func (essm *ExternalSecuritySolutionModel) UnmarshalJSON(body []byte) error {
	ess, err := unmarshalBasicExternalSecuritySolution(body)
	if err != nil {
		return err
	}
	essm.Value = ess

	return nil
}

// ExternalSecuritySolutionProperties the solution properties (correspond to the solution kind)
type ExternalSecuritySolutionProperties struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	DeviceVendor         *string                `json:"deviceVendor,omitempty"`
	DeviceType           *string                `json:"deviceType,omitempty"`
	Workspace            *ConnectedWorkspace    `json:"workspace,omitempty"`
}

// MarshalJSON is the custom marshaler for ExternalSecuritySolutionProperties.
func (essp ExternalSecuritySolutionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if essp.DeviceVendor != nil {
		objectMap["deviceVendor"] = essp.DeviceVendor
	}
	if essp.DeviceType != nil {
		objectMap["deviceType"] = essp.DeviceType
	}
	if essp.Workspace != nil {
		objectMap["workspace"] = essp.Workspace
	}
	for k, v := range essp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExternalSecuritySolutionProperties struct.
func (essp *ExternalSecuritySolutionProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if essp.AdditionalProperties == nil {
					essp.AdditionalProperties = make(map[string]interface{})
				}
				essp.AdditionalProperties[k] = additionalProperties
			}
		case "deviceVendor":
			if v != nil {
				var deviceVendor string
				err = json.Unmarshal(*v, &deviceVendor)
				if err != nil {
					return err
				}
				essp.DeviceVendor = &deviceVendor
			}
		case "deviceType":
			if v != nil {
				var deviceType string
				err = json.Unmarshal(*v, &deviceType)
				if err != nil {
					return err
				}
				essp.DeviceType = &deviceType
			}
		case "workspace":
			if v != nil {
				var workspace ConnectedWorkspace
				err = json.Unmarshal(*v, &workspace)
				if err != nil {
					return err
				}
				essp.Workspace = &workspace
			}
		}
	}

	return nil
}

// FailedLocalLoginsNotInAllowedRange number of failed local logins is not in allowed range.
type FailedLocalLoginsNotInAllowedRange struct {
	// TimeWindowSize - The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeConnectionFromIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) MarshalJSON() ([]byte, error) {
	fllniar.RuleType = RuleTypeFailedLocalLoginsNotInAllowedRange
	objectMap := make(map[string]interface{})
	if fllniar.TimeWindowSize != nil {
		objectMap["timeWindowSize"] = fllniar.TimeWindowSize
	}
	if fllniar.MinThreshold != nil {
		objectMap["minThreshold"] = fllniar.MinThreshold
	}
	if fllniar.MaxThreshold != nil {
		objectMap["maxThreshold"] = fllniar.MaxThreshold
	}
	if fllniar.IsEnabled != nil {
		objectMap["isEnabled"] = fllniar.IsEnabled
	}
	if fllniar.RuleType != "" {
		objectMap["ruleType"] = fllniar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return &fllniar, true
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return &fllniar, true
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsConnectionFromIPNotAllowed is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsConnectionFromIPNotAllowed() (*ConnectionFromIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return &fllniar, true
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for FailedLocalLoginsNotInAllowedRange.
func (fllniar FailedLocalLoginsNotInAllowedRange) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &fllniar, true
}

// FileUploadsNotInAllowedRange number of file uploads is not in allowed range.
type FileUploadsNotInAllowedRange struct {
	// TimeWindowSize - The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeConnectionFromIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) MarshalJSON() ([]byte, error) {
	funiar.RuleType = RuleTypeFileUploadsNotInAllowedRange
	objectMap := make(map[string]interface{})
	if funiar.TimeWindowSize != nil {
		objectMap["timeWindowSize"] = funiar.TimeWindowSize
	}
	if funiar.MinThreshold != nil {
		objectMap["minThreshold"] = funiar.MinThreshold
	}
	if funiar.MaxThreshold != nil {
		objectMap["maxThreshold"] = funiar.MaxThreshold
	}
	if funiar.IsEnabled != nil {
		objectMap["isEnabled"] = funiar.IsEnabled
	}
	if funiar.RuleType != "" {
		objectMap["ruleType"] = funiar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return &funiar, true
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return &funiar, true
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsConnectionFromIPNotAllowed is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsConnectionFromIPNotAllowed() (*ConnectionFromIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return &funiar, true
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for FileUploadsNotInAllowedRange.
func (funiar FileUploadsNotInAllowedRange) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &funiar, true
}

// GcpCredentialsDetailsProperties GCP cloud account connector based service to service credentials, the
// credentials are composed of the organization ID and a JSON API key (write only)
type GcpCredentialsDetailsProperties struct {
	// OrganizationID - The organization ID of the GCP cloud account
	OrganizationID *string `json:"organizationId,omitempty"`
	// Type - Type field of the API key (write only)
	Type *string `json:"type,omitempty"`
	// ProjectID - Project ID field of the API key (write only)
	ProjectID *string `json:"projectId,omitempty"`
	// PrivateKeyID - Private key ID field of the API key (write only)
	PrivateKeyID *string `json:"privateKeyId,omitempty"`
	// PrivateKey - Private key field of the API key (write only)
	PrivateKey *string `json:"privateKey,omitempty"`
	// ClientEmail - Client email field of the API key (write only)
	ClientEmail *string `json:"clientEmail,omitempty"`
	// ClientID - Client ID field of the API key (write only)
	ClientID *string `json:"clientId,omitempty"`
	// AuthURI - Auth URI field of the API key (write only)
	AuthURI *string `json:"authUri,omitempty"`
	// TokenURI - Token URI field of the API key (write only)
	TokenURI *string `json:"tokenUri,omitempty"`
	// AuthProviderX509CertURL - Auth provider x509 certificate URL field of the API key (write only)
	AuthProviderX509CertURL *string `json:"authProviderX509CertUrl,omitempty"`
	// ClientX509CertURL - Client x509 certificate URL field of the API key (write only)
	ClientX509CertURL *string `json:"clientX509CertUrl,omitempty"`
	// AuthenticationProvisioningState - READ-ONLY; State of the multi-cloud connector. Possible values include: 'Valid', 'Invalid', 'Expired', 'IncorrectPolicy'
	AuthenticationProvisioningState AuthenticationProvisioningState `json:"authenticationProvisioningState,omitempty"`
	// GrantedPermissions - READ-ONLY; The permissions detected in the cloud account.
	GrantedPermissions *[]PermissionProperty `json:"grantedPermissions,omitempty"`
	// AuthenticationType - Possible values include: 'AuthenticationTypeAuthenticationDetailsProperties', 'AuthenticationTypeAwsCreds', 'AuthenticationTypeAwsAssumeRole', 'AuthenticationTypeGcpCredentials'
	AuthenticationType AuthenticationType `json:"authenticationType,omitempty"`
}

// MarshalJSON is the custom marshaler for GcpCredentialsDetailsProperties.
func (gcdp GcpCredentialsDetailsProperties) MarshalJSON() ([]byte, error) {
	gcdp.AuthenticationType = AuthenticationTypeGcpCredentials
	objectMap := make(map[string]interface{})
	if gcdp.OrganizationID != nil {
		objectMap["organizationId"] = gcdp.OrganizationID
	}
	if gcdp.Type != nil {
		objectMap["type"] = gcdp.Type
	}
	if gcdp.ProjectID != nil {
		objectMap["projectId"] = gcdp.ProjectID
	}
	if gcdp.PrivateKeyID != nil {
		objectMap["privateKeyId"] = gcdp.PrivateKeyID
	}
	if gcdp.PrivateKey != nil {
		objectMap["privateKey"] = gcdp.PrivateKey
	}
	if gcdp.ClientEmail != nil {
		objectMap["clientEmail"] = gcdp.ClientEmail
	}
	if gcdp.ClientID != nil {
		objectMap["clientId"] = gcdp.ClientID
	}
	if gcdp.AuthURI != nil {
		objectMap["authUri"] = gcdp.AuthURI
	}
	if gcdp.TokenURI != nil {
		objectMap["tokenUri"] = gcdp.TokenURI
	}
	if gcdp.AuthProviderX509CertURL != nil {
		objectMap["authProviderX509CertUrl"] = gcdp.AuthProviderX509CertURL
	}
	if gcdp.ClientX509CertURL != nil {
		objectMap["clientX509CertUrl"] = gcdp.ClientX509CertURL
	}
	if gcdp.AuthenticationType != "" {
		objectMap["authenticationType"] = gcdp.AuthenticationType
	}
	return json.Marshal(objectMap)
}

// AsAwsCredsAuthenticationDetailsProperties is the BasicAuthenticationDetailsProperties implementation for GcpCredentialsDetailsProperties.
func (gcdp GcpCredentialsDetailsProperties) AsAwsCredsAuthenticationDetailsProperties() (*AwsCredsAuthenticationDetailsProperties, bool) {
	return nil, false
}

// AsAwAssumeRoleAuthenticationDetailsProperties is the BasicAuthenticationDetailsProperties implementation for GcpCredentialsDetailsProperties.
func (gcdp GcpCredentialsDetailsProperties) AsAwAssumeRoleAuthenticationDetailsProperties() (*AwAssumeRoleAuthenticationDetailsProperties, bool) {
	return nil, false
}

// AsGcpCredentialsDetailsProperties is the BasicAuthenticationDetailsProperties implementation for GcpCredentialsDetailsProperties.
func (gcdp GcpCredentialsDetailsProperties) AsGcpCredentialsDetailsProperties() (*GcpCredentialsDetailsProperties, bool) {
	return &gcdp, true
}

// AsAuthenticationDetailsProperties is the BasicAuthenticationDetailsProperties implementation for GcpCredentialsDetailsProperties.
func (gcdp GcpCredentialsDetailsProperties) AsAuthenticationDetailsProperties() (*AuthenticationDetailsProperties, bool) {
	return nil, false
}

// AsBasicAuthenticationDetailsProperties is the BasicAuthenticationDetailsProperties implementation for GcpCredentialsDetailsProperties.
func (gcdp GcpCredentialsDetailsProperties) AsBasicAuthenticationDetailsProperties() (BasicAuthenticationDetailsProperties, bool) {
	return &gcdp, true
}

// BasicGcpOrganizationalData the gcpOrganization data
type BasicGcpOrganizationalData interface {
	AsGcpOrganizationalDataOrganization() (*GcpOrganizationalDataOrganization, bool)
	AsGcpOrganizationalDataMember() (*GcpOrganizationalDataMember, bool)
	AsGcpOrganizationalData() (*GcpOrganizationalData, bool)
}

// GcpOrganizationalData the gcpOrganization data
type GcpOrganizationalData struct {
	// OrganizationMembershipType - Possible values include: 'OrganizationMembershipTypeBasicGcpOrganizationalDataOrganizationMembershipTypeGcpOrganizationalData', 'OrganizationMembershipTypeBasicGcpOrganizationalDataOrganizationMembershipTypeOrganization', 'OrganizationMembershipTypeBasicGcpOrganizationalDataOrganizationMembershipTypeMember'
	OrganizationMembershipType OrganizationMembershipTypeBasicGcpOrganizationalData `json:"organizationMembershipType,omitempty"`
}

func unmarshalBasicGcpOrganizationalData(body []byte) (BasicGcpOrganizationalData, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["organizationMembershipType"] {
	case string(OrganizationMembershipTypeBasicGcpOrganizationalDataOrganizationMembershipTypeOrganization):
		var godo GcpOrganizationalDataOrganization
		err := json.Unmarshal(body, &godo)
		return godo, err
	case string(OrganizationMembershipTypeBasicGcpOrganizationalDataOrganizationMembershipTypeMember):
		var godm GcpOrganizationalDataMember
		err := json.Unmarshal(body, &godm)
		return godm, err
	default:
		var god GcpOrganizationalData
		err := json.Unmarshal(body, &god)
		return god, err
	}
}
func unmarshalBasicGcpOrganizationalDataArray(body []byte) ([]BasicGcpOrganizationalData, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	godArray := make([]BasicGcpOrganizationalData, len(rawMessages))

	for index, rawMessage := range rawMessages {
		god, err := unmarshalBasicGcpOrganizationalData(*rawMessage)
		if err != nil {
			return nil, err
		}
		godArray[index] = god
	}
	return godArray, nil
}

// MarshalJSON is the custom marshaler for GcpOrganizationalData.
func (god GcpOrganizationalData) MarshalJSON() ([]byte, error) {
	god.OrganizationMembershipType = OrganizationMembershipTypeBasicGcpOrganizationalDataOrganizationMembershipTypeGcpOrganizationalData
	objectMap := make(map[string]interface{})
	if god.OrganizationMembershipType != "" {
		objectMap["organizationMembershipType"] = god.OrganizationMembershipType
	}
	return json.Marshal(objectMap)
}

// AsGcpOrganizationalDataOrganization is the BasicGcpOrganizationalData implementation for GcpOrganizationalData.
func (god GcpOrganizationalData) AsGcpOrganizationalDataOrganization() (*GcpOrganizationalDataOrganization, bool) {
	return nil, false
}

// AsGcpOrganizationalDataMember is the BasicGcpOrganizationalData implementation for GcpOrganizationalData.
func (god GcpOrganizationalData) AsGcpOrganizationalDataMember() (*GcpOrganizationalDataMember, bool) {
	return nil, false
}

// AsGcpOrganizationalData is the BasicGcpOrganizationalData implementation for GcpOrganizationalData.
func (god GcpOrganizationalData) AsGcpOrganizationalData() (*GcpOrganizationalData, bool) {
	return &god, true
}

// AsBasicGcpOrganizationalData is the BasicGcpOrganizationalData implementation for GcpOrganizationalData.
func (god GcpOrganizationalData) AsBasicGcpOrganizationalData() (BasicGcpOrganizationalData, bool) {
	return &god, true
}

// GcpOrganizationalDataMember the gcpOrganization data for the member account
type GcpOrganizationalDataMember struct {
	// ParentHierarchyID - If the multi cloud account is not of membership type organization, this will be the ID of the project's parent
	ParentHierarchyID *string `json:"parentHierarchyId,omitempty"`
	// ManagementProjectNumber - The GCP management project number from organizational onboarding
	ManagementProjectNumber *string `json:"managementProjectNumber,omitempty"`
	// OrganizationMembershipType - Possible values include: 'OrganizationMembershipTypeBasicGcpOrganizationalDataOrganizationMembershipTypeGcpOrganizationalData', 'OrganizationMembershipTypeBasicGcpOrganizationalDataOrganizationMembershipTypeOrganization', 'OrganizationMembershipTypeBasicGcpOrganizationalDataOrganizationMembershipTypeMember'
	OrganizationMembershipType OrganizationMembershipTypeBasicGcpOrganizationalData `json:"organizationMembershipType,omitempty"`
}

// MarshalJSON is the custom marshaler for GcpOrganizationalDataMember.
func (godm GcpOrganizationalDataMember) MarshalJSON() ([]byte, error) {
	godm.OrganizationMembershipType = OrganizationMembershipTypeBasicGcpOrganizationalDataOrganizationMembershipTypeMember
	objectMap := make(map[string]interface{})
	if godm.ParentHierarchyID != nil {
		objectMap["parentHierarchyId"] = godm.ParentHierarchyID
	}
	if godm.ManagementProjectNumber != nil {
		objectMap["managementProjectNumber"] = godm.ManagementProjectNumber
	}
	if godm.OrganizationMembershipType != "" {
		objectMap["organizationMembershipType"] = godm.OrganizationMembershipType
	}
	return json.Marshal(objectMap)
}

// AsGcpOrganizationalDataOrganization is the BasicGcpOrganizationalData implementation for GcpOrganizationalDataMember.
func (godm GcpOrganizationalDataMember) AsGcpOrganizationalDataOrganization() (*GcpOrganizationalDataOrganization, bool) {
	return nil, false
}

// AsGcpOrganizationalDataMember is the BasicGcpOrganizationalData implementation for GcpOrganizationalDataMember.
func (godm GcpOrganizationalDataMember) AsGcpOrganizationalDataMember() (*GcpOrganizationalDataMember, bool) {
	return &godm, true
}

// AsGcpOrganizationalData is the BasicGcpOrganizationalData implementation for GcpOrganizationalDataMember.
func (godm GcpOrganizationalDataMember) AsGcpOrganizationalData() (*GcpOrganizationalData, bool) {
	return nil, false
}

// AsBasicGcpOrganizationalData is the BasicGcpOrganizationalData implementation for GcpOrganizationalDataMember.
func (godm GcpOrganizationalDataMember) AsBasicGcpOrganizationalData() (BasicGcpOrganizationalData, bool) {
	return &godm, true
}

// GcpOrganizationalDataOrganization the gcpOrganization data for the parent account
type GcpOrganizationalDataOrganization struct {
	// ExcludedProjectNumbers - If the multi cloud account is of membership type organization, list of accounts excluded from offering
	ExcludedProjectNumbers *[]string `json:"excludedProjectNumbers,omitempty"`
	// ServiceAccountEmailAddress - The service account email address which represents the organization level permissions container.
	ServiceAccountEmailAddress *string `json:"serviceAccountEmailAddress,omitempty"`
	// WorkloadIdentityProviderID - The GCP workload identity provider id which represents the permissions required to auto provision security connectors
	WorkloadIdentityProviderID *string `json:"workloadIdentityProviderId,omitempty"`
	// OrganizationMembershipType - Possible values include: 'OrganizationMembershipTypeBasicGcpOrganizationalDataOrganizationMembershipTypeGcpOrganizationalData', 'OrganizationMembershipTypeBasicGcpOrganizationalDataOrganizationMembershipTypeOrganization', 'OrganizationMembershipTypeBasicGcpOrganizationalDataOrganizationMembershipTypeMember'
	OrganizationMembershipType OrganizationMembershipTypeBasicGcpOrganizationalData `json:"organizationMembershipType,omitempty"`
}

// MarshalJSON is the custom marshaler for GcpOrganizationalDataOrganization.
func (godo GcpOrganizationalDataOrganization) MarshalJSON() ([]byte, error) {
	godo.OrganizationMembershipType = OrganizationMembershipTypeBasicGcpOrganizationalDataOrganizationMembershipTypeOrganization
	objectMap := make(map[string]interface{})
	if godo.ExcludedProjectNumbers != nil {
		objectMap["excludedProjectNumbers"] = godo.ExcludedProjectNumbers
	}
	if godo.ServiceAccountEmailAddress != nil {
		objectMap["serviceAccountEmailAddress"] = godo.ServiceAccountEmailAddress
	}
	if godo.WorkloadIdentityProviderID != nil {
		objectMap["workloadIdentityProviderId"] = godo.WorkloadIdentityProviderID
	}
	if godo.OrganizationMembershipType != "" {
		objectMap["organizationMembershipType"] = godo.OrganizationMembershipType
	}
	return json.Marshal(objectMap)
}

// AsGcpOrganizationalDataOrganization is the BasicGcpOrganizationalData implementation for GcpOrganizationalDataOrganization.
func (godo GcpOrganizationalDataOrganization) AsGcpOrganizationalDataOrganization() (*GcpOrganizationalDataOrganization, bool) {
	return &godo, true
}

// AsGcpOrganizationalDataMember is the BasicGcpOrganizationalData implementation for GcpOrganizationalDataOrganization.
func (godo GcpOrganizationalDataOrganization) AsGcpOrganizationalDataMember() (*GcpOrganizationalDataMember, bool) {
	return nil, false
}

// AsGcpOrganizationalData is the BasicGcpOrganizationalData implementation for GcpOrganizationalDataOrganization.
func (godo GcpOrganizationalDataOrganization) AsGcpOrganizationalData() (*GcpOrganizationalData, bool) {
	return nil, false
}

// AsBasicGcpOrganizationalData is the BasicGcpOrganizationalData implementation for GcpOrganizationalDataOrganization.
func (godo GcpOrganizationalDataOrganization) AsBasicGcpOrganizationalData() (BasicGcpOrganizationalData, bool) {
	return &godo, true
}

// GcpProjectDetails the details about the project represented by the security connector
type GcpProjectDetails struct {
	// ProjectNumber - The unique GCP Project number
	ProjectNumber *string `json:"projectNumber,omitempty"`
	// ProjectID - The GCP Project id
	ProjectID *string `json:"projectId,omitempty"`
	// WorkloadIdentityPoolID - READ-ONLY; The GCP workload identity federation pool id
	WorkloadIdentityPoolID *string `json:"workloadIdentityPoolId,omitempty"`
}

// MarshalJSON is the custom marshaler for GcpProjectDetails.
func (gpd GcpProjectDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gpd.ProjectNumber != nil {
		objectMap["projectNumber"] = gpd.ProjectNumber
	}
	if gpd.ProjectID != nil {
		objectMap["projectId"] = gpd.ProjectID
	}
	return json.Marshal(objectMap)
}

// GcpProjectEnvironmentData the GCP project connector environment data
type GcpProjectEnvironmentData struct {
	// OrganizationalData - The Gcp project's organizational data
	OrganizationalData BasicGcpOrganizationalData `json:"organizationalData,omitempty"`
	// ProjectDetails - The Gcp project's details
	ProjectDetails *GcpProjectDetails `json:"projectDetails,omitempty"`
	// EnvironmentType - Possible values include: 'EnvironmentTypeEnvironmentData', 'EnvironmentTypeAwsAccount', 'EnvironmentTypeGcpProject', 'EnvironmentTypeGithubScope', 'EnvironmentTypeAzureDevOpsScope'
	EnvironmentType EnvironmentType `json:"environmentType,omitempty"`
}

// MarshalJSON is the custom marshaler for GcpProjectEnvironmentData.
func (gped GcpProjectEnvironmentData) MarshalJSON() ([]byte, error) {
	gped.EnvironmentType = EnvironmentTypeGcpProject
	objectMap := make(map[string]interface{})
	objectMap["organizationalData"] = gped.OrganizationalData
	if gped.ProjectDetails != nil {
		objectMap["projectDetails"] = gped.ProjectDetails
	}
	if gped.EnvironmentType != "" {
		objectMap["environmentType"] = gped.EnvironmentType
	}
	return json.Marshal(objectMap)
}

// AsAwsEnvironmentData is the BasicEnvironmentData implementation for GcpProjectEnvironmentData.
func (gped GcpProjectEnvironmentData) AsAwsEnvironmentData() (*AwsEnvironmentData, bool) {
	return nil, false
}

// AsGcpProjectEnvironmentData is the BasicEnvironmentData implementation for GcpProjectEnvironmentData.
func (gped GcpProjectEnvironmentData) AsGcpProjectEnvironmentData() (*GcpProjectEnvironmentData, bool) {
	return &gped, true
}

// AsGithubScopeEnvironmentData is the BasicEnvironmentData implementation for GcpProjectEnvironmentData.
func (gped GcpProjectEnvironmentData) AsGithubScopeEnvironmentData() (*GithubScopeEnvironmentData, bool) {
	return nil, false
}

// AsAzureDevOpsScopeEnvironmentData is the BasicEnvironmentData implementation for GcpProjectEnvironmentData.
func (gped GcpProjectEnvironmentData) AsAzureDevOpsScopeEnvironmentData() (*AzureDevOpsScopeEnvironmentData, bool) {
	return nil, false
}

// AsEnvironmentData is the BasicEnvironmentData implementation for GcpProjectEnvironmentData.
func (gped GcpProjectEnvironmentData) AsEnvironmentData() (*EnvironmentData, bool) {
	return nil, false
}

// AsBasicEnvironmentData is the BasicEnvironmentData implementation for GcpProjectEnvironmentData.
func (gped GcpProjectEnvironmentData) AsBasicEnvironmentData() (BasicEnvironmentData, bool) {
	return &gped, true
}

// UnmarshalJSON is the custom unmarshaler for GcpProjectEnvironmentData struct.
func (gped *GcpProjectEnvironmentData) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "organizationalData":
			if v != nil {
				organizationalData, err := unmarshalBasicGcpOrganizationalData(*v)
				if err != nil {
					return err
				}
				gped.OrganizationalData = organizationalData
			}
		case "projectDetails":
			if v != nil {
				var projectDetails GcpProjectDetails
				err = json.Unmarshal(*v, &projectDetails)
				if err != nil {
					return err
				}
				gped.ProjectDetails = &projectDetails
			}
		case "environmentType":
			if v != nil {
				var environmentType EnvironmentType
				err = json.Unmarshal(*v, &environmentType)
				if err != nil {
					return err
				}
				gped.EnvironmentType = environmentType
			}
		}
	}

	return nil
}

// GithubScopeEnvironmentData the github scope connector's environment data
type GithubScopeEnvironmentData struct {
	// EnvironmentType - Possible values include: 'EnvironmentTypeEnvironmentData', 'EnvironmentTypeAwsAccount', 'EnvironmentTypeGcpProject', 'EnvironmentTypeGithubScope', 'EnvironmentTypeAzureDevOpsScope'
	EnvironmentType EnvironmentType `json:"environmentType,omitempty"`
}

// MarshalJSON is the custom marshaler for GithubScopeEnvironmentData.
func (gsed GithubScopeEnvironmentData) MarshalJSON() ([]byte, error) {
	gsed.EnvironmentType = EnvironmentTypeGithubScope
	objectMap := make(map[string]interface{})
	if gsed.EnvironmentType != "" {
		objectMap["environmentType"] = gsed.EnvironmentType
	}
	return json.Marshal(objectMap)
}

// AsAwsEnvironmentData is the BasicEnvironmentData implementation for GithubScopeEnvironmentData.
func (gsed GithubScopeEnvironmentData) AsAwsEnvironmentData() (*AwsEnvironmentData, bool) {
	return nil, false
}

// AsGcpProjectEnvironmentData is the BasicEnvironmentData implementation for GithubScopeEnvironmentData.
func (gsed GithubScopeEnvironmentData) AsGcpProjectEnvironmentData() (*GcpProjectEnvironmentData, bool) {
	return nil, false
}

// AsGithubScopeEnvironmentData is the BasicEnvironmentData implementation for GithubScopeEnvironmentData.
func (gsed GithubScopeEnvironmentData) AsGithubScopeEnvironmentData() (*GithubScopeEnvironmentData, bool) {
	return &gsed, true
}

// AsAzureDevOpsScopeEnvironmentData is the BasicEnvironmentData implementation for GithubScopeEnvironmentData.
func (gsed GithubScopeEnvironmentData) AsAzureDevOpsScopeEnvironmentData() (*AzureDevOpsScopeEnvironmentData, bool) {
	return nil, false
}

// AsEnvironmentData is the BasicEnvironmentData implementation for GithubScopeEnvironmentData.
func (gsed GithubScopeEnvironmentData) AsEnvironmentData() (*EnvironmentData, bool) {
	return nil, false
}

// AsBasicEnvironmentData is the BasicEnvironmentData implementation for GithubScopeEnvironmentData.
func (gsed GithubScopeEnvironmentData) AsBasicEnvironmentData() (BasicEnvironmentData, bool) {
	return &gsed, true
}

// GovernanceAssignment security GovernanceAssignment over a given scope
type GovernanceAssignment struct {
	autorest.Response `json:"-"`
	// GovernanceAssignmentProperties - Properties of a security governanceAssignment
	*GovernanceAssignmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for GovernanceAssignment.
func (ga GovernanceAssignment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ga.GovernanceAssignmentProperties != nil {
		objectMap["properties"] = ga.GovernanceAssignmentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GovernanceAssignment struct.
func (ga *GovernanceAssignment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var governanceAssignmentProperties GovernanceAssignmentProperties
				err = json.Unmarshal(*v, &governanceAssignmentProperties)
				if err != nil {
					return err
				}
				ga.GovernanceAssignmentProperties = &governanceAssignmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ga.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ga.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ga.Type = &typeVar
			}
		}
	}

	return nil
}

// GovernanceAssignmentAdditionalData describe the additional data of GovernanceAssignment - optional
type GovernanceAssignmentAdditionalData struct {
	// TicketNumber - Ticket number associated with this GovernanceAssignment
	TicketNumber *int32 `json:"ticketNumber,omitempty"`
	// TicketLink - Ticket link associated with this GovernanceAssignment - for example: https://snow.com
	TicketLink *string `json:"ticketLink,omitempty"`
	// TicketStatus - The ticket status associated with this GovernanceAssignment - for example: Active
	TicketStatus *string `json:"ticketStatus,omitempty"`
}

// GovernanceAssignmentProperties describes properties of an governance assignment
type GovernanceAssignmentProperties struct {
	// Owner - The Owner for the governance assignment - e.g. user@contoso.com - see example
	Owner *string `json:"owner,omitempty"`
	// RemediationDueDate - The remediation due-date - after this date Secure Score will be affected (in case of  active grace-period)
	RemediationDueDate *date.Time `json:"remediationDueDate,omitempty"`
	// RemediationEta - The ETA (estimated time of arrival) for remediation (optional), see example
	RemediationEta *RemediationEta `json:"remediationEta,omitempty"`
	// IsGracePeriod - Defines whether there is a grace period on the governance assignment
	IsGracePeriod *bool `json:"isGracePeriod,omitempty"`
	// GovernanceEmailNotification - The email notifications settings for the governance rule, states whether to disable notifications for mangers and owners
	GovernanceEmailNotification *GovernanceEmailNotification `json:"governanceEmailNotification,omitempty"`
	// AdditionalData - The additional data for the governance assignment - e.g. links to ticket (optional), see example
	AdditionalData *GovernanceAssignmentAdditionalData `json:"additionalData,omitempty"`
}

// GovernanceAssignmentsList page of a security governance assignments list
type GovernanceAssignmentsList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Collection of governance assignments in this page
	Value *[]GovernanceAssignment `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for GovernanceAssignmentsList.
func (gal GovernanceAssignmentsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// GovernanceAssignmentsListIterator provides access to a complete listing of GovernanceAssignment values.
type GovernanceAssignmentsListIterator struct {
	i    int
	page GovernanceAssignmentsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *GovernanceAssignmentsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GovernanceAssignmentsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *GovernanceAssignmentsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter GovernanceAssignmentsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter GovernanceAssignmentsListIterator) Response() GovernanceAssignmentsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter GovernanceAssignmentsListIterator) Value() GovernanceAssignment {
	if !iter.page.NotDone() {
		return GovernanceAssignment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the GovernanceAssignmentsListIterator type.
func NewGovernanceAssignmentsListIterator(page GovernanceAssignmentsListPage) GovernanceAssignmentsListIterator {
	return GovernanceAssignmentsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (gal GovernanceAssignmentsList) IsEmpty() bool {
	return gal.Value == nil || len(*gal.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (gal GovernanceAssignmentsList) hasNextLink() bool {
	return gal.NextLink != nil && len(*gal.NextLink) != 0
}

// governanceAssignmentsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (gal GovernanceAssignmentsList) governanceAssignmentsListPreparer(ctx context.Context) (*http.Request, error) {
	if !gal.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(gal.NextLink)))
}

// GovernanceAssignmentsListPage contains a page of GovernanceAssignment values.
type GovernanceAssignmentsListPage struct {
	fn  func(context.Context, GovernanceAssignmentsList) (GovernanceAssignmentsList, error)
	gal GovernanceAssignmentsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *GovernanceAssignmentsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GovernanceAssignmentsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.gal)
		if err != nil {
			return err
		}
		page.gal = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *GovernanceAssignmentsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page GovernanceAssignmentsListPage) NotDone() bool {
	return !page.gal.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page GovernanceAssignmentsListPage) Response() GovernanceAssignmentsList {
	return page.gal
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page GovernanceAssignmentsListPage) Values() []GovernanceAssignment {
	if page.gal.IsEmpty() {
		return nil
	}
	return *page.gal.Value
}

// Creates a new instance of the GovernanceAssignmentsListPage type.
func NewGovernanceAssignmentsListPage(cur GovernanceAssignmentsList, getNextPage func(context.Context, GovernanceAssignmentsList) (GovernanceAssignmentsList, error)) GovernanceAssignmentsListPage {
	return GovernanceAssignmentsListPage{
		fn:  getNextPage,
		gal: cur,
	}
}

// GovernanceEmailNotification the governance email weekly notification configuration.
type GovernanceEmailNotification struct {
	// DisableManagerEmailNotification - Exclude manager from weekly email notification.
	DisableManagerEmailNotification *bool `json:"disableManagerEmailNotification,omitempty"`
	// DisableOwnerEmailNotification - Exclude  owner from weekly email notification.
	DisableOwnerEmailNotification *bool `json:"disableOwnerEmailNotification,omitempty"`
}

// GovernanceRule security GovernanceRule over a given scope
type GovernanceRule struct {
	autorest.Response `json:"-"`
	// GovernanceRuleProperties - Properties of a security governanceRule
	*GovernanceRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for GovernanceRule.
func (gr GovernanceRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gr.GovernanceRuleProperties != nil {
		objectMap["properties"] = gr.GovernanceRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GovernanceRule struct.
func (gr *GovernanceRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var governanceRuleProperties GovernanceRuleProperties
				err = json.Unmarshal(*v, &governanceRuleProperties)
				if err != nil {
					return err
				}
				gr.GovernanceRuleProperties = &governanceRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gr.Type = &typeVar
			}
		}
	}

	return nil
}

// GovernanceRuleEmailNotification the governance email weekly notification configuration.
type GovernanceRuleEmailNotification struct {
	// DisableManagerEmailNotification - Defines whether manager email notifications are disabled.
	DisableManagerEmailNotification *bool `json:"disableManagerEmailNotification,omitempty"`
	// DisableOwnerEmailNotification - Defines whether owner email notifications are disabled.
	DisableOwnerEmailNotification *bool `json:"disableOwnerEmailNotification,omitempty"`
}

// GovernanceRuleList page of a security governanceRules list
type GovernanceRuleList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Collection of governanceRules in this page
	Value *[]GovernanceRule `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for GovernanceRuleList.
func (grl GovernanceRuleList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// GovernanceRuleListIterator provides access to a complete listing of GovernanceRule values.
type GovernanceRuleListIterator struct {
	i    int
	page GovernanceRuleListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *GovernanceRuleListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GovernanceRuleListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *GovernanceRuleListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter GovernanceRuleListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter GovernanceRuleListIterator) Response() GovernanceRuleList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter GovernanceRuleListIterator) Value() GovernanceRule {
	if !iter.page.NotDone() {
		return GovernanceRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the GovernanceRuleListIterator type.
func NewGovernanceRuleListIterator(page GovernanceRuleListPage) GovernanceRuleListIterator {
	return GovernanceRuleListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (grl GovernanceRuleList) IsEmpty() bool {
	return grl.Value == nil || len(*grl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (grl GovernanceRuleList) hasNextLink() bool {
	return grl.NextLink != nil && len(*grl.NextLink) != 0
}

// governanceRuleListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (grl GovernanceRuleList) governanceRuleListPreparer(ctx context.Context) (*http.Request, error) {
	if !grl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(grl.NextLink)))
}

// GovernanceRuleListPage contains a page of GovernanceRule values.
type GovernanceRuleListPage struct {
	fn  func(context.Context, GovernanceRuleList) (GovernanceRuleList, error)
	grl GovernanceRuleList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *GovernanceRuleListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GovernanceRuleListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.grl)
		if err != nil {
			return err
		}
		page.grl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *GovernanceRuleListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page GovernanceRuleListPage) NotDone() bool {
	return !page.grl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page GovernanceRuleListPage) Response() GovernanceRuleList {
	return page.grl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page GovernanceRuleListPage) Values() []GovernanceRule {
	if page.grl.IsEmpty() {
		return nil
	}
	return *page.grl.Value
}

// Creates a new instance of the GovernanceRuleListPage type.
func NewGovernanceRuleListPage(cur GovernanceRuleList, getNextPage func(context.Context, GovernanceRuleList) (GovernanceRuleList, error)) GovernanceRuleListPage {
	return GovernanceRuleListPage{
		fn:  getNextPage,
		grl: cur,
	}
}

// GovernanceRuleOwnerSource describe the owner source of governance rule
type GovernanceRuleOwnerSource struct {
	// Type - The owner type for the governance rule owner source. Possible values include: 'ByTag', 'Manually'
	Type GovernanceRuleOwnerSourceType `json:"type,omitempty"`
	// Value - The source value e.g. tag key like owner name or email address
	Value *string `json:"value,omitempty"`
}

// GovernanceRuleProperties describes properties of an governanceRule
type GovernanceRuleProperties struct {
	// DisplayName - display name of the governanceRule
	DisplayName *string `json:"displayName,omitempty"`
	// Description - description of the governanceRule
	Description *string `json:"description,omitempty"`
	// RemediationTimeframe - Governance rule remediation timeframe - this is the time that will affect on the grace-period duration e.g. 7.00:00:00 - means 7 days
	RemediationTimeframe *string `json:"remediationTimeframe,omitempty"`
	// IsGracePeriod - Defines whether there is a grace period on the governance rule
	IsGracePeriod *bool `json:"isGracePeriod,omitempty"`
	// RulePriority - The governance rule priority, priority to the lower number. Rules with the same priority on the same subscription will not be allowed
	RulePriority *int32 `json:"rulePriority,omitempty"`
	// IsDisabled - Defines whether the rule is active/inactive
	IsDisabled *bool `json:"isDisabled,omitempty"`
	// RuleType - The rule type of the governance rule, defines the source of the rule e.g. Integrated. Possible values include: 'Integrated', 'ServiceNow'
	RuleType GovernanceRuleType `json:"ruleType,omitempty"`
	// SourceResourceType - The governance rule source, what the rule affects, e.g. Assessments
	SourceResourceType *string `json:"sourceResourceType,omitempty"`
	// ConditionSets - The governance rule conditionSets - see examples
	ConditionSets *[]interface{} `json:"conditionSets,omitempty"`
	// OwnerSource - The Owner source for the governance rule - e.g. Manually by user@contoso.com - see example
	OwnerSource *GovernanceRuleOwnerSource `json:"ownerSource,omitempty"`
	// GovernanceEmailNotification - The email notifications settings for the governance rule, states whether to disable notifications for mangers and owners
	GovernanceEmailNotification *GovernanceRuleEmailNotification `json:"governanceEmailNotification,omitempty"`
}

// GovernanceRulesRuleIDExecuteSingleSecurityConnectorFuture an abstraction for monitoring and retrieving
// the results of a long-running operation.
type GovernanceRulesRuleIDExecuteSingleSecurityConnectorFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GovernanceRulesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GovernanceRulesRuleIDExecuteSingleSecurityConnectorFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GovernanceRulesRuleIDExecuteSingleSecurityConnectorFuture.Result.
func (future *GovernanceRulesRuleIDExecuteSingleSecurityConnectorFuture) result(client GovernanceRulesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.GovernanceRulesRuleIDExecuteSingleSecurityConnectorFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("security.GovernanceRulesRuleIDExecuteSingleSecurityConnectorFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// GovernanceRulesRuleIDExecuteSingleSubscriptionFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type GovernanceRulesRuleIDExecuteSingleSubscriptionFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GovernanceRulesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GovernanceRulesRuleIDExecuteSingleSubscriptionFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GovernanceRulesRuleIDExecuteSingleSubscriptionFuture.Result.
func (future *GovernanceRulesRuleIDExecuteSingleSubscriptionFuture) result(client GovernanceRulesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.GovernanceRulesRuleIDExecuteSingleSubscriptionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("security.GovernanceRulesRuleIDExecuteSingleSubscriptionFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// HTTPC2DMessagesNotInAllowedRange number of cloud to device messages (HTTP protocol) is not in allowed
// range.
type HTTPC2DMessagesNotInAllowedRange struct {
	// TimeWindowSize - The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeConnectionFromIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	hcmniar.RuleType = RuleTypeHTTPC2DMessagesNotInAllowedRange
	objectMap := make(map[string]interface{})
	if hcmniar.TimeWindowSize != nil {
		objectMap["timeWindowSize"] = hcmniar.TimeWindowSize
	}
	if hcmniar.MinThreshold != nil {
		objectMap["minThreshold"] = hcmniar.MinThreshold
	}
	if hcmniar.MaxThreshold != nil {
		objectMap["maxThreshold"] = hcmniar.MaxThreshold
	}
	if hcmniar.IsEnabled != nil {
		objectMap["isEnabled"] = hcmniar.IsEnabled
	}
	if hcmniar.RuleType != "" {
		objectMap["ruleType"] = hcmniar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return &hcmniar, true
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return &hcmniar, true
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsConnectionFromIPNotAllowed is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsConnectionFromIPNotAllowed() (*ConnectionFromIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return &hcmniar, true
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DMessagesNotInAllowedRange.
func (hcmniar HTTPC2DMessagesNotInAllowedRange) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &hcmniar, true
}

// HTTPC2DRejectedMessagesNotInAllowedRange number of rejected cloud to device messages (HTTP protocol) is
// not in allowed range.
type HTTPC2DRejectedMessagesNotInAllowedRange struct {
	// TimeWindowSize - The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeConnectionFromIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	hcrmniar.RuleType = RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange
	objectMap := make(map[string]interface{})
	if hcrmniar.TimeWindowSize != nil {
		objectMap["timeWindowSize"] = hcrmniar.TimeWindowSize
	}
	if hcrmniar.MinThreshold != nil {
		objectMap["minThreshold"] = hcrmniar.MinThreshold
	}
	if hcrmniar.MaxThreshold != nil {
		objectMap["maxThreshold"] = hcrmniar.MaxThreshold
	}
	if hcrmniar.IsEnabled != nil {
		objectMap["isEnabled"] = hcrmniar.IsEnabled
	}
	if hcrmniar.RuleType != "" {
		objectMap["ruleType"] = hcrmniar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return &hcrmniar, true
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return &hcrmniar, true
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsConnectionFromIPNotAllowed is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsConnectionFromIPNotAllowed() (*ConnectionFromIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return &hcrmniar, true
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for HTTPC2DRejectedMessagesNotInAllowedRange.
func (hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &hcrmniar, true
}

// HTTPD2CMessagesNotInAllowedRange number of device to cloud messages (HTTP protocol) is not in allowed
// range.
type HTTPD2CMessagesNotInAllowedRange struct {
	// TimeWindowSize - The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeConnectionFromIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	hdmniar.RuleType = RuleTypeHTTPD2CMessagesNotInAllowedRange
	objectMap := make(map[string]interface{})
	if hdmniar.TimeWindowSize != nil {
		objectMap["timeWindowSize"] = hdmniar.TimeWindowSize
	}
	if hdmniar.MinThreshold != nil {
		objectMap["minThreshold"] = hdmniar.MinThreshold
	}
	if hdmniar.MaxThreshold != nil {
		objectMap["maxThreshold"] = hdmniar.MaxThreshold
	}
	if hdmniar.IsEnabled != nil {
		objectMap["isEnabled"] = hdmniar.IsEnabled
	}
	if hdmniar.RuleType != "" {
		objectMap["ruleType"] = hdmniar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return &hdmniar, true
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return &hdmniar, true
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsConnectionFromIPNotAllowed is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsConnectionFromIPNotAllowed() (*ConnectionFromIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return &hdmniar, true
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for HTTPD2CMessagesNotInAllowedRange.
func (hdmniar HTTPD2CMessagesNotInAllowedRange) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &hdmniar, true
}

// HybridComputeSettingsProperties settings for hybrid compute management
type HybridComputeSettingsProperties struct {
	// HybridComputeProvisioningState - READ-ONLY; State of the service principal and its secret. Possible values include: 'HybridComputeProvisioningStateValid', 'HybridComputeProvisioningStateInvalid', 'HybridComputeProvisioningStateExpired'
	HybridComputeProvisioningState HybridComputeProvisioningState `json:"hybridComputeProvisioningState,omitempty"`
	// AutoProvision - Whether or not to automatically install Azure Arc (hybrid compute) agents on machines. Possible values include: 'On', 'Off'
	AutoProvision AutoProvision `json:"autoProvision,omitempty"`
	// ResourceGroupName - The name of the resource group where Arc (Hybrid Compute) connectors are connected.
	ResourceGroupName *string `json:"resourceGroupName,omitempty"`
	// Region - The location where the metadata of machines will be stored
	Region *string `json:"region,omitempty"`
	// ProxyServer - For a non-Azure machine that is not connected directly to the internet, specify a proxy server that the non-Azure machine can use.
	ProxyServer *ProxyServerProperties `json:"proxyServer,omitempty"`
	// ServicePrincipal - An object to access resources that are secured by an Azure AD tenant.
	ServicePrincipal *ServicePrincipalProperties `json:"servicePrincipal,omitempty"`
}

// MarshalJSON is the custom marshaler for HybridComputeSettingsProperties.
func (hcsp HybridComputeSettingsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hcsp.AutoProvision != "" {
		objectMap["autoProvision"] = hcsp.AutoProvision
	}
	if hcsp.ResourceGroupName != nil {
		objectMap["resourceGroupName"] = hcsp.ResourceGroupName
	}
	if hcsp.Region != nil {
		objectMap["region"] = hcsp.Region
	}
	if hcsp.ProxyServer != nil {
		objectMap["proxyServer"] = hcsp.ProxyServer
	}
	if hcsp.ServicePrincipal != nil {
		objectMap["servicePrincipal"] = hcsp.ServicePrincipal
	}
	return json.Marshal(objectMap)
}

// InformationProtectionAwsOffering the information protection for AWS offering
type InformationProtectionAwsOffering struct {
	// InformationProtection - The native cloud connection configuration
	InformationProtection *InformationProtectionAwsOfferingInformationProtection `json:"informationProtection,omitempty"`
	// Description - READ-ONLY; The offering description.
	Description *string `json:"description,omitempty"`
	// OfferingType - Possible values include: 'OfferingTypeCloudOffering', 'OfferingTypeCspmMonitorAws', 'OfferingTypeDefenderForContainersAws', 'OfferingTypeDefenderForServersAws', 'OfferingTypeDefenderForDatabasesAws', 'OfferingTypeInformationProtectionAws', 'OfferingTypeCspmMonitorGcp', 'OfferingTypeDefenderForServersGcp', 'OfferingTypeDefenderForDatabasesGcp', 'OfferingTypeDefenderForContainersGcp', 'OfferingTypeCspmMonitorGithub', 'OfferingTypeCspmMonitorAzureDevOps', 'OfferingTypeDefenderCspmAws', 'OfferingTypeDefenderCspmGcp', 'OfferingTypeDefenderForDevOpsGithub', 'OfferingTypeDefenderForDevOpsAzureDevOps'
	OfferingType OfferingType `json:"offeringType,omitempty"`
}

// MarshalJSON is the custom marshaler for InformationProtectionAwsOffering.
func (ipao InformationProtectionAwsOffering) MarshalJSON() ([]byte, error) {
	ipao.OfferingType = OfferingTypeInformationProtectionAws
	objectMap := make(map[string]interface{})
	if ipao.InformationProtection != nil {
		objectMap["informationProtection"] = ipao.InformationProtection
	}
	if ipao.OfferingType != "" {
		objectMap["offeringType"] = ipao.OfferingType
	}
	return json.Marshal(objectMap)
}

// AsCspmMonitorAwsOffering is the BasicCloudOffering implementation for InformationProtectionAwsOffering.
func (ipao InformationProtectionAwsOffering) AsCspmMonitorAwsOffering() (*CspmMonitorAwsOffering, bool) {
	return nil, false
}

// AsDefenderForContainersAwsOffering is the BasicCloudOffering implementation for InformationProtectionAwsOffering.
func (ipao InformationProtectionAwsOffering) AsDefenderForContainersAwsOffering() (*DefenderForContainersAwsOffering, bool) {
	return nil, false
}

// AsDefenderForServersAwsOffering is the BasicCloudOffering implementation for InformationProtectionAwsOffering.
func (ipao InformationProtectionAwsOffering) AsDefenderForServersAwsOffering() (*DefenderForServersAwsOffering, bool) {
	return nil, false
}

// AsDefenderFoDatabasesAwsOffering is the BasicCloudOffering implementation for InformationProtectionAwsOffering.
func (ipao InformationProtectionAwsOffering) AsDefenderFoDatabasesAwsOffering() (*DefenderFoDatabasesAwsOffering, bool) {
	return nil, false
}

// AsInformationProtectionAwsOffering is the BasicCloudOffering implementation for InformationProtectionAwsOffering.
func (ipao InformationProtectionAwsOffering) AsInformationProtectionAwsOffering() (*InformationProtectionAwsOffering, bool) {
	return &ipao, true
}

// AsCspmMonitorGcpOffering is the BasicCloudOffering implementation for InformationProtectionAwsOffering.
func (ipao InformationProtectionAwsOffering) AsCspmMonitorGcpOffering() (*CspmMonitorGcpOffering, bool) {
	return nil, false
}

// AsDefenderForServersGcpOffering is the BasicCloudOffering implementation for InformationProtectionAwsOffering.
func (ipao InformationProtectionAwsOffering) AsDefenderForServersGcpOffering() (*DefenderForServersGcpOffering, bool) {
	return nil, false
}

// AsDefenderForDatabasesGcpOffering is the BasicCloudOffering implementation for InformationProtectionAwsOffering.
func (ipao InformationProtectionAwsOffering) AsDefenderForDatabasesGcpOffering() (*DefenderForDatabasesGcpOffering, bool) {
	return nil, false
}

// AsDefenderForContainersGcpOffering is the BasicCloudOffering implementation for InformationProtectionAwsOffering.
func (ipao InformationProtectionAwsOffering) AsDefenderForContainersGcpOffering() (*DefenderForContainersGcpOffering, bool) {
	return nil, false
}

// AsCspmMonitorGithubOffering is the BasicCloudOffering implementation for InformationProtectionAwsOffering.
func (ipao InformationProtectionAwsOffering) AsCspmMonitorGithubOffering() (*CspmMonitorGithubOffering, bool) {
	return nil, false
}

// AsCspmMonitorAzureDevOpsOffering is the BasicCloudOffering implementation for InformationProtectionAwsOffering.
func (ipao InformationProtectionAwsOffering) AsCspmMonitorAzureDevOpsOffering() (*CspmMonitorAzureDevOpsOffering, bool) {
	return nil, false
}

// AsDefenderCspmAwsOffering is the BasicCloudOffering implementation for InformationProtectionAwsOffering.
func (ipao InformationProtectionAwsOffering) AsDefenderCspmAwsOffering() (*DefenderCspmAwsOffering, bool) {
	return nil, false
}

// AsDefenderCspmGcpOffering is the BasicCloudOffering implementation for InformationProtectionAwsOffering.
func (ipao InformationProtectionAwsOffering) AsDefenderCspmGcpOffering() (*DefenderCspmGcpOffering, bool) {
	return nil, false
}

// AsDefenderForDevOpsGithubOffering is the BasicCloudOffering implementation for InformationProtectionAwsOffering.
func (ipao InformationProtectionAwsOffering) AsDefenderForDevOpsGithubOffering() (*DefenderForDevOpsGithubOffering, bool) {
	return nil, false
}

// AsDefenderForDevOpsAzureDevOpsOffering is the BasicCloudOffering implementation for InformationProtectionAwsOffering.
func (ipao InformationProtectionAwsOffering) AsDefenderForDevOpsAzureDevOpsOffering() (*DefenderForDevOpsAzureDevOpsOffering, bool) {
	return nil, false
}

// AsCloudOffering is the BasicCloudOffering implementation for InformationProtectionAwsOffering.
func (ipao InformationProtectionAwsOffering) AsCloudOffering() (*CloudOffering, bool) {
	return nil, false
}

// AsBasicCloudOffering is the BasicCloudOffering implementation for InformationProtectionAwsOffering.
func (ipao InformationProtectionAwsOffering) AsBasicCloudOffering() (BasicCloudOffering, bool) {
	return &ipao, true
}

// InformationProtectionAwsOfferingInformationProtection the native cloud connection configuration
type InformationProtectionAwsOfferingInformationProtection struct {
	// CloudRoleArn - The cloud role ARN in AWS for this feature
	CloudRoleArn *string `json:"cloudRoleArn,omitempty"`
}

// InformationProtectionKeyword the information type keyword.
type InformationProtectionKeyword struct {
	// Pattern - The keyword pattern.
	Pattern *string `json:"pattern,omitempty"`
	// Custom - Indicates whether the keyword is custom or not.
	Custom *bool `json:"custom,omitempty"`
	// CanBeNumeric - Indicates whether the keyword can be applied on numeric types or not.
	CanBeNumeric *bool `json:"canBeNumeric,omitempty"`
	// Excluded - Indicates whether the keyword is excluded or not.
	Excluded *bool `json:"excluded,omitempty"`
}

// InformationProtectionPolicy information protection policy.
type InformationProtectionPolicy struct {
	autorest.Response `json:"-"`
	// InformationProtectionPolicyProperties - Information protection policy data
	*InformationProtectionPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for InformationProtectionPolicy.
func (ipp InformationProtectionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ipp.InformationProtectionPolicyProperties != nil {
		objectMap["properties"] = ipp.InformationProtectionPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InformationProtectionPolicy struct.
func (ipp *InformationProtectionPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var informationProtectionPolicyProperties InformationProtectionPolicyProperties
				err = json.Unmarshal(*v, &informationProtectionPolicyProperties)
				if err != nil {
					return err
				}
				ipp.InformationProtectionPolicyProperties = &informationProtectionPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ipp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ipp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ipp.Type = &typeVar
			}
		}
	}

	return nil
}

// InformationProtectionPolicyList information protection policies response.
type InformationProtectionPolicyList struct {
	autorest.Response `json:"-"`
	// Value - List of information protection policies.
	Value *[]InformationProtectionPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for InformationProtectionPolicyList.
func (ippl InformationProtectionPolicyList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ippl.Value != nil {
		objectMap["value"] = ippl.Value
	}
	return json.Marshal(objectMap)
}

// InformationProtectionPolicyListIterator provides access to a complete listing of
// InformationProtectionPolicy values.
type InformationProtectionPolicyListIterator struct {
	i    int
	page InformationProtectionPolicyListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InformationProtectionPolicyListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InformationProtectionPolicyListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *InformationProtectionPolicyListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InformationProtectionPolicyListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InformationProtectionPolicyListIterator) Response() InformationProtectionPolicyList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InformationProtectionPolicyListIterator) Value() InformationProtectionPolicy {
	if !iter.page.NotDone() {
		return InformationProtectionPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the InformationProtectionPolicyListIterator type.
func NewInformationProtectionPolicyListIterator(page InformationProtectionPolicyListPage) InformationProtectionPolicyListIterator {
	return InformationProtectionPolicyListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ippl InformationProtectionPolicyList) IsEmpty() bool {
	return ippl.Value == nil || len(*ippl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ippl InformationProtectionPolicyList) hasNextLink() bool {
	return ippl.NextLink != nil && len(*ippl.NextLink) != 0
}

// informationProtectionPolicyListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ippl InformationProtectionPolicyList) informationProtectionPolicyListPreparer(ctx context.Context) (*http.Request, error) {
	if !ippl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ippl.NextLink)))
}

// InformationProtectionPolicyListPage contains a page of InformationProtectionPolicy values.
type InformationProtectionPolicyListPage struct {
	fn   func(context.Context, InformationProtectionPolicyList) (InformationProtectionPolicyList, error)
	ippl InformationProtectionPolicyList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InformationProtectionPolicyListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InformationProtectionPolicyListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ippl)
		if err != nil {
			return err
		}
		page.ippl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *InformationProtectionPolicyListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InformationProtectionPolicyListPage) NotDone() bool {
	return !page.ippl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InformationProtectionPolicyListPage) Response() InformationProtectionPolicyList {
	return page.ippl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InformationProtectionPolicyListPage) Values() []InformationProtectionPolicy {
	if page.ippl.IsEmpty() {
		return nil
	}
	return *page.ippl.Value
}

// Creates a new instance of the InformationProtectionPolicyListPage type.
func NewInformationProtectionPolicyListPage(cur InformationProtectionPolicyList, getNextPage func(context.Context, InformationProtectionPolicyList) (InformationProtectionPolicyList, error)) InformationProtectionPolicyListPage {
	return InformationProtectionPolicyListPage{
		fn:   getNextPage,
		ippl: cur,
	}
}

// InformationProtectionPolicyProperties describes properties of an information protection policy.
type InformationProtectionPolicyProperties struct {
	// LastModifiedUtc - READ-ONLY; Describes the last UTC time the policy was modified.
	LastModifiedUtc *date.Time `json:"lastModifiedUtc,omitempty"`
	// Version - READ-ONLY; Describes the version of the policy.
	Version *string `json:"version,omitempty"`
	// Labels - Dictionary of sensitivity labels.
	Labels map[string]*SensitivityLabel `json:"labels"`
	// InformationTypes - The sensitivity information types.
	InformationTypes map[string]*InformationType `json:"informationTypes"`
}

// MarshalJSON is the custom marshaler for InformationProtectionPolicyProperties.
func (ippp InformationProtectionPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ippp.Labels != nil {
		objectMap["labels"] = ippp.Labels
	}
	if ippp.InformationTypes != nil {
		objectMap["informationTypes"] = ippp.InformationTypes
	}
	return json.Marshal(objectMap)
}

// InformationType the information type.
type InformationType struct {
	// DisplayName - The name of the information type.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - The description of the information type.
	Description *string `json:"description,omitempty"`
	// Order - The order of the information type.
	Order *int32 `json:"order,omitempty"`
	// RecommendedLabelID - The recommended label id to be associated with this information type.
	RecommendedLabelID *uuid.UUID `json:"recommendedLabelId,omitempty"`
	// Enabled - Indicates whether the information type is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`
	// Custom - Indicates whether the information type is custom or not.
	Custom *bool `json:"custom,omitempty"`
	// Keywords - The information type keywords.
	Keywords *[]InformationProtectionKeyword `json:"keywords,omitempty"`
}

// IngestionConnectionString connection string for ingesting security data and logs
type IngestionConnectionString struct {
	// Location - READ-ONLY; The region where ingested logs and data resides
	Location *string `json:"location,omitempty"`
	// Value - READ-ONLY; Connection string value
	Value *string `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for IngestionConnectionString.
func (ics IngestionConnectionString) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// IngestionSetting configures how to correlate scan data and logs with resources associated with the
// subscription.
type IngestionSetting struct {
	autorest.Response `json:"-"`
	// Properties - Ingestion setting data
	Properties interface{} `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for IngestionSetting.
func (is IngestionSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if is.Properties != nil {
		objectMap["properties"] = is.Properties
	}
	return json.Marshal(objectMap)
}

// IngestionSettingList list of ingestion settings
type IngestionSettingList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of ingestion settings
	Value *[]IngestionSetting `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for IngestionSettingList.
func (isl IngestionSettingList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// IngestionSettingListIterator provides access to a complete listing of IngestionSetting values.
type IngestionSettingListIterator struct {
	i    int
	page IngestionSettingListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IngestionSettingListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IngestionSettingListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IngestionSettingListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IngestionSettingListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IngestionSettingListIterator) Response() IngestionSettingList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IngestionSettingListIterator) Value() IngestionSetting {
	if !iter.page.NotDone() {
		return IngestionSetting{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IngestionSettingListIterator type.
func NewIngestionSettingListIterator(page IngestionSettingListPage) IngestionSettingListIterator {
	return IngestionSettingListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (isl IngestionSettingList) IsEmpty() bool {
	return isl.Value == nil || len(*isl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (isl IngestionSettingList) hasNextLink() bool {
	return isl.NextLink != nil && len(*isl.NextLink) != 0
}

// ingestionSettingListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (isl IngestionSettingList) ingestionSettingListPreparer(ctx context.Context) (*http.Request, error) {
	if !isl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(isl.NextLink)))
}

// IngestionSettingListPage contains a page of IngestionSetting values.
type IngestionSettingListPage struct {
	fn  func(context.Context, IngestionSettingList) (IngestionSettingList, error)
	isl IngestionSettingList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IngestionSettingListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IngestionSettingListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.isl)
		if err != nil {
			return err
		}
		page.isl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IngestionSettingListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IngestionSettingListPage) NotDone() bool {
	return !page.isl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IngestionSettingListPage) Response() IngestionSettingList {
	return page.isl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IngestionSettingListPage) Values() []IngestionSetting {
	if page.isl.IsEmpty() {
		return nil
	}
	return *page.isl.Value
}

// Creates a new instance of the IngestionSettingListPage type.
func NewIngestionSettingListPage(cur IngestionSettingList, getNextPage func(context.Context, IngestionSettingList) (IngestionSettingList, error)) IngestionSettingListPage {
	return IngestionSettingListPage{
		fn:  getNextPage,
		isl: cur,
	}
}

// IngestionSettingToken configures how to correlate scan data and logs with resources associated with the
// subscription.
type IngestionSettingToken struct {
	autorest.Response `json:"-"`
	// Token - READ-ONLY; The token is used for correlating security data and logs with the resources in the subscription.
	Token *string `json:"token,omitempty"`
}

// MarshalJSON is the custom marshaler for IngestionSettingToken.
func (ist IngestionSettingToken) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// IoTSecurityAggregatedAlert security Solution Aggregated Alert information
type IoTSecurityAggregatedAlert struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// IoTSecurityAggregatedAlertProperties - IoT Security solution aggregated alert details.
	*IoTSecurityAggregatedAlertProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTSecurityAggregatedAlert.
func (itsaa IoTSecurityAggregatedAlert) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if itsaa.Tags != nil {
		objectMap["tags"] = itsaa.Tags
	}
	if itsaa.IoTSecurityAggregatedAlertProperties != nil {
		objectMap["properties"] = itsaa.IoTSecurityAggregatedAlertProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IoTSecurityAggregatedAlert struct.
func (itsaa *IoTSecurityAggregatedAlert) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				itsaa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				itsaa.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				itsaa.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				itsaa.Tags = tags
			}
		case "properties":
			if v != nil {
				var ioTSecurityAggregatedAlertProperties IoTSecurityAggregatedAlertProperties
				err = json.Unmarshal(*v, &ioTSecurityAggregatedAlertProperties)
				if err != nil {
					return err
				}
				itsaa.IoTSecurityAggregatedAlertProperties = &ioTSecurityAggregatedAlertProperties
			}
		}
	}

	return nil
}

// IoTSecurityAggregatedAlertList list of IoT Security solution aggregated alert data.
type IoTSecurityAggregatedAlertList struct {
	autorest.Response `json:"-"`
	// Value - List of aggregated alerts data.
	Value *[]IoTSecurityAggregatedAlert `json:"value,omitempty"`
	// NextLink - READ-ONLY; When there is too much alert data for one page, use this URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTSecurityAggregatedAlertList.
func (itsaal IoTSecurityAggregatedAlertList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if itsaal.Value != nil {
		objectMap["value"] = itsaal.Value
	}
	return json.Marshal(objectMap)
}

// IoTSecurityAggregatedAlertListIterator provides access to a complete listing of
// IoTSecurityAggregatedAlert values.
type IoTSecurityAggregatedAlertListIterator struct {
	i    int
	page IoTSecurityAggregatedAlertListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IoTSecurityAggregatedAlertListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IoTSecurityAggregatedAlertListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IoTSecurityAggregatedAlertListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IoTSecurityAggregatedAlertListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IoTSecurityAggregatedAlertListIterator) Response() IoTSecurityAggregatedAlertList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IoTSecurityAggregatedAlertListIterator) Value() IoTSecurityAggregatedAlert {
	if !iter.page.NotDone() {
		return IoTSecurityAggregatedAlert{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IoTSecurityAggregatedAlertListIterator type.
func NewIoTSecurityAggregatedAlertListIterator(page IoTSecurityAggregatedAlertListPage) IoTSecurityAggregatedAlertListIterator {
	return IoTSecurityAggregatedAlertListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (itsaal IoTSecurityAggregatedAlertList) IsEmpty() bool {
	return itsaal.Value == nil || len(*itsaal.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (itsaal IoTSecurityAggregatedAlertList) hasNextLink() bool {
	return itsaal.NextLink != nil && len(*itsaal.NextLink) != 0
}

// ioTSecurityAggregatedAlertListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (itsaal IoTSecurityAggregatedAlertList) ioTSecurityAggregatedAlertListPreparer(ctx context.Context) (*http.Request, error) {
	if !itsaal.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(itsaal.NextLink)))
}

// IoTSecurityAggregatedAlertListPage contains a page of IoTSecurityAggregatedAlert values.
type IoTSecurityAggregatedAlertListPage struct {
	fn     func(context.Context, IoTSecurityAggregatedAlertList) (IoTSecurityAggregatedAlertList, error)
	itsaal IoTSecurityAggregatedAlertList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IoTSecurityAggregatedAlertListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IoTSecurityAggregatedAlertListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.itsaal)
		if err != nil {
			return err
		}
		page.itsaal = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IoTSecurityAggregatedAlertListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IoTSecurityAggregatedAlertListPage) NotDone() bool {
	return !page.itsaal.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IoTSecurityAggregatedAlertListPage) Response() IoTSecurityAggregatedAlertList {
	return page.itsaal
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IoTSecurityAggregatedAlertListPage) Values() []IoTSecurityAggregatedAlert {
	if page.itsaal.IsEmpty() {
		return nil
	}
	return *page.itsaal.Value
}

// Creates a new instance of the IoTSecurityAggregatedAlertListPage type.
func NewIoTSecurityAggregatedAlertListPage(cur IoTSecurityAggregatedAlertList, getNextPage func(context.Context, IoTSecurityAggregatedAlertList) (IoTSecurityAggregatedAlertList, error)) IoTSecurityAggregatedAlertListPage {
	return IoTSecurityAggregatedAlertListPage{
		fn:     getNextPage,
		itsaal: cur,
	}
}

// IoTSecurityAggregatedAlertProperties ioT Security solution aggregated alert details.
type IoTSecurityAggregatedAlertProperties struct {
	// AlertType - READ-ONLY; Name of the alert type.
	AlertType *string `json:"alertType,omitempty"`
	// AlertDisplayName - READ-ONLY; Display name of the alert type.
	AlertDisplayName *string `json:"alertDisplayName,omitempty"`
	// AggregatedDateUtc - READ-ONLY; Date of detection.
	AggregatedDateUtc *date.Date `json:"aggregatedDateUtc,omitempty"`
	// VendorName - READ-ONLY; Name of the organization that raised the alert.
	VendorName *string `json:"vendorName,omitempty"`
	// ReportedSeverity - READ-ONLY; Assessed alert severity. Possible values include: 'ReportedSeverityInformational', 'ReportedSeverityLow', 'ReportedSeverityMedium', 'ReportedSeverityHigh'
	ReportedSeverity ReportedSeverity `json:"reportedSeverity,omitempty"`
	// RemediationSteps - READ-ONLY; Recommended steps for remediation.
	RemediationSteps *string `json:"remediationSteps,omitempty"`
	// Description - READ-ONLY; Description of the suspected vulnerability and meaning.
	Description *string `json:"description,omitempty"`
	// Count - READ-ONLY; Number of alerts occurrences within the aggregated time window.
	Count *int64 `json:"count,omitempty"`
	// EffectedResourceType - READ-ONLY; Azure resource ID of the resource that received the alerts.
	EffectedResourceType *string `json:"effectedResourceType,omitempty"`
	// SystemSource - READ-ONLY; The type of the alerted resource (Azure, Non-Azure).
	SystemSource *string `json:"systemSource,omitempty"`
	// ActionTaken - READ-ONLY; IoT Security solution alert response.
	ActionTaken *string `json:"actionTaken,omitempty"`
	// LogAnalyticsQuery - READ-ONLY; Log analytics query for getting the list of affected devices/alerts.
	LogAnalyticsQuery *string `json:"logAnalyticsQuery,omitempty"`
	// TopDevicesList - READ-ONLY; 10 devices with the highest number of occurrences of this alert type, on this day.
	TopDevicesList *[]IoTSecurityAggregatedAlertPropertiesTopDevicesListItem `json:"topDevicesList,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTSecurityAggregatedAlertProperties.
func (itsaap IoTSecurityAggregatedAlertProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// IoTSecurityAggregatedAlertPropertiesTopDevicesListItem ...
type IoTSecurityAggregatedAlertPropertiesTopDevicesListItem struct {
	// DeviceID - READ-ONLY; Name of the device.
	DeviceID *string `json:"deviceId,omitempty"`
	// AlertsCount - READ-ONLY; Number of alerts raised for this device.
	AlertsCount *int64 `json:"alertsCount,omitempty"`
	// LastOccurrence - READ-ONLY; Most recent time this alert was raised for this device, on this day.
	LastOccurrence *string `json:"lastOccurrence,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTSecurityAggregatedAlertPropertiesTopDevicesListItem.
func (itsaapDli IoTSecurityAggregatedAlertPropertiesTopDevicesListItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// IoTSecurityAggregatedRecommendation ioT Security solution recommendation information.
type IoTSecurityAggregatedRecommendation struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// IoTSecurityAggregatedRecommendationProperties - Security Solution data
	*IoTSecurityAggregatedRecommendationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTSecurityAggregatedRecommendation.
func (itsar IoTSecurityAggregatedRecommendation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if itsar.Tags != nil {
		objectMap["tags"] = itsar.Tags
	}
	if itsar.IoTSecurityAggregatedRecommendationProperties != nil {
		objectMap["properties"] = itsar.IoTSecurityAggregatedRecommendationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IoTSecurityAggregatedRecommendation struct.
func (itsar *IoTSecurityAggregatedRecommendation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				itsar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				itsar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				itsar.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				itsar.Tags = tags
			}
		case "properties":
			if v != nil {
				var ioTSecurityAggregatedRecommendationProperties IoTSecurityAggregatedRecommendationProperties
				err = json.Unmarshal(*v, &ioTSecurityAggregatedRecommendationProperties)
				if err != nil {
					return err
				}
				itsar.IoTSecurityAggregatedRecommendationProperties = &ioTSecurityAggregatedRecommendationProperties
			}
		}
	}

	return nil
}

// IoTSecurityAggregatedRecommendationList list of IoT Security solution aggregated recommendations.
type IoTSecurityAggregatedRecommendationList struct {
	autorest.Response `json:"-"`
	// Value - List of aggregated recommendations data.
	Value *[]IoTSecurityAggregatedRecommendation `json:"value,omitempty"`
	// NextLink - READ-ONLY; When there is too much alert data for one page, use this URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTSecurityAggregatedRecommendationList.
func (itsarl IoTSecurityAggregatedRecommendationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if itsarl.Value != nil {
		objectMap["value"] = itsarl.Value
	}
	return json.Marshal(objectMap)
}

// IoTSecurityAggregatedRecommendationListIterator provides access to a complete listing of
// IoTSecurityAggregatedRecommendation values.
type IoTSecurityAggregatedRecommendationListIterator struct {
	i    int
	page IoTSecurityAggregatedRecommendationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IoTSecurityAggregatedRecommendationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IoTSecurityAggregatedRecommendationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IoTSecurityAggregatedRecommendationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IoTSecurityAggregatedRecommendationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IoTSecurityAggregatedRecommendationListIterator) Response() IoTSecurityAggregatedRecommendationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IoTSecurityAggregatedRecommendationListIterator) Value() IoTSecurityAggregatedRecommendation {
	if !iter.page.NotDone() {
		return IoTSecurityAggregatedRecommendation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IoTSecurityAggregatedRecommendationListIterator type.
func NewIoTSecurityAggregatedRecommendationListIterator(page IoTSecurityAggregatedRecommendationListPage) IoTSecurityAggregatedRecommendationListIterator {
	return IoTSecurityAggregatedRecommendationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (itsarl IoTSecurityAggregatedRecommendationList) IsEmpty() bool {
	return itsarl.Value == nil || len(*itsarl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (itsarl IoTSecurityAggregatedRecommendationList) hasNextLink() bool {
	return itsarl.NextLink != nil && len(*itsarl.NextLink) != 0
}

// ioTSecurityAggregatedRecommendationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (itsarl IoTSecurityAggregatedRecommendationList) ioTSecurityAggregatedRecommendationListPreparer(ctx context.Context) (*http.Request, error) {
	if !itsarl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(itsarl.NextLink)))
}

// IoTSecurityAggregatedRecommendationListPage contains a page of IoTSecurityAggregatedRecommendation
// values.
type IoTSecurityAggregatedRecommendationListPage struct {
	fn     func(context.Context, IoTSecurityAggregatedRecommendationList) (IoTSecurityAggregatedRecommendationList, error)
	itsarl IoTSecurityAggregatedRecommendationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IoTSecurityAggregatedRecommendationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IoTSecurityAggregatedRecommendationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.itsarl)
		if err != nil {
			return err
		}
		page.itsarl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IoTSecurityAggregatedRecommendationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IoTSecurityAggregatedRecommendationListPage) NotDone() bool {
	return !page.itsarl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IoTSecurityAggregatedRecommendationListPage) Response() IoTSecurityAggregatedRecommendationList {
	return page.itsarl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IoTSecurityAggregatedRecommendationListPage) Values() []IoTSecurityAggregatedRecommendation {
	if page.itsarl.IsEmpty() {
		return nil
	}
	return *page.itsarl.Value
}

// Creates a new instance of the IoTSecurityAggregatedRecommendationListPage type.
func NewIoTSecurityAggregatedRecommendationListPage(cur IoTSecurityAggregatedRecommendationList, getNextPage func(context.Context, IoTSecurityAggregatedRecommendationList) (IoTSecurityAggregatedRecommendationList, error)) IoTSecurityAggregatedRecommendationListPage {
	return IoTSecurityAggregatedRecommendationListPage{
		fn:     getNextPage,
		itsarl: cur,
	}
}

// IoTSecurityAggregatedRecommendationProperties ioT Security solution aggregated recommendation
// information
type IoTSecurityAggregatedRecommendationProperties struct {
	// RecommendationName - Name of the recommendation.
	RecommendationName *string `json:"recommendationName,omitempty"`
	// RecommendationDisplayName - READ-ONLY; Display name of the recommendation type.
	RecommendationDisplayName *string `json:"recommendationDisplayName,omitempty"`
	// Description - READ-ONLY; Description of the suspected vulnerability and meaning.
	Description *string `json:"description,omitempty"`
	// RecommendationTypeID - READ-ONLY; Recommendation-type GUID.
	RecommendationTypeID *string `json:"recommendationTypeId,omitempty"`
	// DetectedBy - READ-ONLY; Name of the organization that made the recommendation.
	DetectedBy *string `json:"detectedBy,omitempty"`
	// RemediationSteps - READ-ONLY; Recommended steps for remediation
	RemediationSteps *string `json:"remediationSteps,omitempty"`
	// ReportedSeverity - READ-ONLY; Assessed recommendation severity. Possible values include: 'ReportedSeverityInformational', 'ReportedSeverityLow', 'ReportedSeverityMedium', 'ReportedSeverityHigh'
	ReportedSeverity ReportedSeverity `json:"reportedSeverity,omitempty"`
	// HealthyDevices - READ-ONLY; Number of healthy devices within the IoT Security solution.
	HealthyDevices *int64 `json:"healthyDevices,omitempty"`
	// UnhealthyDeviceCount - READ-ONLY; Number of unhealthy devices within the IoT Security solution.
	UnhealthyDeviceCount *int64 `json:"unhealthyDeviceCount,omitempty"`
	// LogAnalyticsQuery - READ-ONLY; Log analytics query for getting the list of affected devices/alerts.
	LogAnalyticsQuery *string `json:"logAnalyticsQuery,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTSecurityAggregatedRecommendationProperties.
func (itsarp IoTSecurityAggregatedRecommendationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if itsarp.RecommendationName != nil {
		objectMap["recommendationName"] = itsarp.RecommendationName
	}
	return json.Marshal(objectMap)
}

// IoTSecurityAlertedDevice statistical information about the number of alerts per device during last set
// number of days.
type IoTSecurityAlertedDevice struct {
	// DeviceID - READ-ONLY; Device identifier.
	DeviceID *string `json:"deviceId,omitempty"`
	// AlertsCount - READ-ONLY; Number of alerts raised for this device.
	AlertsCount *int64 `json:"alertsCount,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTSecurityAlertedDevice.
func (itsad IoTSecurityAlertedDevice) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// IoTSecurityDeviceAlert statistical information about the number of alerts per alert type during last set
// number of days
type IoTSecurityDeviceAlert struct {
	// AlertDisplayName - READ-ONLY; Display name of the alert
	AlertDisplayName *string `json:"alertDisplayName,omitempty"`
	// ReportedSeverity - READ-ONLY; Assessed Alert severity. Possible values include: 'ReportedSeverityInformational', 'ReportedSeverityLow', 'ReportedSeverityMedium', 'ReportedSeverityHigh'
	ReportedSeverity ReportedSeverity `json:"reportedSeverity,omitempty"`
	// AlertsCount - READ-ONLY; Number of alerts raised for this alert type.
	AlertsCount *int64 `json:"alertsCount,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTSecurityDeviceAlert.
func (itsda IoTSecurityDeviceAlert) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// IoTSecurityDeviceRecommendation statistical information about the number of recommendations per device,
// per recommendation type.
type IoTSecurityDeviceRecommendation struct {
	// RecommendationDisplayName - READ-ONLY; Display name of the recommendation.
	RecommendationDisplayName *string `json:"recommendationDisplayName,omitempty"`
	// ReportedSeverity - READ-ONLY; Assessed recommendation severity. Possible values include: 'ReportedSeverityInformational', 'ReportedSeverityLow', 'ReportedSeverityMedium', 'ReportedSeverityHigh'
	ReportedSeverity ReportedSeverity `json:"reportedSeverity,omitempty"`
	// DevicesCount - READ-ONLY; Number of devices with this recommendation.
	DevicesCount *int64 `json:"devicesCount,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTSecurityDeviceRecommendation.
func (itsdr IoTSecurityDeviceRecommendation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// IoTSecuritySolutionAnalyticsModel security analytics of your IoT Security solution
type IoTSecuritySolutionAnalyticsModel struct {
	autorest.Response `json:"-"`
	// IoTSecuritySolutionAnalyticsModelProperties - Security Solution  Aggregated Alert data
	*IoTSecuritySolutionAnalyticsModelProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTSecuritySolutionAnalyticsModel.
func (itssam IoTSecuritySolutionAnalyticsModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if itssam.IoTSecuritySolutionAnalyticsModelProperties != nil {
		objectMap["properties"] = itssam.IoTSecuritySolutionAnalyticsModelProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IoTSecuritySolutionAnalyticsModel struct.
func (itssam *IoTSecuritySolutionAnalyticsModel) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var ioTSecuritySolutionAnalyticsModelProperties IoTSecuritySolutionAnalyticsModelProperties
				err = json.Unmarshal(*v, &ioTSecuritySolutionAnalyticsModelProperties)
				if err != nil {
					return err
				}
				itssam.IoTSecuritySolutionAnalyticsModelProperties = &ioTSecuritySolutionAnalyticsModelProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				itssam.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				itssam.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				itssam.Type = &typeVar
			}
		}
	}

	return nil
}

// IoTSecuritySolutionAnalyticsModelList list of Security analytics of your IoT Security solution
type IoTSecuritySolutionAnalyticsModelList struct {
	autorest.Response `json:"-"`
	// Value - List of Security analytics of your IoT Security solution
	Value *[]IoTSecuritySolutionAnalyticsModel `json:"value,omitempty"`
	// NextLink - READ-ONLY; When there is too much alert data for one page, use this URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTSecuritySolutionAnalyticsModelList.
func (itssaml IoTSecuritySolutionAnalyticsModelList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if itssaml.Value != nil {
		objectMap["value"] = itssaml.Value
	}
	return json.Marshal(objectMap)
}

// IoTSecuritySolutionAnalyticsModelProperties security analytics properties of your IoT Security solution
type IoTSecuritySolutionAnalyticsModelProperties struct {
	// Metrics - READ-ONLY; Security analytics of your IoT Security solution.
	Metrics *IoTSeverityMetrics `json:"metrics,omitempty"`
	// UnhealthyDeviceCount - READ-ONLY; Number of unhealthy devices within your IoT Security solution.
	UnhealthyDeviceCount *int64 `json:"unhealthyDeviceCount,omitempty"`
	// DevicesMetrics - READ-ONLY; List of device metrics by the aggregation date.
	DevicesMetrics *[]IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem `json:"devicesMetrics,omitempty"`
	// TopAlertedDevices - List of the 3 devices with the most alerts.
	TopAlertedDevices *[]IoTSecurityAlertedDevice `json:"topAlertedDevices,omitempty"`
	// MostPrevalentDeviceAlerts - List of the 3 most prevalent device alerts.
	MostPrevalentDeviceAlerts *[]IoTSecurityDeviceAlert `json:"mostPrevalentDeviceAlerts,omitempty"`
	// MostPrevalentDeviceRecommendations - List of the 3 most prevalent device recommendations.
	MostPrevalentDeviceRecommendations *[]IoTSecurityDeviceRecommendation `json:"mostPrevalentDeviceRecommendations,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTSecuritySolutionAnalyticsModelProperties.
func (itssamp IoTSecuritySolutionAnalyticsModelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if itssamp.TopAlertedDevices != nil {
		objectMap["topAlertedDevices"] = itssamp.TopAlertedDevices
	}
	if itssamp.MostPrevalentDeviceAlerts != nil {
		objectMap["mostPrevalentDeviceAlerts"] = itssamp.MostPrevalentDeviceAlerts
	}
	if itssamp.MostPrevalentDeviceRecommendations != nil {
		objectMap["mostPrevalentDeviceRecommendations"] = itssamp.MostPrevalentDeviceRecommendations
	}
	return json.Marshal(objectMap)
}

// IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem ...
type IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem struct {
	// Date - Aggregation of IoT Security solution device alert metrics by date.
	Date *date.Time `json:"date,omitempty"`
	// DevicesMetrics - Device alert count by severity.
	DevicesMetrics *IoTSeverityMetrics `json:"devicesMetrics,omitempty"`
}

// IoTSecuritySolutionModel ioT Security solution configuration and resource information.
type IoTSecuritySolutionModel struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// IoTSecuritySolutionProperties - Security Solution data
	*IoTSecuritySolutionProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTSecuritySolutionModel.
func (itssm IoTSecuritySolutionModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if itssm.Tags != nil {
		objectMap["tags"] = itssm.Tags
	}
	if itssm.Location != nil {
		objectMap["location"] = itssm.Location
	}
	if itssm.IoTSecuritySolutionProperties != nil {
		objectMap["properties"] = itssm.IoTSecuritySolutionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IoTSecuritySolutionModel struct.
func (itssm *IoTSecuritySolutionModel) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				itssm.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				itssm.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				itssm.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				itssm.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				itssm.Location = &location
			}
		case "properties":
			if v != nil {
				var ioTSecuritySolutionProperties IoTSecuritySolutionProperties
				err = json.Unmarshal(*v, &ioTSecuritySolutionProperties)
				if err != nil {
					return err
				}
				itssm.IoTSecuritySolutionProperties = &ioTSecuritySolutionProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				itssm.SystemData = &systemData
			}
		}
	}

	return nil
}

// IoTSecuritySolutionProperties security Solution setting data
type IoTSecuritySolutionProperties struct {
	// Workspace - Workspace resource ID
	Workspace *string `json:"workspace,omitempty"`
	// DisplayName - Resource display name.
	DisplayName *string `json:"displayName,omitempty"`
	// Status - Status of the IoT Security solution. Possible values include: 'SolutionStatusEnabled', 'SolutionStatusDisabled'
	Status SolutionStatus `json:"status,omitempty"`
	// Export - List of additional options for exporting to workspace data.
	Export *[]ExportData `json:"export,omitempty"`
	// DisabledDataSources - Disabled data sources. Disabling these data sources compromises the system.
	DisabledDataSources *[]DataSource `json:"disabledDataSources,omitempty"`
	// IotHubs - IoT Hub resource IDs
	IotHubs              *[]string                       `json:"iotHubs,omitempty"`
	UserDefinedResources *UserDefinedResourcesProperties `json:"userDefinedResources,omitempty"`
	// AutoDiscoveredResources - READ-ONLY; List of resources that were automatically discovered as relevant to the security solution.
	AutoDiscoveredResources      *[]string                                `json:"autoDiscoveredResources,omitempty"`
	RecommendationsConfiguration *[]RecommendationConfigurationProperties `json:"recommendationsConfiguration,omitempty"`
	// UnmaskedIPLoggingStatus - Unmasked IP address logging status. Possible values include: 'UnmaskedIPLoggingStatusDisabled', 'UnmaskedIPLoggingStatusEnabled'
	UnmaskedIPLoggingStatus UnmaskedIPLoggingStatus `json:"unmaskedIpLoggingStatus,omitempty"`
	// AdditionalWorkspaces - List of additional workspaces
	AdditionalWorkspaces *[]AdditionalWorkspacesProperties `json:"additionalWorkspaces,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTSecuritySolutionProperties.
func (itssp IoTSecuritySolutionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if itssp.Workspace != nil {
		objectMap["workspace"] = itssp.Workspace
	}
	if itssp.DisplayName != nil {
		objectMap["displayName"] = itssp.DisplayName
	}
	if itssp.Status != "" {
		objectMap["status"] = itssp.Status
	}
	if itssp.Export != nil {
		objectMap["export"] = itssp.Export
	}
	if itssp.DisabledDataSources != nil {
		objectMap["disabledDataSources"] = itssp.DisabledDataSources
	}
	if itssp.IotHubs != nil {
		objectMap["iotHubs"] = itssp.IotHubs
	}
	if itssp.UserDefinedResources != nil {
		objectMap["userDefinedResources"] = itssp.UserDefinedResources
	}
	if itssp.RecommendationsConfiguration != nil {
		objectMap["recommendationsConfiguration"] = itssp.RecommendationsConfiguration
	}
	if itssp.UnmaskedIPLoggingStatus != "" {
		objectMap["unmaskedIpLoggingStatus"] = itssp.UnmaskedIPLoggingStatus
	}
	if itssp.AdditionalWorkspaces != nil {
		objectMap["additionalWorkspaces"] = itssp.AdditionalWorkspaces
	}
	return json.Marshal(objectMap)
}

// IoTSecuritySolutionsList list of IoT Security solutions.
type IoTSecuritySolutionsList struct {
	autorest.Response `json:"-"`
	// Value - List of IoT Security solutions
	Value *[]IoTSecuritySolutionModel `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTSecuritySolutionsList.
func (itssl IoTSecuritySolutionsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if itssl.Value != nil {
		objectMap["value"] = itssl.Value
	}
	return json.Marshal(objectMap)
}

// IoTSecuritySolutionsListIterator provides access to a complete listing of IoTSecuritySolutionModel
// values.
type IoTSecuritySolutionsListIterator struct {
	i    int
	page IoTSecuritySolutionsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IoTSecuritySolutionsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IoTSecuritySolutionsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IoTSecuritySolutionsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IoTSecuritySolutionsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IoTSecuritySolutionsListIterator) Response() IoTSecuritySolutionsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IoTSecuritySolutionsListIterator) Value() IoTSecuritySolutionModel {
	if !iter.page.NotDone() {
		return IoTSecuritySolutionModel{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IoTSecuritySolutionsListIterator type.
func NewIoTSecuritySolutionsListIterator(page IoTSecuritySolutionsListPage) IoTSecuritySolutionsListIterator {
	return IoTSecuritySolutionsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (itssl IoTSecuritySolutionsList) IsEmpty() bool {
	return itssl.Value == nil || len(*itssl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (itssl IoTSecuritySolutionsList) hasNextLink() bool {
	return itssl.NextLink != nil && len(*itssl.NextLink) != 0
}

// ioTSecuritySolutionsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (itssl IoTSecuritySolutionsList) ioTSecuritySolutionsListPreparer(ctx context.Context) (*http.Request, error) {
	if !itssl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(itssl.NextLink)))
}

// IoTSecuritySolutionsListPage contains a page of IoTSecuritySolutionModel values.
type IoTSecuritySolutionsListPage struct {
	fn    func(context.Context, IoTSecuritySolutionsList) (IoTSecuritySolutionsList, error)
	itssl IoTSecuritySolutionsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IoTSecuritySolutionsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IoTSecuritySolutionsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.itssl)
		if err != nil {
			return err
		}
		page.itssl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IoTSecuritySolutionsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IoTSecuritySolutionsListPage) NotDone() bool {
	return !page.itssl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IoTSecuritySolutionsListPage) Response() IoTSecuritySolutionsList {
	return page.itssl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IoTSecuritySolutionsListPage) Values() []IoTSecuritySolutionModel {
	if page.itssl.IsEmpty() {
		return nil
	}
	return *page.itssl.Value
}

// Creates a new instance of the IoTSecuritySolutionsListPage type.
func NewIoTSecuritySolutionsListPage(cur IoTSecuritySolutionsList, getNextPage func(context.Context, IoTSecuritySolutionsList) (IoTSecuritySolutionsList, error)) IoTSecuritySolutionsListPage {
	return IoTSecuritySolutionsListPage{
		fn:    getNextPage,
		itssl: cur,
	}
}

// IoTSeverityMetrics ioT Security solution analytics severity metrics.
type IoTSeverityMetrics struct {
	// High - Count of high severity alerts/recommendations.
	High *int64 `json:"high,omitempty"`
	// Medium - Count of medium severity alerts/recommendations.
	Medium *int64 `json:"medium,omitempty"`
	// Low - Count of low severity alerts/recommendations.
	Low *int64 `json:"low,omitempty"`
}

// JitNetworkAccessPoliciesList ...
type JitNetworkAccessPoliciesList struct {
	autorest.Response `json:"-"`
	Value             *[]JitNetworkAccessPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for JitNetworkAccessPoliciesList.
func (jnapl JitNetworkAccessPoliciesList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jnapl.Value != nil {
		objectMap["value"] = jnapl.Value
	}
	return json.Marshal(objectMap)
}

// JitNetworkAccessPoliciesListIterator provides access to a complete listing of JitNetworkAccessPolicy
// values.
type JitNetworkAccessPoliciesListIterator struct {
	i    int
	page JitNetworkAccessPoliciesListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JitNetworkAccessPoliciesListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JitNetworkAccessPoliciesListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JitNetworkAccessPoliciesListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JitNetworkAccessPoliciesListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JitNetworkAccessPoliciesListIterator) Response() JitNetworkAccessPoliciesList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JitNetworkAccessPoliciesListIterator) Value() JitNetworkAccessPolicy {
	if !iter.page.NotDone() {
		return JitNetworkAccessPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JitNetworkAccessPoliciesListIterator type.
func NewJitNetworkAccessPoliciesListIterator(page JitNetworkAccessPoliciesListPage) JitNetworkAccessPoliciesListIterator {
	return JitNetworkAccessPoliciesListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jnapl JitNetworkAccessPoliciesList) IsEmpty() bool {
	return jnapl.Value == nil || len(*jnapl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (jnapl JitNetworkAccessPoliciesList) hasNextLink() bool {
	return jnapl.NextLink != nil && len(*jnapl.NextLink) != 0
}

// jitNetworkAccessPoliciesListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jnapl JitNetworkAccessPoliciesList) jitNetworkAccessPoliciesListPreparer(ctx context.Context) (*http.Request, error) {
	if !jnapl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jnapl.NextLink)))
}

// JitNetworkAccessPoliciesListPage contains a page of JitNetworkAccessPolicy values.
type JitNetworkAccessPoliciesListPage struct {
	fn    func(context.Context, JitNetworkAccessPoliciesList) (JitNetworkAccessPoliciesList, error)
	jnapl JitNetworkAccessPoliciesList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JitNetworkAccessPoliciesListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JitNetworkAccessPoliciesListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.jnapl)
		if err != nil {
			return err
		}
		page.jnapl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JitNetworkAccessPoliciesListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JitNetworkAccessPoliciesListPage) NotDone() bool {
	return !page.jnapl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JitNetworkAccessPoliciesListPage) Response() JitNetworkAccessPoliciesList {
	return page.jnapl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JitNetworkAccessPoliciesListPage) Values() []JitNetworkAccessPolicy {
	if page.jnapl.IsEmpty() {
		return nil
	}
	return *page.jnapl.Value
}

// Creates a new instance of the JitNetworkAccessPoliciesListPage type.
func NewJitNetworkAccessPoliciesListPage(cur JitNetworkAccessPoliciesList, getNextPage func(context.Context, JitNetworkAccessPoliciesList) (JitNetworkAccessPoliciesList, error)) JitNetworkAccessPoliciesListPage {
	return JitNetworkAccessPoliciesListPage{
		fn:    getNextPage,
		jnapl: cur,
	}
}

// JitNetworkAccessPolicy ...
type JitNetworkAccessPolicy struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Kind - Kind of the resource
	Kind *string `json:"kind,omitempty"`
	// Location - READ-ONLY; Location where the resource is stored
	Location                          *string `json:"location,omitempty"`
	*JitNetworkAccessPolicyProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for JitNetworkAccessPolicy.
func (jnap JitNetworkAccessPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jnap.Kind != nil {
		objectMap["kind"] = jnap.Kind
	}
	if jnap.JitNetworkAccessPolicyProperties != nil {
		objectMap["properties"] = jnap.JitNetworkAccessPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JitNetworkAccessPolicy struct.
func (jnap *JitNetworkAccessPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				jnap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				jnap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				jnap.Type = &typeVar
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				jnap.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				jnap.Location = &location
			}
		case "properties":
			if v != nil {
				var jitNetworkAccessPolicyProperties JitNetworkAccessPolicyProperties
				err = json.Unmarshal(*v, &jitNetworkAccessPolicyProperties)
				if err != nil {
					return err
				}
				jnap.JitNetworkAccessPolicyProperties = &jitNetworkAccessPolicyProperties
			}
		}
	}

	return nil
}

// JitNetworkAccessPolicyInitiatePort ...
type JitNetworkAccessPolicyInitiatePort struct {
	Number *int32 `json:"number,omitempty"`
	// AllowedSourceAddressPrefix - Source of the allowed traffic. If omitted, the request will be for the source IP address of the initiate request.
	AllowedSourceAddressPrefix *string `json:"allowedSourceAddressPrefix,omitempty"`
	// EndTimeUtc - The time to close the request in UTC
	EndTimeUtc *date.Time `json:"endTimeUtc,omitempty"`
}

// JitNetworkAccessPolicyInitiateRequest ...
type JitNetworkAccessPolicyInitiateRequest struct {
	// VirtualMachines - A list of virtual machines & ports to open access for
	VirtualMachines *[]JitNetworkAccessPolicyInitiateVirtualMachine `json:"virtualMachines,omitempty"`
	// Justification - The justification for making the initiate request
	Justification *string `json:"justification,omitempty"`
}

// JitNetworkAccessPolicyInitiateVirtualMachine ...
type JitNetworkAccessPolicyInitiateVirtualMachine struct {
	// ID - Resource ID of the virtual machine that is linked to this policy
	ID *string `json:"id,omitempty"`
	// Ports - The ports to open for the resource with the `id`
	Ports *[]JitNetworkAccessPolicyInitiatePort `json:"ports,omitempty"`
}

// JitNetworkAccessPolicyProperties ...
type JitNetworkAccessPolicyProperties struct {
	// VirtualMachines - Configurations for Microsoft.Compute/virtualMachines resource type.
	VirtualMachines *[]JitNetworkAccessPolicyVirtualMachine `json:"virtualMachines,omitempty"`
	Requests        *[]JitNetworkAccessRequest              `json:"requests,omitempty"`
	// ProvisioningState - READ-ONLY; Gets the provisioning state of the Just-in-Time policy.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for JitNetworkAccessPolicyProperties.
func (jnapp JitNetworkAccessPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jnapp.VirtualMachines != nil {
		objectMap["virtualMachines"] = jnapp.VirtualMachines
	}
	if jnapp.Requests != nil {
		objectMap["requests"] = jnapp.Requests
	}
	return json.Marshal(objectMap)
}

// JitNetworkAccessPolicyVirtualMachine ...
type JitNetworkAccessPolicyVirtualMachine struct {
	// ID - Resource ID of the virtual machine that is linked to this policy
	ID *string `json:"id,omitempty"`
	// Ports - Port configurations for the virtual machine
	Ports *[]JitNetworkAccessPortRule `json:"ports,omitempty"`
	// PublicIPAddress - Public IP address of the Azure Firewall that is linked to this policy, if applicable
	PublicIPAddress *string `json:"publicIpAddress,omitempty"`
}

// JitNetworkAccessPortRule ...
type JitNetworkAccessPortRule struct {
	Number *int32 `json:"number,omitempty"`
	// Protocol - Possible values include: 'TCP', 'UDP', 'All'
	Protocol Protocol `json:"protocol,omitempty"`
	// AllowedSourceAddressPrefix - Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
	AllowedSourceAddressPrefix *string `json:"allowedSourceAddressPrefix,omitempty"`
	// AllowedSourceAddressPrefixes - Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
	AllowedSourceAddressPrefixes *[]string `json:"allowedSourceAddressPrefixes,omitempty"`
	// MaxRequestAccessDuration - Maximum duration requests can be made for. In ISO 8601 duration format. Minimum 5 minutes, maximum 1 day
	MaxRequestAccessDuration *string `json:"maxRequestAccessDuration,omitempty"`
}

// JitNetworkAccessRequest ...
type JitNetworkAccessRequest struct {
	autorest.Response `json:"-"`
	VirtualMachines   *[]JitNetworkAccessRequestVirtualMachine `json:"virtualMachines,omitempty"`
	// StartTimeUtc - The start time of the request in UTC
	StartTimeUtc *date.Time `json:"startTimeUtc,omitempty"`
	// Requestor - The identity of the person who made the request
	Requestor *string `json:"requestor,omitempty"`
	// Justification - The justification for making the initiate request
	Justification *string `json:"justification,omitempty"`
}

// JitNetworkAccessRequestPort ...
type JitNetworkAccessRequestPort struct {
	Number *int32 `json:"number,omitempty"`
	// AllowedSourceAddressPrefix - Mutually exclusive with the "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
	AllowedSourceAddressPrefix *string `json:"allowedSourceAddressPrefix,omitempty"`
	// AllowedSourceAddressPrefixes - Mutually exclusive with the "allowedSourceAddressPrefix" parameter.
	AllowedSourceAddressPrefixes *[]string `json:"allowedSourceAddressPrefixes,omitempty"`
	// EndTimeUtc - The date & time at which the request ends in UTC
	EndTimeUtc *date.Time `json:"endTimeUtc,omitempty"`
	// Status - The status of the port. Possible values include: 'Revoked', 'Initiated'
	Status Status `json:"status,omitempty"`
	// StatusReason - A description of why the `status` has its value. Possible values include: 'StatusReasonExpired', 'StatusReasonUserRequested', 'StatusReasonNewerRequestInitiated'
	StatusReason StatusReason `json:"statusReason,omitempty"`
	// MappedPort - The port which is mapped to this port's `number` in the Azure Firewall, if applicable
	MappedPort *int32 `json:"mappedPort,omitempty"`
}

// JitNetworkAccessRequestVirtualMachine ...
type JitNetworkAccessRequestVirtualMachine struct {
	// ID - Resource ID of the virtual machine that is linked to this policy
	ID *string `json:"id,omitempty"`
	// Ports - The ports that were opened for the virtual machine
	Ports *[]JitNetworkAccessRequestPort `json:"ports,omitempty"`
}

// Kind describes an Azure resource with kind
type Kind struct {
	// Kind - Kind of the resource
	Kind *string `json:"kind,omitempty"`
}

// BasicListCustomAlertRule a List custom alert rule.
type BasicListCustomAlertRule interface {
	AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool)
	AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool)
	AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool)
	AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool)
	AsConnectionFromIPNotAllowed() (*ConnectionFromIPNotAllowed, bool)
	AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool)
	AsProcessNotAllowed() (*ProcessNotAllowed, bool)
	AsListCustomAlertRule() (*ListCustomAlertRule, bool)
}

// ListCustomAlertRule a List custom alert rule.
type ListCustomAlertRule struct {
	// ValueType - READ-ONLY; The value type of the items in the list. Possible values include: 'ValueTypeIPCidr', 'ValueTypeString'
	ValueType ValueType `json:"valueType,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeConnectionFromIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

func unmarshalBasicListCustomAlertRule(body []byte) (BasicListCustomAlertRule, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["ruleType"] {
	case string(RuleTypeAllowlistCustomAlertRule):
		var acar AllowlistCustomAlertRule
		err := json.Unmarshal(body, &acar)
		return acar, err
	case string(RuleTypeDenylistCustomAlertRule):
		var dcar DenylistCustomAlertRule
		err := json.Unmarshal(body, &dcar)
		return dcar, err
	case string(RuleTypeConnectionToIPNotAllowed):
		var ctina ConnectionToIPNotAllowed
		err := json.Unmarshal(body, &ctina)
		return ctina, err
	case string(RuleTypeConnectionFromIPNotAllowed):
		var cfina ConnectionFromIPNotAllowed
		err := json.Unmarshal(body, &cfina)
		return cfina, err
	case string(RuleTypeLocalUserNotAllowed):
		var luna LocalUserNotAllowed
		err := json.Unmarshal(body, &luna)
		return luna, err
	case string(RuleTypeProcessNotAllowed):
		var pna ProcessNotAllowed
		err := json.Unmarshal(body, &pna)
		return pna, err
	default:
		var lcar ListCustomAlertRule
		err := json.Unmarshal(body, &lcar)
		return lcar, err
	}
}
func unmarshalBasicListCustomAlertRuleArray(body []byte) ([]BasicListCustomAlertRule, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	lcarArray := make([]BasicListCustomAlertRule, len(rawMessages))

	for index, rawMessage := range rawMessages {
		lcar, err := unmarshalBasicListCustomAlertRule(*rawMessage)
		if err != nil {
			return nil, err
		}
		lcarArray[index] = lcar
	}
	return lcarArray, nil
}

// MarshalJSON is the custom marshaler for ListCustomAlertRule.
func (lcar ListCustomAlertRule) MarshalJSON() ([]byte, error) {
	lcar.RuleType = RuleTypeListCustomAlertRule
	objectMap := make(map[string]interface{})
	if lcar.IsEnabled != nil {
		objectMap["isEnabled"] = lcar.IsEnabled
	}
	if lcar.RuleType != "" {
		objectMap["ruleType"] = lcar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return &lcar, true
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return &lcar, true
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsConnectionFromIPNotAllowed is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsConnectionFromIPNotAllowed() (*ConnectionFromIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for ListCustomAlertRule.
func (lcar ListCustomAlertRule) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &lcar, true
}

// LocalUserNotAllowed login by a local user that isn't allowed. Allow list consists of login names to
// allow.
type LocalUserNotAllowed struct {
	// AllowlistValues - The values to allow. The format of the values depends on the rule type.
	AllowlistValues *[]string `json:"allowlistValues,omitempty"`
	// ValueType - READ-ONLY; The value type of the items in the list. Possible values include: 'ValueTypeIPCidr', 'ValueTypeString'
	ValueType ValueType `json:"valueType,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeConnectionFromIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) MarshalJSON() ([]byte, error) {
	luna.RuleType = RuleTypeLocalUserNotAllowed
	objectMap := make(map[string]interface{})
	if luna.AllowlistValues != nil {
		objectMap["allowlistValues"] = luna.AllowlistValues
	}
	if luna.IsEnabled != nil {
		objectMap["isEnabled"] = luna.IsEnabled
	}
	if luna.RuleType != "" {
		objectMap["ruleType"] = luna.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return &luna, true
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return &luna, true
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsConnectionFromIPNotAllowed is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsConnectionFromIPNotAllowed() (*ConnectionFromIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return &luna, true
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for LocalUserNotAllowed.
func (luna LocalUserNotAllowed) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &luna, true
}

// Location describes an Azure resource with location
type Location struct {
	// Location - READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for Location.
func (l Location) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// LogAnalyticsIdentifier represents a Log Analytics workspace scope identifier.
type LogAnalyticsIdentifier struct {
	// WorkspaceID - READ-ONLY; The LogAnalytics workspace id that stores this alert.
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// WorkspaceSubscriptionID - READ-ONLY; The azure subscription id for the LogAnalytics workspace storing this alert.
	WorkspaceSubscriptionID *string `json:"workspaceSubscriptionId,omitempty"`
	// WorkspaceResourceGroup - READ-ONLY; The azure resource group for the LogAnalytics workspace storing this alert
	WorkspaceResourceGroup *string `json:"workspaceResourceGroup,omitempty"`
	// AgentID - READ-ONLY; (optional) The LogAnalytics agent id reporting the event that this alert is based on.
	AgentID *string `json:"agentId,omitempty"`
	// Type - Possible values include: 'TypeResourceIdentifier', 'TypeAzureResource', 'TypeLogAnalytics'
	Type TypeBasicResourceIdentifier `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for LogAnalyticsIdentifier.
func (lai LogAnalyticsIdentifier) MarshalJSON() ([]byte, error) {
	lai.Type = TypeLogAnalytics
	objectMap := make(map[string]interface{})
	if lai.Type != "" {
		objectMap["type"] = lai.Type
	}
	return json.Marshal(objectMap)
}

// AsAzureResourceIdentifier is the BasicResourceIdentifier implementation for LogAnalyticsIdentifier.
func (lai LogAnalyticsIdentifier) AsAzureResourceIdentifier() (*AzureResourceIdentifier, bool) {
	return nil, false
}

// AsLogAnalyticsIdentifier is the BasicResourceIdentifier implementation for LogAnalyticsIdentifier.
func (lai LogAnalyticsIdentifier) AsLogAnalyticsIdentifier() (*LogAnalyticsIdentifier, bool) {
	return &lai, true
}

// AsResourceIdentifier is the BasicResourceIdentifier implementation for LogAnalyticsIdentifier.
func (lai LogAnalyticsIdentifier) AsResourceIdentifier() (*ResourceIdentifier, bool) {
	return nil, false
}

// AsBasicResourceIdentifier is the BasicResourceIdentifier implementation for LogAnalyticsIdentifier.
func (lai LogAnalyticsIdentifier) AsBasicResourceIdentifier() (BasicResourceIdentifier, bool) {
	return &lai, true
}

// MdeOnboardingData the resource of the configuration or data needed to onboard the machine to MDE
type MdeOnboardingData struct {
	autorest.Response            `json:"-"`
	*MdeOnboardingDataProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for MdeOnboardingData.
func (mod MdeOnboardingData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mod.MdeOnboardingDataProperties != nil {
		objectMap["properties"] = mod.MdeOnboardingDataProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MdeOnboardingData struct.
func (mod *MdeOnboardingData) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mdeOnboardingDataProperties MdeOnboardingDataProperties
				err = json.Unmarshal(*v, &mdeOnboardingDataProperties)
				if err != nil {
					return err
				}
				mod.MdeOnboardingDataProperties = &mdeOnboardingDataProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mod.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mod.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mod.Type = &typeVar
			}
		}
	}

	return nil
}

// MdeOnboardingDataList list of all MDE onboarding data resources
type MdeOnboardingDataList struct {
	autorest.Response `json:"-"`
	// Value - List of the resources of the configuration or data needed to onboard the machine to MDE
	Value *[]MdeOnboardingData `json:"value,omitempty"`
}

// MdeOnboardingDataProperties properties of the MDE configuration or data parameter needed to onboard the
// machine to MDE
type MdeOnboardingDataProperties struct {
	// OnboardingPackageWindows - The onboarding package used to onboard Windows machines to MDE, coded in base64. This can also be used for onboarding using the dedicated VM Extension
	OnboardingPackageWindows *[]byte `json:"onboardingPackageWindows,omitempty"`
	// OnboardingPackageLinux - The onboarding package used to onboard Linux machines to MDE, coded in base64. This can also be used for onboarding using the dedicated VM Extension
	OnboardingPackageLinux *[]byte `json:"onboardingPackageLinux,omitempty"`
}

// MqttC2DMessagesNotInAllowedRange number of cloud to device messages (MQTT protocol) is not in allowed
// range.
type MqttC2DMessagesNotInAllowedRange struct {
	// TimeWindowSize - The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeConnectionFromIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	mcmniar.RuleType = RuleTypeMqttC2DMessagesNotInAllowedRange
	objectMap := make(map[string]interface{})
	if mcmniar.TimeWindowSize != nil {
		objectMap["timeWindowSize"] = mcmniar.TimeWindowSize
	}
	if mcmniar.MinThreshold != nil {
		objectMap["minThreshold"] = mcmniar.MinThreshold
	}
	if mcmniar.MaxThreshold != nil {
		objectMap["maxThreshold"] = mcmniar.MaxThreshold
	}
	if mcmniar.IsEnabled != nil {
		objectMap["isEnabled"] = mcmniar.IsEnabled
	}
	if mcmniar.RuleType != "" {
		objectMap["ruleType"] = mcmniar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return &mcmniar, true
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return &mcmniar, true
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsConnectionFromIPNotAllowed is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsConnectionFromIPNotAllowed() (*ConnectionFromIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return &mcmniar, true
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DMessagesNotInAllowedRange.
func (mcmniar MqttC2DMessagesNotInAllowedRange) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &mcmniar, true
}

// MqttC2DRejectedMessagesNotInAllowedRange number of rejected cloud to device messages (MQTT protocol) is
// not in allowed range.
type MqttC2DRejectedMessagesNotInAllowedRange struct {
	// TimeWindowSize - The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeConnectionFromIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	mcrmniar.RuleType = RuleTypeMqttC2DRejectedMessagesNotInAllowedRange
	objectMap := make(map[string]interface{})
	if mcrmniar.TimeWindowSize != nil {
		objectMap["timeWindowSize"] = mcrmniar.TimeWindowSize
	}
	if mcrmniar.MinThreshold != nil {
		objectMap["minThreshold"] = mcrmniar.MinThreshold
	}
	if mcrmniar.MaxThreshold != nil {
		objectMap["maxThreshold"] = mcrmniar.MaxThreshold
	}
	if mcrmniar.IsEnabled != nil {
		objectMap["isEnabled"] = mcrmniar.IsEnabled
	}
	if mcrmniar.RuleType != "" {
		objectMap["ruleType"] = mcrmniar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return &mcrmniar, true
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return &mcrmniar, true
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsConnectionFromIPNotAllowed is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsConnectionFromIPNotAllowed() (*ConnectionFromIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return &mcrmniar, true
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for MqttC2DRejectedMessagesNotInAllowedRange.
func (mcrmniar MqttC2DRejectedMessagesNotInAllowedRange) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &mcrmniar, true
}

// MqttD2CMessagesNotInAllowedRange number of device to cloud messages (MQTT protocol) is not in allowed
// range.
type MqttD2CMessagesNotInAllowedRange struct {
	// TimeWindowSize - The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeConnectionFromIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	mdmniar.RuleType = RuleTypeMqttD2CMessagesNotInAllowedRange
	objectMap := make(map[string]interface{})
	if mdmniar.TimeWindowSize != nil {
		objectMap["timeWindowSize"] = mdmniar.TimeWindowSize
	}
	if mdmniar.MinThreshold != nil {
		objectMap["minThreshold"] = mdmniar.MinThreshold
	}
	if mdmniar.MaxThreshold != nil {
		objectMap["maxThreshold"] = mdmniar.MaxThreshold
	}
	if mdmniar.IsEnabled != nil {
		objectMap["isEnabled"] = mdmniar.IsEnabled
	}
	if mdmniar.RuleType != "" {
		objectMap["ruleType"] = mdmniar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return &mdmniar, true
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return &mdmniar, true
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsConnectionFromIPNotAllowed is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsConnectionFromIPNotAllowed() (*ConnectionFromIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return &mdmniar, true
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for MqttD2CMessagesNotInAllowedRange.
func (mdmniar MqttD2CMessagesNotInAllowedRange) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &mdmniar, true
}

// BasicOnPremiseResourceDetails details of the On Premise resource that was assessed
type BasicOnPremiseResourceDetails interface {
	AsOnPremiseSQLResourceDetails() (*OnPremiseSQLResourceDetails, bool)
	AsOnPremiseResourceDetails() (*OnPremiseResourceDetails, bool)
}

// OnPremiseResourceDetails details of the On Premise resource that was assessed
type OnPremiseResourceDetails struct {
	// WorkspaceID - Azure resource Id of the workspace the machine is attached to
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// Vmuuid - The unique Id of the machine
	Vmuuid *string `json:"vmuuid,omitempty"`
	// SourceComputerID - The oms agent Id installed on the machine
	SourceComputerID *string `json:"sourceComputerId,omitempty"`
	// MachineName - The name of the machine
	MachineName *string `json:"machineName,omitempty"`
	// Source - Possible values include: 'SourceResourceDetails', 'SourceOnPremiseSQL', 'SourceOnPremise', 'SourceAzure'
	Source Source `json:"source,omitempty"`
}

func unmarshalBasicOnPremiseResourceDetails(body []byte) (BasicOnPremiseResourceDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["source"] {
	case string(SourceOnPremiseSQL):
		var opsrd OnPremiseSQLResourceDetails
		err := json.Unmarshal(body, &opsrd)
		return opsrd, err
	default:
		var oprd OnPremiseResourceDetails
		err := json.Unmarshal(body, &oprd)
		return oprd, err
	}
}
func unmarshalBasicOnPremiseResourceDetailsArray(body []byte) ([]BasicOnPremiseResourceDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	oprdArray := make([]BasicOnPremiseResourceDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		oprd, err := unmarshalBasicOnPremiseResourceDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		oprdArray[index] = oprd
	}
	return oprdArray, nil
}

// MarshalJSON is the custom marshaler for OnPremiseResourceDetails.
func (oprd OnPremiseResourceDetails) MarshalJSON() ([]byte, error) {
	oprd.Source = SourceOnPremise
	objectMap := make(map[string]interface{})
	if oprd.WorkspaceID != nil {
		objectMap["workspaceId"] = oprd.WorkspaceID
	}
	if oprd.Vmuuid != nil {
		objectMap["vmuuid"] = oprd.Vmuuid
	}
	if oprd.SourceComputerID != nil {
		objectMap["sourceComputerId"] = oprd.SourceComputerID
	}
	if oprd.MachineName != nil {
		objectMap["machineName"] = oprd.MachineName
	}
	if oprd.Source != "" {
		objectMap["source"] = oprd.Source
	}
	return json.Marshal(objectMap)
}

// AsOnPremiseSQLResourceDetails is the BasicResourceDetails implementation for OnPremiseResourceDetails.
func (oprd OnPremiseResourceDetails) AsOnPremiseSQLResourceDetails() (*OnPremiseSQLResourceDetails, bool) {
	return nil, false
}

// AsOnPremiseResourceDetails is the BasicResourceDetails implementation for OnPremiseResourceDetails.
func (oprd OnPremiseResourceDetails) AsOnPremiseResourceDetails() (*OnPremiseResourceDetails, bool) {
	return &oprd, true
}

// AsBasicOnPremiseResourceDetails is the BasicResourceDetails implementation for OnPremiseResourceDetails.
func (oprd OnPremiseResourceDetails) AsBasicOnPremiseResourceDetails() (BasicOnPremiseResourceDetails, bool) {
	return &oprd, true
}

// AsAzureResourceDetails is the BasicResourceDetails implementation for OnPremiseResourceDetails.
func (oprd OnPremiseResourceDetails) AsAzureResourceDetails() (*AzureResourceDetails, bool) {
	return nil, false
}

// AsResourceDetails is the BasicResourceDetails implementation for OnPremiseResourceDetails.
func (oprd OnPremiseResourceDetails) AsResourceDetails() (*ResourceDetails, bool) {
	return nil, false
}

// AsBasicResourceDetails is the BasicResourceDetails implementation for OnPremiseResourceDetails.
func (oprd OnPremiseResourceDetails) AsBasicResourceDetails() (BasicResourceDetails, bool) {
	return &oprd, true
}

// OnPremiseSQLResourceDetails details of the On Premise Sql resource that was assessed
type OnPremiseSQLResourceDetails struct {
	// ServerName - The Sql server name installed on the machine
	ServerName *string `json:"serverName,omitempty"`
	// DatabaseName - The Sql database name installed on the machine
	DatabaseName *string `json:"databaseName,omitempty"`
	// WorkspaceID - Azure resource Id of the workspace the machine is attached to
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// Vmuuid - The unique Id of the machine
	Vmuuid *string `json:"vmuuid,omitempty"`
	// SourceComputerID - The oms agent Id installed on the machine
	SourceComputerID *string `json:"sourceComputerId,omitempty"`
	// MachineName - The name of the machine
	MachineName *string `json:"machineName,omitempty"`
	// Source - Possible values include: 'SourceResourceDetails', 'SourceOnPremiseSQL', 'SourceOnPremise', 'SourceAzure'
	Source Source `json:"source,omitempty"`
}

// MarshalJSON is the custom marshaler for OnPremiseSQLResourceDetails.
func (opsrd OnPremiseSQLResourceDetails) MarshalJSON() ([]byte, error) {
	opsrd.Source = SourceOnPremiseSQL
	objectMap := make(map[string]interface{})
	if opsrd.ServerName != nil {
		objectMap["serverName"] = opsrd.ServerName
	}
	if opsrd.DatabaseName != nil {
		objectMap["databaseName"] = opsrd.DatabaseName
	}
	if opsrd.WorkspaceID != nil {
		objectMap["workspaceId"] = opsrd.WorkspaceID
	}
	if opsrd.Vmuuid != nil {
		objectMap["vmuuid"] = opsrd.Vmuuid
	}
	if opsrd.SourceComputerID != nil {
		objectMap["sourceComputerId"] = opsrd.SourceComputerID
	}
	if opsrd.MachineName != nil {
		objectMap["machineName"] = opsrd.MachineName
	}
	if opsrd.Source != "" {
		objectMap["source"] = opsrd.Source
	}
	return json.Marshal(objectMap)
}

// AsOnPremiseSQLResourceDetails is the BasicResourceDetails implementation for OnPremiseSQLResourceDetails.
func (opsrd OnPremiseSQLResourceDetails) AsOnPremiseSQLResourceDetails() (*OnPremiseSQLResourceDetails, bool) {
	return &opsrd, true
}

// AsOnPremiseResourceDetails is the BasicResourceDetails implementation for OnPremiseSQLResourceDetails.
func (opsrd OnPremiseSQLResourceDetails) AsOnPremiseResourceDetails() (*OnPremiseResourceDetails, bool) {
	return nil, false
}

// AsBasicOnPremiseResourceDetails is the BasicResourceDetails implementation for OnPremiseSQLResourceDetails.
func (opsrd OnPremiseSQLResourceDetails) AsBasicOnPremiseResourceDetails() (BasicOnPremiseResourceDetails, bool) {
	return &opsrd, true
}

// AsAzureResourceDetails is the BasicResourceDetails implementation for OnPremiseSQLResourceDetails.
func (opsrd OnPremiseSQLResourceDetails) AsAzureResourceDetails() (*AzureResourceDetails, bool) {
	return nil, false
}

// AsResourceDetails is the BasicResourceDetails implementation for OnPremiseSQLResourceDetails.
func (opsrd OnPremiseSQLResourceDetails) AsResourceDetails() (*ResourceDetails, bool) {
	return nil, false
}

// AsBasicResourceDetails is the BasicResourceDetails implementation for OnPremiseSQLResourceDetails.
func (opsrd OnPremiseSQLResourceDetails) AsBasicResourceDetails() (BasicResourceDetails, bool) {
	return &opsrd, true
}

// Operation possible operation in the REST API of Microsoft.Security
type Operation struct {
	// Name - READ-ONLY; Name of the operation
	Name *string `json:"name,omitempty"`
	// Origin - READ-ONLY; Where the operation is originated
	Origin  *string           `json:"origin,omitempty"`
	Display *OperationDisplay `json:"display,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	return json.Marshal(objectMap)
}

// OperationDisplay security operation display
type OperationDisplay struct {
	// Provider - READ-ONLY; The resource provider for the operation.
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; The display name of the resource the operation applies to.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; The display name of the security operation.
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; The description of the operation.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationDisplay.
func (od OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationList list of possible operations for Microsoft.Security resource provider
type OperationList struct {
	autorest.Response `json:"-"`
	// Value - List of Security operations
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationList.
func (ol OperationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ol.Value != nil {
		objectMap["value"] = ol.Value
	}
	return json.Marshal(objectMap)
}

// OperationListIterator provides access to a complete listing of Operation values.
type OperationListIterator struct {
	i    int
	page OperationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListIterator) Response() OperationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListIterator type.
func NewOperationListIterator(page OperationListPage) OperationListIterator {
	return OperationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ol OperationList) IsEmpty() bool {
	return ol.Value == nil || len(*ol.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ol OperationList) hasNextLink() bool {
	return ol.NextLink != nil && len(*ol.NextLink) != 0
}

// operationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ol OperationList) operationListPreparer(ctx context.Context) (*http.Request, error) {
	if !ol.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ol.NextLink)))
}

// OperationListPage contains a page of Operation values.
type OperationListPage struct {
	fn func(context.Context, OperationList) (OperationList, error)
	ol OperationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ol)
		if err != nil {
			return err
		}
		page.ol = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListPage) NotDone() bool {
	return !page.ol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListPage) Response() OperationList {
	return page.ol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListPage) Values() []Operation {
	if page.ol.IsEmpty() {
		return nil
	}
	return *page.ol.Value
}

// Creates a new instance of the OperationListPage type.
func NewOperationListPage(cur OperationList, getNextPage func(context.Context, OperationList) (OperationList, error)) OperationListPage {
	return OperationListPage{
		fn: getNextPage,
		ol: cur,
	}
}

// PathRecommendation represents a path that is recommended to be allowed and its properties
type PathRecommendation struct {
	// Path - The full path of the file, or an identifier of the application
	Path *string `json:"path,omitempty"`
	// Action - Possible values include: 'Recommended', 'Add', 'Remove'
	Action Action `json:"action,omitempty"`
	// Type - Possible values include: 'File', 'FileHash', 'PublisherSignature', 'ProductSignature', 'BinarySignature', 'VersionAndAboveSignature'
	Type          Type1          `json:"type,omitempty"`
	PublisherInfo *PublisherInfo `json:"publisherInfo,omitempty"`
	// Common - Whether the application is commonly run on the machine
	Common    *bool                 `json:"common,omitempty"`
	UserSids  *[]string             `json:"userSids,omitempty"`
	Usernames *[]UserRecommendation `json:"usernames,omitempty"`
	// FileType - Possible values include: 'FileTypeExe', 'FileTypeDll', 'FileTypeMsi', 'FileTypeScript', 'FileTypeExecutable', 'FileTypeUnknown'
	FileType FileType `json:"fileType,omitempty"`
	// ConfigurationStatus - Possible values include: 'ConfigurationStatus1Configured', 'ConfigurationStatus1NotConfigured', 'ConfigurationStatus1InProgress', 'ConfigurationStatus1Failed', 'ConfigurationStatus1NoStatus'
	ConfigurationStatus ConfigurationStatus1 `json:"configurationStatus,omitempty"`
}

// Pricing microsoft Defender for Cloud is provided in two pricing tiers: free and standard, with the
// standard tier available with a trial period. The standard tier offers advanced security capabilities,
// while the free tier offers basic security features.
type Pricing struct {
	autorest.Response `json:"-"`
	// PricingProperties - Pricing data
	*PricingProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Pricing.
func (p Pricing) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.PricingProperties != nil {
		objectMap["properties"] = p.PricingProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Pricing struct.
func (p *Pricing) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var pricingProperties PricingProperties
				err = json.Unmarshal(*v, &pricingProperties)
				if err != nil {
					return err
				}
				p.PricingProperties = &pricingProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = &typeVar
			}
		}
	}

	return nil
}

// PricingList list of pricing configurations response.
type PricingList struct {
	autorest.Response `json:"-"`
	// Value - List of pricing configurations
	Value *[]Pricing `json:"value,omitempty"`
}

// PricingProperties pricing properties for the relevant scope
type PricingProperties struct {
	// PricingTier - The pricing tier value. Microsoft Defender for Cloud is provided in two pricing tiers: free and standard, with the standard tier available with a trial period. The standard tier offers advanced security capabilities, while the free tier offers basic security features. Possible values include: 'Free', 'Standard'
	PricingTier PricingTier `json:"pricingTier,omitempty"`
	// SubPlan - The sub-plan selected for a Standard pricing configuration, when more than one sub-plan is available. Each sub-plan enables a set of security features. When not specified, full plan is applied.
	SubPlan *string `json:"subPlan,omitempty"`
	// FreeTrialRemainingTime - READ-ONLY; The duration left for the subscriptions free trial period - in ISO 8601 format (e.g. P3Y6M4DT12H30M5S).
	FreeTrialRemainingTime *string `json:"freeTrialRemainingTime,omitempty"`
	// Deprecated - READ-ONLY; Optional. True if the plan is deprecated. If there are replacing plans they will appear in `replacedBy` property
	Deprecated *bool `json:"deprecated,omitempty"`
	// ReplacedBy - READ-ONLY; Optional. List of plans that replace this plan. This property exists only if this plan is deprecated.
	ReplacedBy *[]string `json:"replacedBy,omitempty"`
}

// MarshalJSON is the custom marshaler for PricingProperties.
func (pp PricingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pp.PricingTier != "" {
		objectMap["pricingTier"] = pp.PricingTier
	}
	if pp.SubPlan != nil {
		objectMap["subPlan"] = pp.SubPlan
	}
	return json.Marshal(objectMap)
}

// ProcessNotAllowed execution of a process that isn't allowed. Allow list consists of process names to
// allow.
type ProcessNotAllowed struct {
	// AllowlistValues - The values to allow. The format of the values depends on the rule type.
	AllowlistValues *[]string `json:"allowlistValues,omitempty"`
	// ValueType - READ-ONLY; The value type of the items in the list. Possible values include: 'ValueTypeIPCidr', 'ValueTypeString'
	ValueType ValueType `json:"valueType,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeConnectionFromIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for ProcessNotAllowed.
func (pna ProcessNotAllowed) MarshalJSON() ([]byte, error) {
	pna.RuleType = RuleTypeProcessNotAllowed
	objectMap := make(map[string]interface{})
	if pna.AllowlistValues != nil {
		objectMap["allowlistValues"] = pna.AllowlistValues
	}
	if pna.IsEnabled != nil {
		objectMap["isEnabled"] = pna.IsEnabled
	}
	if pna.RuleType != "" {
		objectMap["ruleType"] = pna.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return &pna, true
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return &pna, true
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsConnectionFromIPNotAllowed is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsConnectionFromIPNotAllowed() (*ConnectionFromIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return &pna, true
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for ProcessNotAllowed.
func (pna ProcessNotAllowed) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &pna, true
}

// ProtectionMode the protection mode of the collection/file types. Exe/Msi/Script are used for Windows,
// Executable is used for Linux.
type ProtectionMode struct {
	// Exe - Possible values include: 'ExeAudit', 'ExeEnforce', 'ExeNone'
	Exe Exe `json:"exe,omitempty"`
	// Msi - Possible values include: 'MsiAudit', 'MsiEnforce', 'MsiNone'
	Msi Msi `json:"msi,omitempty"`
	// Script - Possible values include: 'ScriptAudit', 'ScriptEnforce', 'ScriptNone'
	Script Script `json:"script,omitempty"`
	// Executable - Possible values include: 'ExecutableAudit', 'ExecutableEnforce', 'ExecutableNone'
	Executable Executable `json:"executable,omitempty"`
}

// ProxyServerProperties for a non-Azure machine that is not connected directly to the internet, specify a
// proxy server that the non-Azure machine can use.
type ProxyServerProperties struct {
	// IP - Proxy server IP
	IP *string `json:"ip,omitempty"`
	// Port - Proxy server port
	Port *string `json:"port,omitempty"`
}

// PublisherInfo represents the publisher information of a process/rule
type PublisherInfo struct {
	// PublisherName - The Subject field of the x.509 certificate used to sign the code, using the following fields -  O = Organization, L = Locality, S = State or Province, and C = Country
	PublisherName *string `json:"publisherName,omitempty"`
	// ProductName - The product name taken from the file's version resource
	ProductName *string `json:"productName,omitempty"`
	// BinaryName - The "OriginalName" field taken from the file's version resource
	BinaryName *string `json:"binaryName,omitempty"`
	// Version - The binary file version taken from the file's version resource
	Version *string `json:"version,omitempty"`
}

// QueryCheck the rule query details.
type QueryCheck struct {
	// Query - The rule query.
	Query *string `json:"query,omitempty"`
	// ExpectedResult - Expected result.
	ExpectedResult *[][]string `json:"expectedResult,omitempty"`
	// ColumnNames - Column names of expected result.
	ColumnNames *[]string `json:"columnNames,omitempty"`
}

// QueuePurgesNotInAllowedRange number of device queue purges is not in allowed range.
type QueuePurgesNotInAllowedRange struct {
	// TimeWindowSize - The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeConnectionFromIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) MarshalJSON() ([]byte, error) {
	qpniar.RuleType = RuleTypeQueuePurgesNotInAllowedRange
	objectMap := make(map[string]interface{})
	if qpniar.TimeWindowSize != nil {
		objectMap["timeWindowSize"] = qpniar.TimeWindowSize
	}
	if qpniar.MinThreshold != nil {
		objectMap["minThreshold"] = qpniar.MinThreshold
	}
	if qpniar.MaxThreshold != nil {
		objectMap["maxThreshold"] = qpniar.MaxThreshold
	}
	if qpniar.IsEnabled != nil {
		objectMap["isEnabled"] = qpniar.IsEnabled
	}
	if qpniar.RuleType != "" {
		objectMap["ruleType"] = qpniar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return &qpniar, true
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return &qpniar, true
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsConnectionFromIPNotAllowed is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsConnectionFromIPNotAllowed() (*ConnectionFromIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return &qpniar, true
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for QueuePurgesNotInAllowedRange.
func (qpniar QueuePurgesNotInAllowedRange) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &qpniar, true
}

// RecommendationConfigurationProperties the type of IoT Security recommendation.
type RecommendationConfigurationProperties struct {
	// RecommendationType - The type of IoT Security recommendation. Possible values include: 'IoTACRAuthentication', 'IoTAgentSendsUnutilizedMessages', 'IoTBaseline', 'IoTEdgeHubMemOptimize', 'IoTEdgeLoggingOptions', 'IoTInconsistentModuleSettings', 'IoTInstallAgent', 'IoTIPFilterDenyAll', 'IoTIPFilterPermissiveRule', 'IoTOpenPorts', 'IoTPermissiveFirewallPolicy', 'IoTPermissiveInputFirewallRules', 'IoTPermissiveOutputFirewallRules', 'IoTPrivilegedDockerOptions', 'IoTSharedCredentials', 'IoTVulnerableTLSCipherSuite'
	RecommendationType RecommendationType `json:"recommendationType,omitempty"`
	// Name - READ-ONLY
	Name *string `json:"name,omitempty"`
	// Status - Recommendation status. When the recommendation status is disabled recommendations are not generated. Possible values include: 'Disabled', 'Enabled'
	Status RecommendationConfigStatus `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for RecommendationConfigurationProperties.
func (rcp RecommendationConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rcp.RecommendationType != "" {
		objectMap["recommendationType"] = rcp.RecommendationType
	}
	if rcp.Status != "" {
		objectMap["status"] = rcp.Status
	}
	return json.Marshal(objectMap)
}

// RegulatoryComplianceAssessment regulatory compliance assessment details and state
type RegulatoryComplianceAssessment struct {
	autorest.Response `json:"-"`
	// RegulatoryComplianceAssessmentProperties - Regulatory compliance assessment data
	*RegulatoryComplianceAssessmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RegulatoryComplianceAssessment.
func (rca RegulatoryComplianceAssessment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rca.RegulatoryComplianceAssessmentProperties != nil {
		objectMap["properties"] = rca.RegulatoryComplianceAssessmentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RegulatoryComplianceAssessment struct.
func (rca *RegulatoryComplianceAssessment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var regulatoryComplianceAssessmentProperties RegulatoryComplianceAssessmentProperties
				err = json.Unmarshal(*v, &regulatoryComplianceAssessmentProperties)
				if err != nil {
					return err
				}
				rca.RegulatoryComplianceAssessmentProperties = &regulatoryComplianceAssessmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rca.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rca.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rca.Type = &typeVar
			}
		}
	}

	return nil
}

// RegulatoryComplianceAssessmentList list of regulatory compliance assessment response
type RegulatoryComplianceAssessmentList struct {
	autorest.Response `json:"-"`
	Value             *[]RegulatoryComplianceAssessment `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for RegulatoryComplianceAssessmentList.
func (rcal RegulatoryComplianceAssessmentList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rcal.Value != nil {
		objectMap["value"] = rcal.Value
	}
	return json.Marshal(objectMap)
}

// RegulatoryComplianceAssessmentListIterator provides access to a complete listing of
// RegulatoryComplianceAssessment values.
type RegulatoryComplianceAssessmentListIterator struct {
	i    int
	page RegulatoryComplianceAssessmentListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RegulatoryComplianceAssessmentListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RegulatoryComplianceAssessmentListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RegulatoryComplianceAssessmentListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RegulatoryComplianceAssessmentListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RegulatoryComplianceAssessmentListIterator) Response() RegulatoryComplianceAssessmentList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RegulatoryComplianceAssessmentListIterator) Value() RegulatoryComplianceAssessment {
	if !iter.page.NotDone() {
		return RegulatoryComplianceAssessment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RegulatoryComplianceAssessmentListIterator type.
func NewRegulatoryComplianceAssessmentListIterator(page RegulatoryComplianceAssessmentListPage) RegulatoryComplianceAssessmentListIterator {
	return RegulatoryComplianceAssessmentListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rcal RegulatoryComplianceAssessmentList) IsEmpty() bool {
	return rcal.Value == nil || len(*rcal.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rcal RegulatoryComplianceAssessmentList) hasNextLink() bool {
	return rcal.NextLink != nil && len(*rcal.NextLink) != 0
}

// regulatoryComplianceAssessmentListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rcal RegulatoryComplianceAssessmentList) regulatoryComplianceAssessmentListPreparer(ctx context.Context) (*http.Request, error) {
	if !rcal.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rcal.NextLink)))
}

// RegulatoryComplianceAssessmentListPage contains a page of RegulatoryComplianceAssessment values.
type RegulatoryComplianceAssessmentListPage struct {
	fn   func(context.Context, RegulatoryComplianceAssessmentList) (RegulatoryComplianceAssessmentList, error)
	rcal RegulatoryComplianceAssessmentList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RegulatoryComplianceAssessmentListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RegulatoryComplianceAssessmentListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rcal)
		if err != nil {
			return err
		}
		page.rcal = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RegulatoryComplianceAssessmentListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RegulatoryComplianceAssessmentListPage) NotDone() bool {
	return !page.rcal.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RegulatoryComplianceAssessmentListPage) Response() RegulatoryComplianceAssessmentList {
	return page.rcal
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RegulatoryComplianceAssessmentListPage) Values() []RegulatoryComplianceAssessment {
	if page.rcal.IsEmpty() {
		return nil
	}
	return *page.rcal.Value
}

// Creates a new instance of the RegulatoryComplianceAssessmentListPage type.
func NewRegulatoryComplianceAssessmentListPage(cur RegulatoryComplianceAssessmentList, getNextPage func(context.Context, RegulatoryComplianceAssessmentList) (RegulatoryComplianceAssessmentList, error)) RegulatoryComplianceAssessmentListPage {
	return RegulatoryComplianceAssessmentListPage{
		fn:   getNextPage,
		rcal: cur,
	}
}

// RegulatoryComplianceAssessmentProperties regulatory compliance assessment data
type RegulatoryComplianceAssessmentProperties struct {
	// Description - READ-ONLY; The description of the regulatory compliance assessment
	Description *string `json:"description,omitempty"`
	// AssessmentType - READ-ONLY; The expected type of assessment contained in the AssessmentDetailsLink
	AssessmentType *string `json:"assessmentType,omitempty"`
	// AssessmentDetailsLink - READ-ONLY; Link to more detailed assessment results data. The response type will be according to the assessmentType field
	AssessmentDetailsLink *string `json:"assessmentDetailsLink,omitempty"`
	// State - Aggregative state based on the assessment's scanned resources states. Possible values include: 'StatePassed', 'StateFailed', 'StateSkipped', 'StateUnsupported'
	State State `json:"state,omitempty"`
	// PassedResources - READ-ONLY; The given assessment's related resources count with passed state.
	PassedResources *int32 `json:"passedResources,omitempty"`
	// FailedResources - READ-ONLY; The given assessment's related resources count with failed state.
	FailedResources *int32 `json:"failedResources,omitempty"`
	// SkippedResources - READ-ONLY; The given assessment's related resources count with skipped state.
	SkippedResources *int32 `json:"skippedResources,omitempty"`
	// UnsupportedResources - READ-ONLY; The given assessment's related resources count with unsupported state.
	UnsupportedResources *int32 `json:"unsupportedResources,omitempty"`
}

// MarshalJSON is the custom marshaler for RegulatoryComplianceAssessmentProperties.
func (rcap RegulatoryComplianceAssessmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rcap.State != "" {
		objectMap["state"] = rcap.State
	}
	return json.Marshal(objectMap)
}

// RegulatoryComplianceControl regulatory compliance control details and state
type RegulatoryComplianceControl struct {
	autorest.Response `json:"-"`
	// RegulatoryComplianceControlProperties - Regulatory compliance control data
	*RegulatoryComplianceControlProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RegulatoryComplianceControl.
func (rcc RegulatoryComplianceControl) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rcc.RegulatoryComplianceControlProperties != nil {
		objectMap["properties"] = rcc.RegulatoryComplianceControlProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RegulatoryComplianceControl struct.
func (rcc *RegulatoryComplianceControl) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var regulatoryComplianceControlProperties RegulatoryComplianceControlProperties
				err = json.Unmarshal(*v, &regulatoryComplianceControlProperties)
				if err != nil {
					return err
				}
				rcc.RegulatoryComplianceControlProperties = &regulatoryComplianceControlProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rcc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rcc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rcc.Type = &typeVar
			}
		}
	}

	return nil
}

// RegulatoryComplianceControlList list of regulatory compliance controls response
type RegulatoryComplianceControlList struct {
	autorest.Response `json:"-"`
	// Value - List of regulatory compliance controls
	Value *[]RegulatoryComplianceControl `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for RegulatoryComplianceControlList.
func (rccl RegulatoryComplianceControlList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rccl.Value != nil {
		objectMap["value"] = rccl.Value
	}
	return json.Marshal(objectMap)
}

// RegulatoryComplianceControlListIterator provides access to a complete listing of
// RegulatoryComplianceControl values.
type RegulatoryComplianceControlListIterator struct {
	i    int
	page RegulatoryComplianceControlListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RegulatoryComplianceControlListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RegulatoryComplianceControlListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RegulatoryComplianceControlListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RegulatoryComplianceControlListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RegulatoryComplianceControlListIterator) Response() RegulatoryComplianceControlList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RegulatoryComplianceControlListIterator) Value() RegulatoryComplianceControl {
	if !iter.page.NotDone() {
		return RegulatoryComplianceControl{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RegulatoryComplianceControlListIterator type.
func NewRegulatoryComplianceControlListIterator(page RegulatoryComplianceControlListPage) RegulatoryComplianceControlListIterator {
	return RegulatoryComplianceControlListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rccl RegulatoryComplianceControlList) IsEmpty() bool {
	return rccl.Value == nil || len(*rccl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rccl RegulatoryComplianceControlList) hasNextLink() bool {
	return rccl.NextLink != nil && len(*rccl.NextLink) != 0
}

// regulatoryComplianceControlListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rccl RegulatoryComplianceControlList) regulatoryComplianceControlListPreparer(ctx context.Context) (*http.Request, error) {
	if !rccl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rccl.NextLink)))
}

// RegulatoryComplianceControlListPage contains a page of RegulatoryComplianceControl values.
type RegulatoryComplianceControlListPage struct {
	fn   func(context.Context, RegulatoryComplianceControlList) (RegulatoryComplianceControlList, error)
	rccl RegulatoryComplianceControlList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RegulatoryComplianceControlListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RegulatoryComplianceControlListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rccl)
		if err != nil {
			return err
		}
		page.rccl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RegulatoryComplianceControlListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RegulatoryComplianceControlListPage) NotDone() bool {
	return !page.rccl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RegulatoryComplianceControlListPage) Response() RegulatoryComplianceControlList {
	return page.rccl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RegulatoryComplianceControlListPage) Values() []RegulatoryComplianceControl {
	if page.rccl.IsEmpty() {
		return nil
	}
	return *page.rccl.Value
}

// Creates a new instance of the RegulatoryComplianceControlListPage type.
func NewRegulatoryComplianceControlListPage(cur RegulatoryComplianceControlList, getNextPage func(context.Context, RegulatoryComplianceControlList) (RegulatoryComplianceControlList, error)) RegulatoryComplianceControlListPage {
	return RegulatoryComplianceControlListPage{
		fn:   getNextPage,
		rccl: cur,
	}
}

// RegulatoryComplianceControlProperties regulatory compliance control data
type RegulatoryComplianceControlProperties struct {
	// Description - READ-ONLY; The description of the regulatory compliance control
	Description *string `json:"description,omitempty"`
	// State - Aggregative state based on the control's supported assessments states. Possible values include: 'StatePassed', 'StateFailed', 'StateSkipped', 'StateUnsupported'
	State State `json:"state,omitempty"`
	// PassedAssessments - READ-ONLY; The number of supported regulatory compliance assessments of the given control with a passed state
	PassedAssessments *int32 `json:"passedAssessments,omitempty"`
	// FailedAssessments - READ-ONLY; The number of supported regulatory compliance assessments of the given control with a failed state
	FailedAssessments *int32 `json:"failedAssessments,omitempty"`
	// SkippedAssessments - READ-ONLY; The number of supported regulatory compliance assessments of the given control with a skipped state
	SkippedAssessments *int32 `json:"skippedAssessments,omitempty"`
}

// MarshalJSON is the custom marshaler for RegulatoryComplianceControlProperties.
func (rccp RegulatoryComplianceControlProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rccp.State != "" {
		objectMap["state"] = rccp.State
	}
	return json.Marshal(objectMap)
}

// RegulatoryComplianceStandard regulatory compliance standard details and state
type RegulatoryComplianceStandard struct {
	autorest.Response `json:"-"`
	// RegulatoryComplianceStandardProperties - Regulatory compliance standard data
	*RegulatoryComplianceStandardProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RegulatoryComplianceStandard.
func (rcs RegulatoryComplianceStandard) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rcs.RegulatoryComplianceStandardProperties != nil {
		objectMap["properties"] = rcs.RegulatoryComplianceStandardProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RegulatoryComplianceStandard struct.
func (rcs *RegulatoryComplianceStandard) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var regulatoryComplianceStandardProperties RegulatoryComplianceStandardProperties
				err = json.Unmarshal(*v, &regulatoryComplianceStandardProperties)
				if err != nil {
					return err
				}
				rcs.RegulatoryComplianceStandardProperties = &regulatoryComplianceStandardProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rcs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rcs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rcs.Type = &typeVar
			}
		}
	}

	return nil
}

// RegulatoryComplianceStandardList list of regulatory compliance standards response
type RegulatoryComplianceStandardList struct {
	autorest.Response `json:"-"`
	Value             *[]RegulatoryComplianceStandard `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for RegulatoryComplianceStandardList.
func (rcsl RegulatoryComplianceStandardList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rcsl.Value != nil {
		objectMap["value"] = rcsl.Value
	}
	return json.Marshal(objectMap)
}

// RegulatoryComplianceStandardListIterator provides access to a complete listing of
// RegulatoryComplianceStandard values.
type RegulatoryComplianceStandardListIterator struct {
	i    int
	page RegulatoryComplianceStandardListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RegulatoryComplianceStandardListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RegulatoryComplianceStandardListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RegulatoryComplianceStandardListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RegulatoryComplianceStandardListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RegulatoryComplianceStandardListIterator) Response() RegulatoryComplianceStandardList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RegulatoryComplianceStandardListIterator) Value() RegulatoryComplianceStandard {
	if !iter.page.NotDone() {
		return RegulatoryComplianceStandard{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RegulatoryComplianceStandardListIterator type.
func NewRegulatoryComplianceStandardListIterator(page RegulatoryComplianceStandardListPage) RegulatoryComplianceStandardListIterator {
	return RegulatoryComplianceStandardListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rcsl RegulatoryComplianceStandardList) IsEmpty() bool {
	return rcsl.Value == nil || len(*rcsl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rcsl RegulatoryComplianceStandardList) hasNextLink() bool {
	return rcsl.NextLink != nil && len(*rcsl.NextLink) != 0
}

// regulatoryComplianceStandardListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rcsl RegulatoryComplianceStandardList) regulatoryComplianceStandardListPreparer(ctx context.Context) (*http.Request, error) {
	if !rcsl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rcsl.NextLink)))
}

// RegulatoryComplianceStandardListPage contains a page of RegulatoryComplianceStandard values.
type RegulatoryComplianceStandardListPage struct {
	fn   func(context.Context, RegulatoryComplianceStandardList) (RegulatoryComplianceStandardList, error)
	rcsl RegulatoryComplianceStandardList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RegulatoryComplianceStandardListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RegulatoryComplianceStandardListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rcsl)
		if err != nil {
			return err
		}
		page.rcsl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RegulatoryComplianceStandardListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RegulatoryComplianceStandardListPage) NotDone() bool {
	return !page.rcsl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RegulatoryComplianceStandardListPage) Response() RegulatoryComplianceStandardList {
	return page.rcsl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RegulatoryComplianceStandardListPage) Values() []RegulatoryComplianceStandard {
	if page.rcsl.IsEmpty() {
		return nil
	}
	return *page.rcsl.Value
}

// Creates a new instance of the RegulatoryComplianceStandardListPage type.
func NewRegulatoryComplianceStandardListPage(cur RegulatoryComplianceStandardList, getNextPage func(context.Context, RegulatoryComplianceStandardList) (RegulatoryComplianceStandardList, error)) RegulatoryComplianceStandardListPage {
	return RegulatoryComplianceStandardListPage{
		fn:   getNextPage,
		rcsl: cur,
	}
}

// RegulatoryComplianceStandardProperties regulatory compliance standard data
type RegulatoryComplianceStandardProperties struct {
	// State - Aggregative state based on the standard's supported controls states. Possible values include: 'StatePassed', 'StateFailed', 'StateSkipped', 'StateUnsupported'
	State State `json:"state,omitempty"`
	// PassedControls - READ-ONLY; The number of supported regulatory compliance controls of the given standard with a passed state
	PassedControls *int32 `json:"passedControls,omitempty"`
	// FailedControls - READ-ONLY; The number of supported regulatory compliance controls of the given standard with a failed state
	FailedControls *int32 `json:"failedControls,omitempty"`
	// SkippedControls - READ-ONLY; The number of supported regulatory compliance controls of the given standard with a skipped state
	SkippedControls *int32 `json:"skippedControls,omitempty"`
	// UnsupportedControls - READ-ONLY; The number of regulatory compliance controls of the given standard which are unsupported by automated assessments
	UnsupportedControls *int32 `json:"unsupportedControls,omitempty"`
}

// MarshalJSON is the custom marshaler for RegulatoryComplianceStandardProperties.
func (rcsp RegulatoryComplianceStandardProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rcsp.State != "" {
		objectMap["state"] = rcsp.State
	}
	return json.Marshal(objectMap)
}

// Remediation remediation details.
type Remediation struct {
	// Description - Remediation description.
	Description *string `json:"description,omitempty"`
	// Scripts - Remediation script.
	Scripts *[]string `json:"scripts,omitempty"`
	// Automated - Is remediation automated.
	Automated *bool `json:"automated,omitempty"`
	// PortalLink - Optional link to remediate in Azure Portal.
	PortalLink *string `json:"portalLink,omitempty"`
}

// RemediationEta the ETA (estimated time of arrival) for remediation
type RemediationEta struct {
	// Eta - ETA for remediation.
	Eta *date.Time `json:"eta,omitempty"`
	// Justification - Justification for change of Eta.
	Justification *string `json:"justification,omitempty"`
}

// Resource describes an Azure resource.
type Resource struct {
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// BasicResourceDetails details of the resource that was assessed
type BasicResourceDetails interface {
	AsOnPremiseSQLResourceDetails() (*OnPremiseSQLResourceDetails, bool)
	AsOnPremiseResourceDetails() (*OnPremiseResourceDetails, bool)
	AsBasicOnPremiseResourceDetails() (BasicOnPremiseResourceDetails, bool)
	AsAzureResourceDetails() (*AzureResourceDetails, bool)
	AsResourceDetails() (*ResourceDetails, bool)
}

// ResourceDetails details of the resource that was assessed
type ResourceDetails struct {
	// Source - Possible values include: 'SourceResourceDetails', 'SourceOnPremiseSQL', 'SourceOnPremise', 'SourceAzure'
	Source Source `json:"source,omitempty"`
}

func unmarshalBasicResourceDetails(body []byte) (BasicResourceDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["source"] {
	case string(SourceOnPremiseSQL):
		var opsrd OnPremiseSQLResourceDetails
		err := json.Unmarshal(body, &opsrd)
		return opsrd, err
	case string(SourceOnPremise):
		var oprd OnPremiseResourceDetails
		err := json.Unmarshal(body, &oprd)
		return oprd, err
	case string(SourceAzure):
		var ard AzureResourceDetails
		err := json.Unmarshal(body, &ard)
		return ard, err
	default:
		var rd ResourceDetails
		err := json.Unmarshal(body, &rd)
		return rd, err
	}
}
func unmarshalBasicResourceDetailsArray(body []byte) ([]BasicResourceDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rdArray := make([]BasicResourceDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rd, err := unmarshalBasicResourceDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		rdArray[index] = rd
	}
	return rdArray, nil
}

// MarshalJSON is the custom marshaler for ResourceDetails.
func (rd ResourceDetails) MarshalJSON() ([]byte, error) {
	rd.Source = SourceResourceDetails
	objectMap := make(map[string]interface{})
	if rd.Source != "" {
		objectMap["source"] = rd.Source
	}
	return json.Marshal(objectMap)
}

// AsOnPremiseSQLResourceDetails is the BasicResourceDetails implementation for ResourceDetails.
func (rd ResourceDetails) AsOnPremiseSQLResourceDetails() (*OnPremiseSQLResourceDetails, bool) {
	return nil, false
}

// AsOnPremiseResourceDetails is the BasicResourceDetails implementation for ResourceDetails.
func (rd ResourceDetails) AsOnPremiseResourceDetails() (*OnPremiseResourceDetails, bool) {
	return nil, false
}

// AsBasicOnPremiseResourceDetails is the BasicResourceDetails implementation for ResourceDetails.
func (rd ResourceDetails) AsBasicOnPremiseResourceDetails() (BasicOnPremiseResourceDetails, bool) {
	return nil, false
}

// AsAzureResourceDetails is the BasicResourceDetails implementation for ResourceDetails.
func (rd ResourceDetails) AsAzureResourceDetails() (*AzureResourceDetails, bool) {
	return nil, false
}

// AsResourceDetails is the BasicResourceDetails implementation for ResourceDetails.
func (rd ResourceDetails) AsResourceDetails() (*ResourceDetails, bool) {
	return &rd, true
}

// AsBasicResourceDetails is the BasicResourceDetails implementation for ResourceDetails.
func (rd ResourceDetails) AsBasicResourceDetails() (BasicResourceDetails, bool) {
	return &rd, true
}

// BasicResourceIdentifier a resource identifier for an alert which can be used to direct the alert to the right
// product exposure group (tenant, workspace, subscription etc.).
type BasicResourceIdentifier interface {
	AsAzureResourceIdentifier() (*AzureResourceIdentifier, bool)
	AsLogAnalyticsIdentifier() (*LogAnalyticsIdentifier, bool)
	AsResourceIdentifier() (*ResourceIdentifier, bool)
}

// ResourceIdentifier a resource identifier for an alert which can be used to direct the alert to the right
// product exposure group (tenant, workspace, subscription etc.).
type ResourceIdentifier struct {
	// Type - Possible values include: 'TypeResourceIdentifier', 'TypeAzureResource', 'TypeLogAnalytics'
	Type TypeBasicResourceIdentifier `json:"type,omitempty"`
}

func unmarshalBasicResourceIdentifier(body []byte) (BasicResourceIdentifier, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeAzureResource):
		var ari AzureResourceIdentifier
		err := json.Unmarshal(body, &ari)
		return ari, err
	case string(TypeLogAnalytics):
		var lai LogAnalyticsIdentifier
		err := json.Unmarshal(body, &lai)
		return lai, err
	default:
		var ri ResourceIdentifier
		err := json.Unmarshal(body, &ri)
		return ri, err
	}
}
func unmarshalBasicResourceIdentifierArray(body []byte) ([]BasicResourceIdentifier, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	riArray := make([]BasicResourceIdentifier, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ri, err := unmarshalBasicResourceIdentifier(*rawMessage)
		if err != nil {
			return nil, err
		}
		riArray[index] = ri
	}
	return riArray, nil
}

// MarshalJSON is the custom marshaler for ResourceIdentifier.
func (ri ResourceIdentifier) MarshalJSON() ([]byte, error) {
	ri.Type = TypeResourceIdentifier
	objectMap := make(map[string]interface{})
	if ri.Type != "" {
		objectMap["type"] = ri.Type
	}
	return json.Marshal(objectMap)
}

// AsAzureResourceIdentifier is the BasicResourceIdentifier implementation for ResourceIdentifier.
func (ri ResourceIdentifier) AsAzureResourceIdentifier() (*AzureResourceIdentifier, bool) {
	return nil, false
}

// AsLogAnalyticsIdentifier is the BasicResourceIdentifier implementation for ResourceIdentifier.
func (ri ResourceIdentifier) AsLogAnalyticsIdentifier() (*LogAnalyticsIdentifier, bool) {
	return nil, false
}

// AsResourceIdentifier is the BasicResourceIdentifier implementation for ResourceIdentifier.
func (ri ResourceIdentifier) AsResourceIdentifier() (*ResourceIdentifier, bool) {
	return &ri, true
}

// AsBasicResourceIdentifier is the BasicResourceIdentifier implementation for ResourceIdentifier.
func (ri ResourceIdentifier) AsBasicResourceIdentifier() (BasicResourceIdentifier, bool) {
	return &ri, true
}

// Rule describes remote addresses that is recommended to communicate with the Azure resource on some
// (Protocol, Port, Direction). All other remote addresses are recommended to be blocked
type Rule struct {
	// Name - The name of the rule
	Name *string `json:"name,omitempty"`
	// Direction - The rule's direction. Possible values include: 'Inbound', 'Outbound'
	Direction Direction `json:"direction,omitempty"`
	// DestinationPort - The rule's destination port
	DestinationPort *int32 `json:"destinationPort,omitempty"`
	// Protocols - The rule's transport protocols
	Protocols *[]TransportProtocol `json:"protocols,omitempty"`
	// IPAddresses - The remote IP addresses that should be able to communicate with the Azure resource on the rule's destination port and protocol
	IPAddresses *[]string `json:"ipAddresses,omitempty"`
}

// RuleResults rule results.
type RuleResults struct {
	autorest.Response `json:"-"`
	Properties        *RuleResultsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RuleResults.
func (rr RuleResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rr.Properties != nil {
		objectMap["properties"] = rr.Properties
	}
	return json.Marshal(objectMap)
}

// RuleResultsInput rule results input.
type RuleResultsInput struct {
	// LatestScan - Take results from latest scan.
	LatestScan *bool `json:"latestScan,omitempty"`
	// Results - Expected results to be inserted into the baseline.
	// Leave this field empty it LatestScan == true.
	Results *[][]string `json:"results,omitempty"`
}

// RuleResultsProperties rule results properties.
type RuleResultsProperties struct {
	// Results - Expected results in the baseline.
	Results *[][]string `json:"results,omitempty"`
}

// RulesResults a list of rules results.
type RulesResults struct {
	autorest.Response `json:"-"`
	// Value - List of rule results.
	Value *[]RuleResults `json:"value,omitempty"`
}

// RulesResultsInput rules results input.
type RulesResultsInput struct {
	// LatestScan - Take results from latest scan.
	LatestScan *bool `json:"latestScan,omitempty"`
	// Results - Expected results to be inserted into the baseline.
	// Leave this field empty it LatestScan == true.
	Results map[string][][]string `json:"results"`
}

// MarshalJSON is the custom marshaler for RulesResultsInput.
func (rri RulesResultsInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rri.LatestScan != nil {
		objectMap["latestScan"] = rri.LatestScan
	}
	if rri.Results != nil {
		objectMap["results"] = rri.Results
	}
	return json.Marshal(objectMap)
}

// Scan a vulnerability assessment scan record.
type Scan struct {
	autorest.Response `json:"-"`
	Properties        *ScanProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Scan.
func (s Scan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.Properties != nil {
		objectMap["properties"] = s.Properties
	}
	return json.Marshal(objectMap)
}

// ScanProperties a vulnerability assessment scan record properties.
type ScanProperties struct {
	// TriggerType - Possible values include: 'OnDemand', 'Recurring'
	TriggerType ScanTriggerType `json:"triggerType,omitempty"`
	// State - Possible values include: 'ScanStateFailed', 'ScanStateFailedToRun', 'ScanStateInProgress', 'ScanStatePassed'
	State ScanState `json:"state,omitempty"`
	// Server - The server name.
	Server *string `json:"server,omitempty"`
	// Database - The database name.
	Database *string `json:"database,omitempty"`
	// SQLVersion - The SQL version.
	SQLVersion *string `json:"sqlVersion,omitempty"`
	// StartTime - The scan start time (UTC).
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Scan results are valid until end time (UTC).
	EndTime *date.Time `json:"endTime,omitempty"`
	// HighSeverityFailedRulesCount - The number of failed rules with high severity.
	HighSeverityFailedRulesCount *int32 `json:"highSeverityFailedRulesCount,omitempty"`
	// MediumSeverityFailedRulesCount - The number of failed rules with medium severity.
	MediumSeverityFailedRulesCount *int32 `json:"mediumSeverityFailedRulesCount,omitempty"`
	// LowSeverityFailedRulesCount - The number of failed rules with low severity.
	LowSeverityFailedRulesCount *int32 `json:"lowSeverityFailedRulesCount,omitempty"`
	// TotalPassedRulesCount - The number of total passed rules.
	TotalPassedRulesCount *int32 `json:"totalPassedRulesCount,omitempty"`
	// TotalFailedRulesCount - The number of total failed rules.
	TotalFailedRulesCount *int32 `json:"totalFailedRulesCount,omitempty"`
	// TotalRulesCount - The number of total rules assessed.
	TotalRulesCount *int32 `json:"totalRulesCount,omitempty"`
	// IsBaselineApplied - Baseline created for this database, and has one or more rules.
	IsBaselineApplied *bool `json:"isBaselineApplied,omitempty"`
}

// ScanResult a vulnerability assessment scan result for a single rule.
type ScanResult struct {
	autorest.Response `json:"-"`
	Properties        *ScanResultProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ScanResult.
func (sr ScanResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sr.Properties != nil {
		objectMap["properties"] = sr.Properties
	}
	return json.Marshal(objectMap)
}

// ScanResultProperties a vulnerability assessment scan result properties for a single rule.
type ScanResultProperties struct {
	// RuleID - The rule Id.
	RuleID *string `json:"ruleId,omitempty"`
	// Status - Possible values include: 'NonFinding', 'Finding', 'InternalError'
	Status RuleStatus `json:"status,omitempty"`
	// IsTrimmed - Indicated whether the results specified here are trimmed.
	IsTrimmed *bool `json:"isTrimmed,omitempty"`
	// QueryResults - The results of the query that was run.
	QueryResults           *[][]string             `json:"queryResults,omitempty"`
	Remediation            *Remediation            `json:"remediation,omitempty"`
	BaselineAdjustedResult *BaselineAdjustedResult `json:"baselineAdjustedResult,omitempty"`
	RuleMetadata           *VaRule                 `json:"ruleMetadata,omitempty"`
}

// ScanResults a list of vulnerability assessment scan results.
type ScanResults struct {
	autorest.Response `json:"-"`
	// Value - List of vulnerability assessment scan results.
	Value *[]ScanResult `json:"value,omitempty"`
}

// Scans a list of vulnerability assessment scan records.
type Scans struct {
	autorest.Response `json:"-"`
	// Value - List of vulnerability assessment scan records.
	Value *[]Scan `json:"value,omitempty"`
}

// ScopeElement a more specific scope used to identify the alerts to suppress.
type ScopeElement struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Field - The alert entity type to suppress by.
	Field *string `json:"field,omitempty"`
}

// MarshalJSON is the custom marshaler for ScopeElement.
func (se ScopeElement) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if se.Field != nil {
		objectMap["field"] = se.Field
	}
	for k, v := range se.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ScopeElement struct.
func (se *ScopeElement) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if se.AdditionalProperties == nil {
					se.AdditionalProperties = make(map[string]interface{})
				}
				se.AdditionalProperties[k] = additionalProperties
			}
		case "field":
			if v != nil {
				var field string
				err = json.Unmarshal(*v, &field)
				if err != nil {
					return err
				}
				se.Field = &field
			}
		}
	}

	return nil
}

// ScoreDetails calculation result data
type ScoreDetails struct {
	// Max - READ-ONLY; Maximum score available
	Max *int32 `json:"max,omitempty"`
	// Current - READ-ONLY; Current score
	Current *float64 `json:"current,omitempty"`
	// Percentage - READ-ONLY; Ratio of the current score divided by the maximum. Rounded to 4 digits after the decimal point
	Percentage *float64 `json:"percentage,omitempty"`
}

// MarshalJSON is the custom marshaler for ScoreDetails.
func (sd ScoreDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SecureScoreControlDefinitionItem information about the security control.
type SecureScoreControlDefinitionItem struct {
	*SecureScoreControlDefinitionItemProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SecureScoreControlDefinitionItem.
func (sscdi SecureScoreControlDefinitionItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sscdi.SecureScoreControlDefinitionItemProperties != nil {
		objectMap["properties"] = sscdi.SecureScoreControlDefinitionItemProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SecureScoreControlDefinitionItem struct.
func (sscdi *SecureScoreControlDefinitionItem) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var secureScoreControlDefinitionItemProperties SecureScoreControlDefinitionItemProperties
				err = json.Unmarshal(*v, &secureScoreControlDefinitionItemProperties)
				if err != nil {
					return err
				}
				sscdi.SecureScoreControlDefinitionItemProperties = &secureScoreControlDefinitionItemProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sscdi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sscdi.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sscdi.Type = &typeVar
			}
		}
	}

	return nil
}

// SecureScoreControlDefinitionItemProperties security Control Definition Properties.
type SecureScoreControlDefinitionItemProperties struct {
	// DisplayName - READ-ONLY; User friendly display name of the control
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; User friendly description of the control
	Description *string `json:"description,omitempty"`
	// MaxScore - READ-ONLY; Maximum control score (0..10)
	MaxScore *int32 `json:"maxScore,omitempty"`
	// Source - READ-ONLY; Source object from which the control was created
	Source *SecureScoreControlDefinitionSource `json:"source,omitempty"`
	// AssessmentDefinitions - READ-ONLY; Array of assessments metadata IDs that are included in this security control
	AssessmentDefinitions *[]AzureResourceLink `json:"assessmentDefinitions,omitempty"`
}

// MarshalJSON is the custom marshaler for SecureScoreControlDefinitionItemProperties.
func (sscdip SecureScoreControlDefinitionItemProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SecureScoreControlDefinitionList list of security controls definition
type SecureScoreControlDefinitionList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Collection of security controls definition in this page
	Value *[]SecureScoreControlDefinitionItem `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for SecureScoreControlDefinitionList.
func (sscdl SecureScoreControlDefinitionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SecureScoreControlDefinitionListIterator provides access to a complete listing of
// SecureScoreControlDefinitionItem values.
type SecureScoreControlDefinitionListIterator struct {
	i    int
	page SecureScoreControlDefinitionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SecureScoreControlDefinitionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecureScoreControlDefinitionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SecureScoreControlDefinitionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SecureScoreControlDefinitionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SecureScoreControlDefinitionListIterator) Response() SecureScoreControlDefinitionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SecureScoreControlDefinitionListIterator) Value() SecureScoreControlDefinitionItem {
	if !iter.page.NotDone() {
		return SecureScoreControlDefinitionItem{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SecureScoreControlDefinitionListIterator type.
func NewSecureScoreControlDefinitionListIterator(page SecureScoreControlDefinitionListPage) SecureScoreControlDefinitionListIterator {
	return SecureScoreControlDefinitionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sscdl SecureScoreControlDefinitionList) IsEmpty() bool {
	return sscdl.Value == nil || len(*sscdl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sscdl SecureScoreControlDefinitionList) hasNextLink() bool {
	return sscdl.NextLink != nil && len(*sscdl.NextLink) != 0
}

// secureScoreControlDefinitionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sscdl SecureScoreControlDefinitionList) secureScoreControlDefinitionListPreparer(ctx context.Context) (*http.Request, error) {
	if !sscdl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sscdl.NextLink)))
}

// SecureScoreControlDefinitionListPage contains a page of SecureScoreControlDefinitionItem values.
type SecureScoreControlDefinitionListPage struct {
	fn    func(context.Context, SecureScoreControlDefinitionList) (SecureScoreControlDefinitionList, error)
	sscdl SecureScoreControlDefinitionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SecureScoreControlDefinitionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecureScoreControlDefinitionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sscdl)
		if err != nil {
			return err
		}
		page.sscdl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SecureScoreControlDefinitionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SecureScoreControlDefinitionListPage) NotDone() bool {
	return !page.sscdl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SecureScoreControlDefinitionListPage) Response() SecureScoreControlDefinitionList {
	return page.sscdl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SecureScoreControlDefinitionListPage) Values() []SecureScoreControlDefinitionItem {
	if page.sscdl.IsEmpty() {
		return nil
	}
	return *page.sscdl.Value
}

// Creates a new instance of the SecureScoreControlDefinitionListPage type.
func NewSecureScoreControlDefinitionListPage(cur SecureScoreControlDefinitionList, getNextPage func(context.Context, SecureScoreControlDefinitionList) (SecureScoreControlDefinitionList, error)) SecureScoreControlDefinitionListPage {
	return SecureScoreControlDefinitionListPage{
		fn:    getNextPage,
		sscdl: cur,
	}
}

// SecureScoreControlDefinitionSource the type of the security control (For example, BuiltIn)
type SecureScoreControlDefinitionSource struct {
	// SourceType - The type of security control (for example, BuiltIn). Possible values include: 'ControlTypeBuiltIn', 'ControlTypeCustom'
	SourceType ControlType `json:"sourceType,omitempty"`
}

// SecureScoreControlDetails details of the security control, its score, and the health status of the
// relevant resources.
type SecureScoreControlDetails struct {
	*SecureScoreControlScoreDetails `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SecureScoreControlDetails.
func (sscd SecureScoreControlDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sscd.SecureScoreControlScoreDetails != nil {
		objectMap["properties"] = sscd.SecureScoreControlScoreDetails
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SecureScoreControlDetails struct.
func (sscd *SecureScoreControlDetails) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var secureScoreControlScoreDetails SecureScoreControlScoreDetails
				err = json.Unmarshal(*v, &secureScoreControlScoreDetails)
				if err != nil {
					return err
				}
				sscd.SecureScoreControlScoreDetails = &secureScoreControlScoreDetails
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sscd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sscd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sscd.Type = &typeVar
			}
		}
	}

	return nil
}

// SecureScoreControlList list of security controls
type SecureScoreControlList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Collection of security controls in this page
	Value *[]SecureScoreControlDetails `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for SecureScoreControlList.
func (sscl SecureScoreControlList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SecureScoreControlListIterator provides access to a complete listing of SecureScoreControlDetails
// values.
type SecureScoreControlListIterator struct {
	i    int
	page SecureScoreControlListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SecureScoreControlListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecureScoreControlListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SecureScoreControlListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SecureScoreControlListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SecureScoreControlListIterator) Response() SecureScoreControlList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SecureScoreControlListIterator) Value() SecureScoreControlDetails {
	if !iter.page.NotDone() {
		return SecureScoreControlDetails{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SecureScoreControlListIterator type.
func NewSecureScoreControlListIterator(page SecureScoreControlListPage) SecureScoreControlListIterator {
	return SecureScoreControlListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sscl SecureScoreControlList) IsEmpty() bool {
	return sscl.Value == nil || len(*sscl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sscl SecureScoreControlList) hasNextLink() bool {
	return sscl.NextLink != nil && len(*sscl.NextLink) != 0
}

// secureScoreControlListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sscl SecureScoreControlList) secureScoreControlListPreparer(ctx context.Context) (*http.Request, error) {
	if !sscl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sscl.NextLink)))
}

// SecureScoreControlListPage contains a page of SecureScoreControlDetails values.
type SecureScoreControlListPage struct {
	fn   func(context.Context, SecureScoreControlList) (SecureScoreControlList, error)
	sscl SecureScoreControlList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SecureScoreControlListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecureScoreControlListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sscl)
		if err != nil {
			return err
		}
		page.sscl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SecureScoreControlListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SecureScoreControlListPage) NotDone() bool {
	return !page.sscl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SecureScoreControlListPage) Response() SecureScoreControlList {
	return page.sscl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SecureScoreControlListPage) Values() []SecureScoreControlDetails {
	if page.sscl.IsEmpty() {
		return nil
	}
	return *page.sscl.Value
}

// Creates a new instance of the SecureScoreControlListPage type.
func NewSecureScoreControlListPage(cur SecureScoreControlList, getNextPage func(context.Context, SecureScoreControlList) (SecureScoreControlList, error)) SecureScoreControlListPage {
	return SecureScoreControlListPage{
		fn:   getNextPage,
		sscl: cur,
	}
}

// SecureScoreControlScore calculation result data
type SecureScoreControlScore struct {
	// Max - READ-ONLY; Maximum control score (0..10)
	Max *int32 `json:"max,omitempty"`
	// Current - READ-ONLY; Actual score for the control = (achieved points / total points) * max score. if total points is zeroed, the return number is 0.00
	Current *float64 `json:"current,omitempty"`
	// Percentage - READ-ONLY; Ratio of the current score divided by the maximum. Rounded to 4 digits after the decimal point
	Percentage *float64 `json:"percentage,omitempty"`
}

// MarshalJSON is the custom marshaler for SecureScoreControlScore.
func (sscs SecureScoreControlScore) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SecureScoreControlScoreDetails calculation result data in control level
type SecureScoreControlScoreDetails struct {
	// DisplayName - READ-ONLY; User friendly display name of the control
	DisplayName *string `json:"displayName,omitempty"`
	// ScoreDetails - Actual score object for the control
	*ScoreDetails `json:"score,omitempty"`
	// HealthyResourceCount - READ-ONLY; Number of healthy resources in the control
	HealthyResourceCount *int32 `json:"healthyResourceCount,omitempty"`
	// UnhealthyResourceCount - READ-ONLY; Number of unhealthy resources in the control
	UnhealthyResourceCount *int32 `json:"unhealthyResourceCount,omitempty"`
	// NotApplicableResourceCount - READ-ONLY; Number of not applicable resources in the control
	NotApplicableResourceCount *int32 `json:"notApplicableResourceCount,omitempty"`
	// Weight - READ-ONLY; The relative weight for this specific control in each of your subscriptions. Used when calculating an aggregated score for this control across all of your subscriptions.
	Weight     *int64                            `json:"weight,omitempty"`
	Definition *SecureScoreControlDefinitionItem `json:"definition,omitempty"`
}

// MarshalJSON is the custom marshaler for SecureScoreControlScoreDetails.
func (sscsd SecureScoreControlScoreDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sscsd.ScoreDetails != nil {
		objectMap["score"] = sscsd.ScoreDetails
	}
	if sscsd.Definition != nil {
		objectMap["definition"] = sscsd.Definition
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SecureScoreControlScoreDetails struct.
func (sscsd *SecureScoreControlScoreDetails) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				sscsd.DisplayName = &displayName
			}
		case "score":
			if v != nil {
				var scoreDetails ScoreDetails
				err = json.Unmarshal(*v, &scoreDetails)
				if err != nil {
					return err
				}
				sscsd.ScoreDetails = &scoreDetails
			}
		case "healthyResourceCount":
			if v != nil {
				var healthyResourceCount int32
				err = json.Unmarshal(*v, &healthyResourceCount)
				if err != nil {
					return err
				}
				sscsd.HealthyResourceCount = &healthyResourceCount
			}
		case "unhealthyResourceCount":
			if v != nil {
				var unhealthyResourceCount int32
				err = json.Unmarshal(*v, &unhealthyResourceCount)
				if err != nil {
					return err
				}
				sscsd.UnhealthyResourceCount = &unhealthyResourceCount
			}
		case "notApplicableResourceCount":
			if v != nil {
				var notApplicableResourceCount int32
				err = json.Unmarshal(*v, &notApplicableResourceCount)
				if err != nil {
					return err
				}
				sscsd.NotApplicableResourceCount = &notApplicableResourceCount
			}
		case "weight":
			if v != nil {
				var weight int64
				err = json.Unmarshal(*v, &weight)
				if err != nil {
					return err
				}
				sscsd.Weight = &weight
			}
		case "definition":
			if v != nil {
				var definition SecureScoreControlDefinitionItem
				err = json.Unmarshal(*v, &definition)
				if err != nil {
					return err
				}
				sscsd.Definition = &definition
			}
		}
	}

	return nil
}

// SecureScoreItem secure score item data model
type SecureScoreItem struct {
	autorest.Response `json:"-"`
	// SecureScoreItemProperties - READ-ONLY; Secure score item
	*SecureScoreItemProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SecureScoreItem.
func (ssi SecureScoreItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SecureScoreItem struct.
func (ssi *SecureScoreItem) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var secureScoreItemProperties SecureScoreItemProperties
				err = json.Unmarshal(*v, &secureScoreItemProperties)
				if err != nil {
					return err
				}
				ssi.SecureScoreItemProperties = &secureScoreItemProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ssi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ssi.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ssi.Type = &typeVar
			}
		}
	}

	return nil
}

// SecureScoreItemProperties describes properties of a calculated secure score.
type SecureScoreItemProperties struct {
	// DisplayName - READ-ONLY; The initiative’s name
	DisplayName *string `json:"displayName,omitempty"`
	// ScoreDetails - READ-ONLY; score object
	*ScoreDetails `json:"score,omitempty"`
	// Weight - READ-ONLY; The relative weight for each subscription. Used when calculating an aggregated secure score for multiple subscriptions.
	Weight *int64 `json:"weight,omitempty"`
}

// MarshalJSON is the custom marshaler for SecureScoreItemProperties.
func (ssip SecureScoreItemProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SecureScoreItemProperties struct.
func (ssip *SecureScoreItemProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				ssip.DisplayName = &displayName
			}
		case "score":
			if v != nil {
				var scoreDetails ScoreDetails
				err = json.Unmarshal(*v, &scoreDetails)
				if err != nil {
					return err
				}
				ssip.ScoreDetails = &scoreDetails
			}
		case "weight":
			if v != nil {
				var weight int64
				err = json.Unmarshal(*v, &weight)
				if err != nil {
					return err
				}
				ssip.Weight = &weight
			}
		}
	}

	return nil
}

// SecureScoresList list of secure scores
type SecureScoresList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Collection of secure scores in this page
	Value *[]SecureScoreItem `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for SecureScoresList.
func (ssl SecureScoresList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SecureScoresListIterator provides access to a complete listing of SecureScoreItem values.
type SecureScoresListIterator struct {
	i    int
	page SecureScoresListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SecureScoresListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecureScoresListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SecureScoresListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SecureScoresListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SecureScoresListIterator) Response() SecureScoresList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SecureScoresListIterator) Value() SecureScoreItem {
	if !iter.page.NotDone() {
		return SecureScoreItem{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SecureScoresListIterator type.
func NewSecureScoresListIterator(page SecureScoresListPage) SecureScoresListIterator {
	return SecureScoresListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ssl SecureScoresList) IsEmpty() bool {
	return ssl.Value == nil || len(*ssl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ssl SecureScoresList) hasNextLink() bool {
	return ssl.NextLink != nil && len(*ssl.NextLink) != 0
}

// secureScoresListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ssl SecureScoresList) secureScoresListPreparer(ctx context.Context) (*http.Request, error) {
	if !ssl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ssl.NextLink)))
}

// SecureScoresListPage contains a page of SecureScoreItem values.
type SecureScoresListPage struct {
	fn  func(context.Context, SecureScoresList) (SecureScoresList, error)
	ssl SecureScoresList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SecureScoresListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecureScoresListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ssl)
		if err != nil {
			return err
		}
		page.ssl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SecureScoresListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SecureScoresListPage) NotDone() bool {
	return !page.ssl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SecureScoresListPage) Response() SecureScoresList {
	return page.ssl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SecureScoresListPage) Values() []SecureScoreItem {
	if page.ssl.IsEmpty() {
		return nil
	}
	return *page.ssl.Value
}

// Creates a new instance of the SecureScoresListPage type.
func NewSecureScoresListPage(cur SecureScoresList, getNextPage func(context.Context, SecureScoresList) (SecureScoresList, error)) SecureScoresListPage {
	return SecureScoresListPage{
		fn:  getNextPage,
		ssl: cur,
	}
}

// SensitivityLabel the sensitivity label.
type SensitivityLabel struct {
	// DisplayName - The name of the sensitivity label.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - The description of the sensitivity label.
	Description *string `json:"description,omitempty"`
	// Rank - The rank of the sensitivity label. Possible values include: 'RankNone', 'RankLow', 'RankMedium', 'RankHigh', 'RankCritical'
	Rank Rank `json:"rank,omitempty"`
	// Order - The order of the sensitivity label.
	Order *int32 `json:"order,omitempty"`
	// Enabled - Indicates whether the label is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`
}

// ServerVulnerabilityAssessment describes the server vulnerability assessment details on a resource
type ServerVulnerabilityAssessment struct {
	autorest.Response                        `json:"-"`
	*ServerVulnerabilityAssessmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerVulnerabilityAssessment.
func (sva ServerVulnerabilityAssessment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sva.ServerVulnerabilityAssessmentProperties != nil {
		objectMap["properties"] = sva.ServerVulnerabilityAssessmentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerVulnerabilityAssessment struct.
func (sva *ServerVulnerabilityAssessment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serverVulnerabilityAssessmentProperties ServerVulnerabilityAssessmentProperties
				err = json.Unmarshal(*v, &serverVulnerabilityAssessmentProperties)
				if err != nil {
					return err
				}
				sva.ServerVulnerabilityAssessmentProperties = &serverVulnerabilityAssessmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sva.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sva.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sva.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerVulnerabilityAssessmentDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ServerVulnerabilityAssessmentDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServerVulnerabilityAssessmentClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServerVulnerabilityAssessmentDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServerVulnerabilityAssessmentDeleteFuture.Result.
func (future *ServerVulnerabilityAssessmentDeleteFuture) result(client ServerVulnerabilityAssessmentClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.ServerVulnerabilityAssessmentDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("security.ServerVulnerabilityAssessmentDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServerVulnerabilityAssessmentProperties describes ServerVulnerabilityAssessment properties.
type ServerVulnerabilityAssessmentProperties struct {
	// ProvisioningState - READ-ONLY; The provisioningState of the vulnerability assessment capability on the VM. Possible values include: 'ProvisioningState1Succeeded', 'ProvisioningState1Failed', 'ProvisioningState1Canceled', 'ProvisioningState1Provisioning', 'ProvisioningState1Deprovisioning'
	ProvisioningState ProvisioningState1 `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerVulnerabilityAssessmentProperties.
func (svap ServerVulnerabilityAssessmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ServerVulnerabilityAssessmentsList list of server vulnerability assessments
type ServerVulnerabilityAssessmentsList struct {
	autorest.Response `json:"-"`
	Value             *[]ServerVulnerabilityAssessment `json:"value,omitempty"`
}

// ServerVulnerabilityProperties additional context fields for server vulnerability assessment
type ServerVulnerabilityProperties struct {
	// Type - READ-ONLY; Vulnerability Type. e.g: Vulnerability, Potential Vulnerability, Information Gathered
	Type *string `json:"type,omitempty"`
	// Cvss - READ-ONLY; Dictionary from cvss version to cvss details object
	Cvss map[string]*CVSS `json:"cvss"`
	// Patchable - READ-ONLY; Indicates whether a patch is available or not
	Patchable *bool `json:"patchable,omitempty"`
	// Cve - READ-ONLY; List of CVEs
	Cve *[]CVE `json:"cve,omitempty"`
	// Threat - READ-ONLY; Threat name
	Threat *string `json:"threat,omitempty"`
	// PublishedTime - READ-ONLY; Published time
	PublishedTime *date.Time `json:"publishedTime,omitempty"`
	// VendorReferences - READ-ONLY
	VendorReferences *[]VendorReference `json:"vendorReferences,omitempty"`
	// AssessedResourceType - Possible values include: 'AssessedResourceTypeAdditionalData', 'AssessedResourceTypeSQLServerVulnerability', 'AssessedResourceTypeContainerRegistryVulnerability', 'AssessedResourceTypeServerVulnerabilityAssessment'
	AssessedResourceType AssessedResourceType `json:"assessedResourceType,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerVulnerabilityProperties.
func (svp ServerVulnerabilityProperties) MarshalJSON() ([]byte, error) {
	svp.AssessedResourceType = AssessedResourceTypeServerVulnerabilityAssessment
	objectMap := make(map[string]interface{})
	if svp.AssessedResourceType != "" {
		objectMap["assessedResourceType"] = svp.AssessedResourceType
	}
	return json.Marshal(objectMap)
}

// AsSQLServerVulnerabilityProperties is the BasicAdditionalData implementation for ServerVulnerabilityProperties.
func (svp ServerVulnerabilityProperties) AsSQLServerVulnerabilityProperties() (*SQLServerVulnerabilityProperties, bool) {
	return nil, false
}

// AsContainerRegistryVulnerabilityProperties is the BasicAdditionalData implementation for ServerVulnerabilityProperties.
func (svp ServerVulnerabilityProperties) AsContainerRegistryVulnerabilityProperties() (*ContainerRegistryVulnerabilityProperties, bool) {
	return nil, false
}

// AsServerVulnerabilityProperties is the BasicAdditionalData implementation for ServerVulnerabilityProperties.
func (svp ServerVulnerabilityProperties) AsServerVulnerabilityProperties() (*ServerVulnerabilityProperties, bool) {
	return &svp, true
}

// AsAdditionalData is the BasicAdditionalData implementation for ServerVulnerabilityProperties.
func (svp ServerVulnerabilityProperties) AsAdditionalData() (*AdditionalData, bool) {
	return nil, false
}

// AsBasicAdditionalData is the BasicAdditionalData implementation for ServerVulnerabilityProperties.
func (svp ServerVulnerabilityProperties) AsBasicAdditionalData() (BasicAdditionalData, bool) {
	return &svp, true
}

// ServicePrincipalProperties details of the service principal.
type ServicePrincipalProperties struct {
	// ApplicationID - Application ID of service principal.
	ApplicationID *string `json:"applicationId,omitempty"`
	// Secret - A secret string that the application uses to prove its identity, also can be referred to as application password (write only).
	Secret *string `json:"secret,omitempty"`
}

// BasicSetting the kind of the security setting
type BasicSetting interface {
	AsDataExportSettings() (*DataExportSettings, bool)
	AsAlertSyncSettings() (*AlertSyncSettings, bool)
	AsSetting() (*Setting, bool)
}

// Setting the kind of the security setting
type Setting struct {
	autorest.Response `json:"-"`
	// Kind - Possible values include: 'KindSetting', 'KindDataExportSettings', 'KindAlertSyncSettings'
	Kind KindEnum2 `json:"kind,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

func unmarshalBasicSetting(body []byte) (BasicSetting, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["kind"] {
	case string(KindDataExportSettings):
		var desVar DataExportSettings
		err := json.Unmarshal(body, &desVar)
		return desVar, err
	case string(KindAlertSyncSettings):
		var ass AlertSyncSettings
		err := json.Unmarshal(body, &ass)
		return ass, err
	default:
		var s Setting
		err := json.Unmarshal(body, &s)
		return s, err
	}
}
func unmarshalBasicSettingArray(body []byte) ([]BasicSetting, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	sArray := make([]BasicSetting, len(rawMessages))

	for index, rawMessage := range rawMessages {
		s, err := unmarshalBasicSetting(*rawMessage)
		if err != nil {
			return nil, err
		}
		sArray[index] = s
	}
	return sArray, nil
}

// MarshalJSON is the custom marshaler for Setting.
func (s Setting) MarshalJSON() ([]byte, error) {
	s.Kind = KindSetting
	objectMap := make(map[string]interface{})
	if s.Kind != "" {
		objectMap["kind"] = s.Kind
	}
	return json.Marshal(objectMap)
}

// AsDataExportSettings is the BasicSetting implementation for Setting.
func (s Setting) AsDataExportSettings() (*DataExportSettings, bool) {
	return nil, false
}

// AsAlertSyncSettings is the BasicSetting implementation for Setting.
func (s Setting) AsAlertSyncSettings() (*AlertSyncSettings, bool) {
	return nil, false
}

// AsSetting is the BasicSetting implementation for Setting.
func (s Setting) AsSetting() (*Setting, bool) {
	return &s, true
}

// AsBasicSetting is the BasicSetting implementation for Setting.
func (s Setting) AsBasicSetting() (BasicSetting, bool) {
	return &s, true
}

// SettingModel ...
type SettingModel struct {
	autorest.Response `json:"-"`
	Value             BasicSetting `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for SettingModel struct.
func (sm *SettingModel) UnmarshalJSON(body []byte) error {
	s, err := unmarshalBasicSetting(body)
	if err != nil {
		return err
	}
	sm.Value = s

	return nil
}

// SettingsList subscription settings list.
type SettingsList struct {
	autorest.Response `json:"-"`
	// Value - The settings list.
	Value *[]BasicSetting `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for SettingsList.
func (sl SettingsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sl.Value != nil {
		objectMap["value"] = sl.Value
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SettingsList struct.
func (sl *SettingsList) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "value":
			if v != nil {
				value, err := unmarshalBasicSettingArray(*v)
				if err != nil {
					return err
				}
				sl.Value = &value
			}
		case "nextLink":
			if v != nil {
				var nextLink string
				err = json.Unmarshal(*v, &nextLink)
				if err != nil {
					return err
				}
				sl.NextLink = &nextLink
			}
		}
	}

	return nil
}

// SettingsListIterator provides access to a complete listing of Setting values.
type SettingsListIterator struct {
	i    int
	page SettingsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SettingsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SettingsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SettingsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SettingsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SettingsListIterator) Response() SettingsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SettingsListIterator) Value() BasicSetting {
	if !iter.page.NotDone() {
		return Setting{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SettingsListIterator type.
func NewSettingsListIterator(page SettingsListPage) SettingsListIterator {
	return SettingsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sl SettingsList) IsEmpty() bool {
	return sl.Value == nil || len(*sl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sl SettingsList) hasNextLink() bool {
	return sl.NextLink != nil && len(*sl.NextLink) != 0
}

// settingsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sl SettingsList) settingsListPreparer(ctx context.Context) (*http.Request, error) {
	if !sl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sl.NextLink)))
}

// SettingsListPage contains a page of BasicSetting values.
type SettingsListPage struct {
	fn func(context.Context, SettingsList) (SettingsList, error)
	sl SettingsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SettingsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SettingsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sl)
		if err != nil {
			return err
		}
		page.sl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SettingsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SettingsListPage) NotDone() bool {
	return !page.sl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SettingsListPage) Response() SettingsList {
	return page.sl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SettingsListPage) Values() []BasicSetting {
	if page.sl.IsEmpty() {
		return nil
	}
	return *page.sl.Value
}

// Creates a new instance of the SettingsListPage type.
func NewSettingsListPage(cur SettingsList, getNextPage func(context.Context, SettingsList) (SettingsList, error)) SettingsListPage {
	return SettingsListPage{
		fn: getNextPage,
		sl: cur,
	}
}

// Software represents a software data
type Software struct {
	autorest.Response `json:"-"`
	// SoftwareProperties - Properties of the Software Inventory resource
	*SoftwareProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Software.
func (s Software) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.SoftwareProperties != nil {
		objectMap["properties"] = s.SoftwareProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Software struct.
func (s *Software) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var softwareProperties SoftwareProperties
				err = json.Unmarshal(*v, &softwareProperties)
				if err != nil {
					return err
				}
				s.SoftwareProperties = &softwareProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		}
	}

	return nil
}

// SoftwareProperties software Inventory resource properties
type SoftwareProperties struct {
	// DeviceID - Unique identifier for the virtual machine in the service.
	DeviceID *string `json:"deviceId,omitempty"`
	// OsPlatform - Platform of the operating system running on the device.
	OsPlatform *string `json:"osPlatform,omitempty"`
	// Vendor - Name of the software vendor.
	Vendor *string `json:"vendor,omitempty"`
	// SoftwareName - Name of the software product.
	SoftwareName *string `json:"softwareName,omitempty"`
	// Version - Version number of the software product.
	Version *string `json:"version,omitempty"`
	// EndOfSupportStatus - End of support status. Possible values include: 'None', 'NoLongerSupported', 'VersionNoLongerSupported', 'UpcomingNoLongerSupported', 'UpcomingVersionNoLongerSupported'
	EndOfSupportStatus EndOfSupportStatus `json:"endOfSupportStatus,omitempty"`
	// EndOfSupportDate - The end of support date in case the product is upcoming end of support.
	EndOfSupportDate *string `json:"endOfSupportDate,omitempty"`
	// NumberOfKnownVulnerabilities - Number of weaknesses.
	NumberOfKnownVulnerabilities *int32 `json:"numberOfKnownVulnerabilities,omitempty"`
	// FirstSeenAt - First time that the software was seen in the device.
	FirstSeenAt *string `json:"firstSeenAt,omitempty"`
}

// SoftwaresList represents the software inventory of the virtual machine.
type SoftwaresList struct {
	autorest.Response `json:"-"`
	Value             *[]Software `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for SoftwaresList.
func (sl SoftwaresList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sl.Value != nil {
		objectMap["value"] = sl.Value
	}
	return json.Marshal(objectMap)
}

// SoftwaresListIterator provides access to a complete listing of Software values.
type SoftwaresListIterator struct {
	i    int
	page SoftwaresListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SoftwaresListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SoftwaresListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SoftwaresListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SoftwaresListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SoftwaresListIterator) Response() SoftwaresList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SoftwaresListIterator) Value() Software {
	if !iter.page.NotDone() {
		return Software{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SoftwaresListIterator type.
func NewSoftwaresListIterator(page SoftwaresListPage) SoftwaresListIterator {
	return SoftwaresListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sl SoftwaresList) IsEmpty() bool {
	return sl.Value == nil || len(*sl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sl SoftwaresList) hasNextLink() bool {
	return sl.NextLink != nil && len(*sl.NextLink) != 0
}

// softwaresListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sl SoftwaresList) softwaresListPreparer(ctx context.Context) (*http.Request, error) {
	if !sl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sl.NextLink)))
}

// SoftwaresListPage contains a page of Software values.
type SoftwaresListPage struct {
	fn func(context.Context, SoftwaresList) (SoftwaresList, error)
	sl SoftwaresList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SoftwaresListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SoftwaresListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sl)
		if err != nil {
			return err
		}
		page.sl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SoftwaresListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SoftwaresListPage) NotDone() bool {
	return !page.sl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SoftwaresListPage) Response() SoftwaresList {
	return page.sl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SoftwaresListPage) Values() []Software {
	if page.sl.IsEmpty() {
		return nil
	}
	return *page.sl.Value
}

// Creates a new instance of the SoftwaresListPage type.
func NewSoftwaresListPage(cur SoftwaresList, getNextPage func(context.Context, SoftwaresList) (SoftwaresList, error)) SoftwaresListPage {
	return SoftwaresListPage{
		fn: getNextPage,
		sl: cur,
	}
}

// Solution ...
type Solution struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Location where the resource is stored
	Location            *string `json:"location,omitempty"`
	*SolutionProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Solution.
func (s Solution) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.SolutionProperties != nil {
		objectMap["properties"] = s.SolutionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Solution struct.
func (s *Solution) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				s.Location = &location
			}
		case "properties":
			if v != nil {
				var solutionProperties SolutionProperties
				err = json.Unmarshal(*v, &solutionProperties)
				if err != nil {
					return err
				}
				s.SolutionProperties = &solutionProperties
			}
		}
	}

	return nil
}

// SolutionList ...
type SolutionList struct {
	autorest.Response `json:"-"`
	Value             *[]Solution `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for SolutionList.
func (sl SolutionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sl.Value != nil {
		objectMap["value"] = sl.Value
	}
	return json.Marshal(objectMap)
}

// SolutionListIterator provides access to a complete listing of Solution values.
type SolutionListIterator struct {
	i    int
	page SolutionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SolutionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SolutionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SolutionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SolutionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SolutionListIterator) Response() SolutionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SolutionListIterator) Value() Solution {
	if !iter.page.NotDone() {
		return Solution{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SolutionListIterator type.
func NewSolutionListIterator(page SolutionListPage) SolutionListIterator {
	return SolutionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sl SolutionList) IsEmpty() bool {
	return sl.Value == nil || len(*sl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sl SolutionList) hasNextLink() bool {
	return sl.NextLink != nil && len(*sl.NextLink) != 0
}

// solutionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sl SolutionList) solutionListPreparer(ctx context.Context) (*http.Request, error) {
	if !sl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sl.NextLink)))
}

// SolutionListPage contains a page of Solution values.
type SolutionListPage struct {
	fn func(context.Context, SolutionList) (SolutionList, error)
	sl SolutionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SolutionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SolutionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sl)
		if err != nil {
			return err
		}
		page.sl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SolutionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SolutionListPage) NotDone() bool {
	return !page.sl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SolutionListPage) Response() SolutionList {
	return page.sl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SolutionListPage) Values() []Solution {
	if page.sl.IsEmpty() {
		return nil
	}
	return *page.sl.Value
}

// Creates a new instance of the SolutionListPage type.
func NewSolutionListPage(cur SolutionList, getNextPage func(context.Context, SolutionList) (SolutionList, error)) SolutionListPage {
	return SolutionListPage{
		fn: getNextPage,
		sl: cur,
	}
}

// SolutionProperties ...
type SolutionProperties struct {
	// SecurityFamily - The security family of the security solution. Possible values include: 'Waf', 'Ngfw', 'SaasWaf', 'Va'
	SecurityFamily Family `json:"securityFamily,omitempty"`
	// ProvisioningState - The security family provisioning State. Possible values include: 'Succeeded', 'Failed', 'Updating'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Template - The security solutions' template
	Template *string `json:"template,omitempty"`
	// ProtectionStatus - The security solutions' status
	ProtectionStatus *string `json:"protectionStatus,omitempty"`
}

// SolutionsReferenceData ...
type SolutionsReferenceData struct {
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Location where the resource is stored
	Location                          *string `json:"location,omitempty"`
	*SolutionsReferenceDataProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SolutionsReferenceData.
func (srd SolutionsReferenceData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if srd.SolutionsReferenceDataProperties != nil {
		objectMap["properties"] = srd.SolutionsReferenceDataProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SolutionsReferenceData struct.
func (srd *SolutionsReferenceData) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				srd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				srd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				srd.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				srd.Location = &location
			}
		case "properties":
			if v != nil {
				var solutionsReferenceDataProperties SolutionsReferenceDataProperties
				err = json.Unmarshal(*v, &solutionsReferenceDataProperties)
				if err != nil {
					return err
				}
				srd.SolutionsReferenceDataProperties = &solutionsReferenceDataProperties
			}
		}
	}

	return nil
}

// SolutionsReferenceDataList ...
type SolutionsReferenceDataList struct {
	autorest.Response `json:"-"`
	Value             *[]SolutionsReferenceData `json:"value,omitempty"`
}

// SolutionsReferenceDataProperties ...
type SolutionsReferenceDataProperties struct {
	// SecurityFamily - The security family of the security solution. Possible values include: 'Waf', 'Ngfw', 'SaasWaf', 'Va'
	SecurityFamily Family `json:"securityFamily,omitempty"`
	// AlertVendorName - The security solutions' vendor name
	AlertVendorName *string `json:"alertVendorName,omitempty"`
	// PackageInfoURL - The security solutions' package info url
	PackageInfoURL *string `json:"packageInfoUrl,omitempty"`
	// ProductName - The security solutions' product name
	ProductName *string `json:"productName,omitempty"`
	// Publisher - The security solutions' publisher
	Publisher *string `json:"publisher,omitempty"`
	// PublisherDisplayName - The security solutions' publisher display name
	PublisherDisplayName *string `json:"publisherDisplayName,omitempty"`
	// Template - The security solutions' template
	Template *string `json:"template,omitempty"`
}

// SQLServerVulnerabilityProperties details of the resource that was assessed
type SQLServerVulnerabilityProperties struct {
	// Type - READ-ONLY; The resource type the sub assessment refers to in its resource details
	Type *string `json:"type,omitempty"`
	// Query - READ-ONLY; The T-SQL query that runs on your SQL database to perform the particular check
	Query *string `json:"query,omitempty"`
	// AssessedResourceType - Possible values include: 'AssessedResourceTypeAdditionalData', 'AssessedResourceTypeSQLServerVulnerability', 'AssessedResourceTypeContainerRegistryVulnerability', 'AssessedResourceTypeServerVulnerabilityAssessment'
	AssessedResourceType AssessedResourceType `json:"assessedResourceType,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLServerVulnerabilityProperties.
func (ssvp SQLServerVulnerabilityProperties) MarshalJSON() ([]byte, error) {
	ssvp.AssessedResourceType = AssessedResourceTypeSQLServerVulnerability
	objectMap := make(map[string]interface{})
	if ssvp.AssessedResourceType != "" {
		objectMap["assessedResourceType"] = ssvp.AssessedResourceType
	}
	return json.Marshal(objectMap)
}

// AsSQLServerVulnerabilityProperties is the BasicAdditionalData implementation for SQLServerVulnerabilityProperties.
func (ssvp SQLServerVulnerabilityProperties) AsSQLServerVulnerabilityProperties() (*SQLServerVulnerabilityProperties, bool) {
	return &ssvp, true
}

// AsContainerRegistryVulnerabilityProperties is the BasicAdditionalData implementation for SQLServerVulnerabilityProperties.
func (ssvp SQLServerVulnerabilityProperties) AsContainerRegistryVulnerabilityProperties() (*ContainerRegistryVulnerabilityProperties, bool) {
	return nil, false
}

// AsServerVulnerabilityProperties is the BasicAdditionalData implementation for SQLServerVulnerabilityProperties.
func (ssvp SQLServerVulnerabilityProperties) AsServerVulnerabilityProperties() (*ServerVulnerabilityProperties, bool) {
	return nil, false
}

// AsAdditionalData is the BasicAdditionalData implementation for SQLServerVulnerabilityProperties.
func (ssvp SQLServerVulnerabilityProperties) AsAdditionalData() (*AdditionalData, bool) {
	return nil, false
}

// AsBasicAdditionalData is the BasicAdditionalData implementation for SQLServerVulnerabilityProperties.
func (ssvp SQLServerVulnerabilityProperties) AsBasicAdditionalData() (BasicAdditionalData, bool) {
	return &ssvp, true
}

// SubAssessment security sub-assessment on a resource
type SubAssessment struct {
	autorest.Response        `json:"-"`
	*SubAssessmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SubAssessment.
func (sa SubAssessment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sa.SubAssessmentProperties != nil {
		objectMap["properties"] = sa.SubAssessmentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SubAssessment struct.
func (sa *SubAssessment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var subAssessmentProperties SubAssessmentProperties
				err = json.Unmarshal(*v, &subAssessmentProperties)
				if err != nil {
					return err
				}
				sa.SubAssessmentProperties = &subAssessmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sa.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sa.Type = &typeVar
			}
		}
	}

	return nil
}

// SubAssessmentList list of security sub-assessments
type SubAssessmentList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY
	Value *[]SubAssessment `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for SubAssessmentList.
func (sal SubAssessmentList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SubAssessmentListIterator provides access to a complete listing of SubAssessment values.
type SubAssessmentListIterator struct {
	i    int
	page SubAssessmentListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SubAssessmentListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubAssessmentListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SubAssessmentListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SubAssessmentListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SubAssessmentListIterator) Response() SubAssessmentList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SubAssessmentListIterator) Value() SubAssessment {
	if !iter.page.NotDone() {
		return SubAssessment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SubAssessmentListIterator type.
func NewSubAssessmentListIterator(page SubAssessmentListPage) SubAssessmentListIterator {
	return SubAssessmentListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sal SubAssessmentList) IsEmpty() bool {
	return sal.Value == nil || len(*sal.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sal SubAssessmentList) hasNextLink() bool {
	return sal.NextLink != nil && len(*sal.NextLink) != 0
}

// subAssessmentListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sal SubAssessmentList) subAssessmentListPreparer(ctx context.Context) (*http.Request, error) {
	if !sal.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sal.NextLink)))
}

// SubAssessmentListPage contains a page of SubAssessment values.
type SubAssessmentListPage struct {
	fn  func(context.Context, SubAssessmentList) (SubAssessmentList, error)
	sal SubAssessmentList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SubAssessmentListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubAssessmentListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sal)
		if err != nil {
			return err
		}
		page.sal = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SubAssessmentListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SubAssessmentListPage) NotDone() bool {
	return !page.sal.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SubAssessmentListPage) Response() SubAssessmentList {
	return page.sal
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SubAssessmentListPage) Values() []SubAssessment {
	if page.sal.IsEmpty() {
		return nil
	}
	return *page.sal.Value
}

// Creates a new instance of the SubAssessmentListPage type.
func NewSubAssessmentListPage(cur SubAssessmentList, getNextPage func(context.Context, SubAssessmentList) (SubAssessmentList, error)) SubAssessmentListPage {
	return SubAssessmentListPage{
		fn:  getNextPage,
		sal: cur,
	}
}

// SubAssessmentProperties describes properties of an sub-assessment.
type SubAssessmentProperties struct {
	// ID - READ-ONLY; Vulnerability ID
	ID *string `json:"id,omitempty"`
	// DisplayName - READ-ONLY; User friendly display name of the sub-assessment
	DisplayName *string              `json:"displayName,omitempty"`
	Status      *SubAssessmentStatus `json:"status,omitempty"`
	// Remediation - READ-ONLY; Information on how to remediate this sub-assessment
	Remediation *string `json:"remediation,omitempty"`
	// Impact - READ-ONLY; Description of the impact of this sub-assessment
	Impact *string `json:"impact,omitempty"`
	// Category - READ-ONLY; Category of the sub-assessment
	Category *string `json:"category,omitempty"`
	// Description - READ-ONLY; Human readable description of the assessment status
	Description *string `json:"description,omitempty"`
	// TimeGenerated - READ-ONLY; The date and time the sub-assessment was generated
	TimeGenerated   *date.Time           `json:"timeGenerated,omitempty"`
	ResourceDetails BasicResourceDetails `json:"resourceDetails,omitempty"`
	AdditionalData  BasicAdditionalData  `json:"additionalData,omitempty"`
}

// MarshalJSON is the custom marshaler for SubAssessmentProperties.
func (sap SubAssessmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sap.Status != nil {
		objectMap["status"] = sap.Status
	}
	objectMap["resourceDetails"] = sap.ResourceDetails
	objectMap["additionalData"] = sap.AdditionalData
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SubAssessmentProperties struct.
func (sap *SubAssessmentProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sap.ID = &ID
			}
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				sap.DisplayName = &displayName
			}
		case "status":
			if v != nil {
				var status SubAssessmentStatus
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				sap.Status = &status
			}
		case "remediation":
			if v != nil {
				var remediation string
				err = json.Unmarshal(*v, &remediation)
				if err != nil {
					return err
				}
				sap.Remediation = &remediation
			}
		case "impact":
			if v != nil {
				var impact string
				err = json.Unmarshal(*v, &impact)
				if err != nil {
					return err
				}
				sap.Impact = &impact
			}
		case "category":
			if v != nil {
				var category string
				err = json.Unmarshal(*v, &category)
				if err != nil {
					return err
				}
				sap.Category = &category
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				sap.Description = &description
			}
		case "timeGenerated":
			if v != nil {
				var timeGenerated date.Time
				err = json.Unmarshal(*v, &timeGenerated)
				if err != nil {
					return err
				}
				sap.TimeGenerated = &timeGenerated
			}
		case "resourceDetails":
			if v != nil {
				resourceDetails, err := unmarshalBasicResourceDetails(*v)
				if err != nil {
					return err
				}
				sap.ResourceDetails = resourceDetails
			}
		case "additionalData":
			if v != nil {
				additionalData, err := unmarshalBasicAdditionalData(*v)
				if err != nil {
					return err
				}
				sap.AdditionalData = additionalData
			}
		}
	}

	return nil
}

// SubAssessmentStatus status of the sub-assessment
type SubAssessmentStatus struct {
	// Code - READ-ONLY; Programmatic code for the status of the assessment. Possible values include: 'SubAssessmentStatusCodeHealthy', 'SubAssessmentStatusCodeUnhealthy', 'SubAssessmentStatusCodeNotApplicable'
	Code SubAssessmentStatusCode `json:"code,omitempty"`
	// Cause - READ-ONLY; Programmatic code for the cause of the assessment status
	Cause *string `json:"cause,omitempty"`
	// Description - READ-ONLY; Human readable description of the assessment status
	Description *string `json:"description,omitempty"`
	// Severity - READ-ONLY; The sub-assessment severity level. Possible values include: 'SeverityLow', 'SeverityMedium', 'SeverityHigh'
	Severity Severity `json:"severity,omitempty"`
}

// MarshalJSON is the custom marshaler for SubAssessmentStatus.
func (sas SubAssessmentStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SubscriptionGovernanceRulesExecuteStatusGetFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type SubscriptionGovernanceRulesExecuteStatusGetFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SubscriptionGovernanceRulesExecuteStatusClient) (ExecuteRuleStatus, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SubscriptionGovernanceRulesExecuteStatusGetFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SubscriptionGovernanceRulesExecuteStatusGetFuture.Result.
func (future *SubscriptionGovernanceRulesExecuteStatusGetFuture) result(client SubscriptionGovernanceRulesExecuteStatusClient) (ers ExecuteRuleStatus, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.SubscriptionGovernanceRulesExecuteStatusGetFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ers.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("security.SubscriptionGovernanceRulesExecuteStatusGetFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ers.Response.Response, err = future.GetResult(sender); err == nil && ers.Response.Response.StatusCode != http.StatusNoContent {
		ers, err = client.GetResponder(ers.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "security.SubscriptionGovernanceRulesExecuteStatusGetFuture", "Result", ers.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SuppressionAlertsScope ...
type SuppressionAlertsScope struct {
	// AllOf - All the conditions inside need to be true in order to suppress the alert
	AllOf *[]ScopeElement `json:"allOf,omitempty"`
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// Tags a list of key value pairs that describe the resource.
type Tags struct {
	// Tags - A list of key value pairs that describe the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Tags.
func (t Tags) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if t.Tags != nil {
		objectMap["tags"] = t.Tags
	}
	return json.Marshal(objectMap)
}

// TagsResource a container holding only the Tags for a resource, allowing the user to update the tags.
type TagsResource struct {
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for TagsResource.
func (tr TagsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}

// Task security task that we recommend to do in order to strengthen security
type Task struct {
	autorest.Response `json:"-"`
	*TaskProperties   `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Task.
func (t Task) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if t.TaskProperties != nil {
		objectMap["properties"] = t.TaskProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Task struct.
func (t *Task) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var taskProperties TaskProperties
				err = json.Unmarshal(*v, &taskProperties)
				if err != nil {
					return err
				}
				t.TaskProperties = &taskProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				t.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				t.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				t.Type = &typeVar
			}
		}
	}

	return nil
}

// TaskList list of security task recommendations
type TaskList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY
	Value *[]Task `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for TaskList.
func (tl TaskList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// TaskListIterator provides access to a complete listing of Task values.
type TaskListIterator struct {
	i    int
	page TaskListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TaskListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TaskListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TaskListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TaskListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TaskListIterator) Response() TaskList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TaskListIterator) Value() Task {
	if !iter.page.NotDone() {
		return Task{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TaskListIterator type.
func NewTaskListIterator(page TaskListPage) TaskListIterator {
	return TaskListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tl TaskList) IsEmpty() bool {
	return tl.Value == nil || len(*tl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (tl TaskList) hasNextLink() bool {
	return tl.NextLink != nil && len(*tl.NextLink) != 0
}

// taskListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tl TaskList) taskListPreparer(ctx context.Context) (*http.Request, error) {
	if !tl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tl.NextLink)))
}

// TaskListPage contains a page of Task values.
type TaskListPage struct {
	fn func(context.Context, TaskList) (TaskList, error)
	tl TaskList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TaskListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TaskListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.tl)
		if err != nil {
			return err
		}
		page.tl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TaskListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TaskListPage) NotDone() bool {
	return !page.tl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TaskListPage) Response() TaskList {
	return page.tl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TaskListPage) Values() []Task {
	if page.tl.IsEmpty() {
		return nil
	}
	return *page.tl.Value
}

// Creates a new instance of the TaskListPage type.
func NewTaskListPage(cur TaskList, getNextPage func(context.Context, TaskList) (TaskList, error)) TaskListPage {
	return TaskListPage{
		fn: getNextPage,
		tl: cur,
	}
}

// TaskParameters changing set of properties, depending on the task type that is derived from the name
// field
type TaskParameters struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Name - READ-ONLY; Name of the task type
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for TaskParameters.
func (tp TaskParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	for k, v := range tp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TaskParameters struct.
func (tp *TaskParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if tp.AdditionalProperties == nil {
					tp.AdditionalProperties = make(map[string]interface{})
				}
				tp.AdditionalProperties[k] = additionalProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tp.Name = &name
			}
		}
	}

	return nil
}

// TaskProperties describes properties of a task.
type TaskProperties struct {
	// State - READ-ONLY; State of the task (Active, Resolved etc.)
	State *string `json:"state,omitempty"`
	// CreationTimeUtc - READ-ONLY; The time this task was discovered in UTC
	CreationTimeUtc        *date.Time      `json:"creationTimeUtc,omitempty"`
	SecurityTaskParameters *TaskParameters `json:"securityTaskParameters,omitempty"`
	// LastStateChangeTimeUtc - READ-ONLY; The time this task's details were last changed in UTC
	LastStateChangeTimeUtc *date.Time `json:"lastStateChangeTimeUtc,omitempty"`
	// SubState - READ-ONLY; Additional data on the state of the task
	SubState *string `json:"subState,omitempty"`
}

// MarshalJSON is the custom marshaler for TaskProperties.
func (tp TaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tp.SecurityTaskParameters != nil {
		objectMap["securityTaskParameters"] = tp.SecurityTaskParameters
	}
	return json.Marshal(objectMap)
}

// BasicThresholdCustomAlertRule a custom alert rule that checks if a value (depends on the custom alert type) is
// within the given range.
type BasicThresholdCustomAlertRule interface {
	AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool)
	AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool)
	AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool)
	AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool)
	AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool)
	AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool)
	AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool)
	AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool)
	AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool)
	AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool)
	AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool)
	AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool)
	AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool)
	AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool)
	AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool)
	AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool)
	AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool)
	AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool)
	AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool)
}

// ThresholdCustomAlertRule a custom alert rule that checks if a value (depends on the custom alert type) is
// within the given range.
type ThresholdCustomAlertRule struct {
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeConnectionFromIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

func unmarshalBasicThresholdCustomAlertRule(body []byte) (BasicThresholdCustomAlertRule, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["ruleType"] {
	case string(RuleTypeTimeWindowCustomAlertRule):
		var twcar TimeWindowCustomAlertRule
		err := json.Unmarshal(body, &twcar)
		return twcar, err
	case string(RuleTypeActiveConnectionsNotInAllowedRange):
		var acniar ActiveConnectionsNotInAllowedRange
		err := json.Unmarshal(body, &acniar)
		return acniar, err
	case string(RuleTypeAmqpC2DMessagesNotInAllowedRange):
		var acmniar AmqpC2DMessagesNotInAllowedRange
		err := json.Unmarshal(body, &acmniar)
		return acmniar, err
	case string(RuleTypeMqttC2DMessagesNotInAllowedRange):
		var mcmniar MqttC2DMessagesNotInAllowedRange
		err := json.Unmarshal(body, &mcmniar)
		return mcmniar, err
	case string(RuleTypeHTTPC2DMessagesNotInAllowedRange):
		var hcmniar HTTPC2DMessagesNotInAllowedRange
		err := json.Unmarshal(body, &hcmniar)
		return hcmniar, err
	case string(RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange):
		var acrmniar AmqpC2DRejectedMessagesNotInAllowedRange
		err := json.Unmarshal(body, &acrmniar)
		return acrmniar, err
	case string(RuleTypeMqttC2DRejectedMessagesNotInAllowedRange):
		var mcrmniar MqttC2DRejectedMessagesNotInAllowedRange
		err := json.Unmarshal(body, &mcrmniar)
		return mcrmniar, err
	case string(RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange):
		var hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange
		err := json.Unmarshal(body, &hcrmniar)
		return hcrmniar, err
	case string(RuleTypeAmqpD2CMessagesNotInAllowedRange):
		var admniar AmqpD2CMessagesNotInAllowedRange
		err := json.Unmarshal(body, &admniar)
		return admniar, err
	case string(RuleTypeMqttD2CMessagesNotInAllowedRange):
		var mdmniar MqttD2CMessagesNotInAllowedRange
		err := json.Unmarshal(body, &mdmniar)
		return mdmniar, err
	case string(RuleTypeHTTPD2CMessagesNotInAllowedRange):
		var hdmniar HTTPD2CMessagesNotInAllowedRange
		err := json.Unmarshal(body, &hdmniar)
		return hdmniar, err
	case string(RuleTypeDirectMethodInvokesNotInAllowedRange):
		var dminiar DirectMethodInvokesNotInAllowedRange
		err := json.Unmarshal(body, &dminiar)
		return dminiar, err
	case string(RuleTypeFailedLocalLoginsNotInAllowedRange):
		var fllniar FailedLocalLoginsNotInAllowedRange
		err := json.Unmarshal(body, &fllniar)
		return fllniar, err
	case string(RuleTypeFileUploadsNotInAllowedRange):
		var funiar FileUploadsNotInAllowedRange
		err := json.Unmarshal(body, &funiar)
		return funiar, err
	case string(RuleTypeQueuePurgesNotInAllowedRange):
		var qpniar QueuePurgesNotInAllowedRange
		err := json.Unmarshal(body, &qpniar)
		return qpniar, err
	case string(RuleTypeTwinUpdatesNotInAllowedRange):
		var tuniar TwinUpdatesNotInAllowedRange
		err := json.Unmarshal(body, &tuniar)
		return tuniar, err
	case string(RuleTypeUnauthorizedOperationsNotInAllowedRange):
		var uoniar UnauthorizedOperationsNotInAllowedRange
		err := json.Unmarshal(body, &uoniar)
		return uoniar, err
	default:
		var tcar ThresholdCustomAlertRule
		err := json.Unmarshal(body, &tcar)
		return tcar, err
	}
}
func unmarshalBasicThresholdCustomAlertRuleArray(body []byte) ([]BasicThresholdCustomAlertRule, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	tcarArray := make([]BasicThresholdCustomAlertRule, len(rawMessages))

	for index, rawMessage := range rawMessages {
		tcar, err := unmarshalBasicThresholdCustomAlertRule(*rawMessage)
		if err != nil {
			return nil, err
		}
		tcarArray[index] = tcar
	}
	return tcarArray, nil
}

// MarshalJSON is the custom marshaler for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) MarshalJSON() ([]byte, error) {
	tcar.RuleType = RuleTypeThresholdCustomAlertRule
	objectMap := make(map[string]interface{})
	if tcar.MinThreshold != nil {
		objectMap["minThreshold"] = tcar.MinThreshold
	}
	if tcar.MaxThreshold != nil {
		objectMap["maxThreshold"] = tcar.MaxThreshold
	}
	if tcar.IsEnabled != nil {
		objectMap["isEnabled"] = tcar.IsEnabled
	}
	if tcar.RuleType != "" {
		objectMap["ruleType"] = tcar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return &tcar, true
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return &tcar, true
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return nil, false
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsConnectionFromIPNotAllowed is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsConnectionFromIPNotAllowed() (*ConnectionFromIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for ThresholdCustomAlertRule.
func (tcar ThresholdCustomAlertRule) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &tcar, true
}

// BasicTimeWindowCustomAlertRule a custom alert rule that checks if the number of activities (depends on the custom
// alert type) in a time window is within the given range.
type BasicTimeWindowCustomAlertRule interface {
	AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool)
	AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool)
	AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool)
	AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool)
	AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool)
	AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool)
	AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool)
	AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool)
	AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool)
	AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool)
	AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool)
	AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool)
	AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool)
	AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool)
	AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool)
	AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool)
	AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool)
}

// TimeWindowCustomAlertRule a custom alert rule that checks if the number of activities (depends on the custom
// alert type) in a time window is within the given range.
type TimeWindowCustomAlertRule struct {
	// TimeWindowSize - The time window size in iso8601 format.
	TimeWindowSize *string `json:"timeWindowSize,omitempty"`
	// MinThreshold - The minimum threshold.
	MinThreshold *int32 `json:"minThreshold,omitempty"`
	// MaxThreshold - The maximum threshold.
	MaxThreshold *int32 `json:"maxThreshold,omitempty"`
	// DisplayName - READ-ONLY; The display name of the custom alert.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; The description of the custom alert.
	Description *string `json:"description,omitempty"`
	// IsEnabled - Status of the custom alert.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// RuleType - Possible values include: 'RuleTypeCustomAlertRule', 'RuleTypeThresholdCustomAlertRule', 'RuleTypeTimeWindowCustomAlertRule', 'RuleTypeAllowlistCustomAlertRule', 'RuleTypeDenylistCustomAlertRule', 'RuleTypeListCustomAlertRule', 'RuleTypeConnectionToIPNotAllowed', 'RuleTypeConnectionFromIPNotAllowed', 'RuleTypeLocalUserNotAllowed', 'RuleTypeProcessNotAllowed', 'RuleTypeActiveConnectionsNotInAllowedRange', 'RuleTypeAmqpC2DMessagesNotInAllowedRange', 'RuleTypeMqttC2DMessagesNotInAllowedRange', 'RuleTypeHTTPC2DMessagesNotInAllowedRange', 'RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange', 'RuleTypeMqttC2DRejectedMessagesNotInAllowedRange', 'RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange', 'RuleTypeAmqpD2CMessagesNotInAllowedRange', 'RuleTypeMqttD2CMessagesNotInAllowedRange', 'RuleTypeHTTPD2CMessagesNotInAllowedRange', 'RuleTypeDirectMethodInvokesNotInAllowedRange', 'RuleTypeFailedLocalLoginsNotInAllowedRange', 'RuleTypeFileUploadsNotInAllowedRange', 'RuleTypeQueuePurgesNotInAllowedRange', 'RuleTypeTwinUpdatesNotInAllowedRange', 'RuleTypeUnauthorizedOperationsNotInAllowedRange'
	RuleType RuleTypeBasicCustomAlertRule `json:"ruleType,omitempty"`
}

func unmarshalBasicTimeWindowCustomAlertRule(body []byte) (BasicTimeWindowCustomAlertRule, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["ruleType"] {
	case string(RuleTypeActiveConnectionsNotInAllowedRange):
		var acniar ActiveConnectionsNotInAllowedRange
		err := json.Unmarshal(body, &acniar)
		return acniar, err
	case string(RuleTypeAmqpC2DMessagesNotInAllowedRange):
		var acmniar AmqpC2DMessagesNotInAllowedRange
		err := json.Unmarshal(body, &acmniar)
		return acmniar, err
	case string(RuleTypeMqttC2DMessagesNotInAllowedRange):
		var mcmniar MqttC2DMessagesNotInAllowedRange
		err := json.Unmarshal(body, &mcmniar)
		return mcmniar, err
	case string(RuleTypeHTTPC2DMessagesNotInAllowedRange):
		var hcmniar HTTPC2DMessagesNotInAllowedRange
		err := json.Unmarshal(body, &hcmniar)
		return hcmniar, err
	case string(RuleTypeAmqpC2DRejectedMessagesNotInAllowedRange):
		var acrmniar AmqpC2DRejectedMessagesNotInAllowedRange
		err := json.Unmarshal(body, &acrmniar)
		return acrmniar, err
	case string(RuleTypeMqttC2DRejectedMessagesNotInAllowedRange):
		var mcrmniar MqttC2DRejectedMessagesNotInAllowedRange
		err := json.Unmarshal(body, &mcrmniar)
		return mcrmniar, err
	case string(RuleTypeHTTPC2DRejectedMessagesNotInAllowedRange):
		var hcrmniar HTTPC2DRejectedMessagesNotInAllowedRange
		err := json.Unmarshal(body, &hcrmniar)
		return hcrmniar, err
	case string(RuleTypeAmqpD2CMessagesNotInAllowedRange):
		var admniar AmqpD2CMessagesNotInAllowedRange
		err := json.Unmarshal(body, &admniar)
		return admniar, err
	case string(RuleTypeMqttD2CMessagesNotInAllowedRange):
		var mdmniar MqttD2CMessagesNotInAllowedRange
		err := json.Unmarshal(body, &mdmniar)
		return mdmniar, err
	case string(RuleTypeHTTPD2CMessagesNotInAllowedRange):
		var hdmniar HTTPD2CMessagesNotInAllowedRange
		err := json.Unmarshal(body, &hdmniar)
		return hdmniar, err
	case string(RuleTypeDirectMethodInvokesNotInAllowedRange):
		var dminiar DirectMethodInvokesNotInAllowedRange
		err := json.Unmarshal(body, &dminiar)
		return dminiar, err
	case string(RuleTypeFailedLocalLoginsNotInAllowedRange):
		var fllniar FailedLocalLoginsNotInAllowedRange
		err := json.Unmarshal(body, &fllniar)
		return fllniar, err
	case string(RuleTypeFileUploadsNotInAllowedRange):
		var funiar FileUploadsNotInAllowedRange
		err := json.Unmarshal(body, &funiar)
		return funiar, err
	case string(RuleTypeQueuePurgesNotInAllowedRange):
		var qpniar QueuePurgesNotInAllowedRange
		err := json.Unmarshal(body, &qpniar)
		return qpniar, err
	case string(RuleTypeTwinUpdatesNotInAllowedRange):
		var tuniar TwinUpdatesNotInAllowedRange
		err := json.Unmarshal(body, &tuniar)
		return tuniar, err
	case string(RuleTypeUnauthorizedOperationsNotInAllowedRange):
		var uoniar UnauthorizedOperationsNotInAllowedRange
		err := json.Unmarshal(body, &uoniar)
		return uoniar, err
	default:
		var twcar TimeWindowCustomAlertRule
		err := json.Unmarshal(body, &twcar)
		return twcar, err
	}
}
func unmarshalBasicTimeWindowCustomAlertRuleArray(body []byte) ([]BasicTimeWindowCustomAlertRule, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	twcarArray := make([]BasicTimeWindowCustomAlertRule, len(rawMessages))

	for index, rawMessage := range rawMessages {
		twcar, err := unmarshalBasicTimeWindowCustomAlertRule(*rawMessage)
		if err != nil {
			return nil, err
		}
		twcarArray[index] = twcar
	}
	return twcarArray, nil
}

// MarshalJSON is the custom marshaler for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) MarshalJSON() ([]byte, error) {
	twcar.RuleType = RuleTypeTimeWindowCustomAlertRule
	objectMap := make(map[string]interface{})
	if twcar.TimeWindowSize != nil {
		objectMap["timeWindowSize"] = twcar.TimeWindowSize
	}
	if twcar.MinThreshold != nil {
		objectMap["minThreshold"] = twcar.MinThreshold
	}
	if twcar.MaxThreshold != nil {
		objectMap["maxThreshold"] = twcar.MaxThreshold
	}
	if twcar.IsEnabled != nil {
		objectMap["isEnabled"] = twcar.IsEnabled
	}
	if twcar.RuleType != "" {
		objectMap["ruleType"] = twcar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsThresholdCustomAlertRule is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsThresholdCustomAlertRule() (*ThresholdCustomAlertRule, bool) {
	return nil, false
}

// AsBasicThresholdCustomAlertRule is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsBasicThresholdCustomAlertRule() (BasicThresholdCustomAlertRule, bool) {
	return &twcar, true
}

// AsTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsTimeWindowCustomAlertRule() (*TimeWindowCustomAlertRule, bool) {
	return &twcar, true
}

// AsBasicTimeWindowCustomAlertRule is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsBasicTimeWindowCustomAlertRule() (BasicTimeWindowCustomAlertRule, bool) {
	return &twcar, true
}

// AsAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsAllowlistCustomAlertRule() (*AllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsBasicAllowlistCustomAlertRule is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsBasicAllowlistCustomAlertRule() (BasicAllowlistCustomAlertRule, bool) {
	return nil, false
}

// AsDenylistCustomAlertRule is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsDenylistCustomAlertRule() (*DenylistCustomAlertRule, bool) {
	return nil, false
}

// AsListCustomAlertRule is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsListCustomAlertRule() (*ListCustomAlertRule, bool) {
	return nil, false
}

// AsBasicListCustomAlertRule is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsBasicListCustomAlertRule() (BasicListCustomAlertRule, bool) {
	return nil, false
}

// AsConnectionToIPNotAllowed is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsConnectionToIPNotAllowed() (*ConnectionToIPNotAllowed, bool) {
	return nil, false
}

// AsConnectionFromIPNotAllowed is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsConnectionFromIPNotAllowed() (*ConnectionFromIPNotAllowed, bool) {
	return nil, false
}

// AsLocalUserNotAllowed is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsLocalUserNotAllowed() (*LocalUserNotAllowed, bool) {
	return nil, false
}

// AsProcessNotAllowed is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsProcessNotAllowed() (*ProcessNotAllowed, bool) {
	return nil, false
}

// AsActiveConnectionsNotInAllowedRange is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsActiveConnectionsNotInAllowedRange() (*ActiveConnectionsNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsAmqpC2DMessagesNotInAllowedRange() (*AmqpC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsMqttC2DMessagesNotInAllowedRange() (*MqttC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsHTTPC2DMessagesNotInAllowedRange() (*HTTPC2DMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsAmqpC2DRejectedMessagesNotInAllowedRange() (*AmqpC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsMqttC2DRejectedMessagesNotInAllowedRange() (*MqttC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPC2DRejectedMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsHTTPC2DRejectedMessagesNotInAllowedRange() (*HTTPC2DRejectedMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsAmqpD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsAmqpD2CMessagesNotInAllowedRange() (*AmqpD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsMqttD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsMqttD2CMessagesNotInAllowedRange() (*MqttD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsHTTPD2CMessagesNotInAllowedRange is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsHTTPD2CMessagesNotInAllowedRange() (*HTTPD2CMessagesNotInAllowedRange, bool) {
	return nil, false
}

// AsDirectMethodInvokesNotInAllowedRange is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsDirectMethodInvokesNotInAllowedRange() (*DirectMethodInvokesNotInAllowedRange, bool) {
	return nil, false
}

// AsFailedLocalLoginsNotInAllowedRange is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsFailedLocalLoginsNotInAllowedRange() (*FailedLocalLoginsNotInAllowedRange, bool) {
	return nil, false
}

// AsFileUploadsNotInAllowedRange is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsFileUploadsNotInAllowedRange() (*FileUploadsNotInAllowedRange, bool) {
	return nil, false
}

// AsQueuePurgesNotInAllowedRange is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsQueuePurgesNotInAllowedRange() (*QueuePurgesNotInAllowedRange, bool) {
	return nil, false
}

// AsTwinUpdatesNotInAllowedRange is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsTwinUpdatesNotInAllowedRange() (*TwinUpdatesNotInAllowedRange, bool) {
	return nil, false
}

// AsUnauthorizedOperationsNotInAllowedRange is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsUnauthorizedOperationsNotInAllowedRange() (*UnauthorizedOperationsNotInAllowedRange, bool) {
	return nil, false
}

// AsCustomAlertRule is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsCustomAlertRule() (*CustomAlertRule, bool) {
	return nil, false
}

// AsBasicCustomAlertRule is the BasicCustomAlertRule implementation for TimeWindowCustomAlertRule.
func (twcar TimeWindowCustomAlertRule) AsBasicCustomAlertRule() (BasicCustomAlertRule, bool) {
	return &twcar, true
}

// TopologyList ...
type TopologyList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY
	Value *[]TopologyResource `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URI to fetch the next page.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for TopologyList.
func (tl TopologyList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// TopologyListIterator provides access to a complete listing of TopologyResource values.
type TopologyListIterator struct {
	i    int
	page TopologyListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TopologyListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TopologyListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TopologyListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TopologyListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TopologyListIterator) Response() TopologyList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TopologyListIterator) Value() TopologyResource {
	if !iter.page.NotDone() {
		return TopologyResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TopologyListIterator type.
func NewTopologyListIterator(page TopologyListPage) TopologyListIterator {
	return TopologyListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tl TopologyList) IsEmpty() bool {
	return tl.Value == nil || len(*tl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (tl TopologyList) hasNextLink() bool {
	return tl.NextLink != nil && len(*tl.NextLink) != 0
}

// topologyListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tl TopologyList) topologyListPreparer(ctx context.Context) (*http.Request, error) {
	if !tl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tl.NextLink)))
}

// TopologyListPage contains a page of TopologyResource values.
type TopologyListPage struct {
	fn func(context.Context, TopologyList) (TopologyList, error)
	tl TopologyList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TopologyListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TopologyListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.tl)
		if err != nil {
			return err
		}
		page.tl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TopologyListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TopologyListPage) NotDone() bool {
	return !page.tl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TopologyListPage) Response() TopologyList {
	return page.tl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TopologyListPage) Values() []TopologyResource {
	if page.tl.IsEmpty() {
		return nil
	}
	return *page.tl.Value
}

// Creates a new instance of the TopologyListPage type.
func NewTopologyListPage(cur TopologyList, getNextPage func(context.Context, TopologyList) (TopologyList, error)) TopologyListPage {
	return TopologyListPage{
		fn: getNextPage,
		tl: cur,
	}
}

// TopologyResource ...
type TopologyResource struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Location where the resource is stored
	Location *string `json:"location,omitempty"`
	// TopologyResourceProperties - READ-ONLY
	*TopologyResourceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for TopologyResource.
func (tr TopologyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TopologyResource struct.
func (tr *TopologyResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				tr.Location = &location
			}
		case "properties":
			if v != nil {
				var topologyResourceProperties TopologyResourceProperties
				err = json.Unmarshal(*v, &topologyResourceProperties)
				if err != nil {
					return err
				}
				tr.TopologyResourceProperties = &topologyResourceProperties
			}
		}
	}

	return nil
}

// TopologyResourceProperties ...
type TopologyResourceProperties struct {
	// CalculatedDateTime - READ-ONLY; The UTC time on which the topology was calculated
	CalculatedDateTime *date.Time `json:"calculatedDateTime,omitempty"`
	// TopologyResources - READ-ONLY; Azure resources which are part of this topology resource
	TopologyResources *[]TopologySingleResource `json:"topologyResources,omitempty"`
}

// MarshalJSON is the custom marshaler for TopologyResourceProperties.
func (trp TopologyResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// TopologySingleResource ...
type TopologySingleResource struct {
	// ResourceID - READ-ONLY; Azure resource id
	ResourceID *string `json:"resourceId,omitempty"`
	// Severity - READ-ONLY; The security severity of the resource
	Severity *string `json:"severity,omitempty"`
	// RecommendationsExist - READ-ONLY; Indicates if the resource has security recommendations
	RecommendationsExist *bool `json:"recommendationsExist,omitempty"`
	// NetworkZones - READ-ONLY; Indicates the resource connectivity level to the Internet (InternetFacing, Internal ,etc.)
	NetworkZones *string `json:"networkZones,omitempty"`
	// TopologyScore - READ-ONLY; Score of the resource based on its security severity
	TopologyScore *int32 `json:"topologyScore,omitempty"`
	// Location - READ-ONLY; The location of this resource
	Location *string `json:"location,omitempty"`
	// Parents - READ-ONLY; Azure resources connected to this resource which are in higher level in the topology view
	Parents *[]TopologySingleResourceParent `json:"parents,omitempty"`
	// Children - READ-ONLY; Azure resources connected to this resource which are in lower level in the topology view
	Children *[]TopologySingleResourceChild `json:"children,omitempty"`
}

// MarshalJSON is the custom marshaler for TopologySingleResource.
func (tsr TopologySingleResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// TopologySingleResourceChild ...
type TopologySingleResourceChild struct {
	// ResourceID - READ-ONLY; Azure resource id which serves as child resource in topology view
	ResourceID *string `json:"resourceId,omitempty"`
}

// MarshalJSON is the custom marshaler for TopologySingleResourceChild.
func (tsrc TopologySingleResourceChild) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// TopologySingleResourceParent ...
type TopologySingleResourcePar