package diagnostics

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// PredictiveMetricClient is the monitor Management Client
type PredictiveMetricClient struct {
	BaseClient
}

// NewPredictiveMetricClient creates an instance of the PredictiveMetricClient client.
func NewPredictiveMetricClient(subscriptionID string) PredictiveMetricClient {
	return NewPredictiveMetricClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewPredictiveMetricClientWithBaseURI creates an instance of the PredictiveMetricClient client using a custom
// endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure
// stack).
func NewPredictiveMetricClientWithBaseURI(baseURI string, subscriptionID string) PredictiveMetricClient {
	return PredictiveMetricClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Get get predictive autoscale metric future data
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// autoscaleSettingName - the autoscale setting name.
// timespan - the timespan of the query. It is a string with the following format
// 'startDateTime_ISO/endDateTime_ISO'.
// interval - the interval (i.e. timegrain) of the query.
// metricNamespace - metric namespace to query metric definitions for.
// metricName - the names of the metrics (comma separated) to retrieve. Special case: If a metricname itself
// has a comma in it then use %2 to indicate it. Eg: 'Metric,Name1' should be **'Metric%2Name1'**
// aggregation - the list of aggregation types (comma separated) to retrieve.
func (client PredictiveMetricClient) Get(ctx context.Context, resourceGroupName string, autoscaleSettingName string, timespan string, interval string, metricNamespace string, metricName string, aggregation string) (result PredictiveResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PredictiveMetricClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("diagnostics.PredictiveMetricClient", "Get", err.Error())
	}

	req, err := client.GetPreparer(ctx, resourceGroupName, autoscaleSettingName, timespan, interval, metricNamespace, metricName, aggregation)
	if err != nil {
		err = autorest.NewErrorWithError(err, "diagnostics.PredictiveMetricClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "diagnostics.PredictiveMetricClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "diagnostics.PredictiveMetricClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client PredictiveMetricClient) GetPreparer(ctx context.Context, resourceGroupName string, autoscaleSettingName string, timespan string, interval string, metricNamespace string, metricName string, aggregation string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"autoscaleSettingName": autorest.Encode("path", autoscaleSettingName),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-05-01-preview"
	queryParameters := map[string]interface{}{
		"aggregation":     autorest.Encode("query", aggregation),
		"api-version":     APIVersion,
		"interval":        autorest.Encode("query", interval),
		"metricName":      autorest.Encode("query", metricName),
		"metricNamespace": autorest.Encode("query", metricNamespace),
		"timespan":        autorest.Encode("query", timespan),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Insights/autoscalesettings/{autoscaleSettingName}/predictiveMetrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client PredictiveMetricClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client PredictiveMetricClient) GetResponder(resp *http.Response) (result PredictiveResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
