// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package connectwisdomservice

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateAssistant = "CreateAssistant"

// CreateAssistantRequest generates a "aws/request.Request" representing the
// client's request for the CreateAssistant operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAssistant for more information on using the CreateAssistant
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAssistantRequest method.
//    req, resp := client.CreateAssistantRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/CreateAssistant
func (c *ConnectWisdomService) CreateAssistantRequest(input *CreateAssistantInput) (req *request.Request, output *CreateAssistantOutput) {
	op := &request.Operation{
		Name:       opCreateAssistant,
		HTTPMethod: "POST",
		HTTPPath:   "/assistants",
	}

	if input == nil {
		input = &CreateAssistantInput{}
	}

	output = &CreateAssistantOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAssistant API operation for Amazon Connect Wisdom Service.
//
// Creates an Amazon Connect Wisdom assistant.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Wisdom Service's
// API operation CreateAssistant for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The request could not be processed because of conflict in the current state
//   of the resource. For example, if you're using a Create API (such as CreateAssistant)
//   that accepts name, a conflicting resource (usually with the same name) is
//   being created or mutated.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * ServiceQuotaExceededException
//   You've exceeded your service quota. To perform the requested action, remove
//   some of the relevant resources, or use service quotas to request a service
//   quota increase.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/CreateAssistant
func (c *ConnectWisdomService) CreateAssistant(input *CreateAssistantInput) (*CreateAssistantOutput, error) {
	req, out := c.CreateAssistantRequest(input)
	return out, req.Send()
}

// CreateAssistantWithContext is the same as CreateAssistant with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAssistant for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) CreateAssistantWithContext(ctx aws.Context, input *CreateAssistantInput, opts ...request.Option) (*CreateAssistantOutput, error) {
	req, out := c.CreateAssistantRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAssistantAssociation = "CreateAssistantAssociation"

// CreateAssistantAssociationRequest generates a "aws/request.Request" representing the
// client's request for the CreateAssistantAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAssistantAssociation for more information on using the CreateAssistantAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAssistantAssociationRequest method.
//    req, resp := client.CreateAssistantAssociationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/CreateAssistantAssociation
func (c *ConnectWisdomService) CreateAssistantAssociationRequest(input *CreateAssistantAssociationInput) (req *request.Request, output *CreateAssistantAssociationOutput) {
	op := &request.Operation{
		Name:       opCreateAssistantAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/assistants/{assistantId}/associations",
	}

	if input == nil {
		input = &CreateAssistantAssociationInput{}
	}

	output = &CreateAssistantAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAssistantAssociation API operation for Amazon Connect Wisdom Service.
//
// Creates an association between an Amazon Connect Wisdom assistant and another
// resource. Currently, the only supported association is with a knowledge base.
// An assistant can have only a single association.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Wisdom Service's
// API operation CreateAssistantAssociation for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The request could not be processed because of conflict in the current state
//   of the resource. For example, if you're using a Create API (such as CreateAssistant)
//   that accepts name, a conflicting resource (usually with the same name) is
//   being created or mutated.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * ServiceQuotaExceededException
//   You've exceeded your service quota. To perform the requested action, remove
//   some of the relevant resources, or use service quotas to request a service
//   quota increase.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/CreateAssistantAssociation
func (c *ConnectWisdomService) CreateAssistantAssociation(input *CreateAssistantAssociationInput) (*CreateAssistantAssociationOutput, error) {
	req, out := c.CreateAssistantAssociationRequest(input)
	return out, req.Send()
}

// CreateAssistantAssociationWithContext is the same as CreateAssistantAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAssistantAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) CreateAssistantAssociationWithContext(ctx aws.Context, input *CreateAssistantAssociationInput, opts ...request.Option) (*CreateAssistantAssociationOutput, error) {
	req, out := c.CreateAssistantAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateContent = "CreateContent"

// CreateContentRequest generates a "aws/request.Request" representing the
// client's request for the CreateContent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateContent for more information on using the CreateContent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateContentRequest method.
//    req, resp := client.CreateContentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/CreateContent
func (c *ConnectWisdomService) CreateContentRequest(input *CreateContentInput) (req *request.Request, output *CreateContentOutput) {
	op := &request.Operation{
		Name:       opCreateContent,
		HTTPMethod: "POST",
		HTTPPath:   "/knowledgeBases/{knowledgeBaseId}/contents",
	}

	if input == nil {
		input = &CreateContentInput{}
	}

	output = &CreateContentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateContent API operation for Amazon Connect Wisdom Service.
//
// Creates Wisdom content. Before to calling this API, use StartContentUpload
// (https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html)
// to upload an asset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Wisdom Service's
// API operation CreateContent for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The request could not be processed because of conflict in the current state
//   of the resource. For example, if you're using a Create API (such as CreateAssistant)
//   that accepts name, a conflicting resource (usually with the same name) is
//   being created or mutated.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * ServiceQuotaExceededException
//   You've exceeded your service quota. To perform the requested action, remove
//   some of the relevant resources, or use service quotas to request a service
//   quota increase.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/CreateContent
func (c *ConnectWisdomService) CreateContent(input *CreateContentInput) (*CreateContentOutput, error) {
	req, out := c.CreateContentRequest(input)
	return out, req.Send()
}

// CreateContentWithContext is the same as CreateContent with the addition of
// the ability to pass a context and additional request options.
//
// See CreateContent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) CreateContentWithContext(ctx aws.Context, input *CreateContentInput, opts ...request.Option) (*CreateContentOutput, error) {
	req, out := c.CreateContentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateKnowledgeBase = "CreateKnowledgeBase"

// CreateKnowledgeBaseRequest generates a "aws/request.Request" representing the
// client's request for the CreateKnowledgeBase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateKnowledgeBase for more information on using the CreateKnowledgeBase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateKnowledgeBaseRequest method.
//    req, resp := client.CreateKnowledgeBaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/CreateKnowledgeBase
func (c *ConnectWisdomService) CreateKnowledgeBaseRequest(input *CreateKnowledgeBaseInput) (req *request.Request, output *CreateKnowledgeBaseOutput) {
	op := &request.Operation{
		Name:       opCreateKnowledgeBase,
		HTTPMethod: "POST",
		HTTPPath:   "/knowledgeBases",
	}

	if input == nil {
		input = &CreateKnowledgeBaseInput{}
	}

	output = &CreateKnowledgeBaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateKnowledgeBase API operation for Amazon Connect Wisdom Service.
//
// Creates a knowledge base.
//
// When using this API, you cannot reuse Amazon AppIntegrations (https://docs.aws.amazon.com/appintegrations/latest/APIReference/Welcome.html)
// DataIntegrations with external knowledge bases such as Salesforce and ServiceNow.
// If you do, you'll get an InvalidRequestException error.
//
//    <p>For example, you're programmatically managing your external knowledge
//    base, and you want to add or remove one of the fields that is being ingested
//    from Salesforce. Do the following:</p> <ol> <li> <p>Call <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_DeleteKnowledgeBase.html">DeleteKnowledgeBase</a>.</p>
//    </li> <li> <p>Call <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_DeleteDataIntegration.html">DeleteDataIntegration</a>.</p>
//    </li> <li> <p>Call <a href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html">CreateDataIntegration</a>
//    to recreate the DataIntegration or a create different one.</p> </li> <li>
//    <p>Call CreateKnowledgeBase.</p> </li> </ol> </note>
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Wisdom Service's
// API operation CreateKnowledgeBase for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The request could not be processed because of conflict in the current state
//   of the resource. For example, if you're using a Create API (such as CreateAssistant)
//   that accepts name, a conflicting resource (usually with the same name) is
//   being created or mutated.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * ServiceQuotaExceededException
//   You've exceeded your service quota. To perform the requested action, remove
//   some of the relevant resources, or use service quotas to request a service
//   quota increase.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/CreateKnowledgeBase
func (c *ConnectWisdomService) CreateKnowledgeBase(input *CreateKnowledgeBaseInput) (*CreateKnowledgeBaseOutput, error) {
	req, out := c.CreateKnowledgeBaseRequest(input)
	return out, req.Send()
}

// CreateKnowledgeBaseWithContext is the same as CreateKnowledgeBase with the addition of
// the ability to pass a context and additional request options.
//
// See CreateKnowledgeBase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) CreateKnowledgeBaseWithContext(ctx aws.Context, input *CreateKnowledgeBaseInput, opts ...request.Option) (*CreateKnowledgeBaseOutput, error) {
	req, out := c.CreateKnowledgeBaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSession = "CreateSession"

// CreateSessionRequest generates a "aws/request.Request" representing the
// client's request for the CreateSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSession for more information on using the CreateSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSessionRequest method.
//    req, resp := client.CreateSessionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/CreateSession
func (c *ConnectWisdomService) CreateSessionRequest(input *CreateSessionInput) (req *request.Request, output *CreateSessionOutput) {
	op := &request.Operation{
		Name:       opCreateSession,
		HTTPMethod: "POST",
		HTTPPath:   "/assistants/{assistantId}/sessions",
	}

	if input == nil {
		input = &CreateSessionInput{}
	}

	output = &CreateSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSession API operation for Amazon Connect Wisdom Service.
//
// Creates a session. A session is a contextual container used for generating
// recommendations. Amazon Connect creates a new Wisdom session for each contact
// on which Wisdom is enabled.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Wisdom Service's
// API operation CreateSession for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The request could not be processed because of conflict in the current state
//   of the resource. For example, if you're using a Create API (such as CreateAssistant)
//   that accepts name, a conflicting resource (usually with the same name) is
//   being created or mutated.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/CreateSession
func (c *ConnectWisdomService) CreateSession(input *CreateSessionInput) (*CreateSessionOutput, error) {
	req, out := c.CreateSessionRequest(input)
	return out, req.Send()
}

// CreateSessionWithContext is the same as CreateSession with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) CreateSessionWithContext(ctx aws.Context, input *CreateSessionInput, opts ...request.Option) (*CreateSessionOutput, error) {
	req, out := c.CreateSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAssistant = "DeleteAssistant"

// DeleteAssistantRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAssistant operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAssistant for more information on using the DeleteAssistant
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAssistantRequest method.
//    req, resp := client.DeleteAssistantRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/DeleteAssistant
func (c *ConnectWisdomService) DeleteAssistantRequest(input *DeleteAssistantInput) (req *request.Request, output *DeleteAssistantOutput) {
	op := &request.Operation{
		Name:       opDeleteAssistant,
		HTTPMethod: "DELETE",
		HTTPPath:   "/assistants/{assistantId}",
	}

	if input == nil {
		input = &DeleteAssistantInput{}
	}

	output = &DeleteAssistantOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAssistant API operation for Amazon Connect Wisdom Service.
//
// Deletes an assistant.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Wisdom Service's
// API operation DeleteAssistant for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/DeleteAssistant
func (c *ConnectWisdomService) DeleteAssistant(input *DeleteAssistantInput) (*DeleteAssistantOutput, error) {
	req, out := c.DeleteAssistantRequest(input)
	return out, req.Send()
}

// DeleteAssistantWithContext is the same as DeleteAssistant with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAssistant for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) DeleteAssistantWithContext(ctx aws.Context, input *DeleteAssistantInput, opts ...request.Option) (*DeleteAssistantOutput, error) {
	req, out := c.DeleteAssistantRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAssistantAssociation = "DeleteAssistantAssociation"

// DeleteAssistantAssociationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAssistantAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAssistantAssociation for more information on using the DeleteAssistantAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAssistantAssociationRequest method.
//    req, resp := client.DeleteAssistantAssociationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/DeleteAssistantAssociation
func (c *ConnectWisdomService) DeleteAssistantAssociationRequest(input *DeleteAssistantAssociationInput) (req *request.Request, output *DeleteAssistantAssociationOutput) {
	op := &request.Operation{
		Name:       opDeleteAssistantAssociation,
		HTTPMethod: "DELETE",
		HTTPPath:   "/assistants/{assistantId}/associations/{assistantAssociationId}",
	}

	if input == nil {
		input = &DeleteAssistantAssociationInput{}
	}

	output = &DeleteAssistantAssociationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAssistantAssociation API operation for Amazon Connect Wisdom Service.
//
// Deletes an assistant association.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Wisdom Service's
// API operation DeleteAssistantAssociation for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/DeleteAssistantAssociation
func (c *ConnectWisdomService) DeleteAssistantAssociation(input *DeleteAssistantAssociationInput) (*DeleteAssistantAssociationOutput, error) {
	req, out := c.DeleteAssistantAssociationRequest(input)
	return out, req.Send()
}

// DeleteAssistantAssociationWithContext is the same as DeleteAssistantAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAssistantAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) DeleteAssistantAssociationWithContext(ctx aws.Context, input *DeleteAssistantAssociationInput, opts ...request.Option) (*DeleteAssistantAssociationOutput, error) {
	req, out := c.DeleteAssistantAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteContent = "DeleteContent"

// DeleteContentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteContent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteContent for more information on using the DeleteContent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteContentRequest method.
//    req, resp := client.DeleteContentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/DeleteContent
func (c *ConnectWisdomService) DeleteContentRequest(input *DeleteContentInput) (req *request.Request, output *DeleteContentOutput) {
	op := &request.Operation{
		Name:       opDeleteContent,
		HTTPMethod: "DELETE",
		HTTPPath:   "/knowledgeBases/{knowledgeBaseId}/contents/{contentId}",
	}

	if input == nil {
		input = &DeleteContentInput{}
	}

	output = &DeleteContentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteContent API operation for Amazon Connect Wisdom Service.
//
// Deletes the content.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Wisdom Service's
// API operation DeleteContent for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/DeleteContent
func (c *ConnectWisdomService) DeleteContent(input *DeleteContentInput) (*DeleteContentOutput, error) {
	req, out := c.DeleteContentRequest(input)
	return out, req.Send()
}

// DeleteContentWithContext is the same as DeleteContent with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteContent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) DeleteContentWithContext(ctx aws.Context, input *DeleteContentInput, opts ...request.Option) (*DeleteContentOutput, error) {
	req, out := c.DeleteContentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteKnowledgeBase = "DeleteKnowledgeBase"

// DeleteKnowledgeBaseRequest generates a "aws/request.Request" representing the
// client's request for the DeleteKnowledgeBase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteKnowledgeBase for more information on using the DeleteKnowledgeBase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteKnowledgeBaseRequest method.
//    req, resp := client.DeleteKnowledgeBaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/DeleteKnowledgeBase
func (c *ConnectWisdomService) DeleteKnowledgeBaseRequest(input *DeleteKnowledgeBaseInput) (req *request.Request, output *DeleteKnowledgeBaseOutput) {
	op := &request.Operation{
		Name:       opDeleteKnowledgeBase,
		HTTPMethod: "DELETE",
		HTTPPath:   "/knowledgeBases/{knowledgeBaseId}",
	}

	if input == nil {
		input = &DeleteKnowledgeBaseInput{}
	}

	output = &DeleteKnowledgeBaseOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteKnowledgeBase API operation for Amazon Connect Wisdom Service.
//
// Deletes the knowledge base.
//
// When you use this API to delete an external knowledge base such as Salesforce
// or ServiceNow, you must also delete the Amazon AppIntegrations (https://docs.aws.amazon.com/appintegrations/latest/APIReference/Welcome.html)
// DataIntegration. This is because you can't reuse the DataIntegration after
// it's been associated with an external knowledge base. However, you can delete
// and recreate it. See DeleteDataIntegration (https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_DeleteDataIntegration.html)
// and CreateDataIntegration (https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html)
// in the Amazon AppIntegrations API Reference.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Wisdom Service's
// API operation DeleteKnowledgeBase for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The request could not be processed because of conflict in the current state
//   of the resource. For example, if you're using a Create API (such as CreateAssistant)
//   that accepts name, a conflicting resource (usually with the same name) is
//   being created or mutated.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/DeleteKnowledgeBase
func (c *ConnectWisdomService) DeleteKnowledgeBase(input *DeleteKnowledgeBaseInput) (*DeleteKnowledgeBaseOutput, error) {
	req, out := c.DeleteKnowledgeBaseRequest(input)
	return out, req.Send()
}

// DeleteKnowledgeBaseWithContext is the same as DeleteKnowledgeBase with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteKnowledgeBase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) DeleteKnowledgeBaseWithContext(ctx aws.Context, input *DeleteKnowledgeBaseInput, opts ...request.Option) (*DeleteKnowledgeBaseOutput, error) {
	req, out := c.DeleteKnowledgeBaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAssistant = "GetAssistant"

// GetAssistantRequest generates a "aws/request.Request" representing the
// client's request for the GetAssistant operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAssistant for more information on using the GetAssistant
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAssistantRequest method.
//    req, resp := client.GetAssistantRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/GetAssistant
func (c *ConnectWisdomService) GetAssistantRequest(input *GetAssistantInput) (req *request.Request, output *GetAssistantOutput) {
	op := &request.Operation{
		Name:       opGetAssistant,
		HTTPMethod: "GET",
		HTTPPath:   "/assistants/{assistantId}",
	}

	if input == nil {
		input = &GetAssistantInput{}
	}

	output = &GetAssistantOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAssistant API operation for Amazon Connect Wisdom Service.
//
// Retrieves information about an assistant.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Wisdom Service's
// API operation GetAssistant for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/GetAssistant
func (c *ConnectWisdomService) GetAssistant(input *GetAssistantInput) (*GetAssistantOutput, error) {
	req, out := c.GetAssistantRequest(input)
	return out, req.Send()
}

// GetAssistantWithContext is the same as GetAssistant with the addition of
// the ability to pass a context and additional request options.
//
// See GetAssistant for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) GetAssistantWithContext(ctx aws.Context, input *GetAssistantInput, opts ...request.Option) (*GetAssistantOutput, error) {
	req, out := c.GetAssistantRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAssistantAssociation = "GetAssistantAssociation"

// GetAssistantAssociationRequest generates a "aws/request.Request" representing the
// client's request for the GetAssistantAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAssistantAssociation for more information on using the GetAssistantAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAssistantAssociationRequest method.
//    req, resp := client.GetAssistantAssociationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/GetAssistantAssociation
func (c *ConnectWisdomService) GetAssistantAssociationRequest(input *GetAssistantAssociationInput) (req *request.Request, output *GetAssistantAssociationOutput) {
	op := &request.Operation{
		Name:       opGetAssistantAssociation,
		HTTPMethod: "GET",
		HTTPPath:   "/assistants/{assistantId}/associations/{assistantAssociationId}",
	}

	if input == nil {
		input = &GetAssistantAssociationInput{}
	}

	output = &GetAssistantAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAssistantAssociation API operation for Amazon Connect Wisdom Service.
//
// Retrieves information about an assistant association.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Wisdom Service's
// API operation GetAssistantAssociation for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/GetAssistantAssociation
func (c *ConnectWisdomService) GetAssistantAssociation(input *GetAssistantAssociationInput) (*GetAssistantAssociationOutput, error) {
	req, out := c.GetAssistantAssociationRequest(input)
	return out, req.Send()
}

// GetAssistantAssociationWithContext is the same as GetAssistantAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See GetAssistantAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) GetAssistantAssociationWithContext(ctx aws.Context, input *GetAssistantAssociationInput, opts ...request.Option) (*GetAssistantAssociationOutput, error) {
	req, out := c.GetAssistantAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetContent = "GetContent"

// GetContentRequest generates a "aws/request.Request" representing the
// client's request for the GetContent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetContent for more information on using the GetContent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetContentRequest method.
//    req, resp := client.GetContentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/GetContent
func (c *ConnectWisdomService) GetContentRequest(input *GetContentInput) (req *request.Request, output *GetContentOutput) {
	op := &request.Operation{
		Name:       opGetContent,
		HTTPMethod: "GET",
		HTTPPath:   "/knowledgeBases/{knowledgeBaseId}/contents/{contentId}",
	}

	if input == nil {
		input = &GetContentInput{}
	}

	output = &GetContentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetContent API operation for Amazon Connect Wisdom Service.
//
// Retrieves content, including a pre-signed URL to download the content.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Wisdom Service's
// API operation GetContent for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/GetContent
func (c *ConnectWisdomService) GetContent(input *GetContentInput) (*GetContentOutput, error) {
	req, out := c.GetContentRequest(input)
	return out, req.Send()
}

// GetContentWithContext is the same as GetContent with the addition of
// the ability to pass a context and additional request options.
//
// See GetContent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) GetContentWithContext(ctx aws.Context, input *GetContentInput, opts ...request.Option) (*GetContentOutput, error) {
	req, out := c.GetContentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetContentSummary = "GetContentSummary"

// GetContentSummaryRequest generates a "aws/request.Request" representing the
// client's request for the GetContentSummary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetContentSummary for more information on using the GetContentSummary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetContentSummaryRequest method.
//    req, resp := client.GetContentSummaryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/GetContentSummary
func (c *ConnectWisdomService) GetContentSummaryRequest(input *GetContentSummaryInput) (req *request.Request, output *GetContentSummaryOutput) {
	op := &request.Operation{
		Name:       opGetContentSummary,
		HTTPMethod: "GET",
		HTTPPath:   "/knowledgeBases/{knowledgeBaseId}/contents/{contentId}/summary",
	}

	if input == nil {
		input = &GetContentSummaryInput{}
	}

	output = &GetContentSummaryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetContentSummary API operation for Amazon Connect Wisdom Service.
//
// Retrieves summary information about the content.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Wisdom Service's
// API operation GetContentSummary for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/GetContentSummary
func (c *ConnectWisdomService) GetContentSummary(input *GetContentSummaryInput) (*GetContentSummaryOutput, error) {
	req, out := c.GetContentSummaryRequest(input)
	return out, req.Send()
}

// GetContentSummaryWithContext is the same as GetContentSummary with the addition of
// the ability to pass a context and additional request options.
//
// See GetContentSummary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) GetContentSummaryWithContext(ctx aws.Context, input *GetContentSummaryInput, opts ...request.Option) (*GetContentSummaryOutput, error) {
	req, out := c.GetContentSummaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetKnowledgeBase = "GetKnowledgeBase"

// GetKnowledgeBaseRequest generates a "aws/request.Request" representing the
// client's request for the GetKnowledgeBase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetKnowledgeBase for more information on using the GetKnowledgeBase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetKnowledgeBaseRequest method.
//    req, resp := client.GetKnowledgeBaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/GetKnowledgeBase
func (c *ConnectWisdomService) GetKnowledgeBaseRequest(input *GetKnowledgeBaseInput) (req *request.Request, output *GetKnowledgeBaseOutput) {
	op := &request.Operation{
		Name:       opGetKnowledgeBase,
		HTTPMethod: "GET",
		HTTPPath:   "/knowledgeBases/{knowledgeBaseId}",
	}

	if input == nil {
		input = &GetKnowledgeBaseInput{}
	}

	output = &GetKnowledgeBaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetKnowledgeBase API operation for Amazon Connect Wisdom Service.
//
// Retrieves information about the knowledge base.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Wisdom Service's
// API operation GetKnowledgeBase for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/GetKnowledgeBase
func (c *ConnectWisdomService) GetKnowledgeBase(input *GetKnowledgeBaseInput) (*GetKnowledgeBaseOutput, error) {
	req, out := c.GetKnowledgeBaseRequest(input)
	return out, req.Send()
}

// GetKnowledgeBaseWithContext is the same as GetKnowledgeBase with the addition of
// the ability to pass a context and additional request options.
//
// See GetKnowledgeBase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) GetKnowledgeBaseWithContext(ctx aws.Context, input *GetKnowledgeBaseInput, opts ...request.Option) (*GetKnowledgeBaseOutput, error) {
	req, out := c.GetKnowledgeBaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRecommendations = "GetRecommendations"

// GetRecommendationsRequest generates a "aws/request.Request" representing the
// client's request for the GetRecommendations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRecommendations for more information on using the GetRecommendations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRecommendationsRequest method.
//    req, resp := client.GetRecommendationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/GetRecommendations
func (c *ConnectWisdomService) GetRecommendationsRequest(input *GetRecommendationsInput) (req *request.Request, output *GetRecommendationsOutput) {
	op := &request.Operation{
		Name:       opGetRecommendations,
		HTTPMethod: "GET",
		HTTPPath:   "/assistants/{assistantId}/sessions/{sessionId}/recommendations",
	}

	if input == nil {
		input = &GetRecommendationsInput{}
	}

	output = &GetRecommendationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRecommendations API operation for Amazon Connect Wisdom Service.
//
// Retrieves recommendations for the specified session. To avoid retrieving
// the same recommendations in subsequent calls, use NotifyRecommendationsReceived
// (https://docs.aws.amazon.com/wisdom/latest/APIReference/API_NotifyRecommendationsReceived.html).
// This API supports long-polling behavior with the waitTimeSeconds parameter.
// Short poll is the default behavior and only returns recommendations already
// available. To perform a manual query against an assistant, use QueryAssistant
// (https://docs.aws.amazon.com/wisdom/latest/APIReference/API_QueryAssistant.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Wisdom Service's
// API operation GetRecommendations for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/GetRecommendations
func (c *ConnectWisdomService) GetRecommendations(input *GetRecommendationsInput) (*GetRecommendationsOutput, error) {
	req, out := c.GetRecommendationsRequest(input)
	return out, req.Send()
}

// GetRecommendationsWithContext is the same as GetRecommendations with the addition of
// the ability to pass a context and additional request options.
//
// See GetRecommendations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) GetRecommendationsWithContext(ctx aws.Context, input *GetRecommendationsInput, opts ...request.Option) (*GetRecommendationsOutput, error) {
	req, out := c.GetRecommendationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSession = "GetSession"

// GetSessionRequest generates a "aws/request.Request" representing the
// client's request for the GetSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSession for more information on using the GetSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSessionRequest method.
//    req, resp := client.GetSessionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/GetSession
func (c *ConnectWisdomService) GetSessionRequest(input *GetSessionInput) (req *request.Request, output *GetSessionOutput) {
	op := &request.Operation{
		Name:       opGetSession,
		HTTPMethod: "GET",
		HTTPPath:   "/assistants/{assistantId}/sessions/{sessionId}",
	}

	if input == nil {
		input = &GetSessionInput{}
	}

	output = &GetSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSession API operation for Amazon Connect Wisdom Service.
//
// Retrieves information for a specified session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Wisdom Service's
// API operation GetSession for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/GetSession
func (c *ConnectWisdomService) GetSession(input *GetSessionInput) (*GetSessionOutput, error) {
	req, out := c.GetSessionRequest(input)
	return out, req.Send()
}

// GetSessionWithContext is the same as GetSession with the addition of
// the ability to pass a context and additional request options.
//
// See GetSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) GetSessionWithContext(ctx aws.Context, input *GetSessionInput, opts ...request.Option) (*GetSessionOutput, error) {
	req, out := c.GetSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAssistantAssociations = "ListAssistantAssociations"

// ListAssistantAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListAssistantAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssistantAssociations for more information on using the ListAssistantAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAssistantAssociationsRequest method.
//    req, resp := client.ListAssistantAssociationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/ListAssistantAssociations
func (c *ConnectWisdomService) ListAssistantAssociationsRequest(input *ListAssistantAssociationsInput) (req *request.Request, output *ListAssistantAssociationsOutput) {
	op := &request.Operation{
		Name:       opListAssistantAssociations,
		HTTPMethod: "GET",
		HTTPPath:   "/assistants/{assistantId}/associations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssistantAssociationsInput{}
	}

	output = &ListAssistantAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAssistantAssociations API operation for Amazon Connect Wisdom Service.
//
// Lists information about assistant associations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Wisdom Service's
// API operation ListAssistantAssociations for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/ListAssistantAssociations
func (c *ConnectWisdomService) ListAssistantAssociations(input *ListAssistantAssociationsInput) (*ListAssistantAssociationsOutput, error) {
	req, out := c.ListAssistantAssociationsRequest(input)
	return out, req.Send()
}

// ListAssistantAssociationsWithContext is the same as ListAssistantAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssistantAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) ListAssistantAssociationsWithContext(ctx aws.Context, input *ListAssistantAssociationsInput, opts ...request.Option) (*ListAssistantAssociationsOutput, error) {
	req, out := c.ListAssistantAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAssistantAssociationsPages iterates over the pages of a ListAssistantAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAssistantAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAssistantAssociations operation.
//    pageNum := 0
//    err := client.ListAssistantAssociationsPages(params,
//        func(page *connectwisdomservice.ListAssistantAssociationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConnectWisdomService) ListAssistantAssociationsPages(input *ListAssistantAssociationsInput, fn func(*ListAssistantAssociationsOutput, bool) bool) error {
	return c.ListAssistantAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAssistantAssociationsPagesWithContext same as ListAssistantAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) ListAssistantAssociationsPagesWithContext(ctx aws.Context, input *ListAssistantAssociationsInput, fn func(*ListAssistantAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAssistantAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAssistantAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAssistantAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAssistants = "ListAssistants"

// ListAssistantsRequest generates a "aws/request.Request" representing the
// client's request for the ListAssistants operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssistants for more information on using the ListAssistants
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAssistantsRequest method.
//    req, resp := client.ListAssistantsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/ListAssistants
func (c *ConnectWisdomService) ListAssistantsRequest(input *ListAssistantsInput) (req *request.Request, output *ListAssistantsOutput) {
	op := &request.Operation{
		Name:       opListAssistants,
		HTTPMethod: "GET",
		HTTPPath:   "/assistants",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssistantsInput{}
	}

	output = &ListAssistantsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAssistants API operation for Amazon Connect Wisdom Service.
//
// Lists information about assistants.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Wisdom Service's
// API operation ListAssistants for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/ListAssistants
func (c *ConnectWisdomService) ListAssistants(input *ListAssistantsInput) (*ListAssistantsOutput, error) {
	req, out := c.ListAssistantsRequest(input)
	return out, req.Send()
}

// ListAssistantsWithContext is the same as ListAssistants with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssistants for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) ListAssistantsWithContext(ctx aws.Context, input *ListAssistantsInput, opts ...request.Option) (*ListAssistantsOutput, error) {
	req, out := c.ListAssistantsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAssistantsPages iterates over the pages of a ListAssistants operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAssistants method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAssistants operation.
//    pageNum := 0
//    err := client.ListAssistantsPages(params,
//        func(page *connectwisdomservice.ListAssistantsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConnectWisdomService) ListAssistantsPages(input *ListAssistantsInput, fn func(*ListAssistantsOutput, bool) bool) error {
	return c.ListAssistantsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAssistantsPagesWithContext same as ListAssistantsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) ListAssistantsPagesWithContext(ctx aws.Context, input *ListAssistantsInput, fn func(*ListAssistantsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAssistantsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAssistantsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAssistantsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListContents = "ListContents"

// ListContentsRequest generates a "aws/request.Request" representing the
// client's request for the ListContents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListContents for more information on using the ListContents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListContentsRequest method.
//    req, resp := client.ListContentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/ListContents
func (c *ConnectWisdomService) ListContentsRequest(input *ListContentsInput) (req *request.Request, output *ListContentsOutput) {
	op := &request.Operation{
		Name:       opListContents,
		HTTPMethod: "GET",
		HTTPPath:   "/knowledgeBases/{knowledgeBaseId}/contents",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListContentsInput{}
	}

	output = &ListContentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListContents API operation for Amazon Connect Wisdom Service.
//
// Lists the content.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Wisdom Service's
// API operation ListContents for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/ListContents
func (c *ConnectWisdomService) ListContents(input *ListContentsInput) (*ListContentsOutput, error) {
	req, out := c.ListContentsRequest(input)
	return out, req.Send()
}

// ListContentsWithContext is the same as ListContents with the addition of
// the ability to pass a context and additional request options.
//
// See ListContents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) ListContentsWithContext(ctx aws.Context, input *ListContentsInput, opts ...request.Option) (*ListContentsOutput, error) {
	req, out := c.ListContentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListContentsPages iterates over the pages of a ListContents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListContents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListContents operation.
//    pageNum := 0
//    err := client.ListContentsPages(params,
//        func(page *connectwisdomservice.ListContentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConnectWisdomService) ListContentsPages(input *ListContentsInput, fn func(*ListContentsOutput, bool) bool) error {
	return c.ListContentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListContentsPagesWithContext same as ListContentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) ListContentsPagesWithContext(ctx aws.Context, input *ListContentsInput, fn func(*ListContentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListContentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListContentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListContentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListKnowledgeBases = "ListKnowledgeBases"

// ListKnowledgeBasesRequest generates a "aws/request.Request" representing the
// client's request for the ListKnowledgeBases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListKnowledgeBases for more information on using the ListKnowledgeBases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListKnowledgeBasesRequest method.
//    req, resp := client.ListKnowledgeBasesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/ListKnowledgeBases
func (c *ConnectWisdomService) ListKnowledgeBasesRequest(input *ListKnowledgeBasesInput) (req *request.Request, output *ListKnowledgeBasesOutput) {
	op := &request.Operation{
		Name:       opListKnowledgeBases,
		HTTPMethod: "GET",
		HTTPPath:   "/knowledgeBases",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListKnowledgeBasesInput{}
	}

	output = &ListKnowledgeBasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListKnowledgeBases API operation for Amazon Connect Wisdom Service.
//
// Lists the knowledge bases.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Wisdom Service's
// API operation ListKnowledgeBases for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/ListKnowledgeBases
func (c *ConnectWisdomService) ListKnowledgeBases(input *ListKnowledgeBasesInput) (*ListKnowledgeBasesOutput, error) {
	req, out := c.ListKnowledgeBasesRequest(input)
	return out, req.Send()
}

// ListKnowledgeBasesWithContext is the same as ListKnowledgeBases with the addition of
// the ability to pass a context and additional request options.
//
// See ListKnowledgeBases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) ListKnowledgeBasesWithContext(ctx aws.Context, input *ListKnowledgeBasesInput, opts ...request.Option) (*ListKnowledgeBasesOutput, error) {
	req, out := c.ListKnowledgeBasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListKnowledgeBasesPages iterates over the pages of a ListKnowledgeBases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListKnowledgeBases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListKnowledgeBases operation.
//    pageNum := 0
//    err := client.ListKnowledgeBasesPages(params,
//        func(page *connectwisdomservice.ListKnowledgeBasesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConnectWisdomService) ListKnowledgeBasesPages(input *ListKnowledgeBasesInput, fn func(*ListKnowledgeBasesOutput, bool) bool) error {
	return c.ListKnowledgeBasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListKnowledgeBasesPagesWithContext same as ListKnowledgeBasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) ListKnowledgeBasesPagesWithContext(ctx aws.Context, input *ListKnowledgeBasesInput, fn func(*ListKnowledgeBasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListKnowledgeBasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListKnowledgeBasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListKnowledgeBasesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/ListTagsForResource
func (c *ConnectWisdomService) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Connect Wisdom Service.
//
// Lists the tags for the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Wisdom Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/ListTagsForResource
func (c *ConnectWisdomService) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opNotifyRecommendationsReceived = "NotifyRecommendationsReceived"

// NotifyRecommendationsReceivedRequest generates a "aws/request.Request" representing the
// client's request for the NotifyRecommendationsReceived operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See NotifyRecommendationsReceived for more information on using the NotifyRecommendationsReceived
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the NotifyRecommendationsReceivedRequest method.
//    req, resp := client.NotifyRecommendationsReceivedRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/NotifyRecommendationsReceived
func (c *ConnectWisdomService) NotifyRecommendationsReceivedRequest(input *NotifyRecommendationsReceivedInput) (req *request.Request, output *NotifyRecommendationsReceivedOutput) {
	op := &request.Operation{
		Name:       opNotifyRecommendationsReceived,
		HTTPMethod: "POST",
		HTTPPath:   "/assistants/{assistantId}/sessions/{sessionId}/recommendations/notify",
	}

	if input == nil {
		input = &NotifyRecommendationsReceivedInput{}
	}

	output = &NotifyRecommendationsReceivedOutput{}
	req = c.newRequest(op, input, output)
	return
}

// NotifyRecommendationsReceived API operation for Amazon Connect Wisdom Service.
//
// Removes the specified recommendations from the specified assistant's queue
// of newly available recommendations. You can use this API in conjunction with
// GetRecommendations (https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetRecommendations.html)
// and a waitTimeSeconds input for long-polling behavior and avoiding duplicate
// recommendations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Wisdom Service's
// API operation NotifyRecommendationsReceived for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/NotifyRecommendationsReceived
func (c *ConnectWisdomService) NotifyRecommendationsReceived(input *NotifyRecommendationsReceivedInput) (*NotifyRecommendationsReceivedOutput, error) {
	req, out := c.NotifyRecommendationsReceivedRequest(input)
	return out, req.Send()
}

// NotifyRecommendationsReceivedWithContext is the same as NotifyRecommendationsReceived with the addition of
// the ability to pass a context and additional request options.
//
// See NotifyRecommendationsReceived for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) NotifyRecommendationsReceivedWithContext(ctx aws.Context, input *NotifyRecommendationsReceivedInput, opts ...request.Option) (*NotifyRecommendationsReceivedOutput, error) {
	req, out := c.NotifyRecommendationsReceivedRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opQueryAssistant = "QueryAssistant"

// QueryAssistantRequest generates a "aws/request.Request" representing the
// client's request for the QueryAssistant operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See QueryAssistant for more information on using the QueryAssistant
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the QueryAssistantRequest method.
//    req, resp := client.QueryAssistantRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/QueryAssistant
func (c *ConnectWisdomService) QueryAssistantRequest(input *QueryAssistantInput) (req *request.Request, output *QueryAssistantOutput) {
	op := &request.Operation{
		Name:       opQueryAssistant,
		HTTPMethod: "POST",
		HTTPPath:   "/assistants/{assistantId}/query",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &QueryAssistantInput{}
	}

	output = &QueryAssistantOutput{}
	req = c.newRequest(op, input, output)
	return
}

// QueryAssistant API operation for Amazon Connect Wisdom Service.
//
// Performs a manual search against the specified assistant. To retrieve recommendations
// for an assistant, use GetRecommendations (https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetRecommendations.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Wisdom Service's
// API operation QueryAssistant for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/QueryAssistant
func (c *ConnectWisdomService) QueryAssistant(input *QueryAssistantInput) (*QueryAssistantOutput, error) {
	req, out := c.QueryAssistantRequest(input)
	return out, req.Send()
}

// QueryAssistantWithContext is the same as QueryAssistant with the addition of
// the ability to pass a context and additional request options.
//
// See QueryAssistant for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) QueryAssistantWithContext(ctx aws.Context, input *QueryAssistantInput, opts ...request.Option) (*QueryAssistantOutput, error) {
	req, out := c.QueryAssistantRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// QueryAssistantPages iterates over the pages of a QueryAssistant operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See QueryAssistant method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a QueryAssistant operation.
//    pageNum := 0
//    err := client.QueryAssistantPages(params,
//        func(page *connectwisdomservice.QueryAssistantOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConnectWisdomService) QueryAssistantPages(input *QueryAssistantInput, fn func(*QueryAssistantOutput, bool) bool) error {
	return c.QueryAssistantPagesWithContext(aws.BackgroundContext(), input, fn)
}

// QueryAssistantPagesWithContext same as QueryAssistantPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) QueryAssistantPagesWithContext(ctx aws.Context, input *QueryAssistantInput, fn func(*QueryAssistantOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *QueryAssistantInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.QueryAssistantRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*QueryAssistantOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opRemoveKnowledgeBaseTemplateUri = "RemoveKnowledgeBaseTemplateUri"

// RemoveKnowledgeBaseTemplateUriRequest generates a "aws/request.Request" representing the
// client's request for the RemoveKnowledgeBaseTemplateUri operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveKnowledgeBaseTemplateUri for more information on using the RemoveKnowledgeBaseTemplateUri
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveKnowledgeBaseTemplateUriRequest method.
//    req, resp := client.RemoveKnowledgeBaseTemplateUriRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/RemoveKnowledgeBaseTemplateUri
func (c *ConnectWisdomService) RemoveKnowledgeBaseTemplateUriRequest(input *RemoveKnowledgeBaseTemplateUriInput) (req *request.Request, output *RemoveKnowledgeBaseTemplateUriOutput) {
	op := &request.Operation{
		Name:       opRemoveKnowledgeBaseTemplateUri,
		HTTPMethod: "DELETE",
		HTTPPath:   "/knowledgeBases/{knowledgeBaseId}/templateUri",
	}

	if input == nil {
		input = &RemoveKnowledgeBaseTemplateUriInput{}
	}

	output = &RemoveKnowledgeBaseTemplateUriOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveKnowledgeBaseTemplateUri API operation for Amazon Connect Wisdom Service.
//
// Removes a URI template from a knowledge base.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Wisdom Service's
// API operation RemoveKnowledgeBaseTemplateUri for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/RemoveKnowledgeBaseTemplateUri
func (c *ConnectWisdomService) RemoveKnowledgeBaseTemplateUri(input *RemoveKnowledgeBaseTemplateUriInput) (*RemoveKnowledgeBaseTemplateUriOutput, error) {
	req, out := c.RemoveKnowledgeBaseTemplateUriRequest(input)
	return out, req.Send()
}

// RemoveKnowledgeBaseTemplateUriWithContext is the same as RemoveKnowledgeBaseTemplateUri with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveKnowledgeBaseTemplateUri for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) RemoveKnowledgeBaseTemplateUriWithContext(ctx aws.Context, input *RemoveKnowledgeBaseTemplateUriInput, opts ...request.Option) (*RemoveKnowledgeBaseTemplateUriOutput, error) {
	req, out := c.RemoveKnowledgeBaseTemplateUriRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchContent = "SearchContent"

// SearchContentRequest generates a "aws/request.Request" representing the
// client's request for the SearchContent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchContent for more information on using the SearchContent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchContentRequest method.
//    req, resp := client.SearchContentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/SearchContent
func (c *ConnectWisdomService) SearchContentRequest(input *SearchContentInput) (req *request.Request, output *SearchContentOutput) {
	op := &request.Operation{
		Name:       opSearchContent,
		HTTPMethod: "POST",
		HTTPPath:   "/knowledgeBases/{knowledgeBaseId}/search",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchContentInput{}
	}

	output = &SearchContentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchContent API operation for Amazon Connect Wisdom Service.
//
// Searches for content in a specified knowledge base. Can be used to get a
// specific content resource by its name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Wisdom Service's
// API operation SearchContent for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/SearchContent
func (c *ConnectWisdomService) SearchContent(input *SearchContentInput) (*SearchContentOutput, error) {
	req, out := c.SearchContentRequest(input)
	return out, req.Send()
}

// SearchContentWithContext is the same as SearchContent with the addition of
// the ability to pass a context and additional request options.
//
// See SearchContent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) SearchContentWithContext(ctx aws.Context, input *SearchContentInput, opts ...request.Option) (*SearchContentOutput, error) {
	req, out := c.SearchContentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchContentPages iterates over the pages of a SearchContent operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchContent method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SearchContent operation.
//    pageNum := 0
//    err := client.SearchContentPages(params,
//        func(page *connectwisdomservice.SearchContentOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConnectWisdomService) SearchContentPages(input *SearchContentInput, fn func(*SearchContentOutput, bool) bool) error {
	return c.SearchContentPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchContentPagesWithContext same as SearchContentPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) SearchContentPagesWithContext(ctx aws.Context, input *SearchContentInput, fn func(*SearchContentOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchContentInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchContentRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchContentOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchSessions = "SearchSessions"

// SearchSessionsRequest generates a "aws/request.Request" representing the
// client's request for the SearchSessions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchSessions for more information on using the SearchSessions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchSessionsRequest method.
//    req, resp := client.SearchSessionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/SearchSessions
func (c *ConnectWisdomService) SearchSessionsRequest(input *SearchSessionsInput) (req *request.Request, output *SearchSessionsOutput) {
	op := &request.Operation{
		Name:       opSearchSessions,
		HTTPMethod: "POST",
		HTTPPath:   "/assistants/{assistantId}/searchSessions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchSessionsInput{}
	}

	output = &SearchSessionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchSessions API operation for Amazon Connect Wisdom Service.
//
// Searches for sessions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Wisdom Service's
// API operation SearchSessions for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/SearchSessions
func (c *ConnectWisdomService) SearchSessions(input *SearchSessionsInput) (*SearchSessionsOutput, error) {
	req, out := c.SearchSessionsRequest(input)
	return out, req.Send()
}

// SearchSessionsWithContext is the same as SearchSessions with the addition of
// the ability to pass a context and additional request options.
//
// See SearchSessions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) SearchSessionsWithContext(ctx aws.Context, input *SearchSessionsInput, opts ...request.Option) (*SearchSessionsOutput, error) {
	req, out := c.SearchSessionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchSessionsPages iterates over the pages of a SearchSessions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchSessions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SearchSessions operation.
//    pageNum := 0
//    err := client.SearchSessionsPages(params,
//        func(page *connectwisdomservice.SearchSessionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConnectWisdomService) SearchSessionsPages(input *SearchSessionsInput, fn func(*SearchSessionsOutput, bool) bool) error {
	return c.SearchSessionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchSessionsPagesWithContext same as SearchSessionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) SearchSessionsPagesWithContext(ctx aws.Context, input *SearchSessionsInput, fn func(*SearchSessionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchSessionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchSessionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchSessionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartContentUpload = "StartContentUpload"

// StartContentUploadRequest generates a "aws/request.Request" representing the
// client's request for the StartContentUpload operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartContentUpload for more information on using the StartContentUpload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartContentUploadRequest method.
//    req, resp := client.StartContentUploadRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/StartContentUpload
func (c *ConnectWisdomService) StartContentUploadRequest(input *StartContentUploadInput) (req *request.Request, output *StartContentUploadOutput) {
	op := &request.Operation{
		Name:       opStartContentUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/knowledgeBases/{knowledgeBaseId}/upload",
	}

	if input == nil {
		input = &StartContentUploadInput{}
	}

	output = &StartContentUploadOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartContentUpload API operation for Amazon Connect Wisdom Service.
//
// Get a URL to upload content to a knowledge base. To upload content, first
// make a PUT request to the returned URL with your file, making sure to include
// the required headers. Then use CreateContent (https://docs.aws.amazon.com/wisdom/latest/APIReference/API_CreateContent.html)
// to finalize the content creation process or UpdateContent (https://docs.aws.amazon.com/wisdom/latest/APIReference/API_UpdateContent.html)
// to modify an existing resource. You can only upload content to a knowledge
// base of type CUSTOM.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Wisdom Service's
// API operation StartContentUpload for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/StartContentUpload
func (c *ConnectWisdomService) StartContentUpload(input *StartContentUploadInput) (*StartContentUploadOutput, error) {
	req, out := c.StartContentUploadRequest(input)
	return out, req.Send()
}

// StartContentUploadWithContext is the same as StartContentUpload with the addition of
// the ability to pass a context and additional request options.
//
// See StartContentUpload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) StartContentUploadWithContext(ctx aws.Context, input *StartContentUploadInput, opts ...request.Option) (*StartContentUploadOutput, error) {
	req, out := c.StartContentUploadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/TagResource
func (c *ConnectWisdomService) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Connect Wisdom Service.
//
// Adds the specified tags to the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Wisdom Service's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * TooManyTagsException
//   Amazon Connect Wisdom throws this exception if you have too many tags in
//   your tag set.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/TagResource
func (c *ConnectWisdomService) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/UntagResource
func (c *ConnectWisdomService) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Connect Wisdom Service.
//
// Removes the specified tags from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Wisdom Service's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/UntagResource
func (c *ConnectWisdomService) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateContent = "UpdateContent"

// UpdateContentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateContent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateContent for more information on using the UpdateContent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateContentRequest method.
//    req, resp := client.UpdateContentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/UpdateContent
func (c *ConnectWisdomService) UpdateContentRequest(input *UpdateContentInput) (req *request.Request, output *UpdateContentOutput) {
	op := &request.Operation{
		Name:       opUpdateContent,
		HTTPMethod: "POST",
		HTTPPath:   "/knowledgeBases/{knowledgeBaseId}/contents/{contentId}",
	}

	if input == nil {
		input = &UpdateContentInput{}
	}

	output = &UpdateContentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateContent API operation for Amazon Connect Wisdom Service.
//
// Updates information about the content.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Wisdom Service's
// API operation UpdateContent for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * PreconditionFailedException
//   The provided revisionId does not match, indicating the content has been modified
//   since it was last read.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/UpdateContent
func (c *ConnectWisdomService) UpdateContent(input *UpdateContentInput) (*UpdateContentOutput, error) {
	req, out := c.UpdateContentRequest(input)
	return out, req.Send()
}

// UpdateContentWithContext is the same as UpdateContent with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateContent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) UpdateContentWithContext(ctx aws.Context, input *UpdateContentInput, opts ...request.Option) (*UpdateContentOutput, error) {
	req, out := c.UpdateContentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateKnowledgeBaseTemplateUri = "UpdateKnowledgeBaseTemplateUri"

// UpdateKnowledgeBaseTemplateUriRequest generates a "aws/request.Request" representing the
// client's request for the UpdateKnowledgeBaseTemplateUri operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateKnowledgeBaseTemplateUri for more information on using the UpdateKnowledgeBaseTemplateUri
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateKnowledgeBaseTemplateUriRequest method.
//    req, resp := client.UpdateKnowledgeBaseTemplateUriRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/UpdateKnowledgeBaseTemplateUri
func (c *ConnectWisdomService) UpdateKnowledgeBaseTemplateUriRequest(input *UpdateKnowledgeBaseTemplateUriInput) (req *request.Request, output *UpdateKnowledgeBaseTemplateUriOutput) {
	op := &request.Operation{
		Name:       opUpdateKnowledgeBaseTemplateUri,
		HTTPMethod: "POST",
		HTTPPath:   "/knowledgeBases/{knowledgeBaseId}/templateUri",
	}

	if input == nil {
		input = &UpdateKnowledgeBaseTemplateUriInput{}
	}

	output = &UpdateKnowledgeBaseTemplateUriOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateKnowledgeBaseTemplateUri API operation for Amazon Connect Wisdom Service.
//
// Updates the template URI of a knowledge base. This is only supported for
// knowledge bases of type EXTERNAL. Include a single variable in ${variable}
// format; this interpolated by Wisdom using ingested content. For example,
// if you ingest a Salesforce article, it has an Id value, and you can set the
// template URI to https://myInstanceName.lightning.force.com/lightning/r/Knowledge__kav/*${Id}*/view.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Wisdom Service's
// API operation UpdateKnowledgeBaseTemplateUri for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/wisdom-2020-10-19/UpdateKnowledgeBaseTemplateUri
func (c *ConnectWisdomService) UpdateKnowledgeBaseTemplateUri(input *UpdateKnowledgeBaseTemplateUriInput) (*UpdateKnowledgeBaseTemplateUriOutput, error) {
	req, out := c.UpdateKnowledgeBaseTemplateUriRequest(input)
	return out, req.Send()
}

// UpdateKnowledgeBaseTemplateUriWithContext is the same as UpdateKnowledgeBaseTemplateUri with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateKnowledgeBaseTemplateUri for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectWisdomService) UpdateKnowledgeBaseTemplateUriWithContext(ctx aws.Context, input *UpdateKnowledgeBaseTemplateUriInput, opts ...request.Option) (*UpdateKnowledgeBaseTemplateUriOutput, error) {
	req, out := c.UpdateKnowledgeBaseTemplateUriRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Configuration information for Amazon AppIntegrations to automatically ingest
// content.
type AppIntegrationsConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AppIntegrations DataIntegration to
	// use for ingesting content.
	//
	// AppIntegrationArn is a required field
	AppIntegrationArn *string `locationName:"appIntegrationArn" min:"1" type:"string" required:"true"`

	// The fields from the source that are made available to your agents in Wisdom.
	//
	//    * For Salesforce (https://developer.salesforce.com/docs/atlas.en-us.knowledge_dev.meta/knowledge_dev/sforce_api_objects_knowledge__kav.htm),
	//    you must include at least Id, ArticleNumber, VersionNumber, Title, PublishStatus,
	//    and IsDeleted.
	//
	//    * For ServiceNow (https://developer.servicenow.com/dev.do#!/reference/api/rome/rest/knowledge-management-api),
	//    you must include at least number, short_description, sys_mod_count, workflow_state,
	//    and active.
	//
	// Make sure to include additional field(s); these are indexed and used to source
	// recommendations.
	//
	// ObjectFields is a required field
	ObjectFields []*string `locationName:"objectFields" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppIntegrationsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AppIntegrationsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AppIntegrationsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AppIntegrationsConfiguration"}
	if s.AppIntegrationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppIntegrationArn"))
	}
	if s.AppIntegrationArn != nil && len(*s.AppIntegrationArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppIntegrationArn", 1))
	}
	if s.ObjectFields == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectFields"))
	}
	if s.ObjectFields != nil && len(s.ObjectFields) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectFields", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppIntegrationArn sets the AppIntegrationArn field's value.
func (s *AppIntegrationsConfiguration) SetAppIntegrationArn(v string) *AppIntegrationsConfiguration {
	s.AppIntegrationArn = &v
	return s
}

// SetObjectFields sets the ObjectFields field's value.
func (s *AppIntegrationsConfiguration) SetObjectFields(v []*string) *AppIntegrationsConfiguration {
	s.ObjectFields = v
	return s
}

// Information about the assistant association.
type AssistantAssociationData struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Wisdom assistant
	//
	// AssistantArn is a required field
	AssistantArn *string `locationName:"assistantArn" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the assistant association.
	//
	// AssistantAssociationArn is a required field
	AssistantAssociationArn *string `locationName:"assistantAssociationArn" type:"string" required:"true"`

	// The identifier of the assistant association.
	//
	// AssistantAssociationId is a required field
	AssistantAssociationId *string `locationName:"assistantAssociationId" type:"string" required:"true"`

	// The identifier of the Wisdom assistant.
	//
	// AssistantId is a required field
	AssistantId *string `locationName:"assistantId" type:"string" required:"true"`

	// A union type that currently has a single argument, the knowledge base ID.
	//
	// AssociationData is a required field
	AssociationData *AssistantAssociationOutputData `locationName:"associationData" type:"structure" required:"true"`

	// The type of association.
	//
	// AssociationType is a required field
	AssociationType *string `locationName:"associationType" type:"string" required:"true" enum:"AssociationType"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssistantAssociationData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssistantAssociationData) GoString() string {
	return s.String()
}

// SetAssistantArn sets the AssistantArn field's value.
func (s *AssistantAssociationData) SetAssistantArn(v string) *AssistantAssociationData {
	s.AssistantArn = &v
	return s
}

// SetAssistantAssociationArn sets the AssistantAssociationArn field's value.
func (s *AssistantAssociationData) SetAssistantAssociationArn(v string) *AssistantAssociationData {
	s.AssistantAssociationArn = &v
	return s
}

// SetAssistantAssociationId sets the AssistantAssociationId field's value.
func (s *AssistantAssociationData) SetAssistantAssociationId(v string) *AssistantAssociationData {
	s.AssistantAssociationId = &v
	return s
}

// SetAssistantId sets the AssistantId field's value.
func (s *AssistantAssociationData) SetAssistantId(v string) *AssistantAssociationData {
	s.AssistantId = &v
	return s
}

// SetAssociationData sets the AssociationData field's value.
func (s *AssistantAssociationData) SetAssociationData(v *AssistantAssociationOutputData) *AssistantAssociationData {
	s.AssociationData = v
	return s
}

// SetAssociationType sets the AssociationType field's value.
func (s *AssistantAssociationData) SetAssociationType(v string) *AssistantAssociationData {
	s.AssociationType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AssistantAssociationData) SetTags(v map[string]*string) *AssistantAssociationData {
	s.Tags = v
	return s
}

// The data that is input into Wisdom as a result of the assistant association.
type AssistantAssociationInputData struct {
	_ struct{} `type:"structure"`

	// The the identifier of the knowledge base.
	KnowledgeBaseId *string `locationName:"knowledgeBaseId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssistantAssociationInputData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssistantAssociationInputData) GoString() string {
	return s.String()
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *AssistantAssociationInputData) SetKnowledgeBaseId(v string) *AssistantAssociationInputData {
	s.KnowledgeBaseId = &v
	return s
}

// The data that is output as a result of the assistant association.
type AssistantAssociationOutputData struct {
	_ struct{} `type:"structure"`

	// The knowledge base where output data is sent.
	KnowledgeBaseAssociation *KnowledgeBaseAssociationData `locationName:"knowledgeBaseAssociation" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssistantAssociationOutputData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssistantAssociationOutputData) GoString() string {
	return s.String()
}

// SetKnowledgeBaseAssociation sets the KnowledgeBaseAssociation field's value.
func (s *AssistantAssociationOutputData) SetKnowledgeBaseAssociation(v *KnowledgeBaseAssociationData) *AssistantAssociationOutputData {
	s.KnowledgeBaseAssociation = v
	return s
}

// Summary information about the assistant association.
type AssistantAssociationSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Wisdom assistant
	//
	// AssistantArn is a required field
	AssistantArn *string `locationName:"assistantArn" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the assistant association.
	//
	// AssistantAssociationArn is a required field
	AssistantAssociationArn *string `locationName:"assistantAssociationArn" type:"string" required:"true"`

	// The identifier of the assistant association.
	//
	// AssistantAssociationId is a required field
	AssistantAssociationId *string `locationName:"assistantAssociationId" type:"string" required:"true"`

	// The identifier of the Wisdom assistant.
	//
	// AssistantId is a required field
	AssistantId *string `locationName:"assistantId" type:"string" required:"true"`

	// The association data.
	//
	// AssociationData is a required field
	AssociationData *AssistantAssociationOutputData `locationName:"associationData" type:"structure" required:"true"`

	// The type of association.
	//
	// AssociationType is a required field
	AssociationType *string `locationName:"associationType" type:"string" required:"true" enum:"AssociationType"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssistantAssociationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssistantAssociationSummary) GoString() string {
	return s.String()
}

// SetAssistantArn sets the AssistantArn field's value.
func (s *AssistantAssociationSummary) SetAssistantArn(v string) *AssistantAssociationSummary {
	s.AssistantArn = &v
	return s
}

// SetAssistantAssociationArn sets the AssistantAssociationArn field's value.
func (s *AssistantAssociationSummary) SetAssistantAssociationArn(v string) *AssistantAssociationSummary {
	s.AssistantAssociationArn = &v
	return s
}

// SetAssistantAssociationId sets the AssistantAssociationId field's value.
func (s *AssistantAssociationSummary) SetAssistantAssociationId(v string) *AssistantAssociationSummary {
	s.AssistantAssociationId = &v
	return s
}

// SetAssistantId sets the AssistantId field's value.
func (s *AssistantAssociationSummary) SetAssistantId(v string) *AssistantAssociationSummary {
	s.AssistantId = &v
	return s
}

// SetAssociationData sets the AssociationData field's value.
func (s *AssistantAssociationSummary) SetAssociationData(v *AssistantAssociationOutputData) *AssistantAssociationSummary {
	s.AssociationData = v
	return s
}

// SetAssociationType sets the AssociationType field's value.
func (s *AssistantAssociationSummary) SetAssociationType(v string) *AssistantAssociationSummary {
	s.AssociationType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AssistantAssociationSummary) SetTags(v map[string]*string) *AssistantAssociationSummary {
	s.Tags = v
	return s
}

// The assistant data.
type AssistantData struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Wisdom assistant
	//
	// AssistantArn is a required field
	AssistantArn *string `locationName:"assistantArn" type:"string" required:"true"`

	// The identifier of the Wisdom assistant.
	//
	// AssistantId is a required field
	AssistantId *string `locationName:"assistantId" type:"string" required:"true"`

	// The description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The KMS key used for encryption.
	ServerSideEncryptionConfiguration *ServerSideEncryptionConfiguration `locationName:"serverSideEncryptionConfiguration" type:"structure"`

	// The status of the assistant.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"AssistantStatus"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The type of assistant.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"AssistantType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssistantData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssistantData) GoString() string {
	return s.String()
}

// SetAssistantArn sets the AssistantArn field's value.
func (s *AssistantData) SetAssistantArn(v string) *AssistantData {
	s.AssistantArn = &v
	return s
}

// SetAssistantId sets the AssistantId field's value.
func (s *AssistantData) SetAssistantId(v string) *AssistantData {
	s.AssistantId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AssistantData) SetDescription(v string) *AssistantData {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssistantData) SetName(v string) *AssistantData {
	s.Name = &v
	return s
}

// SetServerSideEncryptionConfiguration sets the ServerSideEncryptionConfiguration field's value.
func (s *AssistantData) SetServerSideEncryptionConfiguration(v *ServerSideEncryptionConfiguration) *AssistantData {
	s.ServerSideEncryptionConfiguration = v
	return s
}

// SetStatus sets the Status field's value.
func (s *AssistantData) SetStatus(v string) *AssistantData {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AssistantData) SetTags(v map[string]*string) *AssistantData {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *AssistantData) SetType(v string) *AssistantData {
	s.Type = &v
	return s
}

// Summary information about the assistant.
type AssistantSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Wisdom assistant
	//
	// AssistantArn is a required field
	AssistantArn *string `locationName:"assistantArn" type:"string" required:"true"`

	// The identifier of the Wisdom assistant.
	//
	// AssistantId is a required field
	AssistantId *string `locationName:"assistantId" type:"string" required:"true"`

	// The description of the assistant.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the assistant.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The KMS key used for encryption.
	ServerSideEncryptionConfiguration *ServerSideEncryptionConfiguration `locationName:"serverSideEncryptionConfiguration" type:"structure"`

	// The status of the assistant.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"AssistantStatus"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The type of the assistant.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"AssistantType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssistantSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssistantSummary) GoString() string {
	return s.String()
}

// SetAssistantArn sets the AssistantArn field's value.
func (s *AssistantSummary) SetAssistantArn(v string) *AssistantSummary {
	s.AssistantArn = &v
	return s
}

// SetAssistantId sets the AssistantId field's value.
func (s *AssistantSummary) SetAssistantId(v string) *AssistantSummary {
	s.AssistantId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AssistantSummary) SetDescription(v string) *AssistantSummary {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssistantSummary) SetName(v string) *AssistantSummary {
	s.Name = &v
	return s
}

// SetServerSideEncryptionConfiguration sets the ServerSideEncryptionConfiguration field's value.
func (s *AssistantSummary) SetServerSideEncryptionConfiguration(v *ServerSideEncryptionConfiguration) *AssistantSummary {
	s.ServerSideEncryptionConfiguration = v
	return s
}

// SetStatus sets the Status field's value.
func (s *AssistantSummary) SetStatus(v string) *AssistantSummary {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AssistantSummary) SetTags(v map[string]*string) *AssistantSummary {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *AssistantSummary) SetType(v string) *AssistantSummary {
	s.Type = &v
	return s
}

// The request could not be processed because of conflict in the current state
// of the resource. For example, if you're using a Create API (such as CreateAssistant)
// that accepts name, a conflicting resource (usually with the same name) is
// being created or mutated.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about the content.
type ContentData struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the content.
	//
	// ContentArn is a required field
	ContentArn *string `locationName:"contentArn" type:"string" required:"true"`

	// The identifier of the content.
	//
	// ContentId is a required field
	ContentId *string `locationName:"contentId" type:"string" required:"true"`

	// The media type of the content.
	//
	// ContentType is a required field
	ContentType *string `locationName:"contentType" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the knowledge base.
	//
	// KnowledgeBaseArn is a required field
	KnowledgeBaseArn *string `locationName:"knowledgeBaseArn" type:"string" required:"true"`

	// The the identifier of the knowledge base.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `locationName:"knowledgeBaseId" type:"string" required:"true"`

	// The URI of the content.
	LinkOutUri *string `locationName:"linkOutUri" min:"1" type:"string"`

	// A key/value map to store attributes without affecting tagging or recommendations.
	// For example, when synchronizing data between an external system and Wisdom,
	// you can store an external version identifier as metadata to utilize for determining
	// drift.
	//
	// Metadata is a required field
	Metadata map[string]*string `locationName:"metadata" type:"map" required:"true"`

	// The name of the content.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The identifier of the content revision.
	//
	// RevisionId is a required field
	RevisionId *string `locationName:"revisionId" min:"1" type:"string" required:"true"`

	// The status of the content.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ContentStatus"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The title of the content.
	//
	// Title is a required field
	Title *string `locationName:"title" min:"1" type:"string" required:"true"`

	// The URL of the content.
	//
	// Url is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ContentData's
	// String and GoString methods.
	//
	// Url is a required field
	Url *string `locationName:"url" min:"1" type:"string" required:"true" sensitive:"true"`

	// The expiration time of the URL as an epoch timestamp.
	//
	// UrlExpiry is a required field
	UrlExpiry *time.Time `locationName:"urlExpiry" type:"timestamp" timestampFormat:"unixTimestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContentData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContentData) GoString() string {
	return s.String()
}

// SetContentArn sets the ContentArn field's value.
func (s *ContentData) SetContentArn(v string) *ContentData {
	s.ContentArn = &v
	return s
}

// SetContentId sets the ContentId field's value.
func (s *ContentData) SetContentId(v string) *ContentData {
	s.ContentId = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *ContentData) SetContentType(v string) *ContentData {
	s.ContentType = &v
	return s
}

// SetKnowledgeBaseArn sets the KnowledgeBaseArn field's value.
func (s *ContentData) SetKnowledgeBaseArn(v string) *ContentData {
	s.KnowledgeBaseArn = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *ContentData) SetKnowledgeBaseId(v string) *ContentData {
	s.KnowledgeBaseId = &v
	return s
}

// SetLinkOutUri sets the LinkOutUri field's value.
func (s *ContentData) SetLinkOutUri(v string) *ContentData {
	s.LinkOutUri = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *ContentData) SetMetadata(v map[string]*string) *ContentData {
	s.Metadata = v
	return s
}

// SetName sets the Name field's value.
func (s *ContentData) SetName(v string) *ContentData {
	s.Name = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *ContentData) SetRevisionId(v string) *ContentData {
	s.RevisionId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ContentData) SetStatus(v string) *ContentData {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ContentData) SetTags(v map[string]*string) *ContentData {
	s.Tags = v
	return s
}

// SetTitle sets the Title field's value.
func (s *ContentData) SetTitle(v string) *ContentData {
	s.Title = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *ContentData) SetUrl(v string) *ContentData {
	s.Url = &v
	return s
}

// SetUrlExpiry sets the UrlExpiry field's value.
func (s *ContentData) SetUrlExpiry(v time.Time) *ContentData {
	s.UrlExpiry = &v
	return s
}

// Reference information about the content.
type ContentReference struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the content.
	ContentArn *string `locationName:"contentArn" type:"string"`

	// The identifier of the content.
	ContentId *string `locationName:"contentId" type:"string"`

	// The Amazon Resource Name (ARN) of the knowledge base.
	KnowledgeBaseArn *string `locationName:"knowledgeBaseArn" type:"string"`

	// The the identifier of the knowledge base.
	KnowledgeBaseId *string `locationName:"knowledgeBaseId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContentReference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContentReference) GoString() string {
	return s.String()
}

// SetContentArn sets the ContentArn field's value.
func (s *ContentReference) SetContentArn(v string) *ContentReference {
	s.ContentArn = &v
	return s
}

// SetContentId sets the ContentId field's value.
func (s *ContentReference) SetContentId(v string) *ContentReference {
	s.ContentId = &v
	return s
}

// SetKnowledgeBaseArn sets the KnowledgeBaseArn field's value.
func (s *ContentReference) SetKnowledgeBaseArn(v string) *ContentReference {
	s.KnowledgeBaseArn = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *ContentReference) SetKnowledgeBaseId(v string) *ContentReference {
	s.KnowledgeBaseId = &v
	return s
}

// Summary information about the content.
type ContentSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the content.
	//
	// ContentArn is a required field
	ContentArn *string `locationName:"contentArn" type:"string" required:"true"`

	// The identifier of the content.
	//
	// ContentId is a required field
	ContentId *string `locationName:"contentId" type:"string" required:"true"`

	// The media type of the content.
	//
	// ContentType is a required field
	ContentType *string `locationName:"contentType" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the knowledge base.
	//
	// KnowledgeBaseArn is a required field
	KnowledgeBaseArn *string `locationName:"knowledgeBaseArn" type:"string" required:"true"`

	// The the identifier of the knowledge base.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `locationName:"knowledgeBaseId" type:"string" required:"true"`

	// A key/value map to store attributes without affecting tagging or recommendations.
	// For example, when synchronizing data between an external system and Wisdom,
	// you can store an external version identifier as metadata to utilize for determining
	// drift.
	//
	// Metadata is a required field
	Metadata map[string]*string `locationName:"metadata" type:"map" required:"true"`

	// The name of the content.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The identifier of the revision of the content.
	//
	// RevisionId is a required field
	RevisionId *string `locationName:"revisionId" min:"1" type:"string" required:"true"`

	// The status of the content.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ContentStatus"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The title of the content.
	//
	// Title is a required field
	Title *string `locationName:"title" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContentSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContentSummary) GoString() string {
	return s.String()
}

// SetContentArn sets the ContentArn field's value.
func (s *ContentSummary) SetContentArn(v string) *ContentSummary {
	s.ContentArn = &v
	return s
}

// SetContentId sets the ContentId field's value.
func (s *ContentSummary) SetContentId(v string) *ContentSummary {
	s.ContentId = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *ContentSummary) SetContentType(v string) *ContentSummary {
	s.ContentType = &v
	return s
}

// SetKnowledgeBaseArn sets the KnowledgeBaseArn field's value.
func (s *ContentSummary) SetKnowledgeBaseArn(v string) *ContentSummary {
	s.KnowledgeBaseArn = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *ContentSummary) SetKnowledgeBaseId(v string) *ContentSummary {
	s.KnowledgeBaseId = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *ContentSummary) SetMetadata(v map[string]*string) *ContentSummary {
	s.Metadata = v
	return s
}

// SetName sets the Name field's value.
func (s *ContentSummary) SetName(v string) *ContentSummary {
	s.Name = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *ContentSummary) SetRevisionId(v string) *ContentSummary {
	s.RevisionId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ContentSummary) SetStatus(v string) *ContentSummary {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ContentSummary) SetTags(v map[string]*string) *ContentSummary {
	s.Tags = v
	return s
}

// SetTitle sets the Title field's value.
func (s *ContentSummary) SetTitle(v string) *ContentSummary {
	s.Title = &v
	return s
}

type CreateAssistantAssociationInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Wisdom assistant. Can be either the ID or the ARN.
	// URLs cannot contain the ARN.
	//
	// AssistantId is a required field
	AssistantId *string `location:"uri" locationName:"assistantId" type:"string" required:"true"`

	// The identifier of the associated resource.
	//
	// Association is a required field
	Association *AssistantAssociationInputData `locationName:"association" type:"structure" required:"true"`

	// The type of association.
	//
	// AssociationType is a required field
	AssociationType *string `locationName:"associationType" type:"string" required:"true" enum:"AssociationType"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssistantAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssistantAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAssistantAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAssistantAssociationInput"}
	if s.AssistantId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssistantId"))
	}
	if s.AssistantId != nil && len(*s.AssistantId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssistantId", 1))
	}
	if s.Association == nil {
		invalidParams.Add(request.NewErrParamRequired("Association"))
	}
	if s.AssociationType == nil {
		invalidParams.Add(request.NewErrParamRequired("AssociationType"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssistantId sets the AssistantId field's value.
func (s *CreateAssistantAssociationInput) SetAssistantId(v string) *CreateAssistantAssociationInput {
	s.AssistantId = &v
	return s
}

// SetAssociation sets the Association field's value.
func (s *CreateAssistantAssociationInput) SetAssociation(v *AssistantAssociationInputData) *CreateAssistantAssociationInput {
	s.Association = v
	return s
}

// SetAssociationType sets the AssociationType field's value.
func (s *CreateAssistantAssociationInput) SetAssociationType(v string) *CreateAssistantAssociationInput {
	s.AssociationType = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAssistantAssociationInput) SetClientToken(v string) *CreateAssistantAssociationInput {
	s.ClientToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAssistantAssociationInput) SetTags(v map[string]*string) *CreateAssistantAssociationInput {
	s.Tags = v
	return s
}

type CreateAssistantAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The assistant association.
	AssistantAssociation *AssistantAssociationData `locationName:"assistantAssociation" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssistantAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssistantAssociationOutput) GoString() string {
	return s.String()
}

// SetAssistantAssociation sets the AssistantAssociation field's value.
func (s *CreateAssistantAssociationOutput) SetAssistantAssociation(v *AssistantAssociationData) *CreateAssistantAssociationOutput {
	s.AssistantAssociation = v
	return s
}

type CreateAssistantInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The description of the assistant.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the assistant.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The KMS key used for encryption.
	ServerSideEncryptionConfiguration *ServerSideEncryptionConfiguration `locationName:"serverSideEncryptionConfiguration" type:"structure"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The type of assistant.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"AssistantType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssistantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssistantInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAssistantInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAssistantInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.ServerSideEncryptionConfiguration != nil {
		if err := s.ServerSideEncryptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ServerSideEncryptionConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAssistantInput) SetClientToken(v string) *CreateAssistantInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateAssistantInput) SetDescription(v string) *CreateAssistantInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAssistantInput) SetName(v string) *CreateAssistantInput {
	s.Name = &v
	return s
}

// SetServerSideEncryptionConfiguration sets the ServerSideEncryptionConfiguration field's value.
func (s *CreateAssistantInput) SetServerSideEncryptionConfiguration(v *ServerSideEncryptionConfiguration) *CreateAssistantInput {
	s.ServerSideEncryptionConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAssistantInput) SetTags(v map[string]*string) *CreateAssistantInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateAssistantInput) SetType(v string) *CreateAssistantInput {
	s.Type = &v
	return s
}

type CreateAssistantOutput struct {
	_ struct{} `type:"structure"`

	// Information about the assistant.
	Assistant *AssistantData `locationName:"assistant" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssistantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAssistantOutput) GoString() string {
	return s.String()
}

// SetAssistant sets the Assistant field's value.
func (s *CreateAssistantOutput) SetAssistant(v *AssistantData) *CreateAssistantOutput {
	s.Assistant = v
	return s
}

type CreateContentInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The the identifier of the knowledge base. Can be either the ID or the ARN.
	// URLs cannot contain the ARN.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`

	// A key/value map to store attributes without affecting tagging or recommendations.
	// For example, when synchronizing data between an external system and Wisdom,
	// you can store an external version identifier as metadata to utilize for determining
	// drift.
	Metadata map[string]*string `locationName:"metadata" type:"map"`

	// The name of the content. Each piece of content in a knowledge base must have
	// a unique name. You can retrieve a piece of content using only its knowledge
	// base and its name with the SearchContent (https://docs.aws.amazon.com/wisdom/latest/APIReference/API_SearchContent.html)
	// API.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The URI you want to use for the article. If the knowledge base has a templateUri,
	// setting this argument overrides it for this piece of content.
	OverrideLinkOutUri *string `locationName:"overrideLinkOutUri" min:"1" type:"string"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The title of the content. If not set, the title is equal to the name.
	Title *string `locationName:"title" min:"1" type:"string"`

	// A pointer to the uploaded asset. This value is returned by StartContentUpload
	// (https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html).
	//
	// UploadId is a required field
	UploadId *string `locationName:"uploadId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateContentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateContentInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.OverrideLinkOutUri != nil && len(*s.OverrideLinkOutUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OverrideLinkOutUri", 1))
	}
	if s.Title != nil && len(*s.Title) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Title", 1))
	}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}
	if s.UploadId != nil && len(*s.UploadId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UploadId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateContentInput) SetClientToken(v string) *CreateContentInput {
	s.ClientToken = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *CreateContentInput) SetKnowledgeBaseId(v string) *CreateContentInput {
	s.KnowledgeBaseId = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *CreateContentInput) SetMetadata(v map[string]*string) *CreateContentInput {
	s.Metadata = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateContentInput) SetName(v string) *CreateContentInput {
	s.Name = &v
	return s
}

// SetOverrideLinkOutUri sets the OverrideLinkOutUri field's value.
func (s *CreateContentInput) SetOverrideLinkOutUri(v string) *CreateContentInput {
	s.OverrideLinkOutUri = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateContentInput) SetTags(v map[string]*string) *CreateContentInput {
	s.Tags = v
	return s
}

// SetTitle sets the Title field's value.
func (s *CreateContentInput) SetTitle(v string) *CreateContentInput {
	s.Title = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *CreateContentInput) SetUploadId(v string) *CreateContentInput {
	s.UploadId = &v
	return s
}

type CreateContentOutput struct {
	_ struct{} `type:"structure"`

	// The content.
	Content *ContentData `locationName:"content" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContentOutput) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *CreateContentOutput) SetContent(v *ContentData) *CreateContentOutput {
	s.Content = v
	return s
}

type CreateKnowledgeBaseInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The type of knowledge base. Only CUSTOM knowledge bases allow you to upload
	// your own content. EXTERNAL knowledge bases support integrations with third-party
	// systems whose content is synchronized automatically.
	//
	// KnowledgeBaseType is a required field
	KnowledgeBaseType *string `locationName:"knowledgeBaseType" type:"string" required:"true" enum:"KnowledgeBaseType"`

	// The name of the knowledge base.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Information about how to render the content.
	RenderingConfiguration *RenderingConfiguration `locationName:"renderingConfiguration" type:"structure"`

	// The KMS key used for encryption.
	ServerSideEncryptionConfiguration *ServerSideEncryptionConfiguration `locationName:"serverSideEncryptionConfiguration" type:"structure"`

	// The source of the knowledge base content. Only set this argument for EXTERNAL
	// knowledge bases.
	SourceConfiguration *SourceConfiguration `locationName:"sourceConfiguration" type:"structure"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKnowledgeBaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKnowledgeBaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateKnowledgeBaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateKnowledgeBaseInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.KnowledgeBaseType == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseType"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RenderingConfiguration != nil {
		if err := s.RenderingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RenderingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ServerSideEncryptionConfiguration != nil {
		if err := s.ServerSideEncryptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ServerSideEncryptionConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.SourceConfiguration != nil {
		if err := s.SourceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SourceConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateKnowledgeBaseInput) SetClientToken(v string) *CreateKnowledgeBaseInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateKnowledgeBaseInput) SetDescription(v string) *CreateKnowledgeBaseInput {
	s.Description = &v
	return s
}

// SetKnowledgeBaseType sets the KnowledgeBaseType field's value.
func (s *CreateKnowledgeBaseInput) SetKnowledgeBaseType(v string) *CreateKnowledgeBaseInput {
	s.KnowledgeBaseType = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateKnowledgeBaseInput) SetName(v string) *CreateKnowledgeBaseInput {
	s.Name = &v
	return s
}

// SetRenderingConfiguration sets the RenderingConfiguration field's value.
func (s *CreateKnowledgeBaseInput) SetRenderingConfiguration(v *RenderingConfiguration) *CreateKnowledgeBaseInput {
	s.RenderingConfiguration = v
	return s
}

// SetServerSideEncryptionConfiguration sets the ServerSideEncryptionConfiguration field's value.
func (s *CreateKnowledgeBaseInput) SetServerSideEncryptionConfiguration(v *ServerSideEncryptionConfiguration) *CreateKnowledgeBaseInput {
	s.ServerSideEncryptionConfiguration = v
	return s
}

// SetSourceConfiguration sets the SourceConfiguration field's value.
func (s *CreateKnowledgeBaseInput) SetSourceConfiguration(v *SourceConfiguration) *CreateKnowledgeBaseInput {
	s.SourceConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateKnowledgeBaseInput) SetTags(v map[string]*string) *CreateKnowledgeBaseInput {
	s.Tags = v
	return s
}

type CreateKnowledgeBaseOutput struct {
	_ struct{} `type:"structure"`

	// The knowledge base.
	KnowledgeBase *KnowledgeBaseData `locationName:"knowledgeBase" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKnowledgeBaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKnowledgeBaseOutput) GoString() string {
	return s.String()
}

// SetKnowledgeBase sets the KnowledgeBase field's value.
func (s *CreateKnowledgeBaseOutput) SetKnowledgeBase(v *KnowledgeBaseData) *CreateKnowledgeBaseOutput {
	s.KnowledgeBase = v
	return s
}

type CreateSessionInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Wisdom assistant. Can be either the ID or the ARN.
	// URLs cannot contain the ARN.
	//
	// AssistantId is a required field
	AssistantId *string `location:"uri" locationName:"assistantId" type:"string" required:"true"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the session.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSessionInput"}
	if s.AssistantId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssistantId"))
	}
	if s.AssistantId != nil && len(*s.AssistantId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssistantId", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssistantId sets the AssistantId field's value.
func (s *CreateSessionInput) SetAssistantId(v string) *CreateSessionInput {
	s.AssistantId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateSessionInput) SetClientToken(v string) *CreateSessionInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateSessionInput) SetDescription(v string) *CreateSessionInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSessionInput) SetName(v string) *CreateSessionInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSessionInput) SetTags(v map[string]*string) *CreateSessionInput {
	s.Tags = v
	return s
}

type CreateSessionOutput struct {
	_ struct{} `type:"structure"`

	// The session.
	Session *SessionData `locationName:"session" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSessionOutput) GoString() string {
	return s.String()
}

// SetSession sets the Session field's value.
func (s *CreateSessionOutput) SetSession(v *SessionData) *CreateSessionOutput {
	s.Session = v
	return s
}

type DeleteAssistantAssociationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the assistant association. Can be either the ID or the
	// ARN. URLs cannot contain the ARN.
	//
	// AssistantAssociationId is a required field
	AssistantAssociationId *string `location:"uri" locationName:"assistantAssociationId" type:"string" required:"true"`

	// The identifier of the Wisdom assistant. Can be either the ID or the ARN.
	// URLs cannot contain the ARN.
	//
	// AssistantId is a required field
	AssistantId *string `location:"uri" locationName:"assistantId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssistantAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssistantAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAssistantAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAssistantAssociationInput"}
	if s.AssistantAssociationId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssistantAssociationId"))
	}
	if s.AssistantAssociationId != nil && len(*s.AssistantAssociationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssistantAssociationId", 1))
	}
	if s.AssistantId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssistantId"))
	}
	if s.AssistantId != nil && len(*s.AssistantId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssistantId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssistantAssociationId sets the AssistantAssociationId field's value.
func (s *DeleteAssistantAssociationInput) SetAssistantAssociationId(v string) *DeleteAssistantAssociationInput {
	s.AssistantAssociationId = &v
	return s
}

// SetAssistantId sets the AssistantId field's value.
func (s *DeleteAssistantAssociationInput) SetAssistantId(v string) *DeleteAssistantAssociationInput {
	s.AssistantId = &v
	return s
}

type DeleteAssistantAssociationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssistantAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssistantAssociationOutput) GoString() string {
	return s.String()
}

type DeleteAssistantInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the Wisdom assistant. Can be either the ID or the ARN.
	// URLs cannot contain the ARN.
	//
	// AssistantId is a required field
	AssistantId *string `location:"uri" locationName:"assistantId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssistantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssistantInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAssistantInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAssistantInput"}
	if s.AssistantId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssistantId"))
	}
	if s.AssistantId != nil && len(*s.AssistantId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssistantId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssistantId sets the AssistantId field's value.
func (s *DeleteAssistantInput) SetAssistantId(v string) *DeleteAssistantInput {
	s.AssistantId = &v
	return s
}

type DeleteAssistantOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssistantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAssistantOutput) GoString() string {
	return s.String()
}

type DeleteContentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the content. Can be either the ID or the ARN. URLs cannot
	// contain the ARN.
	//
	// ContentId is a required field
	ContentId *string `location:"uri" locationName:"contentId" type:"string" required:"true"`

	// The the identifier of the knowledge base. Can be either the ID or the ARN.
	// URLs cannot contain the ARN.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteContentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteContentInput"}
	if s.ContentId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContentId"))
	}
	if s.ContentId != nil && len(*s.ContentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContentId", 1))
	}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentId sets the ContentId field's value.
func (s *DeleteContentInput) SetContentId(v string) *DeleteContentInput {
	s.ContentId = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *DeleteContentInput) SetKnowledgeBaseId(v string) *DeleteContentInput {
	s.KnowledgeBaseId = &v
	return s
}

type DeleteContentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteContentOutput) GoString() string {
	return s.String()
}

type DeleteKnowledgeBaseInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The knowledge base to delete content from. Can be either the ID or the ARN.
	// URLs cannot contain the ARN.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKnowledgeBaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKnowledgeBaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteKnowledgeBaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteKnowledgeBaseInput"}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *DeleteKnowledgeBaseInput) SetKnowledgeBaseId(v string) *DeleteKnowledgeBaseInput {
	s.KnowledgeBaseId = &v
	return s
}

type DeleteKnowledgeBaseOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKnowledgeBaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKnowledgeBaseOutput) GoString() string {
	return s.String()
}

// The document.
type Document struct {
	_ struct{} `type:"structure"`

	// A reference to the content resource.
	//
	// ContentReference is a required field
	ContentReference *ContentReference `locationName:"contentReference" type:"structure" required:"true"`

	// The excerpt from the document.
	Excerpt *DocumentText `locationName:"excerpt" type:"structure"`

	// The title of the document.
	Title *DocumentText `locationName:"title" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Document) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Document) GoString() string {
	return s.String()
}

// SetContentReference sets the ContentReference field's value.
func (s *Document) SetContentReference(v *ContentReference) *Document {
	s.ContentReference = v
	return s
}

// SetExcerpt sets the Excerpt field's value.
func (s *Document) SetExcerpt(v *DocumentText) *Document {
	s.Excerpt = v
	return s
}

// SetTitle sets the Title field's value.
func (s *Document) SetTitle(v *DocumentText) *Document {
	s.Title = v
	return s
}

// The text of the document.
type DocumentText struct {
	_ struct{} `type:"structure"`

	// Highlights in the document text.
	Highlights []*Highlight `locationName:"highlights" type:"list"`

	// Text in the document.
	//
	// Text is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DocumentText's
	// String and GoString methods.
	Text *string `locationName:"text" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentText) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentText) GoString() string {
	return s.String()
}

// SetHighlights sets the Highlights field's value.
func (s *DocumentText) SetHighlights(v []*Highlight) *DocumentText {
	s.Highlights = v
	return s
}

// SetText sets the Text field's value.
func (s *DocumentText) SetText(v string) *DocumentText {
	s.Text = &v
	return s
}

// A search filter.
type Filter struct {
	_ struct{} `type:"structure"`

	// The field on which to filter.
	//
	// Field is a required field
	Field *string `locationName:"field" type:"string" required:"true" enum:"FilterField"`

	// The operator to use for comparing the field’s value with the provided value.
	//
	// Operator is a required field
	Operator *string `locationName:"operator" type:"string" required:"true" enum:"FilterOperator"`

	// The desired field value on which to filter.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.Field == nil {
		invalidParams.Add(request.NewErrParamRequired("Field"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetField sets the Field field's value.
func (s *Filter) SetField(v string) *Filter {
	s.Field = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *Filter) SetOperator(v string) *Filter {
	s.Operator = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Filter) SetValue(v string) *Filter {
	s.Value = &v
	return s
}

type GetAssistantAssociationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the assistant association. Can be either the ID or the
	// ARN. URLs cannot contain the ARN.
	//
	// AssistantAssociationId is a required field
	AssistantAssociationId *string `location:"uri" locationName:"assistantAssociationId" type:"string" required:"true"`

	// The identifier of the Wisdom assistant. Can be either the ID or the ARN.
	// URLs cannot contain the ARN.
	//
	// AssistantId is a required field
	AssistantId *string `location:"uri" locationName:"assistantId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssistantAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssistantAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAssistantAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAssistantAssociationInput"}
	if s.AssistantAssociationId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssistantAssociationId"))
	}
	if s.AssistantAssociationId != nil && len(*s.AssistantAssociationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssistantAssociationId", 1))
	}
	if s.AssistantId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssistantId"))
	}
	if s.AssistantId != nil && len(*s.AssistantId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssistantId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssistantAssociationId sets the AssistantAssociationId field's value.
func (s *GetAssistantAssociationInput) SetAssistantAssociationId(v string) *GetAssistantAssociationInput {
	s.AssistantAssociationId = &v
	return s
}

// SetAssistantId sets the AssistantId field's value.
func (s *GetAssistantAssociationInput) SetAssistantId(v string) *GetAssistantAssociationInput {
	s.AssistantId = &v
	return s
}

type GetAssistantAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The assistant association.
	AssistantAssociation *AssistantAssociationData `locationName:"assistantAssociation" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssistantAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssistantAssociationOutput) GoString() string {
	return s.String()
}

// SetAssistantAssociation sets the AssistantAssociation field's value.
func (s *GetAssistantAssociationOutput) SetAssistantAssociation(v *AssistantAssociationData) *GetAssistantAssociationOutput {
	s.AssistantAssociation = v
	return s
}

type GetAssistantInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the Wisdom assistant. Can be either the ID or the ARN.
	// URLs cannot contain the ARN.
	//
	// AssistantId is a required field
	AssistantId *string `location:"uri" locationName:"assistantId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssistantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssistantInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAssistantInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAssistantInput"}
	if s.AssistantId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssistantId"))
	}
	if s.AssistantId != nil && len(*s.AssistantId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssistantId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssistantId sets the AssistantId field's value.
func (s *GetAssistantInput) SetAssistantId(v string) *GetAssistantInput {
	s.AssistantId = &v
	return s
}

type GetAssistantOutput struct {
	_ struct{} `type:"structure"`

	// Information about the assistant.
	Assistant *AssistantData `locationName:"assistant" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssistantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssistantOutput) GoString() string {
	return s.String()
}

// SetAssistant sets the Assistant field's value.
func (s *GetAssistantOutput) SetAssistant(v *AssistantData) *GetAssistantOutput {
	s.Assistant = v
	return s
}

type GetContentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the content. Can be either the ID or the ARN. URLs cannot
	// contain the ARN.
	//
	// ContentId is a required field
	ContentId *string `location:"uri" locationName:"contentId" type:"string" required:"true"`

	// The the identifier of the knowledge base. Can be either the ID or the ARN.
	// URLs cannot contain the ARN.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetContentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetContentInput"}
	if s.ContentId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContentId"))
	}
	if s.ContentId != nil && len(*s.ContentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContentId", 1))
	}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentId sets the ContentId field's value.
func (s *GetContentInput) SetContentId(v string) *GetContentInput {
	s.ContentId = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *GetContentInput) SetKnowledgeBaseId(v string) *GetContentInput {
	s.KnowledgeBaseId = &v
	return s
}

type GetContentOutput struct {
	_ struct{} `type:"structure"`

	// The content.
	Content *ContentData `locationName:"content" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContentOutput) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *GetContentOutput) SetContent(v *ContentData) *GetContentOutput {
	s.Content = v
	return s
}

type GetContentSummaryInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the content. Can be either the ID or the ARN. URLs cannot
	// contain the ARN.
	//
	// ContentId is a required field
	ContentId *string `location:"uri" locationName:"contentId" type:"string" required:"true"`

	// The the identifier of the knowledge base. Can be either the ID or the ARN.
	// URLs cannot contain the ARN.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContentSummaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContentSummaryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetContentSummaryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetContentSummaryInput"}
	if s.ContentId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContentId"))
	}
	if s.ContentId != nil && len(*s.ContentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContentId", 1))
	}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentId sets the ContentId field's value.
func (s *GetContentSummaryInput) SetContentId(v string) *GetContentSummaryInput {
	s.ContentId = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *GetContentSummaryInput) SetKnowledgeBaseId(v string) *GetContentSummaryInput {
	s.KnowledgeBaseId = &v
	return s
}

type GetContentSummaryOutput struct {
	_ struct{} `type:"structure"`

	// The content summary.
	ContentSummary *ContentSummary `locationName:"contentSummary" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContentSummaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContentSummaryOutput) GoString() string {
	return s.String()
}

// SetContentSummary sets the ContentSummary field's value.
func (s *GetContentSummaryOutput) SetContentSummary(v *ContentSummary) *GetContentSummaryOutput {
	s.ContentSummary = v
	return s
}

type GetKnowledgeBaseInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The the identifier of the knowledge base. Can be either the ID or the ARN.
	// URLs cannot contain the ARN.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKnowledgeBaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKnowledgeBaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetKnowledgeBaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetKnowledgeBaseInput"}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *GetKnowledgeBaseInput) SetKnowledgeBaseId(v string) *GetKnowledgeBaseInput {
	s.KnowledgeBaseId = &v
	return s
}

type GetKnowledgeBaseOutput struct {
	_ struct{} `type:"structure"`

	// The knowledge base.
	KnowledgeBase *KnowledgeBaseData `locationName:"knowledgeBase" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKnowledgeBaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKnowledgeBaseOutput) GoString() string {
	return s.String()
}

// SetKnowledgeBase sets the KnowledgeBase field's value.
func (s *GetKnowledgeBaseOutput) SetKnowledgeBase(v *KnowledgeBaseData) *GetKnowledgeBaseOutput {
	s.KnowledgeBase = v
	return s
}

type GetRecommendationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the Wisdom assistant. Can be either the ID or the ARN.
	// URLs cannot contain the ARN.
	//
	// AssistantId is a required field
	AssistantId *string `location:"uri" locationName:"assistantId" type:"string" required:"true"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The identifier of the session. Can be either the ID or the ARN. URLs cannot
	// contain the ARN.
	//
	// SessionId is a required field
	SessionId *string `location:"uri" locationName:"sessionId" type:"string" required:"true"`

	// The duration (in seconds) for which the call waits for a recommendation to
	// be made available before returning. If a recommendation is available, the
	// call returns sooner than WaitTimeSeconds. If no messages are available and
	// the wait time expires, the call returns successfully with an empty list.
	WaitTimeSeconds *int64 `location:"querystring" locationName:"waitTimeSeconds" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecommendationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecommendationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRecommendationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRecommendationsInput"}
	if s.AssistantId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssistantId"))
	}
	if s.AssistantId != nil && len(*s.AssistantId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssistantId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssistantId sets the AssistantId field's value.
func (s *GetRecommendationsInput) SetAssistantId(v string) *GetRecommendationsInput {
	s.AssistantId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetRecommendationsInput) SetMaxResults(v int64) *GetRecommendationsInput {
	s.MaxResults = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *GetRecommendationsInput) SetSessionId(v string) *GetRecommendationsInput {
	s.SessionId = &v
	return s
}

// SetWaitTimeSeconds sets the WaitTimeSeconds field's value.
func (s *GetRecommendationsInput) SetWaitTimeSeconds(v int64) *GetRecommendationsInput {
	s.WaitTimeSeconds = &v
	return s
}

type GetRecommendationsOutput struct {
	_ struct{} `type:"structure"`

	// The recommendations.
	//
	// Recommendations is a required field
	Recommendations []*RecommendationData `locationName:"recommendations" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecommendationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecommendationsOutput) GoString() string {
	return s.String()
}

// SetRecommendations sets the Recommendations field's value.
func (s *GetRecommendationsOutput) SetRecommendations(v []*RecommendationData) *GetRecommendationsOutput {
	s.Recommendations = v
	return s
}

type GetSessionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the Wisdom assistant. Can be either the ID or the ARN.
	// URLs cannot contain the ARN.
	//
	// AssistantId is a required field
	AssistantId *string `location:"uri" locationName:"assistantId" type:"string" required:"true"`

	// The identifier of the session. Can be either the ID or the ARN. URLs cannot
	// contain the ARN.
	//
	// SessionId is a required field
	SessionId *string `location:"uri" locationName:"sessionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSessionInput"}
	if s.AssistantId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssistantId"))
	}
	if s.AssistantId != nil && len(*s.AssistantId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssistantId", 1))
	}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssistantId sets the AssistantId field's value.
func (s *GetSessionInput) SetAssistantId(v string) *GetSessionInput {
	s.AssistantId = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *GetSessionInput) SetSessionId(v string) *GetSessionInput {
	s.SessionId = &v
	return s
}

type GetSessionOutput struct {
	_ struct{} `type:"structure"`

	// The session.
	Session *SessionData `locationName:"session" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSessionOutput) GoString() string {
	return s.String()
}

// SetSession sets the Session field's value.
func (s *GetSessionOutput) SetSession(v *SessionData) *GetSessionOutput {
	s.Session = v
	return s
}

// Offset specification to describe highlighting of document excerpts for rendering
// search results and recommendations.
type Highlight struct {
	_ struct{} `type:"structure"`

	// The offset for the start of the highlight.
	BeginOffsetInclusive *int64 `locationName:"beginOffsetInclusive" type:"integer"`

	// The offset for the end of the highlight.
	EndOffsetExclusive *int64 `locationName:"endOffsetExclusive" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Highlight) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Highlight) GoString() string {
	return s.String()
}

// SetBeginOffsetInclusive sets the BeginOffsetInclusive field's value.
func (s *Highlight) SetBeginOffsetInclusive(v int64) *Highlight {
	s.BeginOffsetInclusive = &v
	return s
}

// SetEndOffsetExclusive sets the EndOffsetExclusive field's value.
func (s *Highlight) SetEndOffsetExclusive(v int64) *Highlight {
	s.EndOffsetExclusive = &v
	return s
}

// Association information about the knowledge base.
type KnowledgeBaseAssociationData struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the knowledge base.
	KnowledgeBaseArn *string `locationName:"knowledgeBaseArn" type:"string"`

	// The the identifier of the knowledge base.
	KnowledgeBaseId *string `locationName:"knowledgeBaseId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseAssociationData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseAssociationData) GoString() string {
	return s.String()
}

// SetKnowledgeBaseArn sets the KnowledgeBaseArn field's value.
func (s *KnowledgeBaseAssociationData) SetKnowledgeBaseArn(v string) *KnowledgeBaseAssociationData {
	s.KnowledgeBaseArn = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *KnowledgeBaseAssociationData) SetKnowledgeBaseId(v string) *KnowledgeBaseAssociationData {
	s.KnowledgeBaseId = &v
	return s
}

// Information about the knowledge base.
type KnowledgeBaseData struct {
	_ struct{} `type:"structure"`

	// The description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the knowledge base.
	//
	// KnowledgeBaseArn is a required field
	KnowledgeBaseArn *string `locationName:"knowledgeBaseArn" type:"string" required:"true"`

	// The the identifier of the knowledge base.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `locationName:"knowledgeBaseId" type:"string" required:"true"`

	// The type of knowledge base.
	//
	// KnowledgeBaseType is a required field
	KnowledgeBaseType *string `locationName:"knowledgeBaseType" type:"string" required:"true" enum:"KnowledgeBaseType"`

	// An epoch timestamp indicating the most recent content modification inside
	// the knowledge base. If no content exists in a knowledge base, this value
	// is unset.
	LastContentModificationTime *time.Time `locationName:"lastContentModificationTime" type:"timestamp" timestampFormat:"unixTimestamp"`

	// The name of the knowledge base.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Information about how to render the content.
	RenderingConfiguration *RenderingConfiguration `locationName:"renderingConfiguration" type:"structure"`

	// The KMS key used for encryption.
	ServerSideEncryptionConfiguration *ServerSideEncryptionConfiguration `locationName:"serverSideEncryptionConfiguration" type:"structure"`

	// Source configuration information about the knowledge base.
	SourceConfiguration *SourceConfiguration `locationName:"sourceConfiguration" type:"structure"`

	// The status of the knowledge base.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"KnowledgeBaseStatus"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseData) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *KnowledgeBaseData) SetDescription(v string) *KnowledgeBaseData {
	s.Description = &v
	return s
}

// SetKnowledgeBaseArn sets the KnowledgeBaseArn field's value.
func (s *KnowledgeBaseData) SetKnowledgeBaseArn(v string) *KnowledgeBaseData {
	s.KnowledgeBaseArn = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *KnowledgeBaseData) SetKnowledgeBaseId(v string) *KnowledgeBaseData {
	s.KnowledgeBaseId = &v
	return s
}

// SetKnowledgeBaseType sets the KnowledgeBaseType field's value.
func (s *KnowledgeBaseData) SetKnowledgeBaseType(v string) *KnowledgeBaseData {
	s.KnowledgeBaseType = &v
	return s
}

// SetLastContentModificationTime sets the LastContentModificationTime field's value.
func (s *KnowledgeBaseData) SetLastContentModificationTime(v time.Time) *KnowledgeBaseData {
	s.LastContentModificationTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *KnowledgeBaseData) SetName(v string) *KnowledgeBaseData {
	s.Name = &v
	return s
}

// SetRenderingConfiguration sets the RenderingConfiguration field's value.
func (s *KnowledgeBaseData) SetRenderingConfiguration(v *RenderingConfiguration) *KnowledgeBaseData {
	s.RenderingConfiguration = v
	return s
}

// SetServerSideEncryptionConfiguration sets the ServerSideEncryptionConfiguration field's value.
func (s *KnowledgeBaseData) SetServerSideEncryptionConfiguration(v *ServerSideEncryptionConfiguration) *KnowledgeBaseData {
	s.ServerSideEncryptionConfiguration = v
	return s
}

// SetSourceConfiguration sets the SourceConfiguration field's value.
func (s *KnowledgeBaseData) SetSourceConfiguration(v *SourceConfiguration) *KnowledgeBaseData {
	s.SourceConfiguration = v
	return s
}

// SetStatus sets the Status field's value.
func (s *KnowledgeBaseData) SetStatus(v string) *KnowledgeBaseData {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *KnowledgeBaseData) SetTags(v map[string]*string) *KnowledgeBaseData {
	s.Tags = v
	return s
}

// Summary information about the knowledge base.
type KnowledgeBaseSummary struct {
	_ struct{} `type:"structure"`

	// The description of the knowledge base.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the knowledge base.
	//
	// KnowledgeBaseArn is a required field
	KnowledgeBaseArn *string `locationName:"knowledgeBaseArn" type:"string" required:"true"`

	// The the identifier of the knowledge base.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `locationName:"knowledgeBaseId" type:"string" required:"true"`

	// The type of knowledge base.
	//
	// KnowledgeBaseType is a required field
	KnowledgeBaseType *string `locationName:"knowledgeBaseType" type:"string" required:"true" enum:"KnowledgeBaseType"`

	// The name of the knowledge base.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Information about how to render the content.
	RenderingConfiguration *RenderingConfiguration `locationName:"renderingConfiguration" type:"structure"`

	// The KMS key used for encryption.
	ServerSideEncryptionConfiguration *ServerSideEncryptionConfiguration `locationName:"serverSideEncryptionConfiguration" type:"structure"`

	// [KEVIN]
	SourceConfiguration *SourceConfiguration `locationName:"sourceConfiguration" type:"structure"`

	// The status of the knowledge base summary.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"KnowledgeBaseStatus"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseSummary) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *KnowledgeBaseSummary) SetDescription(v string) *KnowledgeBaseSummary {
	s.Description = &v
	return s
}

// SetKnowledgeBaseArn sets the KnowledgeBaseArn field's value.
func (s *KnowledgeBaseSummary) SetKnowledgeBaseArn(v string) *KnowledgeBaseSummary {
	s.KnowledgeBaseArn = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *KnowledgeBaseSummary) SetKnowledgeBaseId(v string) *KnowledgeBaseSummary {
	s.KnowledgeBaseId = &v
	return s
}

// SetKnowledgeBaseType sets the KnowledgeBaseType field's value.
func (s *KnowledgeBaseSummary) SetKnowledgeBaseType(v string) *KnowledgeBaseSummary {
	s.KnowledgeBaseType = &v
	return s
}

// SetName sets the Name field's value.
func (s *KnowledgeBaseSummary) SetName(v string) *KnowledgeBaseSummary {
	s.Name = &v
	return s
}

// SetRenderingConfiguration sets the RenderingConfiguration field's value.
func (s *KnowledgeBaseSummary) SetRenderingConfiguration(v *RenderingConfiguration) *KnowledgeBaseSummary {
	s.RenderingConfiguration = v
	return s
}

// SetServerSideEncryptionConfiguration sets the ServerSideEncryptionConfiguration field's value.
func (s *KnowledgeBaseSummary) SetServerSideEncryptionConfiguration(v *ServerSideEncryptionConfiguration) *KnowledgeBaseSummary {
	s.ServerSideEncryptionConfiguration = v
	return s
}

// SetSourceConfiguration sets the SourceConfiguration field's value.
func (s *KnowledgeBaseSummary) SetSourceConfiguration(v *SourceConfiguration) *KnowledgeBaseSummary {
	s.SourceConfiguration = v
	return s
}

// SetStatus sets the Status field's value.
func (s *KnowledgeBaseSummary) SetStatus(v string) *KnowledgeBaseSummary {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *KnowledgeBaseSummary) SetTags(v map[string]*string) *KnowledgeBaseSummary {
	s.Tags = v
	return s
}

type ListAssistantAssociationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the Wisdom assistant. Can be either the ID or the ARN.
	// URLs cannot contain the ARN.
	//
	// AssistantId is a required field
	AssistantId *string `location:"uri" locationName:"assistantId" type:"string" required:"true"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssistantAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssistantAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssistantAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAssistantAssociationsInput"}
	if s.AssistantId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssistantId"))
	}
	if s.AssistantId != nil && len(*s.AssistantId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssistantId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssistantId sets the AssistantId field's value.
func (s *ListAssistantAssociationsInput) SetAssistantId(v string) *ListAssistantAssociationsInput {
	s.AssistantId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAssistantAssociationsInput) SetMaxResults(v int64) *ListAssistantAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssistantAssociationsInput) SetNextToken(v string) *ListAssistantAssociationsInput {
	s.NextToken = &v
	return s
}

type ListAssistantAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// Summary information about assistant associations.
	//
	// AssistantAssociationSummaries is a required field
	AssistantAssociationSummaries []*AssistantAssociationSummary `locationName:"assistantAssociationSummaries" type:"list" required:"true"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssistantAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssistantAssociationsOutput) GoString() string {
	return s.String()
}

// SetAssistantAssociationSummaries sets the AssistantAssociationSummaries field's value.
func (s *ListAssistantAssociationsOutput) SetAssistantAssociationSummaries(v []*AssistantAssociationSummary) *ListAssistantAssociationsOutput {
	s.AssistantAssociationSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssistantAssociationsOutput) SetNextToken(v string) *ListAssistantAssociationsOutput {
	s.NextToken = &v
	return s
}

type ListAssistantsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssistantsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssistantsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssistantsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAssistantsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAssistantsInput) SetMaxResults(v int64) *ListAssistantsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssistantsInput) SetNextToken(v string) *ListAssistantsInput {
	s.NextToken = &v
	return s
}

type ListAssistantsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the assistants.
	//
	// AssistantSummaries is a required field
	AssistantSummaries []*AssistantSummary `locationName:"assistantSummaries" type:"list" required:"true"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssistantsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssistantsOutput) GoString() string {
	return s.String()
}

// SetAssistantSummaries sets the AssistantSummaries field's value.
func (s *ListAssistantsOutput) SetAssistantSummaries(v []*AssistantSummary) *ListAssistantsOutput {
	s.AssistantSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssistantsOutput) SetNextToken(v string) *ListAssistantsOutput {
	s.NextToken = &v
	return s
}

type ListContentsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The the identifier of the knowledge base. Can be either the ID or the ARN.
	// URLs cannot contain the ARN.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListContentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListContentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListContentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListContentsInput"}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *ListContentsInput) SetKnowledgeBaseId(v string) *ListContentsInput {
	s.KnowledgeBaseId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListContentsInput) SetMaxResults(v int64) *ListContentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListContentsInput) SetNextToken(v string) *ListContentsInput {
	s.NextToken = &v
	return s
}

type ListContentsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the content.
	//
	// ContentSummaries is a required field
	ContentSummaries []*ContentSummary `locationName:"contentSummaries" type:"list" required:"true"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListContentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListContentsOutput) GoString() string {
	return s.String()
}

// SetContentSummaries sets the ContentSummaries field's value.
func (s *ListContentsOutput) SetContentSummaries(v []*ContentSummary) *ListContentsOutput {
	s.ContentSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListContentsOutput) SetNextToken(v string) *ListContentsOutput {
	s.NextToken = &v
	return s
}

type ListKnowledgeBasesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKnowledgeBasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKnowledgeBasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListKnowledgeBasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListKnowledgeBasesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListKnowledgeBasesInput) SetMaxResults(v int64) *ListKnowledgeBasesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKnowledgeBasesInput) SetNextToken(v string) *ListKnowledgeBasesInput {
	s.NextToken = &v
	return s
}

type ListKnowledgeBasesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the knowledge bases.
	//
	// KnowledgeBaseSummaries is a required field
	KnowledgeBaseSummaries []*KnowledgeBaseSummary `locationName:"knowledgeBaseSummaries" type:"list" required:"true"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKnowledgeBasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKnowledgeBasesOutput) GoString() string {
	return s.String()
}

// SetKnowledgeBaseSummaries sets the KnowledgeBaseSummaries field's value.
func (s *ListKnowledgeBasesOutput) SetKnowledgeBaseSummaries(v []*KnowledgeBaseSummary) *ListKnowledgeBasesOutput {
	s.KnowledgeBaseSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKnowledgeBasesOutput) SetNextToken(v string) *ListKnowledgeBasesOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// An error occurred when creating a recommendation.
type NotifyRecommendationsReceivedError struct {
	_ struct{} `type:"structure"`

	// A recommendation is causing an error.
	Message *string `locationName:"message" type:"string"`

	// The identifier of the recommendation that is in error.
	RecommendationId *string `locationName:"recommendationId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotifyRecommendationsReceivedError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotifyRecommendationsReceivedError) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *NotifyRecommendationsReceivedError) SetMessage(v string) *NotifyRecommendationsReceivedError {
	s.Message = &v
	return s
}

// SetRecommendationId sets the RecommendationId field's value.
func (s *NotifyRecommendationsReceivedError) SetRecommendationId(v string) *NotifyRecommendationsReceivedError {
	s.RecommendationId = &v
	return s
}

type NotifyRecommendationsReceivedInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Wisdom assistant. Can be either the ID or the ARN.
	// URLs cannot contain the ARN.
	//
	// AssistantId is a required field
	AssistantId *string `location:"uri" locationName:"assistantId" type:"string" required:"true"`

	// The identifiers of the recommendations.
	//
	// RecommendationIds is a required field
	RecommendationIds []*string `locationName:"recommendationIds" type:"list" required:"true"`

	// The identifier of the session. Can be either the ID or the ARN. URLs cannot
	// contain the ARN.
	//
	// SessionId is a required field
	SessionId *string `location:"uri" locationName:"sessionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotifyRecommendationsReceivedInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotifyRecommendationsReceivedInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotifyRecommendationsReceivedInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NotifyRecommendationsReceivedInput"}
	if s.AssistantId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssistantId"))
	}
	if s.AssistantId != nil && len(*s.AssistantId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssistantId", 1))
	}
	if s.RecommendationIds == nil {
		invalidParams.Add(request.NewErrParamRequired("RecommendationIds"))
	}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssistantId sets the AssistantId field's value.
func (s *NotifyRecommendationsReceivedInput) SetAssistantId(v string) *NotifyRecommendationsReceivedInput {
	s.AssistantId = &v
	return s
}

// SetRecommendationIds sets the RecommendationIds field's value.
func (s *NotifyRecommendationsReceivedInput) SetRecommendationIds(v []*string) *NotifyRecommendationsReceivedInput {
	s.RecommendationIds = v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *NotifyRecommendationsReceivedInput) SetSessionId(v string) *NotifyRecommendationsReceivedInput {
	s.SessionId = &v
	return s
}

type NotifyRecommendationsReceivedOutput struct {
	_ struct{} `type:"structure"`

	// The identifiers of recommendations that are causing errors.
	Errors []*NotifyRecommendationsReceivedError `locationName:"errors" type:"list"`

	// The identifiers of the recommendations.
	RecommendationIds []*string `locationName:"recommendationIds" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotifyRecommendationsReceivedOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotifyRecommendationsReceivedOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *NotifyRecommendationsReceivedOutput) SetErrors(v []*NotifyRecommendationsReceivedError) *NotifyRecommendationsReceivedOutput {
	s.Errors = v
	return s
}

// SetRecommendationIds sets the RecommendationIds field's value.
func (s *NotifyRecommendationsReceivedOutput) SetRecommendationIds(v []*string) *NotifyRecommendationsReceivedOutput {
	s.RecommendationIds = v
	return s
}

// The provided revisionId does not match, indicating the content has been modified
// since it was last read.
type PreconditionFailedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PreconditionFailedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PreconditionFailedException) GoString() string {
	return s.String()
}

func newErrorPreconditionFailedException(v protocol.ResponseMetadata) error {
	return &PreconditionFailedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PreconditionFailedException) Code() string {
	return "PreconditionFailedException"
}

// Message returns the exception's message.
func (s *PreconditionFailedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PreconditionFailedException) OrigErr() error {
	return nil
}

func (s *PreconditionFailedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PreconditionFailedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PreconditionFailedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type QueryAssistantInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Wisdom assistant. Can be either the ID or the ARN.
	// URLs cannot contain the ARN.
	//
	// AssistantId is a required field
	AssistantId *string `location:"uri" locationName:"assistantId" type:"string" required:"true"`

	// The maximum number of results to return per page.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The text to search for.
	//
	// QueryText is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by QueryAssistantInput's
	// String and GoString methods.
	//
	// QueryText is a required field
	QueryText *string `locationName:"queryText" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryAssistantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryAssistantInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueryAssistantInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QueryAssistantInput"}
	if s.AssistantId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssistantId"))
	}
	if s.AssistantId != nil && len(*s.AssistantId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssistantId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.QueryText == nil {
		invalidParams.Add(request.NewErrParamRequired("QueryText"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssistantId sets the AssistantId field's value.
func (s *QueryAssistantInput) SetAssistantId(v string) *QueryAssistantInput {
	s.AssistantId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *QueryAssistantInput) SetMaxResults(v int64) *QueryAssistantInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *QueryAssistantInput) SetNextToken(v string) *QueryAssistantInput {
	s.NextToken = &v
	return s
}

// SetQueryText sets the QueryText field's value.
func (s *QueryAssistantInput) SetQueryText(v string) *QueryAssistantInput {
	s.QueryText = &v
	return s
}

type QueryAssistantOutput struct {
	_ struct{} `type:"structure"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The results of the query.
	//
	// Results is a required field
	Results []*ResultData `locationName:"results" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryAssistantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueryAssistantOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *QueryAssistantOutput) SetNextToken(v string) *QueryAssistantOutput {
	s.NextToken = &v
	return s
}

// SetResults sets the Results field's value.
func (s *QueryAssistantOutput) SetResults(v []*ResultData) *QueryAssistantOutput {
	s.Results = v
	return s
}

// Information about the recommendation.
type RecommendationData struct {
	_ struct{} `type:"structure"`

	// The recommended document.
	//
	// Document is a required field
	Document *Document `locationName:"document" type:"structure" required:"true"`

	// The identifier of the recommendation.
	//
	// RecommendationId is a required field
	RecommendationId *string `locationName:"recommendationId" type:"string" required:"true"`

	// The relevance level of the recommendation.
	RelevanceLevel *string `locationName:"relevanceLevel" type:"string" enum:"RelevanceLevel"`

	// The relevance score of the recommendation.
	RelevanceScore *float64 `locationName:"relevanceScore" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecommendationData) GoString() string {
	return s.String()
}

// SetDocument sets the Document field's value.
func (s *RecommendationData) SetDocument(v *Document) *RecommendationData {
	s.Document = v
	return s
}

// SetRecommendationId sets the RecommendationId field's value.
func (s *RecommendationData) SetRecommendationId(v string) *RecommendationData {
	s.RecommendationId = &v
	return s
}

// SetRelevanceLevel sets the RelevanceLevel field's value.
func (s *RecommendationData) SetRelevanceLevel(v string) *RecommendationData {
	s.RelevanceLevel = &v
	return s
}

// SetRelevanceScore sets the RelevanceScore field's value.
func (s *RecommendationData) SetRelevanceScore(v float64) *RecommendationData {
	s.RelevanceScore = &v
	return s
}

type RemoveKnowledgeBaseTemplateUriInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The the identifier of the knowledge base. Can be either the ID or the ARN.
	// URLs cannot contain the ARN.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveKnowledgeBaseTemplateUriInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveKnowledgeBaseTemplateUriInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveKnowledgeBaseTemplateUriInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveKnowledgeBaseTemplateUriInput"}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *RemoveKnowledgeBaseTemplateUriInput) SetKnowledgeBaseId(v string) *RemoveKnowledgeBaseTemplateUriInput {
	s.KnowledgeBaseId = &v
	return s
}

type RemoveKnowledgeBaseTemplateUriOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveKnowledgeBaseTemplateUriOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveKnowledgeBaseTemplateUriOutput) GoString() string {
	return s.String()
}

// Information about how to render the content.
type RenderingConfiguration struct {
	_ struct{} `type:"structure"`

	// A URI template containing exactly one variable in ${variableName} format.
	// This can only be set for EXTERNAL knowledge bases. For Salesforce and ServiceNow,
	// the variable must be one of the following:
	//
	//    * Salesforce: Id, ArticleNumber, VersionNumber, Title, PublishStatus,
	//    or IsDeleted
	//
	//    * ServiceNow: number, short_description, sys_mod_count, workflow_state,
	//    or active
	//
	//    <p>The variable is replaced with the actual value for a piece of content
	//    when calling <a href="https://docs.aws.amazon.com/wisdom/latest/APIReference/API_GetContent.html">GetContent</a>.
	//    </p>
	TemplateUri *string `locationName:"templateUri" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RenderingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RenderingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RenderingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RenderingConfiguration"}
	if s.TemplateUri != nil && len(*s.TemplateUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateUri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateUri sets the TemplateUri field's value.
func (s *RenderingConfiguration) SetTemplateUri(v string) *RenderingConfiguration {
	s.TemplateUri = &v
	return s
}

// The specified resource does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The specified resource name.
	ResourceName *string `locationName:"resourceName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about the result.
type ResultData struct {
	_ struct{} `type:"structure"`

	// The document.
	//
	// Document is a required field
	Document *Document `locationName:"document" type:"structure" required:"true"`

	// The relevance score of the results.
	RelevanceScore *float64 `locationName:"relevanceScore" type:"double"`

	// The identifier of the result data.
	//
	// ResultId is a required field
	ResultId *string `locationName:"resultId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResultData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResultData) GoString() string {
	return s.String()
}

// SetDocument sets the Document field's value.
func (s *ResultData) SetDocument(v *Document) *ResultData {
	s.Document = v
	return s
}

// SetRelevanceScore sets the RelevanceScore field's value.
func (s *ResultData) SetRelevanceScore(v float64) *ResultData {
	s.RelevanceScore = &v
	return s
}

// SetResultId sets the ResultId field's value.
func (s *ResultData) SetResultId(v string) *ResultData {
	s.ResultId = &v
	return s
}

type SearchContentInput struct {
	_ struct{} `type:"structure"`

	// The the identifier of the knowledge base. Can be either the ID or the ARN.
	// URLs cannot contain the ARN.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The search expression to filter results.
	//
	// SearchExpression is a required field
	SearchExpression *SearchExpression `locationName:"searchExpression" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchContentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchContentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchContentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchContentInput"}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.SearchExpression == nil {
		invalidParams.Add(request.NewErrParamRequired("SearchExpression"))
	}
	if s.SearchExpression != nil {
		if err := s.SearchExpression.Validate(); err != nil {
			invalidParams.AddNested("SearchExpression", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *SearchContentInput) SetKnowledgeBaseId(v string) *SearchContentInput {
	s.KnowledgeBaseId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchContentInput) SetMaxResults(v int64) *SearchContentInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchContentInput) SetNextToken(v string) *SearchContentInput {
	s.NextToken = &v
	return s
}

// SetSearchExpression sets the SearchExpression field's value.
func (s *SearchContentInput) SetSearchExpression(v *SearchExpression) *SearchContentInput {
	s.SearchExpression = v
	return s
}

type SearchContentOutput struct {
	_ struct{} `type:"structure"`

	// Summary information about the content.
	//
	// ContentSummaries is a required field
	ContentSummaries []*ContentSummary `locationName:"contentSummaries" type:"list" required:"true"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchContentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchContentOutput) GoString() string {
	return s.String()
}

// SetContentSummaries sets the ContentSummaries field's value.
func (s *SearchContentOutput) SetContentSummaries(v []*ContentSummary) *SearchContentOutput {
	s.ContentSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchContentOutput) SetNextToken(v string) *SearchContentOutput {
	s.NextToken = &v
	return s
}

// The search expression.
type SearchExpression struct {
	_ struct{} `type:"structure"`

	// The search expression filters.
	//
	// Filters is a required field
	Filters []*Filter `locationName:"filters" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchExpression) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchExpression) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchExpression) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchExpression"}
	if s.Filters == nil {
		invalidParams.Add(request.NewErrParamRequired("Filters"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *SearchExpression) SetFilters(v []*Filter) *SearchExpression {
	s.Filters = v
	return s
}

type SearchSessionsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Wisdom assistant. Can be either the ID or the ARN.
	// URLs cannot contain the ARN.
	//
	// AssistantId is a required field
	AssistantId *string `location:"uri" locationName:"assistantId" type:"string" required:"true"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The search expression to filter results.
	//
	// SearchExpression is a required field
	SearchExpression *SearchExpression `locationName:"searchExpression" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchSessionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchSessionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchSessionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchSessionsInput"}
	if s.AssistantId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssistantId"))
	}
	if s.AssistantId != nil && len(*s.AssistantId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssistantId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.SearchExpression == nil {
		invalidParams.Add(request.NewErrParamRequired("SearchExpression"))
	}
	if s.SearchExpression != nil {
		if err := s.SearchExpression.Validate(); err != nil {
			invalidParams.AddNested("SearchExpression", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssistantId sets the AssistantId field's value.
func (s *SearchSessionsInput) SetAssistantId(v string) *SearchSessionsInput {
	s.AssistantId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchSessionsInput) SetMaxResults(v int64) *SearchSessionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchSessionsInput) SetNextToken(v string) *SearchSessionsInput {
	s.NextToken = &v
	return s
}

// SetSearchExpression sets the SearchExpression field's value.
func (s *SearchSessionsInput) SetSearchExpression(v *SearchExpression) *SearchSessionsInput {
	s.SearchExpression = v
	return s
}

type SearchSessionsOutput struct {
	_ struct{} `type:"structure"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Summary information about the sessions.
	//
	// SessionSummaries is a required field
	SessionSummaries []*SessionSummary `locationName:"sessionSummaries" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchSessionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchSessionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *SearchSessionsOutput) SetNextToken(v string) *SearchSessionsOutput {
	s.NextToken = &v
	return s
}

// SetSessionSummaries sets the SessionSummaries field's value.
func (s *SearchSessionsOutput) SetSessionSummaries(v []*SessionSummary) *SearchSessionsOutput {
	s.SessionSummaries = v
	return s
}

// The KMS key used for encryption.
type ServerSideEncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// The KMS key. For information about valid ID values, see Key identifiers (KeyId)
	// (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id)
	// in the AWS Key Management Service Developer Guide.
	KmsKeyId *string `locationName:"kmsKeyId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerSideEncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerSideEncryptionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServerSideEncryptionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServerSideEncryptionConfiguration"}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *ServerSideEncryptionConfiguration) SetKmsKeyId(v string) *ServerSideEncryptionConfiguration {
	s.KmsKeyId = &v
	return s
}

// You've exceeded your service quota. To perform the requested action, remove
// some of the relevant resources, or use service quotas to request a service
// quota increase.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about the session.
type SessionData struct {
	_ struct{} `type:"structure"`

	// The description of the session.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the session.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the session.
	//
	// SessionArn is a required field
	SessionArn *string `locationName:"sessionArn" type:"string" required:"true"`

	// The identifier of the session.
	//
	// SessionId is a required field
	SessionId *string `locationName:"sessionId" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SessionData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SessionData) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *SessionData) SetDescription(v string) *SessionData {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *SessionData) SetName(v string) *SessionData {
	s.Name = &v
	return s
}

// SetSessionArn sets the SessionArn field's value.
func (s *SessionData) SetSessionArn(v string) *SessionData {
	s.SessionArn = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *SessionData) SetSessionId(v string) *SessionData {
	s.SessionId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *SessionData) SetTags(v map[string]*string) *SessionData {
	s.Tags = v
	return s
}

// Summary information about the session.
type SessionSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Wisdom assistant
	//
	// AssistantArn is a required field
	AssistantArn *string `locationName:"assistantArn" type:"string" required:"true"`

	// The identifier of the Wisdom assistant.
	//
	// AssistantId is a required field
	AssistantId *string `locationName:"assistantId" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the session.
	//
	// SessionArn is a required field
	SessionArn *string `locationName:"sessionArn" type:"string" required:"true"`

	// The identifier of the session.
	//
	// SessionId is a required field
	SessionId *string `locationName:"sessionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SessionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SessionSummary) GoString() string {
	return s.String()
}

// SetAssistantArn sets the AssistantArn field's value.
func (s *SessionSummary) SetAssistantArn(v string) *SessionSummary {
	s.AssistantArn = &v
	return s
}

// SetAssistantId sets the AssistantId field's value.
func (s *SessionSummary) SetAssistantId(v string) *SessionSummary {
	s.AssistantId = &v
	return s
}

// SetSessionArn sets the SessionArn field's value.
func (s *SessionSummary) SetSessionArn(v string) *SessionSummary {
	s.SessionArn = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *SessionSummary) SetSessionId(v string) *SessionSummary {
	s.SessionId = &v
	return s
}

// Configuration information about the external data source.
type SourceConfiguration struct {
	_ struct{} `type:"structure"`

	// Configuration information for Amazon AppIntegrations to automatically ingest
	// content.
	AppIntegrations *AppIntegrationsConfiguration `locationName:"appIntegrations" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SourceConfiguration"}
	if s.AppIntegrations != nil {
		if err := s.AppIntegrations.Validate(); err != nil {
			invalidParams.AddNested("AppIntegrations", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppIntegrations sets the AppIntegrations field's value.
func (s *SourceConfiguration) SetAppIntegrations(v *AppIntegrationsConfiguration) *SourceConfiguration {
	s.AppIntegrations = v
	return s
}

type StartContentUploadInput struct {
	_ struct{} `type:"structure"`

	// The type of content to upload.
	//
	// ContentType is a required field
	ContentType *string `locationName:"contentType" type:"string" required:"true"`

	// The the identifier of the knowledge base. Can be either the ID or the ARN.
	// URLs cannot contain the ARN.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartContentUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartContentUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartContentUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartContentUploadInput"}
	if s.ContentType == nil {
		invalidParams.Add(request.NewErrParamRequired("ContentType"))
	}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentType sets the ContentType field's value.
func (s *StartContentUploadInput) SetContentType(v string) *StartContentUploadInput {
	s.ContentType = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *StartContentUploadInput) SetKnowledgeBaseId(v string) *StartContentUploadInput {
	s.KnowledgeBaseId = &v
	return s
}

type StartContentUploadOutput struct {
	_ struct{} `type:"structure"`

	// The headers to include in the upload.
	//
	// HeadersToInclude is a required field
	HeadersToInclude map[string]*string `locationName:"headersToInclude" type:"map" required:"true"`

	// The identifier of the upload.
	//
	// UploadId is a required field
	UploadId *string `locationName:"uploadId" min:"1" type:"string" required:"true"`

	// The URL of the upload.
	//
	// Url is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StartContentUploadOutput's
	// String and GoString methods.
	//
	// Url is a required field
	Url *string `locationName:"url" min:"1" type:"string" required:"true" sensitive:"true"`

	// The expiration time of the URL as an epoch timestamp.
	//
	// UrlExpiry is a required field
	UrlExpiry *time.Time `locationName:"urlExpiry" type:"timestamp" timestampFormat:"unixTimestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartContentUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartContentUploadOutput) GoString() string {
	return s.String()
}

// SetHeadersToInclude sets the HeadersToInclude field's value.
func (s *StartContentUploadOutput) SetHeadersToInclude(v map[string]*string) *StartContentUploadOutput {
	s.HeadersToInclude = v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *StartContentUploadOutput) SetUploadId(v string) *StartContentUploadOutput {
	s.UploadId = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *StartContentUploadOutput) SetUrl(v string) *StartContentUploadOutput {
	s.Url = &v
	return s
}

// SetUrlExpiry sets the UrlExpiry field's value.
func (s *StartContentUploadOutput) SetUrlExpiry(v time.Time) *StartContentUploadOutput {
	s.UrlExpiry = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Amazon Connect Wisdom throws this exception if you have too many tags in
// your tag set.
type TooManyTagsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The specified resource name.
	ResourceName *string `locationName:"resourceName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) GoString() string {
	return s.String()
}

func newErrorTooManyTagsException(v protocol.ResponseMetadata) error {
	return &TooManyTagsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyTagsException) Code() string {
	return "TooManyTagsException"
}

// Message returns the exception's message.
func (s *TooManyTagsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyTagsException) OrigErr() error {
	return nil
}

func (s *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyTagsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyTagsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The tag keys.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateContentInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the content. Can be either the ID or the ARN. URLs cannot
	// contain the ARN.
	//
	// ContentId is a required field
	ContentId *string `location:"uri" locationName:"contentId" type:"string" required:"true"`

	// The the identifier of the knowledge base. Can be either the ID or the ARN
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`

	// A key/value map to store attributes without affecting tagging or recommendations.
	// For example, when synchronizing data between an external system and Wisdom,
	// you can store an external version identifier as metadata to utilize for determining
	// drift.
	Metadata map[string]*string `locationName:"metadata" type:"map"`

	// The URI for the article. If the knowledge base has a templateUri, setting
	// this argument overrides it for this piece of content. To remove an existing
	// overrideLinkOurUri, exclude this argument and set removeOverrideLinkOutUri
	// to true.
	OverrideLinkOutUri *string `locationName:"overrideLinkOutUri" min:"1" type:"string"`

	// Unset the existing overrideLinkOutUri if it exists.
	RemoveOverrideLinkOutUri *bool `locationName:"removeOverrideLinkOutUri" type:"boolean"`

	// The revisionId of the content resource to update, taken from an earlier call
	// to GetContent, GetContentSummary, SearchContent, or ListContents. If included,
	// this argument acts as an optimistic lock to ensure content was not modified
	// since it was last read. If it has been modified, this API throws a PreconditionFailedException.
	RevisionId *string `locationName:"revisionId" min:"1" type:"string"`

	// The title of the content.
	Title *string `locationName:"title" min:"1" type:"string"`

	// A pointer to the uploaded asset. This value is returned by StartContentUpload
	// (https://docs.aws.amazon.com/wisdom/latest/APIReference/API_StartContentUpload.html).
	UploadId *string `locationName:"uploadId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateContentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateContentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateContentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateContentInput"}
	if s.ContentId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContentId"))
	}
	if s.ContentId != nil && len(*s.ContentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContentId", 1))
	}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}
	if s.OverrideLinkOutUri != nil && len(*s.OverrideLinkOutUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OverrideLinkOutUri", 1))
	}
	if s.RevisionId != nil && len(*s.RevisionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RevisionId", 1))
	}
	if s.Title != nil && len(*s.Title) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Title", 1))
	}
	if s.UploadId != nil && len(*s.UploadId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UploadId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentId sets the ContentId field's value.
func (s *UpdateContentInput) SetContentId(v string) *UpdateContentInput {
	s.ContentId = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *UpdateContentInput) SetKnowledgeBaseId(v string) *UpdateContentInput {
	s.KnowledgeBaseId = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *UpdateContentInput) SetMetadata(v map[string]*string) *UpdateContentInput {
	s.Metadata = v
	return s
}

// SetOverrideLinkOutUri sets the OverrideLinkOutUri field's value.
func (s *UpdateContentInput) SetOverrideLinkOutUri(v string) *UpdateContentInput {
	s.OverrideLinkOutUri = &v
	return s
}

// SetRemoveOverrideLinkOutUri sets the RemoveOverrideLinkOutUri field's value.
func (s *UpdateContentInput) SetRemoveOverrideLinkOutUri(v bool) *UpdateContentInput {
	s.RemoveOverrideLinkOutUri = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *UpdateContentInput) SetRevisionId(v string) *UpdateContentInput {
	s.RevisionId = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *UpdateContentInput) SetTitle(v string) *UpdateContentInput {
	s.Title = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *UpdateContentInput) SetUploadId(v string) *UpdateContentInput {
	s.UploadId = &v
	return s
}

type UpdateContentOutput struct {
	_ struct{} `type:"structure"`

	// The content.
	Content *ContentData `locationName:"content" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateContentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateContentOutput) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *UpdateContentOutput) SetContent(v *ContentData) *UpdateContentOutput {
	s.Content = v
	return s
}

type UpdateKnowledgeBaseTemplateUriInput struct {
	_ struct{} `type:"structure"`

	// The the identifier of the knowledge base. Can be either the ID or the ARN.
	// URLs cannot contain the ARN.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`

	// The template URI to update.
	//
	// TemplateUri is a required field
	TemplateUri *string `locationName:"templateUri" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKnowledgeBaseTemplateUriInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKnowledgeBaseTemplateUriInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateKnowledgeBaseTemplateUriInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateKnowledgeBaseTemplateUriInput"}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}
	if s.TemplateUri == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateUri"))
	}
	if s.TemplateUri != nil && len(*s.TemplateUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateUri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *UpdateKnowledgeBaseTemplateUriInput) SetKnowledgeBaseId(v string) *UpdateKnowledgeBaseTemplateUriInput {
	s.KnowledgeBaseId = &v
	return s
}

// SetTemplateUri sets the TemplateUri field's value.
func (s *UpdateKnowledgeBaseTemplateUriInput) SetTemplateUri(v string) *UpdateKnowledgeBaseTemplateUriInput {
	s.TemplateUri = &v
	return s
}

type UpdateKnowledgeBaseTemplateUriOutput struct {
	_ struct{} `type:"structure"`

	// The knowledge base to update.
	KnowledgeBase *KnowledgeBaseData `locationName:"knowledgeBase" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKnowledgeBaseTemplateUriOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKnowledgeBaseTemplateUriOutput) GoString() string {
	return s.String()
}

// SetKnowledgeBase sets the KnowledgeBase field's value.
func (s *UpdateKnowledgeBaseTemplateUriOutput) SetKnowledgeBase(v *KnowledgeBaseData) *UpdateKnowledgeBaseTemplateUriOutput {
	s.KnowledgeBase = v
	return s
}

// The input fails to satisfy the constraints specified by an AWS service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// AssistantStatusCreateInProgress is a AssistantStatus enum value
	AssistantStatusCreateInProgress = "CREATE_IN_PROGRESS"

	// AssistantStatusCreateFailed is a AssistantStatus enum value
	AssistantStatusCreateFailed = "CREATE_FAILED"

	// AssistantStatusActive is a AssistantStatus enum value
	AssistantStatusActive = "ACTIVE"

	// AssistantStatusDeleteInProgress is a AssistantStatus enum value
	AssistantStatusDeleteInProgress = "DELETE_IN_PROGRESS"

	// AssistantStatusDeleteFailed is a AssistantStatus enum value
	AssistantStatusDeleteFailed = "DELETE_FAILED"

	// AssistantStatusDeleted is a AssistantStatus enum value
	AssistantStatusDeleted = "DELETED"
)

// AssistantStatus_Values returns all elements of the AssistantStatus enum
func AssistantStatus_Values() []string {
	return []string{
		AssistantStatusCreateInProgress,
		AssistantStatusCreateFailed,
		AssistantStatusActive,
		AssistantStatusDeleteInProgress,
		AssistantStatusDeleteFailed,
		AssistantStatusDeleted,
	}
}

const (
	// AssistantTypeAgent is a AssistantType enum value
	AssistantTypeAgent = "AGENT"
)

// AssistantType_Values returns all elements of the AssistantType enum
func AssistantType_Values() []string {
	return []string{
		AssistantTypeAgent,
	}
}

const (
	// AssociationTypeKnowledgeBase is a AssociationType enum value
	AssociationTypeKnowledgeBase = "KNOWLEDGE_BASE"
)

// AssociationType_Values returns all elements of the AssociationType enum
func AssociationType_Values() []string {
	return []string{
		AssociationTypeKnowledgeBase,
	}
}

const (
	// ContentStatusCreateInProgress is a ContentStatus enum value
	ContentStatusCreateInProgress = "CREATE_IN_PROGRESS"

	// ContentStatusCreateFailed is a ContentStatus enum value
	ContentStatusCreateFailed = "CREATE_FAILED"

	// ContentStatusActive is a ContentStatus enum value
	ContentStatusActive = "ACTIVE"

	// ContentStatusDeleteInProgress is a ContentStatus enum value
	ContentStatusDeleteInProgress = "DELETE_IN_PROGRESS"

	// ContentStatusDeleteFailed is a ContentStatus enum value
	ContentStatusDeleteFailed = "DELETE_FAILED"

	// ContentStatusDeleted is a ContentStatus enum value
	ContentStatusDeleted = "DELETED"

	// ContentStatusUpdateFailed is a ContentStatus enum value
	ContentStatusUpdateFailed = "UPDATE_FAILED"
)

// ContentStatus_Values returns all elements of the ContentStatus enum
func ContentStatus_Values() []string {
	return []string{
		ContentStatusCreateInProgress,
		ContentStatusCreateFailed,
		ContentStatusActive,
		ContentStatusDeleteInProgress,
		ContentStatusDeleteFailed,
		ContentStatusDeleted,
		ContentStatusUpdateFailed,
	}
}

const (
	// FilterFieldName is a FilterField enum value
	FilterFieldName = "NAME"
)

// FilterField_Values returns all elements of the FilterField enum
func FilterField_Values() []string {
	return []string{
		FilterFieldName,
	}
}

const (
	// FilterOperatorEquals is a FilterOperator enum value
	FilterOperatorEquals = "EQUALS"
)

// FilterOperator_Values returns all elements of the FilterOperator enum
func FilterOperator_Values() []string {
	return []string{
		FilterOperatorEquals,
	}
}

const (
	// KnowledgeBaseStatusCreateInProgress is a KnowledgeBaseStatus enum value
	KnowledgeBaseStatusCreateInProgress = "CREATE_IN_PROGRESS"

	// KnowledgeBaseStatusCreateFailed is a KnowledgeBaseStatus enum value
	KnowledgeBaseStatusCreateFailed = "CREATE_FAILED"

	// KnowledgeBaseStatusActive is a KnowledgeBaseStatus enum value
	KnowledgeBaseStatusActive = "ACTIVE"

	// KnowledgeBaseStatusDeleteInProgress is a KnowledgeBaseStatus enum value
	KnowledgeBaseStatusDeleteInProgress = "DELETE_IN_PROGRESS"

	// KnowledgeBaseStatusDeleteFailed is a KnowledgeBaseStatus enum value
	KnowledgeBaseStatusDeleteFailed = "DELETE_FAILED"

	// KnowledgeBaseStatusDeleted is a KnowledgeBaseStatus enum value
	KnowledgeBaseStatusDeleted = "DELETED"
)

// KnowledgeBaseStatus_Values returns all elements of the KnowledgeBaseStatus enum
func KnowledgeBaseStatus_Values() []string {
	return []string{
		KnowledgeBaseStatusCreateInProgress,
		KnowledgeBaseStatusCreateFailed,
		KnowledgeBaseStatusActive,
		KnowledgeBaseStatusDeleteInProgress,
		KnowledgeBaseStatusDeleteFailed,
		KnowledgeBaseStatusDeleted,
	}
}

const (
	// KnowledgeBaseTypeExternal is a KnowledgeBaseType enum value
	KnowledgeBaseTypeExternal = "EXTERNAL"

	// KnowledgeBaseTypeCustom is a KnowledgeBaseType enum value
	KnowledgeBaseTypeCustom = "CUSTOM"
)

// KnowledgeBaseType_Values returns all elements of the KnowledgeBaseType enum
func KnowledgeBaseType_Values() []string {
	return []string{
		KnowledgeBaseTypeExternal,
		KnowledgeBaseTypeCustom,
	}
}

const (
	// RelevanceLevelHigh is a RelevanceLevel enum value
	RelevanceLevelHigh = "HIGH"

	// RelevanceLevelMedium is a RelevanceLevel enum value
	RelevanceLevelMedium = "MEDIUM"

	// RelevanceLevelLow is a RelevanceLevel enum value
	RelevanceLevelLow = "LOW"
)

// RelevanceLevel_Values returns all elements of the RelevanceLevel enum
func RelevanceLevel_Values() []string {
	return []string{
		RelevanceLevelHigh,
		RelevanceLevelMedium,
		RelevanceLevelLow,
	}
}
