// Code generated by smithy-go-codegen DO NOT EDIT.

package workspaces

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/workspaces/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Terminates the specified WorkSpaces.
//
// Terminating a WorkSpace is a permanent action and cannot be undone. The user's
// data is destroyed. If you need to archive any user data, contact Amazon Web
// Services Support before terminating the WorkSpace.
//
// You can terminate a WorkSpace that is in any state except SUSPENDED .
//
// This operation is asynchronous and returns before the WorkSpaces have been
// completely terminated. After a WorkSpace is terminated, the TERMINATED state is
// returned only briefly before the WorkSpace directory metadata is cleaned up, so
// this state is rarely returned. To confirm that a WorkSpace is terminated, check
// for the WorkSpace ID by using [DescribeWorkSpaces]. If the WorkSpace ID isn't returned, then the
// WorkSpace has been successfully terminated.
//
// Simple AD and AD Connector are made available to you free of charge to use with
// WorkSpaces. If there are no WorkSpaces being used with your Simple AD or AD
// Connector directory for 30 consecutive days, this directory will be
// automatically deregistered for use with Amazon WorkSpaces, and you will be
// charged for this directory as per the [Directory Service pricing terms].
//
// To delete empty directories, see [Delete the Directory for Your WorkSpaces]. If you delete your Simple AD or AD Connector
// directory, you can always create a new one when you want to start using
// WorkSpaces again.
//
// [DescribeWorkSpaces]: https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html
// [Delete the Directory for Your WorkSpaces]: https://docs.aws.amazon.com/workspaces/latest/adminguide/delete-workspaces-directory.html
// [Directory Service pricing terms]: http://aws.amazon.com/directoryservice/pricing/
func (c *Client) TerminateWorkspaces(ctx context.Context, params *TerminateWorkspacesInput, optFns ...func(*Options)) (*TerminateWorkspacesOutput, error) {
	if params == nil {
		params = &TerminateWorkspacesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "TerminateWorkspaces", params, optFns, c.addOperationTerminateWorkspacesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*TerminateWorkspacesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type TerminateWorkspacesInput struct {

	// The WorkSpaces to terminate. You can specify up to 25 WorkSpaces.
	//
	// This member is required.
	TerminateWorkspaceRequests []types.TerminateRequest

	noSmithyDocumentSerde
}

type TerminateWorkspacesOutput struct {

	// Information about the WorkSpaces that could not be terminated.
	FailedRequests []types.FailedWorkspaceChangeRequest

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationTerminateWorkspacesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpTerminateWorkspaces{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpTerminateWorkspaces{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "TerminateWorkspaces"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpTerminateWorkspacesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opTerminateWorkspaces(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opTerminateWorkspaces(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "TerminateWorkspaces",
	}
}
