// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemakergeospatial

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/sagemakergeospatial/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Get the details for a previously initiated Earth Observation job.
func (c *Client) GetEarthObservationJob(ctx context.Context, params *GetEarthObservationJobInput, optFns ...func(*Options)) (*GetEarthObservationJobOutput, error) {
	if params == nil {
		params = &GetEarthObservationJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetEarthObservationJob", params, optFns, c.addOperationGetEarthObservationJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetEarthObservationJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetEarthObservationJobInput struct {

	// The Amazon Resource Name (ARN) of the Earth Observation job.
	//
	// This member is required.
	Arn *string

	noSmithyDocumentSerde
}

type GetEarthObservationJobOutput struct {

	// The Amazon Resource Name (ARN) of the Earth Observation job.
	//
	// This member is required.
	Arn *string

	// The creation time of the initiated Earth Observation job.
	//
	// This member is required.
	CreationTime *time.Time

	// The duration of Earth Observation job, in seconds.
	//
	// This member is required.
	DurationInSeconds *int32

	// Input data for the Earth Observation job.
	//
	// This member is required.
	InputConfig *types.InputConfigOutput

	// An object containing information about the job configuration.
	//
	// This member is required.
	JobConfig types.JobConfigInput

	// The name of the Earth Observation job.
	//
	// This member is required.
	Name *string

	// The status of a previously initiated Earth Observation job.
	//
	// This member is required.
	Status types.EarthObservationJobStatus

	// Details about the errors generated during the Earth Observation job.
	ErrorDetails *types.EarthObservationJobErrorDetails

	// The Amazon Resource Name (ARN) of the IAM role that you specified for the job.
	ExecutionRoleArn *string

	// Details about the errors generated during ExportEarthObservationJob.
	ExportErrorDetails *types.ExportErrorDetails

	// The status of the Earth Observation job.
	ExportStatus types.EarthObservationJobExportStatus

	// The Key Management Service key ID for server-side encryption.
	KmsKeyId *string

	// Bands available in the output of an operation.
	OutputBands []types.OutputBand

	// Each tag consists of a key and a value.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetEarthObservationJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetEarthObservationJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetEarthObservationJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetEarthObservationJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetEarthObservationJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetEarthObservationJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetEarthObservationJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetEarthObservationJob",
	}
}
