// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The configured access rules for the domain's search endpoint, and the current
// status of those rules.
type AccessPoliciesStatus struct {

	// The access policy configured for the domain. Access policies can be
	// resource-based, IP-based, or IAM-based. For more information, see Configuring
	// access policies (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-access-policies)
	// .
	//
	// This member is required.
	Options *string

	// The status of the access policy for the domain.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// List of limits that are specific to a given instance type.
type AdditionalLimit struct {

	//   - MaximumNumberOfDataNodesSupported - This attribute only applies to master
	//   nodes and specifies the maximum number of data nodes of a given instance type a
	//   master node can support.
	//   - MaximumNumberOfDataNodesWithoutMasterNode - This attribute only applies to
	//   data nodes and specifies the maximum number of data nodes of a given instance
	//   type can exist without a master node governing them.
	LimitName *string

	// The values of the additional instance type limits.
	LimitValues []string

	noSmithyDocumentSerde
}

// Status of the advanced options for the specified domain. The following options
// are available:
//   - "rest.action.multi.allow_explicit_index": "true" | "false" - Note the use of
//     a string rather than a boolean. Specifies whether explicit references to indexes
//     are allowed inside the body of HTTP requests. If you want to configure access
//     policies for domain sub-resources, such as specific indexes and domain APIs, you
//     must disable this property. Default is true.
//   - "indices.fielddata.cache.size": "80" - Note the use of a string rather than
//     a boolean. Specifies the percentage of heap space allocated to field data.
//     Default is unbounded.
//   - "indices.query.bool.max_clause_count": "1024" - Note the use of a string
//     rather than a boolean. Specifies the maximum number of clauses allowed in a
//     Lucene boolean query. Default is 1,024. Queries with more than the permitted
//     number of clauses result in a TooManyClauses error.
//   - "override_main_response_version": "true" | "false" - Note the use of a
//     string rather than a boolean. Specifies whether the domain reports its version
//     as 7.10 to allow Elasticsearch OSS clients and plugins to continue working with
//     it. Default is false when creating a domain and true when upgrading a domain.
//
// For more information, see Advanced cluster parameters (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options)
// .
type AdvancedOptionsStatus struct {

	// The status of advanced options for the specified domain.
	//
	// This member is required.
	Options map[string]string

	// The status of advanced options for the specified domain.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// Container for fine-grained access control settings.
type AdvancedSecurityOptions struct {

	// Date and time when the migration period will be disabled. Only necessary when
	// enabling fine-grained access control on an existing domain (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing)
	// .
	AnonymousAuthDisableDate *time.Time

	// True if a 30-day migration period is enabled, during which administrators can
	// create role mappings. Only necessary when enabling fine-grained access control
	// on an existing domain (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing)
	// .
	AnonymousAuthEnabled *bool

	// True if fine-grained access control is enabled.
	Enabled *bool

	// True if the internal user database is enabled.
	InternalUserDatabaseEnabled *bool

	// Container for information about the SAML configuration for OpenSearch
	// Dashboards.
	SAMLOptions *SAMLOptionsOutput

	noSmithyDocumentSerde
}

// Options for enabling and configuring fine-grained access control. For more
// information, see Fine-grained access control in Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html)
// .
type AdvancedSecurityOptionsInput struct {

	// True to enable a 30-day migration period during which administrators can create
	// role mappings. Only necessary when enabling fine-grained access control on an
	// existing domain (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing)
	// .
	AnonymousAuthEnabled *bool

	// True to enable fine-grained access control.
	Enabled *bool

	// True to enable the internal user database.
	InternalUserDatabaseEnabled *bool

	// Container for information about the master user.
	MasterUserOptions *MasterUserOptions

	// Container for information about the SAML configuration for OpenSearch
	// Dashboards.
	SAMLOptions *SAMLOptionsInput

	noSmithyDocumentSerde
}

// The status of fine-grained access control settings for a domain.
type AdvancedSecurityOptionsStatus struct {

	// Container for fine-grained access control settings.
	//
	// This member is required.
	Options *AdvancedSecurityOptions

	// Status of the fine-grained access control settings for a domain.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// Information about an Amazon Web Services account or service that has access to
// an Amazon OpenSearch Service domain through the use of an interface VPC
// endpoint.
type AuthorizedPrincipal struct {

	// The IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html)
	// that is allowed access to the domain.
	Principal *string

	// The type of principal.
	PrincipalType PrincipalType

	noSmithyDocumentSerde
}

// Information about an Auto-Tune action. For more information, see Auto-Tune for
// Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
// .
type AutoTune struct {

	// Details about an Auto-Tune action.
	AutoTuneDetails *AutoTuneDetails

	// The type of Auto-Tune action.
	AutoTuneType AutoTuneType

	noSmithyDocumentSerde
}

// Specifies details about a scheduled Auto-Tune action. For more information, see
// Auto-Tune for Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
// .
type AutoTuneDetails struct {

	// Container for details about a scheduled Auto-Tune action.
	ScheduledAutoTuneDetails *ScheduledAutoTuneDetails

	noSmithyDocumentSerde
}

// This object is deprecated. Use the domain's off-peak window (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html)
// to schedule Auto-Tune optimizations. For migration instructions, see Migrating
// from Auto-Tune maintenance windows (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html#off-peak-migrate)
// . The Auto-Tune maintenance schedule. For more information, see Auto-Tune for
// Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
// .
type AutoTuneMaintenanceSchedule struct {

	// A cron expression for a recurring maintenance schedule during which Auto-Tune
	// can deploy changes.
	CronExpressionForRecurrence *string

	// The duration of the maintenance schedule. For example, "Duration": {"Value": 2,
	// "Unit": "HOURS"} .
	Duration *Duration

	// The Epoch timestamp at which the Auto-Tune maintenance schedule starts.
	StartAt *time.Time

	noSmithyDocumentSerde
}

// Auto-Tune settings when updating a domain. For more information, see Auto-Tune
// for Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
// .
type AutoTuneOptions struct {

	// Whether Auto-Tune is enabled or disabled.
	DesiredState AutoTuneDesiredState

	// DEPRECATED. Use off-peak window (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html)
	// instead. A list of maintenance schedules during which Auto-Tune can deploy
	// changes.
	MaintenanceSchedules []AutoTuneMaintenanceSchedule

	// When disabling Auto-Tune, specify NO_ROLLBACK to retain all prior Auto-Tune
	// settings or DEFAULT_ROLLBACK to revert to the OpenSearch Service defaults. If
	// you specify DEFAULT_ROLLBACK , you must include a MaintenanceSchedule in the
	// request. Otherwise, OpenSearch Service is unable to perform the rollback.
	RollbackOnDisable RollbackOnDisable

	// Whether to use the domain's off-peak window (https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_OffPeakWindow.html)
	// to deploy configuration changes on the domain rather than a maintenance
	// schedule.
	UseOffPeakWindow *bool

	noSmithyDocumentSerde
}

// Options for configuring Auto-Tune. For more information, see Auto-Tune for
// Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
type AutoTuneOptionsInput struct {

	// Whether Auto-Tune is enabled or disabled.
	DesiredState AutoTuneDesiredState

	// A list of maintenance schedules during which Auto-Tune can deploy changes.
	// Maintenance windows are deprecated and have been replaced with off-peak windows (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html)
	// .
	MaintenanceSchedules []AutoTuneMaintenanceSchedule

	// Whether to schedule Auto-Tune optimizations that require blue/green deployments
	// during the domain's configured daily off-peak window.
	UseOffPeakWindow *bool

	noSmithyDocumentSerde
}

// The Auto-Tune settings for a domain, displayed when enabling or disabling
// Auto-Tune.
type AutoTuneOptionsOutput struct {

	// Any errors that occurred while enabling or disabling Auto-Tune.
	ErrorMessage *string

	// The current state of Auto-Tune on the domain.
	State AutoTuneState

	// Whether the domain's off-peak window will be used to deploy Auto-Tune changes
	// rather than a maintenance schedule.
	UseOffPeakWindow *bool

	noSmithyDocumentSerde
}

// The Auto-Tune status for the domain.
type AutoTuneOptionsStatus struct {

	// Auto-Tune settings for updating a domain.
	Options *AutoTuneOptions

	// The current status of Auto-Tune for a domain.
	Status *AutoTuneStatus

	noSmithyDocumentSerde
}

// The current status of Auto-Tune for the domain. For more information, see
// Auto-Tune for Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
// .
type AutoTuneStatus struct {

	// Date and time when Auto-Tune was enabled for the domain.
	//
	// This member is required.
	CreationDate *time.Time

	// The current state of Auto-Tune on the domain.
	//
	// This member is required.
	State AutoTuneState

	// Date and time when the Auto-Tune options were last updated for the domain.
	//
	// This member is required.
	UpdateDate *time.Time

	// Any errors that occurred while enabling or disabling Auto-Tune.
	ErrorMessage *string

	// Indicates whether the domain is being deleted.
	PendingDeletion *bool

	// The latest version of the Auto-Tune options.
	UpdateVersion int32

	noSmithyDocumentSerde
}

// Information about an Availability Zone on a domain.
type AvailabilityZoneInfo struct {

	// The name of the Availability Zone.
	AvailabilityZoneName *string

	// The number of data nodes active in the Availability Zone.
	AvailableDataNodeCount *string

	// The total number of data nodes configured in the Availability Zone.
	ConfiguredDataNodeCount *string

	// The total number of primary and replica shards in the Availability Zone.
	TotalShards *string

	// The total number of primary and replica shards that aren't allocated to any of
	// the nodes in the Availability Zone.
	TotalUnAssignedShards *string

	// The current state of the Availability Zone. Current options are Active and
	// StandBy .
	//   - Active - Data nodes in the Availability Zone are in use.
	//   - StandBy - Data nodes in the Availability Zone are in a standby state.
	//   - NotAvailable - Unable to retrieve information.
	ZoneStatus ZoneStatus

	noSmithyDocumentSerde
}

// Information about an Amazon OpenSearch Service domain.
type AWSDomainInformation struct {

	// Name of the domain.
	//
	// This member is required.
	DomainName *string

	// The Amazon Web Services account ID of the domain owner.
	OwnerId *string

	// The Amazon Web Services Region in which the domain is located.
	Region *string

	noSmithyDocumentSerde
}

// Container for information about a configuration change happening on a domain.
type ChangeProgressDetails struct {

	// The ID of the configuration change.
	ChangeId *string

	// A message corresponding to the status of the configuration change.
	Message *string

	noSmithyDocumentSerde
}

// Progress details for each stage of a domain update.
type ChangeProgressStage struct {

	// The description of the stage.
	Description *string

	// The most recent updated timestamp of the stage.
	LastUpdated *time.Time

	// The name of the stage.
	Name *string

	// The status of the stage.
	Status *string

	noSmithyDocumentSerde
}

// The progress details of a specific domain configuration change.
type ChangeProgressStatusDetails struct {

	// The unique change identifier associated with a specific domain configuration
	// change.
	ChangeId *string

	// The specific stages that the domain is going through to perform the
	// configuration change.
	ChangeProgressStages []ChangeProgressStage

	// The list of properties in the domain configuration change that have completed.
	CompletedProperties []string

	// The list of properties in the domain configuration change that are still
	// pending.
	PendingProperties []string

	// The time at which the configuration change is made on the domain.
	StartTime *time.Time

	// The overall status of the domain configuration change.
	Status OverallChangeStatus

	// The total number of stages required for the configuration change.
	TotalNumberOfStages int32

	noSmithyDocumentSerde
}

// Container for the cluster configuration of an OpenSearch Service domain. For
// more information, see Creating and managing Amazon OpenSearch Service domains (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html)
// .
type ClusterConfig struct {

	// Container for cold storage configuration options.
	ColdStorageOptions *ColdStorageOptions

	// Number of dedicated master nodes in the cluster. This number must be greater
	// than 2 and not 4, otherwise you receive a validation exception.
	DedicatedMasterCount *int32

	// Indicates whether dedicated master nodes are enabled for the cluster. True if
	// the cluster will use a dedicated master node. False if the cluster will not.
	DedicatedMasterEnabled *bool

	// OpenSearch Service instance type of the dedicated master nodes in the cluster.
	DedicatedMasterType OpenSearchPartitionInstanceType

	// Number of data nodes in the cluster. This number must be greater than 1,
	// otherwise you receive a validation exception.
	InstanceCount *int32

	// Instance type of data nodes in the cluster.
	InstanceType OpenSearchPartitionInstanceType

	// A boolean that indicates whether a multi-AZ domain is turned on with a standby
	// AZ. For more information, see Configuring a multi-AZ domain in Amazon
	// OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html)
	// .
	MultiAZWithStandbyEnabled *bool

	// The number of warm nodes in the cluster.
	WarmCount *int32

	// Whether to enable warm storage for the cluster.
	WarmEnabled *bool

	// The instance type for the cluster's warm nodes.
	WarmType OpenSearchWarmPartitionInstanceType

	// Container for zone awareness configuration options. Only required if
	// ZoneAwarenessEnabled is true .
	ZoneAwarenessConfig *ZoneAwarenessConfig

	// Indicates whether multiple Availability Zones are enabled. For more
	// information, see Configuring a multi-AZ domain in Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html)
	// .
	ZoneAwarenessEnabled *bool

	noSmithyDocumentSerde
}

// The cluster configuration status for a domain.
type ClusterConfigStatus struct {

	// Cluster configuration options for the specified domain.
	//
	// This member is required.
	Options *ClusterConfig

	// The status of cluster configuration options for the specified domain.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// Container for the parameters required to enable Cognito authentication for an
// OpenSearch Service domain. For more information, see Configuring Amazon Cognito
// authentication for OpenSearch Dashboards (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html)
// .
type CognitoOptions struct {

	// Whether to enable or disable Amazon Cognito authentication for OpenSearch
	// Dashboards.
	Enabled *bool

	// The Amazon Cognito identity pool ID that you want OpenSearch Service to use for
	// OpenSearch Dashboards authentication.
	IdentityPoolId *string

	// The AmazonOpenSearchServiceCognitoAccess role that allows OpenSearch Service to
	// configure your user pool and identity pool.
	RoleArn *string

	// The Amazon Cognito user pool ID that you want OpenSearch Service to use for
	// OpenSearch Dashboards authentication.
	UserPoolId *string

	noSmithyDocumentSerde
}

// The status of the Cognito options for the specified domain.
type CognitoOptionsStatus struct {

	// Cognito options for the specified domain.
	//
	// This member is required.
	Options *CognitoOptions

	// The status of the Cognito options for the specified domain.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// Container for the parameters required to enable cold storage for an OpenSearch
// Service domain. For more information, see Cold storage for Amazon OpenSearch
// Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cold-storage.html)
// .
type ColdStorageOptions struct {

	// Whether to enable or disable cold storage on the domain.
	//
	// This member is required.
	Enabled *bool

	noSmithyDocumentSerde
}

// A map of OpenSearch or Elasticsearch versions and the versions you can upgrade
// them to.
type CompatibleVersionsMap struct {

	// The current version that the OpenSearch Service domain is running.
	SourceVersion *string

	// The possible versions that you can upgrade the domain to.
	TargetVersions []string

	noSmithyDocumentSerde
}

// The connection properties of an outbound connection.
type ConnectionProperties struct {

	// The connection properties for cross cluster search.
	CrossClusterSearch *CrossClusterSearchConnectionProperties

	// The Endpoint attribute cannot be modified. The endpoint of the remote domain.
	// Applicable for VPC_ENDPOINT connection mode.
	Endpoint *string

	noSmithyDocumentSerde
}

// Cross-cluster search specific connection properties.
type CrossClusterSearchConnectionProperties struct {

	// The status of the SkipUnavailable setting for the outbound connection. This
	// feature allows you to specify some clusters as optional and ensure that your
	// cross-cluster queries return partial results despite failures on one or more
	// remote clusters.
	SkipUnavailable SkipUnavailableStatus

	noSmithyDocumentSerde
}

// Details about a direct-query data source.
type DataSourceDetails struct {

	// The type of data source.
	DataSourceType DataSourceType

	// A description of the data source.
	Description *string

	// The name of the data source.
	Name *string

	noSmithyDocumentSerde
}

// The type of data source.
//
// The following types satisfy this interface:
//
//	DataSourceTypeMemberS3GlueDataCatalog
type DataSourceType interface {
	isDataSourceType()
}

// An Amazon S3 data source.
type DataSourceTypeMemberS3GlueDataCatalog struct {
	Value S3GlueDataCatalog

	noSmithyDocumentSerde
}

func (*DataSourceTypeMemberS3GlueDataCatalog) isDataSourceType() {}

// A filter to apply to the DescribePackage response.
type DescribePackagesFilter struct {

	// Any field from PackageDetails .
	Name DescribePackagesFilterName

	// A non-empty list of values for the specified filter field.
	Value []string

	noSmithyDocumentSerde
}

// Container for the configuration of an OpenSearch Service domain.
type DomainConfig struct {

	// Specifies the access policies for the domain.
	AccessPolicies *AccessPoliciesStatus

	// Key-value pairs to specify advanced configuration options. For more
	// information, see Advanced options (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options)
	// .
	AdvancedOptions *AdvancedOptionsStatus

	// Container for fine-grained access control settings for the domain.
	AdvancedSecurityOptions *AdvancedSecurityOptionsStatus

	// Container for Auto-Tune settings for the domain.
	AutoTuneOptions *AutoTuneOptionsStatus

	// Container for information about the progress of an existing configuration
	// change.
	ChangeProgressDetails *ChangeProgressDetails

	// Container for the cluster configuration of a the domain.
	ClusterConfig *ClusterConfigStatus

	// Container for Amazon Cognito options for the domain.
	CognitoOptions *CognitoOptionsStatus

	// Additional options for the domain endpoint, such as whether to require HTTPS
	// for all traffic.
	DomainEndpointOptions *DomainEndpointOptionsStatus

	// Container for EBS options configured for the domain.
	EBSOptions *EBSOptionsStatus

	// Key-value pairs to enable encryption at rest.
	EncryptionAtRestOptions *EncryptionAtRestOptionsStatus

	// The OpenSearch or Elasticsearch version that the domain is running.
	EngineVersion *VersionStatus

	// Choose either dual stack or IPv4 as your IP address type. Dual stack allows you
	// to share domain resources across IPv4 and IPv6 address types, and is the
	// recommended option. If you set your IP address type to dual stack, you can't
	// change your address type later.
	IPAddressType *IPAddressTypeStatus

	// Key-value pairs to configure log publishing.
	LogPublishingOptions *LogPublishingOptionsStatus

	// Whether node-to-node encryption is enabled or disabled.
	NodeToNodeEncryptionOptions *NodeToNodeEncryptionOptionsStatus

	// Container for off-peak window options for the domain.
	OffPeakWindowOptions *OffPeakWindowOptionsStatus

	// DEPRECATED. Container for parameters required to configure automated snapshots
	// of domain indexes.
	SnapshotOptions *SnapshotOptionsStatus

	// Software update options for the domain.
	SoftwareUpdateOptions *SoftwareUpdateOptionsStatus

	// The current VPC options for the domain and the status of any updates to their
	// configuration.
	VPCOptions *VPCDerivedInfoStatus

	noSmithyDocumentSerde
}

// Options to configure a custom endpoint for an OpenSearch Service domain.
type DomainEndpointOptions struct {

	// The fully qualified URL for the custom endpoint.
	CustomEndpoint *string

	// The ARN for your security certificate, managed in Amazon Web Services
	// Certificate Manager (ACM).
	CustomEndpointCertificateArn *string

	// Whether to enable a custom endpoint for the domain.
	CustomEndpointEnabled *bool

	// True to require that all traffic to the domain arrive over HTTPS.
	EnforceHTTPS *bool

	// Specify the TLS security policy to apply to the HTTPS endpoint of the domain.
	// The policy can be one of the following values:
	//   - Policy-Min-TLS-1-0-2019-07: TLS security policy that supports TLS version
	//   1.0 to TLS version 1.2
	//   - Policy-Min-TLS-1-2-2019-07: TLS security policy that supports only TLS
	//   version 1.2
	//   - Policy-Min-TLS-1-2-PFS-2023-10: TLS security policy that supports TLS
	//   version 1.2 to TLS version 1.3 with perfect forward secrecy cipher suites
	TLSSecurityPolicy TLSSecurityPolicy

	noSmithyDocumentSerde
}

// The configured endpoint options for a domain and their current status.
type DomainEndpointOptionsStatus struct {

	// Options to configure the endpoint for a domain.
	//
	// This member is required.
	Options *DomainEndpointOptions

	// The status of the endpoint options for a domain.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// Information about an OpenSearch Service domain.
type DomainInfo struct {

	// Name of the domain.
	DomainName *string

	// The type of search engine that the domain is running. OpenSearch for an
	// OpenSearch engine, or Elasticsearch for a legacy Elasticsearch OSS engine.
	EngineType EngineType

	noSmithyDocumentSerde
}

// Container for information about an OpenSearch Service domain.
type DomainInformationContainer struct {

	// Information about an Amazon OpenSearch Service domain.
	AWSDomainInformation *AWSDomainInformation

	noSmithyDocumentSerde
}

// Container for the domain maintenance details.
type DomainMaintenanceDetails struct {

	// The name of the action.
	Action MaintenanceType

	// The time at which the action was created.
	CreatedAt *time.Time

	// The name of the domain.
	DomainName *string

	// The ID of the requested action.
	MaintenanceId *string

	// The ID of the data node.
	NodeId *string

	// The status of the action.
	Status MaintenanceStatus

	// The status message for the action.
	StatusMessage *string

	// The time at which the action was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Container for information about nodes on the domain.
type DomainNodesStatus struct {

	// The Availability Zone of the node.
	AvailabilityZone *string

	// The instance type information of the node.
	InstanceType OpenSearchPartitionInstanceType

	// The ID of the node.
	NodeId *string

	// Indicates if the node is active or in standby.
	NodeStatus NodeStatus

	// Indicates whether the nodes is a data, master, or ultrawarm node.
	NodeType NodeType

	// The storage size of the node, in GiB.
	StorageSize *string

	// Indicates if the node has EBS or instance storage.
	StorageType *string

	// If the nodes has EBS storage, indicates if the volume type is GP2 or GP3. Only
	// applicable for data nodes.
	StorageVolumeType VolumeType

	noSmithyDocumentSerde
}

// Information about a package that is associated with a domain. For more
// information, see Custom packages for Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html)
// .
type DomainPackageDetails struct {

	// Name of the domain that the package is associated with.
	DomainName *string

	// State of the association.
	DomainPackageStatus DomainPackageStatus

	// Additional information if the package is in an error state. Null otherwise.
	ErrorDetails *ErrorDetails

	// Timestamp of the most recent update to the package association status.
	LastUpdated *time.Time

	// Internal ID of the package.
	PackageID *string

	// User-specified name of the package.
	PackageName *string

	// The type of package.
	PackageType PackageType

	// The current version of the package.
	PackageVersion *string

	// The relative path of the package on the OpenSearch Service cluster nodes. This
	// is synonym_path when the package is for synonym files.
	ReferencePath *string

	noSmithyDocumentSerde
}

// The current status of an OpenSearch Service domain.
type DomainStatus struct {

	// The Amazon Resource Name (ARN) of the domain. For more information, see IAM
	// identifiers  (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html)
	// in the AWS Identity and Access Management User Guide.
	//
	// This member is required.
	ARN *string

	// Container for the cluster configuration of the domain.
	//
	// This member is required.
	ClusterConfig *ClusterConfig

	// Unique identifier for the domain.
	//
	// This member is required.
	DomainId *string

	// Name of the domain. Domain names are unique across all domains owned by the
	// same account within an Amazon Web Services Region.
	//
	// This member is required.
	DomainName *string

	// Identity and Access Management (IAM) policy document specifying the access
	// policies for the domain.
	AccessPolicies *string

	// Key-value pairs that specify advanced configuration options.
	AdvancedOptions map[string]string

	// Settings for fine-grained access control.
	AdvancedSecurityOptions *AdvancedSecurityOptions

	// Auto-Tune settings for the domain.
	AutoTuneOptions *AutoTuneOptionsOutput

	// Information about a configuration change happening on the domain.
	ChangeProgressDetails *ChangeProgressDetails

	// Key-value pairs to configure Amazon Cognito authentication for OpenSearch
	// Dashboards.
	CognitoOptions *CognitoOptions

	// Creation status of an OpenSearch Service domain. True if domain creation is
	// complete. False if domain creation is still in progress.
	Created *bool

	// Deletion status of an OpenSearch Service domain. True if domain deletion is
	// complete. False if domain deletion is still in progress. Once deletion is
	// complete, the status of the domain is no longer returned.
	Deleted *bool

	// Additional options for the domain endpoint, such as whether to require HTTPS
	// for all traffic.
	DomainEndpointOptions *DomainEndpointOptions

	// Container for EBS-based storage settings for the domain.
	EBSOptions *EBSOptions

	// Encryption at rest settings for the domain.
	EncryptionAtRestOptions *EncryptionAtRestOptions

	// Domain-specific endpoint used to submit index, search, and data upload requests
	// to the domain.
	Endpoint *string

	// If IPAddressType to set to dualstack , a version 2 domain endpoint is
	// provisioned. This endpoint functions like a normal endpoint, except that it
	// works with both IPv4 and IPv6 IP addresses. Normal endpoints work only with IPv4
	// IP addresses.
	EndpointV2 *string

	// The key-value pair that exists if the OpenSearch Service domain uses VPC
	// endpoints. Example key, value :
	// 'vpc','vpc-endpoint-h2dsd34efgyghrtguk5gt6j2foh4.us-east-1.es.amazonaws.com' .
	Endpoints map[string]string

	// Version of OpenSearch or Elasticsearch that the domain is running, in the
	// format Elasticsearch_X.Y or OpenSearch_X.Y .
	EngineVersion *string

	// The type of IP addresses supported by the endpoint for the domain.
	IPAddressType IPAddressType

	// Log publishing options for the domain.
	LogPublishingOptions map[string]LogPublishingOption

	// Whether node-to-node encryption is enabled or disabled.
	NodeToNodeEncryptionOptions *NodeToNodeEncryptionOptions

	// Options that specify a custom 10-hour window during which OpenSearch Service
	// can perform configuration changes on the domain.
	OffPeakWindowOptions *OffPeakWindowOptions

	// The status of the domain configuration. True if OpenSearch Service is
	// processing configuration changes. False if the configuration is active.
	Processing *bool

	// The current status of the domain's service software.
	ServiceSoftwareOptions *ServiceSoftwareOptions

	// DEPRECATED. Container for parameters required to configure automated snapshots
	// of domain indexes.
	SnapshotOptions *SnapshotOptions

	// Service software update options for the domain.
	SoftwareUpdateOptions *SoftwareUpdateOptions

	// The status of a domain version upgrade to a new version of OpenSearch or
	// Elasticsearch. True if OpenSearch Service is in the process of a version
	// upgrade. False if the configuration is active.
	UpgradeProcessing *bool

	// The VPC configuration for the domain.
	VPCOptions *VPCDerivedInfo

	noSmithyDocumentSerde
}

// Information about the progress of a pre-upgrade dry run analysis.
type DryRunProgressStatus struct {

	// The timestamp when the dry run was initiated.
	//
	// This member is required.
	CreationDate *string

	// The unique identifier of the dry run.
	//
	// This member is required.
	DryRunId *string

	// The current status of the dry run.
	//
	// This member is required.
	DryRunStatus *string

	// The timestamp when the dry run was last updated.
	//
	// This member is required.
	UpdateDate *string

	// Any validation failures that occurred as a result of the dry run.
	ValidationFailures []ValidationFailure

	noSmithyDocumentSerde
}

// Results of a dry run performed in an update domain request.
type DryRunResults struct {

	// Specifies the way in which OpenSearch Service will apply an update. Possible
	// values are:
	//   - Blue/Green - The update requires a blue/green deployment.
	//   - DynamicUpdate - No blue/green deployment required
	//   - Undetermined - The domain is in the middle of an update and can't predict
	//   the deployment type. Try again after the update is complete.
	//   - None - The request doesn't include any configuration changes.
	DeploymentType *string

	// A message corresponding to the deployment type.
	Message *string

	noSmithyDocumentSerde
}

// The duration of a maintenance schedule. For more information, see Auto-Tune for
// Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
// .
type Duration struct {

	// The unit of measurement for the duration of a maintenance schedule.
	Unit TimeUnit

	// Integer to specify the value of a maintenance schedule duration.
	Value *int64

	noSmithyDocumentSerde
}

// Container for the parameters required to enable EBS-based storage for an
// OpenSearch Service domain.
type EBSOptions struct {

	// Indicates whether EBS volumes are attached to data nodes in an OpenSearch
	// Service domain.
	EBSEnabled *bool

	// Specifies the baseline input/output (I/O) performance of EBS volumes attached
	// to data nodes. Applicable only for the gp3 and provisioned IOPS EBS volume
	// types.
	Iops *int32

	// Specifies the throughput (in MiB/s) of the EBS volumes attached to data nodes.
	// Applicable only for the gp3 volume type.
	Throughput *int32

	// Specifies the size (in GiB) of EBS volumes attached to data nodes.
	VolumeSize *int32

	// Specifies the type of EBS volumes attached to data nodes.
	VolumeType VolumeType

	noSmithyDocumentSerde
}

// The status of the EBS options for the specified OpenSearch Service domain.
type EBSOptionsStatus struct {

	// The configured EBS options for the specified domain.
	//
	// This member is required.
	Options *EBSOptions

	// The status of the EBS options for the specified domain.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// Specifies whether the domain should encrypt data at rest, and if so, the Key
// Management Service (KMS) key to use. Can be used only to create a new domain,
// not update an existing one.
type EncryptionAtRestOptions struct {

	// True to enable encryption at rest.
	Enabled *bool

	// The KMS key ID. Takes the form 1a2a3a4-1a2a-3a4a-5a6a-1a2a3a4a5a6a .
	KmsKeyId *string

	noSmithyDocumentSerde
}

// Status of the encryption at rest options for the specified OpenSearch Service
// domain.
type EncryptionAtRestOptionsStatus struct {

	// Encryption at rest options for the specified domain.
	//
	// This member is required.
	Options *EncryptionAtRestOptions

	// The status of the encryption at rest options for the specified domain.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// Information about the active domain environment.
type EnvironmentInfo struct {

	// A list of AvailabilityZoneInfo for the domain.
	AvailabilityZoneInformation []AvailabilityZoneInfo

	noSmithyDocumentSerde
}

// Additional information if the package is in an error state. Null otherwise.
type ErrorDetails struct {

	// A message describing the error.
	ErrorMessage *string

	// The type of error that occurred.
	ErrorType *string

	noSmithyDocumentSerde
}

// A filter used to limit results when describing inbound or outbound
// cross-cluster connections. You can specify multiple values per filter. A
// cross-cluster connection must match at least one of the specified values for it
// to be returned from an operation.
type Filter struct {

	// The name of the filter.
	Name *string

	// One or more values for the filter.
	Values []string

	noSmithyDocumentSerde
}

// Describes an inbound cross-cluster connection for Amazon OpenSearch Service.
// For more information, see Cross-cluster search for Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html)
// .
type InboundConnection struct {

	// The unique identifier of the connection.
	ConnectionId *string

	// The connection mode.
	ConnectionMode ConnectionMode

	// The current status of the connection.
	ConnectionStatus *InboundConnectionStatus

	// Information about the source (local) domain.
	LocalDomainInfo *DomainInformationContainer

	// Information about the destination (remote) domain.
	RemoteDomainInfo *DomainInformationContainer

	noSmithyDocumentSerde
}

// The status of an inbound cross-cluster connection for OpenSearch Service.
type InboundConnectionStatus struct {

	// Information about the connection.
	Message *string

	// The status code for the connection. Can be one of the following:
	//   - PENDING_ACCEPTANCE - Inbound connection is not yet accepted by the remote
	//   domain owner.
	//   - APPROVED: Inbound connection is pending acceptance by the remote domain
	//   owner.
	//   - PROVISIONING: Inbound connection is being provisioned.
	//   - ACTIVE: Inbound connection is active and ready to use.
	//   - REJECTING: Inbound connection rejection is in process.
	//   - REJECTED: Inbound connection is rejected.
	//   - DELETING: Inbound connection deletion is in progress.
	//   - DELETED: Inbound connection is deleted and can no longer be used.
	StatusCode InboundConnectionStatusCode

	noSmithyDocumentSerde
}

// Limits on the number of instances that can be created in OpenSearch Service for
// a given instance type.
type InstanceCountLimits struct {

	// The minimum allowed number of instances.
	MaximumInstanceCount int32

	// The maximum allowed number of instances.
	MinimumInstanceCount int32

	noSmithyDocumentSerde
}

// Instance-related attributes that are available for a given instance type.
type InstanceLimits struct {

	// Limits on the number of instances that can be created for a given instance type.
	InstanceCountLimits *InstanceCountLimits

	noSmithyDocumentSerde
}

// Lists all instance types and available features for a given OpenSearch or
// Elasticsearch version.
type InstanceTypeDetails struct {

	// Whether fine-grained access control is supported for the instance type.
	AdvancedSecurityEnabled *bool

	// Whether logging is supported for the instance type.
	AppLogsEnabled *bool

	// The supported Availability Zones for the instance type.
	AvailabilityZones []string

	// Whether Amazon Cognito access is supported for the instance type.
	CognitoEnabled *bool

	// Whether encryption at rest and node-to-node encryption are supported for the
	// instance type.
	EncryptionEnabled *bool

	// Whether the instance acts as a data node, a dedicated master node, or an
	// UltraWarm node.
	InstanceRole []string

	// The instance type.
	InstanceType OpenSearchPartitionInstanceType

	// Whether UltraWarm is supported for the instance type.
	WarmEnabled *bool

	noSmithyDocumentSerde
}

// The IP address type status for the domain.
type IPAddressTypeStatus struct {

	// The IP address options for the domain.
	//
	// This member is required.
	Options IPAddressType

	// Provides the current status of an entity.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// Limits for a given instance type and for each of its roles.
type Limits struct {

	// List of additional limits that are specific to a given instance type for each
	// of its instance roles.
	AdditionalLimits []AdditionalLimit

	// The limits for a given instance type.
	InstanceLimits *InstanceLimits

	// Storage-related attributes that are available for a given instance type.
	StorageTypes []StorageType

	noSmithyDocumentSerde
}

// Specifies whether the Amazon OpenSearch Service domain publishes the OpenSearch
// application and slow logs to Amazon CloudWatch. For more information, see
// Monitoring OpenSearch logs with Amazon CloudWatch Logs (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createdomain-configure-slow-logs.html)
// . After you enable log publishing, you still have to enable the collection of
// slow logs using the OpenSearch REST API.
type LogPublishingOption struct {

	// The Amazon Resource Name (ARN) of the CloudWatch Logs group to publish logs to.
	CloudWatchLogsLogGroupArn *string

	// Whether the log should be published.
	Enabled *bool

	noSmithyDocumentSerde
}

// The configured log publishing options for the domain and their current status.
type LogPublishingOptionsStatus struct {

	// The log publishing options configured for the domain.
	Options map[string]LogPublishingOption

	// The status of the log publishing options for the domain.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// Credentials for the master user for a domain.
type MasterUserOptions struct {

	// Amazon Resource Name (ARN) for the master user. Only specify if
	// InternalUserDatabaseEnabled is false .
	MasterUserARN *string

	// User name for the master user. Only specify if InternalUserDatabaseEnabled is
	// true .
	MasterUserName *string

	// Password for the master user. Only specify if InternalUserDatabaseEnabled is
	// true .
	MasterUserPassword *string

	noSmithyDocumentSerde
}

// Enables or disables node-to-node encryption. For more information, see
// Node-to-node encryption for Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ntn.html)
// .
type NodeToNodeEncryptionOptions struct {

	// True to enable node-to-node encryption.
	Enabled *bool

	noSmithyDocumentSerde
}

// Status of the node-to-node encryption options for the specified domain.
type NodeToNodeEncryptionOptionsStatus struct {

	// The node-to-node encryption options for the specified domain.
	//
	// This member is required.
	Options *NodeToNodeEncryptionOptions

	// The status of the node-to-node encryption options for the specified domain.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// A custom 10-hour, low-traffic window during which OpenSearch Service can
// perform mandatory configuration changes on the domain. These actions can include
// scheduled service software updates and blue/green Auto-Tune enhancements.
// OpenSearch Service will schedule these actions during the window that you
// specify. If you don't specify a window start time, it defaults to 10:00 P.M.
// local time. For more information, see Defining off-peak maintenance windows for
// Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html)
// .
type OffPeakWindow struct {

	// A custom start time for the off-peak window, in Coordinated Universal Time
	// (UTC). The window length will always be 10 hours, so you can't specify an end
	// time. For example, if you specify 11:00 P.M. UTC as a start time, the end time
	// will automatically be set to 9:00 A.M.
	WindowStartTime *WindowStartTime

	noSmithyDocumentSerde
}

// Options for a domain's off-peak window (https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_OffPeakWindow.html)
// , during which OpenSearch Service can perform mandatory configuration changes on
// the domain.
type OffPeakWindowOptions struct {

	// Whether to enable an off-peak window. This option is only available when
	// modifying a domain created prior to February 16, 2023, not when creating a new
	// domain. All domains created after this date have the off-peak window enabled by
	// default. You can't disable the off-peak window after it's enabled for a domain.
	Enabled *bool

	// Off-peak window settings for the domain.
	OffPeakWindow *OffPeakWindow

	noSmithyDocumentSerde
}

// The status of off-peak window (https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_OffPeakWindow.html)
// options for a domain.
type OffPeakWindowOptionsStatus struct {

	// The domain's off-peak window configuration.
	Options *OffPeakWindowOptions

	// The current status of off-peak window options.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// Provides the current status of an entity.
type OptionStatus struct {

	// The timestamp when the entity was created.
	//
	// This member is required.
	CreationDate *time.Time

	// The state of the entity.
	//
	// This member is required.
	State OptionState

	// The timestamp of the last time the entity was updated.
	//
	// This member is required.
	UpdateDate *time.Time

	// Indicates whether the entity is being deleted.
	PendingDeletion *bool

	// The latest version of the entity.
	UpdateVersion int32

	noSmithyDocumentSerde
}

// Specifies details about an outbound cross-cluster connection.
type OutboundConnection struct {

	// Name of the connection.
	ConnectionAlias *string

	// Unique identifier of the connection.
	ConnectionId *string

	// The connection mode.
	ConnectionMode ConnectionMode

	// Properties for the outbound connection.
	ConnectionProperties *ConnectionProperties

	// Status of the connection.
	ConnectionStatus *OutboundConnectionStatus

	// Information about the source (local) domain.
	LocalDomainInfo *DomainInformationContainer

	// Information about the destination (remote) domain.
	RemoteDomainInfo *DomainInformationContainer

	noSmithyDocumentSerde
}

// The status of an outbound cross-cluster connection.
type OutboundConnectionStatus struct {

	// Verbose information for the outbound connection.
	Message *string

	// The status code for the outbound connection. Can be one of the following:
	//   - VALIDATING - The outbound connection request is being validated.
	//   - VALIDATION_FAILED - Validation failed for the connection request.
	//   - PENDING_ACCEPTANCE: Outbound connection request is validated and is not yet
	//   accepted by the remote domain owner.
	//   - APPROVED - Outbound connection has been approved by the remote domain owner
	//   for getting provisioned.
	//   - PROVISIONING - Outbound connection request is in process.
	//   - ACTIVE - Outbound connection is active and ready to use.
	//   - REJECTING - Outbound connection rejection by remote domain owner is in
	//   progress.
	//   - REJECTED - Outbound connection request is rejected by remote domain owner.
	//   - DELETING - Outbound connection deletion is in progress.
	//   - DELETED - Outbound connection is deleted and can no longer be used.
	StatusCode OutboundConnectionStatusCode

	noSmithyDocumentSerde
}

// Basic information about a package.
type PackageDetails struct {

	// The package version.
	AvailablePackageVersion *string

	// If the package is a ZIP-PLUGIN package, additional information about plugin
	// properties.
	AvailablePluginProperties *PluginProperties

	// The timestamp when the package was created.
	CreatedAt *time.Time

	// Version of OpenSearch or Elasticsearch, in the format Elasticsearch_X.Y or
	// OpenSearch_X.Y. Defaults to the latest version of OpenSearch.
	EngineVersion *string

	// Additional information if the package is in an error state. Null otherwise.
	ErrorDetails *ErrorDetails

	// Date and time when the package was last updated.
	LastUpdatedAt *time.Time

	// User-specified description of the package.
	PackageDescription *string

	// The unique identifier of the package.
	PackageID *string

	// The user-specified name of the package.
	PackageName *string

	// The current status of the package. The available options are AVAILABLE , COPYING
	// , COPY_FAILED , VALIDATNG , VALIDATION_FAILED , DELETING , and DELETE_FAILED .
	PackageStatus PackageStatus

	// The type of package.
	PackageType PackageType

	noSmithyDocumentSerde
}

// The Amazon S3 location to import the package from.
type PackageSource struct {

	// The name of the Amazon S3 bucket containing the package.
	S3BucketName *string

	// Key (file name) of the package.
	S3Key *string

	noSmithyDocumentSerde
}

// Details about a package version.
type PackageVersionHistory struct {

	// A message associated with the package version when it was uploaded.
	CommitMessage *string

	// The date and time when the package was created.
	CreatedAt *time.Time

	// The package version.
	PackageVersion *string

	// Additional information about plugin properties if the package is a ZIP-PLUGIN
	// package.
	PluginProperties *PluginProperties

	noSmithyDocumentSerde
}

// Basic information about the plugin.
type PluginProperties struct {

	// The name of the class to load.
	ClassName *string

	// The description of the plugin.
	Description *string

	// The name of the plugin.
	Name *string

	// The uncompressed size of the plugin.
	UncompressedSizeInBytes *int64

	// The version of the plugin.
	Version *string

	noSmithyDocumentSerde
}

// Contains the specific price and frequency of a recurring charges for an
// OpenSearch Reserved Instance, or for a Reserved Instance offering.
type RecurringCharge struct {

	// The monetary amount of the recurring charge.
	RecurringChargeAmount *float64

	// The frequency of the recurring charge.
	RecurringChargeFrequency *string

	noSmithyDocumentSerde
}

// Details of an OpenSearch Reserved Instance.
type ReservedInstance struct {

	// The unique identifier of the billing subscription.
	BillingSubscriptionId *int64

	// The currency code for the offering.
	CurrencyCode *string

	// The duration, in seconds, for which the OpenSearch instance is reserved.
	Duration int32

	// The upfront fixed charge you will paid to purchase the specific Reserved
	// Instance offering.
	FixedPrice *float64

	// The number of OpenSearch instances that have been reserved.
	InstanceCount int32

	// The OpenSearch instance type offered by theReserved Instance offering.
	InstanceType OpenSearchPartitionInstanceType

	// The payment option as defined in the Reserved Instance offering.
	PaymentOption ReservedInstancePaymentOption

	// The recurring charge to your account, regardless of whether you create any
	// domains using the Reserved Instance offering.
	RecurringCharges []RecurringCharge

	// The customer-specified identifier to track this reservation.
	ReservationName *string

	// The unique identifier for the reservation.
	ReservedInstanceId *string

	// The unique identifier of the Reserved Instance offering.
	ReservedInstanceOfferingId *string

	// The date and time when the reservation was purchased.
	StartTime *time.Time

	// The state of the Reserved Instance.
	State *string

	// The hourly rate at which you're charged for the domain using this Reserved
	// Instance.
	UsagePrice *float64

	noSmithyDocumentSerde
}

// Details of an OpenSearch Reserved Instance offering.
type ReservedInstanceOffering struct {

	// The currency code for the Reserved Instance offering.
	CurrencyCode *string

	// The duration, in seconds, for which the offering will reserve the OpenSearch
	// instance.
	Duration int32

	// The upfront fixed charge you will pay to purchase the specific Reserved
	// Instance offering.
	FixedPrice *float64

	// The OpenSearch instance type offered by the Reserved Instance offering.
	InstanceType OpenSearchPartitionInstanceType

	// Payment option for the Reserved Instance offering
	PaymentOption ReservedInstancePaymentOption

	// The recurring charge to your account, regardless of whether you creates any
	// domains using the offering.
	RecurringCharges []RecurringCharge

	// The unique identifier of the Reserved Instance offering.
	ReservedInstanceOfferingId *string

	// The hourly rate at which you're charged for the domain using this Reserved
	// Instance.
	UsagePrice *float64

	noSmithyDocumentSerde
}

// Information about the Amazon S3 Glue Data Catalog.
type S3GlueDataCatalog struct {

	// >The Amazon Resource Name (ARN) for the S3 Glue Data Catalog.
	RoleArn *string

	noSmithyDocumentSerde
}

// The SAML identity povider information.
type SAMLIdp struct {

	// The unique entity ID of the application in the SAML identity provider.
	//
	// This member is required.
	EntityId *string

	// The metadata of the SAML application, in XML format.
	//
	// This member is required.
	MetadataContent *string

	noSmithyDocumentSerde
}

// The SAML authentication configuration for an Amazon OpenSearch Service domain.
type SAMLOptionsInput struct {

	// True to enable SAML authentication for a domain.
	Enabled *bool

	// The SAML Identity Provider's information.
	Idp *SAMLIdp

	// The backend role that the SAML master user is mapped to.
	MasterBackendRole *string

	// The SAML master user name, which is stored in the domain's internal user
	// database.
	MasterUserName *string

	// Element of the SAML assertion to use for backend roles. Default is roles .
	RolesKey *string

	// The duration, in minutes, after which a user session becomes inactive.
	// Acceptable values are between 1 and 1440, and the default value is 60.
	SessionTimeoutMinutes *int32

	// Element of the SAML assertion to use for the user name. Default is NameID .
	SubjectKey *string

	noSmithyDocumentSerde
}

// Describes the SAML application configured for the domain.
type SAMLOptionsOutput struct {

	// True if SAML is enabled.
	Enabled *bool

	// Describes the SAML identity provider's information.
	Idp *SAMLIdp

	// The key used for matching the SAML roles attribute.
	RolesKey *string

	// The duration, in minutes, after which a user session becomes inactive.
	SessionTimeoutMinutes *int32

	// The key used for matching the SAML subject attribute.
	SubjectKey *string

	noSmithyDocumentSerde
}

// Information about a scheduled configuration change for an OpenSearch Service
// domain. This actions can be a service software update (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html)
// or a blue/green Auto-Tune enhancement (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html#auto-tune-types)
// .
type ScheduledAction struct {

	// The unique identifier of the scheduled action.
	//
	// This member is required.
	Id *string

	// The time when the change is scheduled to happen.
	//
	// This member is required.
	ScheduledTime *int64

	// The severity of the action.
	//
	// This member is required.
	Severity ActionSeverity

	// The type of action that will be taken on the domain.
	//
	// This member is required.
	Type ActionType

	// Whether or not the scheduled action is cancellable.
	Cancellable *bool

	// A description of the action to be taken.
	Description *string

	// Whether the action is required or optional.
	Mandatory *bool

	// Whether the action was scheduled manually ( CUSTOMER , or by OpenSearch Service
	// automatically ( SYSTEM ).
	ScheduledBy ScheduledBy

	// The current status of the scheduled action.
	Status ActionStatus

	noSmithyDocumentSerde
}

// Specifies details about a scheduled Auto-Tune action. For more information, see
// Auto-Tune for Amazon OpenSearch Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
// .
type ScheduledAutoTuneDetails struct {

	// A description of the Auto-Tune action.
	Action *string

	// The type of Auto-Tune action.
	ActionType ScheduledAutoTuneActionType

	// The date and time when the Auto-Tune action is scheduled for the domain.
	Date *time.Time

	// The severity of the Auto-Tune action. Valid values are LOW , MEDIUM , and HIGH .
	Severity ScheduledAutoTuneSeverityType

	noSmithyDocumentSerde
}

// The current status of the service software for an Amazon OpenSearch Service
// domain. For more information, see Service software updates in Amazon OpenSearch
// Service (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html)
// .
type ServiceSoftwareOptions struct {

	// The timestamp, in Epoch time, until which you can manually request a service
	// software update. After this date, we automatically update your service software.
	AutomatedUpdateDate *time.Time

	// True if you're able to cancel your service software version update. False if
	// you can't cancel your service software update.
	Cancellable *bool

	// The current service software version present on the domain.
	CurrentVersion *string

	// A description of the service software update status.
	Description *string

	// The new service software version, if one is available.
	NewVersion *string

	// True if a service software is never automatically updated. False if a service
	// software is automatically updated after the automated update date.
	OptionalDeployment *bool

	// True if you're able to update your service software version. False if you can't
	// update your service software version.
	UpdateAvailable *bool

	// The status of your service software update.
	UpdateStatus DeploymentStatus

	noSmithyDocumentSerde
}

// The time, in UTC format, when OpenSearch Service takes a daily automated
// snapshot of the specified domain. Default is 0 hours.
type SnapshotOptions struct {

	// The time, in UTC format, when OpenSearch Service takes a daily automated
	// snapshot of the specified domain. Default is 0 hours.
	AutomatedSnapshotStartHour *int32

	noSmithyDocumentSerde
}

// Container for information about a daily automated snapshot for an OpenSearch
// Service domain.
type SnapshotOptionsStatus struct {

	// The daily snapshot options specified for the domain.
	//
	// This member is required.
	Options *SnapshotOptions

	// The status of a daily automated snapshot.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// Options for configuring service software updates for a domain.
type SoftwareUpdateOptions struct {

	// Whether automatic service software updates are enabled for the domain.
	AutoSoftwareUpdateEnabled *bool

	noSmithyDocumentSerde
}

// The status of the service software options for a domain.
type SoftwareUpdateOptionsStatus struct {

	// The service software update options for a domain.
	Options *SoftwareUpdateOptions

	// The status of service software update options, including creation date and last
	// updated date.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// A list of storage types for an Amazon OpenSearch Service domain that are
// available for a given intance type.
type StorageType struct {

	// The storage sub-type, such as gp3 or io1 .
	StorageSubTypeName *string

	// Limits that are applicable for the given storage type.
	StorageTypeLimits []StorageTypeLimit

	// The name of the storage type.
	StorageTypeName *string

	noSmithyDocumentSerde
}

// Limits that are applicable for the given Amazon OpenSearch Service storage type.
type StorageTypeLimit struct {

	// Name of storage limits that are applicable for the given storage type. If
	// StorageType is ebs , the following options are available:
	//   - MinimumVolumeSize - Minimum volume size that is available for the given
	//   storage type. Can be empty if not applicable.
	//   - MaximumVolumeSize - Maximum volume size that is available for the given
	//   storage type. Can be empty if not applicable.
	//   - MaximumIops - Maximum amount of IOPS that is available for the given the
	//   storage type. Can be empty if not applicable.
	//   - MinimumIops - Minimum amount of IOPS that is available for the given the
	//   storage type. Can be empty if not applicable.
	//   - MaximumThroughput - Maximum amount of throughput that is available for the
	//   given the storage type. Can be empty if not applicable.
	//   - MinimumThroughput - Minimum amount of throughput that is available for the
	//   given the storage type. Can be empty if not applicable.
	LimitName *string

	// The limit values.
	LimitValues []string

	noSmithyDocumentSerde
}

// A tag (key-value pair) for an Amazon OpenSearch Service resource.
type Tag struct {

	// The tag key. Tag keys must be unique for the domain to which they are attached.
	//
	// This member is required.
	Key *string

	// The value assigned to the corresponding tag key. Tag values can be null and
	// don't have to be unique in a tag set. For example, you can have a key value pair
	// in a tag set of project : Trinity and cost-center : Trinity
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// History of the last 10 upgrades and upgrade eligibility checks for an Amazon
// OpenSearch Service domain.
type UpgradeHistory struct {

	// UTC timestamp at which the upgrade API call was made, in the format
	// yyyy-MM-ddTHH:mm:ssZ .
	StartTimestamp *time.Time

	// A list of each step performed as part of a specific upgrade or upgrade
	// eligibility check.
	StepsList []UpgradeStepItem

	// A string that describes the upgrade.
	UpgradeName *string

	// The current status of the upgrade. The status can take one of the following
	// values:
	//   - In Progress
	//   - Succeeded
	//   - Succeeded with Issues
	//   - Failed
	UpgradeStatus UpgradeStatus

	noSmithyDocumentSerde
}

// Represents a single step of an upgrade or upgrade eligibility check workflow.
type UpgradeStepItem struct {

	// A list of strings containing detailed information about the errors encountered
	// in a particular step.
	Issues []string

	// The floating point value representing the progress percentage of a particular
	// step.
	ProgressPercent *float64

	// One of three steps that an upgrade or upgrade eligibility check goes through:
	//   - PreUpgradeCheck
	//   - Snapshot
	//   - Upgrade
	UpgradeStep UpgradeStep

	// The current status of the upgrade. The status can take one of the following
	// values:
	//   - In Progress
	//   - Succeeded
	//   - Succeeded with Issues
	//   - Failed
	UpgradeStepStatus UpgradeStatus

	noSmithyDocumentSerde
}

// A validation failure that occurred as the result of a pre-update validation
// check (verbose dry run) on a domain.
type ValidationFailure struct {

	// The error code of the failure.
	Code *string

	// A message corresponding to the failure.
	Message *string

	noSmithyDocumentSerde
}

// The status of the the OpenSearch or Elasticsearch version options for the
// specified Amazon OpenSearch Service domain.
type VersionStatus struct {

	// The OpenSearch or Elasticsearch version for the specified domain.
	//
	// This member is required.
	Options *string

	// The status of the version options for the specified domain.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// Information about the subnets and security groups for an Amazon OpenSearch
// Service domain provisioned within a virtual private cloud (VPC). For more
// information, see Launching your Amazon OpenSearch Service domains using a VPC (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html)
// . This information only exists if the domain was created with VPCOptions .
type VPCDerivedInfo struct {

	// The list of Availability Zones associated with the VPC subnets.
	AvailabilityZones []string

	// The list of security group IDs associated with the VPC endpoints for the domain.
	SecurityGroupIds []string

	// A list of subnet IDs associated with the VPC endpoints for the domain.
	SubnetIds []string

	// The ID for your VPC. Amazon VPC generates this value when you create a VPC.
	VPCId *string

	noSmithyDocumentSerde
}

// Status of the VPC options for a specified domain.
type VPCDerivedInfoStatus struct {

	// The VPC options for the specified domain.
	//
	// This member is required.
	Options *VPCDerivedInfo

	// The status of the VPC options for the specified domain.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// The connection endpoint for connecting to an Amazon OpenSearch Service domain
// through a proxy.
type VpcEndpoint struct {

	// The Amazon Resource Name (ARN) of the domain associated with the endpoint.
	DomainArn *string

	// The connection endpoint ID for connecting to the domain.
	Endpoint *string

	// The current status of the endpoint.
	Status VpcEndpointStatus

	// The unique identifier of the endpoint.
	VpcEndpointId *string

	// The creator of the endpoint.
	VpcEndpointOwner *string

	// Options to specify the subnets and security groups for an Amazon OpenSearch
	// Service VPC endpoint.
	VpcOptions *VPCDerivedInfo

	noSmithyDocumentSerde
}

// Error information when attempting to describe an Amazon OpenSearch
// Service-managed VPC endpoint.
type VpcEndpointError struct {

	// The code associated with the error.
	ErrorCode VpcEndpointErrorCode

	// A message describing the error.
	ErrorMessage *string

	// The unique identifier of the endpoint.
	VpcEndpointId *string

	noSmithyDocumentSerde
}

// Summary information for an Amazon OpenSearch Service-managed VPC endpoint.
type VpcEndpointSummary struct {

	// The Amazon Resource Name (ARN) of the domain associated with the endpoint.
	DomainArn *string

	// The current status of the endpoint.
	Status VpcEndpointStatus

	// The unique identifier of the endpoint.
	VpcEndpointId *string

	// The creator of the endpoint.
	VpcEndpointOwner *string

	noSmithyDocumentSerde
}

// Options to specify the subnets and security groups for an Amazon OpenSearch
// Service VPC endpoint. For more information, see Launching your Amazon
// OpenSearch Service domains using a VPC (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html)
// .
type VPCOptions struct {

	// The list of security group IDs associated with the VPC endpoints for the
	// domain. If you do not provide a security group ID, OpenSearch Service uses the
	// default security group for the VPC.
	SecurityGroupIds []string

	// A list of subnet IDs associated with the VPC endpoints for the domain. If your
	// domain uses multiple Availability Zones, you need to provide two subnet IDs, one
	// per zone. Otherwise, provide only one.
	SubnetIds []string

	noSmithyDocumentSerde
}

// The desired start time for an off-peak maintenance window (https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_OffPeakWindow.html)
// .
type WindowStartTime struct {

	// The start hour of the window in Coordinated Universal Time (UTC), using 24-hour
	// time. For example, 17 refers to 5:00 P.M. UTC.
	//
	// This member is required.
	Hours int64

	// The start minute of the window, in UTC.
	//
	// This member is required.
	Minutes int64

	noSmithyDocumentSerde
}

// The zone awareness configuration for an Amazon OpenSearch Service domain.
type ZoneAwarenessConfig struct {

	// If you enabled multiple Availability Zones, this value is the number of zones
	// that you want the domain to use. Valid values are 2 and 3 . If your domain is
	// provisioned within a VPC, this value be equal to number of subnets.
	AvailabilityZoneCount *int32

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isDataSourceType() {}
