// Code generated by smithy-go-codegen DO NOT EDIT.

package medicalimaging

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/medicalimaging/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Start importing bulk data into an ACTIVE data store. The import job imports
// DICOM P10 files found in the S3 prefix specified by the inputS3Uri parameter.
// The import job stores processing results in the file specified by the
// outputS3Uri parameter.
func (c *Client) StartDICOMImportJob(ctx context.Context, params *StartDICOMImportJobInput, optFns ...func(*Options)) (*StartDICOMImportJobOutput, error) {
	if params == nil {
		params = &StartDICOMImportJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartDICOMImportJob", params, optFns, c.addOperationStartDICOMImportJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartDICOMImportJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartDICOMImportJobInput struct {

	// A unique identifier for API idempotency.
	//
	// This member is required.
	ClientToken *string

	// The Amazon Resource Name (ARN) of the IAM role that grants permission to access
	// medical imaging resources.
	//
	// This member is required.
	DataAccessRoleArn *string

	// The data store identifier.
	//
	// This member is required.
	DatastoreId *string

	// The input prefix path for the S3 bucket that contains the DICOM files to be
	// imported.
	//
	// This member is required.
	InputS3Uri *string

	// The output prefix of the S3 bucket to upload the results of the DICOM import
	// job.
	//
	// This member is required.
	OutputS3Uri *string

	// The import job name.
	JobName *string

	noSmithyDocumentSerde
}

type StartDICOMImportJobOutput struct {

	// The data store identifier.
	//
	// This member is required.
	DatastoreId *string

	// The import job identifier.
	//
	// This member is required.
	JobId *string

	// The import job status.
	//
	// This member is required.
	JobStatus types.JobStatus

	// The timestamp when the import job was submitted.
	//
	// This member is required.
	SubmittedAt *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartDICOMImportJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartDICOMImportJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartDICOMImportJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartDICOMImportJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addIdempotencyToken_opStartDICOMImportJobMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpStartDICOMImportJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartDICOMImportJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpStartDICOMImportJob struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpStartDICOMImportJob) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpStartDICOMImportJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*StartDICOMImportJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *StartDICOMImportJobInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opStartDICOMImportJobMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpStartDICOMImportJob{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opStartDICOMImportJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartDICOMImportJob",
	}
}
