// Code generated by smithy-go-codegen DO NOT EDIT.

package codegurusecurity

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/codegurusecurity/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of all the standard scans in an account. Does not return express
// scans.
func (c *Client) ListScans(ctx context.Context, params *ListScansInput, optFns ...func(*Options)) (*ListScansOutput, error) {
	if params == nil {
		params = &ListScansInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListScans", params, optFns, c.addOperationListScansMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListScansOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListScansInput struct {

	// The maximum number of results to return in the response. Use this parameter
	// when paginating results. If additional results exist beyond the number you
	// specify, the nextToken element is returned in the response. Use nextToken in a
	// subsequent request to retrieve additional results.
	MaxResults *int32

	// A token to use for paginating results that are returned in the response. Set
	// the value of this parameter to null for the first request. For subsequent calls,
	// use the nextToken value returned from the previous request to continue listing
	// results after the first page.
	NextToken *string

	noSmithyDocumentSerde
}

type ListScansOutput struct {

	// A pagination token. You can use this in future calls to ListScans to continue
	// listing results after the current page.
	NextToken *string

	// A list of ScanSummary objects with information about all scans in an account.
	Summaries []types.ScanSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListScansMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListScans{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListScans{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListScans"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListScans(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListScansAPIClient is a client that implements the ListScans operation.
type ListScansAPIClient interface {
	ListScans(context.Context, *ListScansInput, ...func(*Options)) (*ListScansOutput, error)
}

var _ ListScansAPIClient = (*Client)(nil)

// ListScansPaginatorOptions is the paginator options for ListScans
type ListScansPaginatorOptions struct {
	// The maximum number of results to return in the response. Use this parameter
	// when paginating results. If additional results exist beyond the number you
	// specify, the nextToken element is returned in the response. Use nextToken in a
	// subsequent request to retrieve additional results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListScansPaginator is a paginator for ListScans
type ListScansPaginator struct {
	options   ListScansPaginatorOptions
	client    ListScansAPIClient
	params    *ListScansInput
	nextToken *string
	firstPage bool
}

// NewListScansPaginator returns a new ListScansPaginator
func NewListScansPaginator(client ListScansAPIClient, params *ListScansInput, optFns ...func(*ListScansPaginatorOptions)) *ListScansPaginator {
	if params == nil {
		params = &ListScansInput{}
	}

	options := ListScansPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListScansPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListScansPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListScans page.
func (p *ListScansPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListScansOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListScans(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListScans(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListScans",
	}
}
