// This file was generated by the Gtk# code generator.
// Any changes made will be lost if regenerated.

namespace Gtk {

	using System;
	using System.Collections;
	using System.Collections.Generic;
	using System.Runtime.InteropServices;

#region Autogenerated code
	public partial class CellRenderer : GLib.InitiallyUnowned {

		public CellRenderer (IntPtr raw) : base(raw) {}

		protected CellRenderer() : base(IntPtr.Zero)
		{
			CreateNativeObject (new string [0], new GLib.Value [0]);
		}

		[GLib.Property ("mode")]
		public Gtk.CellRendererMode Mode {
			get {
				GLib.Value val = GetProperty ("mode");
				Gtk.CellRendererMode ret = (Gtk.CellRendererMode) (Enum) val;
				val.Dispose ();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value((Enum) value);
				SetProperty("mode", val);
				val.Dispose ();
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_cell_renderer_get_visible(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_cell_renderer_set_visible(IntPtr raw, bool visible);

		[GLib.Property ("visible")]
		public bool Visible {
			get  {
				bool raw_ret = gtk_cell_renderer_get_visible(Handle);
				bool ret = raw_ret;
				return ret;
			}
			set  {
				gtk_cell_renderer_set_visible(Handle, value);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_cell_renderer_get_sensitive(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_cell_renderer_set_sensitive(IntPtr raw, bool sensitive);

		[GLib.Property ("sensitive")]
		public bool Sensitive {
			get  {
				bool raw_ret = gtk_cell_renderer_get_sensitive(Handle);
				bool ret = raw_ret;
				return ret;
			}
			set  {
				gtk_cell_renderer_set_sensitive(Handle, value);
			}
		}

		[GLib.Property ("xalign")]
		public float Xalign {
			get {
				GLib.Value val = GetProperty ("xalign");
				float ret = (float) val;
				val.Dispose ();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("xalign", val);
				val.Dispose ();
			}
		}

		[GLib.Property ("yalign")]
		public float Yalign {
			get {
				GLib.Value val = GetProperty ("yalign");
				float ret = (float) val;
				val.Dispose ();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("yalign", val);
				val.Dispose ();
			}
		}

		[GLib.Property ("xpad")]
		public uint Xpad {
			get {
				GLib.Value val = GetProperty ("xpad");
				uint ret = (uint) val;
				val.Dispose ();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("xpad", val);
				val.Dispose ();
			}
		}

		[GLib.Property ("ypad")]
		public uint Ypad {
			get {
				GLib.Value val = GetProperty ("ypad");
				uint ret = (uint) val;
				val.Dispose ();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("ypad", val);
				val.Dispose ();
			}
		}

		[GLib.Property ("width")]
		public int Width {
			get {
				GLib.Value val = GetProperty ("width");
				int ret = (int) val;
				val.Dispose ();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("width", val);
				val.Dispose ();
			}
		}

		[GLib.Property ("height")]
		public int Height {
			get {
				GLib.Value val = GetProperty ("height");
				int ret = (int) val;
				val.Dispose ();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("height", val);
				val.Dispose ();
			}
		}

		[GLib.Property ("is-expander")]
		public bool IsExpander {
			get {
				GLib.Value val = GetProperty ("is-expander");
				bool ret = (bool) val;
				val.Dispose ();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("is-expander", val);
				val.Dispose ();
			}
		}

		[GLib.Property ("is-expanded")]
		public bool IsExpanded {
			get {
				GLib.Value val = GetProperty ("is-expanded");
				bool ret = (bool) val;
				val.Dispose ();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("is-expanded", val);
				val.Dispose ();
			}
		}

		[GLib.Property ("cell-background")]
		public string CellBackground {
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("cell-background", val);
				val.Dispose ();
			}
		}

		[GLib.Property ("cell-background-gdk")]
		public Gdk.Color CellBackgroundGdk {
			get {
				GLib.Value val = GetProperty ("cell-background-gdk");
				Gdk.Color ret = (Gdk.Color) val;
				val.Dispose ();
				return ret;
			}
			set {
				GLib.Value val = (GLib.Value) value;
				SetProperty("cell-background-gdk", val);
				val.Dispose ();
			}
		}

		[GLib.Property ("cell-background-rgba")]
		public Gdk.RGBA CellBackgroundRgba {
			get {
				GLib.Value val = GetProperty ("cell-background-rgba");
				Gdk.RGBA ret = (Gdk.RGBA) val;
				val.Dispose ();
				return ret;
			}
			set {
				GLib.Value val = new GLib.Value(value);
				SetProperty("cell-background-rgba", val);
				val.Dispose ();
			}
		}

		[GLib.Property ("editing")]
		public bool Editing {
			get {
				GLib.Value val = GetProperty ("editing");
				bool ret = (bool) val;
				val.Dispose ();
				return ret;
			}
		}

		[GLib.Signal("editing-started")]
		public event Gtk.EditingStartedHandler EditingStarted {
			add {
				this.AddSignalHandler ("editing-started", value, typeof (Gtk.EditingStartedArgs));
			}
			remove {
				this.RemoveSignalHandler ("editing-started", value);
			}
		}

		[GLib.Signal("editing-canceled")]
		public event System.EventHandler EditingCanceled {
			add {
				this.AddSignalHandler ("editing-canceled", value);
			}
			remove {
				this.RemoveSignalHandler ("editing-canceled", value);
			}
		}

		static GetRequestModeNativeDelegate GetRequestMode_cb_delegate;
		static GetRequestModeNativeDelegate GetRequestModeVMCallback {
			get {
				if (GetRequestMode_cb_delegate == null)
					GetRequestMode_cb_delegate = new GetRequestModeNativeDelegate (GetRequestMode_cb);
				return GetRequestMode_cb_delegate;
			}
		}

		static void OverrideGetRequestMode (GLib.GType gtype)
		{
			OverrideGetRequestMode (gtype, GetRequestModeVMCallback);
		}

		static void OverrideGetRequestMode (GLib.GType gtype, GetRequestModeNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("get_request_mode"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate int GetRequestModeNativeDelegate (IntPtr inst);

		static int GetRequestMode_cb (IntPtr inst)
		{
			try {
				CellRenderer __obj = GLib.Object.GetObject (inst, false) as CellRenderer;
				Gtk.SizeRequestMode __result;
				__result = __obj.OnGetRequestMode ();
				return (int) __result;
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.CellRenderer), ConnectionMethod="OverrideGetRequestMode")]
		protected virtual Gtk.SizeRequestMode OnGetRequestMode ()
		{
			return InternalGetRequestMode ();
		}

		private Gtk.SizeRequestMode InternalGetRequestMode ()
		{
			GetRequestModeNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("get_request_mode"));
				unmanaged = (GetRequestModeNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(GetRequestModeNativeDelegate));
			}
			if (unmanaged == null) return (Gtk.SizeRequestMode) 0;

			int __result = unmanaged (this.Handle);
			return (Gtk.SizeRequestMode) __result;
		}

		static GetPreferredWidthNativeDelegate GetPreferredWidth_cb_delegate;
		static GetPreferredWidthNativeDelegate GetPreferredWidthVMCallback {
			get {
				if (GetPreferredWidth_cb_delegate == null)
					GetPreferredWidth_cb_delegate = new GetPreferredWidthNativeDelegate (GetPreferredWidth_cb);
				return GetPreferredWidth_cb_delegate;
			}
		}

		static void OverrideGetPreferredWidth (GLib.GType gtype)
		{
			OverrideGetPreferredWidth (gtype, GetPreferredWidthVMCallback);
		}

		static void OverrideGetPreferredWidth (GLib.GType gtype, GetPreferredWidthNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("get_preferred_width"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void GetPreferredWidthNativeDelegate (IntPtr inst, IntPtr widget, out int minimum_size, out int natural_size);

		static void GetPreferredWidth_cb (IntPtr inst, IntPtr widget, out int minimum_size, out int natural_size)
		{
			try {
				CellRenderer __obj = GLib.Object.GetObject (inst, false) as CellRenderer;
				__obj.OnGetPreferredWidth (GLib.Object.GetObject(widget) as Gtk.Widget, out minimum_size, out natural_size);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.CellRenderer), ConnectionMethod="OverrideGetPreferredWidth")]
		protected virtual void OnGetPreferredWidth (Gtk.Widget widget, out int minimum_size, out int natural_size)
		{
			InternalGetPreferredWidth (widget, out minimum_size, out natural_size);
		}

		private void InternalGetPreferredWidth (Gtk.Widget widget, out int minimum_size, out int natural_size)
		{
			GetPreferredWidthNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("get_preferred_width"));
				unmanaged = (GetPreferredWidthNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(GetPreferredWidthNativeDelegate));
			}
			if (unmanaged == null) throw new InvalidOperationException ("No base method to invoke");

			unmanaged (this.Handle, widget == null ? IntPtr.Zero : widget.Handle, out minimum_size, out natural_size);
		}

		static GetPreferredHeightForWidthNativeDelegate GetPreferredHeightForWidth_cb_delegate;
		static GetPreferredHeightForWidthNativeDelegate GetPreferredHeightForWidthVMCallback {
			get {
				if (GetPreferredHeightForWidth_cb_delegate == null)
					GetPreferredHeightForWidth_cb_delegate = new GetPreferredHeightForWidthNativeDelegate (GetPreferredHeightForWidth_cb);
				return GetPreferredHeightForWidth_cb_delegate;
			}
		}

		static void OverrideGetPreferredHeightForWidth (GLib.GType gtype)
		{
			OverrideGetPreferredHeightForWidth (gtype, GetPreferredHeightForWidthVMCallback);
		}

		static void OverrideGetPreferredHeightForWidth (GLib.GType gtype, GetPreferredHeightForWidthNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("get_preferred_height_for_width"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void GetPreferredHeightForWidthNativeDelegate (IntPtr inst, IntPtr widget, int width, out int minimum_height, out int natural_height);

		static void GetPreferredHeightForWidth_cb (IntPtr inst, IntPtr widget, int width, out int minimum_height, out int natural_height)
		{
			try {
				CellRenderer __obj = GLib.Object.GetObject (inst, false) as CellRenderer;
				__obj.OnGetPreferredHeightForWidth (GLib.Object.GetObject(widget) as Gtk.Widget, width, out minimum_height, out natural_height);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.CellRenderer), ConnectionMethod="OverrideGetPreferredHeightForWidth")]
		protected virtual void OnGetPreferredHeightForWidth (Gtk.Widget widget, int width, out int minimum_height, out int natural_height)
		{
			InternalGetPreferredHeightForWidth (widget, width, out minimum_height, out natural_height);
		}

		private void InternalGetPreferredHeightForWidth (Gtk.Widget widget, int width, out int minimum_height, out int natural_height)
		{
			GetPreferredHeightForWidthNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("get_preferred_height_for_width"));
				unmanaged = (GetPreferredHeightForWidthNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(GetPreferredHeightForWidthNativeDelegate));
			}
			if (unmanaged == null) throw new InvalidOperationException ("No base method to invoke");

			unmanaged (this.Handle, widget == null ? IntPtr.Zero : widget.Handle, width, out minimum_height, out natural_height);
		}

		static GetPreferredHeightNativeDelegate GetPreferredHeight_cb_delegate;
		static GetPreferredHeightNativeDelegate GetPreferredHeightVMCallback {
			get {
				if (GetPreferredHeight_cb_delegate == null)
					GetPreferredHeight_cb_delegate = new GetPreferredHeightNativeDelegate (GetPreferredHeight_cb);
				return GetPreferredHeight_cb_delegate;
			}
		}

		static void OverrideGetPreferredHeight (GLib.GType gtype)
		{
			OverrideGetPreferredHeight (gtype, GetPreferredHeightVMCallback);
		}

		static void OverrideGetPreferredHeight (GLib.GType gtype, GetPreferredHeightNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("get_preferred_height"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void GetPreferredHeightNativeDelegate (IntPtr inst, IntPtr widget, out int minimum_size, out int natural_size);

		static void GetPreferredHeight_cb (IntPtr inst, IntPtr widget, out int minimum_size, out int natural_size)
		{
			try {
				CellRenderer __obj = GLib.Object.GetObject (inst, false) as CellRenderer;
				__obj.OnGetPreferredHeight (GLib.Object.GetObject(widget) as Gtk.Widget, out minimum_size, out natural_size);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.CellRenderer), ConnectionMethod="OverrideGetPreferredHeight")]
		protected virtual void OnGetPreferredHeight (Gtk.Widget widget, out int minimum_size, out int natural_size)
		{
			InternalGetPreferredHeight (widget, out minimum_size, out natural_size);
		}

		private void InternalGetPreferredHeight (Gtk.Widget widget, out int minimum_size, out int natural_size)
		{
			GetPreferredHeightNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("get_preferred_height"));
				unmanaged = (GetPreferredHeightNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(GetPreferredHeightNativeDelegate));
			}
			if (unmanaged == null) throw new InvalidOperationException ("No base method to invoke");

			unmanaged (this.Handle, widget == null ? IntPtr.Zero : widget.Handle, out minimum_size, out natural_size);
		}

		static GetPreferredWidthForHeightNativeDelegate GetPreferredWidthForHeight_cb_delegate;
		static GetPreferredWidthForHeightNativeDelegate GetPreferredWidthForHeightVMCallback {
			get {
				if (GetPreferredWidthForHeight_cb_delegate == null)
					GetPreferredWidthForHeight_cb_delegate = new GetPreferredWidthForHeightNativeDelegate (GetPreferredWidthForHeight_cb);
				return GetPreferredWidthForHeight_cb_delegate;
			}
		}

		static void OverrideGetPreferredWidthForHeight (GLib.GType gtype)
		{
			OverrideGetPreferredWidthForHeight (gtype, GetPreferredWidthForHeightVMCallback);
		}

		static void OverrideGetPreferredWidthForHeight (GLib.GType gtype, GetPreferredWidthForHeightNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("get_preferred_width_for_height"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void GetPreferredWidthForHeightNativeDelegate (IntPtr inst, IntPtr widget, int height, out int minimum_width, out int natural_width);

		static void GetPreferredWidthForHeight_cb (IntPtr inst, IntPtr widget, int height, out int minimum_width, out int natural_width)
		{
			try {
				CellRenderer __obj = GLib.Object.GetObject (inst, false) as CellRenderer;
				__obj.OnGetPreferredWidthForHeight (GLib.Object.GetObject(widget) as Gtk.Widget, height, out minimum_width, out natural_width);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.CellRenderer), ConnectionMethod="OverrideGetPreferredWidthForHeight")]
		protected virtual void OnGetPreferredWidthForHeight (Gtk.Widget widget, int height, out int minimum_width, out int natural_width)
		{
			InternalGetPreferredWidthForHeight (widget, height, out minimum_width, out natural_width);
		}

		private void InternalGetPreferredWidthForHeight (Gtk.Widget widget, int height, out int minimum_width, out int natural_width)
		{
			GetPreferredWidthForHeightNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("get_preferred_width_for_height"));
				unmanaged = (GetPreferredWidthForHeightNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(GetPreferredWidthForHeightNativeDelegate));
			}
			if (unmanaged == null) throw new InvalidOperationException ("No base method to invoke");

			unmanaged (this.Handle, widget == null ? IntPtr.Zero : widget.Handle, height, out minimum_width, out natural_width);
		}

		static GetAlignedAreaNativeDelegate GetAlignedArea_cb_delegate;
		static GetAlignedAreaNativeDelegate GetAlignedAreaVMCallback {
			get {
				if (GetAlignedArea_cb_delegate == null)
					GetAlignedArea_cb_delegate = new GetAlignedAreaNativeDelegate (GetAlignedArea_cb);
				return GetAlignedArea_cb_delegate;
			}
		}

		static void OverrideGetAlignedArea (GLib.GType gtype)
		{
			OverrideGetAlignedArea (gtype, GetAlignedAreaVMCallback);
		}

		static void OverrideGetAlignedArea (GLib.GType gtype, GetAlignedAreaNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("get_aligned_area"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void GetAlignedAreaNativeDelegate (IntPtr inst, IntPtr widget, int flags, IntPtr cell_area, IntPtr aligned_area);

		static void GetAlignedArea_cb (IntPtr inst, IntPtr widget, int flags, IntPtr cell_area, IntPtr aligned_area)
		{
			try {
				CellRenderer __obj = GLib.Object.GetObject (inst, false) as CellRenderer;
				__obj.OnGetAlignedArea (GLib.Object.GetObject(widget) as Gtk.Widget, (Gtk.CellRendererState) flags, (Gdk.Rectangle) Marshal.PtrToStructure (cell_area, typeof (Gdk.Rectangle)), (Gdk.Rectangle) Marshal.PtrToStructure (aligned_area, typeof (Gdk.Rectangle)));
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.CellRenderer), ConnectionMethod="OverrideGetAlignedArea")]
		protected virtual void OnGetAlignedArea (Gtk.Widget widget, Gtk.CellRendererState flags, Gdk.Rectangle cell_area, Gdk.Rectangle aligned_area)
		{
			InternalGetAlignedArea (widget, flags, cell_area, aligned_area);
		}

		private void InternalGetAlignedArea (Gtk.Widget widget, Gtk.CellRendererState flags, Gdk.Rectangle cell_area, Gdk.Rectangle aligned_area)
		{
			GetAlignedAreaNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("get_aligned_area"));
				unmanaged = (GetAlignedAreaNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(GetAlignedAreaNativeDelegate));
			}
			if (unmanaged == null) return;

			IntPtr native_cell_area = GLib.Marshaller.StructureToPtrAlloc (cell_area);
			IntPtr native_aligned_area = GLib.Marshaller.StructureToPtrAlloc (aligned_area);
			unmanaged (this.Handle, widget == null ? IntPtr.Zero : widget.Handle, (int) flags, native_cell_area, native_aligned_area);
			Marshal.FreeHGlobal (native_cell_area);
			Marshal.FreeHGlobal (native_aligned_area);
		}

		static RenderNativeDelegate Render_cb_delegate;
		static RenderNativeDelegate RenderVMCallback {
			get {
				if (Render_cb_delegate == null)
					Render_cb_delegate = new RenderNativeDelegate (Render_cb);
				return Render_cb_delegate;
			}
		}

		static void OverrideRender (GLib.GType gtype)
		{
			OverrideRender (gtype, RenderVMCallback);
		}

		static void OverrideRender (GLib.GType gtype, RenderNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("render"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void RenderNativeDelegate (IntPtr inst, IntPtr cr, IntPtr widget, IntPtr background_area, IntPtr cell_area, int flags);

		static void Render_cb (IntPtr inst, IntPtr cr, IntPtr widget, IntPtr background_area, IntPtr cell_area, int flags)
		{
			Cairo.Context mycr = null;

			try {
				CellRenderer __obj = GLib.Object.GetObject (inst, false) as CellRenderer;
				mycr = new Cairo.Context (cr, false);
				__obj.OnRender (mycr, GLib.Object.GetObject(widget) as Gtk.Widget, (Gdk.Rectangle) Marshal.PtrToStructure (background_area, typeof (Gdk.Rectangle)), (Gdk.Rectangle) Marshal.PtrToStructure (cell_area, typeof (Gdk.Rectangle)), (Gtk.CellRendererState) flags);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			} finally {
				var disposable_cr = mycr as IDisposable;
				if (disposable_cr != null)
					disposable_cr.Dispose ();
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.CellRenderer), ConnectionMethod="OverrideRender")]
		protected virtual void OnRender (Cairo.Context cr, Gtk.Widget widget, Gdk.Rectangle background_area, Gdk.Rectangle cell_area, Gtk.CellRendererState flags)
		{
			InternalRender (cr, widget, background_area, cell_area, flags);
		}

		private void InternalRender (Cairo.Context cr, Gtk.Widget widget, Gdk.Rectangle background_area, Gdk.Rectangle cell_area, Gtk.CellRendererState flags)
		{
			RenderNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("render"));
				unmanaged = (RenderNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(RenderNativeDelegate));
			}
			if (unmanaged == null) return;

			IntPtr native_background_area = GLib.Marshaller.StructureToPtrAlloc (background_area);
			IntPtr native_cell_area = GLib.Marshaller.StructureToPtrAlloc (cell_area);
			unmanaged (this.Handle, cr == null ? IntPtr.Zero : cr.Handle, widget == null ? IntPtr.Zero : widget.Handle, native_background_area, native_cell_area, (int) flags);
			Marshal.FreeHGlobal (native_background_area);
			Marshal.FreeHGlobal (native_cell_area);
		}

		static ActivateNativeDelegate Activate_cb_delegate;
		static ActivateNativeDelegate ActivateVMCallback {
			get {
				if (Activate_cb_delegate == null)
					Activate_cb_delegate = new ActivateNativeDelegate (Activate_cb);
				return Activate_cb_delegate;
			}
		}

		static void OverrideActivate (GLib.GType gtype)
		{
			OverrideActivate (gtype, ActivateVMCallback);
		}

		static void OverrideActivate (GLib.GType gtype, ActivateNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("activate"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate bool ActivateNativeDelegate (IntPtr inst, IntPtr evnt, IntPtr widget, IntPtr path, IntPtr background_area, IntPtr cell_area, int flags);

		static bool Activate_cb (IntPtr inst, IntPtr evnt, IntPtr widget, IntPtr path, IntPtr background_area, IntPtr cell_area, int flags)
		{
			try {
				CellRenderer __obj = GLib.Object.GetObject (inst, false) as CellRenderer;
				bool __result;
				__result = __obj.OnActivate (Gdk.Event.GetEvent (evnt), GLib.Object.GetObject(widget) as Gtk.Widget, GLib.Marshaller.Utf8PtrToString (path), (Gdk.Rectangle) Marshal.PtrToStructure (background_area, typeof (Gdk.Rectangle)), (Gdk.Rectangle) Marshal.PtrToStructure (cell_area, typeof (Gdk.Rectangle)), (Gtk.CellRendererState) flags);
				return __result;
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.CellRenderer), ConnectionMethod="OverrideActivate")]
		protected virtual bool OnActivate (Gdk.Event evnt, Gtk.Widget widget, string path, Gdk.Rectangle background_area, Gdk.Rectangle cell_area, Gtk.CellRendererState flags)
		{
			return InternalActivate (evnt, widget, path, background_area, cell_area, flags);
		}

		private bool InternalActivate (Gdk.Event evnt, Gtk.Widget widget, string path, Gdk.Rectangle background_area, Gdk.Rectangle cell_area, Gtk.CellRendererState flags)
		{
			ActivateNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("activate"));
				unmanaged = (ActivateNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(ActivateNativeDelegate));
			}
			if (unmanaged == null) return false;

			IntPtr native_path = GLib.Marshaller.StringToPtrGStrdup (path);
			IntPtr native_background_area = GLib.Marshaller.StructureToPtrAlloc (background_area);
			IntPtr native_cell_area = GLib.Marshaller.StructureToPtrAlloc (cell_area);
			bool __result = unmanaged (this.Handle, evnt == null ? IntPtr.Zero : evnt.Handle, widget == null ? IntPtr.Zero : widget.Handle, native_path, native_background_area, native_cell_area, (int) flags);
			GLib.Marshaller.Free (native_path);
			Marshal.FreeHGlobal (native_background_area);
			Marshal.FreeHGlobal (native_cell_area);
			return __result;
		}

		static StartEditingNativeDelegate StartEditing_cb_delegate;
		static StartEditingNativeDelegate StartEditingVMCallback {
			get {
				if (StartEditing_cb_delegate == null)
					StartEditing_cb_delegate = new StartEditingNativeDelegate (StartEditing_cb);
				return StartEditing_cb_delegate;
			}
		}

		static void OverrideStartEditing (GLib.GType gtype)
		{
			OverrideStartEditing (gtype, StartEditingVMCallback);
		}

		static void OverrideStartEditing (GLib.GType gtype, StartEditingNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("start_editing"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate IntPtr StartEditingNativeDelegate (IntPtr inst, IntPtr evnt, IntPtr widget, IntPtr path, IntPtr background_area, IntPtr cell_area, int flags);

		static IntPtr StartEditing_cb (IntPtr inst, IntPtr evnt, IntPtr widget, IntPtr path, IntPtr background_area, IntPtr cell_area, int flags)
		{
			try {
				CellRenderer __obj = GLib.Object.GetObject (inst, false) as CellRenderer;
				Gtk.ICellEditable __result;
				__result = __obj.OnStartEditing (Gdk.Event.GetEvent (evnt), GLib.Object.GetObject(widget) as Gtk.Widget, GLib.Marshaller.Utf8PtrToString (path), (Gdk.Rectangle) Marshal.PtrToStructure (background_area, typeof (Gdk.Rectangle)), (Gdk.Rectangle) Marshal.PtrToStructure (cell_area, typeof (Gdk.Rectangle)), (Gtk.CellRendererState) flags);
				return __result == null ? IntPtr.Zero : ((__result is GLib.Object) ? (__result as GLib.Object).Handle : (__result as Gtk.CellEditableAdapter).Handle);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.CellRenderer), ConnectionMethod="OverrideStartEditing")]
		protected virtual Gtk.ICellEditable OnStartEditing (Gdk.Event evnt, Gtk.Widget widget, string path, Gdk.Rectangle background_area, Gdk.Rectangle cell_area, Gtk.CellRendererState flags)
		{
			return InternalStartEditing (evnt, widget, path, background_area, cell_area, flags);
		}

		private Gtk.ICellEditable InternalStartEditing (Gdk.Event evnt, Gtk.Widget widget, string path, Gdk.Rectangle background_area, Gdk.Rectangle cell_area, Gtk.CellRendererState flags)
		{
			StartEditingNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("start_editing"));
				unmanaged = (StartEditingNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(StartEditingNativeDelegate));
			}
			if (unmanaged == null) return null;

			IntPtr native_path = GLib.Marshaller.StringToPtrGStrdup (path);
			IntPtr native_background_area = GLib.Marshaller.StructureToPtrAlloc (background_area);
			IntPtr native_cell_area = GLib.Marshaller.StructureToPtrAlloc (cell_area);
			IntPtr __result = unmanaged (this.Handle, evnt == null ? IntPtr.Zero : evnt.Handle, widget == null ? IntPtr.Zero : widget.Handle, native_path, native_background_area, native_cell_area, (int) flags);
			GLib.Marshaller.Free (native_path);
			Marshal.FreeHGlobal (native_background_area);
			Marshal.FreeHGlobal (native_cell_area);
			return Gtk.CellEditableAdapter.GetObject (__result, false);
		}

		static EditingCanceledNativeDelegate EditingCanceled_cb_delegate;
		static EditingCanceledNativeDelegate EditingCanceledVMCallback {
			get {
				if (EditingCanceled_cb_delegate == null)
					EditingCanceled_cb_delegate = new EditingCanceledNativeDelegate (EditingCanceled_cb);
				return EditingCanceled_cb_delegate;
			}
		}

		static void OverrideEditingCanceled (GLib.GType gtype)
		{
			OverrideEditingCanceled (gtype, EditingCanceledVMCallback);
		}

		static void OverrideEditingCanceled (GLib.GType gtype, EditingCanceledNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("editing_canceled"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void EditingCanceledNativeDelegate (IntPtr inst);

		static void EditingCanceled_cb (IntPtr inst)
		{
			try {
				CellRenderer __obj = GLib.Object.GetObject (inst, false) as CellRenderer;
				__obj.OnEditingCanceled ();
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.CellRenderer), ConnectionMethod="OverrideEditingCanceled")]
		protected virtual void OnEditingCanceled ()
		{
			InternalEditingCanceled ();
		}

		private void InternalEditingCanceled ()
		{
			EditingCanceledNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("editing_canceled"));
				unmanaged = (EditingCanceledNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(EditingCanceledNativeDelegate));
			}
			if (unmanaged == null) return;

			unmanaged (this.Handle);
		}

		static EditingStartedNativeDelegate EditingStarted_cb_delegate;
		static EditingStartedNativeDelegate EditingStartedVMCallback {
			get {
				if (EditingStarted_cb_delegate == null)
					EditingStarted_cb_delegate = new EditingStartedNativeDelegate (EditingStarted_cb);
				return EditingStarted_cb_delegate;
			}
		}

		static void OverrideEditingStarted (GLib.GType gtype)
		{
			OverrideEditingStarted (gtype, EditingStartedVMCallback);
		}

		static void OverrideEditingStarted (GLib.GType gtype, EditingStartedNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("editing_started"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void EditingStartedNativeDelegate (IntPtr inst, IntPtr editable, IntPtr path);

		static void EditingStarted_cb (IntPtr inst, IntPtr editable, IntPtr path)
		{
			try {
				CellRenderer __obj = GLib.Object.GetObject (inst, false) as CellRenderer;
				__obj.OnEditingStarted (Gtk.CellEditableAdapter.GetObject (editable, false), GLib.Marshaller.Utf8PtrToString (path));
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gtk.CellRenderer), ConnectionMethod="OverrideEditingStarted")]
		protected virtual void OnEditingStarted (Gtk.ICellEditable editable, string path)
		{
			InternalEditingStarted (editable, path);
		}

		private void InternalEditingStarted (Gtk.ICellEditable editable, string path)
		{
			EditingStartedNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("editing_started"));
				unmanaged = (EditingStartedNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(EditingStartedNativeDelegate));
			}
			if (unmanaged == null) return;

			IntPtr native_path = GLib.Marshaller.StringToPtrGStrdup (path);
			unmanaged (this.Handle, editable == null ? IntPtr.Zero : ((editable is GLib.Object) ? (editable as GLib.Object).Handle : (editable as Gtk.CellEditableAdapter).Handle), native_path);
			GLib.Marshaller.Free (native_path);
		}


		// Internal representation of the wrapped structure ABI.
		static GLib.AbiStruct _class_abi = null;
		static public new GLib.AbiStruct class_abi {
			get {
				if (_class_abi == null)
					_class_abi = new GLib.AbiStruct (new List<GLib.AbiField>{ 
						new GLib.AbiField("get_request_mode"
							, GLib.Object.class_abi.Fields
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // get_request_mode
							, null
							, "get_preferred_width"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("get_preferred_width"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // get_preferred_width
							, "get_request_mode"
							, "get_preferred_height_for_width"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("get_preferred_height_for_width"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // get_preferred_height_for_width
							, "get_preferred_width"
							, "get_preferred_height"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("get_preferred_height"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // get_preferred_height
							, "get_preferred_height_for_width"
							, "get_preferred_width_for_height"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("get_preferred_width_for_height"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // get_preferred_width_for_height
							, "get_preferred_height"
							, "get_aligned_area"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("get_aligned_area"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // get_aligned_area
							, "get_preferred_width_for_height"
							, "get_size"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("get_size"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // get_size
							, "get_aligned_area"
							, "render"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("render"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // render
							, "get_size"
							, "activate"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("activate"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // activate
							, "render"
							, "start_editing"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("start_editing"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // start_editing
							, "activate"
							, "editing_canceled"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("editing_canceled"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // editing_canceled
							, "start_editing"
							, "editing_started"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("editing_started"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // editing_started
							, "editing_canceled"
							, "priv"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("priv"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // priv
							, "editing_started"
							, "_gtk_reserved2"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("_gtk_reserved2"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // _gtk_reserved2
							, "priv"
							, "_gtk_reserved3"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("_gtk_reserved3"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // _gtk_reserved3
							, "_gtk_reserved2"
							, "_gtk_reserved4"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("_gtk_reserved4"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // _gtk_reserved4
							, "_gtk_reserved3"
							, null
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
					});

				return _class_abi;
			}
		}


		// End of the ABI representation.

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_cell_renderer_activate(IntPtr raw, IntPtr evnt, IntPtr widget, IntPtr path, IntPtr background_area, IntPtr cell_area, int flags);

		public bool Activate(Gdk.Event evnt, Gtk.Widget widget, string path, Gdk.Rectangle background_area, Gdk.Rectangle cell_area, Gtk.CellRendererState flags) {
			IntPtr native_path = GLib.Marshaller.StringToPtrGStrdup (path);
			IntPtr native_background_area = GLib.Marshaller.StructureToPtrAlloc (background_area);
			IntPtr native_cell_area = GLib.Marshaller.StructureToPtrAlloc (cell_area);
			bool raw_ret = gtk_cell_renderer_activate(Handle, evnt == null ? IntPtr.Zero : evnt.Handle, widget == null ? IntPtr.Zero : widget.Handle, native_path, native_background_area, native_cell_area, (int) flags);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_path);
			Marshal.FreeHGlobal (native_background_area);
			Marshal.FreeHGlobal (native_cell_area);
			return ret;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_cell_renderer_get_aligned_area(IntPtr raw, IntPtr widget, int flags, IntPtr cell_area, IntPtr aligned_area);

		public void GetAlignedArea(Gtk.Widget widget, Gtk.CellRendererState flags, Gdk.Rectangle cell_area, Gdk.Rectangle aligned_area) {
			IntPtr native_cell_area = GLib.Marshaller.StructureToPtrAlloc (cell_area);
			IntPtr native_aligned_area = GLib.Marshaller.StructureToPtrAlloc (aligned_area);
			gtk_cell_renderer_get_aligned_area(Handle, widget == null ? IntPtr.Zero : widget.Handle, (int) flags, native_cell_area, native_aligned_area);
			Marshal.FreeHGlobal (native_cell_area);
			Marshal.FreeHGlobal (native_aligned_area);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_cell_renderer_get_alignment(IntPtr raw, out float xalign, out float yalign);

		public void GetAlignment(out float xalign, out float yalign) {
			gtk_cell_renderer_get_alignment(Handle, out xalign, out yalign);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_cell_renderer_get_fixed_size(IntPtr raw, out int width, out int height);

		public void GetFixedSize(out int width, out int height) {
			gtk_cell_renderer_get_fixed_size(Handle, out width, out height);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_cell_renderer_get_padding(IntPtr raw, out int xpad, out int ypad);

		public void GetPadding(out int xpad, out int ypad) {
			gtk_cell_renderer_get_padding(Handle, out xpad, out ypad);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_cell_renderer_get_preferred_height(IntPtr raw, IntPtr widget, out int minimum_size, out int natural_size);

		public void GetPreferredHeight(Gtk.Widget widget, out int minimum_size, out int natural_size) {
			gtk_cell_renderer_get_preferred_height(Handle, widget == null ? IntPtr.Zero : widget.Handle, out minimum_size, out natural_size);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_cell_renderer_get_preferred_height_for_width(IntPtr raw, IntPtr widget, int width, out int minimum_height, out int natural_height);

		public void GetPreferredHeightForWidth(Gtk.Widget widget, int width, out int minimum_height, out int natural_height) {
			gtk_cell_renderer_get_preferred_height_for_width(Handle, widget == null ? IntPtr.Zero : widget.Handle, width, out minimum_height, out natural_height);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_cell_renderer_get_preferred_size(IntPtr raw, IntPtr widget, IntPtr minimum_size, IntPtr natural_size);

		public void GetPreferredSize(Gtk.Widget widget, Gtk.Requisition minimum_size, Gtk.Requisition natural_size) {
			IntPtr native_minimum_size = GLib.Marshaller.StructureToPtrAlloc (minimum_size);
			IntPtr native_natural_size = GLib.Marshaller.StructureToPtrAlloc (natural_size);
			gtk_cell_renderer_get_preferred_size(Handle, widget == null ? IntPtr.Zero : widget.Handle, native_minimum_size, native_natural_size);
			Marshal.FreeHGlobal (native_minimum_size);
			Marshal.FreeHGlobal (native_natural_size);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_cell_renderer_get_preferred_width(IntPtr raw, IntPtr widget, out int minimum_size, out int natural_size);

		public void GetPreferredWidth(Gtk.Widget widget, out int minimum_size, out int natural_size) {
			gtk_cell_renderer_get_preferred_width(Handle, widget == null ? IntPtr.Zero : widget.Handle, out minimum_size, out natural_size);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_cell_renderer_get_preferred_width_for_height(IntPtr raw, IntPtr widget, int height, out int minimum_width, out int natural_width);

		public void GetPreferredWidthForHeight(Gtk.Widget widget, int height, out int minimum_width, out int natural_width) {
			gtk_cell_renderer_get_preferred_width_for_height(Handle, widget == null ? IntPtr.Zero : widget.Handle, height, out minimum_width, out natural_width);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gtk_cell_renderer_get_request_mode(IntPtr raw);

		public Gtk.SizeRequestMode RequestMode { 
			get {
				int raw_ret = gtk_cell_renderer_get_request_mode(Handle);
				Gtk.SizeRequestMode ret = (Gtk.SizeRequestMode) raw_ret;
				return ret;
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gtk_cell_renderer_get_state(IntPtr raw, IntPtr widget, int cell_state);

		public Gtk.StateFlags GetState(Gtk.Widget widget, Gtk.CellRendererState cell_state) {
			int raw_ret = gtk_cell_renderer_get_state(Handle, widget == null ? IntPtr.Zero : widget.Handle, (int) cell_state);
			Gtk.StateFlags ret = (Gtk.StateFlags) raw_ret;
			return ret;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_cell_renderer_get_type();

		public static new GLib.GType GType { 
			get {
				IntPtr raw_ret = gtk_cell_renderer_get_type();
				GLib.GType ret = new GLib.GType(raw_ret);
				return ret;
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_cell_renderer_is_activatable(IntPtr raw);

		public bool IsActivatable { 
			get {
				bool raw_ret = gtk_cell_renderer_is_activatable(Handle);
				bool ret = raw_ret;
				return ret;
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_cell_renderer_render(IntPtr raw, IntPtr cr, IntPtr widget, IntPtr background_area, IntPtr cell_area, int flags);

		public void Render(Cairo.Context cr, Gtk.Widget widget, Gdk.Rectangle background_area, Gdk.Rectangle cell_area, Gtk.CellRendererState flags) {
			IntPtr native_background_area = GLib.Marshaller.StructureToPtrAlloc (background_area);
			IntPtr native_cell_area = GLib.Marshaller.StructureToPtrAlloc (cell_area);
			gtk_cell_renderer_render(Handle, cr == null ? IntPtr.Zero : cr.Handle, widget == null ? IntPtr.Zero : widget.Handle, native_background_area, native_cell_area, (int) flags);
			Marshal.FreeHGlobal (native_background_area);
			Marshal.FreeHGlobal (native_cell_area);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_cell_renderer_set_alignment(IntPtr raw, float xalign, float yalign);

		public void SetAlignment(float xalign, float yalign) {
			gtk_cell_renderer_set_alignment(Handle, xalign, yalign);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_cell_renderer_set_fixed_size(IntPtr raw, int width, int height);

		public void SetFixedSize(int width, int height) {
			gtk_cell_renderer_set_fixed_size(Handle, width, height);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_cell_renderer_set_padding(IntPtr raw, int xpad, int ypad);

		public void SetPadding(int xpad, int ypad) {
			gtk_cell_renderer_set_padding(Handle, xpad, ypad);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_cell_renderer_stop_editing(IntPtr raw, bool canceled);

		public void StopEditing(bool canceled) {
			gtk_cell_renderer_stop_editing(Handle, canceled);
		}


		// Internal representation of the wrapped structure ABI.
		static GLib.AbiStruct _abi_info = null;
		static public new GLib.AbiStruct abi_info {
			get {
				if (_abi_info == null)
					_abi_info = new GLib.AbiStruct (new List<GLib.AbiField>{ 
						new GLib.AbiField("priv"
							, GLib.Object.abi_info.Fields
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // priv
							, null
							, null
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
					});

				return _abi_info;
			}
		}


		// End of the ABI representation.

#endregion
	}
}
