// This file was generated by the Gtk# code generator.
// Any changes made will be lost if regenerated.

namespace Gdk {

	using System;
	using System.Collections;
	using System.Collections.Generic;
	using System.Runtime.InteropServices;

#region Autogenerated code
	public partial class Window : GLib.Object {

		public Window (IntPtr raw) : base(raw) {}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_window_new(IntPtr parent, IntPtr attributes, int attributes_mask);

		public Window (Gdk.Window parent, Gdk.WindowAttr attributes, int attributes_mask) : base (IntPtr.Zero)
		{
			if (GetType () != typeof (Window)) {
				var vals = new List<GLib.Value> ();
				var names = new List<string> ();
				CreateNativeObject (names.ToArray (), vals.ToArray ());
				return;
			}
			IntPtr native_attributes = GLib.Marshaller.StructureToPtrAlloc (attributes);
			Raw = gdk_window_new(parent == null ? IntPtr.Zero : parent.Handle, native_attributes, attributes_mask);
			Marshal.FreeHGlobal (native_attributes);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_window_get_cursor(IntPtr raw);

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_cursor(IntPtr raw, IntPtr cursor);

		[GLib.Property ("cursor")]
		public Gdk.Cursor Cursor {
			get  {
				IntPtr raw_ret = gdk_window_get_cursor(Handle);
				Gdk.Cursor ret = GLib.Object.GetObject(raw_ret) as Gdk.Cursor;
				return ret;
			}
			set  {
				gdk_window_set_cursor(Handle, value == null ? IntPtr.Zero : value.Handle);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void ToEmbedderSignalDelegate (IntPtr inst, double arg0, double arg1, out double arg2, out double arg3, IntPtr gch);

		static void ToEmbedderSignalCallback (IntPtr inst, double arg0, double arg1, out double arg2, out double arg3, IntPtr gch)
		{
			Gdk.ToEmbedderArgs args = new Gdk.ToEmbedderArgs ();
			try {
				GLib.Signal sig = ((GCHandle) gch).Target as GLib.Signal;
				if (sig == null)
					throw new Exception("Unknown signal GC handle received " + gch);

				args.Args = new object[4];
				args.Args[0] = arg0;
				args.Args[1] = arg1;
				Gdk.ToEmbedderHandler handler = (Gdk.ToEmbedderHandler) sig.Handler;
				handler (GLib.Object.GetObject (inst), args);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}

			try {
				arg2 = ((double)args.Args[2]);
				arg3 = ((double)args.Args[3]);
			} catch (Exception) {
				Exception ex = new Exception ("args.RetVal or 'out' property unset or set to incorrect type in Gdk.ToEmbedderHandler callback");
				GLib.ExceptionManager.RaiseUnhandledException (ex, true);
				// NOTREACHED: above call doesn't return.
				throw ex;
			}
		}

		[GLib.Signal("to-embedder")]
		public event Gdk.ToEmbedderHandler ToEmbedder {
			add {
				this.AddSignalHandler ("to-embedder", value, new ToEmbedderSignalDelegate(ToEmbedderSignalCallback));
			}
			remove {
				this.RemoveSignalHandler ("to-embedder", value);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void MovedToRectSignalDelegate (IntPtr inst, IntPtr arg0, IntPtr arg1, bool arg2, bool arg3, IntPtr gch);

		static void MovedToRectSignalCallback (IntPtr inst, IntPtr arg0, IntPtr arg1, bool arg2, bool arg3, IntPtr gch)
		{
			Gdk.MovedToRectArgs args = new Gdk.MovedToRectArgs ();
			try {
				GLib.Signal sig = ((GCHandle) gch).Target as GLib.Signal;
				if (sig == null)
					throw new Exception("Unknown signal GC handle received " + gch);

				args.Args = new object[4];
				args.Args[0] = arg0;
				args.Args[1] = arg1;
				args.Args[2] = arg2;
				args.Args[3] = arg3;
				Gdk.MovedToRectHandler handler = (Gdk.MovedToRectHandler) sig.Handler;
				handler (GLib.Object.GetObject (inst), args);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.Signal("moved-to-rect")]
		public event Gdk.MovedToRectHandler MovedToRect {
			add {
				this.AddSignalHandler ("moved-to-rect", value, new MovedToRectSignalDelegate(MovedToRectSignalCallback));
			}
			remove {
				this.RemoveSignalHandler ("moved-to-rect", value);
			}
		}

		[GLib.Signal("pick-embedded-child")]
		public event Gdk.PickEmbeddedChildHandler PickEmbeddedChild {
			add {
				this.AddSignalHandler ("pick-embedded-child", value, typeof (Gdk.PickEmbeddedChildArgs));
			}
			remove {
				this.RemoveSignalHandler ("pick-embedded-child", value);
			}
		}

		[GLib.Signal("create-surface")]
		public event Gdk.CreateSurfaceHandler CreateSurface {
			add {
				this.AddSignalHandler ("create-surface", value, typeof (Gdk.CreateSurfaceArgs));
			}
			remove {
				this.RemoveSignalHandler ("create-surface", value);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void FromEmbedderSignalDelegate (IntPtr inst, double arg0, double arg1, out double arg2, out double arg3, IntPtr gch);

		static void FromEmbedderSignalCallback (IntPtr inst, double arg0, double arg1, out double arg2, out double arg3, IntPtr gch)
		{
			Gdk.FromEmbedderArgs args = new Gdk.FromEmbedderArgs ();
			try {
				GLib.Signal sig = ((GCHandle) gch).Target as GLib.Signal;
				if (sig == null)
					throw new Exception("Unknown signal GC handle received " + gch);

				args.Args = new object[4];
				args.Args[0] = arg0;
				args.Args[1] = arg1;
				Gdk.FromEmbedderHandler handler = (Gdk.FromEmbedderHandler) sig.Handler;
				handler (GLib.Object.GetObject (inst), args);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}

			try {
				arg2 = ((double)args.Args[2]);
				arg3 = ((double)args.Args[3]);
			} catch (Exception) {
				Exception ex = new Exception ("args.RetVal or 'out' property unset or set to incorrect type in Gdk.FromEmbedderHandler callback");
				GLib.ExceptionManager.RaiseUnhandledException (ex, true);
				// NOTREACHED: above call doesn't return.
				throw ex;
			}
		}

		[GLib.Signal("from-embedder")]
		public event Gdk.FromEmbedderHandler FromEmbedder {
			add {
				this.AddSignalHandler ("from-embedder", value, new FromEmbedderSignalDelegate(FromEmbedderSignalCallback));
			}
			remove {
				this.RemoveSignalHandler ("from-embedder", value);
			}
		}

		static MovedToRectNativeDelegate MovedToRect_cb_delegate;
		static MovedToRectNativeDelegate MovedToRectVMCallback {
			get {
				if (MovedToRect_cb_delegate == null)
					MovedToRect_cb_delegate = new MovedToRectNativeDelegate (MovedToRect_cb);
				return MovedToRect_cb_delegate;
			}
		}

		static void OverrideMovedToRect (GLib.GType gtype)
		{
			OverrideMovedToRect (gtype, MovedToRectVMCallback);
		}

		static void OverrideMovedToRect (GLib.GType gtype, MovedToRectNativeDelegate callback)
		{
			OverrideVirtualMethod (gtype, "moved-to-rect", callback);
		}
		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void MovedToRectNativeDelegate (IntPtr inst, IntPtr p0, IntPtr p1, bool p2, bool p3);

		static void MovedToRect_cb (IntPtr inst, IntPtr p0, IntPtr p1, bool p2, bool p3)
		{
			try {
				Window __obj = GLib.Object.GetObject (inst, false) as Window;
				__obj.OnMovedToRect (p0, p1, p2, p3);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gdk.Window), ConnectionMethod="OverrideMovedToRect")]
		protected virtual void OnMovedToRect (IntPtr p0, IntPtr p1, bool p2, bool p3)
		{
			InternalMovedToRect (p0, p1, p2, p3);
		}

		private void InternalMovedToRect (IntPtr p0, IntPtr p1, bool p2, bool p3)
		{
			GLib.Value ret = GLib.Value.Empty;
			GLib.ValueArray inst_and_params = new GLib.ValueArray (5);
			GLib.Value[] vals = new GLib.Value [5];
			vals [0] = new GLib.Value (this);
			inst_and_params.Append (vals [0]);
			vals [1] = new GLib.Value (p0);
			inst_and_params.Append (vals [1]);
			vals [2] = new GLib.Value (p1);
			inst_and_params.Append (vals [2]);
			vals [3] = new GLib.Value (p2);
			inst_and_params.Append (vals [3]);
			vals [4] = new GLib.Value (p3);
			inst_and_params.Append (vals [4]);
			g_signal_chain_from_overridden (inst_and_params.ArrayPtr, ref ret);
			foreach (GLib.Value v in vals)
				v.Dispose ();
		}

		static PickEmbeddedChildNativeDelegate PickEmbeddedChild_cb_delegate;
		static PickEmbeddedChildNativeDelegate PickEmbeddedChildVMCallback {
			get {
				if (PickEmbeddedChild_cb_delegate == null)
					PickEmbeddedChild_cb_delegate = new PickEmbeddedChildNativeDelegate (PickEmbeddedChild_cb);
				return PickEmbeddedChild_cb_delegate;
			}
		}

		static void OverridePickEmbeddedChild (GLib.GType gtype)
		{
			OverridePickEmbeddedChild (gtype, PickEmbeddedChildVMCallback);
		}

		static void OverridePickEmbeddedChild (GLib.GType gtype, PickEmbeddedChildNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("pick_embedded_child"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate IntPtr PickEmbeddedChildNativeDelegate (IntPtr inst, double x, double y);

		static IntPtr PickEmbeddedChild_cb (IntPtr inst, double x, double y)
		{
			try {
				Window __obj = GLib.Object.GetObject (inst, false) as Window;
				Gdk.Window __result;
				__result = __obj.OnPickEmbeddedChild (x, y);
				return __result == null ? IntPtr.Zero : __result.Handle;
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gdk.Window), ConnectionMethod="OverridePickEmbeddedChild")]
		protected virtual Gdk.Window OnPickEmbeddedChild (double x, double y)
		{
			return InternalPickEmbeddedChild (x, y);
		}

		private Gdk.Window InternalPickEmbeddedChild (double x, double y)
		{
			PickEmbeddedChildNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("pick_embedded_child"));
				unmanaged = (PickEmbeddedChildNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(PickEmbeddedChildNativeDelegate));
			}
			if (unmanaged == null) return null;

			IntPtr __result = unmanaged (this.Handle, x, y);
			return GLib.Object.GetObject(__result) as Gdk.Window;
		}

		static ToEmbedderNativeDelegate ToEmbedder_cb_delegate;
		static ToEmbedderNativeDelegate ToEmbedderVMCallback {
			get {
				if (ToEmbedder_cb_delegate == null)
					ToEmbedder_cb_delegate = new ToEmbedderNativeDelegate (ToEmbedder_cb);
				return ToEmbedder_cb_delegate;
			}
		}

		static void OverrideToEmbedder (GLib.GType gtype)
		{
			OverrideToEmbedder (gtype, ToEmbedderVMCallback);
		}

		static void OverrideToEmbedder (GLib.GType gtype, ToEmbedderNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("to_embedder"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void ToEmbedderNativeDelegate (IntPtr inst, double offscreen_x, double offscreen_y, out double embedder_x, out double embedder_y);

		static void ToEmbedder_cb (IntPtr inst, double offscreen_x, double offscreen_y, out double embedder_x, out double embedder_y)
		{
			try {
				Window __obj = GLib.Object.GetObject (inst, false) as Window;
				__obj.OnToEmbedder (offscreen_x, offscreen_y, out embedder_x, out embedder_y);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gdk.Window), ConnectionMethod="OverrideToEmbedder")]
		protected virtual void OnToEmbedder (double offscreen_x, double offscreen_y, out double embedder_x, out double embedder_y)
		{
			InternalToEmbedder (offscreen_x, offscreen_y, out embedder_x, out embedder_y);
		}

		private void InternalToEmbedder (double offscreen_x, double offscreen_y, out double embedder_x, out double embedder_y)
		{
			ToEmbedderNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("to_embedder"));
				unmanaged = (ToEmbedderNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(ToEmbedderNativeDelegate));
			}
			if (unmanaged == null) throw new InvalidOperationException ("No base method to invoke");

			unmanaged (this.Handle, offscreen_x, offscreen_y, out embedder_x, out embedder_y);
		}

		static FromEmbedderNativeDelegate FromEmbedder_cb_delegate;
		static FromEmbedderNativeDelegate FromEmbedderVMCallback {
			get {
				if (FromEmbedder_cb_delegate == null)
					FromEmbedder_cb_delegate = new FromEmbedderNativeDelegate (FromEmbedder_cb);
				return FromEmbedder_cb_delegate;
			}
		}

		static void OverrideFromEmbedder (GLib.GType gtype)
		{
			OverrideFromEmbedder (gtype, FromEmbedderVMCallback);
		}

		static void OverrideFromEmbedder (GLib.GType gtype, FromEmbedderNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("from_embedder"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void FromEmbedderNativeDelegate (IntPtr inst, double embedder_x, double embedder_y, out double offscreen_x, out double offscreen_y);

		static void FromEmbedder_cb (IntPtr inst, double embedder_x, double embedder_y, out double offscreen_x, out double offscreen_y)
		{
			try {
				Window __obj = GLib.Object.GetObject (inst, false) as Window;
				__obj.OnFromEmbedder (embedder_x, embedder_y, out offscreen_x, out offscreen_y);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gdk.Window), ConnectionMethod="OverrideFromEmbedder")]
		protected virtual void OnFromEmbedder (double embedder_x, double embedder_y, out double offscreen_x, out double offscreen_y)
		{
			InternalFromEmbedder (embedder_x, embedder_y, out offscreen_x, out offscreen_y);
		}

		private void InternalFromEmbedder (double embedder_x, double embedder_y, out double offscreen_x, out double offscreen_y)
		{
			FromEmbedderNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("from_embedder"));
				unmanaged = (FromEmbedderNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(FromEmbedderNativeDelegate));
			}
			if (unmanaged == null) throw new InvalidOperationException ("No base method to invoke");

			unmanaged (this.Handle, embedder_x, embedder_y, out offscreen_x, out offscreen_y);
		}

		static CreateSurfaceNativeDelegate CreateSurface_cb_delegate;
		static CreateSurfaceNativeDelegate CreateSurfaceVMCallback {
			get {
				if (CreateSurface_cb_delegate == null)
					CreateSurface_cb_delegate = new CreateSurfaceNativeDelegate (CreateSurface_cb);
				return CreateSurface_cb_delegate;
			}
		}

		static void OverrideCreateSurface (GLib.GType gtype)
		{
			OverrideCreateSurface (gtype, CreateSurfaceVMCallback);
		}

		static void OverrideCreateSurface (GLib.GType gtype, CreateSurfaceNativeDelegate callback)
		{
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) gtype.GetClassPtr()) + (long) class_abi.GetFieldOffset("create_surface"));
				*raw_ptr = Marshal.GetFunctionPointerForDelegate((Delegate) callback);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate IntPtr CreateSurfaceNativeDelegate (IntPtr inst, int width, int height);

		static IntPtr CreateSurface_cb (IntPtr inst, int width, int height)
		{
			try {
				Window __obj = GLib.Object.GetObject (inst, false) as Window;
				Cairo.Surface __result;
				__result = __obj.OnCreateSurface (width, height);
				return __result.Handle;
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[GLib.DefaultSignalHandler(Type=typeof(Gdk.Window), ConnectionMethod="OverrideCreateSurface")]
		protected virtual Cairo.Surface OnCreateSurface (int width, int height)
		{
			return InternalCreateSurface (width, height);
		}

		private Cairo.Surface InternalCreateSurface (int width, int height)
		{
			CreateSurfaceNativeDelegate unmanaged = null;
			unsafe {
				IntPtr* raw_ptr = (IntPtr*)(((long) this.LookupGType().GetThresholdType().GetClassPtr()) + (long) class_abi.GetFieldOffset("create_surface"));
				unmanaged = (CreateSurfaceNativeDelegate) Marshal.GetDelegateForFunctionPointer(*raw_ptr, typeof(CreateSurfaceNativeDelegate));
			}
			if (unmanaged == null) return null;

			IntPtr __result = unmanaged (this.Handle, width, height);
			return Cairo.Surface.Lookup (__result, true);
		}


		// Internal representation of the wrapped structure ABI.
		static GLib.AbiStruct _class_abi = null;
		static public new GLib.AbiStruct class_abi {
			get {
				if (_class_abi == null)
					_class_abi = new GLib.AbiStruct (new List<GLib.AbiField>{ 
						new GLib.AbiField("pick_embedded_child"
							, GLib.Object.class_abi.Fields
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // pick_embedded_child
							, null
							, "to_embedder"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("to_embedder"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // to_embedder
							, "pick_embedded_child"
							, "from_embedder"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("from_embedder"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // from_embedder
							, "to_embedder"
							, "create_surface"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("create_surface"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // create_surface
							, "from_embedder"
							, "_gdk_reserved1"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("_gdk_reserved1"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // _gdk_reserved1
							, "create_surface"
							, "_gdk_reserved2"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("_gdk_reserved2"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // _gdk_reserved2
							, "_gdk_reserved1"
							, "_gdk_reserved3"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("_gdk_reserved3"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // _gdk_reserved3
							, "_gdk_reserved2"
							, "_gdk_reserved4"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("_gdk_reserved4"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // _gdk_reserved4
							, "_gdk_reserved3"
							, "_gdk_reserved5"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("_gdk_reserved5"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // _gdk_reserved5
							, "_gdk_reserved4"
							, "_gdk_reserved6"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("_gdk_reserved6"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // _gdk_reserved6
							, "_gdk_reserved5"
							, "_gdk_reserved7"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("_gdk_reserved7"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // _gdk_reserved7
							, "_gdk_reserved6"
							, "_gdk_reserved8"
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
						new GLib.AbiField("_gdk_reserved8"
							, -1
							, (uint) Marshal.SizeOf(typeof(IntPtr)) // _gdk_reserved8
							, "_gdk_reserved7"
							, null
							, (uint) Marshal.SizeOf(typeof(IntPtr))
							, 0
							),
					});

				return _class_abi;
			}
		}


		// End of the ABI representation.

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_window_at_pointer(out int win_x, out int win_y);

		[Obsolete]
		public static Gdk.Window AtPointer(out int win_x, out int win_y) {
			IntPtr raw_ret = gdk_window_at_pointer(out win_x, out win_y);
			Gdk.Window ret = GLib.Object.GetObject(raw_ret) as Gdk.Window;
			return ret;
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_beep(IntPtr raw);

		public void Beep() {
			gdk_window_beep(Handle);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_window_begin_draw_frame(IntPtr raw, IntPtr region);

		public Gdk.DrawingContext BeginDrawFrame(Cairo.Region region) {
			IntPtr raw_ret = gdk_window_begin_draw_frame(Handle, region == null ? IntPtr.Zero : region.Handle);
			Gdk.DrawingContext ret = GLib.Object.GetObject(raw_ret) as Gdk.DrawingContext;
			return ret;
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_begin_move_drag(IntPtr raw, int button, int root_x, int root_y, uint timestamp);

		public void BeginMoveDrag(int button, int root_x, int root_y, uint timestamp) {
			gdk_window_begin_move_drag(Handle, button, root_x, root_y, timestamp);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_begin_move_drag_for_device(IntPtr raw, IntPtr device, int button, int root_x, int root_y, uint timestamp);

		public void BeginMoveDragForDevice(Gdk.Device device, int button, int root_x, int root_y, uint timestamp) {
			gdk_window_begin_move_drag_for_device(Handle, device == null ? IntPtr.Zero : device.Handle, button, root_x, root_y, timestamp);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_begin_paint_rect(IntPtr raw, IntPtr rectangle);

		[Obsolete]
		public void BeginPaintRect(Gdk.Rectangle rectangle) {
			IntPtr native_rectangle = GLib.Marshaller.StructureToPtrAlloc (rectangle);
			gdk_window_begin_paint_rect(Handle, native_rectangle);
			Marshal.FreeHGlobal (native_rectangle);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_begin_paint_region(IntPtr raw, IntPtr region);

		[Obsolete]
		public void BeginPaintRegion(Cairo.Region region) {
			gdk_window_begin_paint_region(Handle, region == null ? IntPtr.Zero : region.Handle);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_begin_resize_drag(IntPtr raw, int edge, int button, int root_x, int root_y, uint timestamp);

		public void BeginResizeDrag(Gdk.WindowEdge edge, int button, int root_x, int root_y, uint timestamp) {
			gdk_window_begin_resize_drag(Handle, (int) edge, button, root_x, root_y, timestamp);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_begin_resize_drag_for_device(IntPtr raw, int edge, IntPtr device, int button, int root_x, int root_y, uint timestamp);

		public void BeginResizeDragForDevice(Gdk.WindowEdge edge, Gdk.Device device, int button, int root_x, int root_y, uint timestamp) {
			gdk_window_begin_resize_drag_for_device(Handle, (int) edge, device == null ? IntPtr.Zero : device.Handle, button, root_x, root_y, timestamp);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_configure_finished(IntPtr raw);

		[Obsolete]
		public void ConfigureFinished() {
			gdk_window_configure_finished(Handle);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_constrain_size(IntPtr geometry, int flags, int width, int height, out int new_width, out int new_height);

		public static void ConstrainSize(Gdk.Geometry geometry, Gdk.WindowHints flags, int width, int height, out int new_width, out int new_height) {
			IntPtr native_geometry = GLib.Marshaller.StructureToPtrAlloc (geometry);
			gdk_window_constrain_size(native_geometry, (int) flags, width, height, out new_width, out new_height);
			Marshal.FreeHGlobal (native_geometry);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_coords_from_parent(IntPtr raw, double parent_x, double parent_y, out double x, out double y);

		public void CoordsFromParent(double parent_x, double parent_y, out double x, out double y) {
			gdk_window_coords_from_parent(Handle, parent_x, parent_y, out x, out y);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_coords_to_parent(IntPtr raw, double x, double y, out double parent_x, out double parent_y);

		public void CoordsToParent(double x, double y, out double parent_x, out double parent_y) {
			gdk_window_coords_to_parent(Handle, x, y, out parent_x, out parent_y);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern unsafe IntPtr gdk_window_create_gl_context(IntPtr raw, out IntPtr error);

		public unsafe Gdk.GLContext CreateGlContext() {
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = gdk_window_create_gl_context(Handle, out error);
			Gdk.GLContext ret = GLib.Object.GetObject(raw_ret) as Gdk.GLContext;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_window_create_similar_surface(IntPtr raw, int content, int width, int height);

		public Cairo.Surface CreateSimilarSurface(Cairo.Content content, int width, int height) {
			IntPtr raw_ret = gdk_window_create_similar_surface(Handle, (int) content, width, height);
			Cairo.Surface ret = Cairo.Surface.Lookup (raw_ret, true);
			return ret;
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_deiconify(IntPtr raw);

		public void Deiconify() {
			gdk_window_deiconify(Handle);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_enable_synchronized_configure(IntPtr raw);

		[Obsolete]
		public void EnableSynchronizedConfigure() {
			gdk_window_enable_synchronized_configure(Handle);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_end_draw_frame(IntPtr raw, IntPtr context);

		public void EndDrawFrame(Gdk.DrawingContext context) {
			gdk_window_end_draw_frame(Handle, context == null ? IntPtr.Zero : context.Handle);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_end_paint(IntPtr raw);

		[Obsolete]
		public void EndPaint() {
			gdk_window_end_paint(Handle);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gdk_window_ensure_native(IntPtr raw);

		public bool EnsureNative() {
			bool raw_ret = gdk_window_ensure_native(Handle);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_flush(IntPtr raw);

		[Obsolete]
		public void Flush() {
			gdk_window_flush(Handle);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_focus(IntPtr raw, uint timestamp);

		public void Focus(uint timestamp) {
			gdk_window_focus(Handle, timestamp);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_freeze_updates(IntPtr raw);

		public void FreezeUpdates() {
			gdk_window_freeze_updates(Handle);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_fullscreen(IntPtr raw);

		public void Fullscreen() {
			gdk_window_fullscreen(Handle);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_fullscreen_on_monitor(IntPtr raw, int monitor);

		public void FullscreenOnMonitor(int monitor) {
			gdk_window_fullscreen_on_monitor(Handle, monitor);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_geometry_changed(IntPtr raw);

		public void GeometryChanged() {
			gdk_window_geometry_changed(Handle);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gdk_window_get_accept_focus(IntPtr raw);

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_accept_focus(IntPtr raw, bool accept_focus);

		public bool AcceptFocus { 
			get {
				bool raw_ret = gdk_window_get_accept_focus(Handle);
				bool ret = raw_ret;
				return ret;
			}
			set {
				gdk_window_set_accept_focus(Handle, value);
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_window_get_children_with_user_data(IntPtr raw, IntPtr user_data);

		public GLib.List GetChildrenWithUserData(IntPtr user_data) {
			IntPtr raw_ret = gdk_window_get_children_with_user_data(Handle, user_data);
			GLib.List ret = new GLib.List(raw_ret);
			return ret;
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_window_get_clip_region(IntPtr raw);

		public Cairo.Region ClipRegion { 
			get {
				IntPtr raw_ret = gdk_window_get_clip_region(Handle);
				Cairo.Region ret = new Cairo.Region(raw_ret);
				return ret;
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gdk_window_get_composited(IntPtr raw);

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_composited(IntPtr raw, bool composited);

		[Obsolete]
		public bool Composited { 
			get {
				bool raw_ret = gdk_window_get_composited(Handle);
				bool ret = raw_ret;
				return ret;
			}
			set {
				gdk_window_set_composited(Handle, value);
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gdk_window_get_decorations(IntPtr raw, out int decorations);

		public bool GetDecorations(out Gdk.WMDecoration decorations) {
			int native_decorations;
			bool raw_ret = gdk_window_get_decorations(Handle, out native_decorations);
			bool ret = raw_ret;
			decorations = (Gdk.WMDecoration) native_decorations;
			return ret;
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_window_get_device_cursor(IntPtr raw, IntPtr device);

		public Gdk.Cursor GetDeviceCursor(Gdk.Device device) {
			IntPtr raw_ret = gdk_window_get_device_cursor(Handle, device == null ? IntPtr.Zero : device.Handle);
			Gdk.Cursor ret = GLib.Object.GetObject(raw_ret) as Gdk.Cursor;
			return ret;
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gdk_window_get_device_events(IntPtr raw, IntPtr device);

		public Gdk.EventMask GetDeviceEvents(Gdk.Device device) {
			int raw_ret = gdk_window_get_device_events(Handle, device == null ? IntPtr.Zero : device.Handle);
			Gdk.EventMask ret = (Gdk.EventMask) raw_ret;
			return ret;
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_window_get_device_position(IntPtr raw, IntPtr device, out int x, out int y, out int mask);

		public Gdk.Window GetDevicePosition(Gdk.Device device, out int x, out int y, out Gdk.ModifierType mask) {
			int native_mask;
			IntPtr raw_ret = gdk_window_get_device_position(Handle, device == null ? IntPtr.Zero : device.Handle, out x, out y, out native_mask);
			Gdk.Window ret = GLib.Object.GetObject(raw_ret) as Gdk.Window;
			mask = (Gdk.ModifierType) native_mask;
			return ret;
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_window_get_device_position_double(IntPtr raw, IntPtr device, out double x, out double y, out int mask);

		public Gdk.Window GetDevicePositionDouble(Gdk.Device device, out double x, out double y, out Gdk.ModifierType mask) {
			int native_mask;
			IntPtr raw_ret = gdk_window_get_device_position_double(Handle, device == null ? IntPtr.Zero : device.Handle, out x, out y, out native_mask);
			Gdk.Window ret = GLib.Object.GetObject(raw_ret) as Gdk.Window;
			mask = (Gdk.ModifierType) native_mask;
			return ret;
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_window_get_display(IntPtr raw);

		public Gdk.Display Display { 
			get {
				IntPtr raw_ret = gdk_window_get_display(Handle);
				Gdk.Display ret = GLib.Object.GetObject(raw_ret) as Gdk.Display;
				return ret;
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gdk_window_get_drag_protocol(IntPtr raw, IntPtr target);

		public Gdk.DragProtocol GetDragProtocol(Gdk.Window target) {
			int raw_ret = gdk_window_get_drag_protocol(Handle, target == null ? IntPtr.Zero : target.Handle);
			Gdk.DragProtocol ret = (Gdk.DragProtocol) raw_ret;
			return ret;
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_window_get_effective_parent(IntPtr raw);

		public Gdk.Window EffectiveParent { 
			get {
				IntPtr raw_ret = gdk_window_get_effective_parent(Handle);
				Gdk.Window ret = GLib.Object.GetObject(raw_ret) as Gdk.Window;
				return ret;
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_window_get_effective_toplevel(IntPtr raw);

		public Gdk.Window EffectiveToplevel { 
			get {
				IntPtr raw_ret = gdk_window_get_effective_toplevel(Handle);
				Gdk.Window ret = GLib.Object.GetObject(raw_ret) as Gdk.Window;
				return ret;
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gdk_window_get_event_compression(IntPtr raw);

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_event_compression(IntPtr raw, bool event_compression);

		public bool EventCompression { 
			get {
				bool raw_ret = gdk_window_get_event_compression(Handle);
				bool ret = raw_ret;
				return ret;
			}
			set {
				gdk_window_set_event_compression(Handle, value);
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gdk_window_get_events(IntPtr raw);

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_events(IntPtr raw, int event_mask);

		public Gdk.EventMask Events { 
			get {
				int raw_ret = gdk_window_get_events(Handle);
				Gdk.EventMask ret = (Gdk.EventMask) raw_ret;
				return ret;
			}
			set {
				gdk_window_set_events(Handle, (int) value);
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gdk_window_get_focus_on_map(IntPtr raw);

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_focus_on_map(IntPtr raw, bool focus_on_map);

		public bool FocusOnMap { 
			get {
				bool raw_ret = gdk_window_get_focus_on_map(Handle);
				bool ret = raw_ret;
				return ret;
			}
			set {
				gdk_window_set_focus_on_map(Handle, value);
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_window_get_frame_clock(IntPtr raw);

		public Gdk.FrameClock FrameClock { 
			get {
				IntPtr raw_ret = gdk_window_get_frame_clock(Handle);
				Gdk.FrameClock ret = GLib.Object.GetObject(raw_ret) as Gdk.FrameClock;
				return ret;
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_get_frame_extents(IntPtr raw, IntPtr rect);

		public Gdk.Rectangle FrameExtents { 
			get {
				Gdk.Rectangle rect;
				IntPtr native_rect = Marshal.AllocHGlobal (Marshal.SizeOf (typeof (Gdk.Rectangle)));
				gdk_window_get_frame_extents(Handle, native_rect);
				rect = (Gdk.Rectangle) Marshal.PtrToStructure (native_rect, typeof (Gdk.Rectangle));
				Marshal.FreeHGlobal (native_rect);
				return rect;
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gdk_window_get_fullscreen_mode(IntPtr raw);

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_fullscreen_mode(IntPtr raw, int mode);

		public Gdk.FullscreenMode FullscreenMode { 
			get {
				int raw_ret = gdk_window_get_fullscreen_mode(Handle);
				Gdk.FullscreenMode ret = (Gdk.FullscreenMode) raw_ret;
				return ret;
			}
			set {
				gdk_window_set_fullscreen_mode(Handle, (int) value);
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_get_geometry(IntPtr raw, out int x, out int y, out int width, out int height);

		public void GetGeometry(out int x, out int y, out int width, out int height) {
			gdk_window_get_geometry(Handle, out x, out y, out width, out height);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_window_get_group(IntPtr raw);

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_group(IntPtr raw, IntPtr leader);

		public Gdk.Window Group { 
			get {
				IntPtr raw_ret = gdk_window_get_group(Handle);
				Gdk.Window ret = GLib.Object.GetObject(raw_ret) as Gdk.Window;
				return ret;
			}
			set {
				gdk_window_set_group(Handle, value == null ? IntPtr.Zero : value.Handle);
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gdk_window_get_height(IntPtr raw);

		public int Height { 
			get {
				int raw_ret = gdk_window_get_height(Handle);
				int ret = raw_ret;
				return ret;
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gdk_window_get_modal_hint(IntPtr raw);

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_modal_hint(IntPtr raw, bool modal);

		public bool ModalHint { 
			get {
				bool raw_ret = gdk_window_get_modal_hint(Handle);
				bool ret = raw_ret;
				return ret;
			}
			set {
				gdk_window_set_modal_hint(Handle, value);
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gdk_window_get_origin(IntPtr raw, out int x, out int y);

		public int GetOrigin(out int x, out int y) {
			int raw_ret = gdk_window_get_origin(Handle, out x, out y);
			int ret = raw_ret;
			return ret;
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_window_get_parent(IntPtr raw);

		public Gdk.Window Parent { 
			get {
				IntPtr raw_ret = gdk_window_get_parent(Handle);
				Gdk.Window ret = GLib.Object.GetObject(raw_ret) as Gdk.Window;
				return ret;
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gdk_window_get_pass_through(IntPtr raw);

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_pass_through(IntPtr raw, bool pass_through);

		public bool PassThrough { 
			get {
				bool raw_ret = gdk_window_get_pass_through(Handle);
				bool ret = raw_ret;
				return ret;
			}
			set {
				gdk_window_set_pass_through(Handle, value);
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_window_get_pointer(IntPtr raw, out int x, out int y, out int mask);

		[Obsolete]
		public Gdk.Window GetPointer(out int x, out int y, out Gdk.ModifierType mask) {
			int native_mask;
			IntPtr raw_ret = gdk_window_get_pointer(Handle, out x, out y, out native_mask);
			Gdk.Window ret = GLib.Object.GetObject(raw_ret) as Gdk.Window;
			mask = (Gdk.ModifierType) native_mask;
			return ret;
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_get_position(IntPtr raw, out int x, out int y);

		public void GetPosition(out int x, out int y) {
			gdk_window_get_position(Handle, out x, out y);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_get_root_coords(IntPtr raw, int x, int y, out int root_x, out int root_y);

		public void GetRootCoords(int x, int y, out int root_x, out int root_y) {
			gdk_window_get_root_coords(Handle, x, y, out root_x, out root_y);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_get_root_origin(IntPtr raw, out int x, out int y);

		public void GetRootOrigin(out int x, out int y) {
			gdk_window_get_root_origin(Handle, out x, out y);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gdk_window_get_scale_factor(IntPtr raw);

		public int ScaleFactor { 
			get {
				int raw_ret = gdk_window_get_scale_factor(Handle);
				int ret = raw_ret;
				return ret;
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_window_get_screen(IntPtr raw);

		public Gdk.Screen Screen { 
			get {
				IntPtr raw_ret = gdk_window_get_screen(Handle);
				Gdk.Screen ret = GLib.Object.GetObject(raw_ret) as Gdk.Screen;
				return ret;
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gdk_window_get_source_events(IntPtr raw, int source);

		public Gdk.EventMask GetSourceEvents(Gdk.InputSource source) {
			int raw_ret = gdk_window_get_source_events(Handle, (int) source);
			Gdk.EventMask ret = (Gdk.EventMask) raw_ret;
			return ret;
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gdk_window_get_state(IntPtr raw);

		public Gdk.WindowState State { 
			get {
				int raw_ret = gdk_window_get_state(Handle);
				Gdk.WindowState ret = (Gdk.WindowState) raw_ret;
				return ret;
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gdk_window_get_support_multidevice(IntPtr raw);

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_support_multidevice(IntPtr raw, bool support_multidevice);

		public bool SupportMultidevice { 
			get {
				bool raw_ret = gdk_window_get_support_multidevice(Handle);
				bool ret = raw_ret;
				return ret;
			}
			set {
				gdk_window_set_support_multidevice(Handle, value);
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_window_get_toplevel(IntPtr raw);

		public Gdk.Window Toplevel { 
			get {
				IntPtr raw_ret = gdk_window_get_toplevel(Handle);
				Gdk.Window ret = GLib.Object.GetObject(raw_ret) as Gdk.Window;
				return ret;
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_window_get_type();

		public static new GLib.GType GType { 
			get {
				IntPtr raw_ret = gdk_window_get_type();
				GLib.GType ret = new GLib.GType(raw_ret);
				return ret;
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gdk_window_get_type_hint(IntPtr raw);

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_type_hint(IntPtr raw, int hint);

		public Gdk.WindowTypeHint TypeHint { 
			get {
				int raw_ret = gdk_window_get_type_hint(Handle);
				Gdk.WindowTypeHint ret = (Gdk.WindowTypeHint) raw_ret;
				return ret;
			}
			set {
				gdk_window_set_type_hint(Handle, (int) value);
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_window_get_update_area(IntPtr raw);

		public Cairo.Region UpdateArea { 
			get {
				IntPtr raw_ret = gdk_window_get_update_area(Handle);
				Cairo.Region ret = new Cairo.Region(raw_ret);
				return ret;
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_window_get_visible_region(IntPtr raw);

		public Cairo.Region VisibleRegion { 
			get {
				IntPtr raw_ret = gdk_window_get_visible_region(Handle);
				Cairo.Region ret = new Cairo.Region(raw_ret);
				return ret;
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gdk_window_get_visual(IntPtr raw);

		public Gdk.Visual Visual { 
			get {
				IntPtr raw_ret = gdk_window_get_visual(Handle);
				Gdk.Visual ret = GLib.Object.GetObject(raw_ret) as Gdk.Visual;
				return ret;
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gdk_window_get_width(IntPtr raw);

		public int Width { 
			get {
				int raw_ret = gdk_window_get_width(Handle);
				int ret = raw_ret;
				return ret;
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gdk_window_get_window_type(IntPtr raw);

		public Gdk.WindowType WindowType { 
			get {
				int raw_ret = gdk_window_get_window_type(Handle);
				Gdk.WindowType ret = (Gdk.WindowType) raw_ret;
				return ret;
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gdk_window_has_native(IntPtr raw);

		public bool HasNative { 
			get {
				bool raw_ret = gdk_window_has_native(Handle);
				bool ret = raw_ret;
				return ret;
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_hide(IntPtr raw);

		public void Hide() {
			gdk_window_hide(Handle);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_iconify(IntPtr raw);

		public void Iconify() {
			gdk_window_iconify(Handle);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_input_shape_combine_region(IntPtr raw, IntPtr shape_region, int offset_x, int offset_y);

		public void InputShapeCombineRegion(Cairo.Region shape_region, int offset_x, int offset_y) {
			gdk_window_input_shape_combine_region(Handle, shape_region == null ? IntPtr.Zero : shape_region.Handle, offset_x, offset_y);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_invalidate_maybe_recurse(IntPtr raw, IntPtr region, GdkSharp.WindowChildFuncNative child_func, IntPtr user_data);

		public void InvalidateMaybeRecurse(Cairo.Region region, Gdk.WindowChildFunc child_func) {
			GdkSharp.WindowChildFuncWrapper child_func_wrapper = new GdkSharp.WindowChildFuncWrapper (child_func);
			gdk_window_invalidate_maybe_recurse(Handle, region == null ? IntPtr.Zero : region.Handle, child_func_wrapper.NativeDelegate, IntPtr.Zero);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_invalidate_rect(IntPtr raw, IntPtr rect, bool invalidate_children);

		public void InvalidateRect(Gdk.Rectangle rect, bool invalidate_children) {
			IntPtr native_rect = GLib.Marshaller.StructureToPtrAlloc (rect);
			gdk_window_invalidate_rect(Handle, native_rect, invalidate_children);
			Marshal.FreeHGlobal (native_rect);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_invalidate_region(IntPtr raw, IntPtr region, bool invalidate_children);

		public void InvalidateRegion(Cairo.Region region, bool invalidate_children) {
			gdk_window_invalidate_region(Handle, region == null ? IntPtr.Zero : region.Handle, invalidate_children);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gdk_window_is_destroyed(IntPtr raw);

		public bool IsDestroyed { 
			get {
				bool raw_ret = gdk_window_is_destroyed(Handle);
				bool ret = raw_ret;
				return ret;
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gdk_window_is_input_only(IntPtr raw);

		public bool IsInputOnly { 
			get {
				bool raw_ret = gdk_window_is_input_only(Handle);
				bool ret = raw_ret;
				return ret;
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gdk_window_is_shaped(IntPtr raw);

		public bool IsShaped { 
			get {
				bool raw_ret = gdk_window_is_shaped(Handle);
				bool ret = raw_ret;
				return ret;
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gdk_window_is_viewable(IntPtr raw);

		public bool IsViewable { 
			get {
				bool raw_ret = gdk_window_is_viewable(Handle);
				bool ret = raw_ret;
				return ret;
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gdk_window_is_visible(IntPtr raw);

		public bool IsVisible { 
			get {
				bool raw_ret = gdk_window_is_visible(Handle);
				bool ret = raw_ret;
				return ret;
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_lower(IntPtr raw);

		public void Lower() {
			gdk_window_lower(Handle);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_mark_paint_from_clip(IntPtr raw, IntPtr cr);

		public void MarkPaintFromClip(Cairo.Context cr) {
			gdk_window_mark_paint_from_clip(Handle, cr == null ? IntPtr.Zero : cr.Handle);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_maximize(IntPtr raw);

		public void Maximize() {
			gdk_window_maximize(Handle);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_merge_child_input_shapes(IntPtr raw);

		public void MergeChildInputShapes() {
			gdk_window_merge_child_input_shapes(Handle);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_merge_child_shapes(IntPtr raw);

		public void MergeChildShapes() {
			gdk_window_merge_child_shapes(Handle);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_move(IntPtr raw, int x, int y);

		public void Move(int x, int y) {
			gdk_window_move(Handle, x, y);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_move_region(IntPtr raw, IntPtr region, int dx, int dy);

		public void MoveRegion(Cairo.Region region, int dx, int dy) {
			gdk_window_move_region(Handle, region == null ? IntPtr.Zero : region.Handle, dx, dy);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_move_resize(IntPtr raw, int x, int y, int width, int height);

		public void MoveResize(int x, int y, int width, int height) {
			gdk_window_move_resize(Handle, x, y, width, height);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_process_all_updates();

		public static void ProcessAllUpdates() {
			gdk_window_process_all_updates();
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_process_updates(IntPtr raw, bool update_children);

		public void ProcessUpdates(bool update_children) {
			gdk_window_process_updates(Handle, update_children);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_raise(IntPtr raw);

		public void Raise() {
			gdk_window_raise(Handle);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_register_dnd(IntPtr raw);

		public void RegisterDnd() {
			gdk_window_register_dnd(Handle);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_reparent(IntPtr raw, IntPtr new_parent, int x, int y);

		public void Reparent(Gdk.Window new_parent, int x, int y) {
			gdk_window_reparent(Handle, new_parent == null ? IntPtr.Zero : new_parent.Handle, x, y);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_resize(IntPtr raw, int width, int height);

		public void Resize(int width, int height) {
			gdk_window_resize(Handle, width, height);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_restack(IntPtr raw, IntPtr sibling, bool above);

		public void Restack(Gdk.Window sibling, bool above) {
			gdk_window_restack(Handle, sibling == null ? IntPtr.Zero : sibling.Handle, above);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_scroll(IntPtr raw, int dx, int dy);

		public void Scroll(int dx, int dy) {
			gdk_window_scroll(Handle, dx, dy);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_background(IntPtr raw, IntPtr value);

		[Obsolete]
		public Gdk.Color Background { 
			set {
				IntPtr native_value = GLib.Marshaller.StructureToPtrAlloc (value);
				gdk_window_set_background(Handle, native_value);
				Marshal.FreeHGlobal (native_value);
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_background_rgba(IntPtr raw, IntPtr value);

		[Obsolete]
		public Gdk.RGBA BackgroundRgba { 
			set {
				IntPtr native_value = GLib.Marshaller.StructureToPtrAlloc (value);
				gdk_window_set_background_rgba(Handle, native_value);
				Marshal.FreeHGlobal (native_value);
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_child_input_shapes(IntPtr raw);

		public void SetChildInputShapes() {
			gdk_window_set_child_input_shapes(Handle);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_child_shapes(IntPtr raw);

		public void SetChildShapes() {
			gdk_window_set_child_shapes(Handle);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_debug_updates(bool setting);

		[Obsolete]
		public static bool DebugUpdates { 
			set {
				gdk_window_set_debug_updates(value);
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_decorations(IntPtr raw, int decorations);

		public void SetDecorations(Gdk.WMDecoration decorations) {
			gdk_window_set_decorations(Handle, (int) decorations);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_device_cursor(IntPtr raw, IntPtr device, IntPtr cursor);

		public void SetDeviceCursor(Gdk.Device device, Gdk.Cursor cursor) {
			gdk_window_set_device_cursor(Handle, device == null ? IntPtr.Zero : device.Handle, cursor == null ? IntPtr.Zero : cursor.Handle);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_device_events(IntPtr raw, IntPtr device, int event_mask);

		public void SetDeviceEvents(Gdk.Device device, Gdk.EventMask event_mask) {
			gdk_window_set_device_events(Handle, device == null ? IntPtr.Zero : device.Handle, (int) event_mask);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_functions(IntPtr raw, int functions);

		public Gdk.WMFunction Functions { 
			set {
				gdk_window_set_functions(Handle, (int) value);
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_geometry_hints(IntPtr raw, IntPtr geometry, int geom_mask);

		public void SetGeometryHints(Gdk.Geometry geometry, Gdk.WindowHints geom_mask) {
			IntPtr native_geometry = GLib.Marshaller.StructureToPtrAlloc (geometry);
			gdk_window_set_geometry_hints(Handle, native_geometry, (int) geom_mask);
			Marshal.FreeHGlobal (native_geometry);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_icon_name(IntPtr raw, IntPtr name);

		public string IconName { 
			set {
				IntPtr native_value = GLib.Marshaller.StringToPtrGStrdup (value);
				gdk_window_set_icon_name(Handle, native_value);
				GLib.Marshaller.Free (native_value);
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_invalidate_handler(IntPtr raw, GdkSharp.WindowInvalidateHandlerFuncNative handler);

		public Gdk.WindowInvalidateHandlerFunc InvalidateHandler { 
			set {
				GdkSharp.WindowInvalidateHandlerFuncWrapper value_wrapper = new GdkSharp.WindowInvalidateHandlerFuncWrapper (value);
				gdk_window_set_invalidate_handler(Handle, value_wrapper.NativeDelegate);
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_keep_above(IntPtr raw, bool setting);

		public bool KeepAbove { 
			set {
				gdk_window_set_keep_above(Handle, value);
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_keep_below(IntPtr raw, bool setting);

		public bool KeepBelow { 
			set {
				gdk_window_set_keep_below(Handle, value);
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_opacity(IntPtr raw, double opacity);

		public double Opacity { 
			set {
				gdk_window_set_opacity(Handle, value);
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_opaque_region(IntPtr raw, IntPtr region);

		public Cairo.Region OpaqueRegion { 
			set {
				gdk_window_set_opaque_region(Handle, value == null ? IntPtr.Zero : value.Handle);
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_override_redirect(IntPtr raw, bool override_redirect);

		public bool OverrideRedirect { 
			set {
				gdk_window_set_override_redirect(Handle, value);
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_role(IntPtr raw, IntPtr role);

		public string Role { 
			set {
				IntPtr native_value = GLib.Marshaller.StringToPtrGStrdup (value);
				gdk_window_set_role(Handle, native_value);
				GLib.Marshaller.Free (native_value);
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_shadow_width(IntPtr raw, int left, int right, int top, int bottom);

		public void SetShadowWidth(int left, int right, int top, int bottom) {
			gdk_window_set_shadow_width(Handle, left, right, top, bottom);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_skip_pager_hint(IntPtr raw, bool skips_pager);

		public bool SkipPagerHint { 
			set {
				gdk_window_set_skip_pager_hint(Handle, value);
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_skip_taskbar_hint(IntPtr raw, bool skips_taskbar);

		public bool SkipTaskbarHint { 
			set {
				gdk_window_set_skip_taskbar_hint(Handle, value);
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_source_events(IntPtr raw, int source, int event_mask);

		public void SetSourceEvents(Gdk.InputSource source, Gdk.EventMask event_mask) {
			gdk_window_set_source_events(Handle, (int) source, (int) event_mask);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_startup_id(IntPtr raw, IntPtr startup_id);

		public string StartupId { 
			set {
				IntPtr native_value = GLib.Marshaller.StringToPtrGStrdup (value);
				gdk_window_set_startup_id(Handle, native_value);
				GLib.Marshaller.Free (native_value);
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gdk_window_set_static_gravities(IntPtr raw, bool use_static);

		[Obsolete]
		public bool SetStaticGravities(bool use_static) {
			bool raw_ret = gdk_window_set_static_gravities(Handle, use_static);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_title(IntPtr raw, IntPtr title);

		public string Title { 
			set {
				IntPtr native_value = GLib.Marshaller.StringToPtrGStrdup (value);
				gdk_window_set_title(Handle, native_value);
				GLib.Marshaller.Free (native_value);
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_transient_for(IntPtr raw, IntPtr parent);

		public Gdk.Window TransientFor { 
			set {
				gdk_window_set_transient_for(Handle, value == null ? IntPtr.Zero : value.Handle);
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_set_urgency_hint(IntPtr raw, bool urgent);

		public bool UrgencyHint { 
			set {
				gdk_window_set_urgency_hint(Handle, value);
			}
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_shape_combine_region(IntPtr raw, IntPtr shape_region, int offset_x, int offset_y);

		public void ShapeCombineRegion(Cairo.Region shape_region, int offset_x, int offset_y) {
			gdk_window_shape_combine_region(Handle, shape_region == null ? IntPtr.Zero : shape_region.Handle, offset_x, offset_y);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_show(IntPtr raw);

		public void Show() {
			gdk_window_show(Handle);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_show_unraised(IntPtr raw);

		public void ShowUnraised() {
			gdk_window_show_unraised(Handle);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gdk_window_show_window_menu(IntPtr raw, IntPtr evnt);

		public bool ShowWindowMenu(Gdk.Event evnt) {
			bool raw_ret = gdk_window_show_window_menu(Handle, evnt == null ? IntPtr.Zero : evnt.Handle);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_stick(IntPtr raw);

		public void Stick() {
			gdk_window_stick(Handle);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_thaw_updates(IntPtr raw);

		public void ThawUpdates() {
			gdk_window_thaw_updates(Handle);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_unfullscreen(IntPtr raw);

		public void Unfullscreen() {
			gdk_window_unfullscreen(Handle);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_unmaximize(IntPtr raw);

		public void Unmaximize() {
			gdk_window_unmaximize(Handle);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_unstick(IntPtr raw);

		public void Unstick() {
			gdk_window_unstick(Handle);
		}

		[DllImport("gdk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gdk_window_withdraw(IntPtr raw);

		public void Withdraw() {
			gdk_window_withdraw(Handle);
		}


		// Internal representation of the wrapped structure ABI.
		static GLib.AbiStruct _abi_info = null;
		static public new GLib.AbiStruct abi_info {
			get {
				if (_abi_info == null)
					_abi_info = new GLib.AbiStruct (GLib.Object.abi_info.Fields);

				return _abi_info;
			}
		}


		// End of the ABI representation.

#endregion
	}
}
