/* klotski-window.c generated by valac 0.39.92.14-46f76, the Vala compiler
 * generated from klotski-window.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <libgnome-games-support.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <glib/gstdio.h>


#define TYPE_LEVEL_INFO (level_info_get_type ())
typedef struct _LevelInfo LevelInfo;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_KLOTSKI_WINDOW (klotski_window_get_type ())
#define KLOTSKI_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KLOTSKI_WINDOW, KlotskiWindow))
#define KLOTSKI_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KLOTSKI_WINDOW, KlotskiWindowClass))
#define IS_KLOTSKI_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KLOTSKI_WINDOW))
#define IS_KLOTSKI_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KLOTSKI_WINDOW))
#define KLOTSKI_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KLOTSKI_WINDOW, KlotskiWindowClass))

typedef struct _KlotskiWindow KlotskiWindow;
typedef struct _KlotskiWindowClass KlotskiWindowClass;
typedef struct _KlotskiWindowPrivate KlotskiWindowPrivate;

#define TYPE_PUZZLE_VIEW (puzzle_view_get_type ())
#define PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE_VIEW, PuzzleView))
#define PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE_VIEW, PuzzleViewClass))
#define IS_PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE_VIEW))
#define IS_PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE_VIEW))
#define PUZZLE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE_VIEW, PuzzleViewClass))

typedef struct _PuzzleView PuzzleView;
typedef struct _PuzzleViewClass PuzzleViewClass;

#define TYPE_PUZZLE (puzzle_get_type ())
#define PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE, Puzzle))
#define PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE, PuzzleClass))
#define IS_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE))
#define IS_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE))
#define PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE, PuzzleClass))

typedef struct _Puzzle Puzzle;
typedef struct _PuzzleClass PuzzleClass;
enum  {
	KLOTSKI_WINDOW_0_PROPERTY,
	KLOTSKI_WINDOW_NUM_PROPERTIES
};
static GParamSpec* klotski_window_properties[KLOTSKI_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _PuzzlePrivate PuzzlePrivate;
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))

struct _LevelInfo {
	gchar* name;
	gint group;
	gint width;
	gint height;
	gchar* data;
};

struct _KlotskiWindow {
	GtkApplicationWindow parent_instance;
	KlotskiWindowPrivate * priv;
};

struct _KlotskiWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _KlotskiWindowPrivate {
	GSettings* settings;
	gboolean is_tiled;
	gboolean window_is_maximized;
	gint window_width;
	gint window_height;
	GtkHeaderBar* headerbar;
	GtkStack* stack_packs;
	GtkStack* stack_puzzles;
	GtkPopover* puzzles_popover;
	PuzzleView* view;
	GtkTreeView* treeview_huarong;
	GtkTreeView* treeview_challenge;
	GtkTreeView* treeview_skill;
	GSimpleAction* prev_pack;
	GSimpleAction* next_pack;
	GSimpleAction* prev_puzzle;
	GSimpleAction* next_puzzle;
	GSimpleAction* start_game;
	Puzzle* puzzle;
	gint current_pack;
	gint current_level;
	GamesScoresContext* scores_context;
	GtkListStore* liststore_huarong;
	GtkListStore* liststore_challenge;
	GtkListStore* liststore_skill;
	GtkTreeIter* puzzles_items;
	gint puzzles_items_length1;
	gint _puzzles_items_size_;
};

struct _Puzzle {
	GObject parent_instance;
	PuzzlePrivate * priv;
	gint width;
	gint height;
	gchar* map;
	gint map_length1;
	gchar* move_map;
	gint move_map_length1;
	gchar* orig_map;
	gint orig_map_length1;
	gchar* lastmove_map;
	gint lastmove_map_length1;
	gchar* undomove_map;
	gint undomove_map_length1;
	gint moves;
};

struct _PuzzleClass {
	GObjectClass parent_class;
};


static gpointer klotski_window_parent_class = NULL;
static GeeList* klotski_window_score_categories;
static GeeList* klotski_window_score_categories = NULL;

GType level_info_get_type (void) G_GNUC_CONST;
LevelInfo* level_info_dup (const LevelInfo* self);
void level_info_free (LevelInfo* self);
void level_info_copy (const LevelInfo* self,
                      LevelInfo* dest);
void level_info_destroy (LevelInfo* self);
GType klotski_window_get_type (void) G_GNUC_CONST;
GType puzzle_view_get_type (void) G_GNUC_CONST;
GType puzzle_get_type (void) G_GNUC_CONST;
#define KLOTSKI_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_KLOTSKI_WINDOW, KlotskiWindowPrivate))
#define KLOTSKI_WINDOW_KEY_LEVEL "level"
static void klotski_window_prev_pack_cb (KlotskiWindow* self);
static void _klotski_window_prev_pack_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self);
static void klotski_window_next_pack_cb (KlotskiWindow* self);
static void _klotski_window_next_pack_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self);
static void klotski_window_prev_puzzle_cb (KlotskiWindow* self);
static void _klotski_window_prev_puzzle_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void klotski_window_next_puzzle_cb (KlotskiWindow* self);
static void _klotski_window_next_puzzle_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void klotski_window_start_puzzle_cb (KlotskiWindow* self);
static void _klotski_window_start_puzzle_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self);
static gchar* klotski_window_normalize_map_name (const gchar* name);
static GamesScoresCategory* klotski_window_category_request (KlotskiWindow* self,
                                                      const gchar* key);
static void klotski_window_parse_old_score (KlotskiWindow* self,
                                     const gchar* line,
                                     GamesScoresScore* * score,
                                     GamesScoresCategory* * category);
KlotskiWindow* klotski_window_new (void);
KlotskiWindow* klotski_window_construct (GType object_type);
static GamesScoresCategory* _klotski_window_category_request_games_scores_context_category_request_func (const gchar* category_key,
                                                                                                  gpointer self);
static void _klotski_window_parse_old_score_games_scores_history_file_importer_history_convert_func (const gchar* line,
                                                                                              GamesScoresScore* * score,
                                                                                              GamesScoresCategory* * category,
                                                                                              gpointer self);
static void klotski_window_level_huarong_cb (KlotskiWindow* self,
                                      GtkTreePath* path,
                                      GtkTreeViewColumn* column);
static void _klotski_window_level_huarong_cb_gtk_tree_view_row_activated (GtkTreeView* _sender,
                                                                   GtkTreePath* path,
                                                                   GtkTreeViewColumn* column,
                                                                   gpointer self);
static void klotski_window_level_challenge_cb (KlotskiWindow* self,
                                        GtkTreePath* path,
                                        GtkTreeViewColumn* column);
static void _klotski_window_level_challenge_cb_gtk_tree_view_row_activated (GtkTreeView* _sender,
                                                                     GtkTreePath* path,
                                                                     GtkTreeViewColumn* column,
                                                                     gpointer self);
static void klotski_window_level_skill_cb (KlotskiWindow* self,
                                    GtkTreePath* path,
                                    GtkTreeViewColumn* column);
static void _klotski_window_level_skill_cb_gtk_tree_view_row_activated (GtkTreeView* _sender,
                                                                 GtkTreePath* path,
                                                                 GtkTreeViewColumn* column,
                                                                 gpointer self);
PuzzleView* puzzle_view_new (void);
PuzzleView* puzzle_view_construct (GType object_type);
static void klotski_window_load_solved_state (KlotskiWindow* self);
static void __lambda5_ (KlotskiWindow* self);
static void klotski_window_update_popover (KlotskiWindow* self,
                                    gboolean make_current);
static void ___lambda5__gtk_widget_show (GtkWidget* _sender,
                                  gpointer self);
static void klotski_window_start_puzzle (KlotskiWindow* self);
static void klotski_window_on_size_allocate (KlotskiWindow* self,
                                      GtkAllocation* allocation);
static void _klotski_window_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender,
                                                                GtkAllocation* allocation,
                                                                gpointer self);
static gboolean klotski_window_on_window_state_event (KlotskiWindow* self,
                                               GdkEventWindowState* event);
static gboolean _klotski_window_on_window_state_event_gtk_widget_window_state_event (GtkWidget* _sender,
                                                                              GdkEventWindowState* event,
                                                                              gpointer self);
static void klotski_window_on_destroy (KlotskiWindow* self);
static void _klotski_window_on_destroy_gtk_widget_destroy (GtkWidget* _sender,
                                                    gpointer self);
static void klotski_window_start_puzzle_from_iter (KlotskiWindow* self,
                                            GtkListStore* model,
                                            GtkTreeIter* iter);
static void klotski_window_update_buttons_state (KlotskiWindow* self);
static void klotski_window_level_cb (KlotskiWindow* self,
                              GtkListStore* liststore,
                              GtkTreePath* path,
                              GtkTreeViewColumn* column);
Puzzle* puzzle_new (gint width,
                    gint height,
                    const gchar* data);
Puzzle* puzzle_construct (GType object_type,
                          gint width,
                          gint height,
                          const gchar* data);
static void klotski_window_puzzle_moved_cb (KlotskiWindow* self);
static void _klotski_window_puzzle_moved_cb_puzzle_moved (Puzzle* _sender,
                                                   gpointer self);
void puzzle_view_set_puzzle (PuzzleView* self,
                             Puzzle* value);
static void klotski_window_update_moves_label (KlotskiWindow* self);
gboolean puzzle_game_over (Puzzle* self);
static void klotski_window_game_score (KlotskiWindow* self);
static gchar* klotski_window_get_level_key (KlotskiWindow* self,
                                     gint level_number);
static void klotski_window_puzzle_solved (KlotskiWindow* self,
                                   GtkTreeIter* iter,
                                   gboolean solved);
static void __lambda4_ (KlotskiWindow* self,
                 GObject* object,
                 GAsyncResult* _result_);
static void ___lambda4__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
void klotski_window_show_scores (KlotskiWindow* self);
static void klotski_window_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const LevelInfo KLOTSKI_WINDOW_levels[28] = {{N_ ("Only 18 Steps"), 0, 6, 9, "######" "#a**b#" "#m**n#" "#cdef#" "#ghij#" "#k  l#" "##--##" "    .." "    .."}, {N_ ("Daisy"), 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdef#" "#zghi#" "#j  k#" "##--##" "    .." "    .."}, {N_ ("Violet"), 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdef#" "#cghi#" "#j  k#" "##--##" "    .." "    .."}, {N_ ("Poppy"), 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdde#" "#fghi#" "#j  k#" "##--##" "    .." "    .."}, {N_ ("Pansy"), 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdef#" "#cghf#" "#i  j#" "##--##" "    .." "    .."}, {N_ ("Snowdrop"), 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdde#" "#cfgh#" "#i  j#" "##--##" "    .." "    .."}, {N_ ("Red Donkey"), 0, 6, 9, "######" "#a**b#" "#a**b#" "#cdde#" "#cfge#" "#h  i#" "##--##" "    .." "    .."}, {N_ ("Trail"), 0, 6, 9, "######" "#a**c#" "#a**c#" "#eddg#" "#hffj#" "# ii #" "##--##" "    .." "    .."}, {N_ ("Ambush"), 0, 6, 9, "######" "#a**c#" "#d**e#" "#dffe#" "#ghhi#" "# jj #" "##--##" "    .." "    .."}, {N_ ("Agatka"), 1, 7, 7, "..     " ".      " "#####--" "#**aab-" "#*ccde#" "#fgh  #" "#######"}, {N_ ("Success"), 1, 9, 6, "#######  " "#**bbc#  " "#defgh#  " "#ijkgh-  " "#llk  #  " "#######.."}, {N_ ("Bone"), 1, 6, 9, "######" "#abc*#" "# dd*#" "# ee*#" "# fgh#" "##-###" "     ." "     ." "     ."}, {N_ ("Fortune"), 1, 7, 10, "     .." "     . " "####-. " "#ab  - " "#ccd # " "#ccd # " "#**ee# " "#*fgh# " "#*iih# " "###### "}, {N_ ("Fool"), 1, 10, 6, "  ########" "  -aabc  #" "  #aabdef#" "  #ijggef#" "  #klhh**#" "..########"}, {N_ ("Solomon"), 1, 7, 9, " .     " "..     " "#--####" "#  aab#" "# cdfb#" "#hcefg#" "#hijk*#" "#hll**#" "#######"}, {N_ ("Cleopatra"), 1, 6, 8, "######" "#abcd#" "#**ee#" "#f*g #" "#fh i-" "####--" "    .." "     ."}, {N_ ("Shark"), 1, 11, 8, "########   " "#nrr s #   " "#n*op q#   " "#***jml#   " "#hhijkl#   " "#ffcddg-   " "#abcdde- . " "########..."}, {N_ ("Rome"), 1, 8, 8, "########" "#abcc**#" "#ddeef*#" "#ddghfi#" "#   jki#" "#--#####" " ..     " "  .     "}, {N_ ("Pennant Puzzle"), 1, 6, 9, "######" "#**aa#" "#**bb#" "#de  #" "#fghh#" "#fgii#" "#--###" "    .." "    .."}, {N_ ("Ithaca"), 2, 19, 19, ".aaaaaaaaaaaaaaaaab" "..  cddeffffffffffb" " .. cddeffffffffffb" "  . cddeffffffffffb" "ggg-############hhb" "ggg-  ABCDEFFGH#hhb" "ggg-       FFIJ#hhb" "ggg#       KLMJ#hhb" "ggg#NNNNOOOPQMJ#hhb" "ggg#NNNNOOOP*RS#hhb" "ggg#TTTTTUVW**X#hhb" "ggg#YZ12222W3**#hhb" "ggg#YZ12222W34*#iib" "jjj#YZ155555367#klb" "jjj#############mmb" "jjjnooooooooooppppb" "jjjqooooooooooppppb" "       rrrssssppppb" "ttttttuvvvvvvvwwwwx"}, {N_ ("Pelopones"), 2, 9, 8, "#########" "#abbb***#" "#abbb*c*#" "#adeefgg#" "#  eefhh#" "#... ihh#" "#. . ihh#" "#########"}, {N_ ("Transeuropa"), 2, 15, 8, "    ###########" "    -AAAAABBCC#" "    -   DEFGHI#" "    #   DEFGJI#" "    #   KEFGLI#" "    #   KEFG*I#" "  . #   MM****#" "....###########"}, {N_ ("Lodzianka"), 2, 9, 7, "#########" "#**abbcc#" "#**abbdd#" "#eefgh  #" "#iiijk..#" "#iiijk..#" "#########"}, {N_ ("Polonaise"), 2, 7, 7, "#######" "#aab**#" "#aabc*#" "#defgg#" "#..fhh#" "# .ihh#" "#######"}, {N_ ("Baltic Sea"), 2, 6, 8, "######" "#.abc#" "#.dec#" "#fggc#" "#fhhi#" "#fjk*#" "#flk*#" "######"}, {N_ ("American Pie"), 2, 10, 12, "##########" "#a*bcdefg#" "#**bhhhhg#" "#*iijjkkg#" "#liimnoop#" "#qiirrr  #" "#qstuvv  #" "#qwwxvv  #" "######--##" "         ." "        .." "        . "}, {N_ ("Traffic Jam"), 2, 10, 7, "########  " "#** ffi#  " "#** fgh#  " "#aacehh#  " "#bbdjlm-  " "#bddklm-.." "########.."}, {N_ ("Sunshine"), 2, 17, 22, "       ...       " "      .. ..      " "      .   .      " "      .. ..      " "       ...       " "######-----######" "#hh0iilltmmpp;qq#" "#hh,iill mmpp:qq#" "#2y{45v s w89x/z#" "#jj6kkaa nnoo<rr#" "#jj7kkaaunnoo>rr#" "#33333TTJWW11111#" "#33333TTJWW11111#" "#33333GG HH11111#" "#33333YYIgg11111#" "#33333YYIgg11111#" "#ddFeeA***BffOZZ#" "#ddFee** **ffOZZ#" "#MMKQQ*   *PPS^^#" "#VVLXX** **bbRcc#" "#VVLXXD***EbbRcc#" "#################"}};
static const GActionEntry KLOTSKI_WINDOW_win_actions[5] = {{"prev-pack", _klotski_window_prev_pack_cb_gsimple_action_activate_callback}, {"next-pack", _klotski_window_next_pack_cb_gsimple_action_activate_callback}, {"prev-puzzle", _klotski_window_prev_puzzle_cb_gsimple_action_activate_callback}, {"next-puzzle", _klotski_window_next_puzzle_cb_gsimple_action_activate_callback}, {"start-game", _klotski_window_start_puzzle_cb_gsimple_action_activate_callback}};

void
level_info_copy (const LevelInfo* self,
                 LevelInfo* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).group;
	(*dest).group = _tmp2_;
	_tmp3_ = (*self).width;
	(*dest).width = _tmp3_;
	_tmp4_ = (*self).height;
	(*dest).height = _tmp4_;
	_tmp5_ = (*self).data;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 ((*dest).data);
	(*dest).data = _tmp6_;
}


void
level_info_destroy (LevelInfo* self)
{
	_g_free0 ((*self).name);
	_g_free0 ((*self).data);
}


LevelInfo*
level_info_dup (const LevelInfo* self)
{
	LevelInfo* dup;
	dup = g_new0 (LevelInfo, 1);
	level_info_copy (self, dup);
	return dup;
}


void
level_info_free (LevelInfo* self)
{
	level_info_destroy (self);
	g_free (self);
}


GType
level_info_get_type (void)
{
	static volatile gsize level_info_type_id__volatile = 0;
	if (g_once_init_enter (&level_info_type_id__volatile)) {
		GType level_info_type_id;
		level_info_type_id = g_boxed_type_register_static ("LevelInfo", (GBoxedCopyFunc) level_info_dup, (GBoxedFreeFunc) level_info_free);
		g_once_init_leave (&level_info_type_id__volatile, level_info_type_id);
	}
	return level_info_type_id__volatile;
}


static void
_klotski_window_prev_pack_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self)
{
	klotski_window_prev_pack_cb ((KlotskiWindow*) self);
}


static void
_klotski_window_next_pack_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self)
{
	klotski_window_next_pack_cb ((KlotskiWindow*) self);
}


static void
_klotski_window_prev_puzzle_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	klotski_window_prev_puzzle_cb ((KlotskiWindow*) self);
}


static void
_klotski_window_next_puzzle_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	klotski_window_next_puzzle_cb ((KlotskiWindow*) self);
}


static void
_klotski_window_start_puzzle_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self)
{
	klotski_window_start_puzzle_cb ((KlotskiWindow*) self);
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar*
klotski_window_normalize_map_name (const gchar* name)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_utf8_strdown (name, (gssize) -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_replace (_tmp1_, " ", "-");
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}


static GamesScoresCategory*
klotski_window_category_request (KlotskiWindow* self,
                                 const gchar* key)
{
	GamesScoresCategory* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				LevelInfo _tmp4_;
				const gchar* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				if (!(_tmp2_ < G_N_ELEMENTS (KLOTSKI_WINDOW_levels))) {
					break;
				}
				_tmp3_ = i;
				_tmp4_ = KLOTSKI_WINDOW_levels[_tmp3_];
				_tmp5_ = _tmp4_.name;
				_tmp6_ = klotski_window_normalize_map_name (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = g_strcmp0 (key, _tmp7_) == 0;
				_g_free0 (_tmp7_);
				if (_tmp8_) {
					GeeList* _tmp9_;
					gint _tmp10_;
					gpointer _tmp11_;
					_tmp9_ = klotski_window_score_categories;
					_tmp10_ = i;
					_tmp11_ = gee_list_get (_tmp9_, _tmp10_);
					result = (GamesScoresCategory*) _tmp11_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}


static void
klotski_window_parse_old_score (KlotskiWindow* self,
                                const gchar* line,
                                GamesScoresScore* * score,
                                GamesScoresCategory* * category)
{
	GamesScoresScore* _vala_score = NULL;
	GamesScoresCategory* _vala_category = NULL;
	gchar** tokens = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint tokens_length1;
	gint _tokens_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint64 date = 0LL;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	gint64 _tmp5_;
	gint level = 0;
	gchar** _tmp6_;
	gint _tmp6__length1;
	const gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	gint _tmp9_;
	gboolean _tmp12_ = FALSE;
	gint _tmp13_;
	gint moves = 0;
	gchar** _tmp18_;
	gint _tmp18__length1;
	const gchar* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	gint64 _tmp22_;
	GamesScoresScore* _tmp23_;
	GeeList* _tmp24_;
	gint _tmp25_;
	gpointer _tmp26_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	_g_object_unref0 (_vala_score);
	_vala_score = NULL;
	_g_object_unref0 (_vala_category);
	_vala_category = NULL;
	_tmp1_ = _tmp0_ = g_strsplit (line, " ", 0);
	tokens = _tmp1_;
	tokens_length1 = _vala_array_length (_tmp0_);
	_tokens_size_ = tokens_length1;
	_tmp2_ = tokens;
	_tmp2__length1 = tokens_length1;
	if (_tmp2__length1 != 3) {
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (score) {
			*score = _vala_score;
		} else {
			_g_object_unref0 (_vala_score);
		}
		if (category) {
			*category = _vala_category;
		} else {
			_g_object_unref0 (_vala_category);
		}
		return;
	}
	_tmp3_ = tokens;
	_tmp3__length1 = tokens_length1;
	_tmp4_ = _tmp3_[0];
	date = games_scores_history_file_importer_parse_date (_tmp4_);
	_tmp5_ = date;
	if (_tmp5_ == ((gint64) 0)) {
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (score) {
			*score = _vala_score;
		} else {
			_g_object_unref0 (_vala_score);
		}
		if (category) {
			*category = _vala_category;
		} else {
			_g_object_unref0 (_vala_category);
		}
		return;
	}
	_tmp6_ = tokens;
	_tmp6__length1 = tokens_length1;
	_tmp7_ = _tmp6_[1];
	level = atoi (_tmp7_);
	_tmp9_ = level;
	if (_tmp9_ == 0) {
		gchar** _tmp10_;
		gint _tmp10__length1;
		const gchar* _tmp11_;
		_tmp10_ = tokens;
		_tmp10__length1 = tokens_length1;
		_tmp11_ = _tmp10_[1];
		_tmp8_ = g_strcmp0 (_tmp11_, "0") != 0;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (score) {
			*score = _vala_score;
		} else {
			_g_object_unref0 (_vala_score);
		}
		if (category) {
			*category = _vala_category;
		} else {
			_g_object_unref0 (_vala_category);
		}
		return;
	}
	_tmp13_ = level;
	if (_tmp13_ < 0) {
		_tmp12_ = TRUE;
	} else {
		gint _tmp14_;
		GeeList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		_tmp14_ = level;
		_tmp15_ = klotski_window_score_categories;
		_tmp16_ = gee_collection_get_size ((GeeCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp12_ = _tmp14_ > _tmp17_;
	}
	if (_tmp12_) {
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (score) {
			*score = _vala_score;
		} else {
			_g_object_unref0 (_vala_score);
		}
		if (category) {
			*category = _vala_category;
		} else {
			_g_object_unref0 (_vala_category);
		}
		return;
	}
	_tmp18_ = tokens;
	_tmp18__length1 = tokens_length1;
	_tmp19_ = _tmp18_[2];
	moves = atoi (_tmp19_);
	_tmp20_ = moves;
	if (_tmp20_ <= 0) {
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (score) {
			*score = _vala_score;
		} else {
			_g_object_unref0 (_vala_score);
		}
		if (category) {
			*category = _vala_category;
		} else {
			_g_object_unref0 (_vala_category);
		}
		return;
	}
	_tmp21_ = moves;
	_tmp22_ = date;
	_tmp23_ = games_scores_score_new ((glong) _tmp21_, _tmp22_, NULL);
	_g_object_unref0 (_vala_score);
	_vala_score = _tmp23_;
	_tmp24_ = klotski_window_score_categories;
	_tmp25_ = level;
	_tmp26_ = gee_list_get (_tmp24_, _tmp25_);
	_g_object_unref0 (_vala_category);
	_vala_category = (GamesScoresCategory*) _tmp26_;
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	if (score) {
		*score = _vala_score;
	} else {
		_g_object_unref0 (_vala_score);
	}
	if (category) {
		*category = _vala_category;
	} else {
		_g_object_unref0 (_vala_category);
	}
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static GamesScoresCategory*
_klotski_window_category_request_games_scores_context_category_request_func (const gchar* category_key,
                                                                             gpointer self)
{
	GamesScoresCategory* result;
	result = klotski_window_category_request ((KlotskiWindow*) self, category_key);
	return result;
}


static void
_klotski_window_parse_old_score_games_scores_history_file_importer_history_convert_func (const gchar* line,
                                                                                         GamesScoresScore* * score,
                                                                                         GamesScoresCategory* * category,
                                                                                         gpointer self)
{
	klotski_window_parse_old_score ((KlotskiWindow*) self, line, score, category);
}


static void
_klotski_window_level_huarong_cb_gtk_tree_view_row_activated (GtkTreeView* _sender,
                                                              GtkTreePath* path,
                                                              GtkTreeViewColumn* column,
                                                              gpointer self)
{
	klotski_window_level_huarong_cb ((KlotskiWindow*) self, path, column);
}


static void
_klotski_window_level_challenge_cb_gtk_tree_view_row_activated (GtkTreeView* _sender,
                                                                GtkTreePath* path,
                                                                GtkTreeViewColumn* column,
                                                                gpointer self)
{
	klotski_window_level_challenge_cb ((KlotskiWindow*) self, path, column);
}


static void
_klotski_window_level_skill_cb_gtk_tree_view_row_activated (GtkTreeView* _sender,
                                                            GtkTreePath* path,
                                                            GtkTreeViewColumn* column,
                                                            gpointer self)
{
	klotski_window_level_skill_cb ((KlotskiWindow*) self, path, column);
}


static void
__lambda5_ (KlotskiWindow* self)
{
	klotski_window_update_popover (self, TRUE);
}


static void
___lambda5__gtk_widget_show (GtkWidget* _sender,
                             gpointer self)
{
	__lambda5_ ((KlotskiWindow*) self);
}


KlotskiWindow*
klotski_window_construct (GType object_type)
{
	KlotskiWindow * self = NULL;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp0_;
	GtkCssProvider* _tmp1_;
	GdkScreen* _tmp2_;
	GtkCssProvider* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	GSettings* _tmp7_;
	GAction* _tmp8_;
	GSimpleAction* _tmp9_;
	GAction* _tmp10_;
	GSimpleAction* _tmp11_;
	GAction* _tmp12_;
	GSimpleAction* _tmp13_;
	GAction* _tmp14_;
	GSimpleAction* _tmp15_;
	GAction* _tmp16_;
	GSimpleAction* _tmp17_;
	GamesScoresHistoryFileImporter* _tmp18_;
	GamesScoresHistoryFileImporter* _tmp19_;
	GamesScoresContext* _tmp20_;
	GtkListStore* _tmp21_;
	GtkListStore* _tmp22_;
	GtkListStore* _tmp23_;
	GtkTreeIter* _tmp24_;
	GtkTreeView* _tmp67_;
	GtkListStore* _tmp68_;
	GtkTreeView* _tmp69_;
	GtkListStore* _tmp70_;
	GtkTreeView* _tmp71_;
	GtkListStore* _tmp72_;
	GtkTreeView* _tmp73_;
	GtkTreeView* _tmp74_;
	GtkTreeView* _tmp75_;
	PuzzleView* _tmp76_;
	PuzzleView* _tmp77_;
	PuzzleView* _tmp78_;
	PuzzleView* _tmp79_;
	PuzzleView* _tmp80_;
	GSettings* _tmp81_;
	GtkPopover* _tmp82_;
	self = (KlotskiWindow*) g_object_new (object_type, NULL);
	_tmp0_ = gtk_css_provider_new ();
	css_provider = _tmp0_;
	_tmp1_ = css_provider;
	gtk_css_provider_load_from_resource (_tmp1_, "/org/gnome/klotski/ui/klotski.css");
	_tmp2_ = gdk_screen_get_default ();
	_tmp3_ = css_provider;
	gtk_style_context_add_provider_for_screen (_tmp2_, (GtkStyleProvider*) _tmp3_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp4_ = g_settings_new ("org.gnome.klotski");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp4_;
	_tmp5_ = self->priv->settings;
	_tmp6_ = self->priv->settings;
	gtk_window_set_default_size ((GtkWindow*) self, g_settings_get_int (_tmp5_, "window-width"), g_settings_get_int (_tmp6_, "window-height"));
	_tmp7_ = self->priv->settings;
	if (g_settings_get_boolean (_tmp7_, "window-is-maximized")) {
		gtk_window_maximize ((GtkWindow*) self);
	}
	g_action_map_add_action_entries ((GActionMap*) self, KLOTSKI_WINDOW_win_actions, G_N_ELEMENTS (KLOTSKI_WINDOW_win_actions), self);
	_tmp8_ = g_action_map_lookup_action ((GActionMap*) self, "prev-pack");
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp8_) : NULL);
	_g_object_unref0 (self->priv->prev_pack);
	self->priv->prev_pack = _tmp9_;
	_tmp10_ = g_action_map_lookup_action ((GActionMap*) self, "next-pack");
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp10_) : NULL);
	_g_object_unref0 (self->priv->next_pack);
	self->priv->next_pack = _tmp11_;
	_tmp12_ = g_action_map_lookup_action ((GActionMap*) self, "prev-puzzle");
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp12_) : NULL);
	_g_object_unref0 (self->priv->prev_puzzle);
	self->priv->prev_puzzle = _tmp13_;
	_tmp14_ = g_action_map_lookup_action ((GActionMap*) self, "next-puzzle");
	_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp14_) : NULL);
	_g_object_unref0 (self->priv->next_puzzle);
	self->priv->next_puzzle = _tmp15_;
	_tmp16_ = g_action_map_lookup_action ((GActionMap*) self, "start-game");
	_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp16_) : NULL);
	_g_object_unref0 (self->priv->start_game);
	self->priv->start_game = _tmp17_;
	_tmp18_ = games_scores_history_file_importer_new (_klotski_window_parse_old_score_games_scores_history_file_importer_history_convert_func, self);
	_tmp19_ = _tmp18_;
	_tmp20_ = games_scores_context_new_with_importer ("gnome-klotski", _ ("Puzzle"), (GtkWindow*) self, _klotski_window_category_request_games_scores_context_category_request_func, self, GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER, (GamesScoresImporter*) _tmp19_);
	_g_object_unref0 (self->priv->scores_context);
	self->priv->scores_context = _tmp20_;
	_g_object_unref0 (_tmp19_);
	_tmp21_ = gtk_list_store_new (4, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_INT, G_TYPE_BOOLEAN, -1);
	_g_object_unref0 (self->priv->liststore_huarong);
	self->priv->liststore_huarong = _tmp21_;
	_tmp22_ = gtk_list_store_new (4, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_INT, G_TYPE_BOOLEAN, -1);
	_g_object_unref0 (self->priv->liststore_challenge);
	self->priv->liststore_challenge = _tmp22_;
	_tmp23_ = gtk_list_store_new (4, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_INT, G_TYPE_BOOLEAN, -1);
	_g_object_unref0 (self->priv->liststore_skill);
	self->priv->liststore_skill = _tmp23_;
	_tmp24_ = g_new0 (GtkTreeIter, G_N_ELEMENTS (KLOTSKI_WINDOW_levels));
	self->priv->puzzles_items = (g_free (self->priv->puzzles_items), NULL);
	self->priv->puzzles_items = _tmp24_;
	self->priv->puzzles_items_length1 = G_N_ELEMENTS (KLOTSKI_WINDOW_levels);
	self->priv->_puzzles_items_size_ = self->priv->puzzles_items_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp25_ = FALSE;
			_tmp25_ = TRUE;
			while (TRUE) {
				gint _tmp27_;
				gint _tmp28_;
				LevelInfo _tmp29_;
				gint _tmp30_;
				if (!_tmp25_) {
					gint _tmp26_;
					_tmp26_ = i;
					i = _tmp26_ + 1;
				}
				_tmp25_ = FALSE;
				_tmp27_ = i;
				if (!(_tmp27_ < G_N_ELEMENTS (KLOTSKI_WINDOW_levels))) {
					break;
				}
				_tmp28_ = i;
				_tmp29_ = KLOTSKI_WINDOW_levels[_tmp28_];
				_tmp30_ = _tmp29_.group;
				switch (_tmp30_) {
					case 0:
					{
						GtkListStore* _tmp31_;
						GtkTreeIter* _tmp32_;
						gint _tmp32__length1;
						gint _tmp33_;
						GtkTreeIter _tmp34_ = {0};
						GtkListStore* _tmp35_;
						GtkTreeIter* _tmp36_;
						gint _tmp36__length1;
						gint _tmp37_;
						GtkTreeIter _tmp38_;
						gint _tmp39_;
						LevelInfo _tmp40_;
						const gchar* _tmp41_;
						gint _tmp42_;
						_tmp31_ = self->priv->liststore_huarong;
						_tmp32_ = self->priv->puzzles_items;
						_tmp32__length1 = self->priv->puzzles_items_length1;
						_tmp33_ = i;
						gtk_list_store_append (_tmp31_, &_tmp34_);
						_tmp32_[_tmp33_] = _tmp34_;
						_tmp35_ = self->priv->liststore_huarong;
						_tmp36_ = self->priv->puzzles_items;
						_tmp36__length1 = self->priv->puzzles_items_length1;
						_tmp37_ = i;
						_tmp38_ = _tmp36_[_tmp37_];
						_tmp39_ = i;
						_tmp40_ = KLOTSKI_WINDOW_levels[_tmp39_];
						_tmp41_ = _tmp40_.name;
						_tmp42_ = i;
						gtk_list_store_set (_tmp35_, &_tmp38_, 0, _ (_tmp41_), 1, FALSE, 2, _tmp42_, 3, FALSE, -1);
						break;
					}
					case 1:
					{
						GtkListStore* _tmp43_;
						GtkTreeIter* _tmp44_;
						gint _tmp44__length1;
						gint _tmp45_;
						GtkTreeIter _tmp46_ = {0};
						GtkListStore* _tmp47_;
						GtkTreeIter* _tmp48_;
						gint _tmp48__length1;
						gint _tmp49_;
						GtkTreeIter _tmp50_;
						gint _tmp51_;
						LevelInfo _tmp52_;
						const gchar* _tmp53_;
						gint _tmp54_;
						_tmp43_ = self->priv->liststore_challenge;
						_tmp44_ = self->priv->puzzles_items;
						_tmp44__length1 = self->priv->puzzles_items_length1;
						_tmp45_ = i;
						gtk_list_store_append (_tmp43_, &_tmp46_);
						_tmp44_[_tmp45_] = _tmp46_;
						_tmp47_ = self->priv->liststore_challenge;
						_tmp48_ = self->priv->puzzles_items;
						_tmp48__length1 = self->priv->puzzles_items_length1;
						_tmp49_ = i;
						_tmp50_ = _tmp48_[_tmp49_];
						_tmp51_ = i;
						_tmp52_ = KLOTSKI_WINDOW_levels[_tmp51_];
						_tmp53_ = _tmp52_.name;
						_tmp54_ = i;
						gtk_list_store_set (_tmp47_, &_tmp50_, 0, _ (_tmp53_), 1, FALSE, 2, _tmp54_, 3, FALSE, -1);
						break;
					}
					case 2:
					{
						GtkListStore* _tmp55_;
						GtkTreeIter* _tmp56_;
						gint _tmp56__length1;
						gint _tmp57_;
						GtkTreeIter _tmp58_ = {0};
						GtkListStore* _tmp59_;
						GtkTreeIter* _tmp60_;
						gint _tmp60__length1;
						gint _tmp61_;
						GtkTreeIter _tmp62_;
						gint _tmp63_;
						LevelInfo _tmp64_;
						const gchar* _tmp65_;
						gint _tmp66_;
						_tmp55_ = self->priv->liststore_skill;
						_tmp56_ = self->priv->puzzles_items;
						_tmp56__length1 = self->priv->puzzles_items_length1;
						_tmp57_ = i;
						gtk_list_store_append (_tmp55_, &_tmp58_);
						_tmp56_[_tmp57_] = _tmp58_;
						_tmp59_ = self->priv->liststore_skill;
						_tmp60_ = self->priv->puzzles_items;
						_tmp60__length1 = self->priv->puzzles_items_length1;
						_tmp61_ = i;
						_tmp62_ = _tmp60_[_tmp61_];
						_tmp63_ = i;
						_tmp64_ = KLOTSKI_WINDOW_levels[_tmp63_];
						_tmp65_ = _tmp64_.name;
						_tmp66_ = i;
						gtk_list_store_set (_tmp59_, &_tmp62_, 0, _ (_tmp65_), 1, FALSE, 2, _tmp66_, 3, FALSE, -1);
						break;
					}
					default:
					break;
				}
			}
		}
	}
	_tmp67_ = self->priv->treeview_huarong;
	_tmp68_ = self->priv->liststore_huarong;
	gtk_tree_view_set_model (_tmp67_, (GtkTreeModel*) _tmp68_);
	_tmp69_ = self->priv->treeview_challenge;
	_tmp70_ = self->priv->liststore_challenge;
	gtk_tree_view_set_model (_tmp69_, (GtkTreeModel*) _tmp70_);
	_tmp71_ = self->priv->treeview_skill;
	_tmp72_ = self->priv->liststore_skill;
	gtk_tree_view_set_model (_tmp71_, (GtkTreeModel*) _tmp72_);
	_tmp73_ = self->priv->treeview_huarong;
	g_signal_connect_object (_tmp73_, "row-activated", (GCallback) _klotski_window_level_huarong_cb_gtk_tree_view_row_activated, self, 0);
	_tmp74_ = self->priv->treeview_challenge;
	g_signal_connect_object (_tmp74_, "row-activated", (GCallback) _klotski_window_level_challenge_cb_gtk_tree_view_row_activated, self, 0);
	_tmp75_ = self->priv->treeview_skill;
	g_signal_connect_object (_tmp75_, "row-activated", (GCallback) _klotski_window_level_skill_cb_gtk_tree_view_row_activated, self, 0);
	_tmp76_ = puzzle_view_new ();
	g_object_ref_sink (_tmp76_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp76_;
	_tmp77_ = self->priv->view;
	gtk_widget_set_halign ((GtkWidget*) _tmp77_, GTK_ALIGN_FILL);
	_tmp78_ = self->priv->view;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp78_, TRUE);
	_tmp79_ = self->priv->view;
	gtk_widget_show ((GtkWidget*) _tmp79_);
	_tmp80_ = self->priv->view;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp80_);
	klotski_window_load_solved_state (self);
	_tmp81_ = self->priv->settings;
	self->priv->current_level = CLAMP (g_settings_get_int (_tmp81_, KLOTSKI_WINDOW_KEY_LEVEL), 0, G_N_ELEMENTS (KLOTSKI_WINDOW_levels) - 1);
	_tmp82_ = self->priv->puzzles_popover;
	g_signal_connect_object ((GtkWidget*) _tmp82_, "show", (GCallback) ___lambda5__gtk_widget_show, self, 0);
	klotski_window_update_popover (self, TRUE);
	klotski_window_start_puzzle (self);
	_g_object_unref0 (css_provider);
	return self;
}


KlotskiWindow*
klotski_window_new (void)
{
	return klotski_window_construct (TYPE_KLOTSKI_WINDOW);
}


static void
klotski_window_on_size_allocate (KlotskiWindow* self,
                                 GtkAllocation* allocation)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (allocation != NULL);
	_tmp1_ = self->priv->window_is_maximized;
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_;
		_tmp2_ = self->priv->is_tiled;
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		return;
	}
	gtk_window_get_size ((GtkWindow*) self, &_tmp3_, &_tmp4_);
	self->priv->window_width = _tmp3_;
	self->priv->window_height = _tmp4_;
}


static void
_klotski_window_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender,
                                                           GtkAllocation* allocation,
                                                           gpointer self)
{
	klotski_window_on_size_allocate ((KlotskiWindow*) self, allocation);
}


static gboolean
klotski_window_on_window_state_event (KlotskiWindow* self,
                                      GdkEventWindowState* event)
{
	gboolean result = FALSE;
	GdkWindowState _tmp0_;
	GdkWindowState _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event->changed_mask;
	if ((_tmp0_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		GdkWindowState _tmp1_;
		_tmp1_ = event->new_window_state;
		self->priv->window_is_maximized = (_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	_tmp2_ = event->changed_mask;
	if ((_tmp2_ & GDK_WINDOW_STATE_TILED) != 0) {
		GdkWindowState _tmp3_;
		_tmp3_ = event->new_window_state;
		self->priv->is_tiled = (_tmp3_ & GDK_WINDOW_STATE_TILED) != 0;
	}
	result = FALSE;
	return result;
}


static gboolean
_klotski_window_on_window_state_event_gtk_widget_window_state_event (GtkWidget* _sender,
                                                                     GdkEventWindowState* event,
                                                                     gpointer self)
{
	gboolean result;
	result = klotski_window_on_window_state_event ((KlotskiWindow*) self, event);
	return result;
}


static void
klotski_window_on_destroy (KlotskiWindow* self)
{
	GSettings* _tmp0_;
	gint _tmp1_;
	GSettings* _tmp2_;
	gint _tmp3_;
	GSettings* _tmp4_;
	gint _tmp5_;
	GSettings* _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = self->priv->current_level;
	g_settings_set_int (_tmp0_, KLOTSKI_WINDOW_KEY_LEVEL, _tmp1_);
	_tmp2_ = self->priv->settings;
	_tmp3_ = self->priv->window_width;
	g_settings_set_int (_tmp2_, "window-width", _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = self->priv->window_height;
	g_settings_set_int (_tmp4_, "window-height", _tmp5_);
	_tmp6_ = self->priv->settings;
	_tmp7_ = self->priv->window_is_maximized;
	g_settings_set_boolean (_tmp6_, "window-is-maximized", _tmp7_);
}


static void
_klotski_window_on_destroy_gtk_widget_destroy (GtkWidget* _sender,
                                               gpointer self)
{
	klotski_window_on_destroy ((KlotskiWindow*) self);
}


static void
klotski_window_prev_pack_cb (KlotskiWindow* self)
{
	GtkPopover* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->puzzles_popover;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->current_pack;
	self->priv->current_pack = _tmp3_ - 1;
	klotski_window_update_popover (self, FALSE);
}


static void
klotski_window_next_pack_cb (KlotskiWindow* self)
{
	GtkPopover* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->puzzles_popover;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->current_pack;
	self->priv->current_pack = _tmp3_ + 1;
	klotski_window_update_popover (self, FALSE);
}


static void
klotski_window_prev_puzzle_cb (KlotskiWindow* self)
{
	GtkPopover* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->puzzles_popover;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->current_level;
	self->priv->current_level = _tmp3_ - 1;
	klotski_window_update_popover (self, TRUE);
	klotski_window_start_puzzle (self);
}


static void
klotski_window_next_puzzle_cb (KlotskiWindow* self)
{
	GtkPopover* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->puzzles_popover;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->current_level;
	self->priv->current_level = _tmp3_ + 1;
	klotski_window_update_popover (self, TRUE);
	klotski_window_start_puzzle (self);
}


static void
klotski_window_start_puzzle_cb (KlotskiWindow* self)
{
	GtkTreeView* tree = NULL;
	GtkStack* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	gint _tmp3_;
	gconstpointer _tmp4_;
	GtkWidget* _tmp5_;
	GtkTreeView* _tmp6_;
	GtkTreeView* _tmp7_;
	GtkTreeModel* model = NULL;
	GtkTreeView* _tmp8_;
	GtkTreeModel* _tmp9_;
	GtkTreeModel* _tmp10_;
	GtkTreeIter iter = {0};
	GtkTreeView* _tmp11_;
	GtkTreeSelection* _tmp12_;
	GtkTreeModel* _tmp13_ = NULL;
	GtkTreeIter _tmp14_ = {0};
	gboolean _tmp15_;
	GtkTreeModel* _tmp16_;
	GtkPopover* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack_puzzles;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->current_pack;
	_tmp4_ = g_list_nth_data (_tmp2_, (guint) _tmp3_);
	_tmp5_ = gtk_bin_get_child ((GtkBin*) G_TYPE_CHECK_INSTANCE_CAST ((GtkWidget*) _tmp4_, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_tree_view_get_type (), GtkTreeView));
	_tmp7_ = _tmp6_;
	_g_list_free0 (_tmp2_);
	tree = _tmp7_;
	_tmp8_ = tree;
	_tmp9_ = gtk_tree_view_get_model (_tmp8_);
	_tmp10_ = _g_object_ref0 (_tmp9_);
	model = _tmp10_;
	_tmp11_ = tree;
	_tmp12_ = gtk_tree_view_get_selection (_tmp11_);
	_tmp15_ = gtk_tree_selection_get_selected (_tmp12_, &_tmp13_, &_tmp14_);
	_g_object_unref0 (model);
	_tmp16_ = _g_object_ref0 (_tmp13_);
	model = _tmp16_;
	iter = _tmp14_;
	if (_tmp15_) {
		GtkTreeModel* _tmp17_;
		GtkTreeIter _tmp18_;
		_tmp17_ = model;
		_tmp18_ = iter;
		klotski_window_start_puzzle_from_iter (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_list_store_get_type (), GtkListStore), &_tmp18_);
	} else {
		klotski_window_start_puzzle (self);
	}
	_tmp19_ = self->priv->puzzles_popover;
	gtk_widget_hide ((GtkWidget*) _tmp19_);
	_g_object_unref0 (model);
	_g_object_unref0 (tree);
}


static void
klotski_window_update_popover (KlotskiWindow* self,
                               gboolean make_current)
{
	gint current_level_pack = 0;
	GtkTreeIter iter = {0};
	GtkTreeIter* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	GtkTreeIter _tmp2_;
	GtkListStore* _tmp3_;
	GtkTreeIter _tmp4_;
	GtkTreeSelection* selection = NULL;
	GtkStack* _tmp8_;
	GList* _tmp9_;
	GList* _tmp10_;
	gint _tmp11_;
	gconstpointer _tmp12_;
	GtkWidget* _tmp13_;
	GtkTreeSelection* _tmp14_;
	GtkTreeSelection* _tmp15_;
	GtkTreeSelection* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	GtkStack* _tmp22_;
	GtkStack* _tmp23_;
	GList* _tmp24_;
	GList* _tmp25_;
	gint _tmp26_;
	gconstpointer _tmp27_;
	GtkStack* _tmp28_;
	GtkStack* _tmp29_;
	GList* _tmp30_;
	GList* _tmp31_;
	gint _tmp32_;
	gconstpointer _tmp33_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->puzzles_items;
	_tmp0__length1 = self->priv->puzzles_items_length1;
	_tmp1_ = self->priv->current_level;
	_tmp2_ = _tmp0_[_tmp1_];
	iter = _tmp2_;
	_tmp3_ = self->priv->liststore_huarong;
	_tmp4_ = iter;
	if (gtk_list_store_iter_is_valid (_tmp3_, &_tmp4_)) {
		current_level_pack = 0;
	} else {
		GtkListStore* _tmp5_;
		GtkTreeIter _tmp6_;
		_tmp5_ = self->priv->liststore_challenge;
		_tmp6_ = iter;
		if (gtk_list_store_iter_is_valid (_tmp5_, &_tmp6_)) {
			current_level_pack = 1;
		} else {
			current_level_pack = 2;
		}
	}
	if (make_current) {
		gint _tmp7_;
		_tmp7_ = current_level_pack;
		self->priv->current_pack = _tmp7_;
	}
	_tmp8_ = self->priv->stack_puzzles;
	_tmp9_ = gtk_container_get_children ((GtkContainer*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->current_pack;
	_tmp12_ = g_list_nth_data (_tmp10_, (guint) _tmp11_);
	_tmp13_ = gtk_bin_get_child ((GtkBin*) G_TYPE_CHECK_INSTANCE_CAST ((GtkWidget*) _tmp12_, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp14_ = gtk_tree_view_get_selection (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_tree_view_get_type (), GtkTreeView));
	_tmp15_ = _g_object_ref0 (_tmp14_);
	_tmp16_ = _tmp15_;
	_g_list_free0 (_tmp10_);
	selection = _tmp16_;
	_tmp17_ = self->priv->current_pack;
	_tmp18_ = current_level_pack;
	if (_tmp17_ == _tmp18_) {
		GtkTreeSelection* _tmp19_;
		GtkTreeIter _tmp20_;
		_tmp19_ = selection;
		_tmp20_ = iter;
		gtk_tree_selection_select_iter (_tmp19_, &_tmp20_);
	} else {
		GtkTreeSelection* _tmp21_;
		_tmp21_ = selection;
		gtk_tree_selection_unselect_all (_tmp21_);
	}
	klotski_window_update_buttons_state (self);
	_tmp22_ = self->priv->stack_packs;
	_tmp23_ = self->priv->stack_packs;
	_tmp24_ = gtk_container_get_children ((GtkContainer*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = self->priv->current_pack;
	_tmp27_ = g_list_nth_data (_tmp25_, (guint) _tmp26_);
	gtk_stack_set_visible_child (_tmp22_, (GtkWidget*) _tmp27_);
	_g_list_free0 (_tmp25_);
	_tmp28_ = self->priv->stack_puzzles;
	_tmp29_ = self->priv->stack_puzzles;
	_tmp30_ = gtk_container_get_children ((GtkContainer*) _tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = self->priv->current_pack;
	_tmp33_ = g_list_nth_data (_tmp31_, (guint) _tmp32_);
	gtk_stack_set_visible_child (_tmp28_, (GtkWidget*) _tmp33_);
	_g_list_free0 (_tmp31_);
	_g_object_unref0 (selection);
}


static void
klotski_window_update_buttons_state (KlotskiWindow* self)
{
	GSimpleAction* _tmp0_;
	gint _tmp1_;
	GSimpleAction* _tmp2_;
	gint _tmp3_;
	GSimpleAction* _tmp4_;
	gint _tmp5_;
	GSimpleAction* _tmp6_;
	gint _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->prev_pack;
	_tmp1_ = self->priv->current_pack;
	g_simple_action_set_enabled (_tmp0_, _tmp1_ > 0);
	_tmp2_ = self->priv->next_pack;
	_tmp3_ = self->priv->current_pack;
	g_simple_action_set_enabled (_tmp2_, _tmp3_ < 2);
	_tmp4_ = self->priv->prev_puzzle;
	_tmp5_ = self->priv->current_level;
	g_simple_action_set_enabled (_tmp4_, _tmp5_ > 0);
	_tmp6_ = self->priv->next_puzzle;
	_tmp7_ = self->priv->current_level;
	g_simple_action_set_enabled (_tmp6_, _tmp7_ < (G_N_ELEMENTS (KLOTSKI_WINDOW_levels) - 1));
}


static void
klotski_window_level_huarong_cb (KlotskiWindow* self,
                                 GtkTreePath* path,
                                 GtkTreeViewColumn* column)
{
	GtkListStore* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	_tmp0_ = self->priv->liststore_huarong;
	klotski_window_level_cb (self, _tmp0_, path, column);
}


static void
klotski_window_level_challenge_cb (KlotskiWindow* self,
                                   GtkTreePath* path,
                                   GtkTreeViewColumn* column)
{
	GtkListStore* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	_tmp0_ = self->priv->liststore_challenge;
	klotski_window_level_cb (self, _tmp0_, path, column);
}


static void
klotski_window_level_skill_cb (KlotskiWindow* self,
                               GtkTreePath* path,
                               GtkTreeViewColumn* column)
{
	GtkListStore* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	_tmp0_ = self->priv->liststore_skill;
	klotski_window_level_cb (self, _tmp0_, path, column);
}


static void
klotski_window_level_cb (KlotskiWindow* self,
                         GtkListStore* liststore,
                         GtkTreePath* path,
                         GtkTreeViewColumn* column)
{
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	GtkTreeIter _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (liststore != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	gtk_tree_model_get_iter ((GtkTreeModel*) liststore, &_tmp0_, path);
	iter = _tmp0_;
	_tmp1_ = iter;
	klotski_window_start_puzzle_from_iter (self, liststore, &_tmp1_);
}


static void
klotski_window_start_puzzle_from_iter (KlotskiWindow* self,
                                       GtkListStore* model,
                                       GtkTreeIter* iter)
{
	GValue val = {0};
	GtkTreeIter _tmp0_;
	GValue _tmp1_ = {0};
	gint requested_level = 0;
	GValue _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	gtk_tree_model_get_value ((GtkTreeModel*) model, &_tmp0_, 2, &_tmp1_);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	val = _tmp1_;
	_tmp2_ = val;
	requested_level = g_value_get_int (&_tmp2_);
	_tmp3_ = requested_level;
	if (_tmp3_ < 0) {
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
		return;
	}
	_tmp4_ = requested_level;
	self->priv->current_level = _tmp4_;
	klotski_window_update_buttons_state (self);
	klotski_window_start_puzzle (self);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
}


static void
_klotski_window_puzzle_moved_cb_puzzle_moved (Puzzle* _sender,
                                              gpointer self)
{
	klotski_window_puzzle_moved_cb ((KlotskiWindow*) self);
}


static void
klotski_window_start_puzzle (KlotskiWindow* self)
{
	GtkHeaderBar* _tmp0_;
	gint _tmp1_;
	LevelInfo _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	LevelInfo _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	LevelInfo _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	LevelInfo _tmp11_;
	const gchar* _tmp12_;
	Puzzle* _tmp13_;
	Puzzle* _tmp14_;
	PuzzleView* _tmp15_;
	Puzzle* _tmp16_;
	GSimpleAction* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->headerbar;
	_tmp1_ = self->priv->current_level;
	_tmp2_ = KLOTSKI_WINDOW_levels[_tmp1_];
	_tmp3_ = _tmp2_.name;
	gtk_header_bar_set_title (_tmp0_, _ (_tmp3_));
	_tmp4_ = self->priv->current_level;
	_tmp5_ = KLOTSKI_WINDOW_levels[_tmp4_];
	_tmp6_ = _tmp5_.width;
	_tmp7_ = self->priv->current_level;
	_tmp8_ = KLOTSKI_WINDOW_levels[_tmp7_];
	_tmp9_ = _tmp8_.height;
	_tmp10_ = self->priv->current_level;
	_tmp11_ = KLOTSKI_WINDOW_levels[_tmp10_];
	_tmp12_ = _tmp11_.data;
	_tmp13_ = puzzle_new (_tmp6_, _tmp9_, _tmp12_);
	_g_object_unref0 (self->priv->puzzle);
	self->priv->puzzle = _tmp13_;
	_tmp14_ = self->priv->puzzle;
	g_signal_connect_object (_tmp14_, "moved", (GCallback) _klotski_window_puzzle_moved_cb_puzzle_moved, self, 0);
	_tmp15_ = self->priv->view;
	_tmp16_ = self->priv->puzzle;
	puzzle_view_set_puzzle (_tmp15_, _tmp16_);
	klotski_window_update_moves_label (self);
	_tmp17_ = self->priv->start_game;
	g_simple_action_set_enabled (_tmp17_, FALSE);
}


static void
klotski_window_puzzle_moved_cb (KlotskiWindow* self)
{
	g_return_if_fail (self != NULL);
	klotski_window_update_moves_label (self);
}


static void
klotski_window_update_moves_label (KlotskiWindow* self)
{
	GSimpleAction* _tmp0_;
	GtkHeaderBar* _tmp1_;
	Puzzle* _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	Puzzle* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->start_game;
	g_simple_action_set_enabled (_tmp0_, TRUE);
	_tmp1_ = self->priv->headerbar;
	_tmp2_ = self->priv->puzzle;
	_tmp3_ = _tmp2_->moves;
	_tmp4_ = g_strdup_printf (_ ("Moves: %d"), _tmp3_);
	_tmp5_ = _tmp4_;
	gtk_header_bar_set_subtitle (_tmp1_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->puzzle;
	if (puzzle_game_over (_tmp6_)) {
		GtkHeaderBar* _tmp7_;
		_tmp7_ = self->priv->headerbar;
		gtk_header_bar_set_title (_tmp7_, _ ("Level completed."));
		klotski_window_game_score (self);
	}
}


static void
__lambda4_ (KlotskiWindow* self,
            GObject* object,
            GAsyncResult* _result_)
{
	GError * _inner_error_ = NULL;
	g_return_if_fail (_result_ != NULL);
	{
		GamesScoresContext* _tmp0_;
		_tmp0_ = self->priv->scores_context;
		games_scores_context_add_score_finish (_tmp0_, _result_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("klotski-window.vala:830: Failed to add score: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void
___lambda4__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda4_ ((KlotskiWindow*) self, source_object, res);
	g_object_unref (self);
}


static void
klotski_window_game_score (KlotskiWindow* self)
{
	gchar* key = NULL;
	gint _tmp0_;
	gchar* _tmp1_;
	GKeyFile* keyfile = NULL;
	GKeyFile* _tmp2_;
	gchar* filename = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GtkTreeIter* _tmp7_;
	gint _tmp7__length1;
	gint _tmp8_;
	GtkTreeIter _tmp9_;
	GamesScoresContext* _tmp10_;
	Puzzle* _tmp11_;
	gint _tmp12_;
	GeeList* _tmp13_;
	gint _tmp14_;
	gpointer _tmp15_;
	GamesScoresCategory* _tmp16_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_level;
	_tmp1_ = klotski_window_get_level_key (self, _tmp0_);
	key = _tmp1_;
	_tmp2_ = g_key_file_new ();
	keyfile = _tmp2_;
	_tmp3_ = g_get_user_data_dir ();
	_tmp4_ = g_build_filename (_tmp3_, "gnome-klotski", "levels", NULL);
	filename = _tmp4_;
	{
		g_key_file_load_from_file (keyfile, filename, G_KEY_FILE_NONE, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (filename);
		_g_key_file_unref0 (keyfile);
		_g_free0 (key);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_key_file_set_boolean (keyfile, key, "solved", TRUE);
	{
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = g_key_file_to_data (keyfile, NULL, NULL);
		_tmp6_ = _tmp5_;
		g_file_set_contents (filename, _tmp6_, (gssize) -1, &_inner_error_);
		_g_free0 (_tmp6_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (filename);
		_g_key_file_unref0 (keyfile);
		_g_free0 (key);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = self->priv->puzzles_items;
	_tmp7__length1 = self->priv->puzzles_items_length1;
	_tmp8_ = self->priv->current_level;
	_tmp9_ = _tmp7_[_tmp8_];
	klotski_window_puzzle_solved (self, &_tmp9_, TRUE);
	_tmp10_ = self->priv->scores_context;
	_tmp11_ = self->priv->puzzle;
	_tmp12_ = _tmp11_->moves;
	_tmp13_ = klotski_window_score_categories;
	_tmp14_ = self->priv->current_level;
	_tmp15_ = gee_list_get (_tmp13_, _tmp14_);
	_tmp16_ = (GamesScoresCategory*) _tmp15_;
	games_scores_context_add_score (_tmp10_, (glong) _tmp12_, _tmp16_, NULL, ___lambda4__gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (_tmp16_);
	_g_free0 (filename);
	_g_key_file_unref0 (keyfile);
	_g_free0 (key);
}


void
klotski_window_show_scores (KlotskiWindow* self)
{
	GamesScoresContext* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scores_context;
	games_scores_context_run_dialog (_tmp0_);
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


static gchar*
klotski_window_get_level_key (KlotskiWindow* self,
                              gint level_number)
{
	gchar* result = NULL;
	guint32 _result_ = 0U;
	gchar* data = NULL;
	LevelInfo _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	guint32 _tmp18_;
	gchar* _tmp19_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = (guint32) 0xFFFFFFFFU;
	_tmp0_ = KLOTSKI_WINDOW_levels[level_number];
	_tmp1_ = _tmp0_.data;
	_tmp2_ = g_strdup (_tmp1_);
	data = _tmp2_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				const gchar* _tmp5_;
				gint _tmp6_;
				gchar octet = '\0';
				const gchar* _tmp7_;
				gint _tmp8_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = data;
				_tmp6_ = i;
				if (!(string_get (_tmp5_, (glong) _tmp6_) != '\0')) {
					break;
				}
				_tmp7_ = data;
				_tmp8_ = i;
				octet = string_get (_tmp7_, (glong) _tmp8_);
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp9_ = FALSE;
						_tmp9_ = TRUE;
						while (TRUE) {
							gint _tmp11_;
							gchar _tmp12_;
							guint32 _tmp13_;
							guint32 _tmp16_;
							gchar _tmp17_;
							if (!_tmp9_) {
								gint _tmp10_;
								_tmp10_ = j;
								j = _tmp10_ + 1;
							}
							_tmp9_ = FALSE;
							_tmp11_ = j;
							if (!(_tmp11_ < 8)) {
								break;
							}
							_tmp12_ = octet;
							_tmp13_ = _result_;
							if (((_tmp12_ >> 7) ^ (_tmp13_ >> 31)) != 0) {
								guint32 _tmp14_;
								_tmp14_ = _result_;
								_result_ = (_tmp14_ << 1) ^ 0x04c11db7;
							} else {
								guint32 _tmp15_;
								_tmp15_ = _result_;
								_result_ = _tmp15_ << 1;
							}
							_tmp16_ = _result_;
							_result_ = _tmp16_ & 0xFFFFFFFFLL;
							_tmp17_ = octet;
							octet = (gchar) (_tmp17_ << 1);
						}
					}
				}
			}
		}
	}
	_tmp18_ = _result_;
	_tmp19_ = g_strdup_printf ("%08X", (guint) (~_tmp18_));
	result = _tmp19_;
	_g_free0 (data);
	return result;
}


static void
klotski_window_load_solved_state (KlotskiWindow* self)
{
	GKeyFile* keyfile = NULL;
	GKeyFile* _tmp0_;
	gchar* filename = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_key_file_new ();
	keyfile = _tmp0_;
	_tmp1_ = g_get_user_data_dir ();
	_tmp2_ = g_build_filename (_tmp1_, "gnome-klotski", "levels", NULL);
	filename = _tmp2_;
	{
		g_key_file_load_from_file (keyfile, filename, G_KEY_FILE_NONE, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (filename);
		_g_key_file_unref0 (keyfile);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				gchar* key = NULL;
				gint _tmp6_;
				gchar* _tmp7_;
				gboolean value = FALSE;
				GtkTreeIter* _tmp10_;
				gint _tmp10__length1;
				gint _tmp11_;
				GtkTreeIter _tmp12_;
				gboolean _tmp13_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				if (!(_tmp5_ < G_N_ELEMENTS (KLOTSKI_WINDOW_levels))) {
					break;
				}
				_tmp6_ = i;
				_tmp7_ = klotski_window_get_level_key (self, _tmp6_);
				key = _tmp7_;
				value = FALSE;
				{
					gboolean _tmp8_ = FALSE;
					const gchar* _tmp9_;
					_tmp9_ = key;
					_tmp8_ = g_key_file_get_boolean (keyfile, _tmp9_, "solved", &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch6_g_error;
					}
					value = _tmp8_;
				}
				goto __finally6;
				__catch6_g_error:
				{
					GError* e = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (e);
				}
				__finally6:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_free0 (key);
					_g_free0 (filename);
					_g_key_file_unref0 (keyfile);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp10_ = self->priv->puzzles_items;
				_tmp10__length1 = self->priv->puzzles_items_length1;
				_tmp11_ = i;
				_tmp12_ = _tmp10_[_tmp11_];
				_tmp13_ = value;
				klotski_window_puzzle_solved (self, &_tmp12_, _tmp13_);
				_g_free0 (key);
			}
		}
	}
	_g_free0 (filename);
	_g_key_file_unref0 (keyfile);
}


static void
klotski_window_puzzle_solved (KlotskiWindow* self,
                              GtkTreeIter* iter,
                              gboolean solved)
{
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = self->priv->liststore_huarong;
	_tmp1_ = *iter;
	if (gtk_list_store_iter_is_valid (_tmp0_, &_tmp1_)) {
		GtkListStore* _tmp2_;
		GtkTreeIter _tmp3_;
		_tmp2_ = self->priv->liststore_huarong;
		_tmp3_ = *iter;
		gtk_list_store_set (_tmp2_, &_tmp3_, 1, solved, -1);
	} else {
		GtkListStore* _tmp4_;
		GtkTreeIter _tmp5_;
		_tmp4_ = self->priv->liststore_challenge;
		_tmp5_ = *iter;
		if (gtk_list_store_iter_is_valid (_tmp4_, &_tmp5_)) {
			GtkListStore* _tmp6_;
			GtkTreeIter _tmp7_;
			_tmp6_ = self->priv->liststore_challenge;
			_tmp7_ = *iter;
			gtk_list_store_set (_tmp6_, &_tmp7_, 1, solved, -1);
		} else {
			GtkListStore* _tmp8_;
			GtkTreeIter _tmp9_;
			_tmp8_ = self->priv->liststore_skill;
			_tmp9_ = *iter;
			gtk_list_store_set (_tmp8_, &_tmp9_, 1, solved, -1);
		}
	}
}


static void
klotski_window_base_init (KlotskiWindowClass * klass)
{
	GeeArrayList* _tmp0_;
	_tmp0_ = gee_array_list_new (GAMES_SCORES_TYPE_CATEGORY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (klotski_window_score_categories);
	klotski_window_score_categories = (GeeList*) _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				GeeList* _tmp4_;
				gint _tmp5_;
				LevelInfo _tmp6_;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				gint _tmp10_;
				LevelInfo _tmp11_;
				const gchar* _tmp12_;
				GamesScoresCategory* _tmp13_;
				GamesScoresCategory* _tmp14_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				if (!(_tmp3_ < G_N_ELEMENTS (KLOTSKI_WINDOW_levels))) {
					break;
				}
				_tmp4_ = klotski_window_score_categories;
				_tmp5_ = i;
				_tmp6_ = KLOTSKI_WINDOW_levels[_tmp5_];
				_tmp7_ = _tmp6_.name;
				_tmp8_ = klotski_window_normalize_map_name (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = i;
				_tmp11_ = KLOTSKI_WINDOW_levels[_tmp10_];
				_tmp12_ = _tmp11_.name;
				_tmp13_ = games_scores_category_new (_tmp9_, _ (_tmp12_));
				_tmp14_ = _tmp13_;
				gee_collection_add ((GeeCollection*) _tmp4_, _tmp14_);
				_g_object_unref0 (_tmp14_);
				_g_free0 (_tmp9_);
			}
		}
	}
}


static void
klotski_window_class_init (KlotskiWindowClass * klass)
{
	gint KlotskiWindow_private_offset;
	klotski_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KlotskiWindowPrivate));
	G_OBJECT_CLASS (klass)->finalize = klotski_window_finalize;
	KlotskiWindow_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/klotski/ui/klotski.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "headerbar", FALSE, KlotskiWindow_private_offset + G_STRUCT_OFFSET (KlotskiWindowPrivate, headerbar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack_packs", FALSE, KlotskiWindow_private_offset + G_STRUCT_OFFSET (KlotskiWindowPrivate, stack_packs));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack_puzzles", FALSE, KlotskiWindow_private_offset + G_STRUCT_OFFSET (KlotskiWindowPrivate, stack_puzzles));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "puzzles_popover", FALSE, KlotskiWindow_private_offset + G_STRUCT_OFFSET (KlotskiWindowPrivate, puzzles_popover));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "treeview_huarong", FALSE, KlotskiWindow_private_offset + G_STRUCT_OFFSET (KlotskiWindowPrivate, treeview_huarong));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "treeview_challenge", FALSE, KlotskiWindow_private_offset + G_STRUCT_OFFSET (KlotskiWindowPrivate, treeview_challenge));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "treeview_skill", FALSE, KlotskiWindow_private_offset + G_STRUCT_OFFSET (KlotskiWindowPrivate, treeview_skill));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_size_allocate", G_CALLBACK(_klotski_window_on_size_allocate_gtk_widget_size_allocate));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_window_state_event", G_CALLBACK(_klotski_window_on_window_state_event_gtk_widget_window_state_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_destroy", G_CALLBACK(_klotski_window_on_destroy_gtk_widget_destroy));
}


static void
klotski_window_instance_init (KlotskiWindow * self)
{
	self->priv = KLOTSKI_WINDOW_GET_PRIVATE (self);
	self->priv->current_pack = -1;
	self->priv->current_level = -1;
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void
klotski_window_finalize (GObject * obj)
{
	KlotskiWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_KLOTSKI_WINDOW, KlotskiWindow);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->headerbar);
	_g_object_unref0 (self->priv->stack_packs);
	_g_object_unref0 (self->priv->stack_puzzles);
	_g_object_unref0 (self->priv->puzzles_popover);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->treeview_huarong);
	_g_object_unref0 (self->priv->treeview_challenge);
	_g_object_unref0 (self->priv->treeview_skill);
	_g_object_unref0 (self->priv->prev_pack);
	_g_object_unref0 (self->priv->next_pack);
	_g_object_unref0 (self->priv->prev_puzzle);
	_g_object_unref0 (self->priv->next_puzzle);
	_g_object_unref0 (self->priv->start_game);
	_g_object_unref0 (self->priv->puzzle);
	_g_object_unref0 (self->priv->scores_context);
	_g_object_unref0 (self->priv->liststore_huarong);
	_g_object_unref0 (self->priv->liststore_challenge);
	_g_object_unref0 (self->priv->liststore_skill);
	self->priv->puzzles_items = (g_free (self->priv->puzzles_items), NULL);
	G_OBJECT_CLASS (klotski_window_parent_class)->finalize (obj);
}


GType
klotski_window_get_type (void)
{
	static volatile gsize klotski_window_type_id__volatile = 0;
	if (g_once_init_enter (&klotski_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KlotskiWindowClass), (GBaseInitFunc) klotski_window_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) klotski_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KlotskiWindow), 0, (GInstanceInitFunc) klotski_window_instance_init, NULL };
		GType klotski_window_type_id;
		klotski_window_type_id = g_type_register_static (gtk_application_window_get_type (), "KlotskiWindow", &g_define_type_info, 0);
		g_once_init_leave (&klotski_window_type_id__volatile, klotski_window_type_id);
	}
	return klotski_window_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



