-------------------------------------------------------------------------------
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/dbi/adbc/gnu-db-adbc-sql_helper.adb,v $
--  Description     : ADBC SQL Helper package                                --
--  Author          : <a>Michael Erdmann</a>                                 --
--  Created         : 18.1.2002                                              --
--  Last Modified By: $Author: merdmann $
--  Last Modified On: <d>$Date: 2002/03/22 20:57:28 $
--  Version         : $Revision: 1.4 $
--  Status          : $State: Exp $</d>
--                                                                           --
--  Copyright (C) 2001 Michael Erdmann                                       --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  This software is implemented to work with GNAT, the GNU Ada compiler.    --
--  <p>                                                                      --
--  Functional Description                                                   --
--  ======================                                                   --
--  This is the top level package of the ADO objects. It contains the basic  --
--  reference types for connections, statements and resultsets. </p>         --
--                                                                           --
--                                                                           --
--                                                                           --
--  Restrictions                                                             --
--  ============                                                             --
--  Only Linux                                                               --
--                                                                           --
--  Contact                                                                  --
--  =======                                                                  --
--  Error reports shall be handled via http://gnade.sourceforge.net          --
--  Features and ideas via: gnade-develop@lists.sourceforge.net              --
--                                                                           --
--  Author contact:                                                          --
--               purl:/net/michael.erdmann                                   --
--                                                                           --
-------------------------------------------------------------------------------
with Unchecked_Deallocation;
with Ada.Text_IO;                        use Ada.Text_IO;
with GNU.DB.Support.List.Strings;        use GNU.DB.Support.List.Strings;

package body GNU.DB.ADBC.SQL_Helper is

   Version : constant String :=
      "$Id: gnu-db-adbc-sql_helper.adb,v 1.4 2002/03/22 20:57:28 merdmann Exp $";

   --- ***************************************************************** ---
   --- ****                                                         **** ---
   --- ****           L I S T   O F    R E L A T I O N S            **** ---
   --- ****                                                         **** ---
   --- ***************************************************************** ---

   -------------------
   -- To_Table_Name --
   -------------------
   function To_Table_Name(
      Name   : in String ) return List_Element_Access is
   begin
      return  To_String_List_Element('"' & Name & '"');
   end To_Table_Name;

   -------------------
   -- To_Domain_Name --
   -------------------
   function To_Domain_Name(
      Name   : in String ) return List_Element_Access is
   begin
      return To_String_List_Element('"' & Name & '"');
   end To_Domain_Name;

   --- ***************************************************************** ---
   --- ****                                                         **** ---
   --- ****        S Q L   H E L P E R    F U N C T I O N S         **** ---
   --- ****                                                         **** ---
   --- ***************************************************************** ---

   ----------------
   -- SQL_Select --
   ----------------
   function SQL_Select(
      Table     : in List_Element_Access;
      Fields    : in String := "*";
      Condition : in String := "" ) return String is

      SQL_Query : constant String :=
                    "SELECT " & Fields &
                    " FROM "  & List.Strings.To_String(Table);
   begin
      Destroy( Table );

      if Condition /= "" then
         return SQL_Query & " WHERE " & Condition;
      end if;

      return SQL_Query;
   end SQL_Select;

   ----------------
   -- SQL_Insert --
   ----------------
   function SQL_Insert(
      Table     : in String := "";
      Fields    : in List_Element_Access := null;
      Data      : in List_Element_Access := null ) return String is
   begin
      return "";
   end SQL_Insert;

end GNU.DB.ADBC.SQL_Helper;

