
import gobject
import gtk

import glitch, glitch.gtk
from glitch.limbo.lights import LightSwitch, AmbientLight
from glitch.limbo.material import Material
from glitch.limbo.objects import Cube

def tick():
    global theta
    theta = (theta + 5) % 360
    rotate.angle = theta
    view1.refresh()
    view2.refresh()
    view3.refresh()
    return True

if __name__ == '__main__':
    theta = 0
    rotate = glitch.Rotate(y=1, children=[Cube()])
    scene = LightSwitch(children=[
        AmbientLight(2, 2, 2, children=[
            Material(1.0, 0.5, 0.5, children=[rotate])])])

    w = gtk.Window()
    box = gtk.HBox()
    box.props.spacing = 1
    # XXX: views don't share textures
    view1 = glitch.gtk.GtkCamera(eye=[0, 0, 2], children=[scene])
    view2 = glitch.gtk.GtkCamera(eye=[0, 2, 0.01], children=[scene])
    view3 = glitch.gtk.GtkCamera(eye=[1.5, 1.5, 1.5], children=[scene])

    w.add(box)
    box.pack_start(view1, True)
    box.pack_start(view2, True)
    box.pack_start(view3, True)
    w.show_all()

    gobject.timeout_add(1000/30, tick)
    w.connect('destroy', lambda w: gtk.main_quit())
    gtk.main()

