/*
 *  
 *  $Id: parametrosprincipales.cpp $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-14 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <vector>
#include <sstream>

#include <wx/file.h>
#include <wx/dir.h>
#include <wx/dirdlg.h>
#include <wx/msgdlg.h>
#include <main/controllers/configurationcontroller.h>
#include <wx/msgout.h>
#include <wx/filename.h>
#include <wx/propgrid/propgrid.h>
#include <wx/ginkgostyle/ginkgostyle.h>

#include "parametrosprincipales.h"

#include <api/ientorno.h>
#include <api/ivista.h>
#include <api/controllers/ipacscontroller.h>
#include <api/dicom/idicommanager.h>
#include <api/internationalization/internationalization.h>

#include <main/controllers/commandcontroller.h>

#include <commands/comandoexportacion.h>
#include <api/istudycontext.h>


namespace GNC {
	namespace GUI {

		ParametrosPrincipales::ParametrosPrincipales(wxWindow* pParent,IWizard* pWizard,GNC::GCS::Ptr<TipoWizardExportacion> pDatosPersistentes):ParametrosPrincipalesBase(pParent),IPasoWizard(pWizard)
		{
			m_pDatosPersistentes = pDatosPersistentes;
			
			//pillamos los mapas
			typedef GNC::GCS::IImageExportDelegate::TValorationMaps MapaMapasValoracion;
			m_pDatosPersistentes->m_mapasValoracion = m_pDatosPersistentes->m_pExportDelegate->GetValorationMaps();
			if(m_pDatosPersistentes->m_mapasValoracion.size() == 0) {
				m_pTituloMapas->Show(false);
				m_pMapasCheck->Show(false);
			} else {
				for(MapaMapasValoracion::iterator it= m_pDatosPersistentes->m_mapasValoracion.begin(); it!= m_pDatosPersistentes->m_mapasValoracion.end(); ++it) {
					int item = m_pMapasCheck->Append(wxString::FromUTF8((*it).first.c_str()));
					m_pMapasCheck->Check(item,(*it).second);
				}
			}

			int tmpInt;
			GNC::GCS::ConfigurationController::Instance()->readIntUser("/GinkgoCore/ImageExport", "Scope", tmpInt, 0);
			m_pOrigen->Select(tmpInt);

			GNC::GCS::ConfigurationController::Instance()->readIntUser("/GinkgoCore/ImageExport", "Format", tmpInt, 0);
			m_pFormatoDestino->SetSelection(tmpInt);
			wxCommandEvent evt;
			OnChoiceFormatoDestino(evt);

			bool tmpBool;
			GNC::GCS::ConfigurationController::Instance()->readBoolUser("/GinkgoCore/ImageExport", "AnnotationWidgets", tmpBool, false);
			m_pIncluirWidgets->SetValue(tmpBool);


			Layout();
		}

		ParametrosPrincipales::~ParametrosPrincipales()
		{			
		}


		void ParametrosPrincipales::OnChoiceFormatoDestino(wxCommandEvent &)
		{
			switch(m_pFormatoDestino->GetSelection()){
				case 0:
					m_pPanelContenido->Show(false);
					m_pSep1->Show(false);
					m_pPanelJpeg->Show(false);
					break;
				case 1:
					m_pPanelContenido->Show(true);
					m_pSep1->Show(true);
					m_pPanelJpeg->Show(true);
					break;
				case 2:
				case 3:
					m_pPanelContenido->Show(true);
					m_pSep1->Show(false);
					m_pPanelJpeg->Show(false);
					break;
			}
			Layout();
		}


//region "Metodos heredados de Ipasowizard"
		std::string ParametrosPrincipales::GetTitle(){
			return _Std("DICOM Export");
		}

		std::string ParametrosPrincipales::GetSubTitle(){
			return _Std("Select the format and the images you want to export");
		}

		bool ParametrosPrincipales::Siguiente(){
			return true;
		}

		bool ParametrosPrincipales::Anterior(){
			return false;
		}

		bool ParametrosPrincipales::Cancelar(){
			return true;
		}

		bool ParametrosPrincipales::Validar(){
			switch(m_pFormatoDestino->GetSelection()){
				case 0:
					m_pDatosPersistentes->m_formatoDestino = DICOM;
					break;
				case 1:
					m_pDatosPersistentes->m_formatoDestino = JPEG;
					break;
				case 2:
					m_pDatosPersistentes->m_formatoDestino = BMP;
					break;
				case 3:
					m_pDatosPersistentes->m_formatoDestino = PNG;
					break;
				default:
					m_pDatosPersistentes->m_formatoDestino = DICOM;
			}

			if(m_pOrigen->GetSelection() == 0 ){
				m_pDatosPersistentes->m_ficheroActual=true;
			}else{
				m_pDatosPersistentes->m_ficheroActual=false;
			}

			//mapas de valoracion
			if(m_pDatosPersistentes->m_formatoDestino != DICOM) {
				for(unsigned int i = 0; i< m_pMapasCheck->GetCount(); i++) {
					std::string strTmp(m_pMapasCheck->GetString(i).ToUTF8());
					m_pDatosPersistentes->m_mapasValoracion[strTmp] = m_pMapasCheck->IsChecked(i);
				}
			}
			m_pDatosPersistentes->m_incluirWidgets = m_pIncluirWidgets->IsChecked();

			if(m_pDatosPersistentes->m_formatoDestino == JPEG){
				m_pDatosPersistentes->m_jpegCalidad = m_pSliderCalidad->GetValue();
			}

			GNC::GCS::ConfigurationController::Instance()->writeIntUser("/GinkgoCore/ImageExport", "Scope", m_pOrigen->GetSelection());
			GNC::GCS::ConfigurationController::Instance()->writeIntUser("/GinkgoCore/ImageExport", "Format", m_pFormatoDestino->GetSelection());
			GNC::GCS::ConfigurationController::Instance()->writeBoolUser("/GinkgoCore/ImageExport", "AnnotationWidgets", m_pIncluirWidgets->GetValue());
			//pillamos el directorio...
			return Seleccionardirectorio();

		}
	//endregion

		bool ParametrosPrincipales::Seleccionardirectorio()
		{
			std::string pathDef;
			GNC::GCS::ConfigurationController::Instance()->readStringUser("/GinkgoCore/Exportacion", "PathDefecto", pathDef);
			wxString wxPathDefecto = wxString::FromUTF8(pathDef.c_str());
			wxDirDialog seleccionarDirectorio(this,_("Select the directory where the files will be stored"),wxPathDefecto,wxDD_DEFAULT_STYLE|wxDD_NEW_DIR_BUTTON);
			int response = seleccionarDirectorio.ShowModal();
			if (response == wxID_OK)
			{
				wxString wxPath = seleccionarDirectorio.GetPath();

				if( !wxDirExists(wxPath) ){
					wxMessageDialog dialog(NULL,_("The selected directory does not exist\nWould you like to create?"),_("Info"),wxYES_NO|wxICON_INFORMATION);
					if ( dialog.ShowModal() == wxID_NO)
					{
						return false;;
					}
					if(!wxFileName::Mkdir(wxPath)){
						wxMessageBox(_("There was an error creating directory"), _("Info"),
							wxOK | wxICON_INFORMATION, this);
						return false;
					}
				}

				m_pDatosPersistentes->m_pathDestino = TOPATH(wxPath);

			
				GADAPI::ComandoExportacionParams* pParams = new GADAPI::ComandoExportacionParams(m_pDatosPersistentes);
				GADAPI::ComandoExportacion* pCmd = new GADAPI::ComandoExportacion(pParams);
				void* owner = NULL;
				if (m_pDatosPersistentes->m_pExportDelegate.IsValid()) {
					owner = m_pDatosPersistentes->m_pExportDelegate->GetExportContract()->GetView();
				}
				GNC::GCS::ICommandController::Instance()->ProcessAsync(_Std("Exporting images ..."), pCmd, owner);

				GNC::GCS::ConfigurationController::Instance()->writeStringUser("/GinkgoCore/Exportacion", "PathDefecto",std::string(wxPath.ToUTF8()));
				return true;
			} else {
				return false;
			}
		}
	};

};
