/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl. */

#include "config.h"

#include "stamp-pdbgen.h"

#include <gegl.h>

#include <gdk-pixbuf/gdk-pixbuf.h>

#include "libgimpbase/gimpbase.h"

#include "pdb-types.h"

#include "core/gimpparamspecs.h"
#include "core/gimprasterizable.h"

#include "gimppdb.h"
#include "gimppdberror.h"
#include "gimpprocedure.h"
#include "internal-procs.h"

#include "gimp-intl.h"


static GimpValueArray *
rasterizable_rasterize_invoker (GimpProcedure         *procedure,
                                Gimp                  *gimp,
                                GimpContext           *context,
                                GimpProgress          *progress,
                                const GimpValueArray  *args,
                                GError               **error)
{
  gboolean success = TRUE;
  GimpRasterizable *item;

  item = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      if (! gimp_rasterizable_is_rasterized (GIMP_RASTERIZABLE (item)))
        {
          gimp_rasterizable_rasterize (GIMP_RASTERIZABLE (item), TRUE);
        }
      else
        {
          g_set_error (error, GIMP_PDB_ERROR, GIMP_PDB_ERROR_INVALID_ARGUMENT,
                       _("This item has already been rasterized."));
          success = FALSE;
        }
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
rasterizable_restore_invoker (GimpProcedure         *procedure,
                              Gimp                  *gimp,
                              GimpContext           *context,
                              GimpProgress          *progress,
                              const GimpValueArray  *args,
                              GError               **error)
{
  gboolean success = TRUE;
  GimpRasterizable *item;

  item = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      if (gimp_rasterizable_is_rasterized (GIMP_RASTERIZABLE (item)))
        {
          gimp_rasterizable_restore (GIMP_RASTERIZABLE (item));
        }
      else
        {
          g_set_error (error, GIMP_PDB_ERROR, GIMP_PDB_ERROR_INVALID_ARGUMENT,
                       _("This item has not been rasterized."));
          success = FALSE;
        }
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
rasterizable_is_rasterized_invoker (GimpProcedure         *procedure,
                                    Gimp                  *gimp,
                                    GimpContext           *context,
                                    GimpProgress          *progress,
                                    const GimpValueArray  *args,
                                    GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpRasterizable *item;
  gboolean is_rasterized = FALSE;

  item = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      is_rasterized = gimp_rasterizable_is_rasterized (GIMP_RASTERIZABLE (item));
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_boolean (gimp_value_array_index (return_vals, 1), is_rasterized);

  return return_vals;
}

void
register_rasterizable_procs (GimpPDB *pdb)
{
  GimpProcedure *procedure;

  /*
   * gimp-rasterizable-rasterize
   */
  procedure = gimp_procedure_new (rasterizable_rasterize_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-rasterizable-rasterize");
  gimp_procedure_set_static_help (procedure,
                                  "Rasterize the object.",
                                  "This procedure makes the item behave like a typical raster layer.\n"
                                  "\n"
                                  "Note that the source information (text contents and properties for a text layer, source file for a link layer, path and render properties for a vector layer, etc.) are not actually discarded, and it is possible to retrieve the original behavior with [method@Gimp.Rasterizable.restore].",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Jehan",
                                         "Jehan",
                                         "2025");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_rasterizable ("item",
                                                             "item",
                                                             "The rasterizable item",
                                                             FALSE,
                                                             GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-rasterizable-restore
   */
  procedure = gimp_procedure_new (rasterizable_restore_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-rasterizable-restore");
  gimp_procedure_set_static_help (procedure,
                                  "Revert the rasterization of @item.",
                                  "Restore the information making the item non-destructive, such as text contents and properties of a text layer, source file of a link layer, path and render properties of a vector layer, etc.\n"
                                  "This item won't behave anymore like a raster item. In particular, it will prevent direct modification of its pixels and will be rendered when its properties are updated.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Jehan",
                                         "Jehan",
                                         "2025");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_rasterizable ("item",
                                                             "item",
                                                             "The rasterizable item",
                                                             FALSE,
                                                             GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-rasterizable-is-rasterized
   */
  procedure = gimp_procedure_new (rasterizable_is_rasterized_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-rasterizable-is-rasterized");
  gimp_procedure_set_static_help (procedure,
                                  "Return whether @item has been rasterized.",
                                  "This procedure returns %TRUE if the specified @item has been previously rasterized. In this case, you should treat this @item as the generic raster variant.\n"
                                  "\n"
                                  "For instance, a [class@Gimp.TextLayer] object implements the %GimpRasterizable interface. If a text layer instance were to return %TRUE, you should only consider its rendering as returned by [method@Gimp.Drawable.get_buffer].\n"
                                  "\n"
                                  "On the other hand, if this returned %FALSE, depending on your intents, you may prefer to use the text contents and its properties with the various procedures provided by the [class@Gimp.TextLayer] class interface.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Jehan",
                                         "Jehan",
                                         "2025");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_rasterizable ("item",
                                                             "item",
                                                             "The rasterizable item",
                                                             FALSE,
                                                             GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("is-rasterized",
                                                         "is rasterized",
                                                         "TRUE if @item is rasterized",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);
}
