/*===========================================================================*
 *                                                                           *
 *  sflcvsb.c - Convert a string to a boolean                                *
 *                                                                           *
 *  Copyright (c) 1991-2010 iMatix Corporation                               *
 *                                                                           *
 *  ------------------ GPL Licensed Source Code ------------------           *
 *  iMatix makes this software available under the GNU General               *
 *  Public License (GPL) license for open source projects.  For              *
 *  details of the GPL license please see www.gnu.org or read the            *
 *  file license.gpl provided in this package.                               *
 *                                                                           *
 *  This program is free software; you can redistribute it and/or            *
 *  modify it under the terms of the GNU General Public License as           *
 *  published by the Free Software Foundation; either version 3 of           *
 *  the License, or (at your option) any later version.                      *
 *                                                                           *
 *  This program is distributed in the hope that it will be useful,          *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *  GNU General Public License for more details.                             *
 *                                                                           *
 *  You should have received a copy of the GNU General Public                *
 *  License along with this program in the file 'license.gpl'; if            *
 *  not, see <http://www.gnu.org/licenses/>.                                 *
 *                                                                           *
 *  You can also license this software under iMatix's General Terms          *
 *  of Business (GTB) for commercial projects.  If you have not              *
 *  explicitly licensed this software under the iMatix GTB you may           *
 *  only use it under the terms of the GNU General Public License.           *
 *                                                                           *
 *  For more information, send an email to info@imatix.com.                  *
 *  --------------------------------------------------------------           *
 *===========================================================================*/

#include "prelude.h"                    /*  Universal header file            */
#include "sflconv.h"                    /*  Prototypes for functions         */


/*  ---------------------------------------------------------------------[<]-
    Function: conv_str_bool

    Synopsis: Converts a string to a Bool.  Accepts T/Y/1 as TRUE, F/N/0
    as FALSE, ignoring case.  Looks only at the first letter of the string.
    Returns 1 for TRUE, 0 for FALSE, -1 if the string was not valid.
    ---------------------------------------------------------------------[>]-*/

int
conv_str_bool (
    const char *string)
{
    char
        ch;

    ch = tolower (string [0]);
    conv_reason = 0;                    /*  No conversion errors so far      */
    if (ch == 'y' || ch == 't' || ch == '1')
        return (1);
    else
    if (ch == 'n' || ch == 'f' || ch == '0')
        return (0);
    else
      {
        conv_reason = CONV_ERR_NOT_BOOLEAN;
        return (-1);
      }
}
