*
* $Id: ugeom.F,v 1.1.1.1 1995/10/24 10:22:13 cernlib Exp $
*
* $Log: ugeom.F,v $
* Revision 1.1.1.1  1995/10/24 10:22:13  cernlib
* Geant
*
*
#include "geant321/pilot.h"
*CMZ :  3.21/02 29/03/94  15.41.35  by  S.Giani
*-- Author :
      SUBROUTINE UGEOM
C
C
#include "geant321/gclist.inc"
#include "geant321/gconsp.inc"
C
      COMMON/DLSFLD/ISWFLD,FLDVAL
C
      DIMENSION   CAVPAR(3),TGTPAR(3),TBIPAR(4),TBOPAR(4),ARMPAR(4)
     + ,FMIPAR(3),FCIPAR(5),FCOPAR(5),FHOPAR(3),FDIPAR(3),FDOPAR(3)
     + ,FLDPAR(3),RD1IPA(3),RD1OPA(3),RD2IPA(3),RD2OPA(3),RD3IPA(3)
     + ,RD3OPA(3),RHOPAR(3)
C
C      VOLUME SIZE PARAMETERS
C
      DATA CAVPAR/450.,100.,360./
      DATA TGTPAR/.47625,1.27,.0232/
      DATA TBIPAR/60.91172,5.07172,10.14,27.92/
      DATA TBOPAR/60.96,5.08,10.16,27.94/
      DATA ARMPAR/18.,210.,50.,190./
      DATA FMIPAR/36.83,12.7,.06/
      DATA FCIPAR/13.29941,50.69885,7.565299,13.90419,34.23/
      DATA FCOPAR/13.335,50.80,7.62,13.97,34.29/
      DATA FHOPAR/40.005,13.49375,.15875/
      DATA FDIPAR/41.91,13.97,4.2/
      DATA FDOPAR/41.917,13.977,4.207/
      DATA FLDPAR/55.88,19.05,25.40/
      DATA RD1IPA/70.000,25.500,7.800/
      DATA RD1OPA/70.007,25.507,7.807/
      DATA RD2IPA/85.000,29.500,7.800/
      DATA RD2OPA/85.007,29.507,7.807/
      DATA RD3IPA/100.000,33.500,7.800/
      DATA RD3OPA/100.007,33.507,7.807/
      DATA RHOPAR/150.5,47.,.3175/
C
C      LOCATIONS:
C          TGT VERSUS CAVE CENTER
C          FIELD AND DETECTORS VERSUS ARM CENTER
C          ANGLE SETTINGS OF LEFT AND RIGHT ARMS (DEG., ANGR IS NEG.)
C          LEFT AND RIGHT ARM VERSUS CAVE CENTER
C
      DATA ZTG/-100./
      DATA DFCO,DFHO,DFDO,DFLD,DRD1,DRD2,DRD3,DRHO/-154.77,-120.1625
     + ,-115.4,-84.92,-27.77,3.98,35.73,142.41/
      DATA ANGL,ANGR/45.,-45./
      DATA DARM/217./
      CANGL=COS(ANGL*DEGRAD)
      SANGL=SIN(ANGL*DEGRAD)
      CANGR=COS(ANGR*DEGRAD)
      SANGR=SIN(ANGR*DEGRAD)
      XLARM=DARM*SANGL
      ZLARM=DARM*CANGL+ZTG
      XRARM=DARM*SANGR
      ZRARM=DARM*CANGR+ZTG
C
C      CAVE REFERENCE FRAME:
C          OZ ALONG BEAM, OX HORIZONTAL, OY VERTICAL
C
      CALL GSVOLU('CAVE','BOX ',1,CAVPAR,3,ICAVE)
C
C      TARGET BOX SHIFTED UPSTREAM 100CM IN CAVE.
C           REFERENCE FRAME:
C               OZ ALONG BEAM, OX HORIZONTAL, OY VERTICAL.
C           CA DENSITY = 1.55 G/CM**3.
C           5 SEGMENTS.
C
      CALL GSVOLU('TGT ','BOX ',2,TGTPAR,3,ITGT )
      CALL GSVOLU('TBIN','TRD1',3,TBIPAR,4,ITBIN)
      CALL GSVOLU('TBOU','TRD1',4,TBOPAR,4,ITBOU)
C
C      LEFT AND RIGHT ARM REFERENCE FRAMES:
C           OZ ALONG CENTRAL RAY, OX HORIZONTAL, OY VERTICAL.
C
      CALL GSVOLU('ARM ','TRD1',1,ARMPAR,4,IARM)
      CALL GSVOLU('FMIR','BOX ',5,FMIPAR,3,IFMIR)
      CALL GSVOLU('FCIN','TRD2',6,FCIPAR,5,IFCIN)
      CALL GSVOLU('FCOU','TRD2',7,FCOPAR,5,IFCOU)
      CALL GSVOLU('FHOD','BOX ',8,FHOPAR,3,IFHOD)
      CALL GSVOLU('FDIN','BOX ',9,FDIPAR,3,IFDIN)
      CALL GSVOLU('FDOU','BOX ',4,FDOPAR,3,IFDOU)
      CALL GSVOLU('FLD ','BOX ',10,FLDPAR,3,IFLD )
      CALL GSVOLU('RD1I','BOX ',11,RD1IPA,3,IRD1I)
      CALL GSVOLU('RD1O','BOX ', 4,RD1OPA,3,IRD1O)
      CALL GSVOLU('RD2I','BOX ',11,RD2IPA,3,IRD2I)
      CALL GSVOLU('RD2O','BOX ', 4,RD2OPA,3,IRD2O)
      CALL GSVOLU('RD3I','BOX ',11,RD3IPA,3,IRD3I)
      CALL GSVOLU('RD3O','BOX ', 4,RD3OPA,3,IRD3O)
      CALL GSVOLU('RHOD','BOX ', 8,RHOPAR,3,IRHOD)
C
C         DRIFT CHAMBER SENSE PLANES
C
      FDIPAR(3)=.0025
      CALL GSVOLU('FSP ','BOX ',13,FDIPAR,3,IFSP )
      RD1IPA(3)=.0025
      CALL GSVOLU('RSP1','BOX ',14,RD1IPA,3,IRSP1)
      RD2IPA(3)=.0025
      CALL GSVOLU('RSP2','BOX ',14,RD2IPA,3,IRSP2)
      RD3IPA(3)=.0025
      CALL GSVOLU('RSP3','BOX ',14,RD3IPA,3,IRSP3)
C
C
      THLX=90.+ANGL
      THRX=90.+ANGR
      PHX=0.
      THY=90.
      PHY=90.
      THLZ=ANGL
      THRZ=-ANGR
      PHLZ=0.
      PHRZ=180.
      CALL GSROTM(1,THLX,PHX,THY,PHY,THLZ,PHLZ)
      CALL GSROTM(2,THRX,PHX,THY,PHY,THRZ,PHRZ)
C
C
      CALL GSPOS('TGT ',1,'TBIN', 0., 0.,-5.08,0,'ONLY')
      CALL GSPOS('TGT ',2,'TBIN', 0., 0.,-2.54,0,'ONLY')
      CALL GSPOS('TGT ',3,'TBIN', 0., 0., 0.  ,0,'ONLY')
      CALL GSPOS('TGT ',4,'TBIN', 0., 0., 2.54,0,'ONLY')
      CALL GSPOS('TGT ',5,'TBIN', 0., 0., 5.08,0,'ONLY')
      CALL GSPOS('TBIN',1,'TBOU', 0., 0.,   0.,0,'ONLY')
      CALL GSPOS('TBOU',1,'CAVE', 0., 0.,  ZTG,0,'ONLY')
C
      CALL GSPOS('ARM ',1,'CAVE',XLARM,0.,ZLARM,1,'ONLY')
      CALL GSPOS('ARM ',2,'CAVE',XRARM,0.,ZRARM,2,'ONLY')
C
      CALL GSPOS('FMIR',1,'FCIN',0.,0.,26.0350,0,'ONLY')
      CALL GSPOS('FCIN',1,'FCOU',0.,0., 0.    ,0,'ONLY')
      CALL GSPOS('FCOU',1,'ARM ',0.,0., DFCO  ,0,'ONLY')
C
      CALL GSPOS('FHOD',1,'ARM ',0.,0., DFHO  ,0,'ONLY')
C
      CALL GSPOS('FDIN',1,'FDOU',0.,0., 0.    ,0,'ONLY')
      CALL GSPOS('FDOU',1,'ARM ',0.,0., DFDO  ,0,'ONLY')
C
      CALL GSPOS('FLD ',1,'ARM ',0.,0., DFLD  ,0,'ONLY')
C
      CALL GSPOS('RD1I',1,'RD1O',0.,0., 0.    ,0,'ONLY')
      CALL GSPOS('RD1O',1,'ARM ',0.,0., DRD1  ,0,'ONLY')
C
      CALL GSPOS('RD2I',1,'RD2O',0.,0., 0.    ,0,'ONLY')
      CALL GSPOS('RD2O',1,'ARM ',0.,0., DRD2  ,0,'ONLY')
C
      CALL GSPOS('RD3I',1,'RD3O',0.,0., 0.    ,0,'ONLY')
      CALL GSPOS('RD3O',1,'ARM ',0.,0., DRD3  ,0,'ONLY')
C
      CALL GSPOS('RHOD',1,'ARM ',0.,0., DRHO  ,0,'ONLY')
C
      CALL GSPOS('FSP ',1,'FDIN',0.,0.,-2.9975,0,'ONLY')
      CALL GSPOS('FSP ',2,'FDIN',0.,0.,-1.7975,0,'ONLY')
      CALL GSPOS('FSP ',3,'FDIN',0.,0., -.5975,0,'ONLY')
      CALL GSPOS('FSP ',4,'FDIN',0.,0.,  .6025,0,'ONLY')
      CALL GSPOS('FSP ',5,'FDIN',0.,0., 1.8025,0,'ONLY')
      CALL GSPOS('FSP ',6,'FDIN',0.,0., 3.0025,0,'ONLY')
C
      CALL GSPOS('RSP1',1,'RD1I',0.,0.,-5.9975,0,'ONLY')
      CALL GSPOS('RSP1',2,'RD1I',0.,0.,-3.5975,0,'ONLY')
      CALL GSPOS('RSP1',3,'RD1I',0.,0.,-1.1975,0,'ONLY')
      CALL GSPOS('RSP1',4,'RD1I',0.,0., 1.2025,0,'ONLY')
      CALL GSPOS('RSP1',5,'RD1I',0.,0., 3.6025,0,'ONLY')
      CALL GSPOS('RSP1',6,'RD1I',0.,0., 6.0025,0,'ONLY')
C
      CALL GSPOS('RSP2',1,'RD2I',0.,0.,-5.9975,0,'ONLY')
      CALL GSPOS('RSP2',2,'RD2I',0.,0.,-3.5975,0,'ONLY')
      CALL GSPOS('RSP2',3,'RD2I',0.,0.,-1.1975,0,'ONLY')
      CALL GSPOS('RSP2',4,'RD2I',0.,0., 1.2025,0,'ONLY')
      CALL GSPOS('RSP2',5,'RD2I',0.,0., 3.6025,0,'ONLY')
      CALL GSPOS('RSP2',6,'RD2I',0.,0., 6.0025,0,'ONLY')
C
      CALL GSPOS('RSP3',1,'RD3I',0.,0.,-5.9975,0,'ONLY')
      CALL GSPOS('RSP3',2,'RD3I',0.,0.,-3.5975,0,'ONLY')
      CALL GSPOS('RSP3',3,'RD3I',0.,0.,-1.1975,0,'ONLY')
      CALL GSPOS('RSP3',4,'RD3I',0.,0., 1.2025,0,'ONLY')
      CALL GSPOS('RSP3',5,'RD3I',0.,0., 3.6025,0,'ONLY')
      CALL GSPOS('RSP3',6,'RD3I',0.,0., 6.0025,0,'ONLY')
C
C      CALL GSORD('ARM ',3)
      CALL GSORD('FDIN',3)
      CALL GSORD('RD1I',3)
      CALL GSORD('RD2I',3)
      CALL GSORD('RD3I',3)
C
      CALL GSTMED( 1,'AIR       $',15,0,0,0.,10.,.2,.1,.001,.5,0,0)
      CALL GSTMED( 2,'TARGET    $',17,0,0,0.,10.,.2,.1,.001,.5,0,0)
      CALL GSTMED( 3,'VACUUM    $',16,0,0,0., 0.,.0,.0,.001,.5,0,0)
      CALL GSTMED( 4,'MYLAR     $',18,0,0,0.,10.,.2,.1,.001,.5,0,0)
      CALL GSTMED( 5,'PYREX     $',19,0,0,0.,10.,.2,.1,.001,.5,0,0)
      CALL GSTMED( 6,'FREON13   $',20,0,0,0.,10.,.2,.1,.001,.5,0,0)
      CALL GSTMED( 7,'POLYETHYL.$',22,0,0,0.,10.,.2,.1,.001,.5,0,0)
      CALL GSTMED( 8,'SCINTILL. $',23,0,0,0.,10.,.2,.1,.01,.5,0,0)
      CALL GSTMED( 9,'FRONTDRIFT$',24,0,0,0.,10.,.2,.1,.001,.5,0,0)
      CALL GSTMED(10,'AIR+FIELD $',15,0,ISWFLD,6.,10.,.2,.1,.01,.5,0,0)
      CALL GSTMED(11,'REAR DRIFT$',25,0,0,0.,10.,.2,.1,.001,.5,0,0)
      CALL GSTMED(12,'CO2       $',21,0,0,0.,10.,.2,.1,.01,.5,0,0)
      CALL GSTMED(13,'FR.DR.S.P.$',24,1,0,0.,10.,.2,.1,.001,.5,0,0)
      CALL GSTMED(14,'RE.DR.S.P.$',25,1,0,0.,10.,.2,.1,.001,.5,0,0)
C
C
      CALL GLOOK('VOLU',LPRIN,NPRIN,ILOOK)
      IF(ILOOK.NE.0) CALL GPVOLU(0)
      CALL GLOOK('ROTM',LPRIN,NPRIN,ILOOK)
      IF(ILOOK.NE.0) CALL GPROTM(0)
      CALL GLOOK('TMED',LPRIN,NPRIN,ILOOK)
      IF(ILOOK.NE.0) CALL GPTMED(0)
      CALL GLOOK('MATE',LPRIN,NPRIN,ILOOK)
      IF(ILOOK.NE.0) CALL GPMATE(0)
      CALL GLOOK('PART',LPRIN,NPRIN,ILOOK)
      IF(ILOOK.NE.0) CALL GPPART(0)
C
C
      CALL GGCLOS
C
      RETURN
      END
