/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JPanel;
import ptolemy.gui.ComponentDialog;
import ptolemy.gui.Query;
import ptolemy.gui.QueryListener;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotBox;
import ptolemy.plot.PlotPoint;

public class PlotFormatter
extends JPanel {
    protected final PlotBox _plot;
    private Query _wideQuery;
    private Query _narrowQuery;
    private String _originalTitle;
    private String _originalXLabel;
    private String _originalYLabel;
    private String _originalMarks;
    private String _originalXTicksSpec;
    private String _originalYTicksSpec;
    private double[] _originalXRange;
    private double[] _originalYRange;
    private Vector[] _originalXTicks;
    private Vector[] _originalYTicks;
    private boolean _originalGrid;
    private boolean _originalStems;
    private boolean _originalColor;
    private boolean[][] _originalConnected;
    private PlotPoint[][] _originalPoints;

    public PlotFormatter(PlotBox plotBox) {
        int n;
        Vector vector;
        Vector vector2;
        StringBuffer stringBuffer;
        this._plot = plotBox;
        this.setLayout(new BorderLayout());
        this._wideQuery = new Query();
        this.add((Component)this._wideQuery, "West");
        this._narrowQuery = new Query();
        this.add((Component)this._narrowQuery, "East");
        this._wideQuery.setTextWidth(20);
        this._originalTitle = plotBox.getTitle();
        this._wideQuery.addLine("title", "Title", this._originalTitle);
        this._originalXLabel = plotBox.getXLabel();
        this._wideQuery.addLine("xlabel", "X Label", this._originalXLabel);
        this._originalYLabel = plotBox.getYLabel();
        this._wideQuery.addLine("ylabel", "Y Label", this._originalYLabel);
        this._originalXRange = plotBox.getXRange();
        this._wideQuery.addLine("xrange", "X Range", "" + this._originalXRange[0] + ", " + this._originalXRange[1]);
        this._originalYRange = plotBox.getYRange();
        this._wideQuery.addLine("yrange", "Y Range", "" + this._originalYRange[0] + ", " + this._originalYRange[1]);
        String[] stringArray = new String[]{"none", "points", "dots", "various", "pixels"};
        this._originalMarks = "none";
        if (plotBox instanceof Plot) {
            this._originalMarks = ((Plot)plotBox).getMarksStyle();
            this._wideQuery.addRadioButtons("marks", "Marks", stringArray, this._originalMarks);
        }
        this._originalXTicks = plotBox.getXTicks();
        this._originalXTicksSpec = "";
        if (this._originalXTicks != null) {
            stringBuffer = new StringBuffer();
            vector2 = this._originalXTicks[0];
            vector = this._originalXTicks[1];
            for (n = 0; n < vector.size(); ++n) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(vector.elementAt(n).toString());
                stringBuffer.append(" ");
                stringBuffer.append(vector2.elementAt(n).toString());
            }
            this._originalXTicksSpec = stringBuffer.toString();
        }
        this._wideQuery.addLine("xticks", "X Ticks", this._originalXTicksSpec);
        this._originalYTicks = plotBox.getYTicks();
        this._originalYTicksSpec = "";
        if (this._originalYTicks != null) {
            stringBuffer = new StringBuffer();
            vector2 = this._originalYTicks[0];
            vector = this._originalYTicks[1];
            for (n = 0; n < vector.size(); ++n) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(vector.elementAt(n).toString());
                stringBuffer.append(" ");
                stringBuffer.append(vector2.elementAt(n).toString());
            }
            this._originalYTicksSpec = stringBuffer.toString();
        }
        this._wideQuery.addLine("yticks", "Y Ticks", this._originalYTicksSpec);
        this._originalGrid = plotBox.getGrid();
        this._narrowQuery.addCheckBox("grid", "Grid", this._originalGrid);
        this._originalStems = false;
        this._originalConnected = null;
        if (plotBox instanceof Plot) {
            this._originalStems = ((Plot)plotBox).getImpulses();
            this._narrowQuery.addCheckBox("stems", "Stems", this._originalStems);
            this._saveConnected();
            this._narrowQuery.addCheckBox("connected", "Connect", ((Plot)plotBox).getConnected());
        }
        this._originalColor = plotBox.getColor();
        this._narrowQuery.addCheckBox("color", "Use Color", this._originalColor);
        this._wideQuery.addQueryListener(new QueryListener(){

            public void changed(String string) {
                if (string.equals("title")) {
                    PlotFormatter.this._plot.setTitle(PlotFormatter.this._wideQuery.getStringValue("title"));
                } else if (string.equals("xlabel")) {
                    PlotFormatter.this._plot.setXLabel(PlotFormatter.this._wideQuery.getStringValue("xlabel"));
                } else if (string.equals("ylabel")) {
                    PlotFormatter.this._plot.setYLabel(PlotFormatter.this._wideQuery.getStringValue("ylabel"));
                } else if (string.equals("xrange")) {
                    PlotFormatter.this._plot.read("XRange: " + PlotFormatter.this._wideQuery.getStringValue("xrange"));
                } else if (string.equals("xticks")) {
                    String string2 = PlotFormatter.this._wideQuery.getStringValue("xticks").trim();
                    PlotFormatter.this._plot.read("XTicks: " + string2);
                } else if (string.equals("yticks")) {
                    String string3 = PlotFormatter.this._wideQuery.getStringValue("yticks").trim();
                    PlotFormatter.this._plot.read("YTicks: " + string3);
                } else if (string.equals("yrange")) {
                    PlotFormatter.this._plot.read("YRange: " + PlotFormatter.this._wideQuery.getStringValue("yrange"));
                } else if (string.equals("marks")) {
                    ((Plot)PlotFormatter.this._plot).setMarksStyle(PlotFormatter.this._wideQuery.getStringValue("marks"));
                }
                PlotFormatter.this._plot.repaint();
            }
        });
        this._narrowQuery.addQueryListener(new QueryListener(){

            public void changed(String string) {
                if (string.equals("grid")) {
                    PlotFormatter.this._plot.setGrid(PlotFormatter.this._narrowQuery.getBooleanValue("grid"));
                } else if (string.equals("stems")) {
                    ((Plot)PlotFormatter.this._plot).setImpulses(PlotFormatter.this._narrowQuery.getBooleanValue("stems"));
                    PlotFormatter.this._plot.repaint();
                } else if (string.equals("color")) {
                    PlotFormatter.this._plot.setColor(PlotFormatter.this._narrowQuery.getBooleanValue("color"));
                } else if (string.equals("connected")) {
                    PlotFormatter.this._setConnected(PlotFormatter.this._narrowQuery.getBooleanValue("connected"));
                }
                PlotFormatter.this._plot.repaint();
            }
        });
    }

    public void apply() {
        this._plot.setTitle(this._wideQuery.getStringValue("title"));
        this._plot.setXLabel(this._wideQuery.getStringValue("xlabel"));
        this._plot.setYLabel(this._wideQuery.getStringValue("ylabel"));
        this._plot.read("XRange: " + this._wideQuery.getStringValue("xrange"));
        this._plot.read("YRange: " + this._wideQuery.getStringValue("yrange"));
        this._plot.setGrid(this._narrowQuery.getBooleanValue("grid"));
        this._plot.setColor(this._narrowQuery.getBooleanValue("color"));
        if (this._plot instanceof Plot) {
            Plot plot = (Plot)this._plot;
            plot.setMarksStyle(this._wideQuery.getStringValue("marks"));
            plot.setImpulses(this._narrowQuery.getBooleanValue("stems"));
            this._setConnected(this._narrowQuery.getBooleanValue("connected"));
        }
        this._plot.repaint();
    }

    public void openModal() {
        ComponentDialog componentDialog;
        String[] stringArray = new String[]{"Apply", "Cancel"};
        Container container = this._plot.getTopLevelAncestor();
        Frame frame = null;
        if (container instanceof Frame) {
            frame = (Frame)container;
        }
        if ((componentDialog = new ComponentDialog(frame, "Set plot format", this, stringArray)).buttonPressed().equals("Apply")) {
            this.apply();
        } else {
            this.restore();
        }
    }

    public void restore() {
        this._plot.setTitle(this._originalTitle);
        this._plot.setXLabel(this._originalXLabel);
        this._plot.setYLabel(this._originalYLabel);
        this._plot.setXRange(this._originalXRange[0], this._originalXRange[1]);
        this._plot.setYRange(this._originalYRange[0], this._originalYRange[1]);
        this._plot.setGrid(this._originalGrid);
        this._plot.setColor(this._originalColor);
        if (this._plot instanceof Plot) {
            Plot plot = (Plot)this._plot;
            plot.setMarksStyle(this._originalMarks);
            plot.setImpulses(this._originalStems);
            this._restoreConnected();
        }
        this._plot.repaint();
    }

    private void _saveConnected() {
        Vector vector = ((Plot)this._plot)._points;
        this._originalConnected = new boolean[vector.size()][];
        this._originalPoints = new PlotPoint[vector.size()][];
        for (int i = 0; i < vector.size(); ++i) {
            Vector vector2 = (Vector)vector.elementAt(i);
            this._originalConnected[i] = new boolean[vector2.size()];
            this._originalPoints[i] = new PlotPoint[vector2.size()];
            for (int j = 0; j < vector2.size(); ++j) {
                PlotPoint plotPoint = (PlotPoint)vector2.elementAt(j);
                this._originalConnected[i][j] = plotPoint.connected;
                this._originalPoints[i][j] = plotPoint;
            }
        }
    }

    private void _setConnected(boolean bl) {
        Vector vector = ((Plot)this._plot)._points;
        ((Plot)this._plot).setConnected(bl);
        boolean[][] blArrayArray = new boolean[vector.size()][];
        for (int i = 0; i < vector.size(); ++i) {
            Vector vector2 = (Vector)vector.elementAt(i);
            blArrayArray[i] = new boolean[vector2.size()];
            boolean bl2 = true;
            for (int j = 0; j < vector2.size(); ++j) {
                PlotPoint plotPoint = (PlotPoint)vector2.elementAt(j);
                plotPoint.connected = bl && !bl2;
                bl2 = false;
            }
        }
    }

    private void _restoreConnected() {
        for (int i = 0; i < this._originalPoints.length; ++i) {
            for (int j = 0; j < this._originalPoints[i].length; ++j) {
                PlotPoint plotPoint = this._originalPoints[i][j];
                plotPoint.connected = this._originalConnected[i][j];
            }
        }
    }
}

