'\"
'\" Generated from file '/home/aku/Projects/Tcllib/tklib/embedded/man/files/modules/chatwidget/chatwidget\&.n' by tcllib/doctools with format 'nroff'
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "chatwidget" n 1\&.0\&.0 tklib "Composite widget for chat applications"
.BS
.SH NAME
chatwidget \- Provides a multi-paned view suitable for display of chat room or irc channel information
.SH SYNOPSIS
package require \fBTk  8\&.5\fR
.sp
package require \fBchatwidget  ?1\&.0\&.0?\fR
.sp
\fB::chatwidget::chatwidget\fR \fIpath\fR ?\fIoptions\fR?
.sp
\fB$widget\fR topic \fIcommand\fR \fIargs\fR
.sp
\fB$widget\fR name \fInick\fR \fIargs\fR
.sp
\fB$widget\fR message \fItext\fR \fIargs\fR
.sp
\fB$widget\fR hook \fIcommand\fR \fIargs\fR
.sp
\fB$widget\fR names \fIargs\fR
.sp
\fB$widget\fR entry \fIargs\fR
.sp
\fB$widget\fR chat \fIargs\fR
.sp
.BE
.SH DESCRIPTION
This is a composite widget designed to simplify the construction of
chat applications\&. The widget contains display areas for chat
messages, user names and topic and an entry area\&. It automatically
handles colourization of messages per nick and manages nick
completion\&. A system of hooks permit the application author to adjust
display features\&. The main chat display area may be split for use
displaying history or for searching\&.
.PP
The widget is made up of a number of text widget and panedwindow
widgets so that the size of each part of the display may be adjusted
by the user\&. All the text widgets may be accessed via widget
passthrough commands if fine adjustment is required\&. The topic and
names sections can also be hidden if desired\&.
.SH COMMANDS
.TP
\fB::chatwidget::chatwidget\fR \fIpath\fR ?\fIoptions\fR?
Create a new chatwidget using the Tk window id \fIpath\fR\&. Any options
provided are currently passed directly to the main chat text widget\&.
.PP
.SH "WIDGET COMMANDS"
.TP
\fB$widget\fR topic \fIcommand\fR \fIargs\fR
The chat widget can display a topic string, for instance the topic or
name given to a multi-user chatroom or irc channel\&.
.RS
.TP
\fBshow\fR
Enable display of the topic\&.
.TP
\fBhide\fR
Disable display of the topic
.TP
\fBset \fItopic\fR\fR
Set the topic text to \fItopic\fR\&.
.RE
.TP
\fB$widget\fR name \fInick\fR \fIargs\fR
Control the names and tags associated with names\&.
.RS
.TP
\fBlist ?\fI-full\fR?\fR
Returns a list of all the user names from the names view\&. If ?-full? is given then the list returned is a list of lists where each
sublist is made up of the nick followed by any options that have been
set on this nick entry\&. This may be used to examine any application
specific options that may be applied to a nick when using the
\fBadd\fR command\&.
.TP
\fBadd \fInick\fR ?\fIoptions\fR?\fR
.TP
\fBdelete \fInick\fR\fR
.RE
.TP
\fB$widget\fR message \fItext\fR \fIargs\fR
Add messages to the display\&. options are -nick, -time, -type, -mark
-tags
.TP
\fB$widget\fR hook \fIcommand\fR \fIargs\fR
Manage hooks\&. add (message, post names_group, names_nick, chatstate), remove, run
.TP
\fB$widget\fR names \fIargs\fR
Passthrough to the name display text widget\&. See the \fBtext\fR widget manual
for all available commands\&. The chatwidget provides two additional
commands \fBshow\fR and \fBhide\fR which are used to control the
display of this element in the widget\&.
.TP
\fB$widget\fR entry \fIargs\fR
Passthrough to the entry text widget\&. See the \fBtext\fR widget manual
for all available commands\&.
.TP
\fB$widget\fR chat \fIargs\fR
Passthrough to the chat text widget\&. See the \fBtext\fR widget manual for
all available commands\&.
.PP
.SH EXAMPLE
.CS


chatwidget::chatwidget \&.chat
proc speak {w msg} {$w message $msg -nick user}
\&.chat hook add post [list speak \&.chat]
pack \&.chat -side top -fill both -expand 1
\&.chat topic show
\&.chat topic set "Chat widget demo"
\&.chat name add "admin" -group admin
\&.chat name add "user" -group users -color tomato
\&.chat message "Chatwidget ready" -type system
\&.chat message "Hello, user" -nick admin
\&.chat message "Hello, admin" -nick user

.CE
.PP
A more extensive example is available by examining the code for the picoirc
program in the tclapps repository which ties the tcllib \fBpicoirc\fR package to this
\fBchatwidget\fR package to create a simple irc client\&.
.SH "SEE ALSO"
text(n)
.SH KEYWORDS
chat, chatwidget, composite widget, irc, mega-widget, widget