from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


SIGNAL = _Mock()

add_actions = _Mock()

add_separator = _Mock()

create_action = _Mock()

create_groupbox = _Mock()

create_toolbutton = _Mock()

get_icon = _Mock()

get_std_icon = _Mock()

is_text_string = _Mock()

keybinding = _Mock()

print_function = _Mock()

show_std_icons = _Mock()

sys = _Mock()

text_to_qcolor = _Mock()



class QAction(_Mock):
  pass
  AboutQtRole = 3
  AboutRole = 4
  ApplicationSpecificRole = 2
  HighPriority = 256
  Hover = 1
  LowPriority = 0
  NegativeSoftKey = 2
  NoRole = 0
  NoSoftKey = 0
  NormalPriority = 128
  PositiveSoftKey = 1
  PreferencesRole = 5
  QuitRole = 6
  SelectSoftKey = 3
  TextHeuristicRole = 1
  Trigger = 0

class QApplication(_Mock):
  pass
  CodecForTr = 0
  CustomColor = 1
  DefaultCodec = 0
  GuiClient = 1
  GuiServer = 2
  ManyColor = 2
  NormalColor = 0
  Tty = 0
  UnicodeUTF8 = 1

class QColor(_Mock):
  pass
  Cmyk = 3
  Hsl = 4
  Hsv = 2
  Invalid = 0
  Rgb = 1

class QGroupBox(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class QHBoxLayout(_Mock):
  pass
  BottomToTop = 3
  Down = 2
  LeftToRight = 0
  RightToLeft = 1
  SetDefaultConstraint = 0
  SetFixedSize = 3
  SetMaximumSize = 4
  SetMinAndMaxSize = 5
  SetMinimumSize = 2
  SetNoConstraint = 1
  TopToBottom = 2
  Up = 3

class QIcon(_Mock):
  pass
  Active = 2
  Disabled = 1
  Normal = 0
  Off = 1
  On = 0
  Selected = 3

class QKeySequence(_Mock):
  pass
  AddTab = 19
  Back = 13
  Bold = 27
  Close = 4
  Copy = 9
  Cut = 8
  Delete = 7
  DeleteEndOfLine = 60
  DeleteEndOfWord = 59
  DeleteStartOfWord = 58
  ExactMatch = 2
  Find = 22
  FindNext = 23
  FindPrevious = 24
  Forward = 14
  HelpContents = 1
  InsertLineSeparator = 62
  InsertParagraphSeparator = 61
  Italic = 28
  MoveToEndOfBlock = 41
  MoveToEndOfDocument = 43
  MoveToEndOfLine = 39
  MoveToNextChar = 30
  MoveToNextLine = 34
  MoveToNextPage = 36
  MoveToNextWord = 32
  MoveToPreviousChar = 31
  MoveToPreviousLine = 35
  MoveToPreviousPage = 37
  MoveToPreviousWord = 33
  MoveToStartOfBlock = 40
  MoveToStartOfDocument = 42
  MoveToStartOfLine = 38
  NativeText = 0
  New = 6
  NextChild = 20
  NoMatch = 0
  Open = 3
  PartialMatch = 1
  Paste = 10
  PortableText = 1
  Preferences = 64
  PreviousChild = 21
  Print = 18
  Quit = 65
  Redo = 12
  Refresh = 15
  Replace = 25
  Save = 5
  SaveAs = 63
  SelectAll = 26
  SelectEndOfBlock = 55
  SelectEndOfDocument = 57
  SelectEndOfLine = 53
  SelectNextChar = 44
  SelectNextLine = 48
  SelectNextPage = 50
  SelectNextWord = 46
  SelectPreviousChar = 45
  SelectPreviousLine = 49
  SelectPreviousPage = 51
  SelectPreviousWord = 47
  SelectStartOfBlock = 54
  SelectStartOfDocument = 56
  SelectStartOfLine = 52
  Underline = 29
  Undo = 11
  UnknownKey = 0
  WhatsThis = 2
  ZoomIn = 16
  ZoomOut = 17

class QLabel(_Mock):
  pass
  AlignCenter = 132
  AlignRight = 2
  AlignVCenter = 128
  Box = 1
  DrawChildren = 2
  DrawWindowBackground = 1
  HLine = 4
  IgnoreMask = 4
  NoFrame = 0
  Panel = 2
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Plain = 16
  Raised = 32
  Shadow_Mask = 240
  Shape_Mask = 15
  StyledPanel = 6
  Sunken = 48
  VLine = 5
  WinPanel = 3

class QLineEdit(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  NoEcho = 1
  Normal = 0
  Password = 2
  PasswordEchoOnEdit = 3
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class QMenu(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class QPushButton(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class QStyle(_Mock):
  pass
  CC_ComboBox = 1
  CC_CustomBase = -268435456
  CC_Dial = 7
  CC_GroupBox = 8
  CC_MdiControls = 9
  CC_Q3ListView = 6
  CC_ScrollBar = 2
  CC_Slider = 3
  CC_SpinBox = 0
  CC_TitleBar = 5
  CC_ToolButton = 4
  CE_CheckBox = 3
  CE_CheckBoxLabel = 4
  CE_ColumnViewGrip = 45
  CE_ComboBoxLabel = 40
  CE_CustomBase = -268435456
  CE_DockWidgetTitle = 31
  CE_FocusFrame = 39
  CE_Header = 23
  CE_HeaderEmptyArea = 44
  CE_HeaderLabel = 25
  CE_HeaderSection = 24
  CE_ItemViewItem = 46
  CE_MenuBarEmptyArea = 21
  CE_MenuBarItem = 20
  CE_MenuEmptyArea = 19
  CE_MenuHMargin = 17
  CE_MenuItem = 14
  CE_MenuScroller = 15
  CE_MenuTearoff = 18
  CE_MenuVMargin = 16
  CE_ProgressBar = 10
  CE_ProgressBarContents = 12
  CE_ProgressBarGroove = 11
  CE_ProgressBarLabel = 13
  CE_PushButton = 0
  CE_PushButtonBevel = 1
  CE_PushButtonLabel = 2
  CE_Q3DockWindowEmptyArea = 26
  CE_RadioButton = 5
  CE_RadioButtonLabel = 6
  CE_RubberBand = 30
  CE_ScrollBarAddLine = 32
  CE_ScrollBarAddPage = 34
  CE_ScrollBarFirst = 37
  CE_ScrollBarLast = 38
  CE_ScrollBarSlider = 36
  CE_ScrollBarSubLine = 33
  CE_ScrollBarSubPage = 35
  CE_ShapedFrame = 47
  CE_SizeGrip = 28
  CE_Splitter = 29
  CE_TabBarTab = 7
  CE_TabBarTabLabel = 9
  CE_TabBarTabShape = 8
  CE_ToolBar = 41
  CE_ToolBoxTab = 27
  CE_ToolBoxTabLabel = 43
  CE_ToolBoxTabShape = 42
  CE_ToolButtonLabel = 22
  CT_CheckBox = 1
  CT_ComboBox = 4
  CT_CustomBase = -268435456
  CT_DialogButtons = 20
  CT_GroupBox = 22
  CT_HeaderSection = 21
  CT_ItemViewItem = 24
  CT_LineEdit = 16
  CT_MdiControls = 23
  CT_Menu = 11
  CT_MenuBar = 10
  CT_MenuBarItem = 9
  CT_MenuItem = 8
  CT_ProgressBar = 7
  CT_PushButton = 0
  CT_Q3DockWindow = 6
  CT_Q3Header = 15
  CT_RadioButton = 2
  CT_ScrollBar = 14
  CT_SizeGrip = 18
  CT_Slider = 13
  CT_SpinBox = 17
  CT_Splitter = 5
  CT_TabBarTab = 12
  CT_TabWidget = 19
  CT_ToolButton = 3
  PE_CustomBase = 251658240
  PE_Frame = 5
  PE_FrameButtonBevel = 15
  PE_FrameButtonTool = 16
  PE_FrameDefaultButton = 6
  PE_FrameDockWidget = 7
  PE_FrameFocusRect = 8
  PE_FrameGroupBox = 9
  PE_FrameLineEdit = 10
  PE_FrameMenu = 11
  PE_FrameStatusBar = 12
  PE_FrameStatusBarItem = 12
  PE_FrameTabBarBase = 17
  PE_FrameTabWidget = 13
  PE_FrameWindow = 14
  PE_IndicatorArrowDown = 24
  PE_IndicatorArrowLeft = 25
  PE_IndicatorArrowRight = 26
  PE_IndicatorArrowUp = 27
  PE_IndicatorBranch = 28
  PE_IndicatorButtonDropDown = 29
  PE_IndicatorCheckBox = 31
  PE_IndicatorColumnViewArrow = 47
  PE_IndicatorDockWidgetResizeHandle = 32
  PE_IndicatorHeaderArrow = 33
  PE_IndicatorItemViewItemCheck = 30
  PE_IndicatorItemViewItemDrop = 48
  PE_IndicatorMenuCheckMark = 34
  PE_IndicatorProgressChunk = 35
  PE_IndicatorRadioButton = 36
  PE_IndicatorSpinDown = 37
  PE_IndicatorSpinMinus = 38
  PE_IndicatorSpinPlus = 39
  PE_IndicatorSpinUp = 40
  PE_IndicatorTabClose = 52
  PE_IndicatorTabTear = 44
  PE_IndicatorToolBarHandle = 41
  PE_IndicatorToolBarSeparator = 42
  PE_IndicatorViewItemCheck = 30
  PE_PanelButtonBevel = 19
  PE_PanelButtonCommand = 18
  PE_PanelButtonTool = 20
  PE_PanelItemViewItem = 49
  PE_PanelItemViewRow = 50
  PE_PanelLineEdit = 23
  PE_PanelMenu = 53
  PE_PanelMenuBar = 21
  PE_PanelScrollAreaCorner = 45
  PE_PanelStatusBar = 51
  PE_PanelTipLabel = 43
  PE_PanelToolBar = 22
  PE_Q3CheckListController = 0
  PE_Q3CheckListExclusiveIndicator = 1
  PE_Q3CheckListIndicator = 2
  PE_Q3DockWindowSeparator = 3
  PE_Q3Separator = 4
  PE_Widget = 46
  PM_ButtonDefaultIndicator = 1
  PM_ButtonIconSize = 77
  PM_ButtonMargin = 0
  PM_ButtonShiftHorizontal = 3
  PM_ButtonShiftVertical = 4
  PM_CheckBoxLabelSpacing = 72
  PM_CheckListButtonSize = 41
  PM_CheckListControllerSize = 42
  PM_ComboBoxFrameWidth = 7
  PM_CustomBase = -268435456
  PM_DefaultChildMargin = 62
  PM_DefaultFrameWidth = 5
  PM_DefaultLayoutSpacing = 63
  PM_DefaultTopLevelMargin = 61
  PM_DialogButtonsButtonHeight = 45
  PM_DialogButtonsButtonWidth = 44
  PM_DialogButtonsSeparator = 43
  PM_DockWidgetFrameWidth = 18
  PM_DockWidgetHandleExtent = 17
  PM_DockWidgetSeparatorExtent = 16
  PM_DockWidgetTitleBarButtonMargin = 78
  PM_DockWidgetTitleMargin = 75
  PM_ExclusiveIndicatorHeight = 40
  PM_ExclusiveIndicatorWidth = 39
  PM_FocusFrameHMargin = 70
  PM_FocusFrameVMargin = 69
  PM_HeaderGripMargin = 50
  PM_HeaderMargin = 48
  PM_HeaderMarkSize = 49
  PM_IconViewIconSize = 66
  PM_IndicatorHeight = 38
  PM_IndicatorWidth = 37
  PM_LargeIconSize = 68
  PM_LayoutBottomMargin = 83
  PM_LayoutHorizontalSpacing = 84
  PM_LayoutLeftMargin = 80
  PM_LayoutRightMargin = 82
  PM_LayoutTopMargin = 81
  PM_LayoutVerticalSpacing = 85
  PM_ListViewIconSize = 65
  PM_MDIFrameWidth = 46
  PM_MDIMinimizedWidth = 47
  PM_MaximumDragDistance = 8
  PM_MdiSubWindowFrameWidth = 46
  PM_MdiSubWindowMinimizedWidth = 47
  PM_MenuBarHMargin = 36
  PM_MenuBarItemSpacing = 34
  PM_MenuBarPanelWidth = 33
  PM_MenuBarVMargin = 35
  PM_MenuButtonIndicator = 2
  PM_MenuDesktopFrameWidth = 32
  PM_MenuHMargin = 28
  PM_MenuPanelWidth = 30
  PM_MenuScrollerHeight = 27
  PM_MenuTearoffHeight = 31
  PM_MenuVMargin = 29
  PM_MessageBoxIconSize = 76
  PM_ProgressBarChunkWidth = 24
  PM_RadioButtonLabelSpacing = 79
  PM_ScrollBarExtent = 9
  PM_ScrollBarSliderMin = 10
  PM_ScrollView_ScrollBarSpacing = 90
  PM_SizeGripSize = 74
  PM_SliderControlThickness = 12
  PM_SliderLength = 13
  PM_SliderSpaceAvailable = 15
  PM_SliderThickness = 11
  PM_SliderTickmarkOffset = 14
  PM_SmallIconSize = 67
  PM_SpinBoxFrameWidth = 6
  PM_SpinBoxSliderHeight = 60
  PM_SplitterWidth = 25
  PM_SubMenuOverlap = 91
  PM_TabBarBaseHeight = 22
  PM_TabBarBaseOverlap = 23
  PM_TabBarIconSize = 73
  PM_TabBarScrollButtonWidth = 53
  PM_TabBarTabHSpace = 20
  PM_TabBarTabOverlap = 19
  PM_TabBarTabShiftHorizontal = 51
  PM_TabBarTabShiftVertical = 52
  PM_TabBarTabVSpace = 21
  PM_TabBar_ScrollButtonOverlap = 86
  PM_TabCloseIndicatorHeight = 89
  PM_TabCloseIndicatorWidth = 88
  PM_TextCursorWidth = 87
  PM_TitleBarHeight = 26
  PM_ToolBarExtensionExtent = 59
  PM_ToolBarFrameWidth = 54
  PM_ToolBarHandleExtent = 55
  PM_ToolBarIconSize = 64
  PM_ToolBarItemMargin = 57
  PM_ToolBarItemSpacing = 56
  PM_ToolBarSeparatorExtent = 58
  PM_ToolTipLabelFrameWidth = 71
  RSIP_OnMouseClick = 1
  RSIP_OnMouseClickAndAlreadyFocused = 0
  SC_All = -1
  SC_ComboBoxArrow = 4
  SC_ComboBoxEditField = 2
  SC_ComboBoxFrame = 1
  SC_ComboBoxListBoxPopup = 8
  SC_CustomBase = -268435456
  SC_DialGroove = 1
  SC_DialHandle = 2
  SC_DialTickmarks = 4
  SC_GroupBoxCheckBox = 1
  SC_GroupBoxContents = 4
  SC_GroupBoxFrame = 8
  SC_GroupBoxLabel = 2
  SC_MdiCloseButton = 4
  SC_MdiMinButton = 1
  SC_MdiNormalButton = 2
  SC_None = 0
  SC_Q3ListView = 1
  SC_Q3ListViewBranch = 2
  SC_Q3ListViewExpand = 4
  SC_ScrollBarAddLine = 1
  SC_ScrollBarAddPage = 4
  SC_ScrollBarFirst = 16
  SC_ScrollBarGroove = 128
  SC_ScrollBarLast = 32
  SC_ScrollBarSlider = 64
  SC_ScrollBarSubLine = 2
  SC_ScrollBarSubPage = 8
  SC_SliderGroove = 1
  SC_SliderHandle = 2
  SC_SliderTickmarks = 4
  SC_SpinBoxDown = 2
  SC_SpinBoxEditField = 8
  SC_SpinBoxFrame = 4
  SC_SpinBoxUp = 1
  SC_TitleBarCloseButton = 8
  SC_TitleBarContextHelpButton = 128
  SC_TitleBarLabel = 256
  SC_TitleBarMaxButton = 4
  SC_TitleBarMinButton = 2
  SC_TitleBarNormalButton = 16
  SC_TitleBarShadeButton = 32
  SC_TitleBarSysMenu = 1
  SC_TitleBarUnshadeButton = 64
  SC_ToolButton = 1
  SC_ToolButtonMenu = 2
  SE_CheckBoxClickRect = 5
  SE_CheckBoxContents = 3
  SE_CheckBoxFocusRect = 4
  SE_CheckBoxIndicator = 2
  SE_CheckBoxLayoutItem = 42
  SE_ComboBoxFocusRect = 10
  SE_ComboBoxLayoutItem = 43
  SE_CustomBase = -268435456
  SE_DateTimeEditLayoutItem = 44
  SE_DialogButtonAbort = 21
  SE_DialogButtonAccept = 16
  SE_DialogButtonAll = 20
  SE_DialogButtonApply = 18
  SE_DialogButtonBoxLayoutItem = 45
  SE_DialogButtonCustom = 24
  SE_DialogButtonHelp = 19
  SE_DialogButtonIgnore = 22
  SE_DialogButtonReject = 17
  SE_DialogButtonRetry = 23
  SE_DockWidgetCloseButton = 38
  SE_DockWidgetFloatButton = 39
  SE_DockWidgetIcon = 41
  SE_DockWidgetTitleBarText = 40
  SE_FrameContents = 37
  SE_FrameLayoutItem = 53
  SE_GroupBoxLayoutItem = 54
  SE_HeaderArrow = 27
  SE_HeaderLabel = 26
  SE_ItemViewItemCheckIndicator = 33
  SE_ItemViewItemDecoration = 56
  SE_ItemViewItemFocusRect = 58
  SE_ItemViewItemText = 57
  SE_LabelLayoutItem = 46
  SE_LineEditContents = 36
  SE_ProgressBarContents = 14
  SE_ProgressBarGroove = 13
  SE_ProgressBarLabel = 15
  SE_ProgressBarLayoutItem = 47
  SE_PushButtonContents = 0
  SE_PushButtonFocusRect = 1
  SE_PushButtonLayoutItem = 48
  SE_Q3DockWindowHandleRect = 12
  SE_RadioButtonClickRect = 9
  SE_RadioButtonContents = 7
  SE_RadioButtonFocusRect = 8
  SE_RadioButtonIndicator = 6
  SE_RadioButtonLayoutItem = 49
  SE_ShapedFrameContents = 62
  SE_SliderFocusRect = 11
  SE_SliderLayoutItem = 50
  SE_SpinBoxLayoutItem = 51
  SE_TabBarTabLeftButton = 59
  SE_TabBarTabRightButton = 60
  SE_TabBarTabText = 61
  SE_TabBarTearIndicator = 34
  SE_TabWidgetLayoutItem = 55
  SE_TabWidgetLeftCorner = 31
  SE_TabWidgetRightCorner = 32
  SE_TabWidgetTabBar = 28
  SE_TabWidgetTabContents = 30
  SE_TabWidgetTabPane = 29
  SE_ToolBarHandle = 63
  SE_ToolBoxTabContents = 25
  SE_ToolButtonLayoutItem = 52
  SE_TreeViewDisclosureItem = 35
  SE_ViewItemCheckIndicator = 33
  SH_BlinkCursorWhenTextSelected = 28
  SH_Button_FocusPolicy = 49
  SH_ComboBox_LayoutDirection = 59
  SH_ComboBox_ListMouseTracking = 19
  SH_ComboBox_Popup = 25
  SH_ComboBox_PopupFrameStyle = 70
  SH_CustomBase = -268435456
  SH_Dial_BackgroundRole = 58
  SH_DialogButtonBox_ButtonsHaveIcons = 72
  SH_DialogButtonLayout = 69
  SH_DialogButtons_DefaultButton = 36
  SH_DitherDisabledText = 1
  SH_DockWidget_ButtonsHaveFrame = 95
  SH_DrawMenuBarSeparator = 47
  SH_EtchDisabledText = 0
  SH_FocusFrame_AboveWidget = 78
  SH_FocusFrame_Mask = 54
  SH_FontDialog_SelectAssociatedText = 13
  SH_FormLayoutFieldGrowthPolicy = 90
  SH_FormLayoutFormAlignment = 91
  SH_FormLayoutLabelAlignment = 92
  SH_FormLayoutWrapPolicy = 87
  SH_GroupBox_TextLabelColor = 32
  SH_GroupBox_TextLabelVerticalAlignment = 31
  SH_Header_ArrowAlignment = 6
  SH_ItemView_ActivateItemOnSingleClick = 62
  SH_ItemView_ArrowKeysNavigateIntoChildren = 81
  SH_ItemView_ChangeHighlightOnFocus = 22
  SH_ItemView_DrawDelegateFrame = 93
  SH_ItemView_EllipsisLocation = 60
  SH_ItemView_MovementWithoutUpdatingSelection = 76
  SH_ItemView_PaintAlternatingRowColorsForEmptyArea = 86
  SH_ItemView_ShowDecorationSelected = 61
  SH_LineEdit_PasswordCharacter = 35
  SH_MainWindow_SpaceBelowMenuBar = 12
  SH_MenuBar_AltKeyNavigation = 18
  SH_MenuBar_DismissOnSecondClick = 50
  SH_MenuBar_MouseTracking = 21
  SH_Menu_AllowActiveAndDisabled = 14
  SH_Menu_FadeOutOnHide = 84
  SH_Menu_FillScreenWithScroll = 45
  SH_Menu_FlashTriggeredItem = 83
  SH_Menu_KeyboardSearch = 67
  SH_Menu_Mask = 82
  SH_Menu_MouseTracking = 20
  SH_Menu_Scrollable = 30
  SH_Menu_SelectionWrap = 75
  SH_Menu_SloppySubMenus = 33
  SH_Menu_SpaceActivatesItem = 15
  SH_Menu_SubMenuPopupDelay = 16
  SH_MessageBox_CenterButtons = 74
  SH_MessageBox_TextInteractionFlags = 71
  SH_MessageBox_UseBorderForButtonSpacing = 51
  SH_PrintDialog_RightAlignButtons = 11
  SH_ProgressDialog_CenterCancelButton = 9
  SH_ProgressDialog_TextLabelAlignment = 10
  SH_Q3ListViewExpand_SelectMouseType = 40
  SH_RequestSoftwareInputPanel = 97
  SH_RichText_FullWidthSelection = 29
  SH_RubberBand_Mask = 55
  SH_ScrollBar_ContextMenu = 63
  SH_ScrollBar_LeftClickAbsolutePosition = 39
  SH_ScrollBar_MiddleClickAbsolutePosition = 2
  SH_ScrollBar_RollBetweenButtons = 64
  SH_ScrollBar_ScrollWhenPointerLeavesControl = 3
  SH_ScrollBar_StopMouseOverSlider = 27
  SH_ScrollView_FrameOnlyAroundContents = 17
  SH_Slider_AbsoluteSetButtons = 65
  SH_Slider_PageSetButtons = 66
  SH_Slider_SloppyKeyEvents = 8
  SH_Slider_SnapToValue = 7
  SH_Slider_StopMouseOverSlider = 27
  SH_SpellCheckUnderlineStyle = 73
  SH_SpinBox_AnimateButton = 42
  SH_SpinBox_ClickAutoRepeatRate = 44
  SH_SpinBox_ClickAutoRepeatThreshold = 85
  SH_SpinBox_KeyPressAutoRepeatRate = 43
  SH_SpinControls_DisableOnBounds = 57
  SH_TabBar_Alignment = 5
  SH_TabBar_CloseButtonPosition = 94
  SH_TabBar_ElideMode = 68
  SH_TabBar_PreferNoArrows = 38
  SH_TabBar_SelectMouseType = 4
  SH_TabWidget_DefaultTabPosition = 88
  SH_Table_GridLineColor = 34
  SH_TextControl_FocusIndicatorTextCharFormat = 79
  SH_TitleBar_AutoRaise = 52
  SH_TitleBar_ModifyNotification = 48
  SH_TitleBar_NoBorder = 26
  SH_ToolBar_Movable = 89
  SH_ToolBox_SelectedPageTitleBold = 37
  SH_ToolButtonStyle = 96
  SH_ToolButton_PopupDelay = 53
  SH_ToolTipLabel_Opacity = 46
  SH_ToolTip_Mask = 77
  SH_UnderlineShortcut = 41
  SH_Widget_ShareActivation = 23
  SH_WindowFrame_Mask = 56
  SH_WizardStyle = 80
  SH_Workspace_FillSpaceOnMaximize = 24
  SP_ArrowBack = 53
  SP_ArrowDown = 50
  SP_ArrowForward = 54
  SP_ArrowLeft = 51
  SP_ArrowRight = 52
  SP_ArrowUp = 49
  SP_BrowserReload = 58
  SP_BrowserStop = 59
  SP_CommandLink = 56
  SP_ComputerIcon = 15
  SP_CustomBase = -268435456
  SP_DesktopIcon = 13
  SP_DialogApplyButton = 44
  SP_DialogCancelButton = 39
  SP_DialogCloseButton = 43
  SP_DialogDiscardButton = 46
  SP_DialogHelpButton = 40
  SP_DialogNoButton = 48
  SP_DialogOkButton = 38
  SP_DialogOpenButton = 41
  SP_DialogResetButton = 45
  SP_DialogSaveButton = 42
  SP_DialogYesButton = 47
  SP_DirClosedIcon = 22
  SP_DirHomeIcon = 55
  SP_DirIcon = 37
  SP_DirLinkIcon = 23
  SP_DirOpenIcon = 21
  SP_DockWidgetCloseButton = 8
  SP_DriveCDIcon = 18
  SP_DriveDVDIcon = 19
  SP_DriveFDIcon = 16
  SP_DriveHDIcon = 17
  SP_DriveNetIcon = 20
  SP_FileDialogBack = 36
  SP_FileDialogContentsView = 34
  SP_FileDialogDetailedView = 32
  SP_FileDialogEnd = 29
  SP_FileDialogInfoView = 33
  SP_FileDialogListView = 35
  SP_FileDialogNewFolder = 31
  SP_FileDialogStart = 28
  SP_FileDialogToParent = 30
  SP_FileIcon = 24
  SP_FileLinkIcon = 25
  SP_MediaPause = 62
  SP_MediaPlay = 60
  SP_MediaSeekBackward = 66
  SP_MediaSeekForward = 65
  SP_MediaSkipBackward = 64
  SP_MediaSkipForward = 63
  SP_MediaStop = 61
  SP_MediaVolume = 67
  SP_MediaVolumeMuted = 68
  SP_MessageBoxCritical = 11
  SP_MessageBoxInformation = 9
  SP_MessageBoxQuestion = 12
  SP_MessageBoxWarning = 10
  SP_TitleBarCloseButton = 3
  SP_TitleBarContextHelpButton = 7
  SP_TitleBarMaxButton = 2
  SP_TitleBarMenuButton = 0
  SP_TitleBarMinButton = 1
  SP_TitleBarNormalButton = 4
  SP_TitleBarShadeButton = 5
  SP_TitleBarUnshadeButton = 6
  SP_ToolBarHorizontalExtensionButton = 26
  SP_ToolBarVerticalExtensionButton = 27
  SP_TrashIcon = 14
  SP_VistaShield = 57
  State_Active = 65536
  State_AutoRaise = 4096
  State_Bottom = 1024
  State_Children = 524288
  State_DownArrow = 64
  State_Editing = 4194304
  State_Enabled = 1
  State_FocusAtBorder = 2048
  State_HasFocus = 256
  State_Horizontal = 128
  State_Item = 1048576
  State_KeyboardFocusChange = 8388608
  State_Mini = 134217728
  State_MouseOver = 8192
  State_NoChange = 16
  State_None = 0
  State_Off = 8
  State_On = 32
  State_Open = 262144
  State_Raised = 2
  State_ReadOnly = 33554432
  State_Selected = 32768
  State_Sibling = 2097152
  State_Small = 67108864
  State_Sunken = 4
  State_Top = 512
  State_UpArrow = 16384
  State_Window = 131072

class QToolButton(_Mock):
  pass
  DelayedPopup = 0
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  InstantPopup = 2
  MenuButtonPopup = 1
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class QVBoxLayout(_Mock):
  pass
  BottomToTop = 3
  Down = 2
  LeftToRight = 0
  RightToLeft = 1
  SetDefaultConstraint = 0
  SetFixedSize = 3
  SetMaximumSize = 4
  SetMinAndMaxSize = 5
  SetMinimumSize = 2
  SetNoConstraint = 1
  TopToBottom = 2
  Up = 3

class QWidget(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class Qt(_Mock):
  pass
  AA_CaptureMultimediaKeys = 11
  AA_DontCreateNativeWidgetSiblings = 4
  AA_DontShowIconsInMenus = 2
  AA_DontUseNativeMenuBar = 6
  AA_ImmediateWidgetCreation = 0
  AA_MSWindowsUseDirect3DByDefault = 1
  AA_MacDontSwapCtrlAndMeta = 7
  AA_MacPluginApplication = 5
  AA_NativeWindows = 3
  AA_S60DisablePartialScreenInputMode = 9
  AA_S60DontConstructApplicationPanes = 8
  AA_X11InitThreads = 10
  ALT = 134217728
  AbsoluteSize = 0
  AccessibleDescriptionRole = 12
  AccessibleTextRole = 11
  ActionMask = 255
  ActionsContextMenu = 2
  ActiveWindowFocusReason = 3
  AlignAbsolute = 16
  AlignBottom = 64
  AlignCenter = 132
  AlignHCenter = 4
  AlignHorizontal_Mask = 31
  AlignJustify = 8
  AlignLeading = 1
  AlignLeft = 1
  AlignRight = 2
  AlignTop = 32
  AlignTrailing = 2
  AlignVCenter = 128
  AlignVertical_Mask = 224
  AllDockWidgetAreas = 15
  AllToolBarAreas = 15
  AltModifier = 134217728
  AnchorBottom = 5
  AnchorHorizontalCenter = 1
  AnchorHref = 1
  AnchorLeft = 0
  AnchorName = 0
  AnchorRight = 2
  AnchorTop = 3
  AnchorVerticalCenter = 4
  ApplicationModal = 2
  ApplicationShortcut = 2
  ArrowCursor = 0
  AscendingOrder = 0
  AutoColor = 0
  AutoCompatConnection = 3
  AutoConnection = 0
  AutoDither = 0
  AutoText = 2
  AvoidDither = 128
  BDiagPattern = 12
  BackgroundColorRole = 8
  BackgroundRole = 8
  BacktabFocusReason = 2
  BevelJoin = 64
  BitmapCursor = 24
  BlankCursor = 10
  BlockingQueuedConnection = 4
  BottomDockWidgetArea = 8
  BottomLeftCorner = 2
  BottomLeftSection = 8
  BottomRightCorner = 3
  BottomRightSection = 6
  BottomSection = 7
  BottomToolBarArea = 8
  BusyCursor = 16
  BypassGraphicsProxyWidget = 536870912
  CTRL = 67108864
  CaseInsensitive = 0
  CaseSensitive = 1
  CheckStateRole = 10
  Checked = 2
  ClickFocus = 2
  ClosedHandCursor = 18
  ColorOnly = 3
  ConicalGradientPattern = 17
  ContainsItemBoundingRect = 2
  ContainsItemShape = 0
  ControlModifier = 67108864
  CopyAction = 1
  CrossCursor = 2
  CrossPattern = 11
  CustomContextMenu = 3
  CustomCursor = 25
  CustomDashLine = 6
  CustomGesture = 256
  CustomizeWindowHint = 33554432
  DashDotDotLine = 5
  DashDotLine = 4
  DashLine = 2
  DecorationRole = 1
  DefaultContextMenu = 1
  DefaultLocaleLongDate = 7
  DefaultLocaleShortDate = 6
  Dense1Pattern = 2
  Dense2Pattern = 3
  Dense3Pattern = 4
  Dense4Pattern = 5
  Dense5Pattern = 6
  Dense6Pattern = 7
  Dense7Pattern = 8
  DescendingOrder = 1
  Desktop = 17
  DeviceCoordinates = 0
  DiagCrossPattern = 14
  Dialog = 3
  DiffuseAlphaDither = 8
  DiffuseDither = 0
  DirectConnection = 1
  DisplayRole = 0
  DockWidgetArea_Mask = 15
  DontStartGestureOnChildren = 1
  DotLine = 3
  DownArrow = 2
  DragCopyCursor = 19
  DragLinkCursor = 21
  DragMoveCursor = 20
  Drawer = 7
  EditRole = 2
  ElideLeft = 0
  ElideMiddle = 2
  ElideNone = 3
  ElideRight = 1
  ExactHit = 0
  FDiagPattern = 13
  FastTransformation = 0
  FlatCap = 0
  FontRole = 6
  ForbiddenCursor = 14
  ForegroundRole = 9
  FramelessWindowHint = 2048
  Friday = 5
  FuzzyHit = 1
  GestureCanceled = 4
  GestureFinished = 3
  GestureStarted = 1
  GestureUpdated = 2
  GroupSwitchModifier = 1073741824
  HighEventPriority = 1
  HorPattern = 9
  Horizontal = 1
  IBeamCursor = 4
  ISODate = 1
  IgnoreAction = 0
  IgnoreAspectRatio = 0
  IgnoredGesturesPropagateToParent = 4
  ImAnchorPosition = 6
  ImCurrentSelection = 4
  ImCursorPosition = 2
  ImFont = 1
  ImMaximumTextLength = 5
  ImMicroFocus = 0
  ImSurroundingText = 3
  ImhDialableCharactersOnly = 1048576
  ImhDigitsOnly = 65536
  ImhEmailCharactersOnly = 2097152
  ImhExclusiveInputMask = -65536
  ImhFormattedNumbersOnly = 131072
  ImhHiddenText = 1
  ImhLowercaseOnly = 524288
  ImhNoAutoUppercase = 2
  ImhNoPredictiveText = 32
  ImhNone = 0
  ImhPreferLowercase = 16
  ImhPreferNumbers = 4
  ImhPreferUppercase = 8
  ImhUppercaseOnly = 262144
  ImhUrlCharactersOnly = 4194304
  InitialSortOrderRole = 14
  IntersectClip = 2
  IntersectsItemBoundingRect = 3
  IntersectsItemShape = 1
  ItemIsDragEnabled = 4
  ItemIsDropEnabled = 8
  ItemIsEditable = 2
  ItemIsEnabled = 32
  ItemIsSelectable = 1
  ItemIsTristate = 64
  ItemIsUserCheckable = 16
  KeepAspectRatio = 1
  KeepAspectRatioByExpanding = 2
  Key_0 = 48
  Key_1 = 49
  Key_2 = 50
  Key_3 = 51
  Key_4 = 52
  Key_5 = 53
  Key_6 = 54
  Key_7 = 55
  Key_8 = 56
  Key_9 = 57
  Key_A = 65
  Key_AE = 198
  Key_Aacute = 193
  Key_Acircumflex = 194
  Key_AddFavorite = 16777408
  Key_Adiaeresis = 196
  Key_Agrave = 192
  Key_Alt = 16777251
  Key_AltGr = 16781571
  Key_Ampersand = 38
  Key_Any = 32
  Key_Apostrophe = 39
  Key_ApplicationLeft = 16777415
  Key_ApplicationRight = 16777416
  Key_Aring = 197
  Key_AsciiCircum = 94
  Key_AsciiTilde = 126
  Key_Asterisk = 42
  Key_At = 64
  Key_Atilde = 195
  Key_AudioCycleTrack = 16777478
  Key_AudioForward = 16777474
  Key_AudioRandomPlay = 16777476
  Key_AudioRepeat = 16777475
  Key_AudioRewind = 16777413
  Key_Away = 16777464
  Key_B = 66
  Key_Back = 16777313
  Key_BackForward = 16777414
  Key_Backslash = 92
  Key_Backspace = 16777219
  Key_Backtab = 16777218
  Key_Bar = 124
  Key_BassBoost = 16777331
  Key_BassDown = 16777333
  Key_BassUp = 16777332
  Key_Battery = 16777470
  Key_Bluetooth = 16777471
  Key_Book = 16777417
  Key_BraceLeft = 123
  Key_BraceRight = 125
  Key_BracketLeft = 91
  Key_BracketRight = 93
  Key_BrightnessAdjust = 16777410
  Key_C = 67
  Key_CD = 16777418
  Key_Calculator = 16777419
  Key_Calendar = 16777444
  Key_Call = 17825796
  Key_Camera = 17825824
  Key_CameraFocus = 17825825
  Key_Cancel = 16908289
  Key_CapsLock = 16777252
  Key_Ccedilla = 199
  Key_Clear = 16777227
  Key_ClearGrab = 16777421
  Key_Close = 16777422
  Key_Codeinput = 16781623
  Key_Colon = 58
  Key_Comma = 44
  Key_Community = 16777412
  Key_Context1 = 17825792
  Key_Context2 = 17825793
  Key_Context3 = 17825794
  Key_Context4 = 17825795
  Key_ContrastAdjust = 16777485
  Key_Control = 16777249
  Key_Copy = 16777423
  Key_Cut = 16777424
  Key_D = 68
  Key_DOS = 16777426
  Key_Dead_Abovedot = 16781910
  Key_Dead_Abovering = 16781912
  Key_Dead_Acute = 16781905
  Key_Dead_Belowdot = 16781920
  Key_Dead_Breve = 16781909
  Key_Dead_Caron = 16781914
  Key_Dead_Cedilla = 16781915
  Key_Dead_Circumflex = 16781906
  Key_Dead_Diaeresis = 16781911
  Key_Dead_Doubleacute = 16781913
  Key_Dead_Grave = 16781904
  Key_Dead_Hook = 16781921
  Key_Dead_Horn = 16781922
  Key_Dead_Iota = 16781917
  Key_Dead_Macron = 16781908
  Key_Dead_Ogonek = 16781916
  Key_Dead_Semivoiced_Sound = 16781919
  Key_Dead_Tilde = 16781907
  Key_Dead_Voiced_Sound = 16781918
  Key_Delete = 16777223
  Key_Direction_L = 16777305
  Key_Direction_R = 16777312
  Key_Display = 16777425
  Key_Documents = 16777427
  Key_Dollar = 36
  Key_Down = 16777237
  Key_E = 69
  Key_ETH = 208
  Key_Eacute = 201
  Key_Ecircumflex = 202
  Key_Ediaeresis = 203
  Key_Egrave = 200
  Key_Eisu_Shift = 16781615
  Key_Eisu_toggle = 16781616
  Key_Eject = 16777401
  Key_End = 16777233
  Key_Enter = 16777221
  Key_Equal = 61
  Key_Escape = 16777216
  Key_Excel = 16777428
  Key_Exclam = 33
  Key_Execute = 16908291
  Key_Explorer = 16777429
  Key_F = 70
  Key_F1 = 16777264
  Key_F10 = 16777273
  Key_F11 = 16777274
  Key_F12 = 16777275
  Key_F13 = 16777276
  Key_F14 = 16777277
  Key_F15 = 16777278
  Key_F16 = 16777279
  Key_F17 = 16777280
  Key_F18 = 16777281
  Key_F19 = 16777282
  Key_F2 = 16777265
  Key_F20 = 16777283
  Key_F21 = 16777284
  Key_F22 = 16777285
  Key_F23 = 16777286
  Key_F24 = 16777287
  Key_F25 = 16777288
  Key_F26 = 16777289
  Key_F27 = 16777290
  Key_F28 = 16777291
  Key_F29 = 16777292
  Key_F3 = 16777266
  Key_F30 = 16777293
  Key_F31 = 16777294
  Key_F32 = 16777295
  Key_F33 = 16777296
  Key_F34 = 16777297
  Key_F35 = 16777298
  Key_F4 = 16777267
  Key_F5 = 16777268
  Key_F6 = 16777269
  Key_F7 = 16777270
  Key_F8 = 16777271
  Key_F9 = 16777272
  Key_Favorites = 16777361
  Key_Finance = 16777411
  Key_Flip = 17825798
  Key_Forward = 16777314
  Key_G = 71
  Key_Game = 16777430
  Key_Go = 16777431
  Key_Greater = 62
  Key_H = 72
  Key_Hangul = 16781617
  Key_Hangul_Banja = 16781625
  Key_Hangul_End = 16781619
  Key_Hangul_Hanja = 16781620
  Key_Hangul_Jamo = 16781621
  Key_Hangul_Jeonja = 16781624
  Key_Hangul_PostHanja = 16781627
  Key_Hangul_PreHanja = 16781626
  Key_Hangul_Romaja = 16781622
  Key_Hangul_Special = 16781631
  Key_Hangul_Start = 16781618
  Key_Hangup = 17825797
  Key_Hankaku = 16781609
  Key_Help = 16777304
  Key_Henkan = 16781603
  Key_Hibernate = 16777480
  Key_Hiragana = 16781605
  Key_Hiragana_Katakana = 16781607
  Key_History = 16777407
  Key_Home = 16777232
  Key_HomePage = 16777360
  Key_HotLinks = 16777409
  Key_Hyper_L = 16777302
  Key_Hyper_R = 16777303
  Key_I = 73
  Key_Iacute = 205
  Key_Icircumflex = 206
  Key_Idiaeresis = 207
  Key_Igrave = 204
  Key_Insert = 16777222
  Key_J = 74
  Key_K = 75
  Key_Kana_Lock = 16781613
  Key_Kana_Shift = 16781614
  Key_Kanji = 16781601
  Key_Katakana = 16781606
  Key_KeyboardBrightnessDown = 16777398
  Key_KeyboardBrightnessUp = 16777397
  Key_KeyboardLightOnOff = 16777396
  Key_L = 76
  Key_LastNumberRedial = 17825801
  Key_Launch0 = 16777378
  Key_Launch1 = 16777379
  Key_Launch2 = 16777380
  Key_Launch3 = 16777381
  Key_Launch4 = 16777382
  Key_Launch5 = 16777383
  Key_Launch6 = 16777384
  Key_Launch7 = 16777385
  Key_Launch8 = 16777386
  Key_Launch9 = 16777387
  Key_LaunchA = 16777388
  Key_LaunchB = 16777389
  Key_LaunchC = 16777390
  Key_LaunchD = 16777391
  Key_LaunchE = 16777392
  Key_LaunchF = 16777393
  Key_LaunchG = 16777486
  Key_LaunchH = 16777487
  Key_LaunchMail = 16777376
  Key_LaunchMedia = 16777377
  Key_Left = 16777234
  Key_Less = 60
  Key_LightBulb = 16777405
  Key_LogOff = 16777433
  Key_M = 77
  Key_MailForward = 16777467
  Key_Market = 16777434
  Key_Massyo = 16781612
  Key_MediaLast = 16842751
  Key_MediaNext = 16777347
  Key_MediaPause = 16777349
  Key_MediaPlay = 16777344
  Key_MediaPrevious = 16777346
  Key_MediaRecord = 16777348
  Key_MediaStop = 16777345
  Key_MediaTogglePlayPause = 16777350
  Key_Meeting = 16777435
  Key_Memo = 16777404
  Key_Menu = 16777301
  Key_MenuKB = 16777436
  Key_MenuPB = 16777437
  Key_Messenger = 16777465
  Key_Meta = 16777250
  Key_Minus = 45
  Key_Mode_switch = 16781694
  Key_MonBrightnessDown = 16777395
  Key_MonBrightnessUp = 16777394
  Key_Muhenkan = 16781602
  Key_Multi_key = 16781600
  Key_MultipleCandidate = 16781629
  Key_Music = 16777469
  Key_MySites = 16777438
  Key_N = 78
  Key_News = 16777439
  Key_No = 16842754
  Key_Ntilde = 209
  Key_NumLock = 16777253
  Key_NumberSign = 35
  Key_O = 79
  Key_Oacute = 211
  Key_Ocircumflex = 212
  Key_Odiaeresis = 214
  Key_OfficeHome = 16777440
  Key_Ograve = 210
  Key_Ooblique = 216
  Key_OpenUrl = 16777364
  Key_Option = 16777441
  Key_Otilde = 213
  Key_P = 80
  Key_PageDown = 16777239
  Key_PageUp = 16777238
  Key_ParenLeft = 40
  Key_ParenRight = 41
  Key_Paste = 16777442
  Key_Pause = 16777224
  Key_Percent = 37
  Key_Period = 46
  Key_Phone = 16777443
  Key_Pictures = 16777468
  Key_Play = 16908293
  Key_Plus = 43
  Key_PowerDown = 16777483
  Key_PowerOff = 16777399
  Key_PreviousCandidate = 16781630
  Key_Print = 16777225
  Key_Printer = 16908290
  Key_Q = 81
  Key_Question = 63
  Key_QuoteDbl = 34
  Key_QuoteLeft = 96
  Key_R = 82
  Key_Refresh = 16777316
  Key_Reload = 16777446
  Key_Reply = 16777445
  Key_Return = 16777220
  Key_Right = 16777236
  Key_Romaji = 16781604
  Key_RotateWindows = 16777447
  Key_RotationKB = 16777449
  Key_RotationPB = 16777448
  Key_S = 83
  Key_Save = 16777450
  Key_ScreenSaver = 16777402
  Key_ScrollLock = 16777254
  Key_Search = 16777362
  Key_Select = 16842752
  Key_Semicolon = 59
  Key_Send = 16777451
  Key_Shift = 16777248
  Key_Shop = 16777406
  Key_SingleCandidate = 16781628
  Key_Slash = 47
  Key_Sleep = 16908292
  Key_Space = 32
  Key_Spell = 16777452
  Key_SplitScreen = 16777453
  Key_Standby = 16777363
  Key_Stop = 16777315
  Key_Subtitle = 16777477
  Key_Super_L = 16777299
  Key_Super_R = 16777300
  Key_Support = 16777454
  Key_Suspend = 16777484
  Key_SysReq = 16777226
  Key_T = 84
  Key_THORN = 222
  Key_Tab = 16777217
  Key_TaskPane = 16777455
  Key_Terminal = 16777456
  Key_Time = 16777479
  Key_ToDoList = 16777420
  Key_ToggleCallHangup = 17825799
  Key_Tools = 16777457
  Key_TopMenu = 16777482
  Key_Touroku = 16781611
  Key_Travel = 16777458
  Key_TrebleDown = 16777335
  Key_TrebleUp = 16777334
  Key_U = 85
  Key_UWB = 16777473
  Key_Uacute = 218
  Key_Ucircumflex = 219
  Key_Udiaeresis = 220
  Key_Ugrave = 217
  Key_Underscore = 95
  Key_Up = 16777235
  Key_V = 86
  Key_Video = 16777459
  Key_View = 16777481
  Key_VoiceDial = 17825800
  Key_VolumeDown = 16777328
  Key_VolumeMute = 16777329
  Key_VolumeUp = 16777330
  Key_W = 87
  Key_WLAN = 16777472
  Key_WWW = 16777403
  Key_WakeUp = 16777400
  Key_WebCam = 16777466
  Key_Word = 16777460
  Key_X = 88
  Key_Xfer = 16777461
  Key_Y = 89
  Key_Yacute = 221
  Key_Yes = 16842753
  Key_Z = 90
  Key_Zenkaku = 16781608
  Key_Zenkaku_Hankaku = 16781610
  Key_Zoom = 16908294
  Key_ZoomIn = 16777462
  Key_ZoomOut = 16777463
  Key_acute = 180
  Key_brokenbar = 166
  Key_cedilla = 184
  Key_cent = 162
  Key_copyright = 169
  Key_currency = 164
  Key_degree = 176
  Key_diaeresis = 168
  Key_division = 247
  Key_exclamdown = 161
  Key_guillemotleft = 171
  Key_guillemotright = 187
  Key_hyphen = 173
  Key_iTouch = 16777432
  Key_macron = 175
  Key_masculine = 186
  Key_mu = 181
  Key_multiply = 215
  Key_nobreakspace = 160
  Key_notsign = 172
  Key_onehalf = 189
  Key_onequarter = 188
  Key_onesuperior = 185
  Key_ordfeminine = 170
  Key_paragraph = 182
  Key_periodcentered = 183
  Key_plusminus = 177
  Key_questiondown = 191
  Key_registered = 174
  Key_section = 167
  Key_ssharp = 223
  Key_sterling = 163
  Key_threequarters = 190
  Key_threesuperior = 179
  Key_twosuperior = 178
  Key_unknown = 33554431
  Key_ydiaeresis = 255
  Key_yen = 165
  KeyboardModifierMask = -33554432
  KeypadModifier = 536870912
  LastCursor = 21
  LayoutDirectionAuto = 2
  LeftArrow = 3
  LeftButton = 1
  LeftDockWidgetArea = 1
  LeftSection = 1
  LeftToRight = 0
  LeftToolBarArea = 1
  LinearGradientPattern = 15
  LinkAction = 4
  LinksAccessibleByKeyboard = 8
  LinksAccessibleByMouse = 4
  LocalDate = 2
  LocalTime = 0
  LocaleDate = 3
  LogText = 3
  LogicalCoordinates = 1
  LogicalMoveStyle = 0
  LowEventPriority = -1
  META = 268435456
  MODIFIER_MASK = -33554432
  MPenCapStyle = 48
  MPenJoinStyle = 448
  MPenStyle = 15
  MSWindowsFixedSizeDialogHint = 256
  MSWindowsOwnDC = 512
  MacWindowToolBarButtonHint = 268435456
  MaskInColor = 0
  MaskOutColor = 1
  MatchCaseSensitive = 16
  MatchContains = 1
  MatchEndsWith = 3
  MatchExactly = 0
  MatchFixedString = 8
  MatchRecursive = 64
  MatchRegExp = 4
  MatchStartsWith = 2
  MatchWildcard = 5
  MatchWrap = 32
  MaximumSize = 2
  MenuBarFocusReason = 6
  MetaModifier = 268435456
  MidButton = 4
  MiddleButton = 4
  MinimumDescent = 3
  MinimumSize = 0
  MiterJoin = 0
  Monday = 1
  MonoOnly = 2
  MouseFocusReason = 0
  MoveAction = 2
  NavigationModeCursorAuto = 3
  NavigationModeCursorForceVisible = 4
  NavigationModeKeypadDirectional = 2
  NavigationModeKeypadTabOrder = 1
  NavigationModeNone = 0
  NoArrow = 0
  NoBrush = 0
  NoButton = 0
  NoClip = 0
  NoContextMenu = 0
  NoDockWidgetArea = 0
  NoFocus = 0
  NoFocusReason = 8
  NoItemFlags = 0
  NoModifier = 0
  NoPen = 0
  NoSection = 0
  NoTextInteraction = 0
  NoToolBarArea = 0
  NonModal = 0
  NormalEventPriority = 0
  OddEvenFill = 0
  OffsetFromUTC = 2
  OpaqueMode = 1
  OpenHandCursor = 17
  OrderedAlphaDither = 4
  OrderedDither = 16
  OtherFocusReason = 7
  PanGesture = 3
  PartiallyChecked = 1
  PinchGesture = 4
  PlainText = 0
  PointingHandCursor = 13
  Popup = 9
  PopupFocusReason = 4
  PreferDither = 64
  PreferredSize = 1
  PreventContextMenu = 4
  QueuedConnection = 2
  RadialGradientPattern = 16
  ReceivePartialGestures = 2
  RelativeSize = 1
  RepeatTile = 1
  ReplaceClip = 1
  RichText = 1
  RightArrow = 4
  RightButton = 2
  RightDockWidgetArea = 2
  RightSection = 5
  RightToLeft = 1
  RightToolBarArea = 2
  RoundCap = 32
  RoundJoin = 128
  RoundTile = 2
  SHIFT = 33554432
  Saturday = 6
  ScrollBarAlwaysOff = 1
  ScrollBarAlwaysOn = 2
  ScrollBarAsNeeded = 0
  Sheet = 5
  ShiftModifier = 33554432
  ShortcutFocusReason = 5
  SizeAllCursor = 9
  SizeBDiagCursor = 7
  SizeFDiagCursor = 8
  SizeHintRole = 13
  SizeHorCursor = 6
  SizeVerCursor = 5
  SmoothTransformation = 1
  SolidLine = 1
  SolidPattern = 1
  SplashScreen = 15
  SplitHCursor = 12
  SplitVCursor = 11
  SquareCap = 16
  StatusTipRole = 4
  StretchTile = 0
  StrongFocus = 11
  SubWindow = 18
  Sunday = 7
  SvgMiterJoin = 256
  SwipeGesture = 5
  SystemLocaleDate = 2
  SystemLocaleLongDate = 5
  SystemLocaleShortDate = 4
  TabFocus = 1
  TabFocusReason = 1
  TapAndHoldGesture = 2
  TapGesture = 1
  TargetMoveAction = 32770
  TextAlignmentRole = 7
  TextBrowserInteraction = 13
  TextColorRole = 9
  TextDate = 0
  TextDontClip = 512
  TextDontPrint = 16384
  TextEditable = 16
  TextEditorInteraction = 19
  TextExpandTabs = 1024
  TextHideMnemonic = 32768
  TextIncludeTrailingSpaces = 134217728
  TextJustificationForced = 65536
  TextSelectableByKeyboard = 2
  TextSelectableByMouse = 1
  TextShowMnemonic = 2048
  TextSingleLine = 256
  TextWordWrap = 4096
  TextWrapAnywhere = 8192
  TexturePattern = 24
  ThresholdAlphaDither = 0
  ThresholdDither = 32
  Thursday = 4
  TitleBarArea = 9
  Tool = 11
  ToolBarArea_Mask = 15
  ToolButtonFollowStyle = 4
  ToolButtonIconOnly = 0
  ToolButtonTextBesideIcon = 2
  ToolButtonTextOnly = 1
  ToolButtonTextUnderIcon = 3
  ToolTip = 13
  ToolTipRole = 3
  TopDockWidgetArea = 4
  TopLeftCorner = 0
  TopLeftSection = 2
  TopRightCorner = 1
  TopRightSection = 4
  TopSection = 3
  TopToolBarArea = 4
  TouchPointMoved = 2
  TouchPointPressed = 1
  TouchPointReleased = 8
  TouchPointStationary = 4
  TransparentMode = 0
  Tuesday = 2
  UI_AnimateCombo = 3
  UI_AnimateMenu = 1
  UI_AnimateToolBox = 6
  UI_AnimateTooltip = 4
  UI_FadeMenu = 2
  UI_FadeTooltip = 5
  UI_General = 0
  UNICODE_ACCEL = 0
  UTC = 1
  Unchecked = 0
  UniqueConnection = 128
  UniteClip = 3
  UpArrow = 1
  UpArrowCursor = 1
  UserRole = 32
  VerPattern = 10
  Vertical = 2
  VisualMoveStyle = 1
  WA_AcceptDrops = 78
  WA_AcceptTouchEvents = 121
  WA_AlwaysShowToolTips = 84
  WA_AttributeCount = 135
  WA_AutoOrientation = 130
  WA_CustomWhatsThis = 47
  WA_DeleteOnClose = 55
  WA_Disabled = 0
  WA_DontCreateNativeAncestors = 101
  WA_ForceDisabled = 32
  WA_ForceUpdatesDisabled = 59
  WA_GrabbedShortcut = 50
  WA_GroupLeader = 72
  WA_Hover = 74
  WA_InputMethodEnabled = 14
  WA_InputMethodTransparent = 75
  WA_InvalidSize = 45
  WA_KeyCompression = 33
  WA_KeyboardFocusChange = 77
  WA_LaidOut = 7
  WA_LayoutOnEntireRect = 48
  WA_LayoutUsesWidgetRect = 92
  WA_LockLandscapeOrientation = 129
  WA_LockPortraitOrientation = 128
  WA_MSWindowsUseDirect3D = 94
  WA_MacAlwaysShowToolWindow = 96
  WA_MacBrushedMetal = 46
  WA_MacFrameworkScaled = 117
  WA_MacMetalStyle = 46
  WA_MacMiniSize = 91
  WA_MacNoClickThrough = 12
  WA_MacNoShadow = 134
  WA_MacNormalSize = 89
  WA_MacOpaqueSizeGrip = 85
  WA_MacShowFocusRect = 88
  WA_MacSmallSize = 90
  WA_MacVariableSize = 102
  WA_Mapped = 11
  WA_MergeSoftkeys = 124
  WA_MergeSoftkeysRecursively = 125
  WA_MouseNoMask = 71
  WA_MouseTracking = 2
  WA_Moved = 43
  WA_NativeWindow = 100
  WA_NoChildEventsForParent = 58
  WA_NoChildEventsFromChildren = 39
  WA_NoMousePropagation = 73
  WA_NoMouseReplay = 54
  WA_NoSystemBackground = 9
  WA_NoX11EventCompression = 81
  WA_OpaquePaintEvent = 4
  WA_OutsideWSRange = 49
  WA_PaintOnScreen = 8
  WA_PaintOutsidePaintEvent = 13
  WA_PaintUnclipped = 52
  WA_PendingMoveEvent = 34
  WA_PendingResizeEvent = 35
  WA_PendingUpdate = 44
  WA_QuitOnClose = 76
  WA_Resized = 42
  WA_RightToLeft = 56
  WA_SetCursor = 38
  WA_SetFont = 37
  WA_SetLayoutDirection = 57
  WA_SetLocale = 87
  WA_SetPalette = 36
  WA_SetStyle = 86
  WA_SetWindowIcon = 53
  WA_ShowWithoutActivating = 98
  WA_StaticContents = 5
  WA_StyleSheet = 97
  WA_StyledBackground = 93
  WA_TintedBackground = 82
  WA_TouchPadAcceptSingleTouchEvents = 123
  WA_TranslucentBackground = 120
  WA_TransparentForMouseEvents = 51
  WA_UnderMouse = 1
  WA_UpdatesDisabled = 10
  WA_WState_CompressKeys = 61
  WA_WState_ConfigPending = 64
  WA_WState_Created = 60
  WA_WState_ExplicitShowHide = 69
  WA_WState_Hidden = 16
  WA_WState_InPaintEvent = 62
  WA_WState_OwnSizePolicy = 68
  WA_WState_Polished = 66
  WA_WState_Reparented = 63
  WA_WState_Visible = 15
  WA_WindowModified = 41
  WA_WindowPropagation = 80
  WA_X11DoNotAcceptFocus = 132
  WA_X11NetWmWindowTypeCombo = 115
  WA_X11NetWmWindowTypeDND = 116
  WA_X11NetWmWindowTypeDesktop = 104
  WA_X11NetWmWindowTypeDialog = 110
  WA_X11NetWmWindowTypeDock = 105
  WA_X11NetWmWindowTypeDropDownMenu = 111
  WA_X11NetWmWindowTypeMenu = 107
  WA_X11NetWmWindowTypeNotification = 114
  WA_X11NetWmWindowTypePopupMenu = 112
  WA_X11NetWmWindowTypeSplash = 109
  WA_X11NetWmWindowTypeToolBar = 106
  WA_X11NetWmWindowTypeToolTip = 113
  WA_X11NetWmWindowTypeUtility = 108
  WA_X11OpenGLOverlay = 83
  WDestructiveClose = 'TO BE DONE'
  WaitCursor = 3
  Wednesday = 3
  WhatsThisCursor = 15
  WhatsThisRole = 5
  WheelFocus = 15
  WhiteSpaceModeUndefined = -1
  WhiteSpaceNoWrap = 2
  WhiteSpaceNormal = 0
  WhiteSpacePre = 1
  Widget = 0
  WidgetShortcut = 0
  WidgetWithChildrenShortcut = 3
  WindingFill = 1
  Window = 1
  WindowActive = 8
  WindowCancelButtonHint = 1048576
  WindowCloseButtonHint = 134217728
  WindowContextHelpButtonHint = 65536
  WindowFullScreen = 4
  WindowMaximizeButtonHint = 32768
  WindowMaximized = 2
  WindowMinMaxButtonsHint = 49152
  WindowMinimizeButtonHint = 16384
  WindowMinimized = 1
  WindowModal = 1
  WindowNoState = 0
  WindowOkButtonHint = 524288
  WindowShadeButtonHint = 131072
  WindowShortcut = 1
  WindowSoftkeysRespondHint = -2147483648
  WindowSoftkeysVisibleHint = 1073741824
  WindowStaysOnBottomHint = 67108864
  WindowStaysOnTopHint = 262144
  WindowSystemMenuHint = 8192
  WindowTitleHint = 4096
  WindowType_Mask = 255
  X11BypassWindowManagerHint = 1024
  XAxis = 0
  XButton1 = 8
  XButton2 = 16
  YAxis = 1
  ZAxis = 2
  black = 2
  blue = 9
  color0 = 0
  color1 = 1
  cyan = 10
  darkBlue = 15
  darkCyan = 16
  darkGray = 4
  darkGreen = 14
  darkMagenta = 17
  darkRed = 13
  darkYellow = 18
  gray = 5
  green = 8
  lightGray = 6
  magenta = 11
  red = 7
  transparent = 19
  white = 3
  yellow = 12

class ShowStdIcons(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

