C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
                        SUBROUTINE LECMCR
C                       *****************
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------   LECTURE ET INTERPRETATION DU FICHIER syrthes.ray        *
C              Lecture des mots-cles pour les options du calcul        *
C                                                                      *
C-----------------------------------------------------------------------
C               (*)   (*)                 ARGUMENTS                    !
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !/OPTCT/ !      ! R  !                                             !
C   !/NLOFCT/!      ! D  !                                             !
C   !/NLOFES/!      ! D  !                                             !
C   !__________________________________________________________________!
C   ! FONCTIONS IMPLICITES                                             !
C   !__________________________________________________________________!
C   !________!______!____!_____________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : 
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : 
C
C***********************************************************************
C
      IMPLICIT NONE
C
C**********************************************************************
C     DONNEES EN COMMON 
C**********************************************************************
C
#include "optct.h"
#include "divct.h"
#include "nlofes.h"
#include "nlofct.h"
#include "syrth.h"
C
C**********************************************************************
C
C
      INTEGER I1,I2,II1,II2,LCH
      LOGICAL LVERIF,ERR
C
      CHARACTER*200 CHAINE,FORMA
C
C**********************************************************************
C
C     0- INITIALISATIONS
C     ==================
C
      LVERIF = .TRUE.
      ERR    = .FALSE.
C
C     Valeurs par defaut des parametres
C     ---------------------------------
C
      LSTOKF = .FALSE.
      LECFDF = .FALSE.
      LSTORA = .FALSE.
      LLCORA = .FALSE.
      LPERAY = .FALSE.
      LHISOR = .FALSE.
      NPLASY = 0
      NBANDE = 1
      NCHROR = -1
      NDECMX = 0
      NBLBLR = 2
      LROUVR=.FALSE.
C
C
C     1- LECTURE DE LA CHAINE
C     =======================
C
      REWIND(NFCLRA)
C
   10 CONTINUE
C
      CHAINE = ' '
      READ(NFCLRA,1000,END=999) CHAINE
C
      IF (CHAINE(1:1) .EQ. '/') GOTO 10
C
      CALL POSCOT(CHAINE,I1,I2,LCH)
C
      IF (I1 .EQ. 0) GOTO 10
C
C
C     =======================
C     0- VARIABLES CARACTERES
C     =======================
C
C
C     =====================
C     1- VARIABLES LOGIQUES
C     =====================
C
C
C
C     1.1- STOCKAGE DES FACTEURS DE FORME SUR FICHIER (LSTOKF)
C     -------------------------------------------------------
      IF ( CHAINE(I1:I2).EQ. 
     *     'STOCKAGE DES FACTEURS DE FORME SUR FICHIER=') THEN
C
            CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            IF (CHAINE(I1:I2) .EQ. 'OUI') THEN
              LSTOKF = .TRUE.
            ELSEIF (CHAINE(I1:I2) .EQ. 'NON') THEN
              LSTOKF = .FALSE.
            ELSE
              GOTO 9999
            ENDIF
C
C     1.2- LECTURE DES FACTEURS DE FORME SUR FICHIER (LECFDF)
C     -------------------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *     'LECTURE DES FACTEURS DE FORME SUR FICHIER=') THEN
C
C           Position de la reponse
            CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            IF (CHAINE(I1:I2) .EQ. 'OUI') THEN
              LECFDF = .TRUE.
            ELSEIF (CHAINE(I1:I2) .EQ. 'NON') THEN
              LECFDF = .FALSE.
            ELSE
              GOTO 9999
            ENDIF
C
C
C     1.6- STOCKAGE DES CORRESPONDANTS DE RAYONNEMENT (LSTORA)
C     -----------------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *     'STOCKAGE DES CORRESPONDANTS POUR RAYONNEMENT=') THEN
C
            CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            IF (CHAINE(I1:I2) .EQ. 'OUI') THEN
              LSTORA = .TRUE.
            ELSEIF (CHAINE(I1:I2) .EQ. 'NON') THEN
              LSTORA = .FALSE.
            ENDIF
C
C
C     1.8- LECTURE DES CORRESPONDANTS DE RAYONNEMENT (LLCORA)
C     -----------------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *     'LECTURE DES CORRESPONDANTS POUR RAYONNEMENT=') THEN
C
            CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            IF (CHAINE(I1:I2) .EQ. 'OUI') THEN
              LLCORA = .TRUE.
            ELSEIF (CHAINE(I1:I2) .EQ. 'NON') THEN
              LLCORA = .FALSE.
            ENDIF
C
C     1.9- PERIODICITE DE ROTATION POUR LE RAYONNEMENT
C     ------------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *     'PERIODICITE DE ROTATION POUR LE RAYONNEMENT=') THEN
C
            CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            IF (CHAINE(I1:I2) .EQ. 'OUI') THEN
              LPERAY = .TRUE.
            ELSEIF (CHAINE(I1:I2) .EQ. 'NON') THEN
              LPERAY = .FALSE.
            ENDIF
C
C     1.10- DOMAINE DE RAYONNEMENT CONFINE OUVERT SUR L EXTERIEUR
C     -----------------------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *  'DOMAINE DE RAYONNEMENT CONFINE OUVERT SUR L EXTERIEUR=') THEN
C
            CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            IF (CHAINE(I1:I2) .EQ. 'OUI') THEN
              LROUVR = .TRUE.
            ELSEIF (CHAINE(I1:I2) .EQ. 'NON') THEN
              LROUVR = .FALSE.
            ENDIF
C
C
C     1.11- HISTORIQUES
C     -----------------
      ELSEIF ( CHAINE(I1:I2).EQ. 'HISTORIQUES RAYONNEMENT=') THEN
C
            CALL POSCOT(CHAINE(I2+2:),II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            IF (CHAINE(I1:I2) .EQ. 'OUI') THEN
              LHISOR = .TRUE.
            ELSEIF (CHAINE(I1:I2) .EQ. 'NON') THEN
              LHISOR = .FALSE.
            ENDIF
C
C     =====================
C     2- VARIABLES ENTIERES
C     =====================
C
C
C
C     2.1- NOMBRE DE PLANS DE SYMETRIE POUR LE RAYONNEMENT (NPLASY) 
C     ------------------------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *     'NOMBRE DE PLANS DE SYMETRIE POUR LE RAYONNEMENT=') THEN
C
            CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            CALL CHFORM('I',CHAINE(I1:I2),LCH,1,FORMA)
            READ(CHAINE(I1:I2),FORMA,ERR=9999) NPLASY
            IF (NPLASY.LT.0 .OR. NPLASY.GT.3) THEN
              WRITE(NFECRA,2910)
              ERR = .TRUE.
            ENDIF
C
C
C     2.2- NOMBRE DE BANDES SPECTRALES POUR LE RAYONNEMENT (NBANDE) 
C     ------------------------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *     'NOMBRE DE BANDES SPECTRALES POUR LE RAYONNEMENT=') THEN
C
            CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            CALL CHFORM('I',CHAINE(I1:I2),LCH,1,FORMA)
            READ(CHAINE(I1:I2),FORMA,ERR=9999) NBANDE
            IF (NBANDE.LT.0) THEN
              WRITE(NFECRA,2920)
              ERR = .TRUE.
            ENDIF
C
C
C     2.3- PAS DES SORTIES CHRONO RAYONNEMENT (NCHROR) 
C     -----------------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *     'PAS DES SORTIES CHRONO RAYONNEMENT=') THEN
C
            CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            CALL CHFORM('I',CHAINE(I1:I2),LCH,1,FORMA)
            READ(CHAINE(I1:I2),FORMA,ERR=9999) NCHROR
C
C     2.4- NOMBRE DE REDECOUPAGES POUR CALCUL DES FACTEURS DE FORME 
C           (NDECMX) 
C     -------------------------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *    'NOMBRE DE REDECOUPAGES POUR CALCUL DES FACTEURS DE FORME=')
     *    THEN
C
            CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            CALL CHFORM('I',CHAINE(I1:I2),LCH,1,FORMA)
            READ(CHAINE(I1:I2),FORMA,ERR=9999) NDECMX
C
C     2.5- NIVEAU DES IMPRESSIONS POUR LE RAYONNEMENT (NBLBLR)
C     --------------------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ. 
     *    'NIVEAU DES IMPRESSIONS POUR LE RAYONNEMENT=')
     *    THEN
C
            CALL POSREE(CHAINE(I2+2:),1,II1,II2,LCH)
            I1 = I2 + II1 + 1
            I2 = I1 + LCH - 1
            CALL CHFORM('I',CHAINE(I1:I2),LCH,1,FORMA)
            READ(CHAINE(I1:I2),FORMA,ERR=9999) NBLBLR
            IF(NBLBLR .GT. 3) NBLBLR=NBLBLR-1000
            IF (NBLBLR.LT.0) THEN
              WRITE(NFECRA,2500)
              ERR = .TRUE.
            ENDIF
C
C
C     ====================
C     3- VARIABLES REELLES
C     ====================
C
C
      ENDIF
      GOTO 10
C
 999  CONTINUE
C
C
C     ===================================================
C     4- GESTION DES OPTIONS PRIORITAIRES ET OBLIGATOIRES
C     ===================================================
C
      IF (LSTOKF .AND. LECFDF) THEN
         WRITE(NFECRA,4500)
         LSTOKF = .FALSE.
         LECFDF = .FALSE.
      ENDIF
C
C
      IF (LPERAY .AND. NPLASY .GT. 1) THEN
         WRITE(NFECRA,4600)
         ERR = .TRUE.
      ENDIF
C
C     STOP EN CAS D'ERREUR DE DONNEES
C     -------------------------------
C
      IF (ERR) STOP
C
      GOTO 500
C
C     =================================
C     5. GESTION DES ERREURS DE LECTURE
C     =================================
C
 9999 WRITE(NFECRA,5000) CHAINE
      STOP
C
  500 CONTINUE
C
C--------
C FORMATS
C--------
 1000 FORMAT(A200)
 2500 FORMAT(/,' %% ERREUR LECMCR : MOT-CLE "NIVEAU DES IMPRESSIONS ',
     &       'POUR LE RAYONNEMENT"',/,
     &       '             Les valeurs possibles sont 0,1,2 ou 3')
 2910 FORMAT(/,' %% ERREUR LECMCR : MOT-CLE "NOMBRE DE PLANS DE ',
     &       'SYMETRIE POUR LE RAYONNEMENT"',/,
     &       '             Les valeurs possibles sont 0,1,2 ou 3')
 2920 FORMAT(/,' %% ERREUR LECMCR : MOT-CLE "NOMBRE DE BANDES ',
     &       'SPECTRALES POUR LE RAYONNEMENT"',/,
     &       '             Il faut un entier superieur ou egal a 1')
C
 4500 FORMAT(/,' $$ ATTENTION LECMCR : MOTS-CLES "STOCKAGE DES ',
     &       'FACTEURS DE FORME SUR FICHIER"',/,
     &       '                             et "LECTURE DES ',
     &       'FACTEURS DE FORME SUR FICHIER"',/,
     &       '    Ces 2 options ne peuvent etre activees ',
     &       'simultanement ',/,
     &       '    --> On recalcule les facteurs de forme et ',
     &       'le calcul se poursuit de facon normale...')       
 4600 FORMAT(/,' %% ERREUR LECMCR : MOTS-CLES " NOMBRE DE ',
     &       'PLANS DE SYMETRIE POUR LE RAYONNEMENT="',/,
     &       '                             et " PERIODICITE',
     &       'DE ROTATION POUR LE RAYONNEMENT="',/,
     &       '    Ces 2 options ne peuvent etre activees ',
     &       'simultanement qu''avec 1 seul plan de symetrie',/)     
 5000 FORMAT(/,' %% ERREUR LECMCR : Erreur dans le fichier de donnees',
     * /,20X,'au cours de la lecture des mots-cles ',/,
     *   20X,'Ligne concernee : ',A)
C----
C FIN
C----
C
      RETURN
      END
