/************************************************************************
 *
 * Copyright (C) 2009-2024 IRCAD France
 * Copyright (C) 2012-2018 IHU Strasbourg
 *
 * This file is part of Sight.
 *
 * Sight is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Sight is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sight. If not, see <https://www.gnu.org/licenses/>.
 *
 ***********************************************************************/

#include "io/__/writer/object_writer.hpp"

#include <core/jobs/base.hpp>

namespace sight::io::writer
{

//------------------------------------------------------------------------------

void object_writer::set_object(core::object::csptr _object)
{
    m_object = _object;
}

//------------------------------------------------------------------------------

core::object::csptr object_writer::get_object() const
{
    auto object = m_object.lock();
    SIGHT_ASSERT("Object expired.", object);
    return object;
}

//------------------------------------------------------------------------------

std::string object_writer::extension() const
{
    return {};
}

//------------------------------------------------------------------------------

void object_writer::cancel()
{
    auto job = this->get_job();
    if(job)
    {
        job->cancel();
    }
}

//------------------------------------------------------------------------------

} // namespace sight::io::writer
