// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __basebox_h__
#define __basebox_h__

#include "basemarker.h"

class BaseBox : public BaseMarker {
 protected:
  int numPoints_;
  Vector** vertices_;

 private:
  void newVertices();
  void newVerticesA();
  void newVerticesB();
  void deleteVertices();

  void vertBTest(int* s1, int* s2, double a1, double a2, 
		 double b1, double b2, int ii, int* cnt);
  void vertBPrep(double a1, double a2, double ll, double ul, int ii, int* cnt);
  void vertBSeg(double ang1, double ang2, int ii, int* cnt);

protected:
  virtual void updateHandles();
  Vector intersect(Vector, double);

  void renderX(Drawable, Coord::InternalSystem, RenderMode);
  void renderPS(int);
#ifdef _MACOSX
  void renderMACOSX();
#endif
#ifdef _WIN32
  void renderWIN32();
#endif

public:
  BaseBox(const BaseBox&);
  BaseBox(Base* p, const Vector& ctr, 
	  double a,
	  const char* clr, int* dsh, 
	  int w, const char* f, const char* t, 
	  unsigned short prop, const char* c, 
	  const List<Tag>& tag, const List<CallBack>& cb);
  virtual ~BaseBox();

  virtual Marker* dup() =0;

  int isIn(const Vector& vv) 
  {return isIn(vv, Coord::CANVAS);}
  int isIn(const Vector& vv, Coord::InternalSystem sys)
  {return isIn(vv,sys,numAnnuli_-1);}
  int isIn(const Vector&, Coord::InternalSystem, int);
};

#endif
