import pandas as pd
import os
import click

@click.command()
@click.option('--sf')
def run(sf):
    cell_name = "AAA"
    with open(os.getcwd()+"/alevin_test_data/alevin/cell/"+cell_name+"/quant.sf") as f:
       df = pd.read_table(f).set_index("Name").drop(["Length"], 1)
    df.columns = ["Original"]

    with open(sf+"/alevin/cell/"+cell_name+"/quant.sf") as f:
       pdf = pd.read_table(f).set_index("Name").drop(["Length"], 1)
    pdf.columns = ["Predicted"]

    ct = pd.concat([df, pdf], axis=1)
    print "Spearman Correlation for " + cell_name
    print ct.corr(method="spearman")

if __name__=="__main__":
    run()
