A non-structural-match type was used as the type of a const generic parameter.

Erroneous code example:

```compile_fail,E0741
#![feature(adt_const_params)]

struct A;

struct B<const X: A>; // error!
```

Only structural-match types, which are types that derive `PartialEq` and `Eq`
and implement `ConstParamTy`, may be used as the types of const generic
parameters.

To fix the previous code example, we derive `PartialEq`, `Eq`, and
`ConstParamTy`:

```
#![feature(adt_const_params)]

use std::marker::ConstParamTy;

#[derive(PartialEq, Eq, ConstParamTy)] // We derive both traits here.
struct A;

struct B<const X: A>; // ok!
```
