;; Test all the f32 comparison operators on major boundary values and all
;; special values.

(module
  (func (export "eq") (param $x f32) (param $y f32) (result i32) (f32.eq (local.get $x) (local.get $y)))
  (func (export "ne") (param $x f32) (param $y f32) (result i32) (f32.ne (local.get $x) (local.get $y)))
  (func (export "lt") (param $x f32) (param $y f32) (result i32) (f32.lt (local.get $x) (local.get $y)))
  (func (export "le") (param $x f32) (param $y f32) (result i32) (f32.le (local.get $x) (local.get $y)))
  (func (export "gt") (param $x f32) (param $y f32) (result i32) (f32.gt (local.get $x) (local.get $y)))
  (func (export "ge") (param $x f32) (param $y f32) (result i32) (f32.ge (local.get $x) (local.get $y)))
)

(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -inf) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -inf) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const inf) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const inf) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -inf) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -inf) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const inf) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const inf) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -inf) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -inf) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const inf) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const inf) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -inf) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -inf) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const inf) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const inf) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -inf) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -inf) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const inf) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const inf) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -inf) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -inf) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const inf) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const inf) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -inf) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -inf) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const inf) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const inf) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -inf) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "eq" (f32.const -inf) (f32.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const inf) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const inf) (f32.const inf)) (i32.const 1))
(assert_return (invoke "eq" (f32.const -inf) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -inf) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -inf) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -inf) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const inf) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const inf) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const inf) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const inf) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan:0x200000) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan:0x200000) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan:0x200000) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan:0x200000) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan:0x200000) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan:0x200000) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan:0x200000) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan:0x200000) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan:0x200000) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan:0x200000) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan:0x200000) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan:0x200000) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan:0x200000) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan:0x200000) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan:0x200000) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan:0x200000) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan:0x200000) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan:0x200000) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan:0x200000) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan:0x200000) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan:0x200000) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan:0x200000) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan:0x200000) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan:0x200000) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan:0x200000) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan:0x200000) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan:0x200000) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan:0x200000) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan:0x200000) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan:0x200000) (f32.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan:0x200000) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan:0x200000) (f32.const inf)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan:0x200000) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan:0x200000) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan:0x200000) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan:0x200000) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan:0x200000) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan:0x200000) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan:0x200000) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan:0x200000) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const -nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const -nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const -nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const -nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const -nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const -nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const -nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const -nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const -nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const -nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const -nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const -nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const -nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const -nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -inf) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -inf) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const inf) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const inf) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -inf) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -inf) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const inf) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const inf) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -inf) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -inf) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const inf) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const inf) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -inf) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -inf) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const inf) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const inf) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -inf) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -inf) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const inf) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const inf) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -inf) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -inf) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const inf) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const inf) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -inf) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -inf) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const inf) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const inf) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -inf) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "ne" (f32.const -inf) (f32.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const inf) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const inf) (f32.const inf)) (i32.const 0))
(assert_return (invoke "ne" (f32.const -inf) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -inf) (f32.const -nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -inf) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -inf) (f32.const nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const inf) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const inf) (f32.const -nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const inf) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const inf) (f32.const nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan:0x200000) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan:0x200000) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan:0x200000) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan:0x200000) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan:0x200000) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan:0x200000) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan:0x200000) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan:0x200000) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan:0x200000) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan:0x200000) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan:0x200000) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan:0x200000) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan:0x200000) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan:0x200000) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan:0x200000) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan:0x200000) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan:0x200000) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan:0x200000) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan:0x200000) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan:0x200000) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan:0x200000) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan:0x200000) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan:0x200000) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan:0x200000) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan:0x200000) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan:0x200000) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan:0x200000) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan:0x200000) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan:0x200000) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan:0x200000) (f32.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan:0x200000) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan:0x200000) (f32.const inf)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan:0x200000) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const -nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan:0x200000) (f32.const -nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan:0x200000) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan:0x200000) (f32.const nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan:0x200000) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const -nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan:0x200000) (f32.const -nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan:0x200000) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const nan:0x200000)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan:0x200000) (f32.const nan:0x200000)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const inf)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const inf)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const inf)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const inf)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const inf)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const inf)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const inf)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const inf)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const inf)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const inf)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const inf)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const inf)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const inf)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const inf)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -inf) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -inf) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const inf) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const inf) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -inf) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -inf) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "lt" (f32.const inf) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const inf) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -inf) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -inf) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "lt" (f32.const inf) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const inf) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -inf) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -inf) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f32.const inf) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const inf) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -inf) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -inf) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const inf) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const inf) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -inf) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -inf) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "lt" (f32.const inf) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const inf) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -inf) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -inf) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "lt" (f32.const inf) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const inf) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -inf) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -inf) (f32.const inf)) (i32.const 1))
(assert_return (invoke "lt" (f32.const inf) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f32.const inf) (f32.const inf)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -inf) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -inf) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -inf) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -inf) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const inf) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const inf) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const inf) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const inf) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan:0x200000) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan:0x200000) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan:0x200000) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan:0x200000) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan:0x200000) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan:0x200000) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan:0x200000) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan:0x200000) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan:0x200000) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan:0x200000) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan:0x200000) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan:0x200000) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan:0x200000) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan:0x200000) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan:0x200000) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan:0x200000) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan:0x200000) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan:0x200000) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan:0x200000) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan:0x200000) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan:0x200000) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan:0x200000) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan:0x200000) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan:0x200000) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan:0x200000) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan:0x200000) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan:0x200000) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan:0x200000) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan:0x200000) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const inf)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan:0x200000) (f32.const inf)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan:0x200000) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const inf)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan:0x200000) (f32.const inf)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan:0x200000) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan:0x200000) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan:0x200000) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan:0x200000) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan:0x200000) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan:0x200000) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan:0x200000) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan:0x200000) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const inf)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const inf)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const inf)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const inf)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const inf)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const inf)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const inf)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const inf)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const inf)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const inf)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const inf)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const inf)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const inf)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const inf)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const -inf) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -inf) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const inf) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const inf) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -inf) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "le" (f32.const -inf) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "le" (f32.const inf) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const inf) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const -inf) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "le" (f32.const -inf) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "le" (f32.const inf) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const inf) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const -inf) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f32.const -inf) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f32.const inf) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const inf) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const -inf) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -inf) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const inf) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const inf) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -inf) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "le" (f32.const -inf) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "le" (f32.const inf) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const inf) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const -inf) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "le" (f32.const -inf) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "le" (f32.const inf) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const inf) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const -inf) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "le" (f32.const -inf) (f32.const inf)) (i32.const 1))
(assert_return (invoke "le" (f32.const inf) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f32.const inf) (f32.const inf)) (i32.const 1))
(assert_return (invoke "le" (f32.const -inf) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -inf) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const -inf) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -inf) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const inf) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const inf) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const inf) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const inf) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan:0x200000) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan:0x200000) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan:0x200000) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan:0x200000) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan:0x200000) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan:0x200000) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan:0x200000) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan:0x200000) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan:0x200000) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan:0x200000) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan:0x200000) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan:0x200000) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan:0x200000) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan:0x200000) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan:0x200000) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan:0x200000) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan:0x200000) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan:0x200000) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan:0x200000) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan:0x200000) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan:0x200000) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan:0x200000) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan:0x200000) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan:0x200000) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan:0x200000) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan:0x200000) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan:0x200000) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan:0x200000) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan:0x200000) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const inf)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan:0x200000) (f32.const inf)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan:0x200000) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const inf)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan:0x200000) (f32.const inf)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan:0x200000) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan:0x200000) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan:0x200000) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan:0x200000) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan:0x200000) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan:0x200000) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan:0x200000) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan:0x200000) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -inf) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -inf) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const inf) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const inf) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -inf) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -inf) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const inf) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "gt" (f32.const inf) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -inf) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -inf) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const inf) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "gt" (f32.const inf) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -inf) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -inf) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const inf) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f32.const inf) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -inf) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -inf) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const inf) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const inf) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -inf) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -inf) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const inf) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "gt" (f32.const inf) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -inf) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -inf) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const inf) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "gt" (f32.const inf) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -inf) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -inf) (f32.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f32.const inf) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "gt" (f32.const inf) (f32.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -inf) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -inf) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -inf) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -inf) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const inf) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const inf) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const inf) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const inf) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan:0x200000) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan:0x200000) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan:0x200000) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan:0x200000) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan:0x200000) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan:0x200000) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan:0x200000) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan:0x200000) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan:0x200000) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan:0x200000) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan:0x200000) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan:0x200000) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan:0x200000) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan:0x200000) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan:0x200000) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan:0x200000) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan:0x200000) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan:0x200000) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan:0x200000) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan:0x200000) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan:0x200000) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan:0x200000) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan:0x200000) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan:0x200000) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan:0x200000) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan:0x200000) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan:0x200000) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan:0x200000) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan:0x200000) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan:0x200000) (f32.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan:0x200000) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan:0x200000) (f32.const inf)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan:0x200000) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan:0x200000) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan:0x200000) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan:0x200000) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan:0x200000) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan:0x200000) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan:0x200000) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan:0x200000) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -inf) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -inf) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const inf) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const inf) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -inf) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -inf) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const inf) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ge" (f32.const inf) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -inf) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -inf) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const inf) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ge" (f32.const inf) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -inf) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -inf) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const inf) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f32.const inf) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -inf) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -inf) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const inf) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const inf) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -inf) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -inf) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const inf) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ge" (f32.const inf) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -inf) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -inf) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const inf) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ge" (f32.const inf) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -inf) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -inf) (f32.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f32.const inf) (f32.const -inf)) (i32.const 1))
(assert_return (invoke "ge" (f32.const inf) (f32.const inf)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -inf) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -inf) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -inf) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -inf) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const inf) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const inf) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const inf) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const inf) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan:0x200000) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan:0x200000) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan:0x200000) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan:0x200000) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan:0x200000) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan:0x200000) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan:0x200000) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan:0x200000) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan:0x200000) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan:0x200000) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan:0x200000) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan:0x200000) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan:0x200000) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan:0x200000) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan:0x200000) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan:0x200000) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan:0x200000) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan:0x200000) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan:0x200000) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan:0x200000) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan:0x200000) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan:0x200000) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan:0x200000) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan:0x200000) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan:0x200000) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan:0x200000) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan:0x200000) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan:0x200000) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan:0x200000) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan:0x200000) (f32.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan:0x200000) (f32.const -inf)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan:0x200000) (f32.const inf)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan:0x200000) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan:0x200000) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan:0x200000) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan:0x200000) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan:0x200000) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan:0x200000) (f32.const -nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan:0x200000) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const nan:0x200000)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan:0x200000) (f32.const nan:0x200000)) (i32.const 0))
