// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::Window;
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, pin::Pin};

glib::wrapper! {
    #[doc(alias = "GtkAlertDialog")]
    pub struct AlertDialog(Object<ffi::GtkAlertDialog, ffi::GtkAlertDialogClass>);

    match fn {
        type_ => || ffi::gtk_alert_dialog_get_type(),
    }
}

impl AlertDialog {
    //#[doc(alias = "gtk_alert_dialog_new")]
    //pub fn new(format: &str, : /*Unknown conversion*//*Unimplemented*/Basic: VarArgs) -> AlertDialog {
    //    unsafe { TODO: call ffi:gtk_alert_dialog_new() }
    //}

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`AlertDialog`] objects.
    ///
    /// This method returns an instance of [`AlertDialogBuilder`](crate::builders::AlertDialogBuilder) which can be used to create [`AlertDialog`] objects.
    pub fn builder() -> AlertDialogBuilder {
        AlertDialogBuilder::new()
    }

    #[doc(alias = "gtk_alert_dialog_choose")]
    pub fn choose<P: FnOnce(Result<i32, glib::Error>) + 'static>(
        &self,
        parent: Option<&impl IsA<Window>>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn choose_trampoline<P: FnOnce(Result<i32, glib::Error>) + 'static>(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = std::ptr::null_mut();
            let ret =
                ffi::gtk_alert_dialog_choose_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(ret)
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = choose_trampoline::<P>;
        unsafe {
            ffi::gtk_alert_dialog_choose(
                self.to_glib_none().0,
                parent.map(|p| p.as_ref()).to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    pub fn choose_future(
        &self,
        parent: Option<&(impl IsA<Window> + Clone + 'static)>,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<i32, glib::Error>> + 'static>> {
        let parent = parent.map(ToOwned::to_owned);
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.choose(
                parent.as_ref().map(::std::borrow::Borrow::borrow),
                Some(cancellable),
                move |res| {
                    send.resolve(res);
                },
            );
        }))
    }

    #[doc(alias = "gtk_alert_dialog_get_buttons")]
    #[doc(alias = "get_buttons")]
    pub fn buttons(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::gtk_alert_dialog_get_buttons(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_alert_dialog_get_cancel_button")]
    #[doc(alias = "get_cancel_button")]
    pub fn cancel_button(&self) -> i32 {
        unsafe { ffi::gtk_alert_dialog_get_cancel_button(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_alert_dialog_get_default_button")]
    #[doc(alias = "get_default_button")]
    pub fn default_button(&self) -> i32 {
        unsafe { ffi::gtk_alert_dialog_get_default_button(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_alert_dialog_get_detail")]
    #[doc(alias = "get_detail")]
    pub fn detail(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::gtk_alert_dialog_get_detail(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_alert_dialog_get_message")]
    #[doc(alias = "get_message")]
    pub fn message(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::gtk_alert_dialog_get_message(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_alert_dialog_get_modal")]
    #[doc(alias = "get_modal")]
    pub fn is_modal(&self) -> bool {
        unsafe { from_glib(ffi::gtk_alert_dialog_get_modal(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_alert_dialog_set_buttons")]
    pub fn set_buttons(&self, labels: &[&str]) {
        unsafe {
            ffi::gtk_alert_dialog_set_buttons(self.to_glib_none().0, labels.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_alert_dialog_set_cancel_button")]
    pub fn set_cancel_button(&self, button: i32) {
        unsafe {
            ffi::gtk_alert_dialog_set_cancel_button(self.to_glib_none().0, button);
        }
    }

    #[doc(alias = "gtk_alert_dialog_set_default_button")]
    pub fn set_default_button(&self, button: i32) {
        unsafe {
            ffi::gtk_alert_dialog_set_default_button(self.to_glib_none().0, button);
        }
    }

    #[doc(alias = "gtk_alert_dialog_set_detail")]
    pub fn set_detail(&self, detail: &str) {
        unsafe {
            ffi::gtk_alert_dialog_set_detail(self.to_glib_none().0, detail.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_alert_dialog_set_message")]
    pub fn set_message(&self, message: &str) {
        unsafe {
            ffi::gtk_alert_dialog_set_message(self.to_glib_none().0, message.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_alert_dialog_set_modal")]
    pub fn set_modal(&self, modal: bool) {
        unsafe {
            ffi::gtk_alert_dialog_set_modal(self.to_glib_none().0, modal.into_glib());
        }
    }

    #[doc(alias = "gtk_alert_dialog_show")]
    pub fn show(&self, parent: Option<&impl IsA<Window>>) {
        unsafe {
            ffi::gtk_alert_dialog_show(
                self.to_glib_none().0,
                parent.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[cfg(feature = "v4_10")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_10")))]
    #[doc(alias = "buttons")]
    pub fn connect_buttons_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_buttons_trampoline<F: Fn(&AlertDialog) + 'static>(
            this: *mut ffi::GtkAlertDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::buttons\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_buttons_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_10")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_10")))]
    #[doc(alias = "cancel-button")]
    pub fn connect_cancel_button_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_cancel_button_trampoline<F: Fn(&AlertDialog) + 'static>(
            this: *mut ffi::GtkAlertDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::cancel-button\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_cancel_button_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_10")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_10")))]
    #[doc(alias = "default-button")]
    pub fn connect_default_button_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_default_button_trampoline<F: Fn(&AlertDialog) + 'static>(
            this: *mut ffi::GtkAlertDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::default-button\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_default_button_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_10")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_10")))]
    #[doc(alias = "detail")]
    pub fn connect_detail_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_detail_trampoline<F: Fn(&AlertDialog) + 'static>(
            this: *mut ffi::GtkAlertDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::detail\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_detail_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_10")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_10")))]
    #[doc(alias = "message")]
    pub fn connect_message_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_message_trampoline<F: Fn(&AlertDialog) + 'static>(
            this: *mut ffi::GtkAlertDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::message\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_message_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_10")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_10")))]
    #[doc(alias = "modal")]
    pub fn connect_modal_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_modal_trampoline<F: Fn(&AlertDialog) + 'static>(
            this: *mut ffi::GtkAlertDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::modal\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_modal_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

#[cfg(feature = "v4_10")]
#[cfg_attr(docsrs, doc(cfg(feature = "v4_10")))]
impl Default for AlertDialog {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`AlertDialog`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct AlertDialogBuilder {
    builder: glib::object::ObjectBuilder<'static, AlertDialog>,
}

impl AlertDialogBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    #[cfg(feature = "v4_10")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_10")))]
    pub fn buttons(self, buttons: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("buttons", buttons.into()),
        }
    }

    #[cfg(feature = "v4_10")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_10")))]
    pub fn cancel_button(self, cancel_button: i32) -> Self {
        Self {
            builder: self.builder.property("cancel-button", cancel_button),
        }
    }

    #[cfg(feature = "v4_10")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_10")))]
    pub fn default_button(self, default_button: i32) -> Self {
        Self {
            builder: self.builder.property("default-button", default_button),
        }
    }

    #[cfg(feature = "v4_10")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_10")))]
    pub fn detail(self, detail: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("detail", detail.into()),
        }
    }

    #[cfg(feature = "v4_10")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_10")))]
    pub fn message(self, message: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("message", message.into()),
        }
    }

    #[cfg(feature = "v4_10")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_10")))]
    pub fn modal(self, modal: bool) -> Self {
        Self {
            builder: self.builder.property("modal", modal),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`AlertDialog`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> AlertDialog {
        self.builder.build()
    }
}
