//! String utilities.
use crate::pool::Pool;

/// Duplicate a string into memory allocated from a pool.
pub fn pstrdup<'pool>(s: &'_ str, pool: &'pool Pool) -> &'pool str {
    unsafe {
        let cs = std::ffi::CStr::from_ptr(s.as_ptr() as *const _);
        let dup = crate::generated::apr_pstrndup(pool.as_mut_ptr(), cs.as_ptr(), s.len());
        std::ffi::CStr::from_ptr(dup).to_str().unwrap()
    }
}

#[cfg(test)]
mod tests {
    #[test]
    fn test_pstrdup() {
        let pool = crate::pool::Pool::new();
        let s = "hello";
        let cs = crate::strings::pstrdup(s, &pool);
        assert_eq!(s, cs);
    }
}
