//! Tests auto-converted from "sass-spec/spec/css/plain/error/expression/variable.hrx"

#[allow(unused)]
fn runner() -> crate::TestRunner {
    super::runner()
        .with_cwd("variable")
        .mock_file("declaration/plain.css", "$var: value;\n")
        .mock_file("use/plain.css", "a {\n  x: $var;\n}\n")
}

#[test]
fn declaration() {
    let runner = runner().with_cwd("declaration");
    assert_eq!(
        runner.err("@use \'plain\'"),
        "Error: Sass variables aren\'t allowed in plain CSS.\
         \n  ,\
         \n1 | $var: value;\
         \n  | ^^^^\
         \n  \'\
         \n  plain.css 1:1   @use\
         \n  input.scss 1:1  root stylesheet",
    );
}
#[test]
fn test_use() {
    let runner = runner().with_cwd("use");
    assert_eq!(
        runner.err("@use \'plain\'"),
        "Error: Sass variables aren\'t allowed in plain CSS.\
         \n  ,\
         \n2 |   x: $var;\
         \n  |      ^^^^\
         \n  \'\
         \n  plain.css 2:6   @use\
         \n  input.scss 1:1  root stylesheet",
    );
}
