/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.
    Copyright 2000-2013 the Rosegarden development team.
 
    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/


#include "EventInsertionCommand.h"

#include "base/Event.h"
#include "base/Segment.h"
#include "document/BasicCommand.h"


namespace Rosegarden
{

EventInsertionCommand::EventInsertionCommand(Segment &segment,
        Event *event) :
        BasicCommand(tr("Insert Event"), segment, event->getAbsoluteTime(),
                     event->getAbsoluteTime() + event->getDuration()),
        m_event(new Event(*event))
{
    // nothing
}

EventInsertionCommand::~EventInsertionCommand()
{
    delete m_event;
    // don't want to delete m_lastInsertedEvent, it's just an alias
}

void EventInsertionCommand::modifySegment()
{
    m_lastInsertedEvent = new Event(*m_event);
    getSegment().insert(m_lastInsertedEvent);
}

}
