// second order scheme (experimental)
#include "rheolef/mixed_solver.h"
#include "cahouet-chabart.h"
using namespace std;
int navier_stokes_solve (Float Re, Float delta_t, field f0h, field& uh, field& ph,
    size_t& max_iter, Float& tol, std::ostream *p_cerr=0, std::string label = "navier-stokes") {
  const space& Vh = uh.get_space();
  const space& Qh = ph.get_space();
  form m (Vh, Vh, "mass");
  form a (Vh, Vh, "2D_D");
  a = a + 1.5*(Re/delta_t)*m;
  ssk<Float> fact_a = ldlt(a.uu);
  form b (Vh, Qh, "div"); b = -b;
  cahouet_chabart preconditioner (Qh, 1.5*(Re/delta_t));
  if (p_cerr != 0) *p_cerr << "[" << label << "] #n |du/dt|" << endl;
  field uh1 = uh;
  geomap_option_type opts;
  opts.n_track_step = 10;
  for (size_t n = 0; true; n++) { 
    field uh2 = uh1;
    uh1  = uh;
    field uh_star = 2.0*uh1 - uh2;
    geomap X1 (Vh,     -delta_t*uh_star, opts);
    geomap X2 (Vh, -2.0*delta_t*uh_star, opts);
    field  fh = f0h + 0.5*(Re/delta_t)*(4.0*compose(uh1,X1) - compose(uh2,X2));
    size_t gs_max_iter = 500;
    Float  gs_tol      = 1e-15;
    int status = pcg_abtb (a.uu, b.uu, uh.u, ph.u, (m*fh).u - a.ub*uh.b, -(b.ub*uh.b),
      preconditioner, fact_a, gs_max_iter, gs_tol);
    if (status != 0) warning_macro ("solve generalized stokes: precision not reached: tol = " << tol)
    field duh_dt = (3*uh - 4*uh1 + uh2)/(2*delta_t);
    Float residual = sqrt(m(duh_dt,duh_dt));
    if (p_cerr != 0) *p_cerr << "[" << label << "] "<< n << " " << residual << endl;
    if (residual < tol) {
      tol = residual;
      max_iter = n;
      return 0;
    }
    if (n == max_iter-1) {
      tol = residual;
      return 1;
    }
  }
}
