///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
/*Prog:makefish3d
NAME: @code{makefish3d} -- make a 3D Poisson matrix 
@pindex makefish3d
@pindex hb
@cindex finite difference
@cindex Dirichlet problem
@cindex Poisson matrix
@clindex asr
@clindex csr
@toindex @code{ghostview}
SYNOPSIS: 
    @example
	makefish3d @var{bloc-size}
    @end example
DESCRIPTION:       
    Demonstration of @code{asr} and @code{csr} usage.
    Print Poisson matrix in Harwell-Boeing format on standard output.
    The Poisson matrix is the finite-diference of the tridimensional
    Laplace operator with Dirichlet boundary conditions
    on a square region.
EXAMPLE:
    enter command as:
    @example
    	makefish3d 5 | hb -ps | ghostview -
    @end example
SEE ALSO:
    "hb"(1), class "csr", class "asr"
AUTHOR: 
    LMC-IMAG, 38041 Grenoble cedex 9, France
    | Pierre.Saramito@imag.fr
DATE: 
    20 february 1997
METHOD: @makefish3d
End:
*/
//<makefish3d:
# include "rheolef/skit.h"
#ifndef USE_NOT_MAIN
using namespace rheolef;
#endif // USE_NOT_MAIN
using namespace std;
csr<Float> makefish3d (unsigned int n)
{
  unsigned int N = n*n*n;
  asr<Float> a(N,N);
  
  for (unsigned int i = 0; i < N; i++) 
    a.entry(i,i) = 6;
  
  unsigned int n2 = n*n;
  for (unsigned int i = 0; i < N-n2; i++)
    a.entry(i,i+n2) = a.entry(i+n2, i) = -1;
  
  for (unsigned int i = 0; i < n; i++) {
    unsigned int j0 = i*n2;
    for (unsigned int j=j0; j < j0+n2-n; j++)
      a.entry(j, j+n) = a.entry(j+n, j) = -1; 
  }
  for (unsigned int i = 0; i < n; i++) {
    for (unsigned int j = 0; j < n; j++) {
      unsigned int k0 = i*n2 + j*n;
      for (unsigned int k = k0; k < k0+n-1; k++)
        a.entry(k, k+1) = a.entry(k+1, k) = -1; 
    }
  }
  return csr<Float>(a);
}
#ifndef USE_NOT_MAIN
int main(int argc, char *argv[])
{
  if (argc < 2 || atoi(argv[1]) < 1)
    cerr << argv[0] << ": usage: " 
	 << argv[0] << " <bloc size>" << endl;
  else
    cout << makefish3d (atoi(argv[1]));
  return 0;
}
#endif // USE_NOT_MAIN
//>makefish3d:
