#ifndef _RHEOLEF_OPERATORS2_H
#define _RHEOLEF_OPERATORS2_H
//
// This file is part of Rheolef.
//
// Copyright (C) 2000-2009 Pierre Saramito 
//
// Rheolef is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// Rheolef is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Rheolef; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// ==========================================================================
// 
// operators2: differential operators as grad()
//	in nonlinear or vf expressions
//
// author: Pierre.Saramito@imag.fr
//
// date: 2 april 2013
//
#include "rheolef/field_nonlinear_expr_terminal.h"
#include "rheolef/field_vf_expr.h"
#include "rheolef/field_vf_expr_dg.h"
namespace rheolef {

// ---------------------------------
// normal
// ---------------------------------
template<class T>
inline
field_nonlinear_expr<field_expr_terminal_function<normal_pseudo_function<T> > >
normal_basic()
{
  typedef field_expr_terminal_function<normal_pseudo_function<T> > raw_t;
  typedef field_nonlinear_expr<raw_t> base;
  return field_nonlinear_expr<field_expr_terminal_function<normal_pseudo_function<T> > >
                             (field_expr_terminal_function<normal_pseudo_function<T> > 
                                                          (normal_pseudo_function<T>()));
}
inline
field_nonlinear_expr<field_expr_terminal_function<normal_pseudo_function<Float> > >
normal()
{
  return normal_basic<Float>();
}
// ---------------------------------
// h_local
// ---------------------------------
template<class T>
inline
field_nonlinear_expr<field_expr_terminal_function<h_local_pseudo_function<T> > >
h_local_basic()
{
  typedef field_expr_terminal_function<h_local_pseudo_function<T> > raw_t;
  typedef field_nonlinear_expr<raw_t> base;
  return field_nonlinear_expr<field_expr_terminal_function<h_local_pseudo_function<T> > >
                             (field_expr_terminal_function<h_local_pseudo_function<T> > 
                                                          (h_local_pseudo_function<T>()));
}
inline
field_nonlinear_expr<field_expr_terminal_function<h_local_pseudo_function<Float> > >
h_local()
{
  return h_local_basic<Float>();
}
// ---------------------------------
// penalty
// ---------------------------------
template<class T>
inline
field_nonlinear_expr<field_expr_terminal_function<penalty_pseudo_function<T> > >
penalty_basic()
{
  typedef field_expr_terminal_function<penalty_pseudo_function<T> > raw_t;
  typedef field_nonlinear_expr<raw_t> base;
  return field_nonlinear_expr<field_expr_terminal_function<penalty_pseudo_function<T> > >
                             (field_expr_terminal_function<penalty_pseudo_function<T> > 
                                                          (penalty_pseudo_function<T>()));
}
inline
field_nonlinear_expr<field_expr_terminal_function<penalty_pseudo_function<Float> > >
penalty()
{
  return penalty_basic<Float>();
}
// ---------------------------------
// compose for characteristic
// ---------------------------------
template<class T, class M>
field_nonlinear_expr<field_expr_terminal_field_o_characteristic<T,M> >
compose (const field_basic<T,M>& uh, const characteristic_basic<T,M>& X)
{
  typedef field_expr_terminal_field_o_characteristic<T,M> wrap_t;
  return field_nonlinear_expr<wrap_t>(wrap_t(uh,X));
}
// ---------------------------------
// grad(expr)
// ---------------------------------
// grad(v)
template<class T, class M, class VfTag>
inline
field_vf_expr<
  field_vf_expr_grad<
   test_basic<T,M,VfTag>
  >
>
grad (const test_basic<T,M,VfTag>& x)
{
  typedef test_basic<T,M,VfTag>      arg_t;
  typedef field_vf_expr_grad<arg_t>  expr_t;
  return field_vf_expr<expr_t>(expr_t(x));
}
// grad(uh)
template<class T, class M>
inline
field_nonlinear_expr<
  field_expr_terminal_field_grad<T,M>
>
grad (const field_basic<T,M>& x)
{
  typedef field_expr_terminal_field_grad<T,M> expr_t;
  return field_nonlinear_expr<expr_t>(expr_t(x));
}
// ---------------------------------
// D(expr) 
// ---------------------------------
// D(v) 
template<class T, class M, class VfTag>
inline
field_vf_expr<
  field_vf_expr_grad<
   test_basic<T,M,VfTag>
  >
>
D (const test_basic<T,M,VfTag>& x)
{
  typedef test_basic<T,M,VfTag>      arg_t;
  typedef field_vf_expr_grad<arg_t>  expr_t;
  static details::grad_option_type   opt;
  opt.symmetrized = true;
  return field_vf_expr<expr_t>(expr_t(x, opt));
}
// D(uh)
template<class T, class M>
inline
field_nonlinear_expr<
  field_expr_terminal_field_grad<T,M>
>
D (const field_basic<T,M>& x)
{
  typedef field_expr_terminal_field_grad<T,M> expr_t;
  static details::grad_option_type            opt;
  opt.symmetrized = true;
  return field_nonlinear_expr<expr_t>(expr_t(x,opt));
}
// ---------------------------------
// div(expr)
// ---------------------------------
// div(v)
template<class T, class M, class VfTag>
inline
field_vf_expr<
  field_vf_expr_div<
   test_basic<T,M,VfTag>
  >
>
div (const test_basic<T,M,VfTag>& x)
{
  typedef test_basic<T,M,VfTag>      arg_t;
  typedef field_vf_expr_div<arg_t>   expr_t;
  return field_vf_expr<expr_t>(expr_t(x));
}
// div(uh)
template<class T, class M>
inline
field_nonlinear_expr<
  field_expr_terminal_field_div<T,M>
>
div (const field_basic<T,M>& x)
{
  typedef field_expr_terminal_field_div<T,M> expr_t;
  return field_nonlinear_expr<expr_t>(expr_t(x));
}
// ---------------------------------
// curl(expr)
// ---------------------------------
// curl(v)
template<class T, class M, class VfTag>
inline
field_vf_expr<
  field_vf_expr_curl<
   test_basic<T,M,VfTag>
  >
>
curl (const test_basic<T,M,VfTag>& x)
{
  typedef test_basic<T,M,VfTag>      arg_t;
  typedef field_vf_expr_curl<arg_t>   expr_t;
  return field_vf_expr<expr_t>(expr_t(x));
}
// curl(uh)
template<class T, class M>
inline
field_nonlinear_expr<
  field_expr_terminal_field_curl<T,M>
>
curl (const field_basic<T,M>& x)
{
  typedef field_expr_terminal_field_curl<T,M> expr_t;
  return field_nonlinear_expr<expr_t>(expr_t(x));
}
// ---------------------------------
// bcurl(v) = Batchelor curl
// ---------------------------------
template<class T, class M, class VfTag>
inline
field_vf_expr<
  field_vf_expr_curl<
   test_basic<T,M,VfTag>
  >
>
bcurl (const test_basic<T,M,VfTag>& x)
{
  typedef test_basic<T,M,VfTag>       arg_t;
  typedef field_vf_expr_curl<arg_t>   expr_t;
  static details::grad_option_type    opt;
  opt.batchelor_curl = true;
  return field_vf_expr<expr_t>(expr_t(x, opt));
}
// ========================================================
// surfacic variants
// ========================================================
// ---------------------------------
// grad_s(expr) 
// ---------------------------------
// grad_s(v) 
template<class T, class M, class VfTag>
inline
field_vf_expr<
  field_vf_expr_grad<
   test_basic<T,M,VfTag>
  >
>
grad_s (const test_basic<T,M,VfTag>& x)
{
  typedef test_basic<T,M,VfTag>      arg_t;
  typedef field_vf_expr_grad<arg_t>  expr_t;
  static details::grad_option_type   opt;
  opt.surfacic = true;
  return field_vf_expr<expr_t>(expr_t(x, opt));
}
// grad_s(uh)
template<class T, class M>
inline
field_nonlinear_expr<
  field_expr_terminal_field_grad<T,M>
>
grad_s (const field_basic<T,M>& x)
{
  typedef field_expr_terminal_field_grad<T,M> expr_t;
  static details::grad_option_type   opt;
  opt.surfacic = true;
  return field_nonlinear_expr<expr_t>(expr_t(x,opt));
}
// ---------------------------------
// Ds(expr) 
// ---------------------------------
// Ds(v) 
template<class T, class M, class VfTag>
inline
field_vf_expr<
  field_vf_expr_grad<
   test_basic<T,M,VfTag>
  >
>
Ds (const test_basic<T,M,VfTag>& x)
{
  typedef test_basic<T,M,VfTag>      arg_t;
  typedef field_vf_expr_grad<arg_t>  expr_t;
  static details::grad_option_type   opt;
  opt.symmetrized = true;
  opt.surfacic    = true;
  return field_vf_expr<expr_t>(expr_t(x, opt));
}
// Ds(uh)
template<class T, class M>
inline
field_nonlinear_expr<
  field_expr_terminal_field_grad<T,M>
>
Ds (const field_basic<T,M>& x)
{
  typedef field_expr_terminal_field_grad<T,M> expr_t;
  static details::grad_option_type   opt;
  opt.symmetrized = true;
  opt.surfacic    = true;
  return field_nonlinear_expr<expr_t>(expr_t(x,opt));
}
// ---------------------------------
// div_s(expr)
// ---------------------------------
// div_s(v)
template<class T, class M, class VfTag>
inline
field_vf_expr<
  field_vf_expr_div<
   test_basic<T,M,VfTag>
  >
>
div_s (const test_basic<T,M,VfTag>& x)
{
  typedef test_basic<T,M,VfTag>      arg_t;
  typedef field_vf_expr_div<arg_t>   expr_t;
  static details::grad_option_type   opt;
  opt.surfacic    = true;
  return field_vf_expr<expr_t>(expr_t(x, opt));
}
// div_s(uh)
template<class T, class M>
inline
field_nonlinear_expr<
  field_expr_terminal_field_div<T,M>
>
div_s (const field_basic<T,M>& x)
{
  typedef field_expr_terminal_field_div<T,M> expr_t;
  static details::grad_option_type   opt;
  opt.surfacic    = true;
  return field_nonlinear_expr<expr_t>(expr_t(x, opt));
}
// ========================================================
// broken variants
// ========================================================
// ---------------------------------
// grad_h(expr) 
// ---------------------------------
// grad_h(v) 
template<class T, class M, class VfTag>
inline
field_vf_expr<
  field_vf_expr_grad<
   test_basic<T,M,VfTag>
  >
>
grad_h (const test_basic<T,M,VfTag>& x)
{
  typedef test_basic<T,M,VfTag>      arg_t;
  typedef field_vf_expr_grad<arg_t>  expr_t;
  static details::grad_option_type   opt;
  opt.broken = true;
  return field_vf_expr<expr_t>(expr_t(x, opt));
}
// grad_h(uh)
template<class T, class M>
inline
field_nonlinear_expr<
  field_expr_terminal_field_grad<T,M>
>
grad_h (const field_basic<T,M>& x)
{
  typedef field_expr_terminal_field_grad<T,M> expr_t;
  static details::grad_option_type   opt;
  opt.broken = true;
  return field_nonlinear_expr<expr_t>(expr_t(x,opt));
}
// ---------------------------------
// Dh(expr) 
// ---------------------------------
// Dh(v) 
template<class T, class M, class VfTag>
inline
field_vf_expr<
  field_vf_expr_grad<
   test_basic<T,M,VfTag>
  >
>
Dh (const test_basic<T,M,VfTag>& x)
{
  typedef test_basic<T,M,VfTag>      arg_t;
  typedef field_vf_expr_grad<arg_t>  expr_t;
  static details::grad_option_type   opt;
  opt.symmetrized = true;
  opt.broken      = true;
  return field_vf_expr<expr_t>(expr_t(x, opt));
}
// Dh(uh)
template<class T, class M>
inline
field_nonlinear_expr<
  field_expr_terminal_field_grad<T,M>
>
Dh (const field_basic<T,M>& x)
{
  typedef field_expr_terminal_field_grad<T,M> expr_t;
  static details::grad_option_type   opt;
  opt.symmetrized = true;
  opt.broken      = true;
  return field_nonlinear_expr<expr_t>(expr_t(x,opt));
}
// ---------------------------------
// div_h(expr)
// ---------------------------------
// div_h(v)
template<class T, class M, class VfTag>
inline
field_vf_expr<
  field_vf_expr_div<
   test_basic<T,M,VfTag>
  >
>
div_h (const test_basic<T,M,VfTag>& x)
{
  typedef test_basic<T,M,VfTag>      arg_t;
  typedef field_vf_expr_div<arg_t>   expr_t;
  static details::grad_option_type   opt;
  opt.broken      = true;
  return field_vf_expr<expr_t>(expr_t(x,opt));
}
// div_h(uh)
template<class T, class M>
inline
field_nonlinear_expr<
  field_expr_terminal_field_div<T,M>
>
div_h (const field_basic<T,M>& x)
{
  typedef field_expr_terminal_field_div<T,M> expr_t;
  static details::grad_option_type   opt;
  opt.broken      = true;
  return field_nonlinear_expr<expr_t>(expr_t(x,opt));
}
// ========================================================
// DG operators
// ========================================================
// TODO: jump(nl_expr) ?

#define _RHEOLEF_dg_operator(op,c0,c1)			\
/* op(u) */						\
template<class T, class M, class VfTag>			\
inline							\
field_vf_expr<						\
  field_vf_expr_dg<					\
   test_basic<T,M,VfTag>				\
  >							\
>							\
op (const test_basic<T,M,VfTag>& x)			\
{							\
  typedef test_basic<T,M,VfTag>      arg_t;		\
  typedef field_vf_expr_dg<arg_t>    expr_t;		\
  return field_vf_expr<expr_t>(expr_t(x, c0, c1));	\
}							\
/* op(expr) */						\
template<class Expr, class VfTag>			\
inline							\
field_vf_expr<						\
  field_vf_expr_dg<					\
   field_vf_expr<Expr,VfTag>				\
  >							\
>							\
op (const field_vf_expr<Expr,VfTag>& x)			\
{							\
  typedef field_vf_expr<Expr,VfTag>  arg_t;		\
  typedef field_vf_expr_dg<arg_t>    expr_t;		\
  return field_vf_expr<expr_t>(expr_t(x, c0, c1));	\
}							\
/* op(uh) */						\
template<class T, class M>				\
inline							\
field_nonlinear_expr<					\
  field_nonlinear_expr_dg<				\
    field_expr_terminal_field<T,M>			\
  >							\
>							\
op (const field_basic<T,M>& x)				\
{							\
  typedef field_expr_terminal_field<T,M>      raw_expr_t;	\
  typedef field_nonlinear_expr_dg<raw_expr_t> expr_t;	\
  return  field_nonlinear_expr<expr_t>(expr_t(raw_expr_t(x), c0, c1)); \
}							\
/* TODO: op(uh+vh) : BUGGY? */				\
template<class Expr>					\
inline							\
field_nonlinear_expr<					\
  field_nonlinear_expr_dg<				\
    field_expr_terminal_field<				\
      typename Expr::scalar_type			\
     ,typename Expr::memory_type			\
    >							\
  >							\
>							\
op (const field_expr<Expr>& x)				\
{							\
  typedef typename Expr::scalar_type T;			\
  typedef typename Expr::memory_type M;			\
  typedef field_expr_terminal_field<T,M>      raw_expr_t;	\
  typedef field_nonlinear_expr_dg<raw_expr_t> expr_t;	\
  return  field_nonlinear_expr<expr_t>(expr_t(raw_expr_t(x), c0, c1)); \
}							\
/* op(sqr(uh)) */					\
template<class Expr>					\
inline							\
field_nonlinear_expr<					\
  field_nonlinear_expr_dg<				\
    field_nonlinear_expr<Expr>				\
  >							\
>							\
op (const field_nonlinear_expr<Expr>& x)		\
{							\
  typedef field_nonlinear_expr<Expr>     arg_t;		\
  typedef field_nonlinear_expr_dg<arg_t> expr_t;	\
  return  field_nonlinear_expr<expr_t>(expr_t(x, c0, c1)); \
}							\

// TODO: jump(uh+vh), jump(sqrt(uh))

#ifdef TO_CLEAN
#define _RHEOLEF_dg_operator_OLD(op,c0,c1)		\
/* op(uh+vh) */						\
template<class Expr>					\
inline							\
field_nonlinear_expr<					\
  field_expr_terminal_field_dg<				\
    typename Expr::scalar_type				\
   ,typename Expr::memory_type				\
  >							\
>							\
op (const field_expr<Expr>& x)				\
{							\
  typedef typename Expr::scalar_type T;			\
  typedef typename Expr::memory_type M;			\
  typedef field_expr_terminal_field_dg<T,M> expr_t;	\
  return field_nonlinear_expr<expr_t>(expr_t(x, c0, c1)); \
}
#endif // TO_CLEAN

_RHEOLEF_dg_operator(jump,    1,    -1)
_RHEOLEF_dg_operator(average, 0.5,  0.5)
_RHEOLEF_dg_operator(inner,   1,    0)
_RHEOLEF_dg_operator(outer,   0,    1)
#undef _RHEOLEF_dg_operator

} // namespace rheolef
#endif // _RHEOLEF_OPERATORS2_H
