% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.tfisher.R
\name{stat.tfisher}
\alias{stat.tfisher}
\title{Construct thresholding Fisher's p-value combination statistic.}
\usage{
stat.tfisher(p, tau1, tau2)
}
\arguments{
\item{p}{- input p-values.}

\item{tau1}{- truncation parameter. 0 < tau1 <= 1.}

\item{tau2}{- normalization parameter. tau2 >= tau1.}
}
\value{
Thresholding Fisher's p-value combination statistic.
}
\description{
Construct thresholding Fisher's p-value combination statistic.
}
\details{
Let \eqn{p_{i}}, \eqn{i = 1,...,n} be a sequence of p-values, the thresholding Fisher's p-value combination statistic
\deqn{TFisher = \sum_{i=1}^n -2\log(p_i/\tau_2)I(p_i\leq\tau_2)}
}
\examples{
pval <- runif(100)
stat.tfisher(p=pval, tau1=0.05, tau2=0.25)
}
\references{
1. Hong Zhang and Zheyang Wu. "TFisher Tests: Optimal and Adaptive Thresholding for Combining p-Values", submitted.
}
