% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{stri_list2matrix}
\alias{stri_list2matrix}
\title{Convert a List to a Character Matrix}
\usage{
stri_list2matrix(
  x,
  byrow = FALSE,
  fill = NA_character_,
  n_min = 0,
  by_row = byrow
)
}
\arguments{
\item{x}{a list of atomic vectors}

\item{byrow}{a single logical value; should the resulting matrix be
transposed?}

\item{fill}{a single string, see Details}

\item{n_min}{a single integer value; minimal number of rows (\code{byrow==FALSE})
or columns (otherwise) in the resulting matrix}

\item{by_row}{alias of \code{byrow}}
}
\value{
Returns a character matrix.
}
\description{
This function converts a given list of atomic vectors to
a character matrix.
}
\details{
This function is similar to the built-in \code{\link{simplify2array}}
function. However, it always returns a character matrix,
even if each element in \code{x} is of length 1
or if elements in \code{x} are not of the same lengths.
Moreover, the elements in \code{x} are always coerced to character vectors.

If \code{byrow} is \code{FALSE}, then a matrix with \code{length(x)}
columns is returned.
The number of rows is the length of the
longest vector in \code{x}, but no less than \code{n_min}. Basically, we have
\code{result[i,j] == x[[j]][i]} if \code{i <= length(x[[j]])}
and \code{result[i,j] == fill} otherwise, see Examples.

If \code{byrow} is \code{TRUE}, then the resulting matrix is
a transposition of the above-described one.

This function may be useful, e.g., in connection with \code{\link{stri_split}}
and \code{\link{stri_extract_all}}.
}
\examples{
simplify2array(list(c('a', 'b'), c('c', 'd'), c('e', 'f')))
stri_list2matrix(list(c('a', 'b'), c('c', 'd'), c('e', 'f')))
stri_list2matrix(list(c('a', 'b'), c('c', 'd'), c('e', 'f')), byrow=TRUE)

simplify2array(list('a', c('b', 'c')))
stri_list2matrix(list('a', c('b', 'c')))
stri_list2matrix(list('a', c('b', 'c')), fill='')
stri_list2matrix(list('a', c('b', 'c')), fill='', n_min=5)

}
\seealso{
The official online manual of \pkg{stringi} at \url{https://stringi.gagolewski.com/}

Other utils: 
\code{\link{stri_na2empty}()},
\code{\link{stri_remove_empty}()},
\code{\link{stri_replace_na}()}
}
\concept{utils}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski} and other contributors
}
