% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.utilities.R
\name{as.control.list}
\alias{as.control.list}
\alias{as.control.list.control.list}
\alias{as.control.list.list}
\title{Convert to a control list.}
\usage{
as.control.list(x, ...)

\method{as.control.list}{control.list}(x, ...)

\method{as.control.list}{list}(x, FUN = NULL, unflat = TRUE, ...)
}
\arguments{
\item{x}{An object, usually a \code{\link{list}}, to be converted to a
control list.}

\item{...}{Additional arguments to methods.}

\item{FUN}{Either a \verb{control.*()} function or its name or suffix
(to which \code{"control."} will be prepended); defaults to taking the
nearest (in the call traceback) function that does not begin with
\code{"as.control.list"}, and prepending \code{"control."} to it. (This is
typically the function that called \code{as.control.list()} in the
first place.)}

\item{unflat}{Logical, indicating whether an attempt should be made
to detect whether some of the arguments are appropriate for a
lower-level control function and pass them down.}
}
\value{
a \code{control.list} object.
}
\description{
Convert to a control list.
}
\section{Methods (by class)}{
\itemize{
\item \code{control.list}: Idempotent method for control lists.

\item \code{list}: The method for plain lists, which runs
them through \code{FUN}.
}}

\examples{
myfun <- function(..., control=control.myfun()){
  as.control.list(control)
}
control.myfun <- function(a=1, b=a+1){
  list(a=a,b=b)
}

myfun()
myfun(control = list(a=2))
myfun2 <- function(..., control=control.myfun2()){
  as.control.list(control)
}
control.myfun2 <- function(c=3, d=c+2, myfun=control.myfun()){
  list(c=c,d=d,myfun=myfun)
}

myfun2()
# Argument to control.myfun() (i.e., a) gets passed to it, and a
# warning is issued for unused argument e.
myfun2(control = list(c=3, a=2, e=3))
}
