% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assay5.R
\name{VariableFeatures-StdAssay}
\alias{VariableFeatures-StdAssay}
\alias{HVFInfo.StdAssay}
\alias{VariableFeatures.StdAssay}
\alias{VariableFeatures<-.StdAssay}
\title{Highly Variable Features}
\usage{
\method{HVFInfo}{StdAssay}(object, method = NULL, status = FALSE, layer = NULL, strip = TRUE, ...)

\method{VariableFeatures}{StdAssay}(
  object,
  method = NULL,
  layer = NA,
  simplify = TRUE,
  nfeatures = Inf,
  selection.method = deprecated(),
  ...
)

\method{VariableFeatures}{StdAssay}(object, method = "custom", layer = NULL, ...) <- value
}
\arguments{
\item{object}{An object}

\item{method}{Which method to pull. For \code{HVFInfo} and
\code{VariableFeatures}, choose one from one of the
following:
\itemize{
 \item \dQuote{vst}
 \item \dQuote{sctransform} or \dQuote{sct}
 \item \dQuote{mean.var.plot}, \dQuote{dispersion}, \dQuote{mvp}, or
  \dQuote{disp}
}
For \code{SVFInfo} and \code{SpatiallyVariableFeatures}, choose from:
\itemize{
 \item \dQuote{markvariogram}
 \item \dQuote{moransi}
}}

\item{status}{Add variable status to the resulting data frame}

\item{layer}{Layer to pull variable features for}

\item{strip}{Remove method/layer identifiers from highly variable data frame}

\item{...}{Arguments passed to other methods}

\item{simplify}{When pulling for multiple layers, combine into a single
vector and select a common set of variable features for all layers}

\item{nfeatures}{Maximum number of features to select when simplifying}

\item{selection.method}{\Sexpr[stage=build,results=rd]{lifecycle::badge("deprecated")}}

\item{value}{A character vector of variable features}
}
\value{
\code{HVFInfo}: A data frame with feature means, dispersion, and
scaled dispersion

\code{VariableFeatures}: a vector of the variable features

\code{SVFInfo}: a data frame with the spatially variable features

\code{SpatiallyVariableFeatures}: a character vector of the spatially
variable features
}
\description{
Get and set variable feature information for an \code{\link{Assay}} object.
\code{HVFInfo} and \code{VariableFeatures} utilize generally variable
features, while \code{SVFInfo} and \code{SpatiallyVariableFeatures} are
restricted to spatially variable features
}
\keyword{internal}
